// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PLUGINMANAGERATTRIBUTES_H
#define PLUGINMANAGERATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: PluginManagerAttributes
//
// Purpose:
//    This class contains attributes for managing plugins.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API PluginManagerAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    PluginManagerAttributes();
    PluginManagerAttributes(const PluginManagerAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    PluginManagerAttributes(private_tmfs_t tmfs);
    PluginManagerAttributes(const PluginManagerAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~PluginManagerAttributes();

    virtual PluginManagerAttributes& operator = (const PluginManagerAttributes &obj);
    virtual bool operator == (const PluginManagerAttributes &obj) const;
    virtual bool operator != (const PluginManagerAttributes &obj) const;
private:
    void Init();
    void Copy(const PluginManagerAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectName();
    void SelectType();
    void SelectVersion();
    void SelectId();
    void SelectCategory();
    void SelectEnabled();

    // Property setting methods
    void SetName(const stringVector &name_);
    void SetType(const stringVector &type_);
    void SetVersion(const stringVector &version_);
    void SetId(const stringVector &id_);
    void SetCategory(const stringVector &category_);
    void SetEnabled(const intVector &enabled_);

    // Property getting methods
    const stringVector &GetName() const;
          stringVector &GetName();
    const stringVector &GetType() const;
          stringVector &GetType();
    const stringVector &GetVersion() const;
          stringVector &GetVersion();
    const stringVector &GetId() const;
          stringVector &GetId();
    const stringVector &GetCategory() const;
          stringVector &GetCategory();
    const intVector    &GetEnabled() const;
          intVector    &GetEnabled();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    int GetIndexByID(const std::string &s) const;
    void AddPlugin(const std::string &n,const std::string &t,const std::string &v,const std::string &i,bool e);
    void RemovePlugin(const std::string &s);
    void UniqueCategories(const std::string &t, stringVector &c) const;
    std::string GetPluginCategoryName(const std::string &s) const;
    void SetPluginCategoryName(const std::string &s, const std::string &c);
    bool PluginCategoryNameNotSet(const std::string &s) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_name = 0,
        ID_type,
        ID_version,
        ID_id,
        ID_category,
        ID_enabled,
        ID__LAST
    };

private:
    stringVector name;
    stringVector type;
    stringVector version;
    stringVector id;
    stringVector category;
    intVector    enabled;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PLUGINMANAGERATTRIBUTES_TMFS "s*s*s*s*s*i*"

#endif
