// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef MESHMANAGEMENTATTRIBUTES_H
#define MESHMANAGEMENTATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: MeshManagementAttributes
//
// Purpose:
//    Global variables controlling reading and conversion of non-standard meshes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API MeshManagementAttributes : public AttributeSubject
{
public:
    enum DiscretizationModes
    {
        Uniform,
        Adaptive,
        MultiPass
    };

    // These constructors are for objects of this class
    MeshManagementAttributes();
    MeshManagementAttributes(const MeshManagementAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    MeshManagementAttributes(private_tmfs_t tmfs);
    MeshManagementAttributes(const MeshManagementAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~MeshManagementAttributes();

    virtual MeshManagementAttributes& operator = (const MeshManagementAttributes &obj);
    virtual bool operator == (const MeshManagementAttributes &obj) const;
    virtual bool operator != (const MeshManagementAttributes &obj) const;
private:
    void Init();
    void Copy(const MeshManagementAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectDiscretizationTolerance();
    void SelectDiscretizationToleranceX();
    void SelectDiscretizationToleranceY();
    void SelectDiscretizationToleranceZ();

    // Property setting methods
    void SetDiscretizationTolerance(const doubleVector &discretizationTolerance_);
    void SetDiscretizationToleranceX(const doubleVector &discretizationToleranceX_);
    void SetDiscretizationToleranceY(const doubleVector &discretizationToleranceY_);
    void SetDiscretizationToleranceZ(const doubleVector &discretizationToleranceZ_);
    void SetDiscretizationMode(DiscretizationModes discretizationMode_);
    void SetDiscretizeBoundaryOnly(bool discretizeBoundaryOnly_);
    void SetPassNativeCSG(bool passNativeCSG_);

    // Property getting methods
    const doubleVector &GetDiscretizationTolerance() const;
          doubleVector &GetDiscretizationTolerance();
    const doubleVector &GetDiscretizationToleranceX() const;
          doubleVector &GetDiscretizationToleranceX();
    const doubleVector &GetDiscretizationToleranceY() const;
          doubleVector &GetDiscretizationToleranceY();
    const doubleVector &GetDiscretizationToleranceZ() const;
          doubleVector &GetDiscretizationToleranceZ();
    DiscretizationModes GetDiscretizationMode() const;
    bool               GetDiscretizeBoundaryOnly() const;
    bool               GetPassNativeCSG() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string DiscretizationModes_ToString(DiscretizationModes);
    static bool DiscretizationModes_FromString(const std::string &, DiscretizationModes &);
protected:
    static std::string DiscretizationModes_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_discretizationTolerance = 0,
        ID_discretizationToleranceX,
        ID_discretizationToleranceY,
        ID_discretizationToleranceZ,
        ID_discretizationMode,
        ID_discretizeBoundaryOnly,
        ID_passNativeCSG,
        ID__LAST
    };

private:
    doubleVector discretizationTolerance;
    doubleVector discretizationToleranceX;
    doubleVector discretizationToleranceY;
    doubleVector discretizationToleranceZ;
    int          discretizationMode;
    bool         discretizeBoundaryOnly;
    bool         passNativeCSG;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define MESHMANAGEMENTATTRIBUTES_TMFS "d*d*d*d*ibb"

#endif
