// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef MATERIALATTRIBUTES_H
#define MATERIALATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: MaterialAttributes
//
// Purpose:
//    Attributes to control material interface reconstruction
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API MaterialAttributes : public AttributeSubject
{
public:
    enum Algorithm
    {
        EquiT,
        EquiZ,
        Isovolume,
        PLIC,
        Discrete
    };

    // These constructors are for objects of this class
    MaterialAttributes();
    MaterialAttributes(const MaterialAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    MaterialAttributes(private_tmfs_t tmfs);
    MaterialAttributes(const MaterialAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~MaterialAttributes();

    virtual MaterialAttributes& operator = (const MaterialAttributes &obj);
    virtual bool operator == (const MaterialAttributes &obj) const;
    virtual bool operator != (const MaterialAttributes &obj) const;
private:
    void Init();
    void Copy(const MaterialAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetSmoothing(bool smoothing_);
    void SetForceMIR(bool forceMIR_);
    void SetCleanZonesOnly(bool cleanZonesOnly_);
    void SetNeedValidConnectivity(bool needValidConnectivity_);
    void SetAlgorithm(Algorithm algorithm_);
    void SetIterationEnabled(bool iterationEnabled_);
    void SetNumIterations(int numIterations_);
    void SetIterationDamping(float iterationDamping_);
    void SetSimplifyHeavilyMixedZones(bool simplifyHeavilyMixedZones_);
    void SetMaxMaterialsPerZone(int maxMaterialsPerZone_);
    void SetIsoVolumeFraction(float isoVolumeFraction_);
    void SetAnnealingTime(int annealingTime_);

    // Property getting methods
    bool  GetSmoothing() const;
    bool  GetForceMIR() const;
    bool  GetCleanZonesOnly() const;
    bool  GetNeedValidConnectivity() const;
    Algorithm GetAlgorithm() const;
    bool  GetIterationEnabled() const;
    int   GetNumIterations() const;
    float GetIterationDamping() const;
    bool  GetSimplifyHeavilyMixedZones() const;
    int   GetMaxMaterialsPerZone() const;
    float GetIsoVolumeFraction() const;
    int   GetAnnealingTime() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Algorithm_ToString(Algorithm);
    static bool Algorithm_FromString(const std::string &, Algorithm &);
protected:
    static std::string Algorithm_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_smoothing = 0,
        ID_forceMIR,
        ID_cleanZonesOnly,
        ID_needValidConnectivity,
        ID_algorithm,
        ID_iterationEnabled,
        ID_numIterations,
        ID_iterationDamping,
        ID_simplifyHeavilyMixedZones,
        ID_maxMaterialsPerZone,
        ID_isoVolumeFraction,
        ID_annealingTime,
        ID__LAST
    };

private:
    bool  smoothing;
    bool  forceMIR;
    bool  cleanZonesOnly;
    bool  needValidConnectivity;
    int   algorithm;
    bool  iterationEnabled;
    int   numIterations;
    float iterationDamping;
    bool  simplifyHeavilyMixedZones;
    int   maxMaterialsPerZone;
    float isoVolumeFraction;
    int   annealingTime;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define MATERIALATTRIBUTES_TMFS "bbbbibifbifi"

#endif
