// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef INTERACTORATTRIBUTES_H
#define INTERACTORATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: InteractorAttributes
//
// Purpose:
//    This class contains attributes associated with the main window.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API InteractorAttributes : public AttributeSubject
{
public:
    enum NavigationMode
    {
        Trackball,
        Dolly,
        Flythrough
    };
    enum BoundingBoxMode
    {
        Always,
        Never,
        Auto
    };

    // These constructors are for objects of this class
    InteractorAttributes();
    InteractorAttributes(const InteractorAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    InteractorAttributes(private_tmfs_t tmfs);
    InteractorAttributes(const InteractorAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~InteractorAttributes();

    virtual InteractorAttributes& operator = (const InteractorAttributes &obj);
    virtual bool operator == (const InteractorAttributes &obj) const;
    virtual bool operator != (const InteractorAttributes &obj) const;
private:
    void Init();
    void Copy(const InteractorAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetShowGuidelines(bool showGuidelines_);
    void SetClampSquare(bool clampSquare_);
    void SetFillViewportOnZoom(bool fillViewportOnZoom_);
    void SetNavigationMode(NavigationMode navigationMode_);
    void SetAxisArraySnap(bool axisArraySnap_);
    void SetBoundingBoxMode(BoundingBoxMode boundingBoxMode_);

    // Property getting methods
    bool GetShowGuidelines() const;
    bool GetClampSquare() const;
    bool GetFillViewportOnZoom() const;
    NavigationMode GetNavigationMode() const;
    bool GetAxisArraySnap() const;
    BoundingBoxMode GetBoundingBoxMode() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string NavigationMode_ToString(NavigationMode);
    static bool NavigationMode_FromString(const std::string &, NavigationMode &);
protected:
    static std::string NavigationMode_ToString(int);
public:
    static std::string BoundingBoxMode_ToString(BoundingBoxMode);
    static bool BoundingBoxMode_FromString(const std::string &, BoundingBoxMode &);
protected:
    static std::string BoundingBoxMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_showGuidelines = 0,
        ID_clampSquare,
        ID_fillViewportOnZoom,
        ID_navigationMode,
        ID_axisArraySnap,
        ID_boundingBoxMode,
        ID__LAST
    };

private:
    bool showGuidelines;
    bool clampSquare;
    bool fillViewportOnZoom;
    int  navigationMode;
    bool axisArraySnap;
    int  boundingBoxMode;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define INTERACTORATTRIBUTES_TMFS "bbbibi"

#endif
