// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef GAUSSIANCONTROLPOINTLIST_H
#define GAUSSIANCONTROLPOINTLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class GaussianControlPoint;

// ****************************************************************************
// Class: GaussianControlPointList
//
// Purpose:
//    This class contains a list of GaussianControlPoint objects.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API GaussianControlPointList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    GaussianControlPointList();
    GaussianControlPointList(const GaussianControlPointList &obj);
protected:
    // These constructors are for objects derived from this class
    GaussianControlPointList(private_tmfs_t tmfs);
    GaussianControlPointList(const GaussianControlPointList &obj, private_tmfs_t tmfs);
public:
    virtual ~GaussianControlPointList();

    virtual GaussianControlPointList& operator = (const GaussianControlPointList &obj);
    virtual bool operator == (const GaussianControlPointList &obj) const;
    virtual bool operator != (const GaussianControlPointList &obj) const;
private:
    void Init();
    void Copy(const GaussianControlPointList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectControlPoints();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetControlPoints() const;
          AttributeGroupVector &GetControlPoints();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddControlPoints(const GaussianControlPoint &);
    void ClearControlPoints();
    void RemoveControlPoints(int i);
    int  GetNumControlPoints() const;
    GaussianControlPoint &GetControlPoints(int i);
    const GaussianControlPoint &GetControlPoints(int i) const;

    GaussianControlPoint &operator [] (int i);
    const GaussianControlPoint &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_controlPoints = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector controlPoints;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define GAUSSIANCONTROLPOINTLIST_TMFS "a*"

#endif
