// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ENGINEPROPERTIES_H
#define ENGINEPROPERTIES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: EngineProperties
//
// Purpose:
//    This class contains properties about running engines.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API EngineProperties : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    EngineProperties();
    EngineProperties(const EngineProperties &obj);
protected:
    // These constructors are for objects derived from this class
    EngineProperties(private_tmfs_t tmfs);
    EngineProperties(const EngineProperties &obj, private_tmfs_t tmfs);
public:
    virtual ~EngineProperties();

    virtual EngineProperties& operator = (const EngineProperties &obj);
    virtual bool operator == (const EngineProperties &obj) const;
    virtual bool operator != (const EngineProperties &obj) const;
private:
    void Init();
    void Copy(const EngineProperties &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectLoadBalancingScheme();

    // Property setting methods
    void SetNumNodes(int numNodes_);
    void SetNumProcessors(int numProcessors_);
    void SetNumProcessorsUsingGPUs(int numProcessorsUsingGPUs_);
    void SetDynamicLoadBalancing(bool dynamicLoadBalancing_);
    void SetLoadBalancingScheme(const std::string &loadBalancingScheme_);

    // Property getting methods
    int               GetNumNodes() const;
    int               GetNumProcessors() const;
    int               GetNumProcessorsUsingGPUs() const;
    bool              GetDynamicLoadBalancing() const;
    const std::string &GetLoadBalancingScheme() const;
          std::string &GetLoadBalancingScheme();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_numNodes = 0,
        ID_numProcessors,
        ID_numProcessorsUsingGPUs,
        ID_dynamicLoadBalancing,
        ID_loadBalancingScheme,
        ID__LAST
    };

private:
    int         numNodes;
    int         numProcessors;
    int         numProcessorsUsingGPUs;
    bool        dynamicLoadBalancing;
    std::string loadBalancingScheme;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ENGINEPROPERTIES_TMFS "iiibs"

#endif
