// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef DATABASECORRELATIONLIST_H
#define DATABASECORRELATIONLIST_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

class DatabaseCorrelation;
#include <visitstream.h>

// ****************************************************************************
// Class: DatabaseCorrelationList
//
// Purpose:
//    This class contains the database correlations that we know about.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API DatabaseCorrelationList : public AttributeSubject
{
public:
    enum WhenToCorrelate
    {
        CorrelateAlways,
        CorrelateNever,
        CorrelateOnlyIfSameLength
    };

    // These constructors are for objects of this class
    DatabaseCorrelationList();
    DatabaseCorrelationList(const DatabaseCorrelationList &obj);
protected:
    // These constructors are for objects derived from this class
    DatabaseCorrelationList(private_tmfs_t tmfs);
    DatabaseCorrelationList(const DatabaseCorrelationList &obj, private_tmfs_t tmfs);
public:
    virtual ~DatabaseCorrelationList();

    virtual DatabaseCorrelationList& operator = (const DatabaseCorrelationList &obj);
    virtual bool operator == (const DatabaseCorrelationList &obj) const;
    virtual bool operator != (const DatabaseCorrelationList &obj) const;
private:
    void Init();
    void Copy(const DatabaseCorrelationList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCorrelations();

    // Property setting methods
    void SetNeedPermission(bool needPermission_);
    void SetDefaultCorrelationMethod(int defaultCorrelationMethod_);
    void SetWhenToCorrelate(WhenToCorrelate whenToCorrelate_);

    // Property getting methods
    const AttributeGroupVector &GetCorrelations() const;
          AttributeGroupVector &GetCorrelations();
    bool GetNeedPermission() const;
    int  GetDefaultCorrelationMethod() const;
    WhenToCorrelate GetWhenToCorrelate() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddCorrelations(const DatabaseCorrelation &);
    void ClearCorrelations();
    void RemoveCorrelations(int i);
    int  GetNumCorrelations() const;
    DatabaseCorrelation &GetCorrelations(int i);
    const DatabaseCorrelation &GetCorrelations(int i) const;

    DatabaseCorrelation &operator [] (int i);
    const DatabaseCorrelation &operator [] (int i) const;

    // Enum conversion functions
    static std::string WhenToCorrelate_ToString(WhenToCorrelate);
    static bool WhenToCorrelate_FromString(const std::string &, WhenToCorrelate &);
protected:
    static std::string WhenToCorrelate_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    DatabaseCorrelation *FindCorrelation(const std::string &name) const;
    bool RemoveCorrelation(const std::string &name);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_correlations = 0,
        ID_needPermission,
        ID_defaultCorrelationMethod,
        ID_whenToCorrelate,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector correlations;
    bool                 needPermission;
    int                  defaultCorrelationMethod;
    int                  whenToCorrelate;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define DATABASECORRELATIONLIST_TMFS "a*bii"

// User-defined functions
ostream &operator <<(ostream &, const DatabaseCorrelationList &cL);
#endif
