// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef CLIENTINFORMATIONLIST_H
#define CLIENTINFORMATIONLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>

class ClientInformation;

// ****************************************************************************
// Class: ClientInformationList
//
// Purpose:
//    Contains the information for all connected clients.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ClientInformationList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ClientInformationList();
    ClientInformationList(const ClientInformationList &obj);
protected:
    // These constructors are for objects derived from this class
    ClientInformationList(private_tmfs_t tmfs);
    ClientInformationList(const ClientInformationList &obj, private_tmfs_t tmfs);
public:
    virtual ~ClientInformationList();

    virtual ClientInformationList& operator = (const ClientInformationList &obj);
    virtual bool operator == (const ClientInformationList &obj) const;
    virtual bool operator != (const ClientInformationList &obj) const;
private:
    void Init();
    void Copy(const ClientInformationList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectClients();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetClients() const;
          AttributeGroupVector &GetClients();


    // Attributegroup convenience methods
    void AddClients(const ClientInformation &);
    void ClearClients();
    void RemoveClients(int i);
    int  GetNumClients() const;
    ClientInformation &GetClients(int i);
    const ClientInformation &GetClients(int i) const;

    ClientInformation &operator [] (int i);
    const ClientInformation &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_clients = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector clients;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define CLIENTINFORMATIONLIST_TMFS "a*"

#endif
