// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <CinemaAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Init utility for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void CinemaAttributes::Init()
{
    specification = "A";
    fileName = "visit.cdb";
    cameraMode = "phi-theta";
    theta = 7;
    phi = 12;
    roll = 1;
    format = "png";
    composite = false;
    useScreenCapture = false;
    width = 600;
    height = 600;
    frameStart = 0;
    frameEnd = -1;
    frameStride = 1;

    CinemaAttributes::SelectAll();
}

// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Copy utility for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void CinemaAttributes::Copy(const CinemaAttributes &obj)
{
    specification = obj.specification;
    fileName = obj.fileName;
    cameraMode = obj.cameraMode;
    theta = obj.theta;
    phi = obj.phi;
    roll = obj.roll;
    format = obj.format;
    composite = obj.composite;
    useScreenCapture = obj.useScreenCapture;
    width = obj.width;
    height = obj.height;
    frameStart = obj.frameStart;
    frameEnd = obj.frameEnd;
    frameStride = obj.frameStride;

    CinemaAttributes::SelectAll();
}

// Type map format string
const char *CinemaAttributes::TypeMapFormatString = CINEMAATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t CinemaAttributes::TmfsStruct = {CINEMAATTRIBUTES_TMFS};


// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Default constructor for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes::CinemaAttributes() :
    AttributeSubject(CinemaAttributes::TypeMapFormatString)
{
    CinemaAttributes::Init();
}

// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Constructor for the derived classes of CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes::CinemaAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    CinemaAttributes::Init();
}

// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Copy constructor for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes::CinemaAttributes(const CinemaAttributes &obj) :
    AttributeSubject(CinemaAttributes::TypeMapFormatString)
{
    CinemaAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CinemaAttributes::CinemaAttributes
//
// Purpose:
//   Copy constructor for derived classes of the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes::CinemaAttributes(const CinemaAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    CinemaAttributes::Copy(obj);
}

// ****************************************************************************
// Method: CinemaAttributes::~CinemaAttributes
//
// Purpose:
//   Destructor for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes::~CinemaAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: CinemaAttributes::operator =
//
// Purpose:
//   Assignment operator for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

CinemaAttributes&
CinemaAttributes::operator = (const CinemaAttributes &obj)
{
    if (this == &obj) return *this;

    CinemaAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: CinemaAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CinemaAttributes::operator == (const CinemaAttributes &obj) const
{
    // Create the return value
    return ((specification == obj.specification) &&
            (fileName == obj.fileName) &&
            (cameraMode == obj.cameraMode) &&
            (theta == obj.theta) &&
            (phi == obj.phi) &&
            (roll == obj.roll) &&
            (format == obj.format) &&
            (composite == obj.composite) &&
            (useScreenCapture == obj.useScreenCapture) &&
            (width == obj.width) &&
            (height == obj.height) &&
            (frameStart == obj.frameStart) &&
            (frameEnd == obj.frameEnd) &&
            (frameStride == obj.frameStride));
}

// ****************************************************************************
// Method: CinemaAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CinemaAttributes::operator != (const CinemaAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: CinemaAttributes::TypeName
//
// Purpose:
//   Type name method for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
CinemaAttributes::TypeName() const
{
    return "CinemaAttributes";
}

// ****************************************************************************
// Method: CinemaAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CinemaAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const CinemaAttributes *tmp = (const CinemaAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: CinemaAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
CinemaAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new CinemaAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: CinemaAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the CinemaAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
CinemaAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new CinemaAttributes(*this);
    else
        retval = new CinemaAttributes;

    return retval;
}

// ****************************************************************************
// Method: CinemaAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CinemaAttributes::SelectAll()
{
    Select(ID_specification,    (void *)&specification);
    Select(ID_fileName,         (void *)&fileName);
    Select(ID_cameraMode,       (void *)&cameraMode);
    Select(ID_theta,            (void *)&theta);
    Select(ID_phi,              (void *)&phi);
    Select(ID_roll,             (void *)&roll);
    Select(ID_format,           (void *)&format);
    Select(ID_composite,        (void *)&composite);
    Select(ID_useScreenCapture, (void *)&useScreenCapture);
    Select(ID_width,            (void *)&width);
    Select(ID_height,           (void *)&height);
    Select(ID_frameStart,       (void *)&frameStart);
    Select(ID_frameEnd,         (void *)&frameEnd);
    Select(ID_frameStride,      (void *)&frameStride);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: CinemaAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
CinemaAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    CinemaAttributes defaultObject;
    bool addToParent = false;
    // Create a node for CinemaAttributes.
    DataNode *node = new DataNode("CinemaAttributes");

    if(completeSave || !FieldsEqual(ID_specification, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("specification", specification));
    }

    if(completeSave || !FieldsEqual(ID_fileName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fileName", fileName));
    }

    if(completeSave || !FieldsEqual(ID_cameraMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cameraMode", cameraMode));
    }

    if(completeSave || !FieldsEqual(ID_theta, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("theta", theta));
    }

    if(completeSave || !FieldsEqual(ID_phi, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("phi", phi));
    }

    if(completeSave || !FieldsEqual(ID_roll, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("roll", roll));
    }

    if(completeSave || !FieldsEqual(ID_format, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("format", format));
    }

    if(completeSave || !FieldsEqual(ID_composite, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("composite", composite));
    }

    if(completeSave || !FieldsEqual(ID_useScreenCapture, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useScreenCapture", useScreenCapture));
    }

    if(completeSave || !FieldsEqual(ID_width, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("width", width));
    }

    if(completeSave || !FieldsEqual(ID_height, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("height", height));
    }

    if(completeSave || !FieldsEqual(ID_frameStart, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("frameStart", frameStart));
    }

    if(completeSave || !FieldsEqual(ID_frameEnd, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("frameEnd", frameEnd));
    }

    if(completeSave || !FieldsEqual(ID_frameStride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("frameStride", frameStride));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: CinemaAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
CinemaAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("CinemaAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("specification")) != 0)
        SetSpecification(node->AsString());
    if((node = searchNode->GetNode("fileName")) != 0)
        SetFileName(node->AsString());
    if((node = searchNode->GetNode("cameraMode")) != 0)
        SetCameraMode(node->AsString());
    if((node = searchNode->GetNode("theta")) != 0)
        SetTheta(node->AsInt());
    if((node = searchNode->GetNode("phi")) != 0)
        SetPhi(node->AsInt());
    if((node = searchNode->GetNode("roll")) != 0)
        SetRoll(node->AsInt());
    if((node = searchNode->GetNode("format")) != 0)
        SetFormat(node->AsString());
    if((node = searchNode->GetNode("composite")) != 0)
        SetComposite(node->AsBool());
    if((node = searchNode->GetNode("useScreenCapture")) != 0)
        SetUseScreenCapture(node->AsBool());
    if((node = searchNode->GetNode("width")) != 0)
        SetWidth(node->AsInt());
    if((node = searchNode->GetNode("height")) != 0)
        SetHeight(node->AsInt());
    if((node = searchNode->GetNode("frameStart")) != 0)
        SetFrameStart(node->AsInt());
    if((node = searchNode->GetNode("frameEnd")) != 0)
        SetFrameEnd(node->AsInt());
    if((node = searchNode->GetNode("frameStride")) != 0)
        SetFrameStride(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
CinemaAttributes::SetSpecification(const std::string &specification_)
{
    specification = specification_;
    Select(ID_specification, (void *)&specification);
}

void
CinemaAttributes::SetFileName(const std::string &fileName_)
{
    fileName = fileName_;
    Select(ID_fileName, (void *)&fileName);
}

void
CinemaAttributes::SetCameraMode(const std::string &cameraMode_)
{
    cameraMode = cameraMode_;
    Select(ID_cameraMode, (void *)&cameraMode);
}

void
CinemaAttributes::SetTheta(int theta_)
{
    theta = theta_;
    Select(ID_theta, (void *)&theta);
}

void
CinemaAttributes::SetPhi(int phi_)
{
    phi = phi_;
    Select(ID_phi, (void *)&phi);
}

void
CinemaAttributes::SetRoll(int roll_)
{
    roll = roll_;
    Select(ID_roll, (void *)&roll);
}

void
CinemaAttributes::SetFormat(const std::string &format_)
{
    format = format_;
    Select(ID_format, (void *)&format);
}

void
CinemaAttributes::SetComposite(bool composite_)
{
    composite = composite_;
    Select(ID_composite, (void *)&composite);
}

void
CinemaAttributes::SetUseScreenCapture(bool useScreenCapture_)
{
    useScreenCapture = useScreenCapture_;
    Select(ID_useScreenCapture, (void *)&useScreenCapture);
}

void
CinemaAttributes::SetWidth(int width_)
{
    width = width_;
    Select(ID_width, (void *)&width);
}

void
CinemaAttributes::SetHeight(int height_)
{
    height = height_;
    Select(ID_height, (void *)&height);
}

void
CinemaAttributes::SetFrameStart(int frameStart_)
{
    frameStart = frameStart_;
    Select(ID_frameStart, (void *)&frameStart);
}

void
CinemaAttributes::SetFrameEnd(int frameEnd_)
{
    frameEnd = frameEnd_;
    Select(ID_frameEnd, (void *)&frameEnd);
}

void
CinemaAttributes::SetFrameStride(int frameStride_)
{
    frameStride = frameStride_;
    Select(ID_frameStride, (void *)&frameStride);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
CinemaAttributes::GetSpecification() const
{
    return specification;
}

std::string &
CinemaAttributes::GetSpecification()
{
    return specification;
}

const std::string &
CinemaAttributes::GetFileName() const
{
    return fileName;
}

std::string &
CinemaAttributes::GetFileName()
{
    return fileName;
}

const std::string &
CinemaAttributes::GetCameraMode() const
{
    return cameraMode;
}

std::string &
CinemaAttributes::GetCameraMode()
{
    return cameraMode;
}

int
CinemaAttributes::GetTheta() const
{
    return theta;
}

int
CinemaAttributes::GetPhi() const
{
    return phi;
}

int
CinemaAttributes::GetRoll() const
{
    return roll;
}

const std::string &
CinemaAttributes::GetFormat() const
{
    return format;
}

std::string &
CinemaAttributes::GetFormat()
{
    return format;
}

bool
CinemaAttributes::GetComposite() const
{
    return composite;
}

bool
CinemaAttributes::GetUseScreenCapture() const
{
    return useScreenCapture;
}

int
CinemaAttributes::GetWidth() const
{
    return width;
}

int
CinemaAttributes::GetHeight() const
{
    return height;
}

int
CinemaAttributes::GetFrameStart() const
{
    return frameStart;
}

int
CinemaAttributes::GetFrameEnd() const
{
    return frameEnd;
}

int
CinemaAttributes::GetFrameStride() const
{
    return frameStride;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
CinemaAttributes::SelectSpecification()
{
    Select(ID_specification, (void *)&specification);
}

void
CinemaAttributes::SelectFileName()
{
    Select(ID_fileName, (void *)&fileName);
}

void
CinemaAttributes::SelectCameraMode()
{
    Select(ID_cameraMode, (void *)&cameraMode);
}

void
CinemaAttributes::SelectFormat()
{
    Select(ID_format, (void *)&format);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

