// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef BOXEXTENTS_H
#define BOXEXTENTS_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: BoxExtents
//
// Purpose:
//    Attributes for an axis-aligned box
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API BoxExtents : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    BoxExtents();
    BoxExtents(const BoxExtents &obj);
protected:
    // These constructors are for objects derived from this class
    BoxExtents(private_tmfs_t tmfs);
    BoxExtents(const BoxExtents &obj, private_tmfs_t tmfs);
public:
    virtual ~BoxExtents();

    virtual BoxExtents& operator = (const BoxExtents &obj);
    virtual bool operator == (const BoxExtents &obj) const;
    virtual bool operator != (const BoxExtents &obj) const;
private:
    void Init();
    void Copy(const BoxExtents &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectExtents();

    // Property setting methods
    void SetExtents(const double *extents_);

    // Property getting methods
    const double *GetExtents() const;
          double *GetExtents();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_extents = 0,
        ID__LAST
    };

private:
    double extents[6];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define BOXEXTENTS_TMFS "D"

#endif
