// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <BoxExtents.h>
#include <DataNode.h>

// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Init utility for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoxExtents::Init()
{
    extents[0] = 0;
    extents[1] = 0;
    extents[2] = 0;
    extents[3] = 0;
    extents[4] = 0;
    extents[5] = 0;

    BoxExtents::SelectAll();
}

// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Copy utility for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void BoxExtents::Copy(const BoxExtents &obj)
{

    for(int i = 0; i < 6; ++i)
        extents[i] = obj.extents[i];


    BoxExtents::SelectAll();
}

// Type map format string
const char *BoxExtents::TypeMapFormatString = BOXEXTENTS_TMFS;
const AttributeGroup::private_tmfs_t BoxExtents::TmfsStruct = {BOXEXTENTS_TMFS};


// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Default constructor for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents::BoxExtents() :
    AttributeSubject(BoxExtents::TypeMapFormatString)
{
    BoxExtents::Init();
}

// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Constructor for the derived classes of BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents::BoxExtents(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    BoxExtents::Init();
}

// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Copy constructor for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents::BoxExtents(const BoxExtents &obj) :
    AttributeSubject(BoxExtents::TypeMapFormatString)
{
    BoxExtents::Copy(obj);
}

// ****************************************************************************
// Method: BoxExtents::BoxExtents
//
// Purpose:
//   Copy constructor for derived classes of the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents::BoxExtents(const BoxExtents &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    BoxExtents::Copy(obj);
}

// ****************************************************************************
// Method: BoxExtents::~BoxExtents
//
// Purpose:
//   Destructor for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents::~BoxExtents()
{
    // nothing here
}

// ****************************************************************************
// Method: BoxExtents::operator =
//
// Purpose:
//   Assignment operator for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

BoxExtents&
BoxExtents::operator = (const BoxExtents &obj)
{
    if (this == &obj) return *this;

    BoxExtents::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: BoxExtents::operator ==
//
// Purpose:
//   Comparison operator == for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoxExtents::operator == (const BoxExtents &obj) const
{
    // Compare the extents arrays.
    bool extents_equal = true;
    for(int i = 0; i < 6 && extents_equal; ++i)
        extents_equal = (extents[i] == obj.extents[i]);

    // Create the return value
    return (extents_equal);
}

// ****************************************************************************
// Method: BoxExtents::operator !=
//
// Purpose:
//   Comparison operator != for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoxExtents::operator != (const BoxExtents &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: BoxExtents::TypeName
//
// Purpose:
//   Type name method for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
BoxExtents::TypeName() const
{
    return "BoxExtents";
}

// ****************************************************************************
// Method: BoxExtents::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoxExtents::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const BoxExtents *tmp = (const BoxExtents *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: BoxExtents::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoxExtents::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new BoxExtents(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: BoxExtents::NewInstance
//
// Purpose:
//   NewInstance method for the BoxExtents class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
BoxExtents::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new BoxExtents(*this);
    else
        retval = new BoxExtents;

    return retval;
}

// ****************************************************************************
// Method: BoxExtents::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoxExtents::SelectAll()
{
    Select(ID_extents, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoxExtents::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoxExtents::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    BoxExtents defaultObject;
    bool addToParent = false;
    // Create a node for BoxExtents.
    DataNode *node = new DataNode("BoxExtents");

    if(completeSave || !FieldsEqual(ID_extents, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("extents", extents, 6));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: BoxExtents::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
BoxExtents::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("BoxExtents");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("extents")) != 0)
        SetExtents(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
BoxExtents::SetExtents(const double *extents_)
{
    for(int i = 0; i < 6; ++i)
        extents[i] = extents_[i];
    Select(ID_extents, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
BoxExtents::GetExtents() const
{
    return extents;
}

double *
BoxExtents::GetExtents()
{
    return extents;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
BoxExtents::SelectExtents()
{
    Select(ID_extents, (void *)extents, 6);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: BoxExtents::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoxExtents::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_extents: return "extents";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoxExtents::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
BoxExtents::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_extents: return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: BoxExtents::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
BoxExtents::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_extents: return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: BoxExtents::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
BoxExtents::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const BoxExtents &obj = *((const BoxExtents*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_extents:
        {  // new scope
        // Compare the extents arrays.
        bool extents_equal = true;
        for(int i = 0; i < 6 && extents_equal; ++i)
            extents_equal = (extents[i] == obj.extents[i]);

        retval = extents_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

