// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AXESARRAY_H
#define AXESARRAY_H
#include <state_exports.h>
#include <AttributeSubject.h>

#include <AxisAttributes.h>

// ****************************************************************************
// Class: AxesArray
//
// Purpose:
//    Contains the properties for the array axes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AxesArray : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    AxesArray();
    AxesArray(const AxesArray &obj);
protected:
    // These constructors are for objects derived from this class
    AxesArray(private_tmfs_t tmfs);
    AxesArray(const AxesArray &obj, private_tmfs_t tmfs);
public:
    virtual ~AxesArray();

    virtual AxesArray& operator = (const AxesArray &obj);
    virtual bool operator == (const AxesArray &obj) const;
    virtual bool operator != (const AxesArray &obj) const;
private:
    void Init();
    void Copy(const AxesArray &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectAxes();

    // Property setting methods
    void SetVisible(bool visible_);
    void SetTicksVisible(bool ticksVisible_);
    void SetAutoSetTicks(bool autoSetTicks_);
    void SetAutoSetScaling(bool autoSetScaling_);
    void SetLineWidth(int lineWidth_);
    void SetAxes(const AxisAttributes &axes_);

    // Property getting methods
    bool                 GetVisible() const;
    bool                 GetTicksVisible() const;
    bool                 GetAutoSetTicks() const;
    bool                 GetAutoSetScaling() const;
    int                  GetLineWidth() const;
    const AxisAttributes &GetAxes() const;
          AxisAttributes &GetAxes();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_visible = 0,
        ID_ticksVisible,
        ID_autoSetTicks,
        ID_autoSetScaling,
        ID_lineWidth,
        ID_axes,
        ID__LAST
    };

private:
    bool           visible;
    bool           ticksVisible;
    bool           autoSetTicks;
    bool           autoSetScaling;
    int            lineWidth;
    AxisAttributes axes;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AXESARRAY_TMFS "bbbbia"

#endif
