// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <AnnotationObject.h>
#include <DataNode.h>

//
// Enum conversion methods for AnnotationObject::AnnotationType
//

static const char *AnnotationType_strings[] = {
"Text2D", "Text3D", "TimeSlider",
"Line2D", "Line3D", "Arrow2D",
"Arrow3D", "Box", "Image",
"LegendAttributes", "MaxAnnotationType"};

std::string
AnnotationObject::AnnotationType_ToString(AnnotationObject::AnnotationType t)
{
    int index = int(t);
    if(index < 0 || index >= 11) index = 0;
    return AnnotationType_strings[index];
}

std::string
AnnotationObject::AnnotationType_ToString(int t)
{
    int index = (t < 0 || t >= 11) ? 0 : t;
    return AnnotationType_strings[index];
}

bool
AnnotationObject::AnnotationType_FromString(const std::string &s, AnnotationObject::AnnotationType &val)
{
    val = AnnotationObject::Text2D;
    for(int i = 0; i < 11; ++i)
    {
        if(s == AnnotationType_strings[i])
        {
            val = (AnnotationType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for AnnotationObject::FontFamily
//

static const char *FontFamily_strings[] = {
"Arial", "Courier", "Times"
};

std::string
AnnotationObject::FontFamily_ToString(AnnotationObject::FontFamily t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return FontFamily_strings[index];
}

std::string
AnnotationObject::FontFamily_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return FontFamily_strings[index];
}

bool
AnnotationObject::FontFamily_FromString(const std::string &s, AnnotationObject::FontFamily &val)
{
    val = AnnotationObject::Arial;
    for(int i = 0; i < 3; ++i)
    {
        if(s == FontFamily_strings[i])
        {
            val = (FontFamily)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Init utility for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AnnotationObject::Init()
{
    objectType = Text2D;
    visible = false;
    active = false;
    position[0] = 0;
    position[1] = 0;
    position[2] = 0;
    position2[0] = 0;
    position2[1] = 0;
    position2[2] = 0;
    useForegroundForTextColor = true;
    fontFamily = Arial;
    fontBold = false;
    fontItalic = false;
    fontShadow = false;
    doubleAttribute1 = 0;
    intAttribute1 = 0;

    AnnotationObject::SelectAll();
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Copy utility for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void AnnotationObject::Copy(const AnnotationObject &obj)
{
    objectName = obj.objectName;
    objectType = obj.objectType;
    visible = obj.visible;
    active = obj.active;
    position[0] = obj.position[0];
    position[1] = obj.position[1];
    position[2] = obj.position[2];

    position2[0] = obj.position2[0];
    position2[1] = obj.position2[1];
    position2[2] = obj.position2[2];

    textColor = obj.textColor;
    useForegroundForTextColor = obj.useForegroundForTextColor;
    color1 = obj.color1;
    color2 = obj.color2;
    text = obj.text;
    fontFamily = obj.fontFamily;
    fontBold = obj.fontBold;
    fontItalic = obj.fontItalic;
    fontShadow = obj.fontShadow;
    doubleAttribute1 = obj.doubleAttribute1;
    intAttribute1 = obj.intAttribute1;
    options = obj.options;

    AnnotationObject::SelectAll();
}

// Type map format string
const char *AnnotationObject::TypeMapFormatString = ANNOTATIONOBJECT_TMFS;
const AttributeGroup::private_tmfs_t AnnotationObject::TmfsStruct = {ANNOTATIONOBJECT_TMFS};


// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Default constructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject::AnnotationObject() :
    AttributeSubject(AnnotationObject::TypeMapFormatString),
    textColor(), color1(),
    color2()
{
    AnnotationObject::Init();
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Constructor for the derived classes of AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject::AnnotationObject(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    textColor(), color1(),
    color2()
{
    AnnotationObject::Init();
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Copy constructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject::AnnotationObject(const AnnotationObject &obj) :
    AttributeSubject(AnnotationObject::TypeMapFormatString)
{
    AnnotationObject::Copy(obj);
}

// ****************************************************************************
// Method: AnnotationObject::AnnotationObject
//
// Purpose:
//   Copy constructor for derived classes of the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject::AnnotationObject(const AnnotationObject &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    AnnotationObject::Copy(obj);
}

// ****************************************************************************
// Method: AnnotationObject::~AnnotationObject
//
// Purpose:
//   Destructor for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject::~AnnotationObject()
{
    // nothing here
}

// ****************************************************************************
// Method: AnnotationObject::operator =
//
// Purpose:
//   Assignment operator for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AnnotationObject&
AnnotationObject::operator = (const AnnotationObject &obj)
{
    if (this == &obj) return *this;

    AnnotationObject::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: AnnotationObject::operator ==
//
// Purpose:
//   Comparison operator == for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AnnotationObject::operator == (const AnnotationObject &obj) const
{
    // Compare the position arrays.
    bool position_equal = true;
    for(int i = 0; i < 3 && position_equal; ++i)
        position_equal = (position[i] == obj.position[i]);

    // Compare the position2 arrays.
    bool position2_equal = true;
    for(int i = 0; i < 3 && position2_equal; ++i)
        position2_equal = (position2[i] == obj.position2[i]);

    // Create the return value
    return ((objectName == obj.objectName) &&
            (objectType == obj.objectType) &&
            (visible == obj.visible) &&
            (active == obj.active) &&
            position_equal &&
            position2_equal &&
            (textColor == obj.textColor) &&
            (useForegroundForTextColor == obj.useForegroundForTextColor) &&
            (color1 == obj.color1) &&
            (color2 == obj.color2) &&
            (text == obj.text) &&
            (fontFamily == obj.fontFamily) &&
            (fontBold == obj.fontBold) &&
            (fontItalic == obj.fontItalic) &&
            (fontShadow == obj.fontShadow) &&
            (doubleAttribute1 == obj.doubleAttribute1) &&
            (intAttribute1 == obj.intAttribute1) &&
            (options == obj.options));
}

// ****************************************************************************
// Method: AnnotationObject::operator !=
//
// Purpose:
//   Comparison operator != for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AnnotationObject::operator != (const AnnotationObject &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: AnnotationObject::TypeName
//
// Purpose:
//   Type name method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
AnnotationObject::TypeName() const
{
    return "AnnotationObject";
}

// ****************************************************************************
// Method: AnnotationObject::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AnnotationObject::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const AnnotationObject *tmp = (const AnnotationObject *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: AnnotationObject::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AnnotationObject::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new AnnotationObject(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: AnnotationObject::NewInstance
//
// Purpose:
//   NewInstance method for the AnnotationObject class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
AnnotationObject::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new AnnotationObject(*this);
    else
        retval = new AnnotationObject;

    return retval;
}

// ****************************************************************************
// Method: AnnotationObject::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObject::SelectAll()
{
    Select(ID_objectName,                (void *)&objectName);
    Select(ID_objectType,                (void *)&objectType);
    Select(ID_visible,                   (void *)&visible);
    Select(ID_active,                    (void *)&active);
    Select(ID_position,                  (void *)position, 3);
    Select(ID_position2,                 (void *)position2, 3);
    Select(ID_textColor,                 (void *)&textColor);
    Select(ID_useForegroundForTextColor, (void *)&useForegroundForTextColor);
    Select(ID_color1,                    (void *)&color1);
    Select(ID_color2,                    (void *)&color2);
    Select(ID_text,                      (void *)&text);
    Select(ID_fontFamily,                (void *)&fontFamily);
    Select(ID_fontBold,                  (void *)&fontBold);
    Select(ID_fontItalic,                (void *)&fontItalic);
    Select(ID_fontShadow,                (void *)&fontShadow);
    Select(ID_doubleAttribute1,          (void *)&doubleAttribute1);
    Select(ID_intAttribute1,             (void *)&intAttribute1);
    Select(ID_options,                   (void *)&options);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObject::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AnnotationObject::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    AnnotationObject defaultObject;
    bool addToParent = false;
    // Create a node for AnnotationObject.
    DataNode *node = new DataNode("AnnotationObject");

    if(completeSave || !FieldsEqual(ID_objectName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("objectName", objectName));
    }

    if(completeSave || !FieldsEqual(ID_objectType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("objectType", AnnotationType_ToString(objectType)));
    }

    if(completeSave || !FieldsEqual(ID_visible, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("visible", visible));
    }

    if(completeSave || !FieldsEqual(ID_active, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("active", active));
    }

    if(completeSave || !FieldsEqual(ID_position, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("position", position, 3));
    }

    if(completeSave || !FieldsEqual(ID_position2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("position2", position2, 3));
    }

        DataNode *textColorNode = new DataNode("textColor");
        if(textColor.CreateNode(textColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(textColorNode);
        }
        else
            delete textColorNode;
    if(completeSave || !FieldsEqual(ID_useForegroundForTextColor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useForegroundForTextColor", useForegroundForTextColor));
    }

        DataNode *color1Node = new DataNode("color1");
        if(color1.CreateNode(color1Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(color1Node);
        }
        else
            delete color1Node;
        DataNode *color2Node = new DataNode("color2");
        if(color2.CreateNode(color2Node, completeSave, true))
        {
            addToParent = true;
            node->AddNode(color2Node);
        }
        else
            delete color2Node;
    if(completeSave || !FieldsEqual(ID_text, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("text", text));
    }

    if(completeSave || !FieldsEqual(ID_fontFamily, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontFamily", FontFamily_ToString(fontFamily)));
    }

    if(completeSave || !FieldsEqual(ID_fontBold, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontBold", fontBold));
    }

    if(completeSave || !FieldsEqual(ID_fontItalic, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontItalic", fontItalic));
    }

    if(completeSave || !FieldsEqual(ID_fontShadow, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fontShadow", fontShadow));
    }

    if(completeSave || !FieldsEqual(ID_doubleAttribute1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("doubleAttribute1", doubleAttribute1));
    }

    if(completeSave || !FieldsEqual(ID_intAttribute1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("intAttribute1", intAttribute1));
    }

    if(completeSave || !FieldsEqual(ID_options, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("options", options));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: AnnotationObject::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode
//    representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   Fri Mar 17 14:44:33 PST 2006
//
// Modifications:
//   Kathleen Bonnell, Fri Mar 31 14:14:25 PST 2006
//   Handle the case where the parentNode saved postion as float instead
//   of double.
//
//   Brad Whitlock, Fri Mar 23 17:08:29 PST 2007
//   Added objectName.
//
//   Kathleen Bonnell, Thu Oct  1 15:00:50 PDT 2009
//   Added intAttribute2, intAttribute3, doubleVector1, stringVector1,
//   stringVector2
// ****************************************************************************

void
AnnotationObject::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("AnnotationObject");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("objectName")) != 0)
        SetObjectName(node->AsString());
    if((node = searchNode->GetNode("objectType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 8)
                SetObjectType(AnnotationType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            AnnotationType value;
            if(AnnotationType_FromString(node->AsString(), value))
                SetObjectType(value);
        }
    }
    if((node = searchNode->GetNode("visible")) != 0)
        SetVisible(node->AsBool());
    if((node = searchNode->GetNode("active")) != 0)
        SetActive(node->AsBool());
    if((node = searchNode->GetNode("position")) != 0)
    {
        if(node->GetNodeType() == FLOAT_ARRAY_NODE)
        {
            const float *fn = node->AsFloatArray();
            double dp[3] = {fn[0], fn[1], fn[2]};
            SetPosition(dp);
        }
        else
            SetPosition(node->AsDoubleArray());
    }
    if((node = searchNode->GetNode("position2")) != 0)
    {
        if(node->GetNodeType() == FLOAT_ARRAY_NODE)
        {
            const float *fn = node->AsFloatArray();
            double dp[3] = {fn[0], fn[1], fn[2]};
            SetPosition2(dp);
        }
        else
            SetPosition2(node->AsDoubleArray());
    }
    if((node = searchNode->GetNode("textColor")) != 0)
        textColor.SetFromNode(node);
    if((node = searchNode->GetNode("useForegroundForTextColor")) != 0)
        SetUseForegroundForTextColor(node->AsBool());
    if((node = searchNode->GetNode("color1")) != 0)
        color1.SetFromNode(node);
    if((node = searchNode->GetNode("color2")) != 0)
        color2.SetFromNode(node);
    if((node = searchNode->GetNode("text")) != 0)
        SetText(node->AsStringVector());
    if((node = searchNode->GetNode("fontFamily")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetFontFamily(FontFamily(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            FontFamily value;
            if(FontFamily_FromString(node->AsString(), value))
                SetFontFamily(value);
        }
    }
    if((node = searchNode->GetNode("fontBold")) != 0)
        SetFontBold(node->AsBool());
    if((node = searchNode->GetNode("fontItalic")) != 0)
        SetFontItalic(node->AsBool());
    if((node = searchNode->GetNode("fontShadow")) != 0)
        SetFontShadow(node->AsBool());
    if((node = searchNode->GetNode("doubleAttribute1")) != 0)
        SetDoubleAttribute1(node->AsDouble());
    if((node = searchNode->GetNode("intAttribute1")) != 0)
        SetIntAttribute1(node->AsInt());
    if((node = searchNode->GetNode("options")) != 0)
        SetOptions(node->AsMapNode());
}
///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationObject::SetObjectName(const std::string &objectName_)
{
    objectName = objectName_;
    Select(ID_objectName, (void *)&objectName);
}

void
AnnotationObject::SetObjectType(AnnotationObject::AnnotationType objectType_)
{
    objectType = objectType_;
    Select(ID_objectType, (void *)&objectType);
}

void
AnnotationObject::SetVisible(bool visible_)
{
    visible = visible_;
    Select(ID_visible, (void *)&visible);
}

void
AnnotationObject::SetActive(bool active_)
{
    active = active_;
    Select(ID_active, (void *)&active);
}

void
AnnotationObject::SetPosition(const double *position_)
{
    position[0] = position_[0];
    position[1] = position_[1];
    position[2] = position_[2];
    Select(ID_position, (void *)position, 3);
}

void
AnnotationObject::SetPosition2(const double *position2_)
{
    position2[0] = position2_[0];
    position2[1] = position2_[1];
    position2[2] = position2_[2];
    Select(ID_position2, (void *)position2, 3);
}

void
AnnotationObject::SetTextColor(const ColorAttribute &textColor_)
{
    textColor = textColor_;
    Select(ID_textColor, (void *)&textColor);
}

void
AnnotationObject::SetUseForegroundForTextColor(bool useForegroundForTextColor_)
{
    useForegroundForTextColor = useForegroundForTextColor_;
    Select(ID_useForegroundForTextColor, (void *)&useForegroundForTextColor);
}

void
AnnotationObject::SetColor1(const ColorAttribute &color1_)
{
    color1 = color1_;
    Select(ID_color1, (void *)&color1);
}

void
AnnotationObject::SetColor2(const ColorAttribute &color2_)
{
    color2 = color2_;
    Select(ID_color2, (void *)&color2);
}

void
AnnotationObject::SetText(const stringVector &text_)
{
    text = text_;
    Select(ID_text, (void *)&text);
}

void
AnnotationObject::SetFontFamily(AnnotationObject::FontFamily fontFamily_)
{
    fontFamily = fontFamily_;
    Select(ID_fontFamily, (void *)&fontFamily);
}

void
AnnotationObject::SetFontBold(bool fontBold_)
{
    fontBold = fontBold_;
    Select(ID_fontBold, (void *)&fontBold);
}

void
AnnotationObject::SetFontItalic(bool fontItalic_)
{
    fontItalic = fontItalic_;
    Select(ID_fontItalic, (void *)&fontItalic);
}

void
AnnotationObject::SetFontShadow(bool fontShadow_)
{
    fontShadow = fontShadow_;
    Select(ID_fontShadow, (void *)&fontShadow);
}

void
AnnotationObject::SetDoubleAttribute1(double doubleAttribute1_)
{
    doubleAttribute1 = doubleAttribute1_;
    Select(ID_doubleAttribute1, (void *)&doubleAttribute1);
}

void
AnnotationObject::SetIntAttribute1(int intAttribute1_)
{
    intAttribute1 = intAttribute1_;
    Select(ID_intAttribute1, (void *)&intAttribute1);
}

void
AnnotationObject::SetOptions(const MapNode &options_)
{
    options = options_;
    Select(ID_options, (void *)&options);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
AnnotationObject::GetObjectName() const
{
    return objectName;
}

std::string &
AnnotationObject::GetObjectName()
{
    return objectName;
}

AnnotationObject::AnnotationType
AnnotationObject::GetObjectType() const
{
    return AnnotationType(objectType);
}

bool
AnnotationObject::GetVisible() const
{
    return visible;
}

bool
AnnotationObject::GetActive() const
{
    return active;
}

const double *
AnnotationObject::GetPosition() const
{
    return position;
}

double *
AnnotationObject::GetPosition()
{
    return position;
}

const double *
AnnotationObject::GetPosition2() const
{
    return position2;
}

double *
AnnotationObject::GetPosition2()
{
    return position2;
}

const ColorAttribute &
AnnotationObject::GetTextColor() const
{
    return textColor;
}

ColorAttribute &
AnnotationObject::GetTextColor()
{
    return textColor;
}

bool
AnnotationObject::GetUseForegroundForTextColor() const
{
    return useForegroundForTextColor;
}

const ColorAttribute &
AnnotationObject::GetColor1() const
{
    return color1;
}

ColorAttribute &
AnnotationObject::GetColor1()
{
    return color1;
}

const ColorAttribute &
AnnotationObject::GetColor2() const
{
    return color2;
}

ColorAttribute &
AnnotationObject::GetColor2()
{
    return color2;
}

const stringVector &
AnnotationObject::GetText() const
{
    return text;
}

stringVector &
AnnotationObject::GetText()
{
    return text;
}

AnnotationObject::FontFamily
AnnotationObject::GetFontFamily() const
{
    return FontFamily(fontFamily);
}

bool
AnnotationObject::GetFontBold() const
{
    return fontBold;
}

bool
AnnotationObject::GetFontItalic() const
{
    return fontItalic;
}

bool
AnnotationObject::GetFontShadow() const
{
    return fontShadow;
}

double
AnnotationObject::GetDoubleAttribute1() const
{
    return doubleAttribute1;
}

int
AnnotationObject::GetIntAttribute1() const
{
    return intAttribute1;
}

const MapNode &
AnnotationObject::GetOptions() const
{
    return options;
}

MapNode &
AnnotationObject::GetOptions()
{
    return options;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
AnnotationObject::SelectObjectName()
{
    Select(ID_objectName, (void *)&objectName);
}

void
AnnotationObject::SelectPosition()
{
    Select(ID_position, (void *)position, 3);
}

void
AnnotationObject::SelectPosition2()
{
    Select(ID_position2, (void *)position2, 3);
}

void
AnnotationObject::SelectTextColor()
{
    Select(ID_textColor, (void *)&textColor);
}

void
AnnotationObject::SelectColor1()
{
    Select(ID_color1, (void *)&color1);
}

void
AnnotationObject::SelectColor2()
{
    Select(ID_color2, (void *)&color2);
}

void
AnnotationObject::SelectText()
{
    Select(ID_text, (void *)&text);
}

void
AnnotationObject::SelectOptions()
{
    Select(ID_options, (void *)&options);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObject::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AnnotationObject::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_objectName:                return "objectName";
    case ID_objectType:                return "objectType";
    case ID_visible:                   return "visible";
    case ID_active:                    return "active";
    case ID_position:                  return "position";
    case ID_position2:                 return "position2";
    case ID_textColor:                 return "textColor";
    case ID_useForegroundForTextColor: return "useForegroundForTextColor";
    case ID_color1:                    return "color1";
    case ID_color2:                    return "color2";
    case ID_text:                      return "text";
    case ID_fontFamily:                return "fontFamily";
    case ID_fontBold:                  return "fontBold";
    case ID_fontItalic:                return "fontItalic";
    case ID_fontShadow:                return "fontShadow";
    case ID_doubleAttribute1:          return "doubleAttribute1";
    case ID_intAttribute1:             return "intAttribute1";
    case ID_options:                   return "options";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObject::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
AnnotationObject::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_objectName:                return FieldType_string;
    case ID_objectType:                return FieldType_enum;
    case ID_visible:                   return FieldType_bool;
    case ID_active:                    return FieldType_bool;
    case ID_position:                  return FieldType_doubleArray;
    case ID_position2:                 return FieldType_doubleArray;
    case ID_textColor:                 return FieldType_color;
    case ID_useForegroundForTextColor: return FieldType_bool;
    case ID_color1:                    return FieldType_color;
    case ID_color2:                    return FieldType_color;
    case ID_text:                      return FieldType_stringVector;
    case ID_fontFamily:                return FieldType_enum;
    case ID_fontBold:                  return FieldType_bool;
    case ID_fontItalic:                return FieldType_bool;
    case ID_fontShadow:                return FieldType_bool;
    case ID_doubleAttribute1:          return FieldType_double;
    case ID_intAttribute1:             return FieldType_int;
    case ID_options:                   return FieldType_MapNode;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: AnnotationObject::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
AnnotationObject::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_objectName:                return "string";
    case ID_objectType:                return "enum";
    case ID_visible:                   return "bool";
    case ID_active:                    return "bool";
    case ID_position:                  return "doubleArray";
    case ID_position2:                 return "doubleArray";
    case ID_textColor:                 return "color";
    case ID_useForegroundForTextColor: return "bool";
    case ID_color1:                    return "color";
    case ID_color2:                    return "color";
    case ID_text:                      return "stringVector";
    case ID_fontFamily:                return "enum";
    case ID_fontBold:                  return "bool";
    case ID_fontItalic:                return "bool";
    case ID_fontShadow:                return "bool";
    case ID_doubleAttribute1:          return "double";
    case ID_intAttribute1:             return "int";
    case ID_options:                   return "MapNode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: AnnotationObject::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
AnnotationObject::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const AnnotationObject &obj = *((const AnnotationObject*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_objectName:
        {  // new scope
        retval = (objectName == obj.objectName);
        }
        break;
    case ID_objectType:
        {  // new scope
        retval = (objectType == obj.objectType);
        }
        break;
    case ID_visible:
        {  // new scope
        retval = (visible == obj.visible);
        }
        break;
    case ID_active:
        {  // new scope
        retval = (active == obj.active);
        }
        break;
    case ID_position:
        {  // new scope
        // Compare the position arrays.
        bool position_equal = true;
        for(int i = 0; i < 3 && position_equal; ++i)
            position_equal = (position[i] == obj.position[i]);

        retval = position_equal;
        }
        break;
    case ID_position2:
        {  // new scope
        // Compare the position2 arrays.
        bool position2_equal = true;
        for(int i = 0; i < 3 && position2_equal; ++i)
            position2_equal = (position2[i] == obj.position2[i]);

        retval = position2_equal;
        }
        break;
    case ID_textColor:
        {  // new scope
        retval = (textColor == obj.textColor);
        }
        break;
    case ID_useForegroundForTextColor:
        {  // new scope
        retval = (useForegroundForTextColor == obj.useForegroundForTextColor);
        }
        break;
    case ID_color1:
        {  // new scope
        retval = (color1 == obj.color1);
        }
        break;
    case ID_color2:
        {  // new scope
        retval = (color2 == obj.color2);
        }
        break;
    case ID_text:
        {  // new scope
        retval = (text == obj.text);
        }
        break;
    case ID_fontFamily:
        {  // new scope
        retval = (fontFamily == obj.fontFamily);
        }
        break;
    case ID_fontBold:
        {  // new scope
        retval = (fontBold == obj.fontBold);
        }
        break;
    case ID_fontItalic:
        {  // new scope
        retval = (fontItalic == obj.fontItalic);
        }
        break;
    case ID_fontShadow:
        {  // new scope
        retval = (fontShadow == obj.fontShadow);
        }
        break;
    case ID_doubleAttribute1:
        {  // new scope
        retval = (doubleAttribute1 == obj.doubleAttribute1);
        }
        break;
    case ID_intAttribute1:
        {  // new scope
        retval = (intAttribute1 == obj.intAttribute1);
        }
        break;
    case ID_options:
        {  // new scope
        retval = (options == obj.options);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: AnnotationObject::ProcessOldVersions
//
// Purpose:
//   This method maps old AnnotationAttributes fields to the 1.9.0 version of
//   the data node tree for AnnotationAttributes.
//
// Programmer: Kathleen Bonnell
// Creation:   Thu Sep 17 10:06:49 PDT 2009
//
// Modifications:
//   Kathleen Biagas, Wed Nov 28 14:03:22 PST 2018
//   Split off the different version checks into stand alone methods based
//   on objectType.
//
// ****************************************************************************

void
AnnotationObject::ProcessOldVersions(DataNode *parentNode,
    const char *configVersion)
{
    if (!VersionLessThan(configVersion, "3.0.0") || parentNode == 0)
    {
        return;
    }

    DataNode * searchNode = parentNode->GetNode("AnnotationObject");
    if (searchNode == 0)
        return;

    DataNode *node = searchNode->GetNode("objectType");
    if (node == 0)
        return;

    if (node->AsString() == "LegendAttributes")
        ProcessOldLegend(searchNode, configVersion);
    else if (node->AsString() == "Line3D")
        ProcessOldLine3D(searchNode);
    else if (node->AsString() == "Line2D")
        ProcessOldLine2D(searchNode);
}

// ****************************************************************************
// Method: AnnotationObject::ProcessOldLegend
//
// Purpose:
//   This method maps old Legend fields to
//   the data node tree for AnnotationObject.
//
// Programmer: Kathleen Bonnell
// Creation:   November 28, 2018
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObject::ProcessOldLegend(DataNode *searchNode, const char *configVersion)
{
    // what follows is for Legends only
    DataNode *node = NULL;
    if (VersionLessThan(configVersion, "2.0.0"))
    {
        node = searchNode->GetNode("intAttribute1");
        if (node != 0)
        {
            int n = node->AsInt();

            if ((n & (1 << 2)) != 0) // DrawLabels is set, change it to DrawValues
            {
                n -= 4;   // DrawLabels
                n += 512; // DrawValues
            }
            // other new legend enums, default to on, and sum to 384
            n += 384;
            node->SetInt(n);
        }

        // new numTics attribute, default setting is 5
    }

    // pre 3.0.0
    MapNode options;
    node = searchNode->GetNode("intAttribute2");
    if (node != 0)
    {
        options["numTicks"] = node->AsInt();
        searchNode->RemoveNode("intAttribute2");
    }
    else // pre 2.0.0
    {
        options["numTicks"] = 5; // default
    }

    node = searchNode->GetNode("intAttribute3");
    if (node != 0)
    {
        options["legendType"] = node->AsInt();
        searchNode->RemoveNode("intAttribute3");
    }
    else // pre 2.0.0
    {
        options["legendType"] = 0; // default "Variable" type
    }
    node = searchNode->GetNode("stringVector1");
    if (node != 0)
    {
        options["suppliedLabels"] = node->AsStringVector();
        searchNode->RemoveNode("stringVector1");
    }
    node = searchNode->GetNode("doubleVector1");
    if (node != 0)
    {
        options["suppliedValues"] = node->AsDoubleVector();
        searchNode->RemoveNode("doubleVector1");
    }
    node = searchNode->GetNode("stringVector2");
    if (node != 0)
    {
        options["suppliedValuesStrings"] = node->AsStringVector();
        searchNode->RemoveNode("stringVector2");
    }
    node = searchNode->GetNode("doubleAttribute1");
    if (node != 0)
    {
        options["fontHeight"] = node->AsDouble();
        searchNode->RemoveNode("doubleAttribute1");
    }
    node = new DataNode("options", options);
    searchNode->AddNode(node);
}

// ****************************************************************************
// Method: AnnotationObject::ProcessOldLine3D
//
// Purpose:
//   This method maps old Line3D AnnotationObject fields to the 3.0.0 version
//   of the data node tree for Line3D AnnotationObjects.
//
// Programmer: Kathleen Biagas
// Creation:   November 28, 2018
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObject::ProcessOldLine3D(DataNode *searchNode)
{
    // what follows is for Line3D only

    // Line3D specific options are now stored in a MapNode
    MapNode options;

    DataNode *node = searchNode->GetNode("color2");
    if (node != 0)
    {
        // color2 stored arrow1, arrow2, arrow1Resolution and arrow2Resolution
        const unsigned char *c2 = node->GetNode("ColorAttribute")->GetNode("color")->AsUnsignedCharArray();
        options["arrow1"] = (bool) c2[0];
        options["arrow2"] = (bool) c2[1];
        options["arrow1Resolution"] = (int) c2[2];
        options["arrow2Resolution"] = (int) c2[3];
        searchNode->RemoveNode("color2");
    }

    node = searchNode->GetNode("doubleVector1");
    if (node != 0)
    {
        // doubleVector1 stored arrow1Radius, arrow2Radius,
        // tubeQuality, tubeRadius
        const doubleVector &dv = node->AsDoubleVector();
        options["arrow1Radius"] = dv[0];
        options["arrow2Radius"] = dv[1];
        options["tubeQuality"]  = (int)dv[2];
        options["tubeRadius"]   = dv[3];

        // add new arrow height options, % of radius
        options["arrow1Height"] = dv[0] * 2.8;
        options["arrow1Height"] = dv[1] * 2.8;

        searchNode->RemoveNode("doubleVector1");
    }

    node = searchNode->GetNode("intAttribute1");
    if (node != 0)
    {
        // intAttribute1 stored  line width
        options["width"] = node->AsInt();
        searchNode->RemoveNode("intAttribute1");
    }

    node = searchNode->GetNode("intAttribute2");
    if (node != 0)
    {
        // intAttribute2 stored lineStyle, no longer applicable
        searchNode->RemoveNode("intAttribute2");
    }

    node = searchNode->GetNode("intAttribute3");
    if (node != 0)
    {
        // intAttribute3 stored line Type
        options["lineType"] = node->AsInt();
        searchNode->RemoveNode("intAttribute3");
    }

    // Probably being over-cautious here, but perform some sanity checks to
    // ensure all the required options are present,  fill with defaults if not
    if (! options.HasEntry("arrow1"))
        options["arrow1"] = false;
    if (! options.HasEntry("arrow2"))
        options["arrow2"] = false;
    if (! options.HasEntry("arrow1Resolution"))
        options["arrow1Resolution"] = 16;
    if (! options.HasEntry("arrow2Resolution"))
        options["arrow2Resolution"] = 16;
    if (! options.HasEntry("arrow1Radius"))
        options["arrow1Radius"] = 0.5;
    if (! options.HasEntry("arrow2Radius"))
        options["arrow2Radius"] = 0.5;
    if (! options.HasEntry("arrow1Height"))
        options["arrow1Height"] = 1.4;
    if (! options.HasEntry("arrow2Height"))
        options["arrow2Height"] = 1.4;
    if (! options.HasEntry("width"))
        options["width"] = 0;
    if (! options.HasEntry("lineType"))
        options["lineType"] = 0;
    if (! options.HasEntry("tubeQuality"))
        options["tubeQuality"] = 1;
    if (! options.HasEntry("tubeRadius"))
        options["tubeRadius"] = 0.5;

    node = new DataNode("options", options);
    searchNode->AddNode(node);
}

// ****************************************************************************
// Method: AnnotationObject::ProcessOldLine2D
//
// Purpose:
//   This method maps old Line2D AnnotationObject fields to the 3.0.0 version
//   of the data node tree for Line2D AnnotationObjects.
//
// Programmer: Kathleen Biagas
// Creation:   November 28, 2018
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObject::ProcessOldLine2D(DataNode *searchNode)
{
    // what follows is for Line2D only

    // Line3D specific options are now stored in a MapNode
    MapNode options;

    DataNode *node = searchNode->GetNode("color2");
    if (node != 0)
    {
        // color2 stored beginArrow and endArrow in 'green'(1)  and 'blue' (2)
        const unsigned char *c2 = node->GetNode("ColorAttribute")->GetNode("color")->AsUnsignedCharArray();
        options["beginArrowStyle"] = (int) c2[1];
        options["endArrowStyle"]   = (int) c2[2];
        searchNode->RemoveNode("color2");
    }

    node = searchNode->GetNode("intAttribute1");
    if (node != 0)
    {
        // intAttribute1 stored  line width
        options["width"] = node->AsInt();
        searchNode->RemoveNode("intAttribute1");
    }

    node = searchNode->GetNode("intAttribute2");
    if (node != 0)
    {
        // intAttribute2 stored lineStyle, no longer applicable
        searchNode->RemoveNode("intAttribute2");
    }

    // Probably being over-cautious here, but perform some sanity checks to
    // ensure all the required options are present,  fill with defaults if not
    if (! options.HasEntry("beginArrowStyle"))
        options["arrow1"] = 0;
    if (! options.HasEntry("endArrowStyle"))
        options["arrow2"] = 0;
    if (! options.HasEntry("width"))
        options["width"] = 0;

    node = new DataNode("options", options);
    searchNode->AddNode(node);
}

// ****************************************************************************
// Method: AnnotationObject::ProcessOldText3D
//
// Purpose:
//   This method maps old Text3D AnnotationObject fields to the 3.0.0 version
//   of the data node tree for Text3D AnnotationObjects.
//
// Programmer: Kathleen Biagas
// Creation:   November 28, 2018
//
// Modifications:
//
// ****************************************************************************

void
AnnotationObject::ProcessOldText3D(DataNode *searchNode)
{
    // what follows is for Text3D only

    MapNode options;

    DataNode *node = searchNode->GetNode("fontBold");
    if (node != 0)
    {
        options["preserveOrientation"] = node->AsBool();
        searchNode->RemoveNode("fontBold");
    }

    node = searchNode->GetNode("fontItalic");
    if (node != 0)
    {
        options["useRelativeHeight"] = node->AsBool();
        searchNode->RemoveNode("fontItalic");
    }

    node = searchNode->GetNode("intAttribute1");
    if (node != 0)
    {
        options["relativeHeight"] = node->AsInt();
        searchNode->RemoveNode("intAttribute1");
    }

    node = searchNode->GetNode("doubleAttribute1");
    if (node != 0)
    {
        options["fixedHeight"] = node->AsDouble();
        searchNode->RemoveNode("doubleAttribute1");
    }

    node = new DataNode("options", options);
    searchNode->AddNode(node);
}

