// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef ANIMATIONATTRIBUTES_H
#define ANIMATIONATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: AnimationAttributes
//
// Purpose:
//    This class contains the animation attributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API AnimationAttributes : public AttributeSubject
{
public:
    enum AnimationMode
    {
        ReversePlayMode,
        StopMode,
        PlayMode
    };
    enum PlaybackMode
    {
        Looping,
        PlayOnce,
        Swing
    };

    // These constructors are for objects of this class
    AnimationAttributes();
    AnimationAttributes(const AnimationAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    AnimationAttributes(private_tmfs_t tmfs);
    AnimationAttributes(const AnimationAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~AnimationAttributes();

    virtual AnimationAttributes& operator = (const AnimationAttributes &obj);
    virtual bool operator == (const AnimationAttributes &obj) const;
    virtual bool operator != (const AnimationAttributes &obj) const;
private:
    void Init();
    void Copy(const AnimationAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetAnimationMode(AnimationMode animationMode_);
    void SetPipelineCachingMode(bool pipelineCachingMode_);
    void SetFrameIncrement(int frameIncrement_);
    void SetTimeout(int timeout_);
    void SetPlaybackMode(PlaybackMode playbackMode_);

    // Property getting methods
    AnimationMode GetAnimationMode() const;
    bool GetPipelineCachingMode() const;
    int  GetFrameIncrement() const;
    int  GetTimeout() const;
    PlaybackMode GetPlaybackMode() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string AnimationMode_ToString(AnimationMode);
    static bool AnimationMode_FromString(const std::string &, AnimationMode &);
protected:
    static std::string AnimationMode_ToString(int);
public:
    static std::string PlaybackMode_ToString(PlaybackMode);
    static bool PlaybackMode_FromString(const std::string &, PlaybackMode &);
protected:
    static std::string PlaybackMode_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    virtual void ProcessOldVersions(DataNode *parentNode, const char *configVersion);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_animationMode = 0,
        ID_pipelineCachingMode,
        ID_frameIncrement,
        ID_timeout,
        ID_playbackMode,
        ID__LAST
    };

private:
    int  animationMode;
    bool pipelineCachingMode;
    int  frameIncrement;
    int  timeout;
    int  playbackMode;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define ANIMATIONATTRIBUTES_TMFS "ibiii"

#endif
