// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef MINMAXINFO_H
#define MINMAXINFO_H
#include <query_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <avtMatrix.h>

// ****************************************************************************
// Class: MinMaxInfo
//
// Purpose:
//    Results storage for MinMaxQuery.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class QUERY_API MinMaxInfo : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    MinMaxInfo();
    MinMaxInfo(const MinMaxInfo &obj);
protected:
    // These constructors are for objects derived from this class
    MinMaxInfo(private_tmfs_t tmfs);
    MinMaxInfo(const MinMaxInfo &obj, private_tmfs_t tmfs);
public:
    virtual ~MinMaxInfo();

    virtual MinMaxInfo& operator = (const MinMaxInfo &obj);
    virtual bool operator == (const MinMaxInfo &obj) const;
    virtual bool operator != (const MinMaxInfo &obj) const;
private:
    void Init();
    void Copy(const MinMaxInfo &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCoord();
    void SelectType();
    void SelectMatName();

    // Property setting methods
    void SetElementNum(int elementNum_);
    void SetDomain(int domain_);
    void SetMvalue(double mvalue_);
    void SetCoord(const double *coord_);
    void SetType(const std::string &type_);
    void SetMatName(const std::string &matName_);

    // Property getting methods
    int               GetElementNum() const;
    int               GetDomain() const;
    double            GetMvalue() const;
    const double      *GetCoord() const;
          double      *GetCoord();
    const std::string &GetType() const;
          std::string &GetType();
    const std::string &GetMatName() const;
          std::string &GetMatName();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void Initialize(const double, const std::string &);
    void TransformCoord(const avtMatrix *trans);
    bool  EquivalentForOutput (const MinMaxInfo &obj) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_elementNum = 0,
        ID_domain,
        ID_mvalue,
        ID_coord,
        ID_type,
        ID_matName,
        ID__LAST
    };

private:
    int         elementNum;
    int         domain;
    double      mvalue;
    double      coord[3];
    std::string type;
    std::string matName;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define MINMAXINFO_TMFS "iidDss"

#endif
