// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PY_DATASELECTION_H
#define PY_DATASELECTION_H

#include <avtDataSelection.h>

// Forward Declare PyObject*
#ifndef PyObject_HEAD
struct _object;
typedef _object PyObject;
#endif

//
// Functions used to interface with Python Filter environment.
//

bool                 PyDataSelection_Check(PyObject *obj);
avtDataSelection_p   PyDataSelection_FromPyObject(PyObject *obj);
PyObject            *PyDataSelection_Wrap(avtDataSelection_p sel);


#endif
