// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtCoordSystemConvert.h
// ************************************************************************* //

#ifndef AVT_CoordConvert_FILTER_H
#define AVT_CoordConvert_FILTER_H

#include <filters_exports.h>

#include <avtDataTreeIterator.h>

// ****************************************************************************
//  Class: avtCoordSystemConvert
//
//  Purpose:
//      A plugin operator for CoordConvert.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Fri Jun 27 16:41:32 PST 2003
//
//  Modifications:
//
//    Hank Childs, Wed Jun  8 14:50:52 PDT 2005
//    Added UpdateDataObjectInfo.
//
//    Jeremy Meredith, Fri Aug  7 15:33:18 EDT 2009
//    Added selectable vector transform method.
//    Made the coord system enum be within the class namespace.
//
//    Eric Brugger, Mon Jul 21 10:19:29 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class AVTFILTERS_API avtCoordSystemConvert : public avtDataTreeIterator
{
  public:
    enum CoordSystem
    {
        CARTESIAN = 0,                /* 0 */
        CYLINDRICAL,                  /* 1 */
        SPHERICAL                     /* 2 */
    };

    enum VectorTransformMethod
    {
        None,
        AsPoint,
        AsDisplacement,
        AsDirection
    };

                         avtCoordSystemConvert();
    virtual             ~avtCoordSystemConvert();

    virtual const char  *GetType(void)  { return "avtCoordSystemConvert"; };
    virtual const char  *GetDescription(void)
                             { return "Converting Coordinate System"; };

    void                 SetInputCoordSys(CoordSystem a) { inputSys = a; };
    void                 SetOutputCoordSys(CoordSystem a) { outputSys = a; };
    void                 SetContinuousPhi(bool a) { continuousPhi = a; };
    void                 SetVectorTransformMethod(VectorTransformMethod m)
                                               { vectorTransformMethod = m; }

  protected:
    CoordSystem           inputSys;
    CoordSystem           outputSys;
    bool                  continuousPhi;

    VectorTransformMethod vectorTransformMethod;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void          PostExecute(void);

    virtual void          UpdateDataObjectInfo(void);
};
#endif
