// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyavtVarMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <avtTypes.h>

// ****************************************************************************
// Module: PyavtVarMetaData
//
// Purpose:
//   Contains metadata attributes associated with all mesh variables
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtVarMetaData.
//
struct avtVarMetaDataObject
{
    PyObject_HEAD
    avtVarMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtVarMetaData(int);

std::string
PyavtVarMetaData_ToString(const avtVarMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtBaseVarMetaData_ToString(atts, prefix);

    const char *centering_names = "AVT_NODECENT, AVT_ZONECENT, AVT_NO_VARIABLE, AVT_UNKNOWN_CENT";
    if(atts->centering == AVT_NODECENT)
    {
        snprintf(tmpStr, 1000, "%scentering = %sAVT_NODECENT  # %s\n", prefix, prefix, centering_names);
        str += tmpStr;
    }
    else if(atts->centering == AVT_ZONECENT)
    {
        snprintf(tmpStr, 1000, "%scentering = %sAVT_ZONECENT  # %s\n", prefix, prefix, centering_names);
        str += tmpStr;
    }
    else if(atts->centering == AVT_NO_VARIABLE)
    {
        snprintf(tmpStr, 1000, "%scentering = %sAVT_NO_VARIABLE  # %s\n", prefix, prefix, centering_names);
        str += tmpStr;
    }
    else
    {
        snprintf(tmpStr, 1000, "%scentering = %sAVT_UNKNOWN_CENT  # %s\n", prefix, prefix, centering_names);
        str += tmpStr;
    }

    if(atts->hasUnits)
        snprintf(tmpStr, 1000, "%shasUnits = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%shasUnits = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sunits = \"%s\"\n", prefix, atts->units.c_str());
    str += tmpStr;
    if(atts->hasDataExtents)
        snprintf(tmpStr, 1000, "%shasDataExtents = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%shasDataExtents = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sminDataExtents = %g\n", prefix, atts->minDataExtents);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxDataExtents = %g\n", prefix, atts->maxDataExtents);
    str += tmpStr;
    {   const intVector &matRestricted = atts->matRestricted;
        snprintf(tmpStr, 1000, "%smatRestricted = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < matRestricted.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", matRestricted[i]);
            str += tmpStr;
            if(i < matRestricted.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
avtVarMetaData_Notify(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_SetCentering(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    obj->data->centering = (avtCentering)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetCentering(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->centering));
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetHasUnits(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasUnits in the object.
    obj->data->hasUnits = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetHasUnits(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasUnits?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetUnits(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the units in the object.
    obj->data->units = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetUnits(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->units.c_str());
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetHasDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hasDataExtents in the object.
    obj->data->hasDataExtents = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetHasDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hasDataExtents?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetMinDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minDataExtents in the object.
    obj->data->minDataExtents = dval;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetMinDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->minDataExtents);
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetMaxDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxDataExtents in the object.
    obj->data->maxDataExtents = dval;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetMaxDataExtents(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->maxDataExtents);
    return retval;
}

/*static*/ PyObject *
avtVarMetaData_SetMatRestricted(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;

    intVector  &vec = obj->data->matRestricted;
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the matRestricted in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtVarMetaData_GetMatRestricted(PyObject *self, PyObject *args)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the matRestricted.
    const intVector &matRestricted = obj->data->matRestricted;
    PyObject *retval = PyTuple_New(matRestricted.size());
    for(size_t i = 0; i < matRestricted.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(matRestricted[i])));
    return retval;
}



PyMethodDef PyavtVarMetaData_methods[AVTVARMETADATA_NMETH] = {
    {"Notify", avtVarMetaData_Notify, METH_VARARGS},
    {"SetCentering", avtVarMetaData_SetCentering, METH_VARARGS},
    {"GetCentering", avtVarMetaData_GetCentering, METH_VARARGS},
    {"SetHasUnits", avtVarMetaData_SetHasUnits, METH_VARARGS},
    {"GetHasUnits", avtVarMetaData_GetHasUnits, METH_VARARGS},
    {"SetUnits", avtVarMetaData_SetUnits, METH_VARARGS},
    {"GetUnits", avtVarMetaData_GetUnits, METH_VARARGS},
    {"SetHasDataExtents", avtVarMetaData_SetHasDataExtents, METH_VARARGS},
    {"GetHasDataExtents", avtVarMetaData_GetHasDataExtents, METH_VARARGS},
    {"SetMinDataExtents", avtVarMetaData_SetMinDataExtents, METH_VARARGS},
    {"GetMinDataExtents", avtVarMetaData_GetMinDataExtents, METH_VARARGS},
    {"SetMaxDataExtents", avtVarMetaData_SetMaxDataExtents, METH_VARARGS},
    {"GetMaxDataExtents", avtVarMetaData_GetMaxDataExtents, METH_VARARGS},
    {"SetMatRestricted", avtVarMetaData_SetMatRestricted, METH_VARARGS},
    {"GetMatRestricted", avtVarMetaData_GetMatRestricted, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtVarMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtVarMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtBaseVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtVarMetaData_methods[i] = PyavtBaseVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtVarMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtVarMetaData_dealloc(PyObject *v)
{
   avtVarMetaDataObject *obj = (avtVarMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtVarMetaData_compare(PyObject *v, PyObject *w)
{
    avtVarMetaData *a = ((avtVarMetaDataObject *)v)->data;
    avtVarMetaData *b = ((avtVarMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtVarMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "centering") == 0)
        return avtVarMetaData_GetCentering(self, NULL);
    if(strcmp(name, "AVT_NODECENT") == 0)
        return PyInt_FromLong(long(AVT_NODECENT));
    else if(strcmp(name, "AVT_ZONECENT") == 0)
        return PyInt_FromLong(long(AVT_ZONECENT));
    else if(strcmp(name, "AVT_NO_VARIABLE") == 0)
        return PyInt_FromLong(long(AVT_NO_VARIABLE));
    else if(strcmp(name, "AVT_UNKNOWN_CENT") == 0)
        return PyInt_FromLong(long(AVT_UNKNOWN_CENT));

    if(strcmp(name, "hasUnits") == 0)
        return avtVarMetaData_GetHasUnits(self, NULL);
    if(strcmp(name, "units") == 0)
        return avtVarMetaData_GetUnits(self, NULL);
    if(strcmp(name, "hasDataExtents") == 0)
        return avtVarMetaData_GetHasDataExtents(self, NULL);
    if(strcmp(name, "minDataExtents") == 0)
        return avtVarMetaData_GetMinDataExtents(self, NULL);
    if(strcmp(name, "maxDataExtents") == 0)
        return avtVarMetaData_GetMaxDataExtents(self, NULL);
    if(strcmp(name, "matRestricted") == 0)
        return avtVarMetaData_GetMatRestricted(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtBaseVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtVarMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtVarMetaData_methods, self, name);
}

int
PyavtVarMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtBaseVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "centering") == 0)
        obj = avtVarMetaData_SetCentering(self, tuple);
    else if(strcmp(name, "hasUnits") == 0)
        obj = avtVarMetaData_SetHasUnits(self, tuple);
    else if(strcmp(name, "units") == 0)
        obj = avtVarMetaData_SetUnits(self, tuple);
    else if(strcmp(name, "hasDataExtents") == 0)
        obj = avtVarMetaData_SetHasDataExtents(self, tuple);
    else if(strcmp(name, "minDataExtents") == 0)
        obj = avtVarMetaData_SetMinDataExtents(self, tuple);
    else if(strcmp(name, "maxDataExtents") == 0)
        obj = avtVarMetaData_SetMaxDataExtents(self, tuple);
    else if(strcmp(name, "matRestricted") == 0)
        obj = avtVarMetaData_SetMatRestricted(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtVarMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)v;
    fprintf(fp, "%s", PyavtVarMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtVarMetaData_str(PyObject *v)
{
    avtVarMetaDataObject *obj = (avtVarMetaDataObject *)v;
    return PyString_FromString(PyavtVarMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtVarMetaData_Purpose = "Contains metadata attributes associated with all mesh variables";
#else
static char *avtVarMetaData_Purpose = "Contains metadata attributes associated with all mesh variables";
#endif

//
// The type description structure
//
static PyTypeObject avtVarMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtVarMetaData",                    // tp_name
    sizeof(avtVarMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtVarMetaData_dealloc,  // tp_dealloc
    (printfunc)avtVarMetaData_print,     // tp_print
    (getattrfunc)PyavtVarMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtVarMetaData_setattr, // tp_setattr
    (cmpfunc)avtVarMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtVarMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtVarMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtVarMetaData *defaultAtts = 0;
static avtVarMetaData *currentAtts = 0;

static PyObject *
NewavtVarMetaData(int useCurrent)
{
    avtVarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtVarMetaDataObject, &avtVarMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtVarMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtVarMetaData(*defaultAtts);
    else
        newObject->data = new avtVarMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtVarMetaData(const avtVarMetaData *attr)
{
    avtVarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtVarMetaDataObject, &avtVarMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtVarMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtVarMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtVarMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtVarMetaDataMethods[] = {
    {"avtVarMetaData", avtVarMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtVarMetaDataObserver = 0;

std::string
PyavtVarMetaData_GetLogString()
{
    std::string s("avtVarMetaData = avtVarMetaData()\n");
    if(currentAtts != 0)
        s += PyavtVarMetaData_ToString(currentAtts, "avtVarMetaData.");
    return s;
}

static void
PyavtVarMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtVarMetaData = avtVarMetaData()\n");
        s += PyavtVarMetaData_ToString(currentAtts, "avtVarMetaData.");
        cb(s);
    }
}

void
PyavtVarMetaData_StartUp(avtVarMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtVarMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtVarMetaDataObserver == 0)
    {
        avtVarMetaDataObserver = new ObserverToCallback(subj,
            PyavtVarMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtVarMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtVarMetaDataObserver;
    avtVarMetaDataObserver = 0;
}

PyMethodDef *
PyavtVarMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtVarMetaDataMethods;
}

bool
PyavtVarMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtVarMetaDataType);
}

avtVarMetaData *
PyavtVarMetaData_FromPyObject(PyObject *obj)
{
    avtVarMetaDataObject *obj2 = (avtVarMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtVarMetaData_New()
{
    return NewavtVarMetaData(0);
}

PyObject *
PyavtVarMetaData_Wrap(const avtVarMetaData *attr)
{
    return WrapavtVarMetaData(attr);
}

void
PyavtVarMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtVarMetaDataObject *obj2 = (avtVarMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtVarMetaData_SetDefaults(const avtVarMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtVarMetaData(*atts);
}

