// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyavtMaterialMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyavtMaterialMetaData
//
// Purpose:
//   Contains material metadata attributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtMaterialMetaData.
//
struct avtMaterialMetaDataObject
{
    PyObject_HEAD
    avtMaterialMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtMaterialMetaData(int);

std::string
PyavtMaterialMetaData_ToString(const avtMaterialMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    str = PyavtBaseVarMetaData_ToString(atts, prefix);

    snprintf(tmpStr, 1000, "%snumMaterials = %d\n", prefix, atts->numMaterials);
    str += tmpStr;
    {   const stringVector &materialNames = atts->materialNames;
        snprintf(tmpStr, 1000, "%smaterialNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < materialNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", materialNames[i].c_str());
            str += tmpStr;
            if(i < materialNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &colorNames = atts->colorNames;
        snprintf(tmpStr, 1000, "%scolorNames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < colorNames.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", colorNames[i].c_str());
            str += tmpStr;
            if(i < colorNames.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
avtMaterialMetaData_Notify(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMaterialMetaData_SetNumMaterials(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numMaterials in the object.
    obj->data->numMaterials = (int)ival;

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMaterialMetaData_GetNumMaterials(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->numMaterials));
    return retval;
}

/*static*/ PyObject *
avtMaterialMetaData_SetMaterialNames(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;

    stringVector  &vec = obj->data->materialNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the materialNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMaterialMetaData_GetMaterialNames(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the materialNames.
    const stringVector &materialNames = obj->data->materialNames;
    PyObject *retval = PyTuple_New(materialNames.size());
    for(size_t i = 0; i < materialNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(materialNames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
avtMaterialMetaData_SetColorNames(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;

    stringVector  &vec = obj->data->colorNames;
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the colorNames in the object as modified.
    obj->data->SelectAll();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtMaterialMetaData_GetColorNames(PyObject *self, PyObject *args)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)self;
    // Allocate a tuple the with enough entries to hold the colorNames.
    const stringVector &colorNames = obj->data->colorNames;
    PyObject *retval = PyTuple_New(colorNames.size());
    for(size_t i = 0; i < colorNames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(colorNames[i].c_str()));
    return retval;
}



PyMethodDef PyavtMaterialMetaData_methods[AVTMATERIALMETADATA_NMETH] = {
    {"Notify", avtMaterialMetaData_Notify, METH_VARARGS},
    {"SetNumMaterials", avtMaterialMetaData_SetNumMaterials, METH_VARARGS},
    {"GetNumMaterials", avtMaterialMetaData_GetNumMaterials, METH_VARARGS},
    {"SetMaterialNames", avtMaterialMetaData_SetMaterialNames, METH_VARARGS},
    {"GetMaterialNames", avtMaterialMetaData_GetMaterialNames, METH_VARARGS},
    {"SetColorNames", avtMaterialMetaData_SetColorNames, METH_VARARGS},
    {"GetColorNames", avtMaterialMetaData_GetColorNames, METH_VARARGS},
    {NULL, NULL}
};

static void PyavtMaterialMetaData_ExtendSetGetMethodTable()
{
    static bool extended = false;
    if (extended) return;
    extended = true;

    int i = 0;
    while (PyavtMaterialMetaData_methods[i].ml_name)
        i++;
    int n = i;
    while (PyavtBaseVarMetaData_methods[i-n+1].ml_name)
    {
        PyavtMaterialMetaData_methods[i] = PyavtBaseVarMetaData_methods[i-n+1];
        i++;
    }

    PyMethodDef nullMethod = {NULL, NULL};
    PyavtMaterialMetaData_methods[i] = nullMethod;
}

//
// Type functions
//

static void
avtMaterialMetaData_dealloc(PyObject *v)
{
   avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtMaterialMetaData_compare(PyObject *v, PyObject *w)
{
    avtMaterialMetaData *a = ((avtMaterialMetaDataObject *)v)->data;
    avtMaterialMetaData *b = ((avtMaterialMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtMaterialMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "numMaterials") == 0)
        return avtMaterialMetaData_GetNumMaterials(self, NULL);
    if(strcmp(name, "materialNames") == 0)
        return avtMaterialMetaData_GetMaterialNames(self, NULL);
    if(strcmp(name, "colorNames") == 0)
        return avtMaterialMetaData_GetColorNames(self, NULL);

    if(strcmp(name, "__methods__") != 0)
    {
        PyObject *retval = PyavtBaseVarMetaData_getattr(self, name);
        if (retval) return retval;
    }

    PyavtMaterialMetaData_ExtendSetGetMethodTable();

    return Py_FindMethod(PyavtMaterialMetaData_methods, self, name);
}

int
PyavtMaterialMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    if (PyavtBaseVarMetaData_setattr(self, name, args) != -1)
        return 0;
    else
        PyErr_Clear();

    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "numMaterials") == 0)
        obj = avtMaterialMetaData_SetNumMaterials(self, tuple);
    else if(strcmp(name, "materialNames") == 0)
        obj = avtMaterialMetaData_SetMaterialNames(self, tuple);
    else if(strcmp(name, "colorNames") == 0)
        obj = avtMaterialMetaData_SetColorNames(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtMaterialMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)v;
    fprintf(fp, "%s", PyavtMaterialMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtMaterialMetaData_str(PyObject *v)
{
    avtMaterialMetaDataObject *obj = (avtMaterialMetaDataObject *)v;
    return PyString_FromString(PyavtMaterialMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtMaterialMetaData_Purpose = "Contains material metadata attributes";
#else
static char *avtMaterialMetaData_Purpose = "Contains material metadata attributes";
#endif

//
// The type description structure
//
static PyTypeObject avtMaterialMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtMaterialMetaData",                    // tp_name
    sizeof(avtMaterialMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtMaterialMetaData_dealloc,  // tp_dealloc
    (printfunc)avtMaterialMetaData_print,     // tp_print
    (getattrfunc)PyavtMaterialMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtMaterialMetaData_setattr, // tp_setattr
    (cmpfunc)avtMaterialMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtMaterialMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtMaterialMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtMaterialMetaData *defaultAtts = 0;
static avtMaterialMetaData *currentAtts = 0;

static PyObject *
NewavtMaterialMetaData(int useCurrent)
{
    avtMaterialMetaDataObject *newObject;
    newObject = PyObject_NEW(avtMaterialMetaDataObject, &avtMaterialMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtMaterialMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtMaterialMetaData(*defaultAtts);
    else
        newObject->data = new avtMaterialMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtMaterialMetaData(const avtMaterialMetaData *attr)
{
    avtMaterialMetaDataObject *newObject;
    newObject = PyObject_NEW(avtMaterialMetaDataObject, &avtMaterialMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtMaterialMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtMaterialMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtMaterialMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtMaterialMetaDataMethods[] = {
    {"avtMaterialMetaData", avtMaterialMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtMaterialMetaDataObserver = 0;

std::string
PyavtMaterialMetaData_GetLogString()
{
    std::string s("avtMaterialMetaData = avtMaterialMetaData()\n");
    if(currentAtts != 0)
        s += PyavtMaterialMetaData_ToString(currentAtts, "avtMaterialMetaData.");
    return s;
}

static void
PyavtMaterialMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtMaterialMetaData = avtMaterialMetaData()\n");
        s += PyavtMaterialMetaData_ToString(currentAtts, "avtMaterialMetaData.");
        cb(s);
    }
}

void
PyavtMaterialMetaData_StartUp(avtMaterialMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtMaterialMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtMaterialMetaDataObserver == 0)
    {
        avtMaterialMetaDataObserver = new ObserverToCallback(subj,
            PyavtMaterialMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtMaterialMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtMaterialMetaDataObserver;
    avtMaterialMetaDataObserver = 0;
}

PyMethodDef *
PyavtMaterialMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtMaterialMetaDataMethods;
}

bool
PyavtMaterialMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtMaterialMetaDataType);
}

avtMaterialMetaData *
PyavtMaterialMetaData_FromPyObject(PyObject *obj)
{
    avtMaterialMetaDataObject *obj2 = (avtMaterialMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtMaterialMetaData_New()
{
    return NewavtMaterialMetaData(0);
}

PyObject *
PyavtMaterialMetaData_Wrap(const avtMaterialMetaData *attr)
{
    return WrapavtMaterialMetaData(attr);
}

void
PyavtMaterialMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtMaterialMetaDataObject *obj2 = (avtMaterialMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtMaterialMetaData_SetDefaults(const avtMaterialMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtMaterialMetaData(*atts);
}

