// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyavtBaseVarMetaData.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyavtBaseVarMetaData
//
// Purpose:
//   Contains metadata attributes associated with all mesh variables
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a avtBaseVarMetaData.
//
struct avtBaseVarMetaDataObject
{
    PyObject_HEAD
    avtBaseVarMetaData *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewavtBaseVarMetaData(int);

std::string
PyavtBaseVarMetaData_ToString(const avtBaseVarMetaData *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->name.c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%soriginalName = \"%s\"\n", prefix, atts->originalName.c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smeshName = \"%s\"\n", prefix, atts->meshName.c_str());
    str += tmpStr;
    if(atts->validVariable)
        snprintf(tmpStr, 1000, "%svalidVariable = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svalidVariable = 0\n", prefix);
    str += tmpStr;
    if(atts->hideFromGUI)
        snprintf(tmpStr, 1000, "%shideFromGUI = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%shideFromGUI = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
avtBaseVarMetaData_Notify(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_SetName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->name = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_GetName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->name.c_str());
    return retval;
}

/*static*/ PyObject *
avtBaseVarMetaData_SetOriginalName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the originalName in the object.
    obj->data->originalName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_GetOriginalName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->originalName.c_str());
    return retval;
}

/*static*/ PyObject *
avtBaseVarMetaData_SetMeshName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the meshName in the object.
    obj->data->meshName = std::string(str);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_GetMeshName(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    PyObject *retval = PyString_FromString(obj->data->meshName.c_str());
    return retval;
}

/*static*/ PyObject *
avtBaseVarMetaData_SetValidVariable(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the validVariable in the object.
    obj->data->validVariable = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_GetValidVariable(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->validVariable?1L:0L);
    return retval;
}

/*static*/ PyObject *
avtBaseVarMetaData_SetHideFromGUI(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the hideFromGUI in the object.
    obj->data->hideFromGUI = (ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
avtBaseVarMetaData_GetHideFromGUI(PyObject *self, PyObject *args)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->hideFromGUI?1L:0L);
    return retval;
}



PyMethodDef PyavtBaseVarMetaData_methods[AVTBASEVARMETADATA_NMETH] = {
    {"Notify", avtBaseVarMetaData_Notify, METH_VARARGS},
    {"SetName", avtBaseVarMetaData_SetName, METH_VARARGS},
    {"GetName", avtBaseVarMetaData_GetName, METH_VARARGS},
    {"SetOriginalName", avtBaseVarMetaData_SetOriginalName, METH_VARARGS},
    {"GetOriginalName", avtBaseVarMetaData_GetOriginalName, METH_VARARGS},
    {"SetMeshName", avtBaseVarMetaData_SetMeshName, METH_VARARGS},
    {"GetMeshName", avtBaseVarMetaData_GetMeshName, METH_VARARGS},
    {"SetValidVariable", avtBaseVarMetaData_SetValidVariable, METH_VARARGS},
    {"GetValidVariable", avtBaseVarMetaData_GetValidVariable, METH_VARARGS},
    {"SetHideFromGUI", avtBaseVarMetaData_SetHideFromGUI, METH_VARARGS},
    {"GetHideFromGUI", avtBaseVarMetaData_GetHideFromGUI, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
avtBaseVarMetaData_dealloc(PyObject *v)
{
   avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
avtBaseVarMetaData_compare(PyObject *v, PyObject *w)
{
    avtBaseVarMetaData *a = ((avtBaseVarMetaDataObject *)v)->data;
    avtBaseVarMetaData *b = ((avtBaseVarMetaDataObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyavtBaseVarMetaData_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return avtBaseVarMetaData_GetName(self, NULL);
    if(strcmp(name, "originalName") == 0)
        return avtBaseVarMetaData_GetOriginalName(self, NULL);
    if(strcmp(name, "meshName") == 0)
        return avtBaseVarMetaData_GetMeshName(self, NULL);
    if(strcmp(name, "validVariable") == 0)
        return avtBaseVarMetaData_GetValidVariable(self, NULL);
    if(strcmp(name, "hideFromGUI") == 0)
        return avtBaseVarMetaData_GetHideFromGUI(self, NULL);

    return Py_FindMethod(PyavtBaseVarMetaData_methods, self, name);
}

int
PyavtBaseVarMetaData_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = avtBaseVarMetaData_SetName(self, tuple);
    else if(strcmp(name, "originalName") == 0)
        obj = avtBaseVarMetaData_SetOriginalName(self, tuple);
    else if(strcmp(name, "meshName") == 0)
        obj = avtBaseVarMetaData_SetMeshName(self, tuple);
    else if(strcmp(name, "validVariable") == 0)
        obj = avtBaseVarMetaData_SetValidVariable(self, tuple);
    else if(strcmp(name, "hideFromGUI") == 0)
        obj = avtBaseVarMetaData_SetHideFromGUI(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
avtBaseVarMetaData_print(PyObject *v, FILE *fp, int flags)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)v;
    fprintf(fp, "%s", PyavtBaseVarMetaData_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
avtBaseVarMetaData_str(PyObject *v)
{
    avtBaseVarMetaDataObject *obj = (avtBaseVarMetaDataObject *)v;
    return PyString_FromString(PyavtBaseVarMetaData_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *avtBaseVarMetaData_Purpose = "Contains metadata attributes associated with all mesh variables";
#else
static char *avtBaseVarMetaData_Purpose = "Contains metadata attributes associated with all mesh variables";
#endif

//
// The type description structure
//
static PyTypeObject avtBaseVarMetaDataType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "avtBaseVarMetaData",                    // tp_name
    sizeof(avtBaseVarMetaDataObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)avtBaseVarMetaData_dealloc,  // tp_dealloc
    (printfunc)avtBaseVarMetaData_print,     // tp_print
    (getattrfunc)PyavtBaseVarMetaData_getattr, // tp_getattr
    (setattrfunc)PyavtBaseVarMetaData_setattr, // tp_setattr
    (cmpfunc)avtBaseVarMetaData_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)avtBaseVarMetaData_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    avtBaseVarMetaData_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static avtBaseVarMetaData *defaultAtts = 0;
static avtBaseVarMetaData *currentAtts = 0;

static PyObject *
NewavtBaseVarMetaData(int useCurrent)
{
    avtBaseVarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtBaseVarMetaDataObject, &avtBaseVarMetaDataType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new avtBaseVarMetaData(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new avtBaseVarMetaData(*defaultAtts);
    else
        newObject->data = new avtBaseVarMetaData;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapavtBaseVarMetaData(const avtBaseVarMetaData *attr)
{
    avtBaseVarMetaDataObject *newObject;
    newObject = PyObject_NEW(avtBaseVarMetaDataObject, &avtBaseVarMetaDataType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (avtBaseVarMetaData *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
avtBaseVarMetaData_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewavtBaseVarMetaData(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef avtBaseVarMetaDataMethods[] = {
    {"avtBaseVarMetaData", avtBaseVarMetaData_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *avtBaseVarMetaDataObserver = 0;

std::string
PyavtBaseVarMetaData_GetLogString()
{
    std::string s("avtBaseVarMetaData = avtBaseVarMetaData()\n");
    if(currentAtts != 0)
        s += PyavtBaseVarMetaData_ToString(currentAtts, "avtBaseVarMetaData.");
    return s;
}

static void
PyavtBaseVarMetaData_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("avtBaseVarMetaData = avtBaseVarMetaData()\n");
        s += PyavtBaseVarMetaData_ToString(currentAtts, "avtBaseVarMetaData.");
        cb(s);
    }
}

void
PyavtBaseVarMetaData_StartUp(avtBaseVarMetaData *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyavtBaseVarMetaData_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(avtBaseVarMetaDataObserver == 0)
    {
        avtBaseVarMetaDataObserver = new ObserverToCallback(subj,
            PyavtBaseVarMetaData_CallLogRoutine, (void *)data);
    }

}

void
PyavtBaseVarMetaData_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete avtBaseVarMetaDataObserver;
    avtBaseVarMetaDataObserver = 0;
}

PyMethodDef *
PyavtBaseVarMetaData_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return avtBaseVarMetaDataMethods;
}

bool
PyavtBaseVarMetaData_Check(PyObject *obj)
{
    return (obj->ob_type == &avtBaseVarMetaDataType);
}

avtBaseVarMetaData *
PyavtBaseVarMetaData_FromPyObject(PyObject *obj)
{
    avtBaseVarMetaDataObject *obj2 = (avtBaseVarMetaDataObject *)obj;
    return obj2->data;
}

PyObject *
PyavtBaseVarMetaData_New()
{
    return NewavtBaseVarMetaData(0);
}

PyObject *
PyavtBaseVarMetaData_Wrap(const avtBaseVarMetaData *attr)
{
    return WrapavtBaseVarMetaData(attr);
}

void
PyavtBaseVarMetaData_SetParent(PyObject *obj, PyObject *parent)
{
    avtBaseVarMetaDataObject *obj2 = (avtBaseVarMetaDataObject *)obj;
    obj2->parent = parent;
}

void
PyavtBaseVarMetaData_SetDefaults(const avtBaseVarMetaData *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new avtBaseVarMetaData(*atts);
}

