// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyViewerClientAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyViewerClientAttributes
//
// Purpose:
//   This class contains attributes used for viewer client
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewerClientAttributes.
//
struct ViewerClientAttributesObject
{
    PyObject_HEAD
    ViewerClientAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewViewerClientAttributes(int);

std::string
PyViewerClientAttributes_ToString(const ViewerClientAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *renderingType_names = "None, Image, Data";
    switch (atts->GetRenderingType())
    {
      case ViewerClientAttributes::None:
          snprintf(tmpStr, 1000, "%srenderingType = %sNone  # %s\n", prefix, prefix, renderingType_names);
          str += tmpStr;
          break;
      case ViewerClientAttributes::Image:
          snprintf(tmpStr, 1000, "%srenderingType = %sImage  # %s\n", prefix, prefix, renderingType_names);
          str += tmpStr;
          break;
      case ViewerClientAttributes::Data:
          snprintf(tmpStr, 1000, "%srenderingType = %sData  # %s\n", prefix, prefix, renderingType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sid = %d\n", prefix, atts->GetId());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stitle = \"%s\"\n", prefix, atts->GetTitle().c_str());
    str += tmpStr;
    {   const intVector &windowIds = atts->GetWindowIds();
        snprintf(tmpStr, 1000, "%swindowIds = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < windowIds.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", windowIds[i]);
            str += tmpStr;
            if(i < windowIds.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%simageWidth = %d\n", prefix, atts->GetImageWidth());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%simageHeight = %d\n", prefix, atts->GetImageHeight());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%simageResolutionPcnt = %g\n", prefix, atts->GetImageResolutionPcnt());
    str += tmpStr;
    if(atts->GetExternalClient())
        snprintf(tmpStr, 1000, "%sexternalClient = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sexternalClient = 0\n", prefix);
    str += tmpStr;
    {   const intVector &renderingTypes = atts->GetRenderingTypes();
        snprintf(tmpStr, 1000, "%srenderingTypes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < renderingTypes.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", renderingTypes[i]);
            str += tmpStr;
            if(i < renderingTypes.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ViewerClientAttributes_Notify(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_SetRenderingType(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the renderingType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetRenderingType(ViewerClientAttributes::RenderType(ival));
    else
    {
        fprintf(stderr, "An invalid renderingType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "None, Image, Data.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetRenderingType(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRenderingType()));
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetId(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the id in the object.
    obj->data->SetId((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetId(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetId()));
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetTitle(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the title in the object.
    obj->data->SetTitle(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetTitle(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTitle().c_str());
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetWindowIds(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    intVector  &vec = obj->data->GetWindowIds();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the windowIds in the object as modified.
    obj->data->SelectWindowIds();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetWindowIds(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the windowIds.
    const intVector &windowIds = obj->data->GetWindowIds();
    PyObject *retval = PyTuple_New(windowIds.size());
    for(size_t i = 0; i < windowIds.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(windowIds[i])));
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetImageWidth(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the imageWidth in the object.
    obj->data->SetImageWidth((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetImageWidth(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetImageWidth()));
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetImageHeight(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the imageHeight in the object.
    obj->data->SetImageHeight((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetImageHeight(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetImageHeight()));
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetImageResolutionPcnt(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the imageResolutionPcnt in the object.
    obj->data->SetImageResolutionPcnt(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetImageResolutionPcnt(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetImageResolutionPcnt());
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetExternalClient(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the externalClient in the object.
    obj->data->SetExternalClient(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetExternalClient(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetExternalClient()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ViewerClientAttributes_SetRenderingTypes(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;

    intVector  &vec = obj->data->GetRenderingTypes();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the renderingTypes in the object as modified.
    obj->data->SelectRenderingTypes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewerClientAttributes_GetRenderingTypes(PyObject *self, PyObject *args)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the renderingTypes.
    const intVector &renderingTypes = obj->data->GetRenderingTypes();
    PyObject *retval = PyTuple_New(renderingTypes.size());
    for(size_t i = 0; i < renderingTypes.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(renderingTypes[i])));
    return retval;
}



PyMethodDef PyViewerClientAttributes_methods[VIEWERCLIENTATTRIBUTES_NMETH] = {
    {"Notify", ViewerClientAttributes_Notify, METH_VARARGS},
    {"SetRenderingType", ViewerClientAttributes_SetRenderingType, METH_VARARGS},
    {"GetRenderingType", ViewerClientAttributes_GetRenderingType, METH_VARARGS},
    {"SetId", ViewerClientAttributes_SetId, METH_VARARGS},
    {"GetId", ViewerClientAttributes_GetId, METH_VARARGS},
    {"SetTitle", ViewerClientAttributes_SetTitle, METH_VARARGS},
    {"GetTitle", ViewerClientAttributes_GetTitle, METH_VARARGS},
    {"SetWindowIds", ViewerClientAttributes_SetWindowIds, METH_VARARGS},
    {"GetWindowIds", ViewerClientAttributes_GetWindowIds, METH_VARARGS},
    {"SetImageWidth", ViewerClientAttributes_SetImageWidth, METH_VARARGS},
    {"GetImageWidth", ViewerClientAttributes_GetImageWidth, METH_VARARGS},
    {"SetImageHeight", ViewerClientAttributes_SetImageHeight, METH_VARARGS},
    {"GetImageHeight", ViewerClientAttributes_GetImageHeight, METH_VARARGS},
    {"SetImageResolutionPcnt", ViewerClientAttributes_SetImageResolutionPcnt, METH_VARARGS},
    {"GetImageResolutionPcnt", ViewerClientAttributes_GetImageResolutionPcnt, METH_VARARGS},
    {"SetExternalClient", ViewerClientAttributes_SetExternalClient, METH_VARARGS},
    {"GetExternalClient", ViewerClientAttributes_GetExternalClient, METH_VARARGS},
    {"SetRenderingTypes", ViewerClientAttributes_SetRenderingTypes, METH_VARARGS},
    {"GetRenderingTypes", ViewerClientAttributes_GetRenderingTypes, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewerClientAttributes_dealloc(PyObject *v)
{
   ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ViewerClientAttributes_compare(PyObject *v, PyObject *w)
{
    ViewerClientAttributes *a = ((ViewerClientAttributesObject *)v)->data;
    ViewerClientAttributes *b = ((ViewerClientAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyViewerClientAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "renderingType") == 0)
        return ViewerClientAttributes_GetRenderingType(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(ViewerClientAttributes::None));
    if(strcmp(name, "Image") == 0)
        return PyInt_FromLong(long(ViewerClientAttributes::Image));
    if(strcmp(name, "Data") == 0)
        return PyInt_FromLong(long(ViewerClientAttributes::Data));

    if(strcmp(name, "id") == 0)
        return ViewerClientAttributes_GetId(self, NULL);
    if(strcmp(name, "title") == 0)
        return ViewerClientAttributes_GetTitle(self, NULL);
    if(strcmp(name, "windowIds") == 0)
        return ViewerClientAttributes_GetWindowIds(self, NULL);
    if(strcmp(name, "imageWidth") == 0)
        return ViewerClientAttributes_GetImageWidth(self, NULL);
    if(strcmp(name, "imageHeight") == 0)
        return ViewerClientAttributes_GetImageHeight(self, NULL);
    if(strcmp(name, "imageResolutionPcnt") == 0)
        return ViewerClientAttributes_GetImageResolutionPcnt(self, NULL);
    if(strcmp(name, "externalClient") == 0)
        return ViewerClientAttributes_GetExternalClient(self, NULL);
    if(strcmp(name, "renderingTypes") == 0)
        return ViewerClientAttributes_GetRenderingTypes(self, NULL);

    return Py_FindMethod(PyViewerClientAttributes_methods, self, name);
}

int
PyViewerClientAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "renderingType") == 0)
        obj = ViewerClientAttributes_SetRenderingType(self, tuple);
    else if(strcmp(name, "id") == 0)
        obj = ViewerClientAttributes_SetId(self, tuple);
    else if(strcmp(name, "title") == 0)
        obj = ViewerClientAttributes_SetTitle(self, tuple);
    else if(strcmp(name, "windowIds") == 0)
        obj = ViewerClientAttributes_SetWindowIds(self, tuple);
    else if(strcmp(name, "imageWidth") == 0)
        obj = ViewerClientAttributes_SetImageWidth(self, tuple);
    else if(strcmp(name, "imageHeight") == 0)
        obj = ViewerClientAttributes_SetImageHeight(self, tuple);
    else if(strcmp(name, "imageResolutionPcnt") == 0)
        obj = ViewerClientAttributes_SetImageResolutionPcnt(self, tuple);
    else if(strcmp(name, "externalClient") == 0)
        obj = ViewerClientAttributes_SetExternalClient(self, tuple);
    else if(strcmp(name, "renderingTypes") == 0)
        obj = ViewerClientAttributes_SetRenderingTypes(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ViewerClientAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)v;
    fprintf(fp, "%s", PyViewerClientAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ViewerClientAttributes_str(PyObject *v)
{
    ViewerClientAttributesObject *obj = (ViewerClientAttributesObject *)v;
    return PyString_FromString(PyViewerClientAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ViewerClientAttributes_Purpose = "This class contains attributes used for viewer client";
#else
static char *ViewerClientAttributes_Purpose = "This class contains attributes used for viewer client";
#endif

//
// The type description structure
//
static PyTypeObject ViewerClientAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewerClientAttributes",                    // tp_name
    sizeof(ViewerClientAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewerClientAttributes_dealloc,  // tp_dealloc
    (printfunc)ViewerClientAttributes_print,     // tp_print
    (getattrfunc)PyViewerClientAttributes_getattr, // tp_getattr
    (setattrfunc)PyViewerClientAttributes_setattr, // tp_setattr
    (cmpfunc)ViewerClientAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ViewerClientAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewerClientAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewerClientAttributes *defaultAtts = 0;
static ViewerClientAttributes *currentAtts = 0;

static PyObject *
NewViewerClientAttributes(int useCurrent)
{
    ViewerClientAttributesObject *newObject;
    newObject = PyObject_NEW(ViewerClientAttributesObject, &ViewerClientAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ViewerClientAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ViewerClientAttributes(*defaultAtts);
    else
        newObject->data = new ViewerClientAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewerClientAttributes(const ViewerClientAttributes *attr)
{
    ViewerClientAttributesObject *newObject;
    newObject = PyObject_NEW(ViewerClientAttributesObject, &ViewerClientAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewerClientAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewerClientAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewViewerClientAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewerClientAttributesMethods[] = {
    {"ViewerClientAttributes", ViewerClientAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewerClientAttributesObserver = 0;

std::string
PyViewerClientAttributes_GetLogString()
{
    std::string s("ViewerClientAtts = ViewerClientAttributes()\n");
    if(currentAtts != 0)
        s += PyViewerClientAttributes_ToString(currentAtts, "ViewerClientAtts.");
    return s;
}

static void
PyViewerClientAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ViewerClientAtts = ViewerClientAttributes()\n");
        s += PyViewerClientAttributes_ToString(currentAtts, "ViewerClientAtts.");
        cb(s);
    }
}

void
PyViewerClientAttributes_StartUp(ViewerClientAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyViewerClientAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewerClientAttributesObserver == 0)
    {
        ViewerClientAttributesObserver = new ObserverToCallback(subj,
            PyViewerClientAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyViewerClientAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewerClientAttributesObserver;
    ViewerClientAttributesObserver = 0;
}

PyMethodDef *
PyViewerClientAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewerClientAttributesMethods;
}

bool
PyViewerClientAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewerClientAttributesType);
}

ViewerClientAttributes *
PyViewerClientAttributes_FromPyObject(PyObject *obj)
{
    ViewerClientAttributesObject *obj2 = (ViewerClientAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyViewerClientAttributes_New()
{
    return NewViewerClientAttributes(0);
}

PyObject *
PyViewerClientAttributes_Wrap(const ViewerClientAttributes *attr)
{
    return WrapViewerClientAttributes(attr);
}

void
PyViewerClientAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ViewerClientAttributesObject *obj2 = (ViewerClientAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyViewerClientAttributes_SetDefaults(const ViewerClientAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewerClientAttributes(*atts);
}

