// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyViewAxisArrayAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyViewAxisArrayAttributes
//
// Purpose:
//   This class contains the axis array view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ViewAxisArrayAttributes.
//
struct ViewAxisArrayAttributesObject
{
    PyObject_HEAD
    ViewAxisArrayAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewViewAxisArrayAttributes(int);

std::string
PyViewAxisArrayAttributes_ToString(const ViewAxisArrayAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *domainCoords = atts->GetDomainCoords();
        snprintf(tmpStr, 1000, "%sdomainCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            snprintf(tmpStr, 1000, "%g", domainCoords[i]);
            str += tmpStr;
            if(i < 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *rangeCoords = atts->GetRangeCoords();
        snprintf(tmpStr, 1000, "%srangeCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            snprintf(tmpStr, 1000, "%g", rangeCoords[i]);
            str += tmpStr;
            if(i < 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *viewportCoords = atts->GetViewportCoords();
        snprintf(tmpStr, 1000, "%sviewportCoords = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 4; ++i)
        {
            snprintf(tmpStr, 1000, "%g", viewportCoords[i]);
            str += tmpStr;
            if(i < 3)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ViewAxisArrayAttributes_Notify(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_SetDomainCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;

    double *dvals = obj->data->GetDomainCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the domainCoords in the object as modified.
    obj->data->SelectDomainCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_GetDomainCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the domainCoords.
    PyObject *retval = PyTuple_New(2);
    const double *domainCoords = obj->data->GetDomainCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(domainCoords[i]));
    return retval;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_SetRangeCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;

    double *dvals = obj->data->GetRangeCoords();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rangeCoords in the object as modified.
    obj->data->SelectRangeCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_GetRangeCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rangeCoords.
    PyObject *retval = PyTuple_New(2);
    const double *rangeCoords = obj->data->GetRangeCoords();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rangeCoords[i]));
    return retval;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_SetViewportCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;

    double *dvals = obj->data->GetViewportCoords();
    if(!PyArg_ParseTuple(args, "dddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewportCoords in the object as modified.
    obj->data->SelectViewportCoords();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ViewAxisArrayAttributes_GetViewportCoords(PyObject *self, PyObject *args)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewportCoords.
    PyObject *retval = PyTuple_New(4);
    const double *viewportCoords = obj->data->GetViewportCoords();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewportCoords[i]));
    return retval;
}



PyMethodDef PyViewAxisArrayAttributes_methods[VIEWAXISARRAYATTRIBUTES_NMETH] = {
    {"Notify", ViewAxisArrayAttributes_Notify, METH_VARARGS},
    {"SetDomainCoords", ViewAxisArrayAttributes_SetDomainCoords, METH_VARARGS},
    {"GetDomainCoords", ViewAxisArrayAttributes_GetDomainCoords, METH_VARARGS},
    {"SetRangeCoords", ViewAxisArrayAttributes_SetRangeCoords, METH_VARARGS},
    {"GetRangeCoords", ViewAxisArrayAttributes_GetRangeCoords, METH_VARARGS},
    {"SetViewportCoords", ViewAxisArrayAttributes_SetViewportCoords, METH_VARARGS},
    {"GetViewportCoords", ViewAxisArrayAttributes_GetViewportCoords, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ViewAxisArrayAttributes_dealloc(PyObject *v)
{
   ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ViewAxisArrayAttributes_compare(PyObject *v, PyObject *w)
{
    ViewAxisArrayAttributes *a = ((ViewAxisArrayAttributesObject *)v)->data;
    ViewAxisArrayAttributes *b = ((ViewAxisArrayAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyViewAxisArrayAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "domainCoords") == 0)
        return ViewAxisArrayAttributes_GetDomainCoords(self, NULL);
    if(strcmp(name, "rangeCoords") == 0)
        return ViewAxisArrayAttributes_GetRangeCoords(self, NULL);
    if(strcmp(name, "viewportCoords") == 0)
        return ViewAxisArrayAttributes_GetViewportCoords(self, NULL);

    return Py_FindMethod(PyViewAxisArrayAttributes_methods, self, name);
}

int
PyViewAxisArrayAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "domainCoords") == 0)
        obj = ViewAxisArrayAttributes_SetDomainCoords(self, tuple);
    else if(strcmp(name, "rangeCoords") == 0)
        obj = ViewAxisArrayAttributes_SetRangeCoords(self, tuple);
    else if(strcmp(name, "viewportCoords") == 0)
        obj = ViewAxisArrayAttributes_SetViewportCoords(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ViewAxisArrayAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)v;
    fprintf(fp, "%s", PyViewAxisArrayAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ViewAxisArrayAttributes_str(PyObject *v)
{
    ViewAxisArrayAttributesObject *obj = (ViewAxisArrayAttributesObject *)v;
    return PyString_FromString(PyViewAxisArrayAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ViewAxisArrayAttributes_Purpose = "This class contains the axis array view attributes.";
#else
static char *ViewAxisArrayAttributes_Purpose = "This class contains the axis array view attributes.";
#endif

//
// The type description structure
//
static PyTypeObject ViewAxisArrayAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ViewAxisArrayAttributes",                    // tp_name
    sizeof(ViewAxisArrayAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ViewAxisArrayAttributes_dealloc,  // tp_dealloc
    (printfunc)ViewAxisArrayAttributes_print,     // tp_print
    (getattrfunc)PyViewAxisArrayAttributes_getattr, // tp_getattr
    (setattrfunc)PyViewAxisArrayAttributes_setattr, // tp_setattr
    (cmpfunc)ViewAxisArrayAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ViewAxisArrayAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ViewAxisArrayAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ViewAxisArrayAttributes *defaultAtts = 0;
static ViewAxisArrayAttributes *currentAtts = 0;

static PyObject *
NewViewAxisArrayAttributes(int useCurrent)
{
    ViewAxisArrayAttributesObject *newObject;
    newObject = PyObject_NEW(ViewAxisArrayAttributesObject, &ViewAxisArrayAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ViewAxisArrayAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ViewAxisArrayAttributes(*defaultAtts);
    else
        newObject->data = new ViewAxisArrayAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapViewAxisArrayAttributes(const ViewAxisArrayAttributes *attr)
{
    ViewAxisArrayAttributesObject *newObject;
    newObject = PyObject_NEW(ViewAxisArrayAttributesObject, &ViewAxisArrayAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ViewAxisArrayAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ViewAxisArrayAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewViewAxisArrayAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ViewAxisArrayAttributesMethods[] = {
    {"ViewAxisArrayAttributes", ViewAxisArrayAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ViewAxisArrayAttributesObserver = 0;

std::string
PyViewAxisArrayAttributes_GetLogString()
{
    std::string s("ViewAxisArrayAtts = ViewAxisArrayAttributes()\n");
    if(currentAtts != 0)
        s += PyViewAxisArrayAttributes_ToString(currentAtts, "ViewAxisArrayAtts.");
    return s;
}

static void
PyViewAxisArrayAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ViewAxisArrayAtts = ViewAxisArrayAttributes()\n");
        s += PyViewAxisArrayAttributes_ToString(currentAtts, "ViewAxisArrayAtts.");
        cb(s);
    }
}

void
PyViewAxisArrayAttributes_StartUp(ViewAxisArrayAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyViewAxisArrayAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ViewAxisArrayAttributesObserver == 0)
    {
        ViewAxisArrayAttributesObserver = new ObserverToCallback(subj,
            PyViewAxisArrayAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyViewAxisArrayAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ViewAxisArrayAttributesObserver;
    ViewAxisArrayAttributesObserver = 0;
}

PyMethodDef *
PyViewAxisArrayAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ViewAxisArrayAttributesMethods;
}

bool
PyViewAxisArrayAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ViewAxisArrayAttributesType);
}

ViewAxisArrayAttributes *
PyViewAxisArrayAttributes_FromPyObject(PyObject *obj)
{
    ViewAxisArrayAttributesObject *obj2 = (ViewAxisArrayAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyViewAxisArrayAttributes_New()
{
    return NewViewAxisArrayAttributes(0);
}

PyObject *
PyViewAxisArrayAttributes_Wrap(const ViewAxisArrayAttributes *attr)
{
    return WrapViewAxisArrayAttributes(attr);
}

void
PyViewAxisArrayAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ViewAxisArrayAttributesObject *obj2 = (ViewAxisArrayAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyViewAxisArrayAttributes_SetDefaults(const ViewAxisArrayAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ViewAxisArrayAttributes(*atts);
}

