// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PySelectionVariableSummary.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PySelectionVariableSummary
//
// Purpose:
//   Contains a summary of a variable used in a selection
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SelectionVariableSummary.
//
struct SelectionVariableSummaryObject
{
    PyObject_HEAD
    SelectionVariableSummary *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSelectionVariableSummary(int);

std::string
PySelectionVariableSummary_ToString(const SelectionVariableSummary *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sminimum = %g\n", prefix, atts->GetMinimum());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaximum = %g\n", prefix, atts->GetMaximum());
    str += tmpStr;
    {   const double *histogram = atts->GetHistogram();
        snprintf(tmpStr, 1000, "%shistogram = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 256; ++i)
        {
            snprintf(tmpStr, 1000, "%g", histogram[i]);
            str += tmpStr;
            if(i < 255)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
SelectionVariableSummary_Notify(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionVariableSummary_SetName(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionVariableSummary_GetName(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionVariableSummary_SetMinimum(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minimum in the object.
    obj->data->SetMinimum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionVariableSummary_GetMinimum(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinimum());
    return retval;
}

/*static*/ PyObject *
SelectionVariableSummary_SetMaximum(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maximum in the object.
    obj->data->SetMaximum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionVariableSummary_GetMaximum(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaximum());
    return retval;
}

/*static*/ PyObject *
SelectionVariableSummary_SetHistogram(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;

    double *dvals = obj->data->GetHistogram();
    if(!PyArg_ParseTuple(args, "dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", &dvals[0], &dvals[1], &dvals[2], &dvals[3], &dvals[4], &dvals[5], &dvals[6], &dvals[7], &dvals[8], &dvals[9], &dvals[10], &dvals[11], &dvals[12], &dvals[13], &dvals[14], &dvals[15], &dvals[16], &dvals[17], &dvals[18], &dvals[19], &dvals[20], &dvals[21], &dvals[22], &dvals[23], &dvals[24], &dvals[25], &dvals[26], &dvals[27], &dvals[28], &dvals[29], &dvals[30], &dvals[31], &dvals[32], &dvals[33], &dvals[34], &dvals[35], &dvals[36], &dvals[37], &dvals[38], &dvals[39], &dvals[40], &dvals[41], &dvals[42], &dvals[43], &dvals[44], &dvals[45], &dvals[46], &dvals[47], &dvals[48], &dvals[49], &dvals[50], &dvals[51], &dvals[52], &dvals[53], &dvals[54], &dvals[55], &dvals[56], &dvals[57], &dvals[58], &dvals[59], &dvals[60], &dvals[61], &dvals[62], &dvals[63], &dvals[64], &dvals[65], &dvals[66], &dvals[67], &dvals[68], &dvals[69], &dvals[70], &dvals[71], &dvals[72], &dvals[73], &dvals[74], &dvals[75], &dvals[76], &dvals[77], &dvals[78], &dvals[79], &dvals[80], &dvals[81], &dvals[82], &dvals[83], &dvals[84], &dvals[85], &dvals[86], &dvals[87], &dvals[88], &dvals[89], &dvals[90], &dvals[91], &dvals[92], &dvals[93], &dvals[94], &dvals[95], &dvals[96], &dvals[97], &dvals[98], &dvals[99], &dvals[100], &dvals[101], &dvals[102], &dvals[103], &dvals[104], &dvals[105], &dvals[106], &dvals[107], &dvals[108], &dvals[109], &dvals[110], &dvals[111], &dvals[112], &dvals[113], &dvals[114], &dvals[115], &dvals[116], &dvals[117], &dvals[118], &dvals[119], &dvals[120], &dvals[121], &dvals[122], &dvals[123], &dvals[124], &dvals[125], &dvals[126], &dvals[127], &dvals[128], &dvals[129], &dvals[130], &dvals[131], &dvals[132], &dvals[133], &dvals[134], &dvals[135], &dvals[136], &dvals[137], &dvals[138], &dvals[139], &dvals[140], &dvals[141], &dvals[142], &dvals[143], &dvals[144], &dvals[145], &dvals[146], &dvals[147], &dvals[148], &dvals[149], &dvals[150], &dvals[151], &dvals[152], &dvals[153], &dvals[154], &dvals[155], &dvals[156], &dvals[157], &dvals[158], &dvals[159], &dvals[160], &dvals[161], &dvals[162], &dvals[163], &dvals[164], &dvals[165], &dvals[166], &dvals[167], &dvals[168], &dvals[169], &dvals[170], &dvals[171], &dvals[172], &dvals[173], &dvals[174], &dvals[175], &dvals[176], &dvals[177], &dvals[178], &dvals[179], &dvals[180], &dvals[181], &dvals[182], &dvals[183], &dvals[184], &dvals[185], &dvals[186], &dvals[187], &dvals[188], &dvals[189], &dvals[190], &dvals[191], &dvals[192], &dvals[193], &dvals[194], &dvals[195], &dvals[196], &dvals[197], &dvals[198], &dvals[199], &dvals[200], &dvals[201], &dvals[202], &dvals[203], &dvals[204], &dvals[205], &dvals[206], &dvals[207], &dvals[208], &dvals[209], &dvals[210], &dvals[211], &dvals[212], &dvals[213], &dvals[214], &dvals[215], &dvals[216], &dvals[217], &dvals[218], &dvals[219], &dvals[220], &dvals[221], &dvals[222], &dvals[223], &dvals[224], &dvals[225], &dvals[226], &dvals[227], &dvals[228], &dvals[229], &dvals[230], &dvals[231], &dvals[232], &dvals[233], &dvals[234], &dvals[235], &dvals[236], &dvals[237], &dvals[238], &dvals[239], &dvals[240], &dvals[241], &dvals[242], &dvals[243], &dvals[244], &dvals[245], &dvals[246], &dvals[247], &dvals[248], &dvals[249], &dvals[250], &dvals[251], &dvals[252], &dvals[253], &dvals[254], &dvals[255]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 256)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the histogram in the object as modified.
    obj->data->SelectHistogram();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionVariableSummary_GetHistogram(PyObject *self, PyObject *args)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)self;
    // Allocate a tuple the with enough entries to hold the histogram.
    PyObject *retval = PyTuple_New(256);
    const double *histogram = obj->data->GetHistogram();
    for(int i = 0; i < 256; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(histogram[i]));
    return retval;
}



PyMethodDef PySelectionVariableSummary_methods[SELECTIONVARIABLESUMMARY_NMETH] = {
    {"Notify", SelectionVariableSummary_Notify, METH_VARARGS},
    {"SetName", SelectionVariableSummary_SetName, METH_VARARGS},
    {"GetName", SelectionVariableSummary_GetName, METH_VARARGS},
    {"SetMinimum", SelectionVariableSummary_SetMinimum, METH_VARARGS},
    {"GetMinimum", SelectionVariableSummary_GetMinimum, METH_VARARGS},
    {"SetMaximum", SelectionVariableSummary_SetMaximum, METH_VARARGS},
    {"GetMaximum", SelectionVariableSummary_GetMaximum, METH_VARARGS},
    {"SetHistogram", SelectionVariableSummary_SetHistogram, METH_VARARGS},
    {"GetHistogram", SelectionVariableSummary_GetHistogram, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SelectionVariableSummary_dealloc(PyObject *v)
{
   SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SelectionVariableSummary_compare(PyObject *v, PyObject *w)
{
    SelectionVariableSummary *a = ((SelectionVariableSummaryObject *)v)->data;
    SelectionVariableSummary *b = ((SelectionVariableSummaryObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySelectionVariableSummary_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return SelectionVariableSummary_GetName(self, NULL);
    if(strcmp(name, "minimum") == 0)
        return SelectionVariableSummary_GetMinimum(self, NULL);
    if(strcmp(name, "maximum") == 0)
        return SelectionVariableSummary_GetMaximum(self, NULL);
    if(strcmp(name, "histogram") == 0)
        return SelectionVariableSummary_GetHistogram(self, NULL);

    return Py_FindMethod(PySelectionVariableSummary_methods, self, name);
}

int
PySelectionVariableSummary_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = SelectionVariableSummary_SetName(self, tuple);
    else if(strcmp(name, "minimum") == 0)
        obj = SelectionVariableSummary_SetMinimum(self, tuple);
    else if(strcmp(name, "maximum") == 0)
        obj = SelectionVariableSummary_SetMaximum(self, tuple);
    else if(strcmp(name, "histogram") == 0)
        obj = SelectionVariableSummary_SetHistogram(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SelectionVariableSummary_print(PyObject *v, FILE *fp, int flags)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)v;
    fprintf(fp, "%s", PySelectionVariableSummary_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SelectionVariableSummary_str(PyObject *v)
{
    SelectionVariableSummaryObject *obj = (SelectionVariableSummaryObject *)v;
    return PyString_FromString(PySelectionVariableSummary_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SelectionVariableSummary_Purpose = "Contains a summary of a variable used in a selection";
#else
static char *SelectionVariableSummary_Purpose = "Contains a summary of a variable used in a selection";
#endif

//
// The type description structure
//
static PyTypeObject SelectionVariableSummaryType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SelectionVariableSummary",                    // tp_name
    sizeof(SelectionVariableSummaryObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SelectionVariableSummary_dealloc,  // tp_dealloc
    (printfunc)SelectionVariableSummary_print,     // tp_print
    (getattrfunc)PySelectionVariableSummary_getattr, // tp_getattr
    (setattrfunc)PySelectionVariableSummary_setattr, // tp_setattr
    (cmpfunc)SelectionVariableSummary_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SelectionVariableSummary_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SelectionVariableSummary_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SelectionVariableSummary *defaultAtts = 0;
static SelectionVariableSummary *currentAtts = 0;

static PyObject *
NewSelectionVariableSummary(int useCurrent)
{
    SelectionVariableSummaryObject *newObject;
    newObject = PyObject_NEW(SelectionVariableSummaryObject, &SelectionVariableSummaryType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SelectionVariableSummary(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SelectionVariableSummary(*defaultAtts);
    else
        newObject->data = new SelectionVariableSummary;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSelectionVariableSummary(const SelectionVariableSummary *attr)
{
    SelectionVariableSummaryObject *newObject;
    newObject = PyObject_NEW(SelectionVariableSummaryObject, &SelectionVariableSummaryType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SelectionVariableSummary *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SelectionVariableSummary_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSelectionVariableSummary(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SelectionVariableSummaryMethods[] = {
    {"SelectionVariableSummary", SelectionVariableSummary_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SelectionVariableSummaryObserver = 0;

std::string
PySelectionVariableSummary_GetLogString()
{
    std::string s("SelectionVariableSummary = SelectionVariableSummary()\n");
    if(currentAtts != 0)
        s += PySelectionVariableSummary_ToString(currentAtts, "SelectionVariableSummary.");
    return s;
}

static void
PySelectionVariableSummary_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SelectionVariableSummary = SelectionVariableSummary()\n");
        s += PySelectionVariableSummary_ToString(currentAtts, "SelectionVariableSummary.");
        cb(s);
    }
}

void
PySelectionVariableSummary_StartUp(SelectionVariableSummary *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySelectionVariableSummary_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SelectionVariableSummaryObserver == 0)
    {
        SelectionVariableSummaryObserver = new ObserverToCallback(subj,
            PySelectionVariableSummary_CallLogRoutine, (void *)data);
    }

}

void
PySelectionVariableSummary_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SelectionVariableSummaryObserver;
    SelectionVariableSummaryObserver = 0;
}

PyMethodDef *
PySelectionVariableSummary_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SelectionVariableSummaryMethods;
}

bool
PySelectionVariableSummary_Check(PyObject *obj)
{
    return (obj->ob_type == &SelectionVariableSummaryType);
}

SelectionVariableSummary *
PySelectionVariableSummary_FromPyObject(PyObject *obj)
{
    SelectionVariableSummaryObject *obj2 = (SelectionVariableSummaryObject *)obj;
    return obj2->data;
}

PyObject *
PySelectionVariableSummary_New()
{
    return NewSelectionVariableSummary(0);
}

PyObject *
PySelectionVariableSummary_Wrap(const SelectionVariableSummary *attr)
{
    return WrapSelectionVariableSummary(attr);
}

void
PySelectionVariableSummary_SetParent(PyObject *obj, PyObject *parent)
{
    SelectionVariableSummaryObject *obj2 = (SelectionVariableSummaryObject *)obj;
    obj2->parent = parent;
}

void
PySelectionVariableSummary_SetDefaults(const SelectionVariableSummary *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SelectionVariableSummary(*atts);
}

