// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PySelectionProperties.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PySelectionProperties
//
// Purpose:
//   Contains attributes for a selection
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SelectionProperties.
//
struct SelectionPropertiesObject
{
    PyObject_HEAD
    SelectionProperties *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSelectionProperties(int);

std::string
PySelectionProperties_ToString(const SelectionProperties *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssource = \"%s\"\n", prefix, atts->GetSource().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%shost = \"%s\"\n", prefix, atts->GetHost().c_str());
    str += tmpStr;
    const char *selectionType_names = "BasicSelection, CumulativeQuerySelection";
    switch (atts->GetSelectionType())
    {
      case SelectionProperties::BasicSelection:
          snprintf(tmpStr, 1000, "%sselectionType = %sBasicSelection  # %s\n", prefix, prefix, selectionType_names);
          str += tmpStr;
          break;
      case SelectionProperties::CumulativeQuerySelection:
          snprintf(tmpStr, 1000, "%sselectionType = %sCumulativeQuerySelection  # %s\n", prefix, prefix, selectionType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *idVariableType_names = "UseZoneIDForID, UseGlobalZoneIDForID, UseLocationsForID, UseVariableForID";
    switch (atts->GetIdVariableType())
    {
      case SelectionProperties::UseZoneIDForID:
          snprintf(tmpStr, 1000, "%sidVariableType = %sUseZoneIDForID  # %s\n", prefix, prefix, idVariableType_names);
          str += tmpStr;
          break;
      case SelectionProperties::UseGlobalZoneIDForID:
          snprintf(tmpStr, 1000, "%sidVariableType = %sUseGlobalZoneIDForID  # %s\n", prefix, prefix, idVariableType_names);
          str += tmpStr;
          break;
      case SelectionProperties::UseLocationsForID:
          snprintf(tmpStr, 1000, "%sidVariableType = %sUseLocationsForID  # %s\n", prefix, prefix, idVariableType_names);
          str += tmpStr;
          break;
      case SelectionProperties::UseVariableForID:
          snprintf(tmpStr, 1000, "%sidVariableType = %sUseVariableForID  # %s\n", prefix, prefix, idVariableType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sidVariable = \"%s\"\n", prefix, atts->GetIdVariable().c_str());
    str += tmpStr;
    {   const stringVector &variables = atts->GetVariables();
        snprintf(tmpStr, 1000, "%svariables = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < variables.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", variables[i].c_str());
            str += tmpStr;
            if(i < variables.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &variableMins = atts->GetVariableMins();
        snprintf(tmpStr, 1000, "%svariableMins = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < variableMins.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", variableMins[i]);
            str += tmpStr;
            if(i < variableMins.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &variableMaxs = atts->GetVariableMaxs();
        snprintf(tmpStr, 1000, "%svariableMaxs = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < variableMaxs.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", variableMaxs[i]);
            str += tmpStr;
            if(i < variableMaxs.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sminTimeState = %d\n", prefix, atts->GetMinTimeState());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxTimeState = %d\n", prefix, atts->GetMaxTimeState());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stimeStateStride = %d\n", prefix, atts->GetTimeStateStride());
    str += tmpStr;
    const char *combineRule_names = "CombineAnd, CombineOr";
    switch (atts->GetCombineRule())
    {
      case SelectionProperties::CombineAnd:
          snprintf(tmpStr, 1000, "%scombineRule = %sCombineAnd  # %s\n", prefix, prefix, combineRule_names);
          str += tmpStr;
          break;
      case SelectionProperties::CombineOr:
          snprintf(tmpStr, 1000, "%scombineRule = %sCombineOr  # %s\n", prefix, prefix, combineRule_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *histogramType_names = "HistogramTime, HistogramMatches, HistogramID, HistogramVariable";
    switch (atts->GetHistogramType())
    {
      case SelectionProperties::HistogramTime:
          snprintf(tmpStr, 1000, "%shistogramType = %sHistogramTime  # %s\n", prefix, prefix, histogramType_names);
          str += tmpStr;
          break;
      case SelectionProperties::HistogramMatches:
          snprintf(tmpStr, 1000, "%shistogramType = %sHistogramMatches  # %s\n", prefix, prefix, histogramType_names);
          str += tmpStr;
          break;
      case SelectionProperties::HistogramID:
          snprintf(tmpStr, 1000, "%shistogramType = %sHistogramID  # %s\n", prefix, prefix, histogramType_names);
          str += tmpStr;
          break;
      case SelectionProperties::HistogramVariable:
          snprintf(tmpStr, 1000, "%shistogramType = %sHistogramVariable  # %s\n", prefix, prefix, histogramType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%shistogramNumBins = %d\n", prefix, atts->GetHistogramNumBins());
    str += tmpStr;
    if(atts->GetHistogramAutoScaleNumBins())
        snprintf(tmpStr, 1000, "%shistogramAutoScaleNumBins = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%shistogramAutoScaleNumBins = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%shistogramStartBin = %d\n", prefix, atts->GetHistogramStartBin());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%shistogramEndBin = %d\n", prefix, atts->GetHistogramEndBin());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%shistogramVariable = \"%s\"\n", prefix, atts->GetHistogramVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
SelectionProperties_Notify(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_SetName(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetName(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetSource(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the source in the object.
    obj->data->SetSource(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetSource(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSource().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHost(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the host in the object.
    obj->data->SetHost(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHost(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHost().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetSelectionType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the selectionType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSelectionType(SelectionProperties::SelectionType(ival));
    else
    {
        fprintf(stderr, "An invalid selectionType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "BasicSelection, CumulativeQuerySelection.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetSelectionType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSelectionType()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetIdVariableType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the idVariableType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetIdVariableType(SelectionProperties::IDVariableType(ival));
    else
    {
        fprintf(stderr, "An invalid idVariableType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "UseZoneIDForID, UseGlobalZoneIDForID, UseLocationsForID, UseVariableForID.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetIdVariableType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIdVariableType()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetIdVariable(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the idVariable in the object.
    obj->data->SetIdVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetIdVariable(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetIdVariable().c_str());
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetVariables(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    stringVector  &vec = obj->data->GetVariables();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the variables in the object as modified.
    obj->data->SelectVariables();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetVariables(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    // Allocate a tuple the with enough entries to hold the variables.
    const stringVector &variables = obj->data->GetVariables();
    PyObject *retval = PyTuple_New(variables.size());
    for(size_t i = 0; i < variables.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(variables[i].c_str()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetVariableMins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    doubleVector  &vec = obj->data->GetVariableMins();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the variableMins in the object as modified.
    obj->data->SelectVariableMins();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetVariableMins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    // Allocate a tuple the with enough entries to hold the variableMins.
    const doubleVector &variableMins = obj->data->GetVariableMins();
    PyObject *retval = PyTuple_New(variableMins.size());
    for(size_t i = 0; i < variableMins.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(variableMins[i]));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetVariableMaxs(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    doubleVector  &vec = obj->data->GetVariableMaxs();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the variableMaxs in the object as modified.
    obj->data->SelectVariableMaxs();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetVariableMaxs(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    // Allocate a tuple the with enough entries to hold the variableMaxs.
    const doubleVector &variableMaxs = obj->data->GetVariableMaxs();
    PyObject *retval = PyTuple_New(variableMaxs.size());
    for(size_t i = 0; i < variableMaxs.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(variableMaxs[i]));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetMinTimeState(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minTimeState in the object.
    obj->data->SetMinTimeState((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetMinTimeState(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMinTimeState()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetMaxTimeState(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxTimeState in the object.
    obj->data->SetMaxTimeState((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetMaxTimeState(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxTimeState()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetTimeStateStride(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStateStride in the object.
    obj->data->SetTimeStateStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetTimeStateStride(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStateStride()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetCombineRule(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the combineRule in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCombineRule(SelectionProperties::CombinationType(ival));
    else
    {
        fprintf(stderr, "An invalid combineRule value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CombineAnd, CombineOr.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetCombineRule(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCombineRule()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the histogramType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetHistogramType(SelectionProperties::HistogramType(ival));
    else
    {
        fprintf(stderr, "An invalid histogramType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "HistogramTime, HistogramMatches, HistogramID, HistogramVariable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramType(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHistogramType()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramNumBins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the histogramNumBins in the object.
    obj->data->SetHistogramNumBins((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramNumBins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHistogramNumBins()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramAutoScaleNumBins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the histogramAutoScaleNumBins in the object.
    obj->data->SetHistogramAutoScaleNumBins(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramAutoScaleNumBins(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHistogramAutoScaleNumBins()?1L:0L);
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramStartBin(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the histogramStartBin in the object.
    obj->data->SetHistogramStartBin((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramStartBin(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHistogramStartBin()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramEndBin(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the histogramEndBin in the object.
    obj->data->SetHistogramEndBin((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramEndBin(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetHistogramEndBin()));
    return retval;
}

/*static*/ PyObject *
SelectionProperties_SetHistogramVariable(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the histogramVariable in the object.
    obj->data->SetHistogramVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SelectionProperties_GetHistogramVariable(PyObject *self, PyObject *args)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetHistogramVariable().c_str());
    return retval;
}



PyMethodDef PySelectionProperties_methods[SELECTIONPROPERTIES_NMETH] = {
    {"Notify", SelectionProperties_Notify, METH_VARARGS},
    {"SetName", SelectionProperties_SetName, METH_VARARGS},
    {"GetName", SelectionProperties_GetName, METH_VARARGS},
    {"SetSource", SelectionProperties_SetSource, METH_VARARGS},
    {"GetSource", SelectionProperties_GetSource, METH_VARARGS},
    {"SetHost", SelectionProperties_SetHost, METH_VARARGS},
    {"GetHost", SelectionProperties_GetHost, METH_VARARGS},
    {"SetSelectionType", SelectionProperties_SetSelectionType, METH_VARARGS},
    {"GetSelectionType", SelectionProperties_GetSelectionType, METH_VARARGS},
    {"SetIdVariableType", SelectionProperties_SetIdVariableType, METH_VARARGS},
    {"GetIdVariableType", SelectionProperties_GetIdVariableType, METH_VARARGS},
    {"SetIdVariable", SelectionProperties_SetIdVariable, METH_VARARGS},
    {"GetIdVariable", SelectionProperties_GetIdVariable, METH_VARARGS},
    {"SetVariables", SelectionProperties_SetVariables, METH_VARARGS},
    {"GetVariables", SelectionProperties_GetVariables, METH_VARARGS},
    {"SetVariableMins", SelectionProperties_SetVariableMins, METH_VARARGS},
    {"GetVariableMins", SelectionProperties_GetVariableMins, METH_VARARGS},
    {"SetVariableMaxs", SelectionProperties_SetVariableMaxs, METH_VARARGS},
    {"GetVariableMaxs", SelectionProperties_GetVariableMaxs, METH_VARARGS},
    {"SetMinTimeState", SelectionProperties_SetMinTimeState, METH_VARARGS},
    {"GetMinTimeState", SelectionProperties_GetMinTimeState, METH_VARARGS},
    {"SetMaxTimeState", SelectionProperties_SetMaxTimeState, METH_VARARGS},
    {"GetMaxTimeState", SelectionProperties_GetMaxTimeState, METH_VARARGS},
    {"SetTimeStateStride", SelectionProperties_SetTimeStateStride, METH_VARARGS},
    {"GetTimeStateStride", SelectionProperties_GetTimeStateStride, METH_VARARGS},
    {"SetCombineRule", SelectionProperties_SetCombineRule, METH_VARARGS},
    {"GetCombineRule", SelectionProperties_GetCombineRule, METH_VARARGS},
    {"SetHistogramType", SelectionProperties_SetHistogramType, METH_VARARGS},
    {"GetHistogramType", SelectionProperties_GetHistogramType, METH_VARARGS},
    {"SetHistogramNumBins", SelectionProperties_SetHistogramNumBins, METH_VARARGS},
    {"GetHistogramNumBins", SelectionProperties_GetHistogramNumBins, METH_VARARGS},
    {"SetHistogramAutoScaleNumBins", SelectionProperties_SetHistogramAutoScaleNumBins, METH_VARARGS},
    {"GetHistogramAutoScaleNumBins", SelectionProperties_GetHistogramAutoScaleNumBins, METH_VARARGS},
    {"SetHistogramStartBin", SelectionProperties_SetHistogramStartBin, METH_VARARGS},
    {"GetHistogramStartBin", SelectionProperties_GetHistogramStartBin, METH_VARARGS},
    {"SetHistogramEndBin", SelectionProperties_SetHistogramEndBin, METH_VARARGS},
    {"GetHistogramEndBin", SelectionProperties_GetHistogramEndBin, METH_VARARGS},
    {"SetHistogramVariable", SelectionProperties_SetHistogramVariable, METH_VARARGS},
    {"GetHistogramVariable", SelectionProperties_GetHistogramVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SelectionProperties_dealloc(PyObject *v)
{
   SelectionPropertiesObject *obj = (SelectionPropertiesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SelectionProperties_compare(PyObject *v, PyObject *w)
{
    SelectionProperties *a = ((SelectionPropertiesObject *)v)->data;
    SelectionProperties *b = ((SelectionPropertiesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySelectionProperties_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return SelectionProperties_GetName(self, NULL);
    if(strcmp(name, "source") == 0)
        return SelectionProperties_GetSource(self, NULL);
    if(strcmp(name, "host") == 0)
        return SelectionProperties_GetHost(self, NULL);
    if(strcmp(name, "selectionType") == 0)
        return SelectionProperties_GetSelectionType(self, NULL);
    if(strcmp(name, "BasicSelection") == 0)
        return PyInt_FromLong(long(SelectionProperties::BasicSelection));
    if(strcmp(name, "CumulativeQuerySelection") == 0)
        return PyInt_FromLong(long(SelectionProperties::CumulativeQuerySelection));

    if(strcmp(name, "idVariableType") == 0)
        return SelectionProperties_GetIdVariableType(self, NULL);
    if(strcmp(name, "UseZoneIDForID") == 0)
        return PyInt_FromLong(long(SelectionProperties::UseZoneIDForID));
    if(strcmp(name, "UseGlobalZoneIDForID") == 0)
        return PyInt_FromLong(long(SelectionProperties::UseGlobalZoneIDForID));
    if(strcmp(name, "UseLocationsForID") == 0)
        return PyInt_FromLong(long(SelectionProperties::UseLocationsForID));
    if(strcmp(name, "UseVariableForID") == 0)
        return PyInt_FromLong(long(SelectionProperties::UseVariableForID));

    if(strcmp(name, "idVariable") == 0)
        return SelectionProperties_GetIdVariable(self, NULL);
    if(strcmp(name, "variables") == 0)
        return SelectionProperties_GetVariables(self, NULL);
    if(strcmp(name, "variableMins") == 0)
        return SelectionProperties_GetVariableMins(self, NULL);
    if(strcmp(name, "variableMaxs") == 0)
        return SelectionProperties_GetVariableMaxs(self, NULL);
    if(strcmp(name, "minTimeState") == 0)
        return SelectionProperties_GetMinTimeState(self, NULL);
    if(strcmp(name, "maxTimeState") == 0)
        return SelectionProperties_GetMaxTimeState(self, NULL);
    if(strcmp(name, "timeStateStride") == 0)
        return SelectionProperties_GetTimeStateStride(self, NULL);
    if(strcmp(name, "combineRule") == 0)
        return SelectionProperties_GetCombineRule(self, NULL);
    if(strcmp(name, "CombineAnd") == 0)
        return PyInt_FromLong(long(SelectionProperties::CombineAnd));
    if(strcmp(name, "CombineOr") == 0)
        return PyInt_FromLong(long(SelectionProperties::CombineOr));

    if(strcmp(name, "histogramType") == 0)
        return SelectionProperties_GetHistogramType(self, NULL);
    if(strcmp(name, "HistogramTime") == 0)
        return PyInt_FromLong(long(SelectionProperties::HistogramTime));
    if(strcmp(name, "HistogramMatches") == 0)
        return PyInt_FromLong(long(SelectionProperties::HistogramMatches));
    if(strcmp(name, "HistogramID") == 0)
        return PyInt_FromLong(long(SelectionProperties::HistogramID));
    if(strcmp(name, "HistogramVariable") == 0)
        return PyInt_FromLong(long(SelectionProperties::HistogramVariable));

    if(strcmp(name, "histogramNumBins") == 0)
        return SelectionProperties_GetHistogramNumBins(self, NULL);
    if(strcmp(name, "histogramAutoScaleNumBins") == 0)
        return SelectionProperties_GetHistogramAutoScaleNumBins(self, NULL);
    if(strcmp(name, "histogramStartBin") == 0)
        return SelectionProperties_GetHistogramStartBin(self, NULL);
    if(strcmp(name, "histogramEndBin") == 0)
        return SelectionProperties_GetHistogramEndBin(self, NULL);
    if(strcmp(name, "histogramVariable") == 0)
        return SelectionProperties_GetHistogramVariable(self, NULL);

    return Py_FindMethod(PySelectionProperties_methods, self, name);
}

int
PySelectionProperties_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = SelectionProperties_SetName(self, tuple);
    else if(strcmp(name, "source") == 0)
        obj = SelectionProperties_SetSource(self, tuple);
    else if(strcmp(name, "host") == 0)
        obj = SelectionProperties_SetHost(self, tuple);
    else if(strcmp(name, "selectionType") == 0)
        obj = SelectionProperties_SetSelectionType(self, tuple);
    else if(strcmp(name, "idVariableType") == 0)
        obj = SelectionProperties_SetIdVariableType(self, tuple);
    else if(strcmp(name, "idVariable") == 0)
        obj = SelectionProperties_SetIdVariable(self, tuple);
    else if(strcmp(name, "variables") == 0)
        obj = SelectionProperties_SetVariables(self, tuple);
    else if(strcmp(name, "variableMins") == 0)
        obj = SelectionProperties_SetVariableMins(self, tuple);
    else if(strcmp(name, "variableMaxs") == 0)
        obj = SelectionProperties_SetVariableMaxs(self, tuple);
    else if(strcmp(name, "minTimeState") == 0)
        obj = SelectionProperties_SetMinTimeState(self, tuple);
    else if(strcmp(name, "maxTimeState") == 0)
        obj = SelectionProperties_SetMaxTimeState(self, tuple);
    else if(strcmp(name, "timeStateStride") == 0)
        obj = SelectionProperties_SetTimeStateStride(self, tuple);
    else if(strcmp(name, "combineRule") == 0)
        obj = SelectionProperties_SetCombineRule(self, tuple);
    else if(strcmp(name, "histogramType") == 0)
        obj = SelectionProperties_SetHistogramType(self, tuple);
    else if(strcmp(name, "histogramNumBins") == 0)
        obj = SelectionProperties_SetHistogramNumBins(self, tuple);
    else if(strcmp(name, "histogramAutoScaleNumBins") == 0)
        obj = SelectionProperties_SetHistogramAutoScaleNumBins(self, tuple);
    else if(strcmp(name, "histogramStartBin") == 0)
        obj = SelectionProperties_SetHistogramStartBin(self, tuple);
    else if(strcmp(name, "histogramEndBin") == 0)
        obj = SelectionProperties_SetHistogramEndBin(self, tuple);
    else if(strcmp(name, "histogramVariable") == 0)
        obj = SelectionProperties_SetHistogramVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SelectionProperties_print(PyObject *v, FILE *fp, int flags)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)v;
    fprintf(fp, "%s", PySelectionProperties_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SelectionProperties_str(PyObject *v)
{
    SelectionPropertiesObject *obj = (SelectionPropertiesObject *)v;
    return PyString_FromString(PySelectionProperties_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SelectionProperties_Purpose = "Contains attributes for a selection";
#else
static char *SelectionProperties_Purpose = "Contains attributes for a selection";
#endif

//
// The type description structure
//
static PyTypeObject SelectionPropertiesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SelectionProperties",                    // tp_name
    sizeof(SelectionPropertiesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SelectionProperties_dealloc,  // tp_dealloc
    (printfunc)SelectionProperties_print,     // tp_print
    (getattrfunc)PySelectionProperties_getattr, // tp_getattr
    (setattrfunc)PySelectionProperties_setattr, // tp_setattr
    (cmpfunc)SelectionProperties_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SelectionProperties_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SelectionProperties_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SelectionProperties *defaultAtts = 0;
static SelectionProperties *currentAtts = 0;

static PyObject *
NewSelectionProperties(int useCurrent)
{
    SelectionPropertiesObject *newObject;
    newObject = PyObject_NEW(SelectionPropertiesObject, &SelectionPropertiesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SelectionProperties(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SelectionProperties(*defaultAtts);
    else
        newObject->data = new SelectionProperties;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSelectionProperties(const SelectionProperties *attr)
{
    SelectionPropertiesObject *newObject;
    newObject = PyObject_NEW(SelectionPropertiesObject, &SelectionPropertiesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SelectionProperties *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SelectionProperties_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSelectionProperties(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SelectionPropertiesMethods[] = {
    {"SelectionProperties", SelectionProperties_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SelectionPropertiesObserver = 0;

std::string
PySelectionProperties_GetLogString()
{
    std::string s("SelectionProperties = SelectionProperties()\n");
    if(currentAtts != 0)
        s += PySelectionProperties_ToString(currentAtts, "SelectionProperties.");
    return s;
}

static void
PySelectionProperties_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SelectionProperties = SelectionProperties()\n");
        s += PySelectionProperties_ToString(currentAtts, "SelectionProperties.");
        cb(s);
    }
}

void
PySelectionProperties_StartUp(SelectionProperties *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySelectionProperties_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SelectionPropertiesObserver == 0)
    {
        SelectionPropertiesObserver = new ObserverToCallback(subj,
            PySelectionProperties_CallLogRoutine, (void *)data);
    }

}

void
PySelectionProperties_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SelectionPropertiesObserver;
    SelectionPropertiesObserver = 0;
}

PyMethodDef *
PySelectionProperties_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SelectionPropertiesMethods;
}

bool
PySelectionProperties_Check(PyObject *obj)
{
    return (obj->ob_type == &SelectionPropertiesType);
}

SelectionProperties *
PySelectionProperties_FromPyObject(PyObject *obj)
{
    SelectionPropertiesObject *obj2 = (SelectionPropertiesObject *)obj;
    return obj2->data;
}

PyObject *
PySelectionProperties_New()
{
    return NewSelectionProperties(0);
}

PyObject *
PySelectionProperties_Wrap(const SelectionProperties *attr)
{
    return WrapSelectionProperties(attr);
}

void
PySelectionProperties_SetParent(PyObject *obj, PyObject *parent)
{
    SelectionPropertiesObject *obj2 = (SelectionPropertiesObject *)obj;
    obj2->parent = parent;
}

void
PySelectionProperties_SetDefaults(const SelectionProperties *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SelectionProperties(*atts);
}

