// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyProcessAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyProcessAttributes
//
// Purpose:
//   attributes to describe a running process
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ProcessAttributes.
//
struct ProcessAttributesObject
{
    PyObject_HEAD
    ProcessAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewProcessAttributes(int);

std::string
PyProcessAttributes_ToString(const ProcessAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const intVector &pids = atts->GetPids();
        snprintf(tmpStr, 1000, "%spids = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < pids.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", pids[i]);
            str += tmpStr;
            if(i < pids.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &ppids = atts->GetPpids();
        snprintf(tmpStr, 1000, "%sppids = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < ppids.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", ppids[i]);
            str += tmpStr;
            if(i < ppids.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const stringVector &hosts = atts->GetHosts();
        snprintf(tmpStr, 1000, "%shosts = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < hosts.size(); ++i)
        {
            snprintf(tmpStr, 1000, "\"%s\"", hosts[i].c_str());
            str += tmpStr;
            if(i < hosts.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetIsParallel())
        snprintf(tmpStr, 1000, "%sisParallel = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sisParallel = 0\n", prefix);
    str += tmpStr;
    {   const intVector &memory = atts->GetMemory();
        snprintf(tmpStr, 1000, "%smemory = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < memory.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%d", memory[i]);
            str += tmpStr;
            if(i < memory.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &times = atts->GetTimes();
        snprintf(tmpStr, 1000, "%stimes = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < times.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", times[i]);
            str += tmpStr;
            if(i < times.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ProcessAttributes_Notify(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_SetPids(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    intVector  &vec = obj->data->GetPids();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the pids in the object as modified.
    obj->data->SelectPids();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetPids(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pids.
    const intVector &pids = obj->data->GetPids();
    PyObject *retval = PyTuple_New(pids.size());
    for(size_t i = 0; i < pids.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(pids[i])));
    return retval;
}

/*static*/ PyObject *
ProcessAttributes_SetPpids(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    intVector  &vec = obj->data->GetPpids();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the ppids in the object as modified.
    obj->data->SelectPpids();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetPpids(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the ppids.
    const intVector &ppids = obj->data->GetPpids();
    PyObject *retval = PyTuple_New(ppids.size());
    for(size_t i = 0; i < ppids.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(ppids[i])));
    return retval;
}

/*static*/ PyObject *
ProcessAttributes_SetHosts(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    stringVector  &vec = obj->data->GetHosts();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the hosts in the object as modified.
    obj->data->SelectHosts();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetHosts(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the hosts.
    const stringVector &hosts = obj->data->GetHosts();
    PyObject *retval = PyTuple_New(hosts.size());
    for(size_t i = 0; i < hosts.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(hosts[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ProcessAttributes_SetIsParallel(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isParallel in the object.
    obj->data->SetIsParallel(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetIsParallel(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsParallel()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ProcessAttributes_SetMemory(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    intVector  &vec = obj->data->GetMemory();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the memory in the object as modified.
    obj->data->SelectMemory();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetMemory(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the memory.
    const intVector &memory = obj->data->GetMemory();
    PyObject *retval = PyTuple_New(memory.size());
    for(size_t i = 0; i < memory.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(memory[i])));
    return retval;
}

/*static*/ PyObject *
ProcessAttributes_SetTimes(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;

    doubleVector  &vec = obj->data->GetTimes();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the times in the object as modified.
    obj->data->SelectTimes();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProcessAttributes_GetTimes(PyObject *self, PyObject *args)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the times.
    const doubleVector &times = obj->data->GetTimes();
    PyObject *retval = PyTuple_New(times.size());
    for(size_t i = 0; i < times.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(times[i]));
    return retval;
}



PyMethodDef PyProcessAttributes_methods[PROCESSATTRIBUTES_NMETH] = {
    {"Notify", ProcessAttributes_Notify, METH_VARARGS},
    {"SetPids", ProcessAttributes_SetPids, METH_VARARGS},
    {"GetPids", ProcessAttributes_GetPids, METH_VARARGS},
    {"SetPpids", ProcessAttributes_SetPpids, METH_VARARGS},
    {"GetPpids", ProcessAttributes_GetPpids, METH_VARARGS},
    {"SetHosts", ProcessAttributes_SetHosts, METH_VARARGS},
    {"GetHosts", ProcessAttributes_GetHosts, METH_VARARGS},
    {"SetIsParallel", ProcessAttributes_SetIsParallel, METH_VARARGS},
    {"GetIsParallel", ProcessAttributes_GetIsParallel, METH_VARARGS},
    {"SetMemory", ProcessAttributes_SetMemory, METH_VARARGS},
    {"GetMemory", ProcessAttributes_GetMemory, METH_VARARGS},
    {"SetTimes", ProcessAttributes_SetTimes, METH_VARARGS},
    {"GetTimes", ProcessAttributes_GetTimes, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ProcessAttributes_dealloc(PyObject *v)
{
   ProcessAttributesObject *obj = (ProcessAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ProcessAttributes_compare(PyObject *v, PyObject *w)
{
    ProcessAttributes *a = ((ProcessAttributesObject *)v)->data;
    ProcessAttributes *b = ((ProcessAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyProcessAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "pids") == 0)
        return ProcessAttributes_GetPids(self, NULL);
    if(strcmp(name, "ppids") == 0)
        return ProcessAttributes_GetPpids(self, NULL);
    if(strcmp(name, "hosts") == 0)
        return ProcessAttributes_GetHosts(self, NULL);
    if(strcmp(name, "isParallel") == 0)
        return ProcessAttributes_GetIsParallel(self, NULL);
    if(strcmp(name, "memory") == 0)
        return ProcessAttributes_GetMemory(self, NULL);
    if(strcmp(name, "times") == 0)
        return ProcessAttributes_GetTimes(self, NULL);

    return Py_FindMethod(PyProcessAttributes_methods, self, name);
}

int
PyProcessAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "pids") == 0)
        obj = ProcessAttributes_SetPids(self, tuple);
    else if(strcmp(name, "ppids") == 0)
        obj = ProcessAttributes_SetPpids(self, tuple);
    else if(strcmp(name, "hosts") == 0)
        obj = ProcessAttributes_SetHosts(self, tuple);
    else if(strcmp(name, "isParallel") == 0)
        obj = ProcessAttributes_SetIsParallel(self, tuple);
    else if(strcmp(name, "memory") == 0)
        obj = ProcessAttributes_SetMemory(self, tuple);
    else if(strcmp(name, "times") == 0)
        obj = ProcessAttributes_SetTimes(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ProcessAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)v;
    fprintf(fp, "%s", PyProcessAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ProcessAttributes_str(PyObject *v)
{
    ProcessAttributesObject *obj = (ProcessAttributesObject *)v;
    return PyString_FromString(PyProcessAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ProcessAttributes_Purpose = "attributes to describe a running process";
#else
static char *ProcessAttributes_Purpose = "attributes to describe a running process";
#endif

//
// The type description structure
//
static PyTypeObject ProcessAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ProcessAttributes",                    // tp_name
    sizeof(ProcessAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ProcessAttributes_dealloc,  // tp_dealloc
    (printfunc)ProcessAttributes_print,     // tp_print
    (getattrfunc)PyProcessAttributes_getattr, // tp_getattr
    (setattrfunc)PyProcessAttributes_setattr, // tp_setattr
    (cmpfunc)ProcessAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ProcessAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ProcessAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ProcessAttributes *defaultAtts = 0;
static ProcessAttributes *currentAtts = 0;

static PyObject *
NewProcessAttributes(int useCurrent)
{
    ProcessAttributesObject *newObject;
    newObject = PyObject_NEW(ProcessAttributesObject, &ProcessAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ProcessAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ProcessAttributes(*defaultAtts);
    else
        newObject->data = new ProcessAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapProcessAttributes(const ProcessAttributes *attr)
{
    ProcessAttributesObject *newObject;
    newObject = PyObject_NEW(ProcessAttributesObject, &ProcessAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ProcessAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ProcessAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewProcessAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ProcessAttributesMethods[] = {
    {"ProcessAttributes", ProcessAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ProcessAttributesObserver = 0;

std::string
PyProcessAttributes_GetLogString()
{
    std::string s("ProcessAtts = ProcessAttributes()\n");
    if(currentAtts != 0)
        s += PyProcessAttributes_ToString(currentAtts, "ProcessAtts.");
    return s;
}

static void
PyProcessAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ProcessAtts = ProcessAttributes()\n");
        s += PyProcessAttributes_ToString(currentAtts, "ProcessAtts.");
        cb(s);
    }
}

void
PyProcessAttributes_StartUp(ProcessAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyProcessAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ProcessAttributesObserver == 0)
    {
        ProcessAttributesObserver = new ObserverToCallback(subj,
            PyProcessAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyProcessAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ProcessAttributesObserver;
    ProcessAttributesObserver = 0;
}

PyMethodDef *
PyProcessAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ProcessAttributesMethods;
}

bool
PyProcessAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ProcessAttributesType);
}

ProcessAttributes *
PyProcessAttributes_FromPyObject(PyObject *obj)
{
    ProcessAttributesObject *obj2 = (ProcessAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyProcessAttributes_New()
{
    return NewProcessAttributes(0);
}

PyObject *
PyProcessAttributes_Wrap(const ProcessAttributes *attr)
{
    return WrapProcessAttributes(attr);
}

void
PyProcessAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ProcessAttributesObject *obj2 = (ProcessAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyProcessAttributes_SetDefaults(const ProcessAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ProcessAttributes(*atts);
}

