// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyFontAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyFontAttributes
//
// Purpose:
//   Describes font properties that we can set through VTK
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a FontAttributes.
//
struct FontAttributesObject
{
    PyObject_HEAD
    FontAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewFontAttributes(int);

std::string
PyFontAttributes_ToString(const FontAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *font_names = "Arial, Courier, Times";
    switch (atts->GetFont())
    {
      case FontAttributes::Arial:
          snprintf(tmpStr, 1000, "%sfont = %sArial  # %s\n", prefix, prefix, font_names);
          str += tmpStr;
          break;
      case FontAttributes::Courier:
          snprintf(tmpStr, 1000, "%sfont = %sCourier  # %s\n", prefix, prefix, font_names);
          str += tmpStr;
          break;
      case FontAttributes::Times:
          snprintf(tmpStr, 1000, "%sfont = %sTimes  # %s\n", prefix, prefix, font_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sscale = %g\n", prefix, atts->GetScale());
    str += tmpStr;
    if(atts->GetUseForegroundColor())
        snprintf(tmpStr, 1000, "%suseForegroundColor = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseForegroundColor = 0\n", prefix);
    str += tmpStr;
    const unsigned char *color = atts->GetColor().GetColor();
    snprintf(tmpStr, 1000, "%scolor = (%d, %d, %d, %d)\n", prefix, int(color[0]), int(color[1]), int(color[2]), int(color[3]));
    str += tmpStr;
    if(atts->GetBold())
        snprintf(tmpStr, 1000, "%sbold = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sbold = 0\n", prefix);
    str += tmpStr;
    if(atts->GetItalic())
        snprintf(tmpStr, 1000, "%sitalic = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sitalic = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
FontAttributes_Notify(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_SetFont(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the font in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetFont(FontAttributes::FontName(ival));
    else
    {
        fprintf(stderr, "An invalid font value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Arial, Courier, Times.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetFont(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFont()));
    return retval;
}

/*static*/ PyObject *
FontAttributes_SetScale(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scale in the object.
    obj->data->SetScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetScale(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScale());
    return retval;
}

/*static*/ PyObject *
FontAttributes_SetUseForegroundColor(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useForegroundColor in the object.
    obj->data->SetUseForegroundColor(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetUseForegroundColor(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseForegroundColor()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FontAttributes_SetColor(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the color in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetColor(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the color.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *color = obj->data->GetColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(color[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(color[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(color[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(color[3])));
    return retval;
}

/*static*/ PyObject *
FontAttributes_SetBold(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bold in the object.
    obj->data->SetBold(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetBold(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetBold()?1L:0L);
    return retval;
}

/*static*/ PyObject *
FontAttributes_SetItalic(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the italic in the object.
    obj->data->SetItalic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
FontAttributes_GetItalic(PyObject *self, PyObject *args)
{
    FontAttributesObject *obj = (FontAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetItalic()?1L:0L);
    return retval;
}



PyMethodDef PyFontAttributes_methods[FONTATTRIBUTES_NMETH] = {
    {"Notify", FontAttributes_Notify, METH_VARARGS},
    {"SetFont", FontAttributes_SetFont, METH_VARARGS},
    {"GetFont", FontAttributes_GetFont, METH_VARARGS},
    {"SetScale", FontAttributes_SetScale, METH_VARARGS},
    {"GetScale", FontAttributes_GetScale, METH_VARARGS},
    {"SetUseForegroundColor", FontAttributes_SetUseForegroundColor, METH_VARARGS},
    {"GetUseForegroundColor", FontAttributes_GetUseForegroundColor, METH_VARARGS},
    {"SetColor", FontAttributes_SetColor, METH_VARARGS},
    {"GetColor", FontAttributes_GetColor, METH_VARARGS},
    {"SetBold", FontAttributes_SetBold, METH_VARARGS},
    {"GetBold", FontAttributes_GetBold, METH_VARARGS},
    {"SetItalic", FontAttributes_SetItalic, METH_VARARGS},
    {"GetItalic", FontAttributes_GetItalic, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
FontAttributes_dealloc(PyObject *v)
{
   FontAttributesObject *obj = (FontAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
FontAttributes_compare(PyObject *v, PyObject *w)
{
    FontAttributes *a = ((FontAttributesObject *)v)->data;
    FontAttributes *b = ((FontAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyFontAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "font") == 0)
        return FontAttributes_GetFont(self, NULL);
    if(strcmp(name, "Arial") == 0)
        return PyInt_FromLong(long(FontAttributes::Arial));
    if(strcmp(name, "Courier") == 0)
        return PyInt_FromLong(long(FontAttributes::Courier));
    if(strcmp(name, "Times") == 0)
        return PyInt_FromLong(long(FontAttributes::Times));

    if(strcmp(name, "scale") == 0)
        return FontAttributes_GetScale(self, NULL);
    if(strcmp(name, "useForegroundColor") == 0)
        return FontAttributes_GetUseForegroundColor(self, NULL);
    if(strcmp(name, "color") == 0)
        return FontAttributes_GetColor(self, NULL);
    if(strcmp(name, "bold") == 0)
        return FontAttributes_GetBold(self, NULL);
    if(strcmp(name, "italic") == 0)
        return FontAttributes_GetItalic(self, NULL);

    return Py_FindMethod(PyFontAttributes_methods, self, name);
}

int
PyFontAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "font") == 0)
        obj = FontAttributes_SetFont(self, tuple);
    else if(strcmp(name, "scale") == 0)
        obj = FontAttributes_SetScale(self, tuple);
    else if(strcmp(name, "useForegroundColor") == 0)
        obj = FontAttributes_SetUseForegroundColor(self, tuple);
    else if(strcmp(name, "color") == 0)
        obj = FontAttributes_SetColor(self, tuple);
    else if(strcmp(name, "bold") == 0)
        obj = FontAttributes_SetBold(self, tuple);
    else if(strcmp(name, "italic") == 0)
        obj = FontAttributes_SetItalic(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
FontAttributes_print(PyObject *v, FILE *fp, int flags)
{
    FontAttributesObject *obj = (FontAttributesObject *)v;
    fprintf(fp, "%s", PyFontAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
FontAttributes_str(PyObject *v)
{
    FontAttributesObject *obj = (FontAttributesObject *)v;
    return PyString_FromString(PyFontAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *FontAttributes_Purpose = "Describes font properties that we can set through VTK";
#else
static char *FontAttributes_Purpose = "Describes font properties that we can set through VTK";
#endif

//
// The type description structure
//
static PyTypeObject FontAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "FontAttributes",                    // tp_name
    sizeof(FontAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)FontAttributes_dealloc,  // tp_dealloc
    (printfunc)FontAttributes_print,     // tp_print
    (getattrfunc)PyFontAttributes_getattr, // tp_getattr
    (setattrfunc)PyFontAttributes_setattr, // tp_setattr
    (cmpfunc)FontAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)FontAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    FontAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static FontAttributes *defaultAtts = 0;
static FontAttributes *currentAtts = 0;

static PyObject *
NewFontAttributes(int useCurrent)
{
    FontAttributesObject *newObject;
    newObject = PyObject_NEW(FontAttributesObject, &FontAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new FontAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new FontAttributes(*defaultAtts);
    else
        newObject->data = new FontAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapFontAttributes(const FontAttributes *attr)
{
    FontAttributesObject *newObject;
    newObject = PyObject_NEW(FontAttributesObject, &FontAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (FontAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
FontAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewFontAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef FontAttributesMethods[] = {
    {"FontAttributes", FontAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *FontAttributesObserver = 0;

std::string
PyFontAttributes_GetLogString()
{
    std::string s("FontAtts = FontAttributes()\n");
    if(currentAtts != 0)
        s += PyFontAttributes_ToString(currentAtts, "FontAtts.");
    return s;
}

static void
PyFontAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("FontAtts = FontAttributes()\n");
        s += PyFontAttributes_ToString(currentAtts, "FontAtts.");
        cb(s);
    }
}

void
PyFontAttributes_StartUp(FontAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyFontAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(FontAttributesObserver == 0)
    {
        FontAttributesObserver = new ObserverToCallback(subj,
            PyFontAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyFontAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete FontAttributesObserver;
    FontAttributesObserver = 0;
}

PyMethodDef *
PyFontAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return FontAttributesMethods;
}

bool
PyFontAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &FontAttributesType);
}

FontAttributes *
PyFontAttributes_FromPyObject(PyObject *obj)
{
    FontAttributesObject *obj2 = (FontAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyFontAttributes_New()
{
    return NewFontAttributes(0);
}

PyObject *
PyFontAttributes_Wrap(const FontAttributes *attr)
{
    return WrapFontAttributes(attr);
}

void
PyFontAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    FontAttributesObject *obj2 = (FontAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyFontAttributes_SetDefaults(const FontAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new FontAttributes(*atts);
}

