// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyEngineProperties.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyEngineProperties
//
// Purpose:
//   This class contains properties about running engines.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a EngineProperties.
//
struct EnginePropertiesObject
{
    PyObject_HEAD
    EngineProperties *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewEngineProperties(int);

std::string
PyEngineProperties_ToString(const EngineProperties *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%snumNodes = %d\n", prefix, atts->GetNumNodes());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumProcessors = %d\n", prefix, atts->GetNumProcessors());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumProcessorsUsingGPUs = %d\n", prefix, atts->GetNumProcessorsUsingGPUs());
    str += tmpStr;
    if(atts->GetDynamicLoadBalancing())
        snprintf(tmpStr, 1000, "%sdynamicLoadBalancing = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdynamicLoadBalancing = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sloadBalancingScheme = \"%s\"\n", prefix, atts->GetLoadBalancingScheme().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
EngineProperties_Notify(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_SetNumNodes(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numNodes in the object.
    obj->data->SetNumNodes((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_GetNumNodes(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumNodes()));
    return retval;
}

/*static*/ PyObject *
EngineProperties_SetNumProcessors(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numProcessors in the object.
    obj->data->SetNumProcessors((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_GetNumProcessors(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumProcessors()));
    return retval;
}

/*static*/ PyObject *
EngineProperties_SetNumProcessorsUsingGPUs(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numProcessorsUsingGPUs in the object.
    obj->data->SetNumProcessorsUsingGPUs((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_GetNumProcessorsUsingGPUs(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumProcessorsUsingGPUs()));
    return retval;
}

/*static*/ PyObject *
EngineProperties_SetDynamicLoadBalancing(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dynamicLoadBalancing in the object.
    obj->data->SetDynamicLoadBalancing(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_GetDynamicLoadBalancing(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDynamicLoadBalancing()?1L:0L);
    return retval;
}

/*static*/ PyObject *
EngineProperties_SetLoadBalancingScheme(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the loadBalancingScheme in the object.
    obj->data->SetLoadBalancingScheme(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
EngineProperties_GetLoadBalancingScheme(PyObject *self, PyObject *args)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetLoadBalancingScheme().c_str());
    return retval;
}



PyMethodDef PyEngineProperties_methods[ENGINEPROPERTIES_NMETH] = {
    {"Notify", EngineProperties_Notify, METH_VARARGS},
    {"SetNumNodes", EngineProperties_SetNumNodes, METH_VARARGS},
    {"GetNumNodes", EngineProperties_GetNumNodes, METH_VARARGS},
    {"SetNumProcessors", EngineProperties_SetNumProcessors, METH_VARARGS},
    {"GetNumProcessors", EngineProperties_GetNumProcessors, METH_VARARGS},
    {"SetNumProcessorsUsingGPUs", EngineProperties_SetNumProcessorsUsingGPUs, METH_VARARGS},
    {"GetNumProcessorsUsingGPUs", EngineProperties_GetNumProcessorsUsingGPUs, METH_VARARGS},
    {"SetDynamicLoadBalancing", EngineProperties_SetDynamicLoadBalancing, METH_VARARGS},
    {"GetDynamicLoadBalancing", EngineProperties_GetDynamicLoadBalancing, METH_VARARGS},
    {"SetLoadBalancingScheme", EngineProperties_SetLoadBalancingScheme, METH_VARARGS},
    {"GetLoadBalancingScheme", EngineProperties_GetLoadBalancingScheme, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
EngineProperties_dealloc(PyObject *v)
{
   EnginePropertiesObject *obj = (EnginePropertiesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
EngineProperties_compare(PyObject *v, PyObject *w)
{
    EngineProperties *a = ((EnginePropertiesObject *)v)->data;
    EngineProperties *b = ((EnginePropertiesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyEngineProperties_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "numNodes") == 0)
        return EngineProperties_GetNumNodes(self, NULL);
    if(strcmp(name, "numProcessors") == 0)
        return EngineProperties_GetNumProcessors(self, NULL);
    if(strcmp(name, "numProcessorsUsingGPUs") == 0)
        return EngineProperties_GetNumProcessorsUsingGPUs(self, NULL);
    if(strcmp(name, "dynamicLoadBalancing") == 0)
        return EngineProperties_GetDynamicLoadBalancing(self, NULL);
    if(strcmp(name, "loadBalancingScheme") == 0)
        return EngineProperties_GetLoadBalancingScheme(self, NULL);

    return Py_FindMethod(PyEngineProperties_methods, self, name);
}

int
PyEngineProperties_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "numNodes") == 0)
        obj = EngineProperties_SetNumNodes(self, tuple);
    else if(strcmp(name, "numProcessors") == 0)
        obj = EngineProperties_SetNumProcessors(self, tuple);
    else if(strcmp(name, "numProcessorsUsingGPUs") == 0)
        obj = EngineProperties_SetNumProcessorsUsingGPUs(self, tuple);
    else if(strcmp(name, "dynamicLoadBalancing") == 0)
        obj = EngineProperties_SetDynamicLoadBalancing(self, tuple);
    else if(strcmp(name, "loadBalancingScheme") == 0)
        obj = EngineProperties_SetLoadBalancingScheme(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
EngineProperties_print(PyObject *v, FILE *fp, int flags)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)v;
    fprintf(fp, "%s", PyEngineProperties_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
EngineProperties_str(PyObject *v)
{
    EnginePropertiesObject *obj = (EnginePropertiesObject *)v;
    return PyString_FromString(PyEngineProperties_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *EngineProperties_Purpose = "This class contains properties about running engines.";
#else
static char *EngineProperties_Purpose = "This class contains properties about running engines.";
#endif

//
// The type description structure
//
static PyTypeObject EnginePropertiesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "EngineProperties",                    // tp_name
    sizeof(EnginePropertiesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)EngineProperties_dealloc,  // tp_dealloc
    (printfunc)EngineProperties_print,     // tp_print
    (getattrfunc)PyEngineProperties_getattr, // tp_getattr
    (setattrfunc)PyEngineProperties_setattr, // tp_setattr
    (cmpfunc)EngineProperties_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)EngineProperties_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    EngineProperties_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static EngineProperties *defaultAtts = 0;
static EngineProperties *currentAtts = 0;

static PyObject *
NewEngineProperties(int useCurrent)
{
    EnginePropertiesObject *newObject;
    newObject = PyObject_NEW(EnginePropertiesObject, &EnginePropertiesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new EngineProperties(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new EngineProperties(*defaultAtts);
    else
        newObject->data = new EngineProperties;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapEngineProperties(const EngineProperties *attr)
{
    EnginePropertiesObject *newObject;
    newObject = PyObject_NEW(EnginePropertiesObject, &EnginePropertiesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (EngineProperties *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
EngineProperties_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewEngineProperties(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef EnginePropertiesMethods[] = {
    {"EngineProperties", EngineProperties_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *EnginePropertiesObserver = 0;

std::string
PyEngineProperties_GetLogString()
{
    std::string s("EngineProperties = EngineProperties()\n");
    if(currentAtts != 0)
        s += PyEngineProperties_ToString(currentAtts, "EngineProperties.");
    return s;
}

static void
PyEngineProperties_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("EngineProperties = EngineProperties()\n");
        s += PyEngineProperties_ToString(currentAtts, "EngineProperties.");
        cb(s);
    }
}

void
PyEngineProperties_StartUp(EngineProperties *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyEngineProperties_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(EnginePropertiesObserver == 0)
    {
        EnginePropertiesObserver = new ObserverToCallback(subj,
            PyEngineProperties_CallLogRoutine, (void *)data);
    }

}

void
PyEngineProperties_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete EnginePropertiesObserver;
    EnginePropertiesObserver = 0;
}

PyMethodDef *
PyEngineProperties_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return EnginePropertiesMethods;
}

bool
PyEngineProperties_Check(PyObject *obj)
{
    return (obj->ob_type == &EnginePropertiesType);
}

EngineProperties *
PyEngineProperties_FromPyObject(PyObject *obj)
{
    EnginePropertiesObject *obj2 = (EnginePropertiesObject *)obj;
    return obj2->data;
}

PyObject *
PyEngineProperties_New()
{
    return NewEngineProperties(0);
}

PyObject *
PyEngineProperties_Wrap(const EngineProperties *attr)
{
    return WrapEngineProperties(attr);
}

void
PyEngineProperties_SetParent(PyObject *obj, PyObject *parent)
{
    EnginePropertiesObject *obj2 = (EnginePropertiesObject *)obj;
    obj2->parent = parent;
}

void
PyEngineProperties_SetDefaults(const EngineProperties *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new EngineProperties(*atts);
}

