// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyColorControlPoint.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyColorControlPoint
//
// Purpose:
//   This class contains an RGBA color with a position value.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ColorControlPoint.
//
struct ColorControlPointObject
{
    PyObject_HEAD
    ColorControlPoint *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewColorControlPoint(int);

std::string
PyColorControlPoint_ToString(const ColorControlPoint *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const unsigned char *colors = atts->GetColors();
        snprintf(tmpStr, 1000, "%scolors = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 4; ++i)
        {
            snprintf(tmpStr, 1000, "%d", int(colors[i]));
            str += tmpStr;
            if(i < 3)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sposition = %g\n", prefix, atts->GetPosition());
    str += tmpStr;
    return str;
}

static PyObject *
ColorControlPoint_Notify(PyObject *self, PyObject *args)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPoint_SetColors(PyObject *self, PyObject *args)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)self;

    unsigned char *cvals = obj->data->GetColors();
    if(!PyArg_ParseTuple(args, "cccc", &cvals[0], &cvals[1], &cvals[2], &cvals[3]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 4)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                int c;
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    c = int(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    c = int(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    c = int(PyLong_AsDouble(item));
                else
                    c = 0;

                if(c < 0) c = 0;
                if(c > 255) c = 255;
                cvals[i] = (unsigned char)(c);
            }
        }
        else
            return NULL;
    }

    // Mark the colors in the object as modified.
    obj->data->SelectColors();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPoint_GetColors(PyObject *self, PyObject *args)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)self;
    // Allocate a tuple the with enough entries to hold the colors.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *colors = obj->data->GetColors();
    for(int i = 0; i < 4; ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(colors[i])));
    return retval;
}

/*static*/ PyObject *
ColorControlPoint_SetPosition(PyObject *self, PyObject *args)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the position in the object.
    obj->data->SetPosition(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ColorControlPoint_GetPosition(PyObject *self, PyObject *args)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetPosition()));
    return retval;
}



PyMethodDef PyColorControlPoint_methods[COLORCONTROLPOINT_NMETH] = {
    {"Notify", ColorControlPoint_Notify, METH_VARARGS},
    {"SetColors", ColorControlPoint_SetColors, METH_VARARGS},
    {"GetColors", ColorControlPoint_GetColors, METH_VARARGS},
    {"SetPosition", ColorControlPoint_SetPosition, METH_VARARGS},
    {"GetPosition", ColorControlPoint_GetPosition, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ColorControlPoint_dealloc(PyObject *v)
{
   ColorControlPointObject *obj = (ColorControlPointObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ColorControlPoint_compare(PyObject *v, PyObject *w)
{
    ColorControlPoint *a = ((ColorControlPointObject *)v)->data;
    ColorControlPoint *b = ((ColorControlPointObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyColorControlPoint_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "colors") == 0)
        return ColorControlPoint_GetColors(self, NULL);
    if(strcmp(name, "position") == 0)
        return ColorControlPoint_GetPosition(self, NULL);

    return Py_FindMethod(PyColorControlPoint_methods, self, name);
}

int
PyColorControlPoint_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "colors") == 0)
        obj = ColorControlPoint_SetColors(self, tuple);
    else if(strcmp(name, "position") == 0)
        obj = ColorControlPoint_SetPosition(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ColorControlPoint_print(PyObject *v, FILE *fp, int flags)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)v;
    fprintf(fp, "%s", PyColorControlPoint_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ColorControlPoint_str(PyObject *v)
{
    ColorControlPointObject *obj = (ColorControlPointObject *)v;
    return PyString_FromString(PyColorControlPoint_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ColorControlPoint_Purpose = "This class contains an RGBA color with a position value.";
#else
static char *ColorControlPoint_Purpose = "This class contains an RGBA color with a position value.";
#endif

//
// The type description structure
//
static PyTypeObject ColorControlPointType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ColorControlPoint",                    // tp_name
    sizeof(ColorControlPointObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ColorControlPoint_dealloc,  // tp_dealloc
    (printfunc)ColorControlPoint_print,     // tp_print
    (getattrfunc)PyColorControlPoint_getattr, // tp_getattr
    (setattrfunc)PyColorControlPoint_setattr, // tp_setattr
    (cmpfunc)ColorControlPoint_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ColorControlPoint_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ColorControlPoint_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ColorControlPoint *defaultAtts = 0;
static ColorControlPoint *currentAtts = 0;

static PyObject *
NewColorControlPoint(int useCurrent)
{
    ColorControlPointObject *newObject;
    newObject = PyObject_NEW(ColorControlPointObject, &ColorControlPointType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ColorControlPoint(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ColorControlPoint(*defaultAtts);
    else
        newObject->data = new ColorControlPoint;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapColorControlPoint(const ColorControlPoint *attr)
{
    ColorControlPointObject *newObject;
    newObject = PyObject_NEW(ColorControlPointObject, &ColorControlPointType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ColorControlPoint *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ColorControlPoint_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewColorControlPoint(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ColorControlPointMethods[] = {
    {"ColorControlPoint", ColorControlPoint_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ColorControlPointObserver = 0;

std::string
PyColorControlPoint_GetLogString()
{
    std::string s("ColorControlPoint = ColorControlPoint()\n");
    if(currentAtts != 0)
        s += PyColorControlPoint_ToString(currentAtts, "ColorControlPoint.");
    return s;
}

static void
PyColorControlPoint_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ColorControlPoint = ColorControlPoint()\n");
        s += PyColorControlPoint_ToString(currentAtts, "ColorControlPoint.");
        cb(s);
    }
}

void
PyColorControlPoint_StartUp(ColorControlPoint *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyColorControlPoint_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ColorControlPointObserver == 0)
    {
        ColorControlPointObserver = new ObserverToCallback(subj,
            PyColorControlPoint_CallLogRoutine, (void *)data);
    }

}

void
PyColorControlPoint_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ColorControlPointObserver;
    ColorControlPointObserver = 0;
}

PyMethodDef *
PyColorControlPoint_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ColorControlPointMethods;
}

bool
PyColorControlPoint_Check(PyObject *obj)
{
    return (obj->ob_type == &ColorControlPointType);
}

ColorControlPoint *
PyColorControlPoint_FromPyObject(PyObject *obj)
{
    ColorControlPointObject *obj2 = (ColorControlPointObject *)obj;
    return obj2->data;
}

PyObject *
PyColorControlPoint_New()
{
    return NewColorControlPoint(0);
}

PyObject *
PyColorControlPoint_Wrap(const ColorControlPoint *attr)
{
    return WrapColorControlPoint(attr);
}

void
PyColorControlPoint_SetParent(PyObject *obj, PyObject *parent)
{
    ColorControlPointObject *obj2 = (ColorControlPointObject *)obj;
    obj2->parent = parent;
}

void
PyColorControlPoint_SetDefaults(const ColorControlPoint *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ColorControlPoint(*atts);
}

