// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyAxisTickMarks.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyAxisTickMarks
//
// Purpose:
//   Contains the tick mark properties for one axis.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AxisTickMarks.
//
struct AxisTickMarksObject
{
    PyObject_HEAD
    AxisTickMarks *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxisTickMarks(int);

std::string
PyAxisTickMarks_ToString(const AxisTickMarks *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetVisible())
        snprintf(tmpStr, 1000, "%svisible = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svisible = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smajorMinimum = %g\n", prefix, atts->GetMajorMinimum());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smajorMaximum = %g\n", prefix, atts->GetMajorMaximum());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sminorSpacing = %g\n", prefix, atts->GetMinorSpacing());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smajorSpacing = %g\n", prefix, atts->GetMajorSpacing());
    str += tmpStr;
    return str;
}

static PyObject *
AxisTickMarks_Notify(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_SetVisible(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_GetVisible(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AxisTickMarks_SetMajorMinimum(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the majorMinimum in the object.
    obj->data->SetMajorMinimum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_GetMajorMinimum(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMajorMinimum());
    return retval;
}

/*static*/ PyObject *
AxisTickMarks_SetMajorMaximum(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the majorMaximum in the object.
    obj->data->SetMajorMaximum(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_GetMajorMaximum(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMajorMaximum());
    return retval;
}

/*static*/ PyObject *
AxisTickMarks_SetMinorSpacing(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the minorSpacing in the object.
    obj->data->SetMinorSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_GetMinorSpacing(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMinorSpacing());
    return retval;
}

/*static*/ PyObject *
AxisTickMarks_SetMajorSpacing(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the majorSpacing in the object.
    obj->data->SetMajorSpacing(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AxisTickMarks_GetMajorSpacing(PyObject *self, PyObject *args)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMajorSpacing());
    return retval;
}



PyMethodDef PyAxisTickMarks_methods[AXISTICKMARKS_NMETH] = {
    {"Notify", AxisTickMarks_Notify, METH_VARARGS},
    {"SetVisible", AxisTickMarks_SetVisible, METH_VARARGS},
    {"GetVisible", AxisTickMarks_GetVisible, METH_VARARGS},
    {"SetMajorMinimum", AxisTickMarks_SetMajorMinimum, METH_VARARGS},
    {"GetMajorMinimum", AxisTickMarks_GetMajorMinimum, METH_VARARGS},
    {"SetMajorMaximum", AxisTickMarks_SetMajorMaximum, METH_VARARGS},
    {"GetMajorMaximum", AxisTickMarks_GetMajorMaximum, METH_VARARGS},
    {"SetMinorSpacing", AxisTickMarks_SetMinorSpacing, METH_VARARGS},
    {"GetMinorSpacing", AxisTickMarks_GetMinorSpacing, METH_VARARGS},
    {"SetMajorSpacing", AxisTickMarks_SetMajorSpacing, METH_VARARGS},
    {"GetMajorSpacing", AxisTickMarks_GetMajorSpacing, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AxisTickMarks_dealloc(PyObject *v)
{
   AxisTickMarksObject *obj = (AxisTickMarksObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AxisTickMarks_compare(PyObject *v, PyObject *w)
{
    AxisTickMarks *a = ((AxisTickMarksObject *)v)->data;
    AxisTickMarks *b = ((AxisTickMarksObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAxisTickMarks_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return AxisTickMarks_GetVisible(self, NULL);
    if(strcmp(name, "majorMinimum") == 0)
        return AxisTickMarks_GetMajorMinimum(self, NULL);
    if(strcmp(name, "majorMaximum") == 0)
        return AxisTickMarks_GetMajorMaximum(self, NULL);
    if(strcmp(name, "minorSpacing") == 0)
        return AxisTickMarks_GetMinorSpacing(self, NULL);
    if(strcmp(name, "majorSpacing") == 0)
        return AxisTickMarks_GetMajorSpacing(self, NULL);

    return Py_FindMethod(PyAxisTickMarks_methods, self, name);
}

int
PyAxisTickMarks_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "visible") == 0)
        obj = AxisTickMarks_SetVisible(self, tuple);
    else if(strcmp(name, "majorMinimum") == 0)
        obj = AxisTickMarks_SetMajorMinimum(self, tuple);
    else if(strcmp(name, "majorMaximum") == 0)
        obj = AxisTickMarks_SetMajorMaximum(self, tuple);
    else if(strcmp(name, "minorSpacing") == 0)
        obj = AxisTickMarks_SetMinorSpacing(self, tuple);
    else if(strcmp(name, "majorSpacing") == 0)
        obj = AxisTickMarks_SetMajorSpacing(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AxisTickMarks_print(PyObject *v, FILE *fp, int flags)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)v;
    fprintf(fp, "%s", PyAxisTickMarks_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AxisTickMarks_str(PyObject *v)
{
    AxisTickMarksObject *obj = (AxisTickMarksObject *)v;
    return PyString_FromString(PyAxisTickMarks_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AxisTickMarks_Purpose = "Contains the tick mark properties for one axis.";
#else
static char *AxisTickMarks_Purpose = "Contains the tick mark properties for one axis.";
#endif

//
// The type description structure
//
static PyTypeObject AxisTickMarksType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AxisTickMarks",                    // tp_name
    sizeof(AxisTickMarksObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AxisTickMarks_dealloc,  // tp_dealloc
    (printfunc)AxisTickMarks_print,     // tp_print
    (getattrfunc)PyAxisTickMarks_getattr, // tp_getattr
    (setattrfunc)PyAxisTickMarks_setattr, // tp_setattr
    (cmpfunc)AxisTickMarks_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AxisTickMarks_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AxisTickMarks_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AxisTickMarks *defaultAtts = 0;
static AxisTickMarks *currentAtts = 0;

static PyObject *
NewAxisTickMarks(int useCurrent)
{
    AxisTickMarksObject *newObject;
    newObject = PyObject_NEW(AxisTickMarksObject, &AxisTickMarksType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AxisTickMarks(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AxisTickMarks(*defaultAtts);
    else
        newObject->data = new AxisTickMarks;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxisTickMarks(const AxisTickMarks *attr)
{
    AxisTickMarksObject *newObject;
    newObject = PyObject_NEW(AxisTickMarksObject, &AxisTickMarksType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AxisTickMarks *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AxisTickMarks_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxisTickMarks(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AxisTickMarksMethods[] = {
    {"AxisTickMarks", AxisTickMarks_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AxisTickMarksObserver = 0;

std::string
PyAxisTickMarks_GetLogString()
{
    std::string s("AxisTickMarks = AxisTickMarks()\n");
    if(currentAtts != 0)
        s += PyAxisTickMarks_ToString(currentAtts, "AxisTickMarks.");
    return s;
}

static void
PyAxisTickMarks_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AxisTickMarks = AxisTickMarks()\n");
        s += PyAxisTickMarks_ToString(currentAtts, "AxisTickMarks.");
        cb(s);
    }
}

void
PyAxisTickMarks_StartUp(AxisTickMarks *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxisTickMarks_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AxisTickMarksObserver == 0)
    {
        AxisTickMarksObserver = new ObserverToCallback(subj,
            PyAxisTickMarks_CallLogRoutine, (void *)data);
    }

}

void
PyAxisTickMarks_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AxisTickMarksObserver;
    AxisTickMarksObserver = 0;
}

PyMethodDef *
PyAxisTickMarks_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AxisTickMarksMethods;
}

bool
PyAxisTickMarks_Check(PyObject *obj)
{
    return (obj->ob_type == &AxisTickMarksType);
}

AxisTickMarks *
PyAxisTickMarks_FromPyObject(PyObject *obj)
{
    AxisTickMarksObject *obj2 = (AxisTickMarksObject *)obj;
    return obj2->data;
}

PyObject *
PyAxisTickMarks_New()
{
    return NewAxisTickMarks(0);
}

PyObject *
PyAxisTickMarks_Wrap(const AxisTickMarks *attr)
{
    return WrapAxisTickMarks(attr);
}

void
PyAxisTickMarks_SetParent(PyObject *obj, PyObject *parent)
{
    AxisTickMarksObject *obj2 = (AxisTickMarksObject *)obj;
    obj2->parent = parent;
}

void
PyAxisTickMarks_SetDefaults(const AxisTickMarks *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AxisTickMarks(*atts);
}

