// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyAxes2D.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <PyAxisAttributes.h>
#include <PyAxisAttributes.h>

// ****************************************************************************
// Module: PyAxes2D
//
// Purpose:
//   Contains the properties for the 2D axes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a Axes2D.
//
struct Axes2DObject
{
    PyObject_HEAD
    Axes2D *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAxes2D(int);

std::string
PyAxes2D_ToString(const Axes2D *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetVisible())
        snprintf(tmpStr, 1000, "%svisible = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%svisible = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutoSetTicks())
        snprintf(tmpStr, 1000, "%sautoSetTicks = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sautoSetTicks = 0\n", prefix);
    str += tmpStr;
    if(atts->GetAutoSetScaling())
        snprintf(tmpStr, 1000, "%sautoSetScaling = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sautoSetScaling = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%slineWidth = %d\n", prefix, atts->GetLineWidth());
    str += tmpStr;
    const char *tickLocation_names = "Inside, Outside, Both";
    switch (atts->GetTickLocation())
    {
      case Axes2D::Inside:
          snprintf(tmpStr, 1000, "%stickLocation = %sInside  # %s\n", prefix, prefix, tickLocation_names);
          str += tmpStr;
          break;
      case Axes2D::Outside:
          snprintf(tmpStr, 1000, "%stickLocation = %sOutside  # %s\n", prefix, prefix, tickLocation_names);
          str += tmpStr;
          break;
      case Axes2D::Both:
          snprintf(tmpStr, 1000, "%stickLocation = %sBoth  # %s\n", prefix, prefix, tickLocation_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *tickAxes_names = "Off, Bottom, Left, BottomLeft, All";
    switch (atts->GetTickAxes())
    {
      case Axes2D::Off:
          snprintf(tmpStr, 1000, "%stickAxes = %sOff  # %s\n", prefix, prefix, tickAxes_names);
          str += tmpStr;
          break;
      case Axes2D::Bottom:
          snprintf(tmpStr, 1000, "%stickAxes = %sBottom  # %s\n", prefix, prefix, tickAxes_names);
          str += tmpStr;
          break;
      case Axes2D::Left:
          snprintf(tmpStr, 1000, "%stickAxes = %sLeft  # %s\n", prefix, prefix, tickAxes_names);
          str += tmpStr;
          break;
      case Axes2D::BottomLeft:
          snprintf(tmpStr, 1000, "%stickAxes = %sBottomLeft  # %s\n", prefix, prefix, tickAxes_names);
          str += tmpStr;
          break;
      case Axes2D::All:
          snprintf(tmpStr, 1000, "%stickAxes = %sAll  # %s\n", prefix, prefix, tickAxes_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "xAxis.";
        str += PyAxisAttributes_ToString(&atts->GetXAxis(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "yAxis.";
        str += PyAxisAttributes_ToString(&atts->GetYAxis(), objPrefix.c_str());
    }
    return str;
}

static PyObject *
Axes2D_Notify(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_SetVisible(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetVisible(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Axes2D_SetAutoSetTicks(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoSetTicks in the object.
    obj->data->SetAutoSetTicks(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetAutoSetTicks(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoSetTicks()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Axes2D_SetAutoSetScaling(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the autoSetScaling in the object.
    obj->data->SetAutoSetScaling(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetAutoSetScaling(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAutoSetScaling()?1L:0L);
    return retval;
}

/*static*/ PyObject *
Axes2D_SetLineWidth(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lineWidth in the object.
    obj->data->SetLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetLineWidth(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetLineWidth()));
    return retval;
}

/*static*/ PyObject *
Axes2D_SetTickLocation(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tickLocation in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTickLocation(Axes2D::Location(ival));
    else
    {
        fprintf(stderr, "An invalid tickLocation value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Inside, Outside, Both.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetTickLocation(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTickLocation()));
    return retval;
}

/*static*/ PyObject *
Axes2D_SetTickAxes(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the tickAxes in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetTickAxes(Axes2D::Ticks(ival));
    else
    {
        fprintf(stderr, "An invalid tickAxes value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "Off, Bottom, Left, BottomLeft, All"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetTickAxes(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTickAxes()));
    return retval;
}

/*static*/ PyObject *
Axes2D_SetXAxis(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxisAttributes_Check(newValue))
    {
        fprintf(stderr, "The xAxis field can only be set with AxisAttributes objects.\n");
        return NULL;
    }

    obj->data->SetXAxis(*PyAxisAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetXAxis(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxisAttributes_Wrap(&obj->data->GetXAxis());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxisAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
Axes2D_SetYAxis(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxisAttributes_Check(newValue))
    {
        fprintf(stderr, "The yAxis field can only be set with AxisAttributes objects.\n");
        return NULL;
    }

    obj->data->SetYAxis(*PyAxisAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
Axes2D_GetYAxis(PyObject *self, PyObject *args)
{
    Axes2DObject *obj = (Axes2DObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxisAttributes_Wrap(&obj->data->GetYAxis());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxisAttributes_SetParent(retval, self);

    return retval;
}



PyMethodDef PyAxes2D_methods[AXES2D_NMETH] = {
    {"Notify", Axes2D_Notify, METH_VARARGS},
    {"SetVisible", Axes2D_SetVisible, METH_VARARGS},
    {"GetVisible", Axes2D_GetVisible, METH_VARARGS},
    {"SetAutoSetTicks", Axes2D_SetAutoSetTicks, METH_VARARGS},
    {"GetAutoSetTicks", Axes2D_GetAutoSetTicks, METH_VARARGS},
    {"SetAutoSetScaling", Axes2D_SetAutoSetScaling, METH_VARARGS},
    {"GetAutoSetScaling", Axes2D_GetAutoSetScaling, METH_VARARGS},
    {"SetLineWidth", Axes2D_SetLineWidth, METH_VARARGS},
    {"GetLineWidth", Axes2D_GetLineWidth, METH_VARARGS},
    {"SetTickLocation", Axes2D_SetTickLocation, METH_VARARGS},
    {"GetTickLocation", Axes2D_GetTickLocation, METH_VARARGS},
    {"SetTickAxes", Axes2D_SetTickAxes, METH_VARARGS},
    {"GetTickAxes", Axes2D_GetTickAxes, METH_VARARGS},
    {"SetXAxis", Axes2D_SetXAxis, METH_VARARGS},
    {"GetXAxis", Axes2D_GetXAxis, METH_VARARGS},
    {"SetYAxis", Axes2D_SetYAxis, METH_VARARGS},
    {"GetYAxis", Axes2D_GetYAxis, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
Axes2D_dealloc(PyObject *v)
{
   Axes2DObject *obj = (Axes2DObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
Axes2D_compare(PyObject *v, PyObject *w)
{
    Axes2D *a = ((Axes2DObject *)v)->data;
    Axes2D *b = ((Axes2DObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAxes2D_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return Axes2D_GetVisible(self, NULL);
    if(strcmp(name, "autoSetTicks") == 0)
        return Axes2D_GetAutoSetTicks(self, NULL);
    if(strcmp(name, "autoSetScaling") == 0)
        return Axes2D_GetAutoSetScaling(self, NULL);
    if(strcmp(name, "lineWidth") == 0)
        return Axes2D_GetLineWidth(self, NULL);
    if(strcmp(name, "tickLocation") == 0)
        return Axes2D_GetTickLocation(self, NULL);
    if(strcmp(name, "Inside") == 0)
        return PyInt_FromLong(long(Axes2D::Inside));
    if(strcmp(name, "Outside") == 0)
        return PyInt_FromLong(long(Axes2D::Outside));
    if(strcmp(name, "Both") == 0)
        return PyInt_FromLong(long(Axes2D::Both));

    if(strcmp(name, "tickAxes") == 0)
        return Axes2D_GetTickAxes(self, NULL);
    if(strcmp(name, "Off") == 0)
        return PyInt_FromLong(long(Axes2D::Off));
    if(strcmp(name, "Bottom") == 0)
        return PyInt_FromLong(long(Axes2D::Bottom));
    if(strcmp(name, "Left") == 0)
        return PyInt_FromLong(long(Axes2D::Left));
    if(strcmp(name, "BottomLeft") == 0)
        return PyInt_FromLong(long(Axes2D::BottomLeft));
    if(strcmp(name, "All") == 0)
        return PyInt_FromLong(long(Axes2D::All));

    if(strcmp(name, "xAxis") == 0)
        return Axes2D_GetXAxis(self, NULL);
    if(strcmp(name, "yAxis") == 0)
        return Axes2D_GetYAxis(self, NULL);

    return Py_FindMethod(PyAxes2D_methods, self, name);
}

int
PyAxes2D_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "visible") == 0)
        obj = Axes2D_SetVisible(self, tuple);
    else if(strcmp(name, "autoSetTicks") == 0)
        obj = Axes2D_SetAutoSetTicks(self, tuple);
    else if(strcmp(name, "autoSetScaling") == 0)
        obj = Axes2D_SetAutoSetScaling(self, tuple);
    else if(strcmp(name, "lineWidth") == 0)
        obj = Axes2D_SetLineWidth(self, tuple);
    else if(strcmp(name, "tickLocation") == 0)
        obj = Axes2D_SetTickLocation(self, tuple);
    else if(strcmp(name, "tickAxes") == 0)
        obj = Axes2D_SetTickAxes(self, tuple);
    else if(strcmp(name, "xAxis") == 0)
        obj = Axes2D_SetXAxis(self, tuple);
    else if(strcmp(name, "yAxis") == 0)
        obj = Axes2D_SetYAxis(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
Axes2D_print(PyObject *v, FILE *fp, int flags)
{
    Axes2DObject *obj = (Axes2DObject *)v;
    fprintf(fp, "%s", PyAxes2D_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
Axes2D_str(PyObject *v)
{
    Axes2DObject *obj = (Axes2DObject *)v;
    return PyString_FromString(PyAxes2D_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *Axes2D_Purpose = "Contains the properties for the 2D axes.";
#else
static char *Axes2D_Purpose = "Contains the properties for the 2D axes.";
#endif

//
// The type description structure
//
static PyTypeObject Axes2DType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "Axes2D",                    // tp_name
    sizeof(Axes2DObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)Axes2D_dealloc,  // tp_dealloc
    (printfunc)Axes2D_print,     // tp_print
    (getattrfunc)PyAxes2D_getattr, // tp_getattr
    (setattrfunc)PyAxes2D_setattr, // tp_setattr
    (cmpfunc)Axes2D_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)Axes2D_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    Axes2D_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static Axes2D *defaultAtts = 0;
static Axes2D *currentAtts = 0;

static PyObject *
NewAxes2D(int useCurrent)
{
    Axes2DObject *newObject;
    newObject = PyObject_NEW(Axes2DObject, &Axes2DType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new Axes2D(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new Axes2D(*defaultAtts);
    else
        newObject->data = new Axes2D;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAxes2D(const Axes2D *attr)
{
    Axes2DObject *newObject;
    newObject = PyObject_NEW(Axes2DObject, &Axes2DType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (Axes2D *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
Axes2D_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAxes2D(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef Axes2DMethods[] = {
    {"Axes2D", Axes2D_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *Axes2DObserver = 0;

std::string
PyAxes2D_GetLogString()
{
    std::string s("Axes2D = Axes2D()\n");
    if(currentAtts != 0)
        s += PyAxes2D_ToString(currentAtts, "Axes2D.");
    return s;
}

static void
PyAxes2D_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("Axes2D = Axes2D()\n");
        s += PyAxes2D_ToString(currentAtts, "Axes2D.");
        cb(s);
    }
}

void
PyAxes2D_StartUp(Axes2D *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAxes2D_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(Axes2DObserver == 0)
    {
        Axes2DObserver = new ObserverToCallback(subj,
            PyAxes2D_CallLogRoutine, (void *)data);
    }

}

void
PyAxes2D_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete Axes2DObserver;
    Axes2DObserver = 0;
}

PyMethodDef *
PyAxes2D_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return Axes2DMethods;
}

bool
PyAxes2D_Check(PyObject *obj)
{
    return (obj->ob_type == &Axes2DType);
}

Axes2D *
PyAxes2D_FromPyObject(PyObject *obj)
{
    Axes2DObject *obj2 = (Axes2DObject *)obj;
    return obj2->data;
}

PyObject *
PyAxes2D_New()
{
    return NewAxes2D(0);
}

PyObject *
PyAxes2D_Wrap(const Axes2D *attr)
{
    return WrapAxes2D(attr);
}

void
PyAxes2D_SetParent(PyObject *obj, PyObject *parent)
{
    Axes2DObject *obj2 = (Axes2DObject *)obj;
    obj2->parent = parent;
}

void
PyAxes2D_SetDefaults(const Axes2D *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new Axes2D(*atts);
}

