// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyAnnotationAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <PyAxes2D.h>
#include <PyAxes3D.h>
#include <PyFontAttributes.h>
#include <PyFontAttributes.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <ColorAttribute.h>
#include <PyAxesArray.h>

// ****************************************************************************
// Module: PyAnnotationAttributes
//
// Purpose:
//   This class contains the attributes controlling annotations.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a AnnotationAttributes.
//
struct AnnotationAttributesObject
{
    PyObject_HEAD
    AnnotationAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewAnnotationAttributes(int);

std::string
PyAnnotationAttributes_ToString(const AnnotationAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "axes2D.";
        str += PyAxes2D_ToString(&atts->GetAxes2D(), objPrefix.c_str());
    }
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "axes3D.";
        str += PyAxes3D_ToString(&atts->GetAxes3D(), objPrefix.c_str());
    }
    if(atts->GetUserInfoFlag())
        snprintf(tmpStr, 1000, "%suserInfoFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suserInfoFlag = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "userInfoFont.";
        str += PyFontAttributes_ToString(&atts->GetUserInfoFont(), objPrefix.c_str());
    }
    if(atts->GetDatabaseInfoFlag())
        snprintf(tmpStr, 1000, "%sdatabaseInfoFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sdatabaseInfoFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetTimeInfoFlag())
        snprintf(tmpStr, 1000, "%stimeInfoFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%stimeInfoFlag = 0\n", prefix);
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "databaseInfoFont.";
        str += PyFontAttributes_ToString(&atts->GetDatabaseInfoFont(), objPrefix.c_str());
    }
    const char *databaseInfoExpansionMode_names = "File, Directory, Full, Smart, SmartDirectory";
    switch (atts->GetDatabaseInfoExpansionMode())
    {
      case AnnotationAttributes::File:
          snprintf(tmpStr, 1000, "%sdatabaseInfoExpansionMode = %sFile  # %s\n", prefix, prefix, databaseInfoExpansionMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Directory:
          snprintf(tmpStr, 1000, "%sdatabaseInfoExpansionMode = %sDirectory  # %s\n", prefix, prefix, databaseInfoExpansionMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Full:
          snprintf(tmpStr, 1000, "%sdatabaseInfoExpansionMode = %sFull  # %s\n", prefix, prefix, databaseInfoExpansionMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Smart:
          snprintf(tmpStr, 1000, "%sdatabaseInfoExpansionMode = %sSmart  # %s\n", prefix, prefix, databaseInfoExpansionMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::SmartDirectory:
          snprintf(tmpStr, 1000, "%sdatabaseInfoExpansionMode = %sSmartDirectory  # %s\n", prefix, prefix, databaseInfoExpansionMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sdatabaseInfoTimeScale = %g\n", prefix, atts->GetDatabaseInfoTimeScale());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sdatabaseInfoTimeOffset = %g\n", prefix, atts->GetDatabaseInfoTimeOffset());
    str += tmpStr;
    if(atts->GetLegendInfoFlag())
        snprintf(tmpStr, 1000, "%slegendInfoFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slegendInfoFlag = 0\n", prefix);
    str += tmpStr;
    const unsigned char *backgroundColor = atts->GetBackgroundColor().GetColor();
    snprintf(tmpStr, 1000, "%sbackgroundColor = (%d, %d, %d, %d)\n", prefix, int(backgroundColor[0]), int(backgroundColor[1]), int(backgroundColor[2]), int(backgroundColor[3]));
    str += tmpStr;
    const unsigned char *foregroundColor = atts->GetForegroundColor().GetColor();
    snprintf(tmpStr, 1000, "%sforegroundColor = (%d, %d, %d, %d)\n", prefix, int(foregroundColor[0]), int(foregroundColor[1]), int(foregroundColor[2]), int(foregroundColor[3]));
    str += tmpStr;
    const char *gradientBackgroundStyle_names = "TopToBottom, BottomToTop, LeftToRight, RightToLeft, Radial";
    switch (atts->GetGradientBackgroundStyle())
    {
      case AnnotationAttributes::TopToBottom:
          snprintf(tmpStr, 1000, "%sgradientBackgroundStyle = %sTopToBottom  # %s\n", prefix, prefix, gradientBackgroundStyle_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::BottomToTop:
          snprintf(tmpStr, 1000, "%sgradientBackgroundStyle = %sBottomToTop  # %s\n", prefix, prefix, gradientBackgroundStyle_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::LeftToRight:
          snprintf(tmpStr, 1000, "%sgradientBackgroundStyle = %sLeftToRight  # %s\n", prefix, prefix, gradientBackgroundStyle_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::RightToLeft:
          snprintf(tmpStr, 1000, "%sgradientBackgroundStyle = %sRightToLeft  # %s\n", prefix, prefix, gradientBackgroundStyle_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Radial:
          snprintf(tmpStr, 1000, "%sgradientBackgroundStyle = %sRadial  # %s\n", prefix, prefix, gradientBackgroundStyle_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *gradientColor1 = atts->GetGradientColor1().GetColor();
    snprintf(tmpStr, 1000, "%sgradientColor1 = (%d, %d, %d, %d)\n", prefix, int(gradientColor1[0]), int(gradientColor1[1]), int(gradientColor1[2]), int(gradientColor1[3]));
    str += tmpStr;
    const unsigned char *gradientColor2 = atts->GetGradientColor2().GetColor();
    snprintf(tmpStr, 1000, "%sgradientColor2 = (%d, %d, %d, %d)\n", prefix, int(gradientColor2[0]), int(gradientColor2[1]), int(gradientColor2[2]), int(gradientColor2[3]));
    str += tmpStr;
    const char *backgroundMode_names = "Solid, Gradient, Image, ImageSphere";
    switch (atts->GetBackgroundMode())
    {
      case AnnotationAttributes::Solid:
          snprintf(tmpStr, 1000, "%sbackgroundMode = %sSolid  # %s\n", prefix, prefix, backgroundMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Gradient:
          snprintf(tmpStr, 1000, "%sbackgroundMode = %sGradient  # %s\n", prefix, prefix, backgroundMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::Image:
          snprintf(tmpStr, 1000, "%sbackgroundMode = %sImage  # %s\n", prefix, prefix, backgroundMode_names);
          str += tmpStr;
          break;
      case AnnotationAttributes::ImageSphere:
          snprintf(tmpStr, 1000, "%sbackgroundMode = %sImageSphere  # %s\n", prefix, prefix, backgroundMode_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sbackgroundImage = \"%s\"\n", prefix, atts->GetBackgroundImage().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%simageRepeatX = %d\n", prefix, atts->GetImageRepeatX());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%simageRepeatY = %d\n", prefix, atts->GetImageRepeatY());
    str += tmpStr;
    { // new scope
        std::string objPrefix(prefix);
        objPrefix += "axesArray.";
        str += PyAxesArray_ToString(&atts->GetAxesArray(), objPrefix.c_str());
    }
    return str;
}

static PyObject *
AnnotationAttributes_Notify(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_SetAxes2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxes2D_Check(newValue))
    {
        fprintf(stderr, "The axes2D field can only be set with Axes2D objects.\n");
        return NULL;
    }

    obj->data->SetAxes2D(*PyAxes2D_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetAxes2D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxes2D_Wrap(&obj->data->GetAxes2D());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxes2D_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetAxes3D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxes3D_Check(newValue))
    {
        fprintf(stderr, "The axes3D field can only be set with Axes3D objects.\n");
        return NULL;
    }

    obj->data->SetAxes3D(*PyAxes3D_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetAxes3D(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxes3D_Wrap(&obj->data->GetAxes3D());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxes3D_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetUserInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the userInfoFlag in the object.
    obj->data->SetUserInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetUserInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUserInfoFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetUserInfoFont(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The userInfoFont field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetUserInfoFont(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetUserInfoFont(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetUserInfoFont());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetDatabaseInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the databaseInfoFlag in the object.
    obj->data->SetDatabaseInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetDatabaseInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDatabaseInfoFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetTimeInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeInfoFlag in the object.
    obj->data->SetTimeInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetTimeInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTimeInfoFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetDatabaseInfoFont(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyFontAttributes_Check(newValue))
    {
        fprintf(stderr, "The databaseInfoFont field can only be set with FontAttributes objects.\n");
        return NULL;
    }

    obj->data->SetDatabaseInfoFont(*PyFontAttributes_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetDatabaseInfoFont(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyFontAttributes_Wrap(&obj->data->GetDatabaseInfoFont());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyFontAttributes_SetParent(retval, self);

    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetDatabaseInfoExpansionMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the databaseInfoExpansionMode in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetDatabaseInfoExpansionMode(AnnotationAttributes::PathExpansionMode(ival));
    else
    {
        fprintf(stderr, "An invalid databaseInfoExpansionMode value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "File, Directory, Full, Smart, SmartDirectory"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetDatabaseInfoExpansionMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDatabaseInfoExpansionMode()));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetDatabaseInfoTimeScale(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the databaseInfoTimeScale in the object.
    obj->data->SetDatabaseInfoTimeScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetDatabaseInfoTimeScale(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDatabaseInfoTimeScale());
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetDatabaseInfoTimeOffset(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the databaseInfoTimeOffset in the object.
    obj->data->SetDatabaseInfoTimeOffset(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetDatabaseInfoTimeOffset(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetDatabaseInfoTimeOffset());
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetLegendInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendInfoFlag in the object.
    obj->data->SetLegendInfoFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetLegendInfoFlag(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendInfoFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetBackgroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the backgroundColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetBackgroundColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetBackgroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the backgroundColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *backgroundColor = obj->data->GetBackgroundColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(backgroundColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(backgroundColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(backgroundColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(backgroundColor[3])));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetForegroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the foregroundColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetForegroundColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetForegroundColor(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the foregroundColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *foregroundColor = obj->data->GetForegroundColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(foregroundColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(foregroundColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(foregroundColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(foregroundColor[3])));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetGradientBackgroundStyle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the gradientBackgroundStyle in the object.
    if(ival >= 0 && ival < 5)
        obj->data->SetGradientBackgroundStyle(AnnotationAttributes::GradientStyle(ival));
    else
    {
        fprintf(stderr, "An invalid gradientBackgroundStyle value was given. "
                        "Valid values are in the range of [0,4]. "
                        "You can also use the following names: "
                        "TopToBottom, BottomToTop, LeftToRight, RightToLeft, Radial"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetGradientBackgroundStyle(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetGradientBackgroundStyle()));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetGradientColor1(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the gradientColor1 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetGradientColor1(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetGradientColor1(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the gradientColor1.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *gradientColor1 = obj->data->GetGradientColor1().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(gradientColor1[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(gradientColor1[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(gradientColor1[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(gradientColor1[3])));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetGradientColor2(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the gradientColor2 in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetGradientColor2(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetGradientColor2(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the gradientColor2.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *gradientColor2 = obj->data->GetGradientColor2().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(gradientColor2[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(gradientColor2[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(gradientColor2[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(gradientColor2[3])));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetBackgroundMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the backgroundMode in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetBackgroundMode(AnnotationAttributes::BackgroundMode(ival));
    else
    {
        fprintf(stderr, "An invalid backgroundMode value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Solid, Gradient, Image, ImageSphere.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetBackgroundMode(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBackgroundMode()));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetBackgroundImage(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the backgroundImage in the object.
    obj->data->SetBackgroundImage(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetBackgroundImage(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetBackgroundImage().c_str());
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetImageRepeatX(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the imageRepeatX in the object.
    obj->data->SetImageRepeatX((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetImageRepeatX(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetImageRepeatX()));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetImageRepeatY(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the imageRepeatY in the object.
    obj->data->SetImageRepeatY((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetImageRepeatY(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetImageRepeatY()));
    return retval;
}

/*static*/ PyObject *
AnnotationAttributes_SetAxesArray(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;

    PyObject *newValue = NULL;
    if(!PyArg_ParseTuple(args, "O", &newValue))
        return NULL;
    if(!PyAxesArray_Check(newValue))
    {
        fprintf(stderr, "The axesArray field can only be set with AxesArray objects.\n");
        return NULL;
    }

    obj->data->SetAxesArray(*PyAxesArray_FromPyObject(newValue));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AnnotationAttributes_GetAxesArray(PyObject *self, PyObject *args)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)self;
    // Since the new object will point to data owned by this object,
    // we need to increment the reference count.
    Py_INCREF(self);

    PyObject *retval = PyAxesArray_Wrap(&obj->data->GetAxesArray());
    // Set the object's parent so the reference to the parent can be decref'd
    // when the child goes out of scope.
    PyAxesArray_SetParent(retval, self);

    return retval;
}



PyMethodDef PyAnnotationAttributes_methods[ANNOTATIONATTRIBUTES_NMETH] = {
    {"Notify", AnnotationAttributes_Notify, METH_VARARGS},
    {"SetAxes2D", AnnotationAttributes_SetAxes2D, METH_VARARGS},
    {"GetAxes2D", AnnotationAttributes_GetAxes2D, METH_VARARGS},
    {"SetAxes3D", AnnotationAttributes_SetAxes3D, METH_VARARGS},
    {"GetAxes3D", AnnotationAttributes_GetAxes3D, METH_VARARGS},
    {"SetUserInfoFlag", AnnotationAttributes_SetUserInfoFlag, METH_VARARGS},
    {"GetUserInfoFlag", AnnotationAttributes_GetUserInfoFlag, METH_VARARGS},
    {"SetUserInfoFont", AnnotationAttributes_SetUserInfoFont, METH_VARARGS},
    {"GetUserInfoFont", AnnotationAttributes_GetUserInfoFont, METH_VARARGS},
    {"SetDatabaseInfoFlag", AnnotationAttributes_SetDatabaseInfoFlag, METH_VARARGS},
    {"GetDatabaseInfoFlag", AnnotationAttributes_GetDatabaseInfoFlag, METH_VARARGS},
    {"SetTimeInfoFlag", AnnotationAttributes_SetTimeInfoFlag, METH_VARARGS},
    {"GetTimeInfoFlag", AnnotationAttributes_GetTimeInfoFlag, METH_VARARGS},
    {"SetDatabaseInfoFont", AnnotationAttributes_SetDatabaseInfoFont, METH_VARARGS},
    {"GetDatabaseInfoFont", AnnotationAttributes_GetDatabaseInfoFont, METH_VARARGS},
    {"SetDatabaseInfoExpansionMode", AnnotationAttributes_SetDatabaseInfoExpansionMode, METH_VARARGS},
    {"GetDatabaseInfoExpansionMode", AnnotationAttributes_GetDatabaseInfoExpansionMode, METH_VARARGS},
    {"SetDatabaseInfoTimeScale", AnnotationAttributes_SetDatabaseInfoTimeScale, METH_VARARGS},
    {"GetDatabaseInfoTimeScale", AnnotationAttributes_GetDatabaseInfoTimeScale, METH_VARARGS},
    {"SetDatabaseInfoTimeOffset", AnnotationAttributes_SetDatabaseInfoTimeOffset, METH_VARARGS},
    {"GetDatabaseInfoTimeOffset", AnnotationAttributes_GetDatabaseInfoTimeOffset, METH_VARARGS},
    {"SetLegendInfoFlag", AnnotationAttributes_SetLegendInfoFlag, METH_VARARGS},
    {"GetLegendInfoFlag", AnnotationAttributes_GetLegendInfoFlag, METH_VARARGS},
    {"SetBackgroundColor", AnnotationAttributes_SetBackgroundColor, METH_VARARGS},
    {"GetBackgroundColor", AnnotationAttributes_GetBackgroundColor, METH_VARARGS},
    {"SetForegroundColor", AnnotationAttributes_SetForegroundColor, METH_VARARGS},
    {"GetForegroundColor", AnnotationAttributes_GetForegroundColor, METH_VARARGS},
    {"SetGradientBackgroundStyle", AnnotationAttributes_SetGradientBackgroundStyle, METH_VARARGS},
    {"GetGradientBackgroundStyle", AnnotationAttributes_GetGradientBackgroundStyle, METH_VARARGS},
    {"SetGradientColor1", AnnotationAttributes_SetGradientColor1, METH_VARARGS},
    {"GetGradientColor1", AnnotationAttributes_GetGradientColor1, METH_VARARGS},
    {"SetGradientColor2", AnnotationAttributes_SetGradientColor2, METH_VARARGS},
    {"GetGradientColor2", AnnotationAttributes_GetGradientColor2, METH_VARARGS},
    {"SetBackgroundMode", AnnotationAttributes_SetBackgroundMode, METH_VARARGS},
    {"GetBackgroundMode", AnnotationAttributes_GetBackgroundMode, METH_VARARGS},
    {"SetBackgroundImage", AnnotationAttributes_SetBackgroundImage, METH_VARARGS},
    {"GetBackgroundImage", AnnotationAttributes_GetBackgroundImage, METH_VARARGS},
    {"SetImageRepeatX", AnnotationAttributes_SetImageRepeatX, METH_VARARGS},
    {"GetImageRepeatX", AnnotationAttributes_GetImageRepeatX, METH_VARARGS},
    {"SetImageRepeatY", AnnotationAttributes_SetImageRepeatY, METH_VARARGS},
    {"GetImageRepeatY", AnnotationAttributes_GetImageRepeatY, METH_VARARGS},
    {"SetAxesArray", AnnotationAttributes_SetAxesArray, METH_VARARGS},
    {"GetAxesArray", AnnotationAttributes_GetAxesArray, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
AnnotationAttributes_dealloc(PyObject *v)
{
   AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
AnnotationAttributes_compare(PyObject *v, PyObject *w)
{
    AnnotationAttributes *a = ((AnnotationAttributesObject *)v)->data;
    AnnotationAttributes *b = ((AnnotationAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyAnnotationAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "axes2D") == 0)
        return AnnotationAttributes_GetAxes2D(self, NULL);
    if(strcmp(name, "axes3D") == 0)
        return AnnotationAttributes_GetAxes3D(self, NULL);
    if(strcmp(name, "userInfoFlag") == 0)
        return AnnotationAttributes_GetUserInfoFlag(self, NULL);
    if(strcmp(name, "userInfoFont") == 0)
        return AnnotationAttributes_GetUserInfoFont(self, NULL);
    if(strcmp(name, "databaseInfoFlag") == 0)
        return AnnotationAttributes_GetDatabaseInfoFlag(self, NULL);
    if(strcmp(name, "timeInfoFlag") == 0)
        return AnnotationAttributes_GetTimeInfoFlag(self, NULL);
    if(strcmp(name, "databaseInfoFont") == 0)
        return AnnotationAttributes_GetDatabaseInfoFont(self, NULL);
    if(strcmp(name, "databaseInfoExpansionMode") == 0)
        return AnnotationAttributes_GetDatabaseInfoExpansionMode(self, NULL);
    if(strcmp(name, "File") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::File));
    if(strcmp(name, "Directory") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Directory));
    if(strcmp(name, "Full") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Full));
    if(strcmp(name, "Smart") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Smart));
    if(strcmp(name, "SmartDirectory") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::SmartDirectory));

    if(strcmp(name, "databaseInfoTimeScale") == 0)
        return AnnotationAttributes_GetDatabaseInfoTimeScale(self, NULL);
    if(strcmp(name, "databaseInfoTimeOffset") == 0)
        return AnnotationAttributes_GetDatabaseInfoTimeOffset(self, NULL);
    if(strcmp(name, "legendInfoFlag") == 0)
        return AnnotationAttributes_GetLegendInfoFlag(self, NULL);
    if(strcmp(name, "backgroundColor") == 0)
        return AnnotationAttributes_GetBackgroundColor(self, NULL);
    if(strcmp(name, "foregroundColor") == 0)
        return AnnotationAttributes_GetForegroundColor(self, NULL);
    if(strcmp(name, "gradientBackgroundStyle") == 0)
        return AnnotationAttributes_GetGradientBackgroundStyle(self, NULL);
    if(strcmp(name, "TopToBottom") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::TopToBottom));
    if(strcmp(name, "BottomToTop") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::BottomToTop));
    if(strcmp(name, "LeftToRight") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::LeftToRight));
    if(strcmp(name, "RightToLeft") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::RightToLeft));
    if(strcmp(name, "Radial") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Radial));

    if(strcmp(name, "gradientColor1") == 0)
        return AnnotationAttributes_GetGradientColor1(self, NULL);
    if(strcmp(name, "gradientColor2") == 0)
        return AnnotationAttributes_GetGradientColor2(self, NULL);
    if(strcmp(name, "backgroundMode") == 0)
        return AnnotationAttributes_GetBackgroundMode(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Solid));
    if(strcmp(name, "Gradient") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Gradient));
    if(strcmp(name, "Image") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::Image));
    if(strcmp(name, "ImageSphere") == 0)
        return PyInt_FromLong(long(AnnotationAttributes::ImageSphere));

    if(strcmp(name, "backgroundImage") == 0)
        return AnnotationAttributes_GetBackgroundImage(self, NULL);
    if(strcmp(name, "imageRepeatX") == 0)
        return AnnotationAttributes_GetImageRepeatX(self, NULL);
    if(strcmp(name, "imageRepeatY") == 0)
        return AnnotationAttributes_GetImageRepeatY(self, NULL);
    if(strcmp(name, "axesArray") == 0)
        return AnnotationAttributes_GetAxesArray(self, NULL);

    return Py_FindMethod(PyAnnotationAttributes_methods, self, name);
}

int
PyAnnotationAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "axes2D") == 0)
        obj = AnnotationAttributes_SetAxes2D(self, tuple);
    else if(strcmp(name, "axes3D") == 0)
        obj = AnnotationAttributes_SetAxes3D(self, tuple);
    else if(strcmp(name, "userInfoFlag") == 0)
        obj = AnnotationAttributes_SetUserInfoFlag(self, tuple);
    else if(strcmp(name, "userInfoFont") == 0)
        obj = AnnotationAttributes_SetUserInfoFont(self, tuple);
    else if(strcmp(name, "databaseInfoFlag") == 0)
        obj = AnnotationAttributes_SetDatabaseInfoFlag(self, tuple);
    else if(strcmp(name, "timeInfoFlag") == 0)
        obj = AnnotationAttributes_SetTimeInfoFlag(self, tuple);
    else if(strcmp(name, "databaseInfoFont") == 0)
        obj = AnnotationAttributes_SetDatabaseInfoFont(self, tuple);
    else if(strcmp(name, "databaseInfoExpansionMode") == 0)
        obj = AnnotationAttributes_SetDatabaseInfoExpansionMode(self, tuple);
    else if(strcmp(name, "databaseInfoTimeScale") == 0)
        obj = AnnotationAttributes_SetDatabaseInfoTimeScale(self, tuple);
    else if(strcmp(name, "databaseInfoTimeOffset") == 0)
        obj = AnnotationAttributes_SetDatabaseInfoTimeOffset(self, tuple);
    else if(strcmp(name, "legendInfoFlag") == 0)
        obj = AnnotationAttributes_SetLegendInfoFlag(self, tuple);
    else if(strcmp(name, "backgroundColor") == 0)
        obj = AnnotationAttributes_SetBackgroundColor(self, tuple);
    else if(strcmp(name, "foregroundColor") == 0)
        obj = AnnotationAttributes_SetForegroundColor(self, tuple);
    else if(strcmp(name, "gradientBackgroundStyle") == 0)
        obj = AnnotationAttributes_SetGradientBackgroundStyle(self, tuple);
    else if(strcmp(name, "gradientColor1") == 0)
        obj = AnnotationAttributes_SetGradientColor1(self, tuple);
    else if(strcmp(name, "gradientColor2") == 0)
        obj = AnnotationAttributes_SetGradientColor2(self, tuple);
    else if(strcmp(name, "backgroundMode") == 0)
        obj = AnnotationAttributes_SetBackgroundMode(self, tuple);
    else if(strcmp(name, "backgroundImage") == 0)
        obj = AnnotationAttributes_SetBackgroundImage(self, tuple);
    else if(strcmp(name, "imageRepeatX") == 0)
        obj = AnnotationAttributes_SetImageRepeatX(self, tuple);
    else if(strcmp(name, "imageRepeatY") == 0)
        obj = AnnotationAttributes_SetImageRepeatY(self, tuple);
    else if(strcmp(name, "axesArray") == 0)
        obj = AnnotationAttributes_SetAxesArray(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
AnnotationAttributes_print(PyObject *v, FILE *fp, int flags)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;
    fprintf(fp, "%s", PyAnnotationAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
AnnotationAttributes_str(PyObject *v)
{
    AnnotationAttributesObject *obj = (AnnotationAttributesObject *)v;
    return PyString_FromString(PyAnnotationAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *AnnotationAttributes_Purpose = "This class contains the attributes controlling annotations.";
#else
static char *AnnotationAttributes_Purpose = "This class contains the attributes controlling annotations.";
#endif

//
// The type description structure
//
static PyTypeObject AnnotationAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "AnnotationAttributes",                    // tp_name
    sizeof(AnnotationAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)AnnotationAttributes_dealloc,  // tp_dealloc
    (printfunc)AnnotationAttributes_print,     // tp_print
    (getattrfunc)PyAnnotationAttributes_getattr, // tp_getattr
    (setattrfunc)PyAnnotationAttributes_setattr, // tp_setattr
    (cmpfunc)AnnotationAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)AnnotationAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    AnnotationAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AnnotationAttributes *defaultAtts = 0;
static AnnotationAttributes *currentAtts = 0;

static PyObject *
NewAnnotationAttributes(int useCurrent)
{
    AnnotationAttributesObject *newObject;
    newObject = PyObject_NEW(AnnotationAttributesObject, &AnnotationAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new AnnotationAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new AnnotationAttributes(*defaultAtts);
    else
        newObject->data = new AnnotationAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapAnnotationAttributes(const AnnotationAttributes *attr)
{
    AnnotationAttributesObject *newObject;
    newObject = PyObject_NEW(AnnotationAttributesObject, &AnnotationAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AnnotationAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
AnnotationAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewAnnotationAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef AnnotationAttributesMethods[] = {
    {"AnnotationAttributes", AnnotationAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *AnnotationAttributesObserver = 0;

std::string
PyAnnotationAttributes_GetLogString()
{
    std::string s("AnnotationAtts = AnnotationAttributes()\n");
    if(currentAtts != 0)
        s += PyAnnotationAttributes_ToString(currentAtts, "AnnotationAtts.");
    return s;
}

static void
PyAnnotationAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("AnnotationAtts = AnnotationAttributes()\n");
        s += PyAnnotationAttributes_ToString(currentAtts, "AnnotationAtts.");
        cb(s);
    }
}

void
PyAnnotationAttributes_StartUp(AnnotationAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyAnnotationAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(AnnotationAttributesObserver == 0)
    {
        AnnotationAttributesObserver = new ObserverToCallback(subj,
            PyAnnotationAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyAnnotationAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete AnnotationAttributesObserver;
    AnnotationAttributesObserver = 0;
}

PyMethodDef *
PyAnnotationAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return AnnotationAttributesMethods;
}

bool
PyAnnotationAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &AnnotationAttributesType);
}

AnnotationAttributes *
PyAnnotationAttributes_FromPyObject(PyObject *obj)
{
    AnnotationAttributesObject *obj2 = (AnnotationAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyAnnotationAttributes_New()
{
    return NewAnnotationAttributes(0);
}

PyObject *
PyAnnotationAttributes_Wrap(const AnnotationAttributes *attr)
{
    return WrapAnnotationAttributes(attr);
}

void
PyAnnotationAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    AnnotationAttributesObject *obj2 = (AnnotationAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyAnnotationAttributes_SetDefaults(const AnnotationAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AnnotationAttributes(*atts);
}

