// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VIEWERWINDOWMANAGERATTRIBUTES_H
#define VIEWERWINDOWMANAGERATTRIBUTES_H
#include <viewercore_exports.h>
#include <AttributeSubject.h>

class ActionGroupDescription;
#include "ViewerRPC.h"

// ****************************************************************************
// Class: ViewerWindowManagerAttributes
//
// Purpose:
//    This class contains the attributes that dictate where viewer windows are positioned, etc.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class VIEWERCORE_API ViewerWindowManagerAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ViewerWindowManagerAttributes();
    ViewerWindowManagerAttributes(const ViewerWindowManagerAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ViewerWindowManagerAttributes(private_tmfs_t tmfs);
    ViewerWindowManagerAttributes(const ViewerWindowManagerAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewerWindowManagerAttributes();

    virtual ViewerWindowManagerAttributes& operator = (const ViewerWindowManagerAttributes &obj);
    virtual bool operator == (const ViewerWindowManagerAttributes &obj) const;
    virtual bool operator != (const ViewerWindowManagerAttributes &obj) const;
private:
    void Init();
    void Copy(const ViewerWindowManagerAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectActionConfigurations();

    // Property setting methods
    void SetToolbarsVisible(bool toolbarsVisible_);
    void SetLargeIcons(bool largeIcons_);

    // Property getting methods
    const AttributeGroupVector &GetActionConfigurations() const;
          AttributeGroupVector &GetActionConfigurations();
    bool GetToolbarsVisible() const;
    bool GetLargeIcons() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddActionConfigurations(const ActionGroupDescription &);
    void ClearActionConfigurations();
    void RemoveActionConfigurations(int i);
    int  GetNumActionConfigurations() const;
    ActionGroupDescription &GetActionConfigurations(int i);
    const ActionGroupDescription &GetActionConfigurations(int i) const;

    ActionGroupDescription &operator [] (int i);
    const ActionGroupDescription &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    virtual void ProcessOldVersions(DataNode *parentNode, const char *configVersion);
    void RemoveActionFromNode(DataNode *, const char *, ViewerRPC::ViewerRPCType);
    void RemoveActionFromNode(DataNode *, const char *, const char *);
    void AddAction(DataNode *, const char *, ViewerRPC::ViewerRPCType);
    void AddActionGroup(DataNode *, ActionGroupDescription &);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_actionConfigurations = 0,
        ID_toolbarsVisible,
        ID_largeIcons,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector actionConfigurations;
    bool                 toolbarsVisible;
    bool                 largeIcons;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWERWINDOWMANAGERATTRIBUTES_TMFS "a*bb"

#endif
