// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtDO_REPL_STRING.h                           //
// ************************************************************************* //

#ifndef AVT_DO_REPL_STRING_H
#define AVT_DO_REPL_STRING_H

#include <pipeline_exports.h>


#include <ref_ptr.h>

#include <avtDataObject.h>


// ****************************************************************************
//  Class: avtDO_REPL_STRING
//
//  Purpose:
//      This defines the DO_REPL_STRING data object.
//
//  Programmer: autogenerated by AUTHOR_REPL_STRING
//  Creation:   DATE_REPL_STRING
//
// ****************************************************************************

class PIPELINE_API avtDO_REPL_STRING : public avtDataObject
{
    friend class              avtDO_REPL_STRINGSink;
    friend class              avtDO_REPL_STRINGSource;

  public:
                              avtDO_REPL_STRING(avtDataObjectSource *);
    virtual                  ~avtDO_REPL_STRING();

    virtual const char       *GetType(void)  { return "avtDO_REPL_STRING"; };
    virtual avtDataObject    *Instance(void);
    virtual long long         GetNumberOfCells(bool) const;

    /* You will need to implement this if you want your data object to be 
     * passed from the server to the client.

    virtual avtDataObjectWriter
                             *InstantiateWriter(void);
     */

    virtual void              ReleaseData(void);

  protected:
    YOUR DATA OBJECTS GO HERE

    virtual void              DerivedCopy(avtDataObject *);
};


typedef ref_ptr<avtDO_REPL_STRING>  avtDO_REPL_STRING_p;


#endif


