// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <string.h>
#include <visitstream.h>
#include <silo.h>

// suppress the following since silo uses char * in its API
#if defined(__clang__)
# pragma clang diagnostic ignored "-Wwritable-strings"
#elif defined(__GNUC__)
# pragma GCC diagnostic ignored "-Wwrite-strings"
#endif

#define NNODES 17890
#define NHEXES 7939
#define NBEAMS 4
#define NSHELLS 7060

struct node {
   int    nodeNumber;
   double x;
   double y;
   double z;
};

struct beam {
   int    elementNumber;
   int    materialNumber;
   int    nodes[3];
};

struct shell {
   int    elementNumber;
   int    materialNumber;
   int    nodes[4];
};

struct hex {
   int    elementNumber;
   int    materialNumber;
   int    nodes[8];
};

struct node nodes[NNODES] = {
 {       1, .8457714843750E+04, -.1336392089844E+04, .1137171875000E+04},
 {       2, .8453079101562E+04, -.1336392089844E+04, .1139248046875E+04},
 {       3, .8457714843750E+04, -.1322421997070E+04, .1137171875000E+04},
 {       4, .8453079101562E+04, -.1322421997070E+04, .1139248046875E+04},
 {       5, .8454361328125E+04, -.1336392089844E+04, .1124345092773E+04},
 {       6, .8449513671875E+04, -.1336392089844E+04, .1125612792969E+04},
 {       7, .8454361328125E+04, -.1322421997070E+04, .1124345092773E+04},
 {       8, .8449513671875E+04, -.1322421997070E+04, .1125612792969E+04},
 {       9, .8453173828125E+04, -.1336392089844E+04, .1119800903320E+04},
 {      10, .8448323242188E+04, -.1336392089844E+04, .1121068237305E+04},
 {      11, .8453173828125E+04, -.1322421997070E+04, .1119800903320E+04},
 {      12, .8448323242188E+04, -.1322421997070E+04, .1121068237305E+04},
 {      13, .8445935546875E+04, -.1336392089844E+04, .1092127197266E+04},
 {      14, .8441193359375E+04, -.1336392089844E+04, .1093798583984E+04},
 {      15, .8445935546875E+04, -.1322421997070E+04, .1092127197266E+04},
 {      16, .8441193359375E+04, -.1322421997070E+04, .1093798583984E+04},
 {      17, .8438700195312E+04, -.1336392089844E+04, .1064454101562E+04},
 {      18, .8434066406250E+04, -.1336392089844E+04, .1066529052734E+04},
 {      19, .8438700195312E+04, -.1322421997070E+04, .1064454101562E+04},
 {      20, .8434066406250E+04, -.1322421997070E+04, .1066529052734E+04},
 {      21, .8457714843750E+04, -.1316072021484E+04, .1137171875000E+04},
 {      22, .8453079101562E+04, -.1316072021484E+04, .1139248046875E+04},
 {      23, .8454361328125E+04, -.1316072021484E+04, .1124345092773E+04},
 {      24, .8449513671875E+04, -.1316072021484E+04, .1125612792969E+04},
 {      25, .8453173828125E+04, -.1316072021484E+04, .1119800903320E+04},
 {      26, .8448323242188E+04, -.1316072021484E+04, .1121068237305E+04},
 {      27, .8445935546875E+04, -.1316072021484E+04, .1092127197266E+04},
 {      28, .8441193359375E+04, -.1316072021484E+04, .1093798583984E+04},
 {      29, .8438700195312E+04, -.1316072021484E+04, .1064454101562E+04},
 {      30, .8434066406250E+04, -.1316072021484E+04, .1066529052734E+04},
 {      31, .8457714843750E+04, -.1300832031250E+04, .1137171875000E+04},
 {      32, .8453079101562E+04, -.1300832031250E+04, .1139248046875E+04},
 {      33, .8457714843750E+04, -.1285592041016E+04, .1137171875000E+04},
 {      34, .8453079101562E+04, -.1285592041016E+04, .1139248046875E+04},
 {      35, .8457714843750E+04, -.1270352050781E+04, .1137171875000E+04},
 {      36, .8453079101562E+04, -.1270352050781E+04, .1139248046875E+04},
 {      37, .8457714843750E+04, -.1255112060547E+04, .1137171875000E+04},
 {      38, .8453079101562E+04, -.1255112060547E+04, .1139248046875E+04},
 {      39, .8454361328125E+04, -.1300832031250E+04, .1124345092773E+04},
 {      40, .8449513671875E+04, -.1300832031250E+04, .1125612792969E+04},
 {      41, .8454361328125E+04, -.1285592041016E+04, .1124345092773E+04},
 {      42, .8449513671875E+04, -.1285592041016E+04, .1125612792969E+04},
 {      43, .8454361328125E+04, -.1270352050781E+04, .1124345092773E+04},
 {      44, .8449513671875E+04, -.1270352050781E+04, .1125612792969E+04},
 {      45, .8454361328125E+04, -.1255112060547E+04, .1124345092773E+04},
 {      46, .8449513671875E+04, -.1255112060547E+04, .1125612792969E+04},
 {      47, .8453173828125E+04, -.1300832031250E+04, .1119800903320E+04},
 {      48, .8448323242188E+04, -.1300832031250E+04, .1121068237305E+04},
 {      49, .8453173828125E+04, -.1285592041016E+04, .1119800903320E+04},
 {      50, .8448323242188E+04, -.1285592041016E+04, .1121068237305E+04},
 {      51, .8453173828125E+04, -.1270352050781E+04, .1119800903320E+04},
 {      52, .8448323242188E+04, -.1270352050781E+04, .1121068237305E+04},
 {      53, .8453173828125E+04, -.1255112060547E+04, .1119800659180E+04},
 {      54, .8448323242188E+04, -.1255112060547E+04, .1121068237305E+04},
 {      55, .8445935546875E+04, -.1300832031250E+04, .1092127197266E+04},
 {      56, .8441193359375E+04, -.1300832031250E+04, .1093798583984E+04},
 {      57, .8445935546875E+04, -.1285592041016E+04, .1092127197266E+04},
 {      58, .8441193359375E+04, -.1285592041016E+04, .1093798583984E+04},
 {      59, .8445935546875E+04, -.1270352050781E+04, .1092127197266E+04},
 {      60, .8441193359375E+04, -.1270352050781E+04, .1093798583984E+04},
 {      61, .8445935546875E+04, -.1255112060547E+04, .1092127197266E+04},
 {      62, .8441193359375E+04, -.1255112060547E+04, .1093798583984E+04},
 {      63, .8438700195312E+04, -.1300832031250E+04, .1064454101562E+04},
 {      64, .8434066406250E+04, -.1300832031250E+04, .1066529052734E+04},
 {      65, .8438700195312E+04, -.1285592041016E+04, .1064454101562E+04},
 {      66, .8434066406250E+04, -.1285592041016E+04, .1066529052734E+04},
 {      67, .8438700195312E+04, -.1270352050781E+04, .1064454101562E+04},
 {      68, .8434066406250E+04, -.1270352050781E+04, .1066529052734E+04},
 {      69, .8438700195312E+04, -.1255112060547E+04, .1064454101562E+04},
 {      70, .8434066406250E+04, -.1255112060547E+04, .1066529052734E+04},
 {      71, .8457714843750E+04, -.1248762084961E+04, .1137171875000E+04},
 {      72, .8453079101562E+04, -.1248762084961E+04, .1139248046875E+04},
 {      73, .8454361328125E+04, -.1248762084961E+04, .1124345092773E+04},
 {      74, .8449513671875E+04, -.1248762084961E+04, .1125612792969E+04},
 {      75, .8453173828125E+04, -.1248762084961E+04, .1119800659180E+04},
 {      76, .8448323242188E+04, -.1248762084961E+04, .1121068237305E+04},
 {      77, .8445935546875E+04, -.1248762084961E+04, .1092127197266E+04},
 {      78, .8441193359375E+04, -.1248762084961E+04, .1093798583984E+04},
 {      79, .8438700195312E+04, -.1248762084961E+04, .1064454101562E+04},
 {      80, .8434066406250E+04, -.1248762084961E+04, .1066529052734E+04},
 {      81, .8457714843750E+04, -.1234791992188E+04, .1137171875000E+04},
 {      82, .8453079101562E+04, -.1234791992188E+04, .1139248046875E+04},
 {      83, .8454361328125E+04, -.1234791992188E+04, .1124345092773E+04},
 {      84, .8449513671875E+04, -.1234791992188E+04, .1125612792969E+04},
 {      85, .8453173828125E+04, -.1234791992188E+04, .1119800659180E+04},
 {      86, .8448323242188E+04, -.1234791992188E+04, .1121068237305E+04},
 {      87, .8445935546875E+04, -.1234791992188E+04, .1092127197266E+04},
 {      88, .8441193359375E+04, -.1234791992188E+04, .1093798583984E+04},
 {      89, .8438700195312E+04, -.1234791992188E+04, .1064454101562E+04},
 {      90, .8434066406250E+04, -.1234791992188E+04, .1066529052734E+04},
 {      91, .8434968750000E+04, -.1336392089844E+04, .1129415771484E+04},
 {      92, .8434968750000E+04, -.1322421997070E+04, .1129415771484E+04},
 {      93, .8433782226562E+04, -.1336392089844E+04, .1124871093750E+04},
 {      94, .8433782226562E+04, -.1322421997070E+04, .1124871093750E+04},
 {      95, .8434968750000E+04, -.1316072021484E+04, .1129415771484E+04},
 {      96, .8433782226562E+04, -.1316072021484E+04, .1124871093750E+04},
 {      97, .8426966796875E+04, -.1322421997070E+04, .1098813476562E+04},
 {      98, .8426966796875E+04, -.1316072021484E+04, .1098813476562E+04},
 {      99, .8420154296875E+04, -.1322421997070E+04, .1072756347656E+04},
 {     100, .8420154296875E+04, -.1316072021484E+04, .1072756347656E+04},
 {     101, .8428875976562E+04, -.1322421997070E+04, .1054938110352E+04},
 {     102, .8414964843750E+04, -.1322421997070E+04, .1061164794922E+04},
 {     103, .8428875976562E+04, -.1316072021484E+04, .1054938110352E+04},
 {     104, .8414964843750E+04, -.1316072021484E+04, .1061164794922E+04},
 {     105, .8423685546875E+04, -.1322421997070E+04, .1043346679688E+04},
 {     106, .8409775390625E+04, -.1322421997070E+04, .1049573486328E+04},
 {     107, .8423685546875E+04, -.1316072021484E+04, .1043346679688E+04},
 {     108, .8409775390625E+04, -.1316072021484E+04, .1049573486328E+04},
 {     109, .8418497070312E+04, -.1322421997070E+04, .1031754394531E+04},
 {     110, .8404586914062E+04, -.1322421997070E+04, .1037981933594E+04},
 {     111, .8418497070312E+04, -.1316072021484E+04, .1031754394531E+04},
 {     112, .8404586914062E+04, -.1316072021484E+04, .1037981933594E+04},
 {     113, .8413306640625E+04, -.1322421997070E+04, .1020163574219E+04},
 {     114, .8399399414062E+04, -.1322421997070E+04, .1026390747070E+04},
 {     115, .8413306640625E+04, -.1316072021484E+04, .1020163574219E+04},
 {     116, .8399399414062E+04, -.1316072021484E+04, .1026390747070E+04},
 {     117, .8412009765625E+04, -.1322421997070E+04, .1017265747070E+04},
 {     118, .8398100585938E+04, -.1322421997070E+04, .1023492065430E+04},
 {     119, .8412009765625E+04, -.1316072021484E+04, .1017265747070E+04},
 {     120, .8398100585938E+04, -.1316072021484E+04, .1023492065430E+04},
 {     121, .8406821289062E+04, -.1322421997070E+04, .1005673706055E+04},
 {     122, .8392910156250E+04, -.1322421997070E+04, .1011901184082E+04},
 {     123, .8406821289062E+04, -.1316072021484E+04, .1005673706055E+04},
 {     124, .8392910156250E+04, -.1316072021484E+04, .1011901184082E+04},
 {     125, .8401631835938E+04, -.1322421997070E+04, .9940820312500E+03},
 {     126, .8387722656250E+04, -.1322421997070E+04, .1000309448242E+04},
 {     127, .8401631835938E+04, -.1316072021484E+04, .9940820312500E+03},
 {     128, .8387722656250E+04, -.1316072021484E+04, .1000309448242E+04},
 {     129, .8400334960938E+04, -.1322421997070E+04, .9911846923828E+03},
 {     130, .8386424804688E+04, -.1322421997070E+04, .9974113159180E+03},
 {     131, .8400334960938E+04, -.1316072021484E+04, .9911846923828E+03},
 {     132, .8386424804688E+04, -.1316072021484E+04, .9974113159180E+03},
 {     133, .8395144531250E+04, -.1322421997070E+04, .9795933837891E+03},
 {     134, .8381236328125E+04, -.1322421997070E+04, .9858200683594E+03},
 {     135, .8395144531250E+04, -.1316072021484E+04, .9795933837891E+03},
 {     136, .8381236328125E+04, -.1316072021484E+04, .9858200683594E+03},
 {     137, .8389957031250E+04, -.1322421997070E+04, .9680015869141E+03},
 {     138, .8376045898438E+04, -.1322421997070E+04, .9742283325195E+03},
 {     139, .8389957031250E+04, -.1316072021484E+04, .9680015869141E+03},
 {     140, .8376045898438E+04, -.1316072021484E+04, .9742283325195E+03},
 {     141, .8388660156250E+04, -.1322421997070E+04, .9651035156250E+03},
 {     142, .8374750000000E+04, -.1322421997070E+04, .9713304443359E+03},
 {     143, .8388660156250E+04, -.1316072021484E+04, .9651035156250E+03},
 {     144, .8374750000000E+04, -.1316072021484E+04, .9713304443359E+03},
 {     145, .8383468750000E+04, -.1322421997070E+04, .9535125122070E+03},
 {     146, .8369560546875E+04, -.1322421997070E+04, .9597390747070E+03},
 {     147, .8383468750000E+04, -.1316072021484E+04, .9535125122070E+03},
 {     148, .8369560546875E+04, -.1316072021484E+04, .9597390747070E+03},
 {     149, .8378281250000E+04, -.1322421997070E+04, .9419204711914E+03},
 {     150, .8364371093750E+04, -.1322421997070E+04, .9481473999023E+03},
 {     151, .8378281250000E+04, -.1316072021484E+04, .9419204711914E+03},
 {     152, .8364371093750E+04, -.1316072021484E+04, .9481473999023E+03},
 {     153, .8376984375000E+04, -.1322421997070E+04, .9390224609375E+03},
 {     154, .8363074218750E+04, -.1322421997070E+04, .9452495727539E+03},
 {     155, .8376984375000E+04, -.1316072021484E+04, .9390224609375E+03},
 {     156, .8363074218750E+04, -.1316072021484E+04, .9452495727539E+03},
 {     157, .8371793945312E+04, -.1322421997070E+04, .9274310302734E+03},
 {     158, .8357883789062E+04, -.1322421997070E+04, .9336578979492E+03},
 {     159, .8371793945312E+04, -.1316072021484E+04, .9274310302734E+03},
 {     160, .8357883789062E+04, -.1316072021484E+04, .9336578979492E+03},
 {     161, .8366604492188E+04, -.1322421997070E+04, .9158396606445E+03},
 {     162, .8352696289062E+04, -.1322421997070E+04, .9220664672852E+03},
 {     163, .8366604492188E+04, -.1316072021484E+04, .9158396606445E+03},
 {     164, .8352696289062E+04, -.1316072021484E+04, .9220664672852E+03},
 {     165, .8364531250000E+04, -.1322421997070E+04, .9112027587891E+03},
 {     166, .8350619140625E+04, -.1322421997070E+04, .9174299926758E+03},
 {     167, .8364531250000E+04, -.1316072021484E+04, .9112027587891E+03},
 {     168, .8350619140625E+04, -.1316072021484E+04, .9174299926758E+03},
 {     169, .8434968750000E+04, -.1300832031250E+04, .1129415771484E+04},
 {     170, .8434968750000E+04, -.1285592041016E+04, .1129415771484E+04},
 {     171, .8434968750000E+04, -.1270352050781E+04, .1129415771484E+04},
 {     172, .8434968750000E+04, -.1255112060547E+04, .1129415771484E+04},
 {     173, .8433782226562E+04, -.1300832031250E+04, .1124871093750E+04},
 {     174, .8433782226562E+04, -.1285592041016E+04, .1124871093750E+04},
 {     175, .8433782226562E+04, -.1270352050781E+04, .1124871093750E+04},
 {     176, .8433782226562E+04, -.1255112060547E+04, .1124871093750E+04},
 {     177, .8420154296875E+04, -.1300832031250E+04, .1072756347656E+04},
 {     178, .8420154296875E+04, -.1285592041016E+04, .1072756347656E+04},
 {     179, .8420154296875E+04, -.1270352050781E+04, .1072756347656E+04},
 {     180, .8420154296875E+04, -.1255112060547E+04, .1072756347656E+04},
 {     181, .8428875976562E+04, -.1300832031250E+04, .1054938110352E+04},
 {     182, .8414964843750E+04, -.1300832031250E+04, .1061164794922E+04},
 {     183, .8428875976562E+04, -.1285592041016E+04, .1054938110352E+04},
 {     184, .8414964843750E+04, -.1285592041016E+04, .1061164794922E+04},
 {     185, .8428875976562E+04, -.1270352050781E+04, .1054938110352E+04},
 {     186, .8414964843750E+04, -.1270352050781E+04, .1061164794922E+04},
 {     187, .8428875976562E+04, -.1255112060547E+04, .1054938110352E+04},
 {     188, .8414964843750E+04, -.1255112060547E+04, .1061164794922E+04},
 {     189, .8423685546875E+04, -.1300832031250E+04, .1043346679688E+04},
 {     190, .8409775390625E+04, -.1300832031250E+04, .1049573486328E+04},
 {     191, .8423685546875E+04, -.1285592041016E+04, .1043346679688E+04},
 {     192, .8409775390625E+04, -.1285592041016E+04, .1049573486328E+04},
 {     193, .8423685546875E+04, -.1270352050781E+04, .1043346679688E+04},
 {     194, .8409775390625E+04, -.1270352050781E+04, .1049573486328E+04},
 {     195, .8423685546875E+04, -.1255112060547E+04, .1043346679688E+04},
 {     196, .8409775390625E+04, -.1255112060547E+04, .1049573486328E+04},
 {     197, .8418497070312E+04, -.1300832031250E+04, .1031754394531E+04},
 {     198, .8404586914062E+04, -.1300832031250E+04, .1037981933594E+04},
 {     199, .8418497070312E+04, -.1285592041016E+04, .1031754394531E+04},
 {     200, .8404586914062E+04, -.1285592041016E+04, .1037981933594E+04},
 {     201, .8418497070312E+04, -.1270352050781E+04, .1031754394531E+04},
 {     202, .8404586914062E+04, -.1270352050781E+04, .1037981933594E+04},
 {     203, .8418497070312E+04, -.1255112060547E+04, .1031754394531E+04},
 {     204, .8404586914062E+04, -.1255112060547E+04, .1037981933594E+04},
 {     205, .8413306640625E+04, -.1300832031250E+04, .1020163574219E+04},
 {     206, .8399399414062E+04, -.1300832031250E+04, .1026390747070E+04},
 {     207, .8413306640625E+04, -.1285592041016E+04, .1020163574219E+04},
 {     208, .8399399414062E+04, -.1285592041016E+04, .1026390747070E+04},
 {     209, .8413306640625E+04, -.1270352050781E+04, .1020163574219E+04},
 {     210, .8399399414062E+04, -.1270352050781E+04, .1026390747070E+04},
 {     211, .8413306640625E+04, -.1255112060547E+04, .1020163574219E+04},
 {     212, .8399399414062E+04, -.1255112060547E+04, .1026390747070E+04},
 {     213, .8412009765625E+04, -.1300832031250E+04, .1017265747070E+04},
 {     214, .8398100585938E+04, -.1300832031250E+04, .1023492065430E+04},
 {     215, .8412009765625E+04, -.1285592041016E+04, .1017265747070E+04},
 {     216, .8398100585938E+04, -.1285592041016E+04, .1023492065430E+04},
 {     217, .8412009765625E+04, -.1270352050781E+04, .1017265747070E+04},
 {     218, .8398100585938E+04, -.1270352050781E+04, .1023492065430E+04},
 {     219, .8412009765625E+04, -.1255112060547E+04, .1017265747070E+04},
 {     220, .8398100585938E+04, -.1255112060547E+04, .1023492065430E+04},
 {     221, .8406821289062E+04, -.1300832031250E+04, .1005673706055E+04},
 {     222, .8392910156250E+04, -.1300832031250E+04, .1011901184082E+04},
 {     223, .8406821289062E+04, -.1285592041016E+04, .1005673706055E+04},
 {     224, .8392910156250E+04, -.1285592041016E+04, .1011901184082E+04},
 {     225, .8406821289062E+04, -.1270352050781E+04, .1005673706055E+04},
 {     226, .8392910156250E+04, -.1270352050781E+04, .1011901184082E+04},
 {     227, .8406821289062E+04, -.1255112060547E+04, .1005673706055E+04},
 {     228, .8392910156250E+04, -.1255112060547E+04, .1011901184082E+04},
 {     229, .8401631835938E+04, -.1300832031250E+04, .9940820312500E+03},
 {     230, .8387722656250E+04, -.1300832031250E+04, .1000309448242E+04},
 {     231, .8401631835938E+04, -.1285592041016E+04, .9940820312500E+03},
 {     232, .8387722656250E+04, -.1285592041016E+04, .1000309448242E+04},
 {     233, .8401631835938E+04, -.1270352050781E+04, .9940820312500E+03},
 {     234, .8387722656250E+04, -.1270352050781E+04, .1000309448242E+04},
 {     235, .8401631835938E+04, -.1255112060547E+04, .9940820312500E+03},
 {     236, .8387722656250E+04, -.1255112060547E+04, .1000309448242E+04},
 {     237, .8400334960938E+04, -.1300832031250E+04, .9911846923828E+03},
 {     238, .8386424804688E+04, -.1300832031250E+04, .9974113159180E+03},
 {     239, .8400334960938E+04, -.1285592041016E+04, .9911846923828E+03},
 {     240, .8386424804688E+04, -.1285592041016E+04, .9974113159180E+03},
 {     241, .8400334960938E+04, -.1270352050781E+04, .9911846923828E+03},
 {     242, .8386424804688E+04, -.1270352050781E+04, .9974113159180E+03},
 {     243, .8400334960938E+04, -.1255112060547E+04, .9911846923828E+03},
 {     244, .8386424804688E+04, -.1255112060547E+04, .9974113159180E+03},
 {     245, .8395144531250E+04, -.1300832031250E+04, .9795933837891E+03},
 {     246, .8381236328125E+04, -.1300832031250E+04, .9858200683594E+03},
 {     247, .8395144531250E+04, -.1285592041016E+04, .9795933837891E+03},
 {     248, .8381236328125E+04, -.1285592041016E+04, .9858200683594E+03},
 {     249, .8395144531250E+04, -.1270352050781E+04, .9795933837891E+03},
 {     250, .8381236328125E+04, -.1270352050781E+04, .9858200683594E+03},
 {     251, .8395144531250E+04, -.1255112060547E+04, .9795933837891E+03},
 {     252, .8381236328125E+04, -.1255112060547E+04, .9858200683594E+03},
 {     253, .8389957031250E+04, -.1300832031250E+04, .9680015869141E+03},
 {     254, .8376045898438E+04, -.1300832031250E+04, .9742283325195E+03},
 {     255, .8389957031250E+04, -.1285592041016E+04, .9680015869141E+03},
 {     256, .8376045898438E+04, -.1285592041016E+04, .9742283325195E+03},
 {     257, .8389957031250E+04, -.1270352050781E+04, .9680015869141E+03},
 {     258, .8376045898438E+04, -.1270352050781E+04, .9742283325195E+03},
 {     259, .8389957031250E+04, -.1255112060547E+04, .9680015869141E+03},
 {     260, .8376045898438E+04, -.1255112060547E+04, .9742283325195E+03},
 {     261, .8388660156250E+04, -.1300832031250E+04, .9651035156250E+03},
 {     262, .8374750000000E+04, -.1300832031250E+04, .9713304443359E+03},
 {     263, .8388660156250E+04, -.1285592041016E+04, .9651035156250E+03},
 {     264, .8374750000000E+04, -.1285592041016E+04, .9713304443359E+03},
 {     265, .8388660156250E+04, -.1270352050781E+04, .9651035156250E+03},
 {     266, .8374750000000E+04, -.1270352050781E+04, .9713304443359E+03},
 {     267, .8388660156250E+04, -.1255112060547E+04, .9651035156250E+03},
 {     268, .8374750000000E+04, -.1255112060547E+04, .9713304443359E+03},
 {     269, .8383468750000E+04, -.1300832031250E+04, .9535125122070E+03},
 {     270, .8369560546875E+04, -.1300832031250E+04, .9597390747070E+03},
 {     271, .8383468750000E+04, -.1285592041016E+04, .9535125122070E+03},
 {     272, .8369560546875E+04, -.1285592041016E+04, .9597390747070E+03},
 {     273, .8383468750000E+04, -.1270352050781E+04, .9535125122070E+03},
 {     274, .8369560546875E+04, -.1270352050781E+04, .9597390747070E+03},
 {     275, .8383468750000E+04, -.1255112060547E+04, .9535125122070E+03},
 {     276, .8369560546875E+04, -.1255112060547E+04, .9597390747070E+03},
 {     277, .8378281250000E+04, -.1300832031250E+04, .9419204711914E+03},
 {     278, .8364371093750E+04, -.1300832031250E+04, .9481473999023E+03},
 {     279, .8378281250000E+04, -.1285592041016E+04, .9419204711914E+03},
 {     280, .8364371093750E+04, -.1285592041016E+04, .9481473999023E+03},
 {     281, .8378281250000E+04, -.1270352050781E+04, .9419204711914E+03},
 {     282, .8364371093750E+04, -.1270352050781E+04, .9481473999023E+03},
 {     283, .8378281250000E+04, -.1255112060547E+04, .9419204711914E+03},
 {     284, .8364371093750E+04, -.1255112060547E+04, .9481473999023E+03},
 {     285, .8376984375000E+04, -.1300832031250E+04, .9390224609375E+03},
 {     286, .8363074218750E+04, -.1300832031250E+04, .9452495727539E+03},
 {     287, .8376984375000E+04, -.1285592041016E+04, .9390224609375E+03},
 {     288, .8363074218750E+04, -.1285592041016E+04, .9452495727539E+03},
 {     289, .8376984375000E+04, -.1270352050781E+04, .9390224609375E+03},
 {     290, .8363074218750E+04, -.1270352050781E+04, .9452495727539E+03},
 {     291, .8376984375000E+04, -.1255112060547E+04, .9390224609375E+03},
 {     292, .8363074218750E+04, -.1255112060547E+04, .9452495727539E+03},
 {     293, .8371793945312E+04, -.1300832031250E+04, .9274310302734E+03},
 {     294, .8357883789062E+04, -.1300832031250E+04, .9336578979492E+03},
 {     295, .8371793945312E+04, -.1285592041016E+04, .9274310302734E+03},
 {     296, .8357883789062E+04, -.1285592041016E+04, .9336578979492E+03},
 {     297, .8371793945312E+04, -.1270352050781E+04, .9274310302734E+03},
 {     298, .8357883789062E+04, -.1270352050781E+04, .9336578979492E+03},
 {     299, .8371793945312E+04, -.1255112060547E+04, .9274310302734E+03},
 {     300, .8357883789062E+04, -.1255112060547E+04, .9336578979492E+03},
 {     301, .8366604492188E+04, -.1300832031250E+04, .9158396606445E+03},
 {     302, .8352696289062E+04, -.1300832031250E+04, .9220664672852E+03},
 {     303, .8366604492188E+04, -.1285592041016E+04, .9158396606445E+03},
 {     304, .8352696289062E+04, -.1285592041016E+04, .9220664672852E+03},
 {     305, .8366604492188E+04, -.1270352050781E+04, .9158396606445E+03},
 {     306, .8352696289062E+04, -.1270352050781E+04, .9220664672852E+03},
 {     307, .8366604492188E+04, -.1255112060547E+04, .9158396606445E+03},
 {     308, .8352696289062E+04, -.1255112060547E+04, .9220664672852E+03},
 {     309, .8364531250000E+04, -.1300832031250E+04, .9112027587891E+03},
 {     310, .8350619140625E+04, -.1300832031250E+04, .9174299926758E+03},
 {     311, .8364531250000E+04, -.1285592041016E+04, .9112027587891E+03},
 {     312, .8350619140625E+04, -.1285592041016E+04, .9174299926758E+03},
 {     313, .8364531250000E+04, -.1270352050781E+04, .9112027587891E+03},
 {     314, .8350619140625E+04, -.1270352050781E+04, .9174299926758E+03},
 {     315, .8364531250000E+04, -.1255112060547E+04, .9112027587891E+03},
 {     316, .8350619140625E+04, -.1255112060547E+04, .9174299926758E+03},
 {     317, .8434968750000E+04, -.1248762084961E+04, .1129415771484E+04},
 {     318, .8433782226562E+04, -.1248762084961E+04, .1124871093750E+04},
 {     319, .8426966796875E+04, -.1255112060547E+04, .1098813476562E+04},
 {     320, .8426966796875E+04, -.1248762084961E+04, .1098813476562E+04},
 {     321, .8420154296875E+04, -.1248762084961E+04, .1072756347656E+04},
 {     322, .8428875976562E+04, -.1248762084961E+04, .1054938110352E+04},
 {     323, .8414964843750E+04, -.1248762084961E+04, .1061164794922E+04},
 {     324, .8423685546875E+04, -.1248762084961E+04, .1043346679688E+04},
 {     325, .8409775390625E+04, -.1248762084961E+04, .1049573486328E+04},
 {     326, .8418497070312E+04, -.1248762084961E+04, .1031754394531E+04},
 {     327, .8404586914062E+04, -.1248762084961E+04, .1037981933594E+04},
 {     328, .8413306640625E+04, -.1248762084961E+04, .1020163574219E+04},
 {     329, .8399399414062E+04, -.1248762084961E+04, .1026390747070E+04},
 {     330, .8412009765625E+04, -.1248762084961E+04, .1017265747070E+04},
 {     331, .8398100585938E+04, -.1248762084961E+04, .1023492065430E+04},
 {     332, .8406821289062E+04, -.1248762084961E+04, .1005673706055E+04},
 {     333, .8392910156250E+04, -.1248762084961E+04, .1011901184082E+04},
 {     334, .8401631835938E+04, -.1248762084961E+04, .9940820312500E+03},
 {     335, .8387722656250E+04, -.1248762084961E+04, .1000309448242E+04},
 {     336, .8400334960938E+04, -.1248762084961E+04, .9911846923828E+03},
 {     337, .8386424804688E+04, -.1248762084961E+04, .9974113159180E+03},
 {     338, .8395144531250E+04, -.1248762084961E+04, .9795933837891E+03},
 {     339, .8381236328125E+04, -.1248762084961E+04, .9858200683594E+03},
 {     340, .8389957031250E+04, -.1248762084961E+04, .9680015869141E+03},
 {     341, .8376045898438E+04, -.1248762084961E+04, .9742283325195E+03},
 {     342, .8388660156250E+04, -.1248762084961E+04, .9651035156250E+03},
 {     343, .8374750000000E+04, -.1248762084961E+04, .9713304443359E+03},
 {     344, .8383468750000E+04, -.1248762084961E+04, .9535125122070E+03},
 {     345, .8369560546875E+04, -.1248762084961E+04, .9597390747070E+03},
 {     346, .8378281250000E+04, -.1248762084961E+04, .9419204711914E+03},
 {     347, .8364371093750E+04, -.1248762084961E+04, .9481473999023E+03},
 {     348, .8376984375000E+04, -.1248762084961E+04, .9390224609375E+03},
 {     349, .8363074218750E+04, -.1248762084961E+04, .9452495727539E+03},
 {     350, .8371793945312E+04, -.1248762084961E+04, .9274310302734E+03},
 {     351, .8357883789062E+04, -.1248762084961E+04, .9336578979492E+03},
 {     352, .8366604492188E+04, -.1248762084961E+04, .9158396606445E+03},
 {     353, .8352696289062E+04, -.1248762084961E+04, .9220664672852E+03},
 {     354, .8364531250000E+04, -.1248762084961E+04, .9112027587891E+03},
 {     355, .8350619140625E+04, -.1248762084961E+04, .9174299926758E+03},
 {     356, .8434968750000E+04, -.1234791992188E+04, .1129415771484E+04},
 {     357, .8433782226562E+04, -.1234791992188E+04, .1124871093750E+04},
 {     358, .8416972656250E+04, -.1336392089844E+04, .1134121948242E+04},
 {     359, .8398976562500E+04, -.1336392089844E+04, .1138827880859E+04},
 {     360, .8416972656250E+04, -.1322421997070E+04, .1134121948242E+04},
 {     361, .8398976562500E+04, -.1322421997070E+04, .1138827880859E+04},
 {     362, .8415571289062E+04, -.1336392089844E+04, .1129632568359E+04},
 {     363, .8397360351562E+04, -.1336392089844E+04, .1134395141602E+04},
 {     364, .8415571289062E+04, -.1322421997070E+04, .1129632568359E+04},
 {     365, .8397360351562E+04, -.1322421997070E+04, .1134395141602E+04},
 {     366, .8416972656250E+04, -.1316072021484E+04, .1134121948242E+04},
 {     367, .8398976562500E+04, -.1316072021484E+04, .1138827880859E+04},
 {     368, .8415571289062E+04, -.1316072021484E+04, .1129632568359E+04},
 {     369, .8397360351562E+04, -.1316072021484E+04, .1134395141602E+04},
 {     370, .8408059570312E+04, -.1322421997070E+04, .1105346069336E+04},
 {     371, .8389152343750E+04, -.1322421997070E+04, .1111878662109E+04},
 {     372, .8408059570312E+04, -.1316072021484E+04, .1105346069336E+04},
 {     373, .8389152343750E+04, -.1316072021484E+04, .1111878662109E+04},
 {     374, .8400548828125E+04, -.1322421997070E+04, .1081059814453E+04},
 {     375, .8380944335938E+04, -.1322421997070E+04, .1089363159180E+04},
 {     376, .8400548828125E+04, -.1316072021484E+04, .1081059814453E+04},
 {     377, .8380944335938E+04, -.1316072021484E+04, .1089363159180E+04},
 {     378, .8395785156250E+04, -.1322421997070E+04, .1069313354492E+04},
 {     379, .8376604492188E+04, -.1322421997070E+04, .1077461914062E+04},
 {     380, .8395785156250E+04, -.1316072021484E+04, .1069313354492E+04},
 {     381, .8376604492188E+04, -.1316072021484E+04, .1077461914062E+04},
 {     382, .8391020507812E+04, -.1322421997070E+04, .1057566650391E+04},
 {     383, .8372265625000E+04, -.1322421997070E+04, .1065559936523E+04},
 {     384, .8391020507812E+04, -.1316072021484E+04, .1057566650391E+04},
 {     385, .8372265625000E+04, -.1316072021484E+04, .1065559936523E+04},
 {     386, .8386255859375E+04, -.1322421997070E+04, .1045820434570E+04},
 {     387, .8367925781250E+04, -.1322421997070E+04, .1053658691406E+04},
 {     388, .8386255859375E+04, -.1316072021484E+04, .1045820434570E+04},
 {     389, .8367925781250E+04, -.1316072021484E+04, .1053658691406E+04},
 {     390, .8381492187500E+04, -.1322421997070E+04, .1034073974609E+04},
 {     391, .8363587890625E+04, -.1322421997070E+04, .1041757446289E+04},
 {     392, .8381492187500E+04, -.1316072021484E+04, .1034073974609E+04},
 {     393, .8363587890625E+04, -.1316072021484E+04, .1041757446289E+04},
 {     394, .8380301757812E+04, -.1322421997070E+04, .1031137573242E+04},
 {     395, .8362500976562E+04, -.1322421997070E+04, .1038782226562E+04},
 {     396, .8380301757812E+04, -.1316072021484E+04, .1031137573242E+04},
 {     397, .8362500976562E+04, -.1316072021484E+04, .1038782226562E+04},
 {     398, .8375536132812E+04, -.1322421997070E+04, .1019390747070E+04},
 {     399, .8358162109375E+04, -.1322421997070E+04, .1026880493164E+04},
 {     400, .8375536132812E+04, -.1316072021484E+04, .1019390747070E+04},
 {     401, .8358162109375E+04, -.1316072021484E+04, .1026880493164E+04},
 {     402, .8370773437500E+04, -.1322421997070E+04, .1007644409180E+04},
 {     403, .8353825195312E+04, -.1322421997070E+04, .1014978881836E+04},
 {     404, .8370773437500E+04, -.1316072021484E+04, .1007644409180E+04},
 {     405, .8353825195312E+04, -.1316072021484E+04, .1014978881836E+04},
 {     406, .8369581054688E+04, -.1322421997070E+04, .1004707702637E+04},
 {     407, .8352739257812E+04, -.1322421997070E+04, .1012003540039E+04},
 {     408, .8369581054688E+04, -.1316072021484E+04, .1004707702637E+04},
 {     409, .8352739257812E+04, -.1316072021484E+04, .1012003540039E+04},
 {     410, .8364818359375E+04, -.1322421997070E+04, .9929609375000E+03},
 {     411, .8348402343750E+04, -.1322421997070E+04, .1000102050781E+04},
 {     412, .8364818359375E+04, -.1316072021484E+04, .9929609375000E+03},
 {     413, .8348402343750E+04, -.1316072021484E+04, .1000102050781E+04},
 {     414, .8360055664062E+04, -.1322421997070E+04, .9812144775391E+03},
 {     415, .8344062500000E+04, -.1322421997070E+04, .9882008666992E+03},
 {     416, .8360055664062E+04, -.1316072021484E+04, .9812144775391E+03},
 {     417, .8344062500000E+04, -.1316072021484E+04, .9882008666992E+03},
 {     418, .8358863281250E+04, -.1322421997070E+04, .9782779541016E+03},
 {     419, .8342976562500E+04, -.1322421997070E+04, .9852258300781E+03},
 {     420, .8358863281250E+04, -.1316072021484E+04, .9782779541016E+03},
 {     421, .8342976562500E+04, -.1316072021484E+04, .9852258300781E+03},
 {     422, .8354100585938E+04, -.1322421997070E+04, .9665313110352E+03},
 {     423, .8338638671875E+04, -.1322421997070E+04, .9733240966797E+03},
 {     424, .8354100585938E+04, -.1316072021484E+04, .9665313110352E+03},
 {     425, .8338638671875E+04, -.1316072021484E+04, .9733240966797E+03},
 {     426, .8349333984375E+04, -.1322421997070E+04, .9547850341797E+03},
 {     427, .8334298828125E+04, -.1322421997070E+04, .9614224853516E+03},
 {     428, .8349333984375E+04, -.1316072021484E+04, .9547850341797E+03},
 {     429, .8334298828125E+04, -.1316072021484E+04, .9614224853516E+03},
 {     430, .8348143554688E+04, -.1322421997070E+04, .9518484497070E+03},
 {     431, .8333214843750E+04, -.1322421997070E+04, .9584469604492E+03},
 {     432, .8348143554688E+04, -.1316072021484E+04, .9518484497070E+03},
 {     433, .8333214843750E+04, -.1316072021484E+04, .9584469604492E+03},
 {     434, .8343379882812E+04, -.1322421997070E+04, .9401017456055E+03},
 {     435, .8328873046875E+04, -.1322421997070E+04, .9465457763672E+03},
 {     436, .8343379882812E+04, -.1316072021484E+04, .9401017456055E+03},
 {     437, .8328873046875E+04, -.1316072021484E+04, .9465457763672E+03},
 {     438, .8338615234375E+04, -.1322421997070E+04, .9283553466797E+03},
 {     439, .8324534179688E+04, -.1322421997070E+04, .9346444091797E+03},
 {     440, .8338615234375E+04, -.1316072021484E+04, .9283553466797E+03},
 {     441, .8324534179688E+04, -.1316072021484E+04, .9346444091797E+03},
 {     442, .8336710937500E+04, -.1322421997070E+04, .9236568603516E+03},
 {     443, .8322800781250E+04, -.1322421997070E+04, .9298833618164E+03},
 {     444, .8336710937500E+04, -.1316072021484E+04, .9236568603516E+03},
 {     445, .8322800781250E+04, -.1316072021484E+04, .9298833618164E+03},
 {     446, .8416972656250E+04, -.1300832031250E+04, .1134121948242E+04},
 {     447, .8398976562500E+04, -.1300832031250E+04, .1138827880859E+04},
 {     448, .8416972656250E+04, -.1285592041016E+04, .1134121948242E+04},
 {     449, .8398976562500E+04, -.1285592041016E+04, .1138827880859E+04},
 {     450, .8416972656250E+04, -.1270352050781E+04, .1134121948242E+04},
 {     451, .8398976562500E+04, -.1270352050781E+04, .1138827880859E+04},
 {     452, .8416972656250E+04, -.1255112060547E+04, .1134121948242E+04},
 {     453, .8398976562500E+04, -.1255112060547E+04, .1138827880859E+04},
 {     454, .8415571289062E+04, -.1300832031250E+04, .1129632568359E+04},
 {     455, .8397360351562E+04, -.1300832031250E+04, .1134395141602E+04},
 {     456, .8415571289062E+04, -.1285592041016E+04, .1129632568359E+04},
 {     457, .8397360351562E+04, -.1285592041016E+04, .1134395141602E+04},
 {     458, .8415571289062E+04, -.1270352050781E+04, .1129632568359E+04},
 {     459, .8397360351562E+04, -.1270352050781E+04, .1134395141602E+04},
 {     460, .8415571289062E+04, -.1255112060547E+04, .1129632568359E+04},
 {     461, .8397360351562E+04, -.1255112060547E+04, .1134395141602E+04},
 {     462, .8338615234375E+04, -.1300832031250E+04, .9283553466797E+03},
 {     463, .8324534179688E+04, -.1300832031250E+04, .9346444091797E+03},
 {     464, .8338615234375E+04, -.1285592041016E+04, .9283553466797E+03},
 {     465, .8324534179688E+04, -.1285592041016E+04, .9346444091797E+03},
 {     466, .8338615234375E+04, -.1270352050781E+04, .9283553466797E+03},
 {     467, .8324534179688E+04, -.1270352050781E+04, .9346444091797E+03},
 {     468, .8338615234375E+04, -.1255112060547E+04, .9283553466797E+03},
 {     469, .8324534179688E+04, -.1255112060547E+04, .9346444091797E+03},
 {     470, .8336710937500E+04, -.1300832031250E+04, .9236568603516E+03},
 {     471, .8322800781250E+04, -.1300832031250E+04, .9298833618164E+03},
 {     472, .8336710937500E+04, -.1285592041016E+04, .9236568603516E+03},
 {     473, .8322800781250E+04, -.1285592041016E+04, .9298833618164E+03},
 {     474, .8336710937500E+04, -.1270352050781E+04, .9236568603516E+03},
 {     475, .8322800781250E+04, -.1270352050781E+04, .9298833618164E+03},
 {     476, .8336710937500E+04, -.1255112060547E+04, .9236568603516E+03},
 {     477, .8322800781250E+04, -.1255112060547E+04, .9298833618164E+03},
 {     478, .8416972656250E+04, -.1248762084961E+04, .1134121948242E+04},
 {     479, .8398976562500E+04, -.1248762084961E+04, .1138827880859E+04},
 {     480, .8415571289062E+04, -.1248762084961E+04, .1129632568359E+04},
 {     481, .8397360351562E+04, -.1248762084961E+04, .1134395141602E+04},
 {     482, .8408059570312E+04, -.1255112060547E+04, .1105346069336E+04},
 {     483, .8389152343750E+04, -.1255112060547E+04, .1111878662109E+04},
 {     484, .8408059570312E+04, -.1248762084961E+04, .1105346069336E+04},
 {     485, .8389152343750E+04, -.1248762084961E+04, .1111878662109E+04},
 {     486, .8400548828125E+04, -.1255112060547E+04, .1081059814453E+04},
 {     487, .8380944335938E+04, -.1255112060547E+04, .1089363159180E+04},
 {     488, .8400548828125E+04, -.1248762084961E+04, .1081059814453E+04},
 {     489, .8380944335938E+04, -.1248762084961E+04, .1089363159180E+04},
 {     490, .8395785156250E+04, -.1255112060547E+04, .1069313354492E+04},
 {     491, .8376604492188E+04, -.1255112060547E+04, .1077461914062E+04},
 {     492, .8395785156250E+04, -.1248762084961E+04, .1069313354492E+04},
 {     493, .8376604492188E+04, -.1248762084961E+04, .1077461914062E+04},
 {     494, .8391020507812E+04, -.1255112060547E+04, .1057566650391E+04},
 {     495, .8372265625000E+04, -.1255112060547E+04, .1065559936523E+04},
 {     496, .8391020507812E+04, -.1248762084961E+04, .1057566650391E+04},
 {     497, .8372265625000E+04, -.1248762084961E+04, .1065559936523E+04},
 {     498, .8386255859375E+04, -.1255112060547E+04, .1045820434570E+04},
 {     499, .8367925781250E+04, -.1255112060547E+04, .1053658691406E+04},
 {     500, .8386255859375E+04, -.1248762084961E+04, .1045820434570E+04},
 {     501, .8367925781250E+04, -.1248762084961E+04, .1053658691406E+04},
 {     502, .8381492187500E+04, -.1255112060547E+04, .1034073974609E+04},
 {     503, .8363587890625E+04, -.1255112060547E+04, .1041757446289E+04},
 {     504, .8381492187500E+04, -.1248762084961E+04, .1034073974609E+04},
 {     505, .8363587890625E+04, -.1248762084961E+04, .1041757446289E+04},
 {     506, .8380301757812E+04, -.1255112060547E+04, .1031137573242E+04},
 {     507, .8362500976562E+04, -.1255112060547E+04, .1038782226562E+04},
 {     508, .8380301757812E+04, -.1248762084961E+04, .1031137573242E+04},
 {     509, .8362500976562E+04, -.1248762084961E+04, .1038782226562E+04},
 {     510, .8375536132812E+04, -.1255112060547E+04, .1019390747070E+04},
 {     511, .8358162109375E+04, -.1255112060547E+04, .1026880493164E+04},
 {     512, .8375536132812E+04, -.1248762084961E+04, .1019390747070E+04},
 {     513, .8358162109375E+04, -.1248762084961E+04, .1026880493164E+04},
 {     514, .8370773437500E+04, -.1255112060547E+04, .1007644409180E+04},
 {     515, .8353825195312E+04, -.1255112060547E+04, .1014978881836E+04},
 {     516, .8370773437500E+04, -.1248762084961E+04, .1007644409180E+04},
 {     517, .8353825195312E+04, -.1248762084961E+04, .1014978881836E+04},
 {     518, .8369581054688E+04, -.1255112060547E+04, .1004707702637E+04},
 {     519, .8352739257812E+04, -.1255112060547E+04, .1012003540039E+04},
 {     520, .8369581054688E+04, -.1248762084961E+04, .1004707702637E+04},
 {     521, .8352739257812E+04, -.1248762084961E+04, .1012003540039E+04},
 {     522, .8364818359375E+04, -.1255112060547E+04, .9929609375000E+03},
 {     523, .8348402343750E+04, -.1255112060547E+04, .1000102050781E+04},
 {     524, .8364818359375E+04, -.1248762084961E+04, .9929609375000E+03},
 {     525, .8348402343750E+04, -.1248762084961E+04, .1000102050781E+04},
 {     526, .8360055664062E+04, -.1255112060547E+04, .9812144775391E+03},
 {     527, .8344062500000E+04, -.1255112060547E+04, .9882008666992E+03},
 {     528, .8360055664062E+04, -.1248762084961E+04, .9812144775391E+03},
 {     529, .8344062500000E+04, -.1248762084961E+04, .9882008666992E+03},
 {     530, .8358863281250E+04, -.1255112060547E+04, .9782779541016E+03},
 {     531, .8342976562500E+04, -.1255112060547E+04, .9852258300781E+03},
 {     532, .8358863281250E+04, -.1248762084961E+04, .9782779541016E+03},
 {     533, .8342976562500E+04, -.1248762084961E+04, .9852258300781E+03},
 {     534, .8354100585938E+04, -.1255112060547E+04, .9665313110352E+03},
 {     535, .8338638671875E+04, -.1255112060547E+04, .9733240966797E+03},
 {     536, .8354100585938E+04, -.1248762084961E+04, .9665313110352E+03},
 {     537, .8338638671875E+04, -.1248762084961E+04, .9733240966797E+03},
 {     538, .8349333984375E+04, -.1255112060547E+04, .9547850341797E+03},
 {     539, .8334298828125E+04, -.1255112060547E+04, .9614224853516E+03},
 {     540, .8349333984375E+04, -.1248762084961E+04, .9547850341797E+03},
 {     541, .8334298828125E+04, -.1248762084961E+04, .9614224853516E+03},
 {     542, .8348143554688E+04, -.1255112060547E+04, .9518484497070E+03},
 {     543, .8333214843750E+04, -.1255112060547E+04, .9584469604492E+03},
 {     544, .8348143554688E+04, -.1248762084961E+04, .9518484497070E+03},
 {     545, .8333214843750E+04, -.1248762084961E+04, .9584469604492E+03},
 {     546, .8343379882812E+04, -.1255112060547E+04, .9401017456055E+03},
 {     547, .8328873046875E+04, -.1255112060547E+04, .9465457763672E+03},
 {     548, .8343379882812E+04, -.1248762084961E+04, .9401017456055E+03},
 {     549, .8328873046875E+04, -.1248762084961E+04, .9465457763672E+03},
 {     550, .8338615234375E+04, -.1248762084961E+04, .9283553466797E+03},
 {     551, .8324534179688E+04, -.1248762084961E+04, .9346444091797E+03},
 {     552, .8336710937500E+04, -.1248762084961E+04, .9236568603516E+03},
 {     553, .8322800781250E+04, -.1248762084961E+04, .9298833618164E+03},
 {     554, .8416972656250E+04, -.1234791992188E+04, .1134121948242E+04},
 {     555, .8398976562500E+04, -.1234791992188E+04, .1138827880859E+04},
 {     556, .8415571289062E+04, -.1234791992188E+04, .1129632568359E+04},
 {     557, .8397360351562E+04, -.1234791992188E+04, .1134395141602E+04},
 {     558, .8380511718750E+04, -.1336392089844E+04, .1143656005859E+04},
 {     559, .8362046875000E+04, -.1336392089844E+04, .1148484252930E+04},
 {     560, .8380511718750E+04, -.1322421997070E+04, .1143656005859E+04},
 {     561, .8362046875000E+04, -.1322421997070E+04, .1148484252930E+04},
 {     562, .8378894531250E+04, -.1336392089844E+04, .1139223510742E+04},
 {     563, .8360430664062E+04, -.1336392089844E+04, .1144051879883E+04},
 {     564, .8378894531250E+04, -.1322421997070E+04, .1139223510742E+04},
 {     565, .8360430664062E+04, -.1322421997070E+04, .1144051879883E+04},
 {     566, .8380511718750E+04, -.1316072021484E+04, .1143656005859E+04},
 {     567, .8362046875000E+04, -.1316072021484E+04, .1148484252930E+04},
 {     568, .8378894531250E+04, -.1316072021484E+04, .1139223510742E+04},
 {     569, .8360430664062E+04, -.1316072021484E+04, .1144051879883E+04},
 {     570, .8371226562500E+04, -.1322421997070E+04, .1118185058594E+04},
 {     571, .8353299804688E+04, -.1322421997070E+04, .1124491210938E+04},
 {     572, .8371226562500E+04, -.1316072021484E+04, .1118185058594E+04},
 {     573, .8353299804688E+04, -.1316072021484E+04, .1124491210938E+04},
 {     574, .8363556640625E+04, -.1322421997070E+04, .1097146728516E+04},
 {     575, .8346169921875E+04, -.1322421997070E+04, .1104930053711E+04},
 {     576, .8363556640625E+04, -.1316072021484E+04, .1097146728516E+04},
 {     577, .8346169921875E+04, -.1316072021484E+04, .1104930053711E+04},
 {     578, .8359215820312E+04, -.1322421997070E+04, .1085245239258E+04},
 {     579, .8341830078125E+04, -.1322421997070E+04, .1093029174805E+04},
 {     580, .8359215820312E+04, -.1316072021484E+04, .1085245239258E+04},
 {     581, .8341830078125E+04, -.1316072021484E+04, .1093029174805E+04},
 {     582, .8354876953125E+04, -.1322421997070E+04, .1073343994141E+04},
 {     583, .8337489257812E+04, -.1322421997070E+04, .1081127685547E+04},
 {     584, .8354876953125E+04, -.1316072021484E+04, .1073343994141E+04},
 {     585, .8337489257812E+04, -.1316072021484E+04, .1081127685547E+04},
 {     586, .8350541015625E+04, -.1322421997070E+04, .1061442260742E+04},
 {     587, .8333151367188E+04, -.1322421997070E+04, .1069225830078E+04},
 {     588, .8350541015625E+04, -.1316072021484E+04, .1061442260742E+04},
 {     589, .8333151367188E+04, -.1316072021484E+04, .1069225830078E+04},
 {     590, .8346200195312E+04, -.1322421997070E+04, .1049540527344E+04},
 {     591, .8328813476562E+04, -.1322421997070E+04, .1057324462891E+04},
 {     592, .8346200195312E+04, -.1316072021484E+04, .1049540527344E+04},
 {     593, .8328813476562E+04, -.1316072021484E+04, .1057324462891E+04},
 {     594, .8345115234375E+04, -.1322421997070E+04, .1046565673828E+04},
 {     595, .8327726562500E+04, -.1322421997070E+04, .1054348999023E+04},
 {     596, .8345115234375E+04, -.1316072021484E+04, .1046565673828E+04},
 {     597, .8327726562500E+04, -.1316072021484E+04, .1054348999023E+04},
 {     598, .8340775390625E+04, -.1322421997070E+04, .1034663818359E+04},
 {     599, .8323387695312E+04, -.1322421997070E+04, .1042448120117E+04},
 {     600, .8340775390625E+04, -.1316072021484E+04, .1034663818359E+04},
 {     601, .8323387695312E+04, -.1316072021484E+04, .1042448120117E+04},
 {     602, .8336436523438E+04, -.1322421997070E+04, .1022763061523E+04},
 {     603, .8319047851562E+04, -.1322421997070E+04, .1030546630859E+04},
 {     604, .8336436523438E+04, -.1316072021484E+04, .1022763061523E+04},
 {     605, .8319047851562E+04, -.1316072021484E+04, .1030546630859E+04},
 {     606, .8335351562500E+04, -.1322421997070E+04, .1019787292480E+04},
 {     607, .8317963867188E+04, -.1322421997070E+04, .1027571166992E+04},
 {     608, .8335351562500E+04, -.1316072021484E+04, .1019787292480E+04},
 {     609, .8317963867188E+04, -.1316072021484E+04, .1027571166992E+04},
 {     610, .8331013671875E+04, -.1322421997070E+04, .1007885559082E+04},
 {     611, .8313628906250E+04, -.1322421997070E+04, .1015669189453E+04},
 {     612, .8331013671875E+04, -.1316072021484E+04, .1007885559082E+04},
 {     613, .8313628906250E+04, -.1316072021484E+04, .1015669189453E+04},
 {     614, .8326674804688E+04, -.1322421997070E+04, .9959844970703E+03},
 {     615, .8309287109375E+04, -.1322421997070E+04, .1003768188477E+04},
 {     616, .8326674804688E+04, -.1316072021484E+04, .9959842529297E+03},
 {     617, .8309287109375E+04, -.1316072021484E+04, .1003768188477E+04},
 {     618, .8325590820312E+04, -.1322421997070E+04, .9930088500977E+03},
 {     619, .8308203125000E+04, -.1322421997070E+04, .1000792480469E+04},
 {     620, .8325590820312E+04, -.1316072021484E+04, .9930088500977E+03},
 {     621, .8308203125000E+04, -.1316072021484E+04, .1000792480469E+04},
 {     622, .8321250976562E+04, -.1322421997070E+04, .9811076660156E+03},
 {     623, .8303865234375E+04, -.1322421997070E+04, .9888907470703E+03},
 {     624, .8321250976562E+04, -.1316072021484E+04, .9811076660156E+03},
 {     625, .8303865234375E+04, -.1316072021484E+04, .9888907470703E+03},
 {     626, .8316912109375E+04, -.1322421997070E+04, .9692061767578E+03},
 {     627, .8299524414062E+04, -.1322421997070E+04, .9769899291992E+03},
 {     628, .8316912109375E+04, -.1316072021484E+04, .9692061767578E+03},
 {     629, .8299524414062E+04, -.1316072021484E+04, .9769899291992E+03},
 {     630, .8315827148438E+04, -.1322421997070E+04, .9662307128906E+03},
 {     631, .8298438476562E+04, -.1322421997070E+04, .9740146484375E+03},
 {     632, .8315827148438E+04, -.1316072021484E+04, .9662307128906E+03},
 {     633, .8298438476562E+04, -.1316072021484E+04, .9740146484375E+03},
 {     634, .8311488281250E+04, -.1322421997070E+04, .9543291625977E+03},
 {     635, .8294100585938E+04, -.1322421997070E+04, .9621129150391E+03},
 {     636, .8311488281250E+04, -.1316072021484E+04, .9543291625977E+03},
 {     637, .8294100585938E+04, -.1316072021484E+04, .9621129150391E+03},
 {     638, .8307148437500E+04, -.1322421997070E+04, .9424277954102E+03},
 {     639, .8289761718750E+04, -.1322421997070E+04, .9502113647461E+03},
 {     640, .8307148437500E+04, -.1316072021484E+04, .9424277954102E+03},
 {     641, .8289761718750E+04, -.1316072021484E+04, .9502113647461E+03},
 {     642, .8305412109375E+04, -.1322421997070E+04, .9376674194336E+03},
 {     643, .8288026367188E+04, -.1322421997070E+04, .9454510498047E+03},
 {     644, .8305412109375E+04, -.1316072021484E+04, .9376674194336E+03},
 {     645, .8288026367188E+04, -.1316072021484E+04, .9454510498047E+03},
 {     646, .8380511718750E+04, -.1300832031250E+04, .1143656005859E+04},
 {     647, .8362046875000E+04, -.1300832031250E+04, .1148484252930E+04},
 {     648, .8380511718750E+04, -.1285592041016E+04, .1143656005859E+04},
 {     649, .8362046875000E+04, -.1285592041016E+04, .1148484252930E+04},
 {     650, .8380511718750E+04, -.1270352050781E+04, .1143656005859E+04},
 {     651, .8362046875000E+04, -.1270352050781E+04, .1148484252930E+04},
 {     652, .8380511718750E+04, -.1255112060547E+04, .1143656005859E+04},
 {     653, .8362046875000E+04, -.1255112060547E+04, .1148484252930E+04},
 {     654, .8378894531250E+04, -.1300832031250E+04, .1139223510742E+04},
 {     655, .8360430664062E+04, -.1300832031250E+04, .1144051879883E+04},
 {     656, .8378894531250E+04, -.1285592041016E+04, .1139223510742E+04},
 {     657, .8360430664062E+04, -.1285592041016E+04, .1144051879883E+04},
 {     658, .8378894531250E+04, -.1270352050781E+04, .1139223510742E+04},
 {     659, .8360430664062E+04, -.1270352050781E+04, .1144051879883E+04},
 {     660, .8378894531250E+04, -.1255112060547E+04, .1139223510742E+04},
 {     661, .8360430664062E+04, -.1255112060547E+04, .1144051879883E+04},
 {     662, .8389152343750E+04, -.1300832031250E+04, .1111878662109E+04},
 {     663, .8371226562500E+04, -.1300832031250E+04, .1118185058594E+04},
 {     664, .8353299804688E+04, -.1300832031250E+04, .1124491210938E+04},
 {     665, .8389152343750E+04, -.1285592041016E+04, .1111878662109E+04},
 {     666, .8371226562500E+04, -.1285592041016E+04, .1118185058594E+04},
 {     667, .8353299804688E+04, -.1285592041016E+04, .1124491210938E+04},
 {     668, .8389152343750E+04, -.1270352050781E+04, .1111878662109E+04},
 {     669, .8371226562500E+04, -.1270352050781E+04, .1118185058594E+04},
 {     670, .8353299804688E+04, -.1270352050781E+04, .1124491210938E+04},
 {     671, .8371226562500E+04, -.1255112060547E+04, .1118185058594E+04},
 {     672, .8353299804688E+04, -.1255112060547E+04, .1124491210938E+04},
 {     673, .8380944335938E+04, -.1300832031250E+04, .1089363159180E+04},
 {     674, .8363556640625E+04, -.1300832031250E+04, .1097146728516E+04},
 {     675, .8346169921875E+04, -.1300832031250E+04, .1104930053711E+04},
 {     676, .8380944335938E+04, -.1285592041016E+04, .1089363159180E+04},
 {     677, .8363556640625E+04, -.1285592041016E+04, .1097146728516E+04},
 {     678, .8346169921875E+04, -.1285592041016E+04, .1104930053711E+04},
 {     679, .8380944335938E+04, -.1270352050781E+04, .1089363159180E+04},
 {     680, .8363556640625E+04, -.1270352050781E+04, .1097146728516E+04},
 {     681, .8346169921875E+04, -.1270352050781E+04, .1104930053711E+04},
 {     682, .8363556640625E+04, -.1255112060547E+04, .1097146728516E+04},
 {     683, .8346169921875E+04, -.1255112060547E+04, .1104930053711E+04},
 {     684, .8376604492188E+04, -.1300832031250E+04, .1077461914062E+04},
 {     685, .8359215820312E+04, -.1300832031250E+04, .1085245239258E+04},
 {     686, .8341830078125E+04, -.1300832031250E+04, .1093029174805E+04},
 {     687, .8376604492188E+04, -.1285592041016E+04, .1077461914062E+04},
 {     688, .8359215820312E+04, -.1285592041016E+04, .1085245239258E+04},
 {     689, .8341830078125E+04, -.1285592041016E+04, .1093029174805E+04},
 {     690, .8376604492188E+04, -.1270352050781E+04, .1077461914062E+04},
 {     691, .8359215820312E+04, -.1270352050781E+04, .1085245239258E+04},
 {     692, .8341830078125E+04, -.1270352050781E+04, .1093029174805E+04},
 {     693, .8359215820312E+04, -.1255112060547E+04, .1085245239258E+04},
 {     694, .8341830078125E+04, -.1255112060547E+04, .1093029174805E+04},
 {     695, .8372265625000E+04, -.1300832031250E+04, .1065559936523E+04},
 {     696, .8354876953125E+04, -.1300832031250E+04, .1073343994141E+04},
 {     697, .8337489257812E+04, -.1300832031250E+04, .1081127685547E+04},
 {     698, .8372265625000E+04, -.1285592041016E+04, .1065559936523E+04},
 {     699, .8354876953125E+04, -.1285592041016E+04, .1073343994141E+04},
 {     700, .8337489257812E+04, -.1285592041016E+04, .1081127685547E+04},
 {     701, .8372265625000E+04, -.1270352050781E+04, .1065559936523E+04},
 {     702, .8354876953125E+04, -.1270352050781E+04, .1073343994141E+04},
 {     703, .8337489257812E+04, -.1270352050781E+04, .1081127685547E+04},
 {     704, .8354876953125E+04, -.1255112060547E+04, .1073343994141E+04},
 {     705, .8337489257812E+04, -.1255112060547E+04, .1081127685547E+04},
 {     706, .8367925781250E+04, -.1300832031250E+04, .1053658691406E+04},
 {     707, .8350541015625E+04, -.1300832031250E+04, .1061442260742E+04},
 {     708, .8333151367188E+04, -.1300832031250E+04, .1069225830078E+04},
 {     709, .8367925781250E+04, -.1285592041016E+04, .1053658691406E+04},
 {     710, .8350541015625E+04, -.1285592041016E+04, .1061442260742E+04},
 {     711, .8333151367188E+04, -.1285592041016E+04, .1069225830078E+04},
 {     712, .8367925781250E+04, -.1270352050781E+04, .1053658691406E+04},
 {     713, .8350541015625E+04, -.1270352050781E+04, .1061442260742E+04},
 {     714, .8333151367188E+04, -.1270352050781E+04, .1069225830078E+04},
 {     715, .8350541015625E+04, -.1255112060547E+04, .1061442260742E+04},
 {     716, .8333151367188E+04, -.1255112060547E+04, .1069225830078E+04},
 {     717, .8363587890625E+04, -.1300832031250E+04, .1041757446289E+04},
 {     718, .8346200195312E+04, -.1300832031250E+04, .1049540527344E+04},
 {     719, .8328813476562E+04, -.1300832031250E+04, .1057324462891E+04},
 {     720, .8363587890625E+04, -.1285592041016E+04, .1041757446289E+04},
 {     721, .8346200195312E+04, -.1285592041016E+04, .1049540527344E+04},
 {     722, .8328813476562E+04, -.1285592041016E+04, .1057324462891E+04},
 {     723, .8363587890625E+04, -.1270352050781E+04, .1041757446289E+04},
 {     724, .8346200195312E+04, -.1270352050781E+04, .1049540527344E+04},
 {     725, .8328813476562E+04, -.1270352050781E+04, .1057324462891E+04},
 {     726, .8346200195312E+04, -.1255112060547E+04, .1049540527344E+04},
 {     727, .8328813476562E+04, -.1255112060547E+04, .1057324462891E+04},
 {     728, .8362500976562E+04, -.1300832031250E+04, .1038782226562E+04},
 {     729, .8345115234375E+04, -.1300832031250E+04, .1046565673828E+04},
 {     730, .8327726562500E+04, -.1300832031250E+04, .1054348999023E+04},
 {     731, .8362500976562E+04, -.1285592041016E+04, .1038782226562E+04},
 {     732, .8345115234375E+04, -.1285592041016E+04, .1046565673828E+04},
 {     733, .8327726562500E+04, -.1285592041016E+04, .1054348999023E+04},
 {     734, .8362500976562E+04, -.1270352050781E+04, .1038782226562E+04},
 {     735, .8345115234375E+04, -.1270352050781E+04, .1046565673828E+04},
 {     736, .8327726562500E+04, -.1270352050781E+04, .1054348999023E+04},
 {     737, .8345115234375E+04, -.1255112060547E+04, .1046565673828E+04},
 {     738, .8327726562500E+04, -.1255112060547E+04, .1054348999023E+04},
 {     739, .8358162109375E+04, -.1300832031250E+04, .1026880493164E+04},
 {     740, .8340775390625E+04, -.1300832031250E+04, .1034663818359E+04},
 {     741, .8323387695312E+04, -.1300832031250E+04, .1042448120117E+04},
 {     742, .8358162109375E+04, -.1285592041016E+04, .1026880493164E+04},
 {     743, .8340775390625E+04, -.1285592041016E+04, .1034663818359E+04},
 {     744, .8323387695312E+04, -.1285592041016E+04, .1042448120117E+04},
 {     745, .8358162109375E+04, -.1270352050781E+04, .1026880493164E+04},
 {     746, .8340775390625E+04, -.1270352050781E+04, .1034663818359E+04},
 {     747, .8323387695312E+04, -.1270352050781E+04, .1042448120117E+04},
 {     748, .8340775390625E+04, -.1255112060547E+04, .1034663818359E+04},
 {     749, .8323387695312E+04, -.1255112060547E+04, .1042448120117E+04},
 {     750, .8353825195312E+04, -.1300832031250E+04, .1014978881836E+04},
 {     751, .8336436523438E+04, -.1300832031250E+04, .1022763061523E+04},
 {     752, .8319047851562E+04, -.1300832031250E+04, .1030546630859E+04},
 {     753, .8353825195312E+04, -.1285592041016E+04, .1014978881836E+04},
 {     754, .8336436523438E+04, -.1285592041016E+04, .1022763061523E+04},
 {     755, .8319047851562E+04, -.1285592041016E+04, .1030546630859E+04},
 {     756, .8353825195312E+04, -.1270352050781E+04, .1014978881836E+04},
 {     757, .8336436523438E+04, -.1270352050781E+04, .1022763061523E+04},
 {     758, .8319047851562E+04, -.1270352050781E+04, .1030546630859E+04},
 {     759, .8336436523438E+04, -.1255112060547E+04, .1022763061523E+04},
 {     760, .8319047851562E+04, -.1255112060547E+04, .1030546630859E+04},
 {     761, .8352739257812E+04, -.1300832031250E+04, .1012003540039E+04},
 {     762, .8335351562500E+04, -.1300832031250E+04, .1019787292480E+04},
 {     763, .8317963867188E+04, -.1300832031250E+04, .1027571166992E+04},
 {     764, .8352739257812E+04, -.1285592041016E+04, .1012003540039E+04},
 {     765, .8335351562500E+04, -.1285592041016E+04, .1019787292480E+04},
 {     766, .8317963867188E+04, -.1285592041016E+04, .1027571166992E+04},
 {     767, .8352739257812E+04, -.1270352050781E+04, .1012003540039E+04},
 {     768, .8335351562500E+04, -.1270352050781E+04, .1019787292480E+04},
 {     769, .8317963867188E+04, -.1270352050781E+04, .1027571166992E+04},
 {     770, .8335351562500E+04, -.1255112060547E+04, .1019787292480E+04},
 {     771, .8317963867188E+04, -.1255112060547E+04, .1027571166992E+04},
 {     772, .8348402343750E+04, -.1300832031250E+04, .1000102050781E+04},
 {     773, .8331013671875E+04, -.1300832031250E+04, .1007885559082E+04},
 {     774, .8313628906250E+04, -.1300832031250E+04, .1015669189453E+04},
 {     775, .8348402343750E+04, -.1285592041016E+04, .1000102050781E+04},
 {     776, .8331013671875E+04, -.1285592041016E+04, .1007885559082E+04},
 {     777, .8313628906250E+04, -.1285592041016E+04, .1015669189453E+04},
 {     778, .8348402343750E+04, -.1270352050781E+04, .1000102050781E+04},
 {     779, .8331013671875E+04, -.1270352050781E+04, .1007885559082E+04},
 {     780, .8313628906250E+04, -.1270352050781E+04, .1015669189453E+04},
 {     781, .8331013671875E+04, -.1255112060547E+04, .1007885559082E+04},
 {     782, .8313628906250E+04, -.1255112060547E+04, .1015669189453E+04},
 {     783, .8344062500000E+04, -.1300832031250E+04, .9882008666992E+03},
 {     784, .8326674804688E+04, -.1300832031250E+04, .9959842529297E+03},
 {     785, .8309287109375E+04, -.1300832031250E+04, .1003768188477E+04},
 {     786, .8344062500000E+04, -.1285592041016E+04, .9882008666992E+03},
 {     787, .8326674804688E+04, -.1285592041016E+04, .9959842529297E+03},
 {     788, .8309287109375E+04, -.1285592041016E+04, .1003768188477E+04},
 {     789, .8344062500000E+04, -.1270352050781E+04, .9882008666992E+03},
 {     790, .8326674804688E+04, -.1270352050781E+04, .9959842529297E+03},
 {     791, .8309287109375E+04, -.1270352050781E+04, .1003768188477E+04},
 {     792, .8326674804688E+04, -.1255112060547E+04, .9959842529297E+03},
 {     793, .8309287109375E+04, -.1255112060547E+04, .1003768188477E+04},
 {     794, .8342976562500E+04, -.1300832031250E+04, .9852258300781E+03},
 {     795, .8325590820312E+04, -.1300832031250E+04, .9930088500977E+03},
 {     796, .8308203125000E+04, -.1300832031250E+04, .1000792480469E+04},
 {     797, .8342976562500E+04, -.1285592041016E+04, .9852258300781E+03},
 {     798, .8325590820312E+04, -.1285592041016E+04, .9930088500977E+03},
 {     799, .8308203125000E+04, -.1285592041016E+04, .1000792480469E+04},
 {     800, .8342976562500E+04, -.1270352050781E+04, .9852258300781E+03},
 {     801, .8325590820312E+04, -.1270352050781E+04, .9930088500977E+03},
 {     802, .8308203125000E+04, -.1270352050781E+04, .1000792480469E+04},
 {     803, .8325590820312E+04, -.1255112060547E+04, .9930088500977E+03},
 {     804, .8308203125000E+04, -.1255112060547E+04, .1000792480469E+04},
 {     805, .8338638671875E+04, -.1300832031250E+04, .9733240966797E+03},
 {     806, .8321250976562E+04, -.1300832031250E+04, .9811076660156E+03},
 {     807, .8303865234375E+04, -.1300832031250E+04, .9888907470703E+03},
 {     808, .8338638671875E+04, -.1285592041016E+04, .9733240966797E+03},
 {     809, .8321250976562E+04, -.1285592041016E+04, .9811076660156E+03},
 {     810, .8303865234375E+04, -.1285592041016E+04, .9888907470703E+03},
 {     811, .8338638671875E+04, -.1270352050781E+04, .9733240966797E+03},
 {     812, .8321250976562E+04, -.1270352050781E+04, .9811076660156E+03},
 {     813, .8303865234375E+04, -.1270352050781E+04, .9888907470703E+03},
 {     814, .8321250976562E+04, -.1255112060547E+04, .9811076660156E+03},
 {     815, .8303865234375E+04, -.1255112060547E+04, .9888907470703E+03},
 {     816, .8334298828125E+04, -.1300832031250E+04, .9614224853516E+03},
 {     817, .8316912109375E+04, -.1300832031250E+04, .9692061767578E+03},
 {     818, .8299524414062E+04, -.1300832031250E+04, .9769899291992E+03},
 {     819, .8334298828125E+04, -.1285592041016E+04, .9614224853516E+03},
 {     820, .8316912109375E+04, -.1285592041016E+04, .9692061767578E+03},
 {     821, .8299524414062E+04, -.1285592041016E+04, .9769899291992E+03},
 {     822, .8334298828125E+04, -.1270352050781E+04, .9614224853516E+03},
 {     823, .8316912109375E+04, -.1270352050781E+04, .9692061767578E+03},
 {     824, .8299524414062E+04, -.1270352050781E+04, .9769899291992E+03},
 {     825, .8316912109375E+04, -.1255112060547E+04, .9692061767578E+03},
 {     826, .8299524414062E+04, -.1255112060547E+04, .9769899291992E+03},
 {     827, .8333214843750E+04, -.1300832031250E+04, .9584469604492E+03},
 {     828, .8315827148438E+04, -.1300832031250E+04, .9662307128906E+03},
 {     829, .8298438476562E+04, -.1300832031250E+04, .9740146484375E+03},
 {     830, .8333214843750E+04, -.1285592041016E+04, .9584469604492E+03},
 {     831, .8315827148438E+04, -.1285592041016E+04, .9662307128906E+03},
 {     832, .8298438476562E+04, -.1285592041016E+04, .9740146484375E+03},
 {     833, .8333214843750E+04, -.1270352050781E+04, .9584469604492E+03},
 {     834, .8315827148438E+04, -.1270352050781E+04, .9662307128906E+03},
 {     835, .8298438476562E+04, -.1270352050781E+04, .9740146484375E+03},
 {     836, .8315827148438E+04, -.1255112060547E+04, .9662307128906E+03},
 {     837, .8298438476562E+04, -.1255112060547E+04, .9740146484375E+03},
 {     838, .8328873046875E+04, -.1300832031250E+04, .9465457763672E+03},
 {     839, .8311488281250E+04, -.1300832031250E+04, .9543291625977E+03},
 {     840, .8294100585938E+04, -.1300832031250E+04, .9621129150391E+03},
 {     841, .8328873046875E+04, -.1285592041016E+04, .9465457763672E+03},
 {     842, .8311488281250E+04, -.1285592041016E+04, .9543291625977E+03},
 {     843, .8294100585938E+04, -.1285592041016E+04, .9621129150391E+03},
 {     844, .8328873046875E+04, -.1270352050781E+04, .9465457763672E+03},
 {     845, .8311488281250E+04, -.1270352050781E+04, .9543291625977E+03},
 {     846, .8294100585938E+04, -.1270352050781E+04, .9621129150391E+03},
 {     847, .8311488281250E+04, -.1255112060547E+04, .9543291625977E+03},
 {     848, .8294100585938E+04, -.1255112060547E+04, .9621129150391E+03},
 {     849, .8307148437500E+04, -.1300832031250E+04, .9424277954102E+03},
 {     850, .8289761718750E+04, -.1300832031250E+04, .9502113647461E+03},
 {     851, .8307148437500E+04, -.1285592041016E+04, .9424277954102E+03},
 {     852, .8289761718750E+04, -.1285592041016E+04, .9502113647461E+03},
 {     853, .8307148437500E+04, -.1270352050781E+04, .9424277954102E+03},
 {     854, .8289761718750E+04, -.1270352050781E+04, .9502113647461E+03},
 {     855, .8307148437500E+04, -.1255112060547E+04, .9424277954102E+03},
 {     856, .8289761718750E+04, -.1255112060547E+04, .9502113647461E+03},
 {     857, .8305412109375E+04, -.1300832031250E+04, .9376674194336E+03},
 {     858, .8288026367188E+04, -.1300832031250E+04, .9454510498047E+03},
 {     859, .8305412109375E+04, -.1285592041016E+04, .9376674194336E+03},
 {     860, .8288026367188E+04, -.1285592041016E+04, .9454510498047E+03},
 {     861, .8305412109375E+04, -.1270352050781E+04, .9376674194336E+03},
 {     862, .8288026367188E+04, -.1270352050781E+04, .9454510498047E+03},
 {     863, .8305412109375E+04, -.1255112060547E+04, .9376674194336E+03},
 {     864, .8288026367188E+04, -.1255112060547E+04, .9454510498047E+03},
 {     865, .8380511718750E+04, -.1248762084961E+04, .1143656005859E+04},
 {     866, .8362046875000E+04, -.1248762084961E+04, .1148484252930E+04},
 {     867, .8378894531250E+04, -.1248762084961E+04, .1139223510742E+04},
 {     868, .8360430664062E+04, -.1248762084961E+04, .1144051879883E+04},
 {     869, .8371226562500E+04, -.1248762084961E+04, .1118185058594E+04},
 {     870, .8353299804688E+04, -.1248762084961E+04, .1124491210938E+04},
 {     871, .8363556640625E+04, -.1248762084961E+04, .1097146728516E+04},
 {     872, .8346169921875E+04, -.1248762084961E+04, .1104930053711E+04},
 {     873, .8359215820312E+04, -.1248762084961E+04, .1085245239258E+04},
 {     874, .8341830078125E+04, -.1248762084961E+04, .1093029174805E+04},
 {     875, .8354876953125E+04, -.1248762084961E+04, .1073343994141E+04},
 {     876, .8337489257812E+04, -.1248762084961E+04, .1081127685547E+04},
 {     877, .8350541015625E+04, -.1248762084961E+04, .1061442260742E+04},
 {     878, .8333151367188E+04, -.1248762084961E+04, .1069225830078E+04},
 {     879, .8346200195312E+04, -.1248762084961E+04, .1049540527344E+04},
 {     880, .8328813476562E+04, -.1248762084961E+04, .1057324462891E+04},
 {     881, .8345115234375E+04, -.1248762084961E+04, .1046565673828E+04},
 {     882, .8327726562500E+04, -.1248762084961E+04, .1054348999023E+04},
 {     883, .8340775390625E+04, -.1248762084961E+04, .1034663818359E+04},
 {     884, .8323387695312E+04, -.1248762084961E+04, .1042448120117E+04},
 {     885, .8336436523438E+04, -.1248762084961E+04, .1022763061523E+04},
 {     886, .8319047851562E+04, -.1248762084961E+04, .1030546630859E+04},
 {     887, .8335351562500E+04, -.1248762084961E+04, .1019787292480E+04},
 {     888, .8317963867188E+04, -.1248762084961E+04, .1027571166992E+04},
 {     889, .8331013671875E+04, -.1248762084961E+04, .1007885559082E+04},
 {     890, .8313628906250E+04, -.1248762084961E+04, .1015669189453E+04},
 {     891, .8326674804688E+04, -.1248762084961E+04, .9959842529297E+03},
 {     892, .8309287109375E+04, -.1248762084961E+04, .1003768188477E+04},
 {     893, .8325590820312E+04, -.1248762084961E+04, .9930088500977E+03},
 {     894, .8308203125000E+04, -.1248762084961E+04, .1000792480469E+04},
 {     895, .8321250976562E+04, -.1248762084961E+04, .9811076660156E+03},
 {     896, .8303865234375E+04, -.1248762084961E+04, .9888907470703E+03},
 {     897, .8316912109375E+04, -.1248762084961E+04, .9692061767578E+03},
 {     898, .8299524414062E+04, -.1248762084961E+04, .9769899291992E+03},
 {     899, .8315827148438E+04, -.1248762084961E+04, .9662307128906E+03},
 {     900, .8298438476562E+04, -.1248762084961E+04, .9740146484375E+03},
 {     901, .8311488281250E+04, -.1248762084961E+04, .9543291625977E+03},
 {     902, .8294100585938E+04, -.1248762084961E+04, .9621129150391E+03},
 {     903, .8307148437500E+04, -.1248762084961E+04, .9424277954102E+03},
 {     904, .8289761718750E+04, -.1248762084961E+04, .9502113647461E+03},
 {     905, .8305412109375E+04, -.1248762084961E+04, .9376674194336E+03},
 {     906, .8288026367188E+04, -.1248762084961E+04, .9454510498047E+03},
 {     907, .8380511718750E+04, -.1234791992188E+04, .1143656005859E+04},
 {     908, .8362046875000E+04, -.1234791992188E+04, .1148484252930E+04},
 {     909, .8378894531250E+04, -.1234791992188E+04, .1139223510742E+04},
 {     910, .8360430664062E+04, -.1234791992188E+04, .1144051879883E+04},
 {     911, .8384388671875E+04, -.1248762084961E+04, .1031717529297E+04},
 {     912, .8370479492188E+04, -.1248762084961E+04, .1037944335938E+04},
 {     913, .8384388671875E+04, -.1243682006836E+04, .1031717529297E+04},
 {     914, .8370479492188E+04, -.1243682006836E+04, .1037944335938E+04},
 {     915, .8382312500000E+04, -.1248762084961E+04, .1027081298828E+04},
 {     916, .8368404296875E+04, -.1248762084961E+04, .1033307861328E+04},
 {     917, .8382312500000E+04, -.1243682006836E+04, .1027081298828E+04},
 {     918, .8368404296875E+04, -.1243682006836E+04, .1033307861328E+04},
 {     919, .8366747070312E+04, -.1248762084961E+04, .9923063354492E+03},
 {     920, .8352836914062E+04, -.1248762084961E+04, .9985332031250E+03},
 {     921, .8366747070312E+04, -.1243682006836E+04, .9923063354492E+03},
 {     922, .8352836914062E+04, -.1243682006836E+04, .9985332031250E+03},
 {     923, .8351178710938E+04, -.1248762084961E+04, .9575316162109E+03},
 {     924, .8337269531250E+04, -.1248762084961E+04, .9637586669922E+03},
 {     925, .8351178710938E+04, -.1243682006836E+04, .9575316162109E+03},
 {     926, .8337269531250E+04, -.1243682006836E+04, .9637586669922E+03},
 {     927, .8349103515625E+04, -.1248762084961E+04, .9528950195312E+03},
 {     928, .8335194335938E+04, -.1248762084961E+04, .9591218261719E+03},
 {     929, .8349103515625E+04, -.1243682006836E+04, .9528950195312E+03},
 {     930, .8335194335938E+04, -.1243682006836E+04, .9591218261719E+03},
 {     931, .8373957031250E+04, -.1232252075195E+04, .1036387451172E+04},
 {     932, .8365261718750E+04, -.1234156982422E+04, .1040279541016E+04},
 {     933, .8363524414062E+04, -.1220822021484E+04, .1041057495117E+04},
 {     934, .8360046875000E+04, -.1224632080078E+04, .1042614624023E+04},
 {     935, .8371880859375E+04, -.1232252075195E+04, .1031751464844E+04},
 {     936, .8363188476562E+04, -.1234156982422E+04, .1035642456055E+04},
 {     937, .8361448242188E+04, -.1220822021484E+04, .1036421264648E+04},
 {     938, .8357970703125E+04, -.1224632080078E+04, .1037977783203E+04},
 {     939, .8340746093750E+04, -.1232252075195E+04, .9622017822266E+03},
 {     940, .8332054687500E+04, -.1234157104492E+04, .9660935668945E+03},
 {     941, .8330314453125E+04, -.1220822021484E+04, .9668717651367E+03},
 {     942, .8326837890625E+04, -.1224632080078E+04, .9684285888672E+03},
 {     943, .8338672851562E+04, -.1232252075195E+04, .9575651855469E+03},
 {     944, .8329978515625E+04, -.1234157104492E+04, .9614570312500E+03},
 {     945, .8328240234375E+04, -.1220822021484E+04, .9622355957031E+03},
 {     946, .8324761718750E+04, -.1224632080078E+04, .9637919311523E+03},
 {     947, .8356571289062E+04, -.1248762084961E+04, .1044170898438E+04},
 {     948, .8342660156250E+04, -.1248762084961E+04, .1050398315430E+04},
 {     949, .8356571289062E+04, -.1243682006836E+04, .1044170898438E+04},
 {     950, .8342660156250E+04, -.1243682006836E+04, .1050398315430E+04},
 {     951, .8354495117188E+04, -.1248762084961E+04, .1039534545898E+04},
 {     952, .8340585937500E+04, -.1248762084961E+04, .1045761230469E+04},
 {     953, .8354495117188E+04, -.1243682006836E+04, .1039534545898E+04},
 {     954, .8340585937500E+04, -.1243682006836E+04, .1045761230469E+04},
 {     955, .8338926757812E+04, -.1248762084961E+04, .1004759948730E+04},
 {     956, .8325017578125E+04, -.1248762084961E+04, .1010986938477E+04},
 {     957, .8338926757812E+04, -.1243682006836E+04, .1004759948730E+04},
 {     958, .8325017578125E+04, -.1243682006836E+04, .1010986938477E+04},
 {     959, .8323359375000E+04, -.1248762084961E+04, .9699854736328E+03},
 {     960, .8309452148438E+04, -.1248762084961E+04, .9762120361328E+03},
 {     961, .8323359375000E+04, -.1243682006836E+04, .9699854736328E+03},
 {     962, .8309452148438E+04, -.1243682006836E+04, .9762120361328E+03},
 {     963, .8321284179688E+04, -.1248762084961E+04, .9653489379883E+03},
 {     964, .8307374023438E+04, -.1248762084961E+04, .9715754394531E+03},
 {     965, .8321284179688E+04, -.1243682006836E+04, .9653489379883E+03},
 {     966, .8307374023438E+04, -.1243682006836E+04, .9715754394531E+03},
 {     967, .8353959960938E+04, -.1231299560547E+04, .1045338745117E+04},
 {     968, .8342660156250E+04, -.1228442016602E+04, .1050398315430E+04},
 {     969, .8351354492188E+04, -.1218916992188E+04, .1046506103516E+04},
 {     970, .8342660156250E+04, -.1213202026367E+04, .1050398315430E+04},
 {     971, .8351885742188E+04, -.1231299560547E+04, .1040701782227E+04},
 {     972, .8340585937500E+04, -.1228442016602E+04, .1045761230469E+04},
 {     973, .8349277343750E+04, -.1218916992188E+04, .1041869873047E+04},
 {     974, .8340585937500E+04, -.1213202026367E+04, .1045761230469E+04},
 {     975, .8320751953125E+04, -.1231299560547E+04, .9711528320312E+03},
 {     976, .8309452148438E+04, -.1228442016602E+04, .9762120361328E+03},
 {     977, .8318144531250E+04, -.1218916992188E+04, .9723205566406E+03},
 {     978, .8309452148438E+04, -.1213202026367E+04, .9762120361328E+03},
 {     979, .8318675781250E+04, -.1231299560547E+04, .9665163574219E+03},
 {     980, .8307374023438E+04, -.1228442016602E+04, .9715754394531E+03},
 {     981, .8316069335938E+04, -.1218916992188E+04, .9676834716797E+03},
 {     982, .8307374023438E+04, -.1213202026367E+04, .9715754394531E+03},
 {     983, .8353090820312E+04, -.1209392089844E+04, .1045728027344E+04},
 {     984, .8342660156250E+04, -.1197962036133E+04, .1050398315430E+04},
 {     985, .8351016601562E+04, -.1209392089844E+04, .1041091796875E+04},
 {     986, .8340585937500E+04, -.1197962036133E+04, .1045761230469E+04},
 {     987, .8319881835938E+04, -.1209392089844E+04, .9715419921875E+03},
 {     988, .8309452148438E+04, -.1197962036133E+04, .9762120361328E+03},
 {     989, .8317806640625E+04, -.1209392089844E+04, .9669058837891E+03},
 {     990, .8307374023438E+04, -.1197962036133E+04, .9715754394531E+03},
 {     991, .8338023437500E+04, -.1248762084961E+04, .1052473632812E+04},
 {     992, .8338023437500E+04, -.1243682006836E+04, .1052473632812E+04},
 {     993, .8335948242188E+04, -.1248762084961E+04, .1047837280273E+04},
 {     994, .8335948242188E+04, -.1243682006836E+04, .1047837280273E+04},
 {     995, .8320379882812E+04, -.1248762084961E+04, .1013062622070E+04},
 {     996, .8320379882812E+04, -.1243682006836E+04, .1013062622070E+04},
 {     997, .8304811523438E+04, -.1248762084961E+04, .9782882080078E+03},
 {     998, .8304811523438E+04, -.1243682006836E+04, .9782882080078E+03},
 {     999, .8302738281250E+04, -.1248762084961E+04, .9736513061523E+03},
 {    1000, .8302738281250E+04, -.1243682006836E+04, .9736513061523E+03},
 {    1001, .8338023437500E+04, -.1228442016602E+04, .1052473632812E+04},
 {    1002, .8338023437500E+04, -.1213202026367E+04, .1052473632812E+04},
 {    1003, .8335948242188E+04, -.1228442016602E+04, .1047837280273E+04},
 {    1004, .8335948242188E+04, -.1213202026367E+04, .1047837280273E+04},
 {    1005, .8325017578125E+04, -.1228442016602E+04, .1010986938477E+04},
 {    1006, .8320379882812E+04, -.1228442016602E+04, .1013062622070E+04},
 {    1007, .8325017578125E+04, -.1213202026367E+04, .1010986938477E+04},
 {    1008, .8320379882812E+04, -.1213202026367E+04, .1013062622070E+04},
 {    1009, .8304811523438E+04, -.1228442016602E+04, .9782882080078E+03},
 {    1010, .8304811523438E+04, -.1213202026367E+04, .9782882080078E+03},
 {    1011, .8302738281250E+04, -.1228442016602E+04, .9736513061523E+03},
 {    1012, .8302738281250E+04, -.1213202026367E+04, .9736513061523E+03},
 {    1013, .8338023437500E+04, -.1197962036133E+04, .1052473632812E+04},
 {    1014, .8335948242188E+04, -.1197962036133E+04, .1047837280273E+04},
 {    1015, .8325017578125E+04, -.1197962036133E+04, .1010986938477E+04},
 {    1016, .8320379882812E+04, -.1197962036133E+04, .1013062622070E+04},
 {    1017, .8304811523438E+04, -.1197962036133E+04, .9782882080078E+03},
 {    1018, .8302738281250E+04, -.1197962036133E+04, .9736513061523E+03},
 {    1019, .8326053710938E+04, -.1213202026367E+04, .1013305480957E+04},
 {    1020, .8328127929688E+04, -.1213202026367E+04, .1017941894531E+04},
 {    1021, .8325664062500E+04, -.1211216186523E+04, .1012432006836E+04},
 {    1022, .8326958984375E+04, -.1207244506836E+04, .1015323242188E+04},
 {    1023, .8324786132812E+04, -.1210725708008E+04, .1010471191406E+04},
 {    1024, .8324324218750E+04, -.1205773071289E+04, .1009438903809E+04},
 {    1025, .8324083007812E+04, -.1212099975586E+04, .1008897949219E+04},
 {    1026, .8322211914062E+04, -.1209895874023E+04, .1004720581055E+04},
 {    1027, .8324083007812E+04, -.1214304077148E+04, .1008897949219E+04},
 {    1028, .8322211914062E+04, -.1216508300781E+04, .1004720581055E+04},
 {    1029, .8324786132812E+04, -.1215678344727E+04, .1010471191406E+04},
 {    1030, .8324324218750E+04, -.1220630981445E+04, .1009438903809E+04},
 {    1031, .8325664062500E+04, -.1215187866211E+04, .1012432006836E+04},
 {    1032, .8326958984375E+04, -.1219159545898E+04, .1015323242188E+04},
 {    1033, .8321416992188E+04, -.1213202026367E+04, .1015381103516E+04},
 {    1034, .8323493164062E+04, -.1213202026367E+04, .1020017456055E+04},
 {    1035, .8321026367188E+04, -.1211216186523E+04, .1014508178711E+04},
 {    1036, .8322321289062E+04, -.1207244506836E+04, .1017398864746E+04},
 {    1037, .8320150390625E+04, -.1210725708008E+04, .1012546752930E+04},
 {    1038, .8319685546875E+04, -.1205773071289E+04, .1011514892578E+04},
 {    1039, .8319444335938E+04, -.1212099975586E+04, .1010974121094E+04},
 {    1040, .8317574218750E+04, -.1209895874023E+04, .1006796630859E+04},
 {    1041, .8319444335938E+04, -.1214304077148E+04, .1010974121094E+04},
 {    1042, .8317574218750E+04, -.1216508300781E+04, .1006796630859E+04},
 {    1043, .8320150390625E+04, -.1215678344727E+04, .1012546752930E+04},
 {    1044, .8319685546875E+04, -.1220630981445E+04, .1011514892578E+04},
 {    1045, .8321026367188E+04, -.1215187866211E+04, .1014508178711E+04},
 {    1046, .8322321289062E+04, -.1219159545898E+04, .1017398864746E+04},
 {    1047, .8319098632812E+04, -.1213202026367E+04, .1016419250488E+04},
 {    1048, .8321175781250E+04, -.1213202026367E+04, .1021055053711E+04},
 {    1049, .8318708007812E+04, -.1211216186523E+04, .1015545959473E+04},
 {    1050, .8320002929688E+04, -.1207244506836E+04, .1018436767578E+04},
 {    1051, .8317830078125E+04, -.1210725708008E+04, .1013584838867E+04},
 {    1052, .8317369140625E+04, -.1205773071289E+04, .1012552368164E+04},
 {    1053, .8317125000000E+04, -.1212099975586E+04, .1012011840820E+04},
 {    1054, .8315255859375E+04, -.1209895874023E+04, .1007834228516E+04},
 {    1055, .8317125000000E+04, -.1214304077148E+04, .1012011840820E+04},
 {    1056, .8315255859375E+04, -.1216508300781E+04, .1007834228516E+04},
 {    1057, .8317830078125E+04, -.1215678344727E+04, .1013584838867E+04},
 {    1058, .8317369140625E+04, -.1220630981445E+04, .1012552368164E+04},
 {    1059, .8318708007812E+04, -.1215187866211E+04, .1015545959473E+04},
 {    1060, .8320002929688E+04, -.1219159545898E+04, .1018437011719E+04},
 {    1061, .8314462890625E+04, -.1213202026367E+04, .1018493774414E+04},
 {    1062, .8316538085938E+04, -.1213202026367E+04, .1023131286621E+04},
 {    1063, .8314072265625E+04, -.1211216186523E+04, .1017621398926E+04},
 {    1064, .8315366210938E+04, -.1207244506836E+04, .1020512695312E+04},
 {    1065, .8313195312500E+04, -.1210725708008E+04, .1015660217285E+04},
 {    1066, .8312730468750E+04, -.1205773071289E+04, .1014628417969E+04},
 {    1067, .8312488281250E+04, -.1212099975586E+04, .1014087524414E+04},
 {    1068, .8310619140625E+04, -.1209895874023E+04, .1009909912109E+04},
 {    1069, .8312488281250E+04, -.1214304077148E+04, .1014087524414E+04},
 {    1070, .8310619140625E+04, -.1216508300781E+04, .1009909912109E+04},
 {    1071, .8313195312500E+04, -.1215678344727E+04, .1015660217285E+04},
 {    1072, .8312730468750E+04, -.1220630981445E+04, .1014628417969E+04},
 {    1073, .8314072265625E+04, -.1215187866211E+04, .1017621398926E+04},
 {    1074, .8315366210938E+04, -.1219159545898E+04, .1020512695312E+04},
 {    1075, .8330514648438E+04, -.1238602050781E+04, .1041920043945E+04},
 {    1076, .8325879882812E+04, -.1238602050781E+04, .1043995605469E+04},
 {    1077, .8330514648438E+04, -.1225902099609E+04, .1041920043945E+04},
 {    1078, .8325879882812E+04, -.1225902099609E+04, .1043995605469E+04},
 {    1079, .8330514648438E+04, -.1213202026367E+04, .1041920043945E+04},
 {    1080, .8325879882812E+04, -.1213202026367E+04, .1043995605469E+04},
 {    1081, .8328440429688E+04, -.1238602050781E+04, .1037283203125E+04},
 {    1082, .8323803710938E+04, -.1238602050781E+04, .1039358886719E+04},
 {    1083, .8328440429688E+04, -.1225902099609E+04, .1037283203125E+04},
 {    1084, .8323803710938E+04, -.1225902099609E+04, .1039358886719E+04},
 {    1085, .8328440429688E+04, -.1213202026367E+04, .1037283203125E+04},
 {    1086, .8323803710938E+04, -.1213202026367E+04, .1039358886719E+04},
 {    1087, .8318061523438E+04, -.1238602050781E+04, .1014100219727E+04},
 {    1088, .8313423828125E+04, -.1238602050781E+04, .1016175903320E+04},
 {    1089, .8318061523438E+04, -.1225902099609E+04, .1014100219727E+04},
 {    1090, .8313423828125E+04, -.1225902099609E+04, .1016175903320E+04},
 {    1091, .8318061523438E+04, -.1213202026367E+04, .1014100219727E+04},
 {    1092, .8313423828125E+04, -.1213202026367E+04, .1016175903320E+04},
 {    1093, .8307683593750E+04, -.1238602050781E+04, .9909177246094E+03},
 {    1094, .8303047851562E+04, -.1238602050781E+04, .9929933471680E+03},
 {    1095, .8307683593750E+04, -.1225902099609E+04, .9909177246094E+03},
 {    1096, .8303047851562E+04, -.1225902099609E+04, .9929933471680E+03},
 {    1097, .8307683593750E+04, -.1213202026367E+04, .9909177246094E+03},
 {    1098, .8303047851562E+04, -.1213202026367E+04, .9929933471680E+03},
 {    1099, .8305609375000E+04, -.1238602050781E+04, .9862807617188E+03},
 {    1100, .8300971679688E+04, -.1238602050781E+04, .9883564453125E+03},
 {    1101, .8305609375000E+04, -.1225902099609E+04, .9862807617188E+03},
 {    1102, .8300971679688E+04, -.1225902099609E+04, .9883564453125E+03},
 {    1103, .8305609375000E+04, -.1213202026367E+04, .9862807617188E+03},
 {    1104, .8300971679688E+04, -.1213202026367E+04, .9883564453125E+03},
 {    1105, .8330514648438E+04, -.1200502075195E+04, .1041920043945E+04},
 {    1106, .8325879882812E+04, -.1200502075195E+04, .1043995605469E+04},
 {    1107, .8328440429688E+04, -.1200502075195E+04, .1037283203125E+04},
 {    1108, .8323803710938E+04, -.1200502075195E+04, .1039358886719E+04},
 {    1109, .8318061523438E+04, -.1200502075195E+04, .1014100219727E+04},
 {    1110, .8313423828125E+04, -.1200502075195E+04, .1016175903320E+04},
 {    1111, .8307683593750E+04, -.1200502075195E+04, .9909177246094E+03},
 {    1112, .8303047851562E+04, -.1200502075195E+04, .9929933471680E+03},
 {    1113, .8305609375000E+04, -.1200502075195E+04, .9862807617188E+03},
 {    1114, .8300971679688E+04, -.1200502075195E+04, .9883564453125E+03},
 {    1115, .8330514648438E+04, -.1187802001953E+04, .1041920043945E+04},
 {    1116, .8325879882812E+04, -.1187802001953E+04, .1043995605469E+04},
 {    1117, .8328440429688E+04, -.1187802001953E+04, .1037283203125E+04},
 {    1118, .8323803710938E+04, -.1187802001953E+04, .1039358886719E+04},
 {    1119, .8318061523438E+04, -.1187802001953E+04, .1014100219727E+04},
 {    1120, .8313423828125E+04, -.1187802001953E+04, .1016175903320E+04},
 {    1121, .8307683593750E+04, -.1187802001953E+04, .9909177246094E+03},
 {    1122, .8303047851562E+04, -.1187802001953E+04, .9929933471680E+03},
 {    1123, .8305609375000E+04, -.1187802001953E+04, .9862807617188E+03},
 {    1124, .8300971679688E+04, -.1187802001953E+04, .9883564453125E+03},
 {    1125, .8314288085938E+04, -.1238602050781E+04, .1049184570312E+04},
 {    1126, .8302695312500E+04, -.1238602050781E+04, .1054373779297E+04},
 {    1127, .8314288085938E+04, -.1225902099609E+04, .1049184570312E+04},
 {    1128, .8302695312500E+04, -.1225902099609E+04, .1054373779297E+04},
 {    1129, .8314288085938E+04, -.1213202026367E+04, .1049184570312E+04},
 {    1130, .8302695312500E+04, -.1213202026367E+04, .1054373779297E+04},
 {    1131, .8312212890625E+04, -.1238602050781E+04, .1044547851562E+04},
 {    1132, .8300619140625E+04, -.1238602050781E+04, .1049737304688E+04},
 {    1133, .8312212890625E+04, -.1225902099609E+04, .1044547851562E+04},
 {    1134, .8300619140625E+04, -.1225902099609E+04, .1049737304688E+04},
 {    1135, .8312212890625E+04, -.1213202026367E+04, .1044547851562E+04},
 {    1136, .8300619140625E+04, -.1213202026367E+04, .1049737304688E+04},
 {    1137, .8291455078125E+04, -.1238602050781E+04, .9981821289062E+03},
 {    1138, .8279864257812E+04, -.1238602050781E+04, .1003370788574E+04},
 {    1139, .8291455078125E+04, -.1225902099609E+04, .9981821289062E+03},
 {    1140, .8279864257812E+04, -.1225902099609E+04, .1003370788574E+04},
 {    1141, .8291455078125E+04, -.1213202026367E+04, .9981821289062E+03},
 {    1142, .8279864257812E+04, -.1213202026367E+04, .1003370788574E+04},
 {    1143, .8289379882812E+04, -.1238602050781E+04, .9935454711914E+03},
 {    1144, .8277790039062E+04, -.1238602050781E+04, .9987342529297E+03},
 {    1145, .8289379882812E+04, -.1225902099609E+04, .9935454711914E+03},
 {    1146, .8277790039062E+04, -.1225902099609E+04, .9987342529297E+03},
 {    1147, .8289379882812E+04, -.1213202026367E+04, .9935454711914E+03},
 {    1148, .8277790039062E+04, -.1213202026367E+04, .9987342529297E+03},
 {    1149, .8314288085938E+04, -.1200502075195E+04, .1049184570312E+04},
 {    1150, .8302695312500E+04, -.1200502075195E+04, .1054373779297E+04},
 {    1151, .8312212890625E+04, -.1200502075195E+04, .1044547851562E+04},
 {    1152, .8300619140625E+04, -.1200502075195E+04, .1049737304688E+04},
 {    1153, .8291455078125E+04, -.1200502075195E+04, .9981821289062E+03},
 {    1154, .8279864257812E+04, -.1200502075195E+04, .1003370788574E+04},
 {    1155, .8289379882812E+04, -.1200502075195E+04, .9935454711914E+03},
 {    1156, .8277790039062E+04, -.1200502075195E+04, .9987342529297E+03},
 {    1157, .8314288085938E+04, -.1187802001953E+04, .1049184570312E+04},
 {    1158, .8302695312500E+04, -.1187802001953E+04, .1054373779297E+04},
 {    1159, .8312212890625E+04, -.1187802001953E+04, .1044547851562E+04},
 {    1160, .8300619140625E+04, -.1187802001953E+04, .1049737304688E+04},
 {    1161, .8291455078125E+04, -.1187802001953E+04, .9981821289062E+03},
 {    1162, .8279864257812E+04, -.1187802001953E+04, .1003370788574E+04},
 {    1163, .8289379882812E+04, -.1187802001953E+04, .9935454711914E+03},
 {    1164, .8277790039062E+04, -.1187802001953E+04, .9987342529297E+03},
 {    1165, .8291105468750E+04, -.1238602050781E+04, .1059562866211E+04},
 {    1166, .8291105468750E+04, -.1225902099609E+04, .1059562866211E+04},
 {    1167, .8291105468750E+04, -.1213202026367E+04, .1059562866211E+04},
 {    1168, .8289028320312E+04, -.1238602050781E+04, .1054926269531E+04},
 {    1169, .8289028320312E+04, -.1225902099609E+04, .1054926269531E+04},
 {    1170, .8289028320312E+04, -.1213202026367E+04, .1054926269531E+04},
 {    1171, .8268272460938E+04, -.1238602050781E+04, .1008559814453E+04},
 {    1172, .8268272460938E+04, -.1225902099609E+04, .1008559814453E+04},
 {    1173, .8268272460938E+04, -.1213202026367E+04, .1008559814453E+04},
 {    1174, .8266196289062E+04, -.1238602050781E+04, .1003923828125E+04},
 {    1175, .8266196289062E+04, -.1225902099609E+04, .1003923828125E+04},
 {    1176, .8266196289062E+04, -.1213202026367E+04, .1003923828125E+04},
 {    1177, .8291105468750E+04, -.1200502075195E+04, .1059562866211E+04},
 {    1178, .8289028320312E+04, -.1200502075195E+04, .1054926269531E+04},
 {    1179, .8268272460938E+04, -.1200502075195E+04, .1008559814453E+04},
 {    1180, .8266196289062E+04, -.1200502075195E+04, .1003923828125E+04},
 {    1181, .8291105468750E+04, -.1187802001953E+04, .1059562866211E+04},
 {    1182, .8289028320312E+04, -.1187802001953E+04, .1054926269531E+04},
 {    1183, .8268272460938E+04, -.1187802001953E+04, .1008559814453E+04},
 {    1184, .8266196289062E+04, -.1187802001953E+04, .1003923828125E+04},
 {    1185, .8395313476562E+04, -.1322421997070E+04, .1042133056641E+04},
 {    1186, .8372129882812E+04, -.1322421997070E+04, .1052511230469E+04},
 {    1187, .8348947265625E+04, -.1322421997070E+04, .1062889038086E+04},
 {    1188, .8395313476562E+04, -.1331947021484E+04, .1042133056641E+04},
 {    1189, .8372129882812E+04, -.1331947021484E+04, .1052511230469E+04},
 {    1190, .8348947265625E+04, -.1331947021484E+04, .1062889038086E+04},
 {    1191, .8383637695312E+04, -.1322421997070E+04, .1016052368164E+04},
 {    1192, .8360456054688E+04, -.1322421997070E+04, .1026430297852E+04},
 {    1193, .8337271484375E+04, -.1322421997070E+04, .1036808105469E+04},
 {    1194, .8383637695312E+04, -.1331947021484E+04, .1016052368164E+04},
 {    1195, .8360456054688E+04, -.1331947021484E+04, .1026430297852E+04},
 {    1196, .8337271484375E+04, -.1331947021484E+04, .1036808105469E+04},
 {    1197, .8371962890625E+04, -.1322421997070E+04, .9899710693359E+03},
 {    1198, .8348777343750E+04, -.1322421997070E+04, .1000349548340E+04},
 {    1199, .8325596679688E+04, -.1322421997070E+04, .1010727416992E+04},
 {    1200, .8371962890625E+04, -.1331947021484E+04, .9899710693359E+03},
 {    1201, .8348777343750E+04, -.1331947021484E+04, .1000349548340E+04},
 {    1202, .8325596679688E+04, -.1331947021484E+04, .1010727416992E+04},
 {    1203, .8360286132812E+04, -.1322421997070E+04, .9638902587891E+03},
 {    1204, .8337104492188E+04, -.1322421997070E+04, .9742684326172E+03},
 {    1205, .8313920898438E+04, -.1322421997070E+04, .9846463623047E+03},
 {    1206, .8360286132812E+04, -.1331947021484E+04, .9638902587891E+03},
 {    1207, .8337104492188E+04, -.1331947021484E+04, .9742684326172E+03},
 {    1208, .8313920898438E+04, -.1331947021484E+04, .9846463623047E+03},
 {    1209, .8348611328125E+04, -.1322421997070E+04, .9378092651367E+03},
 {    1210, .8325427734375E+04, -.1322421997070E+04, .9481873168945E+03},
 {    1211, .8302246093750E+04, -.1322421997070E+04, .9585657348633E+03},
 {    1212, .8348611328125E+04, -.1331947021484E+04, .9378092651367E+03},
 {    1213, .8325427734375E+04, -.1331947021484E+04, .9481873168945E+03},
 {    1214, .8302246093750E+04, -.1331947021484E+04, .9585657348633E+03},
 {    1215, .8316424804688E+04, -.1285592041016E+04, .9327375488281E+03},
 {    1216, .8303964843750E+04, -.1285592041016E+04, .9383157958984E+03},
 {    1217, .8291503906250E+04, -.1285592041016E+04, .9438941040039E+03},
 {    1218, .8317589843750E+04, -.1280829589844E+04, .9322163085938E+03},
 {    1219, .8306798828125E+04, -.1274003295898E+04, .9370472412109E+03},
 {    1220, .8296005859375E+04, -.1267177001953E+04, .9418781127930E+03},
 {    1221, .8320771484375E+04, -.1277343139648E+04, .9307918701172E+03},
 {    1222, .8314541992188E+04, -.1265519775391E+04, .9335808105469E+03},
 {    1223, .8308311523438E+04, -.1253696289062E+04, .9363698730469E+03},
 {    1224, .8325119140625E+04, -.1276067016602E+04, .9288457031250E+03},
 {    1225, .8325119140625E+04, -.1262414550781E+04, .9288457031250E+03},
 {    1226, .8325119140625E+04, -.1248762084961E+04, .9288457031250E+03},
 {    1227, .8329465820312E+04, -.1277343139648E+04, .9268997802734E+03},
 {    1228, .8335697265625E+04, -.1265519775391E+04, .9241107177734E+03},
 {    1229, .8341927734375E+04, -.1253696289062E+04, .9213214721680E+03},
 {    1230, .8332648437500E+04, -.1280829589844E+04, .9254752197266E+03},
 {    1231, .8343438476562E+04, -.1274003295898E+04, .9206443481445E+03},
 {    1232, .8354230468750E+04, -.1267177001953E+04, .9158136596680E+03},
 {    1233, .8333813476562E+04, -.1285592041016E+04, .9249539794922E+03},
 {    1234, .8346272460938E+04, -.1285592041016E+04, .9193757324219E+03},
 {    1235, .8358735351562E+04, -.1285592041016E+04, .9137974853516E+03},
 {    1236, .8332648437500E+04, -.1290354492188E+04, .9254752197266E+03},
 {    1237, .8343438476562E+04, -.1297180786133E+04, .9206443481445E+03},
 {    1238, .8354230468750E+04, -.1304007080078E+04, .9158136596680E+03},
 {    1239, .8329465820312E+04, -.1293840942383E+04, .9268997802734E+03},
 {    1240, .8335697265625E+04, -.1305664306641E+04, .9241107177734E+03},
 {    1241, .8341927734375E+04, -.1317487792969E+04, .9213214721680E+03},
 {    1242, .8325119140625E+04, -.1295117065430E+04, .9288457031250E+03},
 {    1243, .8325119140625E+04, -.1308769531250E+04, .9288457031250E+03},
 {    1244, .8325119140625E+04, -.1322421997070E+04, .9288457031250E+03},
 {    1245, .8320771484375E+04, -.1293840942383E+04, .9307918701172E+03},
 {    1246, .8314541992188E+04, -.1305664306641E+04, .9335808105469E+03},
 {    1247, .8308311523438E+04, -.1317487792969E+04, .9363698730469E+03},
 {    1248, .8317589843750E+04, -.1290354492188E+04, .9322163085938E+03},
 {    1249, .8306798828125E+04, -.1297180786133E+04, .9370472412109E+03},
 {    1250, .8296005859375E+04, -.1304007080078E+04, .9418781127930E+03},
 {    1251, .8314349609375E+04, -.1285592041016E+04, .9281008300781E+03},
 {    1252, .8301887695312E+04, -.1285592041016E+04, .9336794433594E+03},
 {    1253, .8289425781250E+04, -.1285592041016E+04, .9392575683594E+03},
 {    1254, .8315515625000E+04, -.1280829589844E+04, .9275798339844E+03},
 {    1255, .8304723632812E+04, -.1274003295898E+04, .9324104003906E+03},
 {    1256, .8293932617188E+04, -.1267177001953E+04, .9372412719727E+03},
 {    1257, .8318698242188E+04, -.1277343139648E+04, .9261550292969E+03},
 {    1258, .8312467773438E+04, -.1265519775391E+04, .9289443359375E+03},
 {    1259, .8306236328125E+04, -.1253696289062E+04, .9317331542969E+03},
 {    1260, .8323044921875E+04, -.1276067016602E+04, .9242091064453E+03},
 {    1261, .8323044921875E+04, -.1262414550781E+04, .9242091064453E+03},
 {    1262, .8323044921875E+04, -.1248762084961E+04, .9242091064453E+03},
 {    1263, .8327389648438E+04, -.1277343139648E+04, .9222633056641E+03},
 {    1264, .8333620117188E+04, -.1265519775391E+04, .9194742431641E+03},
 {    1265, .8339851562500E+04, -.1253696289062E+04, .9166852416992E+03},
 {    1266, .8330573242188E+04, -.1280829589844E+04, .9208387451172E+03},
 {    1267, .8341364257812E+04, -.1274003295898E+04, .9160078125000E+03},
 {    1268, .8352155273438E+04, -.1267177001953E+04, .9111768188477E+03},
 {    1269, .8331736328125E+04, -.1285592041016E+04, .9203173828125E+03},
 {    1270, .8344197265625E+04, -.1285592041016E+04, .9147390747070E+03},
 {    1271, .8356658203125E+04, -.1285592041016E+04, .9091607055664E+03},
 {    1272, .8330573242188E+04, -.1290354492188E+04, .9208387451172E+03},
 {    1273, .8341364257812E+04, -.1297180786133E+04, .9160078125000E+03},
 {    1274, .8352155273438E+04, -.1304007080078E+04, .9111768188477E+03},
 {    1275, .8327389648438E+04, -.1293840942383E+04, .9222633056641E+03},
 {    1276, .8333620117188E+04, -.1305664306641E+04, .9194742431641E+03},
 {    1277, .8339851562500E+04, -.1317487792969E+04, .9166852416992E+03},
 {    1278, .8323044921875E+04, -.1295117065430E+04, .9242091064453E+03},
 {    1279, .8323044921875E+04, -.1308769531250E+04, .9242091064453E+03},
 {    1280, .8323044921875E+04, -.1322421997070E+04, .9242091064453E+03},
 {    1281, .8318698242188E+04, -.1293840942383E+04, .9261550292969E+03},
 {    1282, .8312467773438E+04, -.1305664306641E+04, .9289443359375E+03},
 {    1283, .8306236328125E+04, -.1317487792969E+04, .9317331542969E+03},
 {    1284, .8315515625000E+04, -.1290354492188E+04, .9275798339844E+03},
 {    1285, .8304723632812E+04, -.1297180786133E+04, .9324104003906E+03},
 {    1286, .8293932617188E+04, -.1304007080078E+04, .9372412719727E+03},
 {    1287, .8302931640625E+04, -.1285592041016E+04, .9025998535156E+03},
 {    1288, .8290471679688E+04, -.1285592041016E+04, .9081780395508E+03},
 {    1289, .8278011718750E+04, -.1285592041016E+04, .9137561645508E+03},
 {    1290, .8304096679688E+04, -.1280829589844E+04, .9020783691406E+03},
 {    1291, .8293306640625E+04, -.1274003295898E+04, .9069093017578E+03},
 {    1292, .8282514648438E+04, -.1267177001953E+04, .9117402343750E+03},
 {    1293, .8307281250000E+04, -.1277343139648E+04, .9006535644531E+03},
 {    1294, .8301050781250E+04, -.1265519775391E+04, .9034426269531E+03},
 {    1295, .8294818359375E+04, -.1253696289062E+04, .9062321777344E+03},
 {    1296, .8311625976562E+04, -.1276067016602E+04, .8987078857422E+03},
 {    1297, .8311625976562E+04, -.1262414550781E+04, .8987078857422E+03},
 {    1298, .8311625976562E+04, -.1248762084961E+04, .8987078857422E+03},
 {    1299, .8315971679688E+04, -.1277343139648E+04, .8967618408203E+03},
 {    1300, .8322202148438E+04, -.1265519775391E+04, .8939728393555E+03},
 {    1301, .8328432617188E+04, -.1253696289062E+04, .8911837158203E+03},
 {    1302, .8319153320312E+04, -.1280829589844E+04, .8953376464844E+03},
 {    1303, .8329945312500E+04, -.1274003295898E+04, .8905066528320E+03},
 {    1304, .8340739257812E+04, -.1267177001953E+04, .8856756591797E+03},
 {    1305, .8320319335938E+04, -.1285592041016E+04, .8948159790039E+03},
 {    1306, .8332782226562E+04, -.1285592041016E+04, .8892377929688E+03},
 {    1307, .8345244140625E+04, -.1285592041016E+04, .8836594238281E+03},
 {    1308, .8319153320312E+04, -.1290354492188E+04, .8953376464844E+03},
 {    1309, .8329945312500E+04, -.1297180786133E+04, .8905066528320E+03},
 {    1310, .8340739257812E+04, -.1304007080078E+04, .8856757812500E+03},
 {    1311, .8315971679688E+04, -.1293840942383E+04, .8967618408203E+03},
 {    1312, .8322202148438E+04, -.1305664306641E+04, .8939728393555E+03},
 {    1313, .8328432617188E+04, -.1317487792969E+04, .8911837158203E+03},
 {    1314, .8311625976562E+04, -.1295117065430E+04, .8987078857422E+03},
 {    1315, .8311625976562E+04, -.1308769531250E+04, .8987078857422E+03},
 {    1316, .8311625976562E+04, -.1322421997070E+04, .8987078857422E+03},
 {    1317, .8307281250000E+04, -.1293840942383E+04, .9006535644531E+03},
 {    1318, .8301050781250E+04, -.1305664306641E+04, .9034426269531E+03},
 {    1319, .8294818359375E+04, -.1317487792969E+04, .9062321777344E+03},
 {    1320, .8304096679688E+04, -.1290354492188E+04, .9020783691406E+03},
 {    1321, .8293306640625E+04, -.1297180786133E+04, .9069093017578E+03},
 {    1322, .8282514648438E+04, -.1304007080078E+04, .9117402343750E+03},
 {    1323, .8300858398438E+04, -.1285592041016E+04, .8979628906250E+03},
 {    1324, .8288397460938E+04, -.1285592041016E+04, .9035413208008E+03},
 {    1325, .8275935546875E+04, -.1285592041016E+04, .9091195678711E+03},
 {    1326, .8302022460938E+04, -.1280829589844E+04, .8974417724609E+03},
 {    1327, .8291231445312E+04, -.1274003295898E+04, .9022724609375E+03},
 {    1328, .8280438476562E+04, -.1267177001953E+04, .9071033935547E+03},
 {    1329, .8305205078125E+04, -.1277343139648E+04, .8960172119141E+03},
 {    1330, .8298973632812E+04, -.1265519775391E+04, .8988064575195E+03},
 {    1331, .8292743164062E+04, -.1253696289062E+04, .9015954589844E+03},
 {    1332, .8309549804688E+04, -.1276067016602E+04, .8940714111328E+03},
 {    1333, .8309549804688E+04, -.1262414550781E+04, .8940714111328E+03},
 {    1334, .8309549804688E+04, -.1248762084961E+04, .8940714111328E+03},
 {    1335, .8313899414062E+04, -.1277343139648E+04, .8921250610352E+03},
 {    1336, .8320127929688E+04, -.1265519775391E+04, .8893361816406E+03},
 {    1337, .8326359375000E+04, -.1253696289062E+04, .8865470581055E+03},
 {    1338, .8317080078125E+04, -.1280829589844E+04, .8907007446289E+03},
 {    1339, .8327872070312E+04, -.1274003295898E+04, .8858696899414E+03},
 {    1340, .8338664062500E+04, -.1267177001953E+04, .8810389404297E+03},
 {    1341, .8318246093750E+04, -.1285592041016E+04, .8901795043945E+03},
 {    1342, .8330706054688E+04, -.1285592041016E+04, .8846011962891E+03},
 {    1343, .8343166015625E+04, -.1285592041016E+04, .8790230712891E+03},
 {    1344, .8317080078125E+04, -.1290354492188E+04, .8907007446289E+03},
 {    1345, .8327872070312E+04, -.1297180786133E+04, .8858696899414E+03},
 {    1346, .8338664062500E+04, -.1304007080078E+04, .8810389404297E+03},
 {    1347, .8313899414062E+04, -.1293840942383E+04, .8921250610352E+03},
 {    1348, .8320127929688E+04, -.1305664306641E+04, .8893361816406E+03},
 {    1349, .8326359375000E+04, -.1317487792969E+04, .8865470581055E+03},
 {    1350, .8309549804688E+04, -.1295117065430E+04, .8940714111328E+03},
 {    1351, .8309549804688E+04, -.1308769531250E+04, .8940714111328E+03},
 {    1352, .8309549804688E+04, -.1322421997070E+04, .8940714111328E+03},
 {    1353, .8305205078125E+04, -.1293840942383E+04, .8960172119141E+03},
 {    1354, .8298973632812E+04, -.1305664306641E+04, .8988064575195E+03},
 {    1355, .8292743164062E+04, -.1317487792969E+04, .9015954589844E+03},
 {    1356, .8302022460938E+04, -.1290354492188E+04, .8974417724609E+03},
 {    1357, .8291231445312E+04, -.1297180786133E+04, .9022724609375E+03},
 {    1358, .8280438476562E+04, -.1304007080078E+04, .9071033935547E+03},
 {    1359, .8289183593750E+04, -.1285592041016E+04, .9449321289062E+03},
 {    1360, .8294000000000E+04, -.1265907104492E+04, .9427765502930E+03},
 {    1361, .8307153320312E+04, -.1251496582031E+04, .9368885498047E+03},
 {    1362, .8325119140625E+04, -.1246222045898E+04, .9288457031250E+03},
 {    1363, .8343084960938E+04, -.1251496582031E+04, .9208028564453E+03},
 {    1364, .8356238281250E+04, -.1265907104492E+04, .9149147338867E+03},
 {    1365, .8361052734375E+04, -.1285592041016E+04, .9127595214844E+03},
 {    1366, .8356238281250E+04, -.1305277099609E+04, .9149147338867E+03},
 {    1367, .8343084960938E+04, -.1319687500000E+04, .9208028564453E+03},
 {    1368, .8325119140625E+04, -.1324962036133E+04, .9288457031250E+03},
 {    1369, .8307153320312E+04, -.1319687500000E+04, .9368885498047E+03},
 {    1370, .8294000000000E+04, -.1305277099609E+04, .9427765502930E+03},
 {    1371, .8287109375000E+04, -.1285592041016E+04, .9402951049805E+03},
 {    1372, .8291923828125E+04, -.1265907104492E+04, .9381401977539E+03},
 {    1373, .8305075195312E+04, -.1251496582031E+04, .9322524414062E+03},
 {    1374, .8323044921875E+04, -.1246222045898E+04, .9242091064453E+03},
 {    1375, .8341009765625E+04, -.1251496582031E+04, .9161661987305E+03},
 {    1376, .8354164062500E+04, -.1265907104492E+04, .9102781982422E+03},
 {    1377, .8358976562500E+04, -.1285592041016E+04, .9081231079102E+03},
 {    1378, .8354164062500E+04, -.1305277099609E+04, .9102781982422E+03},
 {    1379, .8341009765625E+04, -.1319687500000E+04, .9161661987305E+03},
 {    1380, .8323044921875E+04, -.1324962036133E+04, .9242091064453E+03},
 {    1381, .8305076171875E+04, -.1319687500000E+04, .9322521972656E+03},
 {    1382, .8291923828125E+04, -.1305277099609E+04, .9381401977539E+03},
 {    1383, .8275694335938E+04, -.1285592041016E+04, .9147940063477E+03},
 {    1384, .8280505859375E+04, -.1265907104492E+04, .9126388549805E+03},
 {    1385, .8293659179688E+04, -.1251496582031E+04, .9067509765625E+03},
 {    1386, .8311625976562E+04, -.1246222045898E+04, .8987078857422E+03},
 {    1387, .8329594726562E+04, -.1251496582031E+04, .8906648559570E+03},
 {    1388, .8342746093750E+04, -.1265907104492E+04, .8847769775391E+03},
 {    1389, .8347560546875E+04, -.1285592041016E+04, .8826217041016E+03},
 {    1390, .8342746093750E+04, -.1305277099609E+04, .8847769775391E+03},
 {    1391, .8329594726562E+04, -.1319687500000E+04, .8906648559570E+03},
 {    1392, .8311625976562E+04, -.1324962036133E+04, .8987078857422E+03},
 {    1393, .8293659179688E+04, -.1319687500000E+04, .9067510986328E+03},
 {    1394, .8280505859375E+04, -.1305277099609E+04, .9126388549805E+03},
 {    1395, .8273618164062E+04, -.1285592041016E+04, .9101577758789E+03},
 {    1396, .8278432617188E+04, -.1265907104492E+04, .9080020751953E+03},
 {    1397, .8291584960938E+04, -.1251496582031E+04, .9021141357422E+03},
 {    1398, .8309549804688E+04, -.1246222045898E+04, .8940714111328E+03},
 {    1399, .8327519531250E+04, -.1251496582031E+04, .8860280761719E+03},
 {    1400, .8340671875000E+04, -.1265907104492E+04, .8801399536133E+03},
 {    1401, .8345485351562E+04, -.1285592041016E+04, .8779854125977E+03},
 {    1402, .8340671875000E+04, -.1305277099609E+04, .8801399536133E+03},
 {    1403, .8327519531250E+04, -.1319687500000E+04, .8860280761719E+03},
 {    1404, .8309549804688E+04, -.1324962036133E+04, .8940714111328E+03},
 {    1405, .8291584960938E+04, -.1319687500000E+04, .9021141357422E+03},
 {    1406, .8278432617188E+04, -.1305277099609E+04, .9080020751953E+03},
 {    1407, .8424918945312E+04, -.1336392089844E+04, .1132043945312E+04},
 {    1408, .8400327148438E+04, -.1336392089844E+04, .1138474121094E+04},
 {    1409, .8375732421875E+04, -.1336392089844E+04, .1144905151367E+04},
 {    1410, .8449513671875E+04, -.1323692016602E+04, .1125612792969E+04},
 {    1411, .8424918945312E+04, -.1323692016602E+04, .1132043945312E+04},
 {    1412, .8400327148438E+04, -.1323692016602E+04, .1138474121094E+04},
 {    1413, .8375732421875E+04, -.1323692016602E+04, .1144905151367E+04},
 {    1414, .8451096679688E+04, -.1336392089844E+04, .1131673217773E+04},
 {    1415, .8426840820312E+04, -.1336392089844E+04, .1138015747070E+04},
 {    1416, .8402583984375E+04, -.1336392089844E+04, .1144358398438E+04},
 {    1417, .8378328125000E+04, -.1336392089844E+04, .1150701171875E+04},
 {    1418, .8451096679688E+04, -.1323692016602E+04, .1131673217773E+04},
 {    1419, .8426840820312E+04, -.1323692016602E+04, .1138015747070E+04},
 {    1420, .8402583984375E+04, -.1323692016602E+04, .1144358398438E+04},
 {    1421, .8378328125000E+04, -.1323692016602E+04, .1150701171875E+04},
 {    1422, .8449513671875E+04, -.1317342041016E+04, .1125612792969E+04},
 {    1423, .8424918945312E+04, -.1317342041016E+04, .1132043945312E+04},
 {    1424, .8400327148438E+04, -.1317342041016E+04, .1138474121094E+04},
 {    1425, .8375732421875E+04, -.1317342041016E+04, .1144905151367E+04},
 {    1426, .8451096679688E+04, -.1317342041016E+04, .1131673217773E+04},
 {    1427, .8426840820312E+04, -.1317342041016E+04, .1138015747070E+04},
 {    1428, .8402583984375E+04, -.1317342041016E+04, .1144358398438E+04},
 {    1429, .8378328125000E+04, -.1317342041016E+04, .1150701171875E+04},
 {    1430, .8449513671875E+04, -.1310992065430E+04, .1125612792969E+04},
 {    1431, .8424918945312E+04, -.1310992065430E+04, .1132043945312E+04},
 {    1432, .8400327148438E+04, -.1310992065430E+04, .1138474121094E+04},
 {    1433, .8375732421875E+04, -.1310992065430E+04, .1144905151367E+04},
 {    1434, .8451096679688E+04, -.1310992065430E+04, .1131673217773E+04},
 {    1435, .8426840820312E+04, -.1310992065430E+04, .1138015747070E+04},
 {    1436, .8402583984375E+04, -.1310992065430E+04, .1144358398438E+04},
 {    1437, .8378328125000E+04, -.1310992065430E+04, .1150701171875E+04},
 {    1438, .8453606445312E+04, -.1317342041016E+04, .1141267700195E+04},
 {    1439, .8429772460938E+04, -.1317342041016E+04, .1147500366211E+04},
 {    1440, .8405935546875E+04, -.1317342041016E+04, .1153733276367E+04},
 {    1441, .8382102539062E+04, -.1317342041016E+04, .1159964965820E+04},
 {    1442, .8453606445312E+04, -.1310992065430E+04, .1141267700195E+04},
 {    1443, .8429772460938E+04, -.1310992065430E+04, .1147500366211E+04},
 {    1444, .8405935546875E+04, -.1310992065430E+04, .1153733276367E+04},
 {    1445, .8382102539062E+04, -.1310992065430E+04, .1159964965820E+04},
 {    1446, .8443737304688E+04, -.1317342041016E+04, .1157407470703E+04},
 {    1447, .8425268554688E+04, -.1317342041016E+04, .1163724609375E+04},
 {    1448, .8406796875000E+04, -.1317342041016E+04, .1170040039062E+04},
 {    1449, .8388329101562E+04, -.1317342041016E+04, .1176356689453E+04},
 {    1450, .8443737304688E+04, -.1310992065430E+04, .1157407470703E+04},
 {    1451, .8425268554688E+04, -.1310992065430E+04, .1163724609375E+04},
 {    1452, .8406796875000E+04, -.1310992065430E+04, .1170040039062E+04},
 {    1453, .8388329101562E+04, -.1310992065430E+04, .1176356689453E+04},
 {    1454, .8433868164062E+04, -.1317342041016E+04, .1173547485352E+04},
 {    1455, .8420765625000E+04, -.1317342041016E+04, .1179947509766E+04},
 {    1456, .8407661132812E+04, -.1317342041016E+04, .1186348022461E+04},
 {    1457, .8394555664062E+04, -.1317342041016E+04, .1192748901367E+04},
 {    1458, .8433868164062E+04, -.1310992065430E+04, .1173547485352E+04},
 {    1459, .8420765625000E+04, -.1310992065430E+04, .1179947509766E+04},
 {    1460, .8407661132812E+04, -.1310992065430E+04, .1186348022461E+04},
 {    1461, .8394555664062E+04, -.1310992065430E+04, .1192748901367E+04},
 {    1462, .8423999023438E+04, -.1317342041016E+04, .1189687988281E+04},
 {    1463, .8415592773438E+04, -.1317342041016E+04, .1193002929688E+04},
 {    1464, .8407188476562E+04, -.1317342041016E+04, .1196318725586E+04},
 {    1465, .8398785156250E+04, -.1317342041016E+04, .1199633544922E+04},
 {    1466, .8423999023438E+04, -.1310992065430E+04, .1189687988281E+04},
 {    1467, .8415592773438E+04, -.1310992065430E+04, .1193002929688E+04},
 {    1468, .8407188476562E+04, -.1310992065430E+04, .1196318725586E+04},
 {    1469, .8398785156250E+04, -.1310992065430E+04, .1199633544922E+04},
 {    1470, .8414131835938E+04, -.1317342041016E+04, .1205827880859E+04},
 {    1471, .8410420898438E+04, -.1317342041016E+04, .1206058105469E+04},
 {    1472, .8406715820312E+04, -.1317342041016E+04, .1206288696289E+04},
 {    1473, .8403009765625E+04, -.1317342041016E+04, .1206519165039E+04},
 {    1474, .8414131835938E+04, -.1310992065430E+04, .1205827880859E+04},
 {    1475, .8410420898438E+04, -.1310992065430E+04, .1206058105469E+04},
 {    1476, .8406715820312E+04, -.1310992065430E+04, .1206288696289E+04},
 {    1477, .8403009765625E+04, -.1310992065430E+04, .1206519165039E+04},
 {    1478, .8449513671875E+04, -.1295117065430E+04, .1125612792969E+04},
 {    1479, .8424918945312E+04, -.1295117065430E+04, .1132043945312E+04},
 {    1480, .8400327148438E+04, -.1295117065430E+04, .1138474121094E+04},
 {    1481, .8375732421875E+04, -.1295117065430E+04, .1144905151367E+04},
 {    1482, .8451096679688E+04, -.1295117065430E+04, .1131673217773E+04},
 {    1483, .8426840820312E+04, -.1295117065430E+04, .1138015747070E+04},
 {    1484, .8402583984375E+04, -.1295117065430E+04, .1144358398438E+04},
 {    1485, .8378328125000E+04, -.1295117065430E+04, .1150701171875E+04},
 {    1486, .8449513671875E+04, -.1276067016602E+04, .1125612792969E+04},
 {    1487, .8424918945312E+04, -.1276067016602E+04, .1132043945312E+04},
 {    1488, .8400327148438E+04, -.1276067016602E+04, .1138474121094E+04},
 {    1489, .8375732421875E+04, -.1276067016602E+04, .1144905151367E+04},
 {    1490, .8451096679688E+04, -.1276067016602E+04, .1131673217773E+04},
 {    1491, .8426840820312E+04, -.1276067016602E+04, .1138015747070E+04},
 {    1492, .8402583984375E+04, -.1276067016602E+04, .1144358398438E+04},
 {    1493, .8378328125000E+04, -.1276067016602E+04, .1150701171875E+04},
 {    1494, .8453606445312E+04, -.1295117065430E+04, .1141267700195E+04},
 {    1495, .8429772460938E+04, -.1295117065430E+04, .1147500366211E+04},
 {    1496, .8405935546875E+04, -.1295117065430E+04, .1153733276367E+04},
 {    1497, .8382102539062E+04, -.1295117065430E+04, .1159964965820E+04},
 {    1498, .8453606445312E+04, -.1276067016602E+04, .1141267700195E+04},
 {    1499, .8429772460938E+04, -.1276067016602E+04, .1147500366211E+04},
 {    1500, .8405935546875E+04, -.1276067016602E+04, .1153733276367E+04},
 {    1501, .8382102539062E+04, -.1276067016602E+04, .1159964965820E+04},
 {    1502, .8443737304688E+04, -.1295117065430E+04, .1157407470703E+04},
 {    1503, .8425268554688E+04, -.1295117065430E+04, .1163724365234E+04},
 {    1504, .8406796875000E+04, -.1295117065430E+04, .1170040039062E+04},
 {    1505, .8388329101562E+04, -.1295117065430E+04, .1176356689453E+04},
 {    1506, .8443737304688E+04, -.1276067016602E+04, .1157407470703E+04},
 {    1507, .8425268554688E+04, -.1276067016602E+04, .1163724365234E+04},
 {    1508, .8406796875000E+04, -.1276067016602E+04, .1170040039062E+04},
 {    1509, .8388329101562E+04, -.1276067016602E+04, .1176356689453E+04},
 {    1510, .8433868164062E+04, -.1295117065430E+04, .1173547485352E+04},
 {    1511, .8420765625000E+04, -.1295117065430E+04, .1179947509766E+04},
 {    1512, .8407661132812E+04, -.1295117065430E+04, .1186348022461E+04},
 {    1513, .8394555664062E+04, -.1295117065430E+04, .1192748901367E+04},
 {    1514, .8433868164062E+04, -.1276067016602E+04, .1173547485352E+04},
 {    1515, .8420765625000E+04, -.1276067016602E+04, .1179947509766E+04},
 {    1516, .8407661132812E+04, -.1276067016602E+04, .1186348022461E+04},
 {    1517, .8394555664062E+04, -.1276067016602E+04, .1192748901367E+04},
 {    1518, .8423999023438E+04, -.1295117065430E+04, .1189687988281E+04},
 {    1519, .8415592773438E+04, -.1295117065430E+04, .1193002929688E+04},
 {    1520, .8407188476562E+04, -.1295117065430E+04, .1196318725586E+04},
 {    1521, .8398785156250E+04, -.1295117065430E+04, .1199633544922E+04},
 {    1522, .8423999023438E+04, -.1276067016602E+04, .1189687988281E+04},
 {    1523, .8415592773438E+04, -.1276067016602E+04, .1193002929688E+04},
 {    1524, .8407188476562E+04, -.1276067016602E+04, .1196318725586E+04},
 {    1525, .8398785156250E+04, -.1276067016602E+04, .1199633544922E+04},
 {    1526, .8414131835938E+04, -.1295117065430E+04, .1205827880859E+04},
 {    1527, .8410420898438E+04, -.1295117065430E+04, .1206058105469E+04},
 {    1528, .8406715820312E+04, -.1295117065430E+04, .1206288696289E+04},
 {    1529, .8403009765625E+04, -.1295117065430E+04, .1206519165039E+04},
 {    1530, .8414131835938E+04, -.1276067016602E+04, .1205827880859E+04},
 {    1531, .8410420898438E+04, -.1276067016602E+04, .1206058105469E+04},
 {    1532, .8406715820312E+04, -.1276067016602E+04, .1206288696289E+04},
 {    1533, .8403009765625E+04, -.1276067016602E+04, .1206519165039E+04},
 {    1534, .8449513671875E+04, -.1260192016602E+04, .1125612792969E+04},
 {    1535, .8424918945312E+04, -.1260192016602E+04, .1132043945312E+04},
 {    1536, .8400327148438E+04, -.1260192016602E+04, .1138474121094E+04},
 {    1537, .8375732421875E+04, -.1260192016602E+04, .1144905151367E+04},
 {    1538, .8451096679688E+04, -.1260192016602E+04, .1131673217773E+04},
 {    1539, .8426840820312E+04, -.1260192016602E+04, .1138015747070E+04},
 {    1540, .8402583984375E+04, -.1260192016602E+04, .1144358398438E+04},
 {    1541, .8378328125000E+04, -.1260192016602E+04, .1150701171875E+04},
 {    1542, .8449513671875E+04, -.1253842041016E+04, .1125612792969E+04},
 {    1543, .8424918945312E+04, -.1253842041016E+04, .1132043945312E+04},
 {    1544, .8400327148438E+04, -.1253842041016E+04, .1138474121094E+04},
 {    1545, .8375732421875E+04, -.1253842041016E+04, .1144905151367E+04},
 {    1546, .8451096679688E+04, -.1253842041016E+04, .1131673217773E+04},
 {    1547, .8426840820312E+04, -.1253842041016E+04, .1138015747070E+04},
 {    1548, .8402583984375E+04, -.1253842041016E+04, .1144358398438E+04},
 {    1549, .8378328125000E+04, -.1253842041016E+04, .1150701171875E+04},
 {    1550, .8453606445312E+04, -.1260192016602E+04, .1141267700195E+04},
 {    1551, .8429772460938E+04, -.1260192016602E+04, .1147500366211E+04},
 {    1552, .8405935546875E+04, -.1260192016602E+04, .1153733276367E+04},
 {    1553, .8382102539062E+04, -.1260192016602E+04, .1159964965820E+04},
 {    1554, .8453606445312E+04, -.1253842041016E+04, .1141267700195E+04},
 {    1555, .8429772460938E+04, -.1253842041016E+04, .1147500366211E+04},
 {    1556, .8405935546875E+04, -.1253842041016E+04, .1153733276367E+04},
 {    1557, .8382102539062E+04, -.1253842041016E+04, .1159964965820E+04},
 {    1558, .8443737304688E+04, -.1260192016602E+04, .1157407470703E+04},
 {    1559, .8425268554688E+04, -.1260192016602E+04, .1163724365234E+04},
 {    1560, .8406796875000E+04, -.1260192016602E+04, .1170040039062E+04},
 {    1561, .8388329101562E+04, -.1260192016602E+04, .1176356689453E+04},
 {    1562, .8443737304688E+04, -.1253842041016E+04, .1157407470703E+04},
 {    1563, .8425268554688E+04, -.1253842041016E+04, .1163724365234E+04},
 {    1564, .8406796875000E+04, -.1253842041016E+04, .1170040039062E+04},
 {    1565, .8388329101562E+04, -.1253842041016E+04, .1176356689453E+04},
 {    1566, .8433868164062E+04, -.1260192016602E+04, .1173547485352E+04},
 {    1567, .8420765625000E+04, -.1260192016602E+04, .1179947509766E+04},
 {    1568, .8407661132812E+04, -.1260192016602E+04, .1186348022461E+04},
 {    1569, .8394555664062E+04, -.1260192016602E+04, .1192748901367E+04},
 {    1570, .8433868164062E+04, -.1253842041016E+04, .1173547485352E+04},
 {    1571, .8420765625000E+04, -.1253842041016E+04, .1179947509766E+04},
 {    1572, .8407661132812E+04, -.1253842041016E+04, .1186348022461E+04},
 {    1573, .8394555664062E+04, -.1253842041016E+04, .1192748901367E+04},
 {    1574, .8423999023438E+04, -.1260192016602E+04, .1189687988281E+04},
 {    1575, .8415592773438E+04, -.1260192016602E+04, .1193002929688E+04},
 {    1576, .8407188476562E+04, -.1260192016602E+04, .1196318725586E+04},
 {    1577, .8398785156250E+04, -.1260192016602E+04, .1199633544922E+04},
 {    1578, .8423999023438E+04, -.1253842041016E+04, .1189687988281E+04},
 {    1579, .8415592773438E+04, -.1253842041016E+04, .1193002929688E+04},
 {    1580, .8407188476562E+04, -.1253842041016E+04, .1196318725586E+04},
 {    1581, .8398785156250E+04, -.1253842041016E+04, .1199633544922E+04},
 {    1582, .8414131835938E+04, -.1260192016602E+04, .1205827880859E+04},
 {    1583, .8410420898438E+04, -.1260192016602E+04, .1206058105469E+04},
 {    1584, .8406715820312E+04, -.1260192016602E+04, .1206288696289E+04},
 {    1585, .8403009765625E+04, -.1260192016602E+04, .1206519165039E+04},
 {    1586, .8414131835938E+04, -.1253842041016E+04, .1205827880859E+04},
 {    1587, .8410420898438E+04, -.1253842041016E+04, .1206058105469E+04},
 {    1588, .8406715820312E+04, -.1253842041016E+04, .1206288696289E+04},
 {    1589, .8403009765625E+04, -.1253842041016E+04, .1206519165039E+04},
 {    1590, .8449513671875E+04, -.1247492065430E+04, .1125612792969E+04},
 {    1591, .8424918945312E+04, -.1247492065430E+04, .1132043945312E+04},
 {    1592, .8400327148438E+04, -.1247492065430E+04, .1138474121094E+04},
 {    1593, .8375732421875E+04, -.1247492065430E+04, .1144905151367E+04},
 {    1594, .8451096679688E+04, -.1247492065430E+04, .1131673217773E+04},
 {    1595, .8426840820312E+04, -.1247492065430E+04, .1138015747070E+04},
 {    1596, .8402583984375E+04, -.1247492065430E+04, .1144358398438E+04},
 {    1597, .8378328125000E+04, -.1247492065430E+04, .1150701171875E+04},
 {    1598, .8424918945312E+04, -.1234791992188E+04, .1132043945312E+04},
 {    1599, .8400327148438E+04, -.1234791992188E+04, .1138474121094E+04},
 {    1600, .8375732421875E+04, -.1234791992188E+04, .1144905151367E+04},
 {    1601, .8451096679688E+04, -.1234791992188E+04, .1131673217773E+04},
 {    1602, .8426840820312E+04, -.1234791992188E+04, .1138015747070E+04},
 {    1603, .8402583984375E+04, -.1234791992188E+04, .1144358398438E+04},
 {    1604, .8378328125000E+04, -.1234791992188E+04, .1150701171875E+04},
 {    1605, .8369673828125E+04, -.1336392089844E+04, .1146489746094E+04},
 {    1606, .8369673828125E+04, -.1323692016602E+04, .1146489746094E+04},
 {    1607, .8372268554688E+04, -.1336392089844E+04, .1152285888672E+04},
 {    1608, .8372268554688E+04, -.1323692016602E+04, .1152285888672E+04},
 {    1609, .8369673828125E+04, -.1317342041016E+04, .1146489746094E+04},
 {    1610, .8372268554688E+04, -.1317342041016E+04, .1152285888672E+04},
 {    1611, .8403009765625E+04, -.1323692016602E+04, .1206519165039E+04},
 {    1612, .8397076171875E+04, -.1323692016602E+04, .1206888183594E+04},
 {    1613, .8397076171875E+04, -.1317342041016E+04, .1206888183594E+04},
 {    1614, .8403379882812E+04, -.1323692016602E+04, .1212453979492E+04},
 {    1615, .8397443359375E+04, -.1323692016602E+04, .1212823120117E+04},
 {    1616, .8403379882812E+04, -.1317342041016E+04, .1212453979492E+04},
 {    1617, .8397443359375E+04, -.1317342041016E+04, .1212823120117E+04},
 {    1618, .8369673828125E+04, -.1310992065430E+04, .1146489746094E+04},
 {    1619, .8372268554688E+04, -.1310992065430E+04, .1152285888672E+04},
 {    1620, .8376040039062E+04, -.1317342041016E+04, .1161549804688E+04},
 {    1621, .8376040039062E+04, -.1310992065430E+04, .1161549804688E+04},
 {    1622, .8382333007812E+04, -.1317342041016E+04, .1177333740234E+04},
 {    1623, .8382333007812E+04, -.1310992065430E+04, .1177333740234E+04},
 {    1624, .8388622070312E+04, -.1317342041016E+04, .1193117187500E+04},
 {    1625, .8388622070312E+04, -.1310992065430E+04, .1193117187500E+04},
 {    1626, .8392849609375E+04, -.1317342041016E+04, .1200002929688E+04},
 {    1627, .8392849609375E+04, -.1310992065430E+04, .1200002929688E+04},
 {    1628, .8397076171875E+04, -.1310992065430E+04, .1206888183594E+04},
 {    1629, .8403379882812E+04, -.1310992065430E+04, .1212453979492E+04},
 {    1630, .8397443359375E+04, -.1310992065430E+04, .1212823120117E+04},
 {    1631, .8369673828125E+04, -.1295117065430E+04, .1146489746094E+04},
 {    1632, .8372268554688E+04, -.1295117065430E+04, .1152285888672E+04},
 {    1633, .8397076171875E+04, -.1295117065430E+04, .1206888183594E+04},
 {    1634, .8403379882812E+04, -.1295117065430E+04, .1212453979492E+04},
 {    1635, .8397443359375E+04, -.1295117065430E+04, .1212823120117E+04},
 {    1636, .8369673828125E+04, -.1276067016602E+04, .1146489746094E+04},
 {    1637, .8372268554688E+04, -.1276067016602E+04, .1152285888672E+04},
 {    1638, .8376040039062E+04, -.1295117065430E+04, .1161549804688E+04},
 {    1639, .8376040039062E+04, -.1276067016602E+04, .1161549804688E+04},
 {    1640, .8382333007812E+04, -.1295117065430E+04, .1177333740234E+04},
 {    1641, .8382333007812E+04, -.1276067016602E+04, .1177333740234E+04},
 {    1642, .8388622070312E+04, -.1295117065430E+04, .1193117187500E+04},
 {    1643, .8388622070312E+04, -.1276067016602E+04, .1193117187500E+04},
 {    1644, .8392849609375E+04, -.1295117065430E+04, .1200002929688E+04},
 {    1645, .8392849609375E+04, -.1276067016602E+04, .1200002929688E+04},
 {    1646, .8397076171875E+04, -.1276067016602E+04, .1206888183594E+04},
 {    1647, .8403379882812E+04, -.1276067016602E+04, .1212453979492E+04},
 {    1648, .8397443359375E+04, -.1276067016602E+04, .1212823120117E+04},
 {    1649, .8369673828125E+04, -.1260192016602E+04, .1146489746094E+04},
 {    1650, .8372268554688E+04, -.1260192016602E+04, .1152285888672E+04},
 {    1651, .8397076171875E+04, -.1260192016602E+04, .1206888183594E+04},
 {    1652, .8403379882812E+04, -.1260192016602E+04, .1212453979492E+04},
 {    1653, .8397443359375E+04, -.1260192016602E+04, .1212823120117E+04},
 {    1654, .8369673828125E+04, -.1253842041016E+04, .1146489746094E+04},
 {    1655, .8372268554688E+04, -.1253842041016E+04, .1152285888672E+04},
 {    1656, .8376040039062E+04, -.1260192016602E+04, .1161549804688E+04},
 {    1657, .8376040039062E+04, -.1253842041016E+04, .1161549804688E+04},
 {    1658, .8382333007812E+04, -.1260192016602E+04, .1177333740234E+04},
 {    1659, .8382333007812E+04, -.1253842041016E+04, .1177333740234E+04},
 {    1660, .8388622070312E+04, -.1260192016602E+04, .1193117187500E+04},
 {    1661, .8388622070312E+04, -.1253842041016E+04, .1193117187500E+04},
 {    1662, .8392849609375E+04, -.1260192016602E+04, .1200002929688E+04},
 {    1663, .8392849609375E+04, -.1253842041016E+04, .1200002929688E+04},
 {    1664, .8397076171875E+04, -.1253842041016E+04, .1206888183594E+04},
 {    1665, .8403379882812E+04, -.1253842041016E+04, .1212453979492E+04},
 {    1666, .8397443359375E+04, -.1253842041016E+04, .1212823120117E+04},
 {    1667, .8369673828125E+04, -.1247492065430E+04, .1146489746094E+04},
 {    1668, .8372268554688E+04, -.1247492065430E+04, .1152285888672E+04},
 {    1669, .8403009765625E+04, -.1247492065430E+04, .1206519165039E+04},
 {    1670, .8397076171875E+04, -.1247492065430E+04, .1206888183594E+04},
 {    1671, .8403379882812E+04, -.1247492065430E+04, .1212453979492E+04},
 {    1672, .8397443359375E+04, -.1247492065430E+04, .1212823120117E+04},
 {    1673, .8369673828125E+04, -.1234791992188E+04, .1146489746094E+04},
 {    1674, .8372268554688E+04, -.1234791992188E+04, .1152285888672E+04},
 {    1675, .8381201171875E+04, -.1323692016602E+04, .1207875854492E+04},
 {    1676, .8381201171875E+04, -.1317342041016E+04, .1207875854492E+04},
 {    1677, .8381570312500E+04, -.1323692016602E+04, .1213810791016E+04},
 {    1678, .8381570312500E+04, -.1317342041016E+04, .1213810791016E+04},
 {    1679, .8380314453125E+04, -.1317342041016E+04, .1193634155273E+04},
 {    1680, .8380314453125E+04, -.1310992065430E+04, .1193634155273E+04},
 {    1681, .8380758789062E+04, -.1317342041016E+04, .1200755126953E+04},
 {    1682, .8380758789062E+04, -.1310992065430E+04, .1200755126953E+04},
 {    1683, .8381201171875E+04, -.1310992065430E+04, .1207875854492E+04},
 {    1684, .8381570312500E+04, -.1310992065430E+04, .1213810791016E+04},
 {    1685, .8381201171875E+04, -.1295117065430E+04, .1207875854492E+04},
 {    1686, .8381570312500E+04, -.1295117065430E+04, .1213810791016E+04},
 {    1687, .8380314453125E+04, -.1295117065430E+04, .1193634155273E+04},
 {    1688, .8380314453125E+04, -.1276067016602E+04, .1193634155273E+04},
 {    1689, .8380758789062E+04, -.1295117065430E+04, .1200755126953E+04},
 {    1690, .8380758789062E+04, -.1276067016602E+04, .1200755126953E+04},
 {    1691, .8381201171875E+04, -.1276067016602E+04, .1207875854492E+04},
 {    1692, .8381570312500E+04, -.1276067016602E+04, .1213810791016E+04},
 {    1693, .8381201171875E+04, -.1260192016602E+04, .1207875854492E+04},
 {    1694, .8381570312500E+04, -.1260192016602E+04, .1213810791016E+04},
 {    1695, .8380314453125E+04, -.1260192016602E+04, .1193634155273E+04},
 {    1696, .8380314453125E+04, -.1253842041016E+04, .1193634155273E+04},
 {    1697, .8380758789062E+04, -.1260192016602E+04, .1200755126953E+04},
 {    1698, .8380758789062E+04, -.1253842041016E+04, .1200755126953E+04},
 {    1699, .8381201171875E+04, -.1253842041016E+04, .1207875854492E+04},
 {    1700, .8381570312500E+04, -.1253842041016E+04, .1213810791016E+04},
 {    1701, .8381201171875E+04, -.1247492065430E+04, .1207875854492E+04},
 {    1702, .8381570312500E+04, -.1247492065430E+04, .1213810791016E+04},
 {    1703, .8365672851562E+04, -.1323692016602E+04, .1208842529297E+04},
 {    1704, .8350144531250E+04, -.1323692016602E+04, .1209808349609E+04},
 {    1705, .8334618164062E+04, -.1323692016602E+04, .1210774780273E+04},
 {    1706, .8365672851562E+04, -.1317342041016E+04, .1208842529297E+04},
 {    1707, .8350144531250E+04, -.1317342041016E+04, .1209808349609E+04},
 {    1708, .8334618164062E+04, -.1317342041016E+04, .1210774780273E+04},
 {    1709, .8366041015625E+04, -.1323692016602E+04, .1214777465820E+04},
 {    1710, .8350513671875E+04, -.1323692016602E+04, .1215742187500E+04},
 {    1711, .8334985351562E+04, -.1323692016602E+04, .1216708740234E+04},
 {    1712, .8366041015625E+04, -.1317342041016E+04, .1214777465820E+04},
 {    1713, .8350513671875E+04, -.1317342041016E+04, .1215742187500E+04},
 {    1714, .8334985351562E+04, -.1317342041016E+04, .1216708740234E+04},
 {    1715, .8365672851562E+04, -.1310992065430E+04, .1208842529297E+04},
 {    1716, .8350144531250E+04, -.1310992065430E+04, .1209808349609E+04},
 {    1717, .8334618164062E+04, -.1310992065430E+04, .1210774780273E+04},
 {    1718, .8366041015625E+04, -.1310992065430E+04, .1214777465820E+04},
 {    1719, .8350513671875E+04, -.1310992065430E+04, .1215742187500E+04},
 {    1720, .8334985351562E+04, -.1310992065430E+04, .1216708740234E+04},
 {    1721, .8365672851562E+04, -.1295117065430E+04, .1208842529297E+04},
 {    1722, .8350144531250E+04, -.1295117065430E+04, .1209808349609E+04},
 {    1723, .8334618164062E+04, -.1295117065430E+04, .1210774780273E+04},
 {    1724, .8366041015625E+04, -.1295117065430E+04, .1214777465820E+04},
 {    1725, .8350513671875E+04, -.1295117065430E+04, .1215742187500E+04},
 {    1726, .8334985351562E+04, -.1295117065430E+04, .1216708740234E+04},
 {    1727, .8364786132812E+04, -.1295117065430E+04, .1194600219727E+04},
 {    1728, .8349257812500E+04, -.1295117065430E+04, .1195566162109E+04},
 {    1729, .8333730468750E+04, -.1295117065430E+04, .1196532348633E+04},
 {    1730, .8364786132812E+04, -.1276067016602E+04, .1194600219727E+04},
 {    1731, .8349257812500E+04, -.1276067016602E+04, .1195566162109E+04},
 {    1732, .8333730468750E+04, -.1276067016602E+04, .1196532348633E+04},
 {    1733, .8365230468750E+04, -.1295117065430E+04, .1201721191406E+04},
 {    1734, .8349703125000E+04, -.1295117065430E+04, .1202687500000E+04},
 {    1735, .8334175781250E+04, -.1295117065430E+04, .1203653442383E+04},
 {    1736, .8365230468750E+04, -.1276067016602E+04, .1201721191406E+04},
 {    1737, .8349703125000E+04, -.1276067016602E+04, .1202687500000E+04},
 {    1738, .8334175781250E+04, -.1276067016602E+04, .1203653442383E+04},
 {    1739, .8365672851562E+04, -.1276067016602E+04, .1208842529297E+04},
 {    1740, .8350144531250E+04, -.1276067016602E+04, .1209808349609E+04},
 {    1741, .8334618164062E+04, -.1276067016602E+04, .1210774780273E+04},
 {    1742, .8366041015625E+04, -.1276067016602E+04, .1214777465820E+04},
 {    1743, .8350513671875E+04, -.1276067016602E+04, .1215742187500E+04},
 {    1744, .8334985351562E+04, -.1276067016602E+04, .1216708740234E+04},
 {    1745, .8365672851562E+04, -.1260192016602E+04, .1208842529297E+04},
 {    1746, .8350144531250E+04, -.1260192016602E+04, .1209808349609E+04},
 {    1747, .8334618164062E+04, -.1260192016602E+04, .1210774780273E+04},
 {    1748, .8366041015625E+04, -.1260192016602E+04, .1214777465820E+04},
 {    1749, .8350513671875E+04, -.1260192016602E+04, .1215742187500E+04},
 {    1750, .8334985351562E+04, -.1260192016602E+04, .1216708740234E+04},
 {    1751, .8365672851562E+04, -.1253842041016E+04, .1208842529297E+04},
 {    1752, .8350144531250E+04, -.1253842041016E+04, .1209808349609E+04},
 {    1753, .8334618164062E+04, -.1253842041016E+04, .1210774780273E+04},
 {    1754, .8366041015625E+04, -.1253842041016E+04, .1214777465820E+04},
 {    1755, .8350513671875E+04, -.1253842041016E+04, .1215742187500E+04},
 {    1756, .8334985351562E+04, -.1253842041016E+04, .1216708740234E+04},
 {    1757, .8365672851562E+04, -.1247492065430E+04, .1208842529297E+04},
 {    1758, .8350144531250E+04, -.1247492065430E+04, .1209808349609E+04},
 {    1759, .8334618164062E+04, -.1247492065430E+04, .1210774780273E+04},
 {    1760, .8366041015625E+04, -.1247492065430E+04, .1214777465820E+04},
 {    1761, .8350513671875E+04, -.1247492065430E+04, .1215742187500E+04},
 {    1762, .8334985351562E+04, -.1247492065430E+04, .1216708740234E+04},
 {    1763, .8285606445312E+04, -.1186532104492E+04, .1028630371094E+04},
 {    1764, .8272855468750E+04, -.1186532104492E+04, .1034337890625E+04},
 {    1765, .8285188476562E+04, -.1186532104492E+04, .1026033569336E+04},
 {    1766, .8271292968750E+04, -.1186532104492E+04, .1024601318359E+04},
 {    1767, .8286127929688E+04, -.1186532104492E+04, .1023576171875E+04},
 {    1768, .8274807617188E+04, -.1186532104492E+04, .1015388061523E+04},
 {    1769, .8288166015625E+04, -.1186532104492E+04, .1021918090820E+04},
 {    1770, .8282458984375E+04, -.1186532104492E+04, .1009166748047E+04},
 {    1771, .8285606445312E+04, -.1190342041016E+04, .1028630371094E+04},
 {    1772, .8272855468750E+04, -.1190342041016E+04, .1034337890625E+04},
 {    1773, .8285188476562E+04, -.1190342041016E+04, .1026033569336E+04},
 {    1774, .8271292968750E+04, -.1190342041016E+04, .1024601318359E+04},
 {    1775, .8286127929688E+04, -.1190342041016E+04, .1023576171875E+04},
 {    1776, .8274807617188E+04, -.1190342041016E+04, .1015388061523E+04},
 {    1777, .8288166015625E+04, -.1190342041016E+04, .1021918090820E+04},
 {    1778, .8282458984375E+04, -.1190342041016E+04, .1009166748047E+04},
 {    1779, .8285606445312E+04, -.1200502075195E+04, .1028630371094E+04},
 {    1780, .8272855468750E+04, -.1200502075195E+04, .1034337890625E+04},
 {    1781, .8285188476562E+04, -.1200502075195E+04, .1026033569336E+04},
 {    1782, .8271292968750E+04, -.1200502075195E+04, .1024601318359E+04},
 {    1783, .8286127929688E+04, -.1200502075195E+04, .1023576171875E+04},
 {    1784, .8274807617188E+04, -.1200502075195E+04, .1015388061523E+04},
 {    1785, .8288166015625E+04, -.1200502075195E+04, .1021918090820E+04},
 {    1786, .8282458984375E+04, -.1200502075195E+04, .1009166748047E+04},
 {    1787, .8285606445312E+04, -.1223679565430E+04, .1028630371094E+04},
 {    1788, .8272855468750E+04, -.1223679565430E+04, .1034337890625E+04},
 {    1789, .8285188476562E+04, -.1223679565430E+04, .1026033569336E+04},
 {    1790, .8271292968750E+04, -.1223679565430E+04, .1024601318359E+04},
 {    1791, .8286127929688E+04, -.1223679565430E+04, .1023576171875E+04},
 {    1792, .8274807617188E+04, -.1223679565430E+04, .1015388061523E+04},
 {    1793, .8288166015625E+04, -.1223679565430E+04, .1021918090820E+04},
 {    1794, .8282458984375E+04, -.1223679565430E+04, .1009166748047E+04},
 {    1795, .8285606445312E+04, -.1246857055664E+04, .1028630371094E+04},
 {    1796, .8272855468750E+04, -.1246857055664E+04, .1034337890625E+04},
 {    1797, .8285188476562E+04, -.1246857055664E+04, .1026033569336E+04},
 {    1798, .8271292968750E+04, -.1246857055664E+04, .1024601318359E+04},
 {    1799, .8286127929688E+04, -.1246857055664E+04, .1023576171875E+04},
 {    1800, .8274807617188E+04, -.1246857055664E+04, .1015388061523E+04},
 {    1801, .8288166015625E+04, -.1246857055664E+04, .1021918090820E+04},
 {    1802, .8282458984375E+04, -.1246857055664E+04, .1009166748047E+04},
 {    1803, .8285606445312E+04, -.1270034545898E+04, .1028630371094E+04},
 {    1804, .8272855468750E+04, -.1270034545898E+04, .1034337890625E+04},
 {    1805, .8285188476562E+04, -.1270034545898E+04, .1026033569336E+04},
 {    1806, .8271292968750E+04, -.1270034545898E+04, .1024601318359E+04},
 {    1807, .8286127929688E+04, -.1270034545898E+04, .1023576171875E+04},
 {    1808, .8274807617188E+04, -.1270034545898E+04, .1015388061523E+04},
 {    1809, .8288166015625E+04, -.1270034545898E+04, .1021918090820E+04},
 {    1810, .8282458984375E+04, -.1270034545898E+04, .1009166748047E+04},
 {    1811, .8285606445312E+04, -.1293212036133E+04, .1028630371094E+04},
 {    1812, .8272855468750E+04, -.1293212036133E+04, .1034337890625E+04},
 {    1813, .8285188476562E+04, -.1293212036133E+04, .1026033569336E+04},
 {    1814, .8271292968750E+04, -.1293212036133E+04, .1024601318359E+04},
 {    1815, .8286127929688E+04, -.1293212036133E+04, .1023576171875E+04},
 {    1816, .8274807617188E+04, -.1293212036133E+04, .1015388061523E+04},
 {    1817, .8288166015625E+04, -.1293212036133E+04, .1021918090820E+04},
 {    1818, .8282458984375E+04, -.1293212036133E+04, .1009166748047E+04},
 {    1819, .8290762695312E+04, -.1186532104492E+04, .1021500854492E+04},
 {    1820, .8292194335938E+04, -.1186532104492E+04, .1007604736328E+04},
 {    1821, .8293221679688E+04, -.1186532104492E+04, .1022438232422E+04},
 {    1822, .8301407226562E+04, -.1186532104492E+04, .1011119628906E+04},
 {    1823, .8294878906250E+04, -.1186532104492E+04, .1024478881836E+04},
 {    1824, .8307628906250E+04, -.1186532104492E+04, .1018770141602E+04},
 {    1825, .8295294921875E+04, -.1186532104492E+04, .1027074951172E+04},
 {    1826, .8309192382812E+04, -.1186532104492E+04, .1028507568359E+04},
 {    1827, .8294360351562E+04, -.1186532104492E+04, .1029531738281E+04},
 {    1828, .8305677734375E+04, -.1186532104492E+04, .1037719970703E+04},
 {    1829, .8292318359375E+04, -.1186532104492E+04, .1031190917969E+04},
 {    1830, .8298025390625E+04, -.1186532104492E+04, .1043941162109E+04},
 {    1831, .8290762695312E+04, -.1190342041016E+04, .1021500854492E+04},
 {    1832, .8292194335938E+04, -.1190342041016E+04, .1007604736328E+04},
 {    1833, .8293221679688E+04, -.1190342041016E+04, .1022438232422E+04},
 {    1834, .8301407226562E+04, -.1190342041016E+04, .1011119628906E+04},
 {    1835, .8294878906250E+04, -.1190342041016E+04, .1024478881836E+04},
 {    1836, .8307628906250E+04, -.1190342041016E+04, .1018770141602E+04},
 {    1837, .8295294921875E+04, -.1190342041016E+04, .1027074951172E+04},
 {    1838, .8309192382812E+04, -.1190342041016E+04, .1028507568359E+04},
 {    1839, .8294360351562E+04, -.1190342041016E+04, .1029531738281E+04},
 {    1840, .8305677734375E+04, -.1190342041016E+04, .1037719970703E+04},
 {    1841, .8292318359375E+04, -.1190342041016E+04, .1031190917969E+04},
 {    1842, .8298025390625E+04, -.1190342041016E+04, .1043941162109E+04},
 {    1843, .8290762695312E+04, -.1200502075195E+04, .1021500854492E+04},
 {    1844, .8292194335938E+04, -.1200502075195E+04, .1007604736328E+04},
 {    1845, .8293221679688E+04, -.1200502075195E+04, .1022438232422E+04},
 {    1846, .8301407226562E+04, -.1200502075195E+04, .1011119628906E+04},
 {    1847, .8294878906250E+04, -.1200502075195E+04, .1024478881836E+04},
 {    1848, .8307628906250E+04, -.1200502075195E+04, .1018770141602E+04},
 {    1849, .8295294921875E+04, -.1200502075195E+04, .1027074951172E+04},
 {    1850, .8309192382812E+04, -.1200502075195E+04, .1028507568359E+04},
 {    1851, .8294360351562E+04, -.1200502075195E+04, .1029531738281E+04},
 {    1852, .8305677734375E+04, -.1200502075195E+04, .1037719970703E+04},
 {    1853, .8292318359375E+04, -.1200502075195E+04, .1031190917969E+04},
 {    1854, .8298025390625E+04, -.1200502075195E+04, .1043941162109E+04},
 {    1855, .8290762695312E+04, -.1223679565430E+04, .1021500854492E+04},
 {    1856, .8292194335938E+04, -.1223679565430E+04, .1007604736328E+04},
 {    1857, .8293221679688E+04, -.1223679565430E+04, .1022438232422E+04},
 {    1858, .8301407226562E+04, -.1223679565430E+04, .1011119628906E+04},
 {    1859, .8294878906250E+04, -.1223679565430E+04, .1024478881836E+04},
 {    1860, .8307628906250E+04, -.1223679565430E+04, .1018770141602E+04},
 {    1861, .8295294921875E+04, -.1223679565430E+04, .1027074951172E+04},
 {    1862, .8309192382812E+04, -.1223679565430E+04, .1028507568359E+04},
 {    1863, .8294360351562E+04, -.1223679565430E+04, .1029531738281E+04},
 {    1864, .8305677734375E+04, -.1223679565430E+04, .1037719970703E+04},
 {    1865, .8292318359375E+04, -.1223679565430E+04, .1031190917969E+04},
 {    1866, .8298025390625E+04, -.1223679565430E+04, .1043941162109E+04},
 {    1867, .8290762695312E+04, -.1246857055664E+04, .1021500854492E+04},
 {    1868, .8292194335938E+04, -.1246857055664E+04, .1007604736328E+04},
 {    1869, .8293221679688E+04, -.1246857055664E+04, .1022438232422E+04},
 {    1870, .8301407226562E+04, -.1246857055664E+04, .1011119628906E+04},
 {    1871, .8294878906250E+04, -.1246857055664E+04, .1024478881836E+04},
 {    1872, .8307628906250E+04, -.1246857055664E+04, .1018770141602E+04},
 {    1873, .8295294921875E+04, -.1246857055664E+04, .1027074951172E+04},
 {    1874, .8309192382812E+04, -.1246857055664E+04, .1028507568359E+04},
 {    1875, .8294360351562E+04, -.1246857055664E+04, .1029531738281E+04},
 {    1876, .8305677734375E+04, -.1246857055664E+04, .1037719970703E+04},
 {    1877, .8292318359375E+04, -.1246857055664E+04, .1031190917969E+04},
 {    1878, .8298025390625E+04, -.1246857055664E+04, .1043941162109E+04},
 {    1879, .8290762695312E+04, -.1270034545898E+04, .1021500854492E+04},
 {    1880, .8292194335938E+04, -.1270034545898E+04, .1007604736328E+04},
 {    1881, .8293221679688E+04, -.1270034545898E+04, .1022438232422E+04},
 {    1882, .8301407226562E+04, -.1270034545898E+04, .1011119628906E+04},
 {    1883, .8294878906250E+04, -.1270034545898E+04, .1024478881836E+04},
 {    1884, .8307628906250E+04, -.1270034545898E+04, .1018770141602E+04},
 {    1885, .8295294921875E+04, -.1270034545898E+04, .1027074951172E+04},
 {    1886, .8309192382812E+04, -.1270034545898E+04, .1028507568359E+04},
 {    1887, .8294360351562E+04, -.1270034545898E+04, .1029531738281E+04},
 {    1888, .8305677734375E+04, -.1270034545898E+04, .1037719970703E+04},
 {    1889, .8292318359375E+04, -.1270034545898E+04, .1031190917969E+04},
 {    1890, .8298025390625E+04, -.1270034545898E+04, .1043941162109E+04},
 {    1891, .8290762695312E+04, -.1293212036133E+04, .1021500854492E+04},
 {    1892, .8292194335938E+04, -.1293212036133E+04, .1007604736328E+04},
 {    1893, .8293221679688E+04, -.1293212036133E+04, .1022438232422E+04},
 {    1894, .8301407226562E+04, -.1293212036133E+04, .1011119628906E+04},
 {    1895, .8294878906250E+04, -.1293212036133E+04, .1024478881836E+04},
 {    1896, .8307628906250E+04, -.1293212036133E+04, .1018770141602E+04},
 {    1897, .8295294921875E+04, -.1293212036133E+04, .1027074951172E+04},
 {    1898, .8309192382812E+04, -.1293212036133E+04, .1028507568359E+04},
 {    1899, .8294360351562E+04, -.1293212036133E+04, .1029531738281E+04},
 {    1900, .8305677734375E+04, -.1293212036133E+04, .1037719970703E+04},
 {    1901, .8292318359375E+04, -.1293212036133E+04, .1031190917969E+04},
 {    1902, .8298025390625E+04, -.1293212036133E+04, .1043941162109E+04},
 {    1903, .8289721679688E+04, -.1186532104492E+04, .1031607421875E+04},
 {    1904, .8288289062500E+04, -.1186532104492E+04, .1045503784180E+04},
 {    1905, .8287264648438E+04, -.1186532104492E+04, .1030670043945E+04},
 {    1906, .8279077148438E+04, -.1186532104492E+04, .1041988647461E+04},
 {    1907, .8289721679688E+04, -.1190342041016E+04, .1031607421875E+04},
 {    1908, .8288289062500E+04, -.1190342041016E+04, .1045503784180E+04},
 {    1909, .8287264648438E+04, -.1190342041016E+04, .1030670043945E+04},
 {    1910, .8279077148438E+04, -.1190342041016E+04, .1041988647461E+04},
 {    1911, .8289721679688E+04, -.1200502075195E+04, .1031607421875E+04},
 {    1912, .8288289062500E+04, -.1200502075195E+04, .1045503784180E+04},
 {    1913, .8287264648438E+04, -.1200502075195E+04, .1030670043945E+04},
 {    1914, .8279077148438E+04, -.1200502075195E+04, .1041988647461E+04},
 {    1915, .8289721679688E+04, -.1223679565430E+04, .1031607421875E+04},
 {    1916, .8288289062500E+04, -.1223679565430E+04, .1045503784180E+04},
 {    1917, .8287264648438E+04, -.1223679565430E+04, .1030670043945E+04},
 {    1918, .8279077148438E+04, -.1223679565430E+04, .1041988647461E+04},
 {    1919, .8289721679688E+04, -.1246857055664E+04, .1031607421875E+04},
 {    1920, .8288289062500E+04, -.1246857055664E+04, .1045503784180E+04},
 {    1921, .8287264648438E+04, -.1246857055664E+04, .1030670043945E+04},
 {    1922, .8279077148438E+04, -.1246857055664E+04, .1041988647461E+04},
 {    1923, .8289721679688E+04, -.1270034545898E+04, .1031607421875E+04},
 {    1924, .8288289062500E+04, -.1270034545898E+04, .1045503784180E+04},
 {    1925, .8287264648438E+04, -.1270034545898E+04, .1030670043945E+04},
 {    1926, .8279077148438E+04, -.1270034545898E+04, .1041988647461E+04},
 {    1927, .8289721679688E+04, -.1293212036133E+04, .1031607421875E+04},
 {    1928, .8288289062500E+04, -.1293212036133E+04, .1045503784180E+04},
 {    1929, .8287264648438E+04, -.1293212036133E+04, .1030670043945E+04},
 {    1930, .8279077148438E+04, -.1293212036133E+04, .1041988647461E+04},
 {    1931, .8267059570312E+04, -.1190342041016E+04, .1036932617188E+04},
 {    1932, .8264975585938E+04, -.1190342041016E+04, .1023950683594E+04},
 {    1933, .8269664062500E+04, -.1190342041016E+04, .1011665832520E+04},
 {    1934, .8279864257812E+04, -.1190342041016E+04, .1003370788574E+04},
 {    1935, .8267059570312E+04, -.1200502075195E+04, .1036932617188E+04},
 {    1936, .8264975585938E+04, -.1200502075195E+04, .1023950683594E+04},
 {    1937, .8269664062500E+04, -.1200502075195E+04, .1011665832520E+04},
 {    1938, .8279864257812E+04, -.1200502075195E+04, .1003370788574E+04},
 {    1939, .8292847656250E+04, -.1190342041016E+04, .1001287841797E+04},
 {    1940, .8305130859375E+04, -.1190342041016E+04, .1005974731445E+04},
 {    1941, .8313423828125E+04, -.1190342041016E+04, .1016175903320E+04},
 {    1942, .8315507812500E+04, -.1190342041016E+04, .1029157592773E+04},
 {    1943, .8310823242188E+04, -.1190342041016E+04, .1041442260742E+04},
 {    1944, .8300619140625E+04, -.1190342041016E+04, .1049737304688E+04},
 {    1945, .8292847656250E+04, -.1200502075195E+04, .1001287841797E+04},
 {    1946, .8305130859375E+04, -.1200502075195E+04, .1005974731445E+04},
 {    1947, .8313423828125E+04, -.1200502075195E+04, .1016175903320E+04},
 {    1948, .8315507812500E+04, -.1200502075195E+04, .1029157592773E+04},
 {    1949, .8310823242188E+04, -.1200502075195E+04, .1041442260742E+04},
 {    1950, .8300619140625E+04, -.1200502075195E+04, .1049737304688E+04},
 {    1951, .8287638671875E+04, -.1190342041016E+04, .1051820434570E+04},
 {    1952, .8275354492188E+04, -.1190342041016E+04, .1047132934570E+04},
 {    1953, .8287638671875E+04, -.1200502075195E+04, .1051820434570E+04},
 {    1954, .8275354492188E+04, -.1200502075195E+04, .1047132934570E+04},
 {    1955, .8290245117188E+04, -.1323692016602E+04, .1026553833008E+04},
 {    1956, .8290245117188E+04, -.1248127075195E+04, .1026553833008E+04},
 {    1957, .8287923828125E+04, -.1295752075195E+04, .1027591796875E+04},
 {    1958, .8285606445312E+04, -.1295752075195E+04, .1028630371094E+04},
 {    1959, .8287716796875E+04, -.1295752075195E+04, .1026293579102E+04},
 {    1960, .8285188476562E+04, -.1295752075195E+04, .1026033569336E+04},
 {    1961, .8288183593750E+04, -.1295752075195E+04, .1025065673828E+04},
 {    1962, .8286127929688E+04, -.1295752075195E+04, .1023576171875E+04},
 {    1963, .8289204101562E+04, -.1295752075195E+04, .1024235595703E+04},
 {    1964, .8288166015625E+04, -.1295752075195E+04, .1021918090820E+04},
 {    1965, .8287923828125E+04, -.1310357055664E+04, .1027591796875E+04},
 {    1966, .8285606445312E+04, -.1310357055664E+04, .1028630371094E+04},
 {    1967, .8287716796875E+04, -.1310357055664E+04, .1026293579102E+04},
 {    1968, .8285188476562E+04, -.1310357055664E+04, .1026033569336E+04},
 {    1969, .8288184570312E+04, -.1310357055664E+04, .1025065185547E+04},
 {    1970, .8286127929688E+04, -.1310357055664E+04, .1023576171875E+04},
 {    1971, .8289204101562E+04, -.1310357055664E+04, .1024235595703E+04},
 {    1972, .8288166015625E+04, -.1310357055664E+04, .1021918090820E+04},
 {    1973, .8287923828125E+04, -.1324962036133E+04, .1027591796875E+04},
 {    1974, .8285606445312E+04, -.1324962036133E+04, .1028630371094E+04},
 {    1975, .8287716796875E+04, -.1324962036133E+04, .1026293579102E+04},
 {    1976, .8285188476562E+04, -.1324962036133E+04, .1026033569336E+04},
 {    1977, .8288184570312E+04, -.1324962036133E+04, .1025065185547E+04},
 {    1978, .8286127929688E+04, -.1324962036133E+04, .1023576171875E+04},
 {    1979, .8289204101562E+04, -.1324962036133E+04, .1024235595703E+04},
 {    1980, .8288166015625E+04, -.1324962036133E+04, .1021918090820E+04},
 {    1981, .8287923828125E+04, -.1339567016602E+04, .1027591796875E+04},
 {    1982, .8285606445312E+04, -.1339567016602E+04, .1028630371094E+04},
 {    1983, .8287716796875E+04, -.1339567016602E+04, .1026293579102E+04},
 {    1984, .8285188476562E+04, -.1339567016602E+04, .1026033569336E+04},
 {    1985, .8288184570312E+04, -.1339567016602E+04, .1025065185547E+04},
 {    1986, .8286127929688E+04, -.1339567016602E+04, .1023576171875E+04},
 {    1987, .8289204101562E+04, -.1339567016602E+04, .1024235595703E+04},
 {    1988, .8288166015625E+04, -.1339567016602E+04, .1021918090820E+04},
 {    1989, .8287923828125E+04, -.1354171997070E+04, .1027591796875E+04},
 {    1990, .8285606445312E+04, -.1354171997070E+04, .1028630371094E+04},
 {    1991, .8287716796875E+04, -.1354171997070E+04, .1026293579102E+04},
 {    1992, .8285188476562E+04, -.1354171997070E+04, .1026033569336E+04},
 {    1993, .8288184570312E+04, -.1354171997070E+04, .1025065185547E+04},
 {    1994, .8286127929688E+04, -.1354171997070E+04, .1023576171875E+04},
 {    1995, .8289204101562E+04, -.1354171997070E+04, .1024235595703E+04},
 {    1996, .8288166015625E+04, -.1354171997070E+04, .1021918090820E+04},
 {    1997, .8287923828125E+04, -.1364332031250E+04, .1027591796875E+04},
 {    1998, .8285606445312E+04, -.1364332031250E+04, .1028630371094E+04},
 {    1999, .8287716796875E+04, -.1364332031250E+04, .1026293579102E+04},
 {    2000, .8285188476562E+04, -.1364332031250E+04, .1026033569336E+04},
 {    2001, .8288184570312E+04, -.1364332031250E+04, .1025065185547E+04},
 {    2002, .8286127929688E+04, -.1364332031250E+04, .1023576171875E+04},
 {    2003, .8289204101562E+04, -.1364332031250E+04, .1024235595703E+04},
 {    2004, .8288166015625E+04, -.1364332031250E+04, .1021918090820E+04},
 {    2005, .8287923828125E+04, -.1374492065430E+04, .1027591796875E+04},
 {    2006, .8285606445312E+04, -.1374492065430E+04, .1028630371094E+04},
 {    2007, .8287716796875E+04, -.1374492065430E+04, .1026293579102E+04},
 {    2008, .8285188476562E+04, -.1374492065430E+04, .1026033569336E+04},
 {    2009, .8288184570312E+04, -.1374492065430E+04, .1025065185547E+04},
 {    2010, .8286127929688E+04, -.1374492065430E+04, .1023576171875E+04},
 {    2011, .8289204101562E+04, -.1374492065430E+04, .1024235595703E+04},
 {    2012, .8288166015625E+04, -.1374492065430E+04, .1021918090820E+04},
 {    2013, .8289083984375E+04, -.1384652099609E+04, .1027073120117E+04},
 {    2014, .8285606445312E+04, -.1384652099609E+04, .1028630371094E+04},
 {    2015, .8287716796875E+04, -.1384652099609E+04, .1026293579102E+04},
 {    2016, .8285188476562E+04, -.1384652099609E+04, .1026033569336E+04},
 {    2017, .8288184570312E+04, -.1384652099609E+04, .1025065185547E+04},
 {    2018, .8286127929688E+04, -.1384652099609E+04, .1023576171875E+04},
 {    2019, .8289204101562E+04, -.1384652099609E+04, .1024235595703E+04},
 {    2020, .8288166015625E+04, -.1384652099609E+04, .1021918090820E+04},
 {    2021, .8290504882812E+04, -.1295752075195E+04, .1024027343750E+04},
 {    2022, .8290762695312E+04, -.1295752075195E+04, .1021500854492E+04},
 {    2023, .8291729492188E+04, -.1295752075195E+04, .1024496582031E+04},
 {    2024, .8293221679688E+04, -.1295752075195E+04, .1022438232422E+04},
 {    2025, .8292560546875E+04, -.1295752075195E+04, .1025516601562E+04},
 {    2026, .8294878906250E+04, -.1295752075195E+04, .1024478881836E+04},
 {    2027, .8292769531250E+04, -.1295752075195E+04, .1026814575195E+04},
 {    2028, .8295294921875E+04, -.1295752075195E+04, .1027074951172E+04},
 {    2029, .8292300781250E+04, -.1295752075195E+04, .1028042968750E+04},
 {    2030, .8294360351562E+04, -.1295752075195E+04, .1029531738281E+04},
 {    2031, .8291280273438E+04, -.1295752075195E+04, .1028872314453E+04},
 {    2032, .8292318359375E+04, -.1295752075195E+04, .1031190917969E+04},
 {    2033, .8290504882812E+04, -.1310357055664E+04, .1024027343750E+04},
 {    2034, .8290762695312E+04, -.1310357055664E+04, .1021500854492E+04},
 {    2035, .8291729492188E+04, -.1310357055664E+04, .1024496582031E+04},
 {    2036, .8293221679688E+04, -.1310357055664E+04, .1022438232422E+04},
 {    2037, .8292560546875E+04, -.1310357055664E+04, .1025516601562E+04},
 {    2038, .8294878906250E+04, -.1310357055664E+04, .1024478881836E+04},
 {    2039, .8292769531250E+04, -.1310357055664E+04, .1026814575195E+04},
 {    2040, .8295294921875E+04, -.1310357055664E+04, .1027074951172E+04},
 {    2041, .8292300781250E+04, -.1310357055664E+04, .1028042968750E+04},
 {    2042, .8294360351562E+04, -.1310357055664E+04, .1029531738281E+04},
 {    2043, .8291280273438E+04, -.1310357055664E+04, .1028872314453E+04},
 {    2044, .8292318359375E+04, -.1310357055664E+04, .1031190917969E+04},
 {    2045, .8290504882812E+04, -.1324962036133E+04, .1024027343750E+04},
 {    2046, .8290762695312E+04, -.1324962036133E+04, .1021500854492E+04},
 {    2047, .8291729492188E+04, -.1324962036133E+04, .1024496582031E+04},
 {    2048, .8293221679688E+04, -.1324962036133E+04, .1022438232422E+04},
 {    2049, .8292560546875E+04, -.1324962036133E+04, .1025516601562E+04},
 {    2050, .8294878906250E+04, -.1324962036133E+04, .1024478881836E+04},
 {    2051, .8292769531250E+04, -.1324962036133E+04, .1026814575195E+04},
 {    2052, .8295294921875E+04, -.1324962036133E+04, .1027074951172E+04},
 {    2053, .8292300781250E+04, -.1324962036133E+04, .1028042968750E+04},
 {    2054, .8294360351562E+04, -.1324962036133E+04, .1029531738281E+04},
 {    2055, .8291280273438E+04, -.1324962036133E+04, .1028872314453E+04},
 {    2056, .8292318359375E+04, -.1324962036133E+04, .1031190917969E+04},
 {    2057, .8290504882812E+04, -.1339567016602E+04, .1024027343750E+04},
 {    2058, .8290762695312E+04, -.1339567016602E+04, .1021500854492E+04},
 {    2059, .8291729492188E+04, -.1339567016602E+04, .1024496582031E+04},
 {    2060, .8293221679688E+04, -.1339567016602E+04, .1022438232422E+04},
 {    2061, .8292560546875E+04, -.1339567016602E+04, .1025516601562E+04},
 {    2062, .8294878906250E+04, -.1339567016602E+04, .1024478881836E+04},
 {    2063, .8292769531250E+04, -.1339567016602E+04, .1026814575195E+04},
 {    2064, .8295294921875E+04, -.1339567016602E+04, .1027074951172E+04},
 {    2065, .8292300781250E+04, -.1339567016602E+04, .1028042968750E+04},
 {    2066, .8294360351562E+04, -.1339567016602E+04, .1029531738281E+04},
 {    2067, .8291280273438E+04, -.1339567016602E+04, .1028872314453E+04},
 {    2068, .8292318359375E+04, -.1339567016602E+04, .1031190917969E+04},
 {    2069, .8290504882812E+04, -.1354171997070E+04, .1024027343750E+04},
 {    2070, .8290762695312E+04, -.1354171997070E+04, .1021501098633E+04},
 {    2071, .8291729492188E+04, -.1354171997070E+04, .1024496582031E+04},
 {    2072, .8293221679688E+04, -.1354171997070E+04, .1022438232422E+04},
 {    2073, .8292560546875E+04, -.1354171997070E+04, .1025516601562E+04},
 {    2074, .8294878906250E+04, -.1354171997070E+04, .1024478881836E+04},
 {    2075, .8292769531250E+04, -.1354171997070E+04, .1026814575195E+04},
 {    2076, .8295294921875E+04, -.1354171997070E+04, .1027074951172E+04},
 {    2077, .8292300781250E+04, -.1354171997070E+04, .1028042968750E+04},
 {    2078, .8294360351562E+04, -.1354171997070E+04, .1029531738281E+04},
 {    2079, .8291280273438E+04, -.1354171997070E+04, .1028872314453E+04},
 {    2080, .8292318359375E+04, -.1354171997070E+04, .1031190917969E+04},
 {    2081, .8290504882812E+04, -.1364332031250E+04, .1024027343750E+04},
 {    2082, .8290762695312E+04, -.1364332031250E+04, .1021501098633E+04},
 {    2083, .8291729492188E+04, -.1364332031250E+04, .1024496582031E+04},
 {    2084, .8293221679688E+04, -.1364332031250E+04, .1022438232422E+04},
 {    2085, .8292560546875E+04, -.1364332031250E+04, .1025516601562E+04},
 {    2086, .8294878906250E+04, -.1364332031250E+04, .1024478881836E+04},
 {    2087, .8292769531250E+04, -.1364332031250E+04, .1026814575195E+04},
 {    2088, .8295294921875E+04, -.1364332031250E+04, .1027074951172E+04},
 {    2089, .8292300781250E+04, -.1364332031250E+04, .1028042968750E+04},
 {    2090, .8294360351562E+04, -.1364332031250E+04, .1029531738281E+04},
 {    2091, .8291280273438E+04, -.1364332031250E+04, .1028872314453E+04},
 {    2092, .8292318359375E+04, -.1364332031250E+04, .1031190917969E+04},
 {    2093, .8290504882812E+04, -.1374492065430E+04, .1024027343750E+04},
 {    2094, .8290762695312E+04, -.1374492065430E+04, .1021501098633E+04},
 {    2095, .8291729492188E+04, -.1374492065430E+04, .1024496582031E+04},
 {    2096, .8293221679688E+04, -.1374492065430E+04, .1022438232422E+04},
 {    2097, .8292560546875E+04, -.1374492065430E+04, .1025516601562E+04},
 {    2098, .8294878906250E+04, -.1374492065430E+04, .1024478881836E+04},
 {    2099, .8292769531250E+04, -.1374492065430E+04, .1026814575195E+04},
 {    2100, .8295294921875E+04, -.1374492065430E+04, .1027074951172E+04},
 {    2101, .8292300781250E+04, -.1374492065430E+04, .1028042968750E+04},
 {    2102, .8294360351562E+04, -.1374492065430E+04, .1029531738281E+04},
 {    2103, .8291280273438E+04, -.1374492065430E+04, .1028872314453E+04},
 {    2104, .8292318359375E+04, -.1374492065430E+04, .1031190917969E+04},
 {    2105, .8290504882812E+04, -.1384652099609E+04, .1024027343750E+04},
 {    2106, .8290762695312E+04, -.1384652099609E+04, .1021501098633E+04},
 {    2107, .8291729492188E+04, -.1384652099609E+04, .1024496582031E+04},
 {    2108, .8293221679688E+04, -.1384652099609E+04, .1022438232422E+04},
 {    2109, .8292560546875E+04, -.1384652099609E+04, .1025516601562E+04},
 {    2110, .8294878906250E+04, -.1384652099609E+04, .1024478881836E+04},
 {    2111, .8292769531250E+04, -.1384652099609E+04, .1026814575195E+04},
 {    2112, .8295294921875E+04, -.1384652099609E+04, .1027074951172E+04},
 {    2113, .8292300781250E+04, -.1384652099609E+04, .1028042968750E+04},
 {    2114, .8294360351562E+04, -.1384652099609E+04, .1029531738281E+04},
 {    2115, .8291280273438E+04, -.1384652099609E+04, .1028872314453E+04},
 {    2116, .8292318359375E+04, -.1384652099609E+04, .1031190917969E+04},
 {    2117, .8289981445312E+04, -.1295752075195E+04, .1029081054688E+04},
 {    2118, .8289721679688E+04, -.1295752075195E+04, .1031607421875E+04},
 {    2119, .8288752929688E+04, -.1295752075195E+04, .1028612060547E+04},
 {    2120, .8287264648438E+04, -.1295752075195E+04, .1030670043945E+04},
 {    2121, .8289981445312E+04, -.1310357055664E+04, .1029081054688E+04},
 {    2122, .8289721679688E+04, -.1310357055664E+04, .1031607421875E+04},
 {    2123, .8288752929688E+04, -.1310357055664E+04, .1028612060547E+04},
 {    2124, .8287264648438E+04, -.1310357055664E+04, .1030670043945E+04},
 {    2125, .8289981445312E+04, -.1324962036133E+04, .1029081054688E+04},
 {    2126, .8289721679688E+04, -.1324962036133E+04, .1031607421875E+04},
 {    2127, .8288752929688E+04, -.1324962036133E+04, .1028612060547E+04},
 {    2128, .8287264648438E+04, -.1324962036133E+04, .1030670043945E+04},
 {    2129, .8289981445312E+04, -.1339567016602E+04, .1029081054688E+04},
 {    2130, .8289721679688E+04, -.1339567016602E+04, .1031607421875E+04},
 {    2131, .8288752929688E+04, -.1339567016602E+04, .1028612060547E+04},
 {    2132, .8287264648438E+04, -.1339567016602E+04, .1030670043945E+04},
 {    2133, .8289981445312E+04, -.1354171997070E+04, .1029081054688E+04},
 {    2134, .8289721679688E+04, -.1354171997070E+04, .1031607421875E+04},
 {    2135, .8288752929688E+04, -.1354171997070E+04, .1028612060547E+04},
 {    2136, .8287264648438E+04, -.1354171997070E+04, .1030670043945E+04},
 {    2137, .8289981445312E+04, -.1364332031250E+04, .1029081054688E+04},
 {    2138, .8289721679688E+04, -.1364332031250E+04, .1031607421875E+04},
 {    2139, .8288752929688E+04, -.1364332031250E+04, .1028612060547E+04},
 {    2140, .8287264648438E+04, -.1364332031250E+04, .1030670043945E+04},
 {    2141, .8289981445312E+04, -.1374492065430E+04, .1029081054688E+04},
 {    2142, .8289721679688E+04, -.1374492065430E+04, .1031607421875E+04},
 {    2143, .8288752929688E+04, -.1374492065430E+04, .1028612060547E+04},
 {    2144, .8287264648438E+04, -.1374492065430E+04, .1030670043945E+04},
 {    2145, .8289981445312E+04, -.1384652099609E+04, .1029081054688E+04},
 {    2146, .8289721679688E+04, -.1384652099609E+04, .1031607421875E+04},
 {    2147, .8288752929688E+04, -.1384652099609E+04, .1028612060547E+04},
 {    2148, .8287264648438E+04, -.1384652099609E+04, .1030670043945E+04},
 {    2149, .8279115234375E+04, -.1354171997070E+04, .1031535522461E+04},
 {    2150, .8278114257812E+04, -.1354171997070E+04, .1025304443359E+04},
 {    2151, .8280364257812E+04, -.1354171997070E+04, .1019407958984E+04},
 {    2152, .8285260742188E+04, -.1354171997070E+04, .1015426330566E+04},
 {    2153, .8279115234375E+04, -.1364332031250E+04, .1031535522461E+04},
 {    2154, .8278114257812E+04, -.1364332031250E+04, .1025304443359E+04},
 {    2155, .8280364257812E+04, -.1364332031250E+04, .1019407958984E+04},
 {    2156, .8285260742188E+04, -.1364332031250E+04, .1015426330566E+04},
 {    2157, .8279115234375E+04, -.1374492065430E+04, .1031535522461E+04},
 {    2158, .8278114257812E+04, -.1374492065430E+04, .1025304443359E+04},
 {    2159, .8280364257812E+04, -.1374492065430E+04, .1019407958984E+04},
 {    2160, .8285260742188E+04, -.1374492065430E+04, .1015426330566E+04},
 {    2161, .8279115234375E+04, -.1384652099609E+04, .1031535522461E+04},
 {    2162, .8278114257812E+04, -.1384652099609E+04, .1025304443359E+04},
 {    2163, .8280364257812E+04, -.1384652099609E+04, .1019407958984E+04},
 {    2164, .8285260742188E+04, -.1384652099609E+04, .1015426330566E+04},
 {    2165, .8291492187500E+04, -.1354171997070E+04, .1014426391602E+04},
 {    2166, .8297388671875E+04, -.1354171997070E+04, .1016676269531E+04},
 {    2167, .8301370117188E+04, -.1354171997070E+04, .1021572326660E+04},
 {    2168, .8302370117188E+04, -.1354171997070E+04, .1027804077148E+04},
 {    2169, .8300122070312E+04, -.1354171997070E+04, .1033700195312E+04},
 {    2170, .8295223632812E+04, -.1354171997070E+04, .1037682006836E+04},
 {    2171, .8291492187500E+04, -.1364332031250E+04, .1014426391602E+04},
 {    2172, .8297388671875E+04, -.1364332031250E+04, .1016676269531E+04},
 {    2173, .8301370117188E+04, -.1364332031250E+04, .1021572326660E+04},
 {    2174, .8302370117188E+04, -.1364332031250E+04, .1027804077148E+04},
 {    2175, .8300122070312E+04, -.1364332031250E+04, .1033700195312E+04},
 {    2176, .8295223632812E+04, -.1364332031250E+04, .1037682006836E+04},
 {    2177, .8291492187500E+04, -.1374492065430E+04, .1014426391602E+04},
 {    2178, .8297388671875E+04, -.1374492065430E+04, .1016676269531E+04},
 {    2179, .8301370117188E+04, -.1374492065430E+04, .1021572326660E+04},
 {    2180, .8302370117188E+04, -.1374492065430E+04, .1027804077148E+04},
 {    2181, .8300122070312E+04, -.1374492065430E+04, .1033700195312E+04},
 {    2182, .8295223632812E+04, -.1374492065430E+04, .1037682006836E+04},
 {    2183, .8291492187500E+04, -.1384652099609E+04, .1014426391602E+04},
 {    2184, .8297388671875E+04, -.1384652099609E+04, .1016676269531E+04},
 {    2185, .8301370117188E+04, -.1384652099609E+04, .1021572326660E+04},
 {    2186, .8302370117188E+04, -.1384652099609E+04, .1027804077148E+04},
 {    2187, .8300122070312E+04, -.1384652099609E+04, .1033700195312E+04},
 {    2188, .8295223632812E+04, -.1384652099609E+04, .1037682006836E+04},
 {    2189, .8288993164062E+04, -.1354171997070E+04, .1038681884766E+04},
 {    2190, .8283096679688E+04, -.1354171997070E+04, .1036432006836E+04},
 {    2191, .8288993164062E+04, -.1364332031250E+04, .1038681884766E+04},
 {    2192, .8283096679688E+04, -.1364332031250E+04, .1036432006836E+04},
 {    2193, .8288993164062E+04, -.1374492065430E+04, .1038681884766E+04},
 {    2194, .8283096679688E+04, -.1374492065430E+04, .1036432006836E+04},
 {    2195, .8288993164062E+04, -.1384652099609E+04, .1038681884766E+04},
 {    2196, .8283096679688E+04, -.1384652099609E+04, .1036432006836E+04},
 {    2197, .8290245117188E+04, -.1323692016602E+04, .1026553833008E+04},
 {    2198, .8290245117188E+04, -.1248127075195E+04, .1026553833008E+04},
 {    2876, .8395313476562E+04, -.1343059570312E+04, .1042133056641E+04},
 {    2877, .8372129882812E+04, -.1348615844727E+04, .1052511230469E+04},
 {    2878, .8348947265625E+04, -.1354171997070E+04, .1062889038086E+04},
 {    2879, .8395313476562E+04, -.1354171997070E+04, .1042133056641E+04},
 {    2880, .8372129882812E+04, -.1365284545898E+04, .1052511230469E+04},
 {    2881, .8348947265625E+04, -.1376397094727E+04, .1062889038086E+04},
 {    2882, .8383637695312E+04, -.1343059570312E+04, .1016052368164E+04},
 {    2883, .8360456054688E+04, -.1348615844727E+04, .1026430297852E+04},
 {    2884, .8337271484375E+04, -.1354171997070E+04, .1036808105469E+04},
 {    2885, .8383637695312E+04, -.1354171997070E+04, .1016052368164E+04},
 {    2886, .8360456054688E+04, -.1365284545898E+04, .1026430297852E+04},
 {    2887, .8337271484375E+04, -.1376397094727E+04, .1036808105469E+04},
 {    2888, .8371962890625E+04, -.1343059570312E+04, .9899710693359E+03},
 {    2889, .8348777343750E+04, -.1348615844727E+04, .1000349548340E+04},
 {    2890, .8325596679688E+04, -.1354171997070E+04, .1010727416992E+04},
 {    2891, .8371962890625E+04, -.1354171997070E+04, .9899710693359E+03},
 {    2892, .8348777343750E+04, -.1365284545898E+04, .1000349548340E+04},
 {    2893, .8325596679688E+04, -.1376397094727E+04, .1010727416992E+04},
 {    2894, .8360286132812E+04, -.1343059570312E+04, .9638902587891E+03},
 {    2895, .8337104492188E+04, -.1348615844727E+04, .9742684326172E+03},
 {    2896, .8313920898438E+04, -.1354171997070E+04, .9846463623047E+03},
 {    2897, .8360286132812E+04, -.1354171997070E+04, .9638902587891E+03},
 {    2898, .8337104492188E+04, -.1365284545898E+04, .9742684326172E+03},
 {    2899, .8313920898438E+04, -.1376397094727E+04, .9846463623047E+03},
 {    2900, .8348611328125E+04, -.1343059570312E+04, .9378092651367E+03},
 {    2901, .8325427734375E+04, -.1348615844727E+04, .9481873168945E+03},
 {    2902, .8302246093750E+04, -.1354172119141E+04, .9585657348633E+03},
 {    2903, .8348611328125E+04, -.1354171997070E+04, .9378092651367E+03},
 {    2904, .8325427734375E+04, -.1365284545898E+04, .9481873168945E+03},
 {    2905, .8302246093750E+04, -.1376397094727E+04, .9585657348633E+03},
 {    2906, .8356454101562E+04, -.1153512084961E+04, .1073442993164E+04},
 {    2907, .8344863281250E+04, -.1153512084961E+04, .1078632080078E+04},
 {    2908, .8356520507812E+04, -.1150775634766E+04, .1073413452148E+04},
 {    2909, .8344863281250E+04, -.1149702026367E+04, .1078632080078E+04},
 {    2910, .8351264648438E+04, -.1153512084961E+04, .1061851684570E+04},
 {    2911, .8339673828125E+04, -.1153512084961E+04, .1067040649414E+04},
 {    2912, .8351333007812E+04, -.1150775634766E+04, .1061821899414E+04},
 {    2913, .8339673828125E+04, -.1149702026367E+04, .1067040649414E+04},
 {    2914, .8346075195312E+04, -.1153512084961E+04, .1050260009766E+04},
 {    2915, .8334484375000E+04, -.1153512084961E+04, .1055449218750E+04},
 {    2916, .8346143554688E+04, -.1150775634766E+04, .1050230224609E+04},
 {    2917, .8334484375000E+04, -.1149702026367E+04, .1055449218750E+04},
 {    2918, .8344782226562E+04, -.1153512084961E+04, .1047361816406E+04},
 {    2919, .8333187500000E+04, -.1153512084961E+04, .1052551025391E+04},
 {    2920, .8344845703125E+04, -.1150775634766E+04, .1047332397461E+04},
 {    2921, .8333187500000E+04, -.1149702026367E+04, .1052551025391E+04},
 {    2922, .8339590820312E+04, -.1153512084961E+04, .1035770751953E+04},
 {    2923, .8327998046875E+04, -.1153512084961E+04, .1040959594727E+04},
 {    2924, .8339656250000E+04, -.1150775634766E+04, .1035740966797E+04},
 {    2925, .8327998046875E+04, -.1149702026367E+04, .1040959594727E+04},
 {    2926, .8334400390625E+04, -.1153512084961E+04, .1024179321289E+04},
 {    2927, .8322810546875E+04, -.1153512084961E+04, .1029367919922E+04},
 {    2928, .8334469726562E+04, -.1150775634766E+04, .1024149536133E+04},
 {    2929, .8322810546875E+04, -.1149702026367E+04, .1029367919922E+04},
 {    2930, .8333103515625E+04, -.1153512084961E+04, .1021281066895E+04},
 {    2931, .8321513671875E+04, -.1153512084961E+04, .1026470092773E+04},
 {    2932, .8333168945312E+04, -.1150775634766E+04, .1021251586914E+04},
 {    2933, .8321513671875E+04, -.1149702026367E+04, .1026470092773E+04},
 {    2934, .8327915039062E+04, -.1153512084961E+04, .1009689575195E+04},
 {    2935, .8316325195312E+04, -.1153512084961E+04, .1014878845215E+04},
 {    2936, .8327980468750E+04, -.1150775634766E+04, .1009660278320E+04},
 {    2937, .8316325195312E+04, -.1149702026367E+04, .1014878845215E+04},
 {    2938, .8322724609375E+04, -.1153512084961E+04, .9980984497070E+03},
 {    2939, .8311132812500E+04, -.1153512084961E+04, .1003287475586E+04},
 {    2940, .8322793945312E+04, -.1150775634766E+04, .9980681152344E+03},
 {    2941, .8311132812500E+04, -.1149702026367E+04, .1003287475586E+04},
 {    2942, .8321427734375E+04, -.1153512084961E+04, .9951999511719E+03},
 {    2943, .8309836914062E+04, -.1153512084961E+04, .1000389099121E+04},
 {    2944, .8321496093750E+04, -.1150775634766E+04, .9951699218750E+03},
 {    2945, .8309836914062E+04, -.1149702026367E+04, .1000389099121E+04},
 {    2946, .8316240234375E+04, -.1153512084961E+04, .9836082763672E+03},
 {    2947, .8304648437500E+04, -.1153512084961E+04, .9887977294922E+03},
 {    2948, .8316306640625E+04, -.1150775634766E+04, .9835786132812E+03},
 {    2949, .8304648437500E+04, -.1149702026367E+04, .9887977294922E+03},
 {    2950, .8311048828125E+04, -.1153512084961E+04, .9720169677734E+03},
 {    2951, .8299458007812E+04, -.1153512084961E+04, .9772065429688E+03},
 {    2952, .8311118164062E+04, -.1150775634766E+04, .9719872436523E+03},
 {    2953, .8299458007812E+04, -.1149702026367E+04, .9772065429688E+03},
 {    2954, .8309751953125E+04, -.1153512084961E+04, .9691195068359E+03},
 {    2955, .8298160156250E+04, -.1153512084961E+04, .9743084106445E+03},
 {    2956, .8309819335938E+04, -.1150775634766E+04, .9690899047852E+03},
 {    2957, .8298160156250E+04, -.1149702026367E+04, .9743084106445E+03},
 {    2958, .8304563476562E+04, -.1153512084961E+04, .9575277099609E+03},
 {    2959, .8292974609375E+04, -.1153512084961E+04, .9627166748047E+03},
 {    2960, .8304630859375E+04, -.1150775634766E+04, .9574979248047E+03},
 {    2961, .8292974609375E+04, -.1149702026367E+04, .9627166748047E+03},
 {    2962, .8299374023438E+04, -.1153512084961E+04, .9459361572266E+03},
 {    2963, .8287781250000E+04, -.1153512084961E+04, .9511254882812E+03},
 {    2964, .8299442382812E+04, -.1150775634766E+04, .9459061279297E+03},
 {    2965, .8287781250000E+04, -.1149702026367E+04, .9511254882812E+03},
 {    2966, .8333272460938E+04, -.1153512084961E+04, .1083821044922E+04},
 {    2967, .8321680664062E+04, -.1153512084961E+04, .1089010131836E+04},
 {    2968, .8333272460938E+04, -.1149702026367E+04, .1083821044922E+04},
 {    2969, .8321680664062E+04, -.1149702026367E+04, .1089010131836E+04},
 {    2970, .8328083007812E+04, -.1153512084961E+04, .1072229858398E+04},
 {    2971, .8316491210938E+04, -.1153512084961E+04, .1077418945312E+04},
 {    2972, .8328083007812E+04, -.1149702026367E+04, .1072229858398E+04},
 {    2973, .8316491210938E+04, -.1149702026367E+04, .1077418945312E+04},
 {    2974, .8322892578125E+04, -.1153512084961E+04, .1060638183594E+04},
 {    2975, .8311302734375E+04, -.1153512084961E+04, .1065827270508E+04},
 {    2976, .8322892578125E+04, -.1149702026367E+04, .1060638183594E+04},
 {    2977, .8311302734375E+04, -.1149702026367E+04, .1065827270508E+04},
 {    2978, .8321595703125E+04, -.1153512084961E+04, .1057740356445E+04},
 {    2979, .8310006835938E+04, -.1153512084961E+04, .1062929321289E+04},
 {    2980, .8321595703125E+04, -.1149702026367E+04, .1057740356445E+04},
 {    2981, .8310006835938E+04, -.1149702026367E+04, .1062929321289E+04},
 {    2982, .8316409179688E+04, -.1153512084961E+04, .1046148437500E+04},
 {    2983, .8304816406250E+04, -.1153512084961E+04, .1051337646484E+04},
 {    2984, .8316409179688E+04, -.1149702026367E+04, .1046148437500E+04},
 {    2985, .8304816406250E+04, -.1149702026367E+04, .1051337646484E+04},
 {    2986, .8311216796875E+04, -.1153512084961E+04, .1034557128906E+04},
 {    2987, .8299626953125E+04, -.1153512084961E+04, .1039746093750E+04},
 {    2988, .8311216796875E+04, -.1149702026367E+04, .1034557128906E+04},
 {    2989, .8299626953125E+04, -.1149702026367E+04, .1039746093750E+04},
 {    2990, .8309919921875E+04, -.1153512084961E+04, .1031659179688E+04},
 {    2991, .8298330078125E+04, -.1153512084961E+04, .1036848388672E+04},
 {    2992, .8309919921875E+04, -.1149702026367E+04, .1031659179688E+04},
 {    2993, .8298330078125E+04, -.1149702026367E+04, .1036848388672E+04},
 {    2994, .8304731445312E+04, -.1153512084961E+04, .1020067871094E+04},
 {    2995, .8293141601562E+04, -.1153512084961E+04, .1025256958008E+04},
 {    2996, .8304731445312E+04, -.1149702026367E+04, .1020067871094E+04},
 {    2997, .8293141601562E+04, -.1149702026367E+04, .1025256958008E+04},
 {    2998, .8299541992188E+04, -.1153512084961E+04, .1008476074219E+04},
 {    2999, .8287951171875E+04, -.1153512084961E+04, .1013665771484E+04},
 {    3000, .8299541992188E+04, -.1149702026367E+04, .1008476074219E+04},
 {    3001, .8287951171875E+04, -.1149702026367E+04, .1013665771484E+04},
 {    3002, .8298244140625E+04, -.1153512084961E+04, .1005578613281E+04},
 {    3003, .8286653320312E+04, -.1153512084961E+04, .1010767395020E+04},
 {    3004, .8298244140625E+04, -.1149702026367E+04, .1005578613281E+04},
 {    3005, .8286653320312E+04, -.1149702026367E+04, .1010767395020E+04},
 {    3006, .8293055664062E+04, -.1153512084961E+04, .9939868164062E+03},
 {    3007, .8281464843750E+04, -.1153512084961E+04, .9991757812500E+03},
 {    3008, .8293055664062E+04, -.1149702026367E+04, .9939868164062E+03},
 {    3009, .8281464843750E+04, -.1149702026367E+04, .9991757812500E+03},
 {    3010, .8287866210938E+04, -.1153512084961E+04, .9823952636719E+03},
 {    3011, .8276275390625E+04, -.1153512084961E+04, .9875843505859E+03},
 {    3012, .8287866210938E+04, -.1149702026367E+04, .9823952636719E+03},
 {    3013, .8276275390625E+04, -.1149702026367E+04, .9875843505859E+03},
 {    3014, .8286571289062E+04, -.1153512084961E+04, .9794973144531E+03},
 {    3015, .8274979492188E+04, -.1153512084961E+04, .9846864624023E+03},
 {    3016, .8286571289062E+04, -.1149702026367E+04, .9794973144531E+03},
 {    3017, .8274979492188E+04, -.1149702026367E+04, .9846864624023E+03},
 {    3018, .8281380859375E+04, -.1153512084961E+04, .9679062500000E+03},
 {    3019, .8269791015625E+04, -.1153512084961E+04, .9730949707031E+03},
 {    3020, .8281380859375E+04, -.1149702026367E+04, .9679062500000E+03},
 {    3021, .8269791015625E+04, -.1149702026367E+04, .9730949707031E+03},
 {    3022, .8276192382812E+04, -.1153512084961E+04, .9563143310547E+03},
 {    3023, .8264600585938E+04, -.1153512084961E+04, .9615036621094E+03},
 {    3024, .8276192382812E+04, -.1149702026367E+04, .9563143310547E+03},
 {    3025, .8264600585938E+04, -.1149702026367E+04, .9615036621094E+03},
 {    3026, .8310089843750E+04, -.1153512084961E+04, .1094199707031E+04},
 {    3027, .8309917968750E+04, -.1150696289062E+04, .1094276123047E+04},
 {    3028, .8304899414062E+04, -.1153512084961E+04, .1082608154297E+04},
 {    3029, .8304728515625E+04, -.1150696289062E+04, .1082684814453E+04},
 {    3030, .8299710937500E+04, -.1153512084961E+04, .1071016357422E+04},
 {    3031, .8299537109375E+04, -.1150696289062E+04, .1071093017578E+04},
 {    3032, .8298413085938E+04, -.1153512084961E+04, .1068118286133E+04},
 {    3033, .8298241210938E+04, -.1150696289062E+04, .1068195068359E+04},
 {    3034, .8293222656250E+04, -.1153512084961E+04, .1056526855469E+04},
 {    3035, .8293050781250E+04, -.1150696289062E+04, .1056603759766E+04},
 {    3036, .8288036132812E+04, -.1153512084961E+04, .1044935058594E+04},
 {    3037, .8287862304688E+04, -.1150696289062E+04, .1045012207031E+04},
 {    3038, .8286740234375E+04, -.1153512084961E+04, .1042037475586E+04},
 {    3039, .8286567382812E+04, -.1150696289062E+04, .1042114135742E+04},
 {    3040, .8281547851562E+04, -.1153512084961E+04, .1030446166992E+04},
 {    3041, .8281377929688E+04, -.1150696289062E+04, .1030522705078E+04},
 {    3042, .8276358398438E+04, -.1153512084961E+04, .1018854675293E+04},
 {    3043, .8276186523438E+04, -.1150696289062E+04, .1018931396484E+04},
 {    3044, .8275063476562E+04, -.1153512084961E+04, .1015956665039E+04},
 {    3045, .8274890625000E+04, -.1150696289062E+04, .1016033325195E+04},
 {    3046, .8269874023438E+04, -.1153512084961E+04, .1004364807129E+04},
 {    3047, .8269702148438E+04, -.1150696289062E+04, .1004441650391E+04},
 {    3048, .8264683593750E+04, -.1153512084961E+04, .9927739257812E+03},
 {    3049, .8264510742188E+04, -.1150696289062E+04, .9928507080078E+03},
 {    3050, .8263387695312E+04, -.1153512084961E+04, .9898752441406E+03},
 {    3051, .8263213867188E+04, -.1150696289062E+04, .9899526367188E+03},
 {    3052, .8258200195312E+04, -.1153512084961E+04, .9782839355469E+03},
 {    3053, .8258027343750E+04, -.1150696289062E+04, .9783605957031E+03},
 {    3054, .8253008789062E+04, -.1153512084961E+04, .9666925048828E+03},
 {    3055, .8252834960938E+04, -.1150696289062E+04, .9667696533203E+03},
 {    3056, .8310089843750E+04, -.1417671997070E+04, .1094199707031E+04},
 {    3057, .8321680664062E+04, -.1417671997070E+04, .1089010131836E+04},
 {    3058, .8310121093750E+04, -.1420615112305E+04, .1094184814453E+04},
 {    3059, .8321680664062E+04, -.1421482055664E+04, .1089010131836E+04},
 {    3060, .8304899414062E+04, -.1417671997070E+04, .1082608154297E+04},
 {    3061, .8316491210938E+04, -.1417671997070E+04, .1077418945312E+04},
 {    3062, .8304932617188E+04, -.1420615112305E+04, .1082593261719E+04},
 {    3063, .8316491210938E+04, -.1421482055664E+04, .1077418945312E+04},
 {    3064, .8299710937500E+04, -.1417671997070E+04, .1071016357422E+04},
 {    3065, .8311302734375E+04, -.1417671997070E+04, .1065827270508E+04},
 {    3066, .8299743164062E+04, -.1420615112305E+04, .1071002075195E+04},
 {    3067, .8311302734375E+04, -.1421482055664E+04, .1065827270508E+04},
 {    3068, .8298413085938E+04, -.1417671997070E+04, .1068118286133E+04},
 {    3069, .8310006835938E+04, -.1417671997070E+04, .1062929321289E+04},
 {    3070, .8298444335938E+04, -.1420615112305E+04, .1068104248047E+04},
 {    3071, .8310006835938E+04, -.1421482055664E+04, .1062929321289E+04},
 {    3072, .8293222656250E+04, -.1417671997070E+04, .1056526855469E+04},
 {    3073, .8304816406250E+04, -.1417671997070E+04, .1051337890625E+04},
 {    3074, .8293255859375E+04, -.1420615112305E+04, .1056512939453E+04},
 {    3075, .8304816406250E+04, -.1421482055664E+04, .1051337890625E+04},
 {    3076, .8288036132812E+04, -.1417671997070E+04, .1044935058594E+04},
 {    3077, .8299626953125E+04, -.1417671997070E+04, .1039746093750E+04},
 {    3078, .8288067382812E+04, -.1420615112305E+04, .1044921020508E+04},
 {    3079, .8299626953125E+04, -.1421482055664E+04, .1039746093750E+04},
 {    3080, .8286740234375E+04, -.1417671997070E+04, .1042037475586E+04},
 {    3081, .8298330078125E+04, -.1417671997070E+04, .1036848388672E+04},
 {    3082, .8286768554688E+04, -.1420615112305E+04, .1042023193359E+04},
 {    3083, .8298330078125E+04, -.1421482055664E+04, .1036848388672E+04},
 {    3084, .8281547851562E+04, -.1417671997070E+04, .1030446166992E+04},
 {    3085, .8293141601562E+04, -.1417671997070E+04, .1025256958008E+04},
 {    3086, .8281580078125E+04, -.1420615112305E+04, .1030432128906E+04},
 {    3087, .8293141601562E+04, -.1421482055664E+04, .1025256958008E+04},
 {    3088, .8276358398438E+04, -.1417671997070E+04, .1018854675293E+04},
 {    3089, .8287951171875E+04, -.1417671997070E+04, .1013665771484E+04},
 {    3090, .8276393554688E+04, -.1420615112305E+04, .1018839904785E+04},
 {    3091, .8287951171875E+04, -.1421482055664E+04, .1013665771484E+04},
 {    3092, .8275063476562E+04, -.1417671997070E+04, .1015956665039E+04},
 {    3093, .8286653320312E+04, -.1417671997070E+04, .1010767395020E+04},
 {    3094, .8275093750000E+04, -.1420615112305E+04, .1015942138672E+04},
 {    3095, .8286653320312E+04, -.1421482055664E+04, .1010767395020E+04},
 {    3096, .8269874023438E+04, -.1417671997070E+04, .1004364807129E+04},
 {    3097, .8281464843750E+04, -.1417671997070E+04, .9991757812500E+03},
 {    3098, .8269904296875E+04, -.1420615112305E+04, .1004350830078E+04},
 {    3099, .8281464843750E+04, -.1421482055664E+04, .9991757812500E+03},
 {    3100, .8264683593750E+04, -.1417671997070E+04, .9927739257812E+03},
 {    3101, .8276275390625E+04, -.1417671997070E+04, .9875843505859E+03},
 {    3102, .8264715820312E+04, -.1420615112305E+04, .9927590942383E+03},
 {    3103, .8276275390625E+04, -.1421482055664E+04, .9875843505859E+03},
 {    3104, .8263387695312E+04, -.1417671997070E+04, .9898752441406E+03},
 {    3105, .8274979492188E+04, -.1417671997070E+04, .9846864624023E+03},
 {    3106, .8263417968750E+04, -.1420615112305E+04, .9898618164062E+03},
 {    3107, .8274979492188E+04, -.1421482055664E+04, .9846864624023E+03},
 {    3108, .8258200195312E+04, -.1417671997070E+04, .9782839355469E+03},
 {    3109, .8269791015625E+04, -.1417671997070E+04, .9730949707031E+03},
 {    3110, .8258229492188E+04, -.1420615112305E+04, .9782700195312E+03},
 {    3111, .8269791015625E+04, -.1421482055664E+04, .9730949707031E+03},
 {    3112, .8253008789062E+04, -.1417671997070E+04, .9666925048828E+03},
 {    3113, .8264600585938E+04, -.1417671997070E+04, .9615036621094E+03},
 {    3114, .8253041015625E+04, -.1420615112305E+04, .9666783447266E+03},
 {    3115, .8264600585938E+04, -.1421482055664E+04, .9615036621094E+03},
 {    3116, .8333272460938E+04, -.1417671997070E+04, .1083821044922E+04},
 {    3117, .8344863281250E+04, -.1417671997070E+04, .1078632080078E+04},
 {    3118, .8333272460938E+04, -.1421482055664E+04, .1083821044922E+04},
 {    3119, .8344863281250E+04, -.1421482055664E+04, .1078632080078E+04},
 {    3120, .8328083007812E+04, -.1417671997070E+04, .1072229858398E+04},
 {    3121, .8339673828125E+04, -.1417671997070E+04, .1067040893555E+04},
 {    3122, .8328083007812E+04, -.1421482055664E+04, .1072229858398E+04},
 {    3123, .8339673828125E+04, -.1421482055664E+04, .1067040893555E+04},
 {    3124, .8322892578125E+04, -.1417671997070E+04, .1060638183594E+04},
 {    3125, .8334484375000E+04, -.1417671997070E+04, .1055449218750E+04},
 {    3126, .8322892578125E+04, -.1421482055664E+04, .1060638183594E+04},
 {    3127, .8334484375000E+04, -.1421482055664E+04, .1055449218750E+04},
 {    3128, .8321595703125E+04, -.1417671997070E+04, .1057740356445E+04},
 {    3129, .8333187500000E+04, -.1417671997070E+04, .1052551025391E+04},
 {    3130, .8321595703125E+04, -.1421482055664E+04, .1057740356445E+04},
 {    3131, .8333187500000E+04, -.1421482055664E+04, .1052551025391E+04},
 {    3132, .8316409179688E+04, -.1417671997070E+04, .1046148437500E+04},
 {    3133, .8327998046875E+04, -.1417671997070E+04, .1040959594727E+04},
 {    3134, .8316409179688E+04, -.1421482055664E+04, .1046148437500E+04},
 {    3135, .8327998046875E+04, -.1421482055664E+04, .1040959594727E+04},
 {    3136, .8311216796875E+04, -.1417671997070E+04, .1034557128906E+04},
 {    3137, .8322810546875E+04, -.1417671997070E+04, .1029367919922E+04},
 {    3138, .8311216796875E+04, -.1421482055664E+04, .1034557128906E+04},
 {    3139, .8322810546875E+04, -.1421482055664E+04, .1029367919922E+04},
 {    3140, .8309919921875E+04, -.1417671997070E+04, .1031659423828E+04},
 {    3141, .8321513671875E+04, -.1417671997070E+04, .1026470336914E+04},
 {    3142, .8309919921875E+04, -.1421482055664E+04, .1031659423828E+04},
 {    3143, .8321513671875E+04, -.1421482055664E+04, .1026470336914E+04},
 {    3144, .8304731445312E+04, -.1417671997070E+04, .1020067871094E+04},
 {    3145, .8316325195312E+04, -.1417671997070E+04, .1014878845215E+04},
 {    3146, .8304731445312E+04, -.1421482055664E+04, .1020067871094E+04},
 {    3147, .8316325195312E+04, -.1421482055664E+04, .1014878845215E+04},
 {    3148, .8299541992188E+04, -.1417671997070E+04, .1008476074219E+04},
 {    3149, .8311132812500E+04, -.1417671997070E+04, .1003287475586E+04},
 {    3150, .8299541992188E+04, -.1421482055664E+04, .1008476074219E+04},
 {    3151, .8311132812500E+04, -.1421482055664E+04, .1003287475586E+04},
 {    3152, .8298244140625E+04, -.1417671997070E+04, .1005578613281E+04},
 {    3153, .8309836914062E+04, -.1417671997070E+04, .1000389099121E+04},
 {    3154, .8298244140625E+04, -.1421482055664E+04, .1005578613281E+04},
 {    3155, .8309836914062E+04, -.1421482055664E+04, .1000389099121E+04},
 {    3156, .8293055664062E+04, -.1417671997070E+04, .9939868164062E+03},
 {    3157, .8304648437500E+04, -.1417671997070E+04, .9887977294922E+03},
 {    3158, .8293055664062E+04, -.1421482055664E+04, .9939868164062E+03},
 {    3159, .8304648437500E+04, -.1421482055664E+04, .9887977294922E+03},
 {    3160, .8287866210938E+04, -.1417671997070E+04, .9823955078125E+03},
 {    3161, .8299458007812E+04, -.1417671997070E+04, .9772065429688E+03},
 {    3162, .8287866210938E+04, -.1421482055664E+04, .9823955078125E+03},
 {    3163, .8299458007812E+04, -.1421482055664E+04, .9772065429688E+03},
 {    3164, .8286571289062E+04, -.1417671997070E+04, .9794973144531E+03},
 {    3165, .8298160156250E+04, -.1417671997070E+04, .9743084106445E+03},
 {    3166, .8286571289062E+04, -.1421482055664E+04, .9794973144531E+03},
 {    3167, .8298160156250E+04, -.1421482055664E+04, .9743084106445E+03},
 {    3168, .8281380859375E+04, -.1417671997070E+04, .9679062500000E+03},
 {    3169, .8292974609375E+04, -.1417671997070E+04, .9627166748047E+03},
 {    3170, .8281380859375E+04, -.1421482055664E+04, .9679062500000E+03},
 {    3171, .8292974609375E+04, -.1421482055664E+04, .9627166748047E+03},
 {    3172, .8276192382812E+04, -.1417671997070E+04, .9563143310547E+03},
 {    3173, .8287782226562E+04, -.1417671997070E+04, .9511254882812E+03},
 {    3174, .8276192382812E+04, -.1421482055664E+04, .9563143310547E+03},
 {    3175, .8287782226562E+04, -.1421482055664E+04, .9511254882812E+03},
 {    3176, .8356454101562E+04, -.1417671997070E+04, .1073442993164E+04},
 {    3177, .8356752929688E+04, -.1420387207031E+04, .1073309326172E+04},
 {    3178, .8351264648438E+04, -.1417671997070E+04, .1061851684570E+04},
 {    3179, .8351563476562E+04, -.1420387207031E+04, .1061718261719E+04},
 {    3180, .8346075195312E+04, -.1417671997070E+04, .1050260009766E+04},
 {    3181, .8346373046875E+04, -.1420387207031E+04, .1050126708984E+04},
 {    3182, .8344782226562E+04, -.1417671997070E+04, .1047361816406E+04},
 {    3183, .8345077148438E+04, -.1420387207031E+04, .1047229003906E+04},
 {    3184, .8339590820312E+04, -.1417671997070E+04, .1035770751953E+04},
 {    3185, .8339888671875E+04, -.1420387207031E+04, .1035637451172E+04},
 {    3186, .8334400390625E+04, -.1417671997070E+04, .1024179321289E+04},
 {    3187, .8334699218750E+04, -.1420387207031E+04, .1024045654297E+04},
 {    3188, .8333103515625E+04, -.1417671997070E+04, .1021281066895E+04},
 {    3189, .8333401367188E+04, -.1420387207031E+04, .1021148071289E+04},
 {    3190, .8327915039062E+04, -.1417671997070E+04, .1009689575195E+04},
 {    3191, .8328213867188E+04, -.1420387207031E+04, .1009556274414E+04},
 {    3192, .8322724609375E+04, -.1417671997070E+04, .9980984497070E+03},
 {    3193, .8323023437500E+04, -.1420387207031E+04, .9979649658203E+03},
 {    3194, .8321426757812E+04, -.1417671997070E+04, .9952003173828E+03},
 {    3195, .8321725585938E+04, -.1420387207031E+04, .9950671386719E+03},
 {    3196, .8316240234375E+04, -.1417671997070E+04, .9836082763672E+03},
 {    3197, .8316538085938E+04, -.1420387207031E+04, .9834755859375E+03},
 {    3198, .8311048828125E+04, -.1417671997070E+04, .9720169677734E+03},
 {    3199, .8311348632812E+04, -.1420387207031E+04, .9718837280273E+03},
 {    3200, .8309751953125E+04, -.1417671997070E+04, .9691195068359E+03},
 {    3201, .8310051757812E+04, -.1420387207031E+04, .9689860839844E+03},
 {    3202, .8304563476562E+04, -.1417671997070E+04, .9575277099609E+03},
 {    3203, .8304861328125E+04, -.1420387207031E+04, .9573945312500E+03},
 {    3204, .8299374023438E+04, -.1417671997070E+04, .9459361572266E+03},
 {    3205, .8299671875000E+04, -.1420387207031E+04, .9458029785156E+03},
 {    3206, .8414109375000E+04, -.1196710449219E+04, .1047633666992E+04},
 {    3207, .8404593750000E+04, -.1181935180664E+04, .1051893066406E+04},
 {    3208, .8394711914062E+04, -.1171106323242E+04, .1056317016602E+04},
 {    3209, .8383438476562E+04, -.1163107421875E+04, .1061363769531E+04},
 {    3210, .8415550781250E+04, -.1193971191406E+04, .1046988159180E+04},
 {    3211, .8406066406250E+04, -.1179587768555E+04, .1051234130859E+04},
 {    3212, .8396022460938E+04, -.1169240722656E+04, .1055729980469E+04},
 {    3213, .8384544921875E+04, -.1160875366211E+04, .1060868408203E+04},
 {    3214, .8408918945312E+04, -.1196710449219E+04, .1036042602539E+04},
 {    3215, .8399406250000E+04, -.1181935180664E+04, .1040301025391E+04},
 {    3216, .8389521484375E+04, -.1171106323242E+04, .1044725463867E+04},
 {    3217, .8378250000000E+04, -.1163107421875E+04, .1049771972656E+04},
 {    3218, .8410363281250E+04, -.1193971191406E+04, .1035395629883E+04},
 {    3219, .8400876953125E+04, -.1179587768555E+04, .1039642456055E+04},
 {    3220, .8390833007812E+04, -.1169240722656E+04, .1044138427734E+04},
 {    3221, .8379357421875E+04, -.1160875366211E+04, .1049276977539E+04},
 {    3222, .8403730468750E+04, -.1196710449219E+04, .1024450805664E+04},
 {    3223, .8394214843750E+04, -.1181935180664E+04, .1028709594727E+04},
 {    3224, .8384333007812E+04, -.1171106323242E+04, .1033134155273E+04},
 {    3225, .8373059570312E+04, -.1163107421875E+04, .1038180786133E+04},
 {    3226, .8405173828125E+04, -.1193971191406E+04, .1023804321289E+04},
 {    3227, .8395687500000E+04, -.1179587768555E+04, .1028051269531E+04},
 {    3228, .8385645507812E+04, -.1169240722656E+04, .1032546875000E+04},
 {    3229, .8374166992188E+04, -.1160875366211E+04, .1037685302734E+04},
 {    3230, .8402432617188E+04, -.1196710449219E+04, .1021553100586E+04},
 {    3231, .8392916992188E+04, -.1181935180664E+04, .1025811889648E+04},
 {    3232, .8383035156250E+04, -.1171106323242E+04, .1030236694336E+04},
 {    3233, .8371762695312E+04, -.1163107421875E+04, .1035282348633E+04},
 {    3234, .8403874023438E+04, -.1193971191406E+04, .1020906982422E+04},
 {    3235, .8394391601562E+04, -.1179587768555E+04, .1025153076172E+04},
 {    3236, .8384346679688E+04, -.1169240722656E+04, .1029648803711E+04},
 {    3237, .8372871093750E+04, -.1160875366211E+04, .1034787597656E+04},
 {    3238, .8397244140625E+04, -.1196710449219E+04, .1009961181641E+04},
 {    3239, .8387728515625E+04, -.1181935180664E+04, .1014220214844E+04},
 {    3240, .8377846679688E+04, -.1171106323242E+04, .1018644836426E+04},
 {    3241, .8366573242188E+04, -.1163107421875E+04, .1023691284180E+04},
 {    3242, .8398685546875E+04, -.1193971191406E+04, .1009315063477E+04},
 {    3243, .8389201171875E+04, -.1179587768555E+04, .1013561523438E+04},
 {    3244, .8379159179688E+04, -.1169240722656E+04, .1018057434082E+04},
 {    3245, .8367679687500E+04, -.1160875366211E+04, .1023195800781E+04},
 {    3246, .8392054687500E+04, -.1196710449219E+04, .9983700561523E+03},
 {    3247, .8382541015625E+04, -.1181935180664E+04, .1002628540039E+04},
 {    3248, .8372656250000E+04, -.1171106323242E+04, .1007053344727E+04},
 {    3249, .8361383789062E+04, -.1163107421875E+04, .1012099426270E+04},
 {    3250, .8393499023438E+04, -.1193971191406E+04, .9977236328125E+03},
 {    3251, .8384011718750E+04, -.1179587768555E+04, .1001970092773E+04},
 {    3252, .8373969726562E+04, -.1169240722656E+04, .1006465942383E+04},
 {    3253, .8362491210938E+04, -.1160875366211E+04, .1011604553223E+04},
 {    3254, .8390756835938E+04, -.1196710449219E+04, .9954720458984E+03},
 {    3255, .8381243164062E+04, -.1181935180664E+04, .9997308349609E+03},
 {    3256, .8371360351562E+04, -.1171106323242E+04, .1004155212402E+04},
 {    3257, .8360087890625E+04, -.1163107421875E+04, .1009201477051E+04},
 {    3258, .8392202148438E+04, -.1193971191406E+04, .9948258056641E+03},
 {    3259, .8382714843750E+04, -.1179587768555E+04, .9990728149414E+03},
 {    3260, .8372671875000E+04, -.1169240722656E+04, .1003568115234E+04},
 {    3261, .8361193359375E+04, -.1160875366211E+04, .1008706420898E+04},
 {    3262, .8385566406250E+04, -.1196710449219E+04, .9838812255859E+03},
 {    3263, .8376055664062E+04, -.1181935180664E+04, .9881390991211E+03},
 {    3264, .8366171875000E+04, -.1171106323242E+04, .9925639648438E+03},
 {    3265, .8354898437500E+04, -.1163107421875E+04, .9976102294922E+03},
 {    3266, .8387011718750E+04, -.1193971191406E+04, .9832340087891E+03},
 {    3267, .8377526367188E+04, -.1179587768555E+04, .9874804687500E+03},
 {    3268, .8367482421875E+04, -.1169240722656E+04, .9919765014648E+03},
 {    3269, .8356003906250E+04, -.1160875366211E+04, .9971148071289E+03},
 {    3270, .8380380859375E+04, -.1196710449219E+04, .9722885742188E+03},
 {    3271, .8370866210938E+04, -.1181935180664E+04, .9765481567383E+03},
 {    3272, .8360981445312E+04, -.1171106323242E+04, .9809725341797E+03},
 {    3273, .8349708984375E+04, -.1163107421875E+04, .9860187988281E+03},
 {    3274, .8381824218750E+04, -.1193971191406E+04, .9716420898438E+03},
 {    3275, .8372334960938E+04, -.1179587890625E+04, .9758894042969E+03},
 {    3276, .8362293945312E+04, -.1169240722656E+04, .9803850097656E+03},
 {    3277, .8350816406250E+04, -.1160875366211E+04, .9855231323242E+03},
 {    3278, .8379081054688E+04, -.1196710449219E+04, .9693909912109E+03},
 {    3279, .8369567382812E+04, -.1181935180664E+04, .9736498413086E+03},
 {    3280, .8359683593750E+04, -.1171106323242E+04, .9780749511719E+03},
 {    3281, .8348412109375E+04, -.1163107421875E+04, .9831212158203E+03},
 {    3282, .8380524414062E+04, -.1193971191406E+04, .9687448730469E+03},
 {    3283, .8371040039062E+04, -.1179587890625E+04, .9729910888672E+03},
 {    3284, .8360996093750E+04, -.1169240722656E+04, .9774871826172E+03},
 {    3285, .8349520507812E+04, -.1160875366211E+04, .9826252441406E+03},
 {    3286, .8373892578125E+04, -.1196710449219E+04, .9577994384766E+03},
 {    3287, .8364378906250E+04, -.1181935180664E+04, .9620584106445E+03},
 {    3288, .8354495117188E+04, -.1171106323242E+04, .9664827880859E+03},
 {    3289, .8343223632812E+04, -.1163107421875E+04, .9715290527344E+03},
 {    3290, .8375336914062E+04, -.1193971191406E+04, .9571532592773E+03},
 {    3291, .8365851562500E+04, -.1179587890625E+04, .9613994140625E+03},
 {    3292, .8355807617188E+04, -.1169240722656E+04, .9658959350586E+03},
 {    3293, .8344329101562E+04, -.1160875366211E+04, .9710339965820E+03},
 {    3294, .8368704101562E+04, -.1196710449219E+04, .9462077636719E+03},
 {    3295, .8359191406250E+04, -.1181935180664E+04, .9504667968750E+03},
 {    3296, .8349305664062E+04, -.1171106323242E+04, .9548912963867E+03},
 {    3297, .8338034179688E+04, -.1163107421875E+04, .9599376220703E+03},
 {    3298, .8370147460938E+04, -.1193971191406E+04, .9455616455078E+03},
 {    3299, .8360660156250E+04, -.1179587890625E+04, .9498082885742E+03},
 {    3300, .8350618164062E+04, -.1169240722656E+04, .9543040161133E+03},
 {    3301, .8339141601562E+04, -.1160875366211E+04, .9594423828125E+03},
 {    3302, .8367408203125E+04, -.1196710449219E+04, .9433099365234E+03},
 {    3303, .8357893554688E+04, -.1181935180664E+04, .9475689697266E+03},
 {    3304, .8348008789062E+04, -.1171106323242E+04, .9519936523438E+03},
 {    3305, .8336736328125E+04, -.1163107421875E+04, .9570397949219E+03},
 {    3306, .8368849609375E+04, -.1193971191406E+04, .9426639404297E+03},
 {    3307, .8359364257812E+04, -.1179587890625E+04, .9469100952148E+03},
 {    3308, .8349319335938E+04, -.1169240722656E+04, .9514063110352E+03},
 {    3309, .8337843750000E+04, -.1160875366211E+04, .9565447998047E+03},
 {    3310, .8362215820312E+04, -.1196710449219E+04, .9317186279297E+03},
 {    3311, .8352705078125E+04, -.1181935180664E+04, .9359776611328E+03},
 {    3312, .8342818359375E+04, -.1171106323242E+04, .9404022216797E+03},
 {    3313, .8331548828125E+04, -.1163107421875E+04, .9454482421875E+03},
 {    3314, .8363661132812E+04, -.1193971191406E+04, .9310722656250E+03},
 {    3315, .8354176757812E+04, -.1179587890625E+04, .9353189086914E+03},
 {    3316, .8344132812500E+04, -.1169240722656E+04, .9398144531250E+03},
 {    3317, .8332654296875E+04, -.1160875366211E+04, .9449530029297E+03},
 {    3318, .8357027343750E+04, -.1196710449219E+04, .9201270751953E+03},
 {    3319, .8347515625000E+04, -.1181935180664E+04, .9243858642578E+03},
 {    3320, .8337629882812E+04, -.1171106323242E+04, .9288106689453E+03},
 {    3321, .8326359375000E+04, -.1163107421875E+04, .9338565673828E+03},
 {    3322, .8358473632812E+04, -.1193971191406E+04, .9194806518555E+03},
 {    3323, .8348985351562E+04, -.1179587890625E+04, .9237270507812E+03},
 {    3324, .8338943359375E+04, -.1169240722656E+04, .9282229614258E+03},
 {    3325, .8327464843750E+04, -.1160875366211E+04, .9333614501953E+03},
 {    3326, .8383438476562E+04, -.1408076660156E+04, .1061363769531E+04},
 {    3327, .8394711914062E+04, -.1400077758789E+04, .1056317016602E+04},
 {    3328, .8404347656250E+04, -.1389518310547E+04, .1052002807617E+04},
 {    3329, .8414927734375E+04, -.1373575683594E+04, .1047267456055E+04},
 {    3330, .8384544921875E+04, -.1410308715820E+04, .1060868408203E+04},
 {    3331, .8396022460938E+04, -.1401943359375E+04, .1055729980469E+04},
 {    3332, .8406066406250E+04, -.1391596191406E+04, .1051234130859E+04},
 {    3333, .8416159179688E+04, -.1375984741211E+04, .1046715576172E+04},
 {    3334, .8378250000000E+04, -.1408076660156E+04, .1049771972656E+04},
 {    3335, .8389521484375E+04, -.1400077758789E+04, .1044725463867E+04},
 {    3336, .8399160156250E+04, -.1389518310547E+04, .1040411010742E+04},
 {    3337, .8409739257812E+04, -.1373575683594E+04, .1035675537109E+04},
 {    3338, .8379357421875E+04, -.1410308715820E+04, .1049276977539E+04},
 {    3339, .8390834960938E+04, -.1401943359375E+04, .1044138305664E+04},
 {    3340, .8400876953125E+04, -.1391596191406E+04, .1039642456055E+04},
 {    3341, .8410970703125E+04, -.1375984741211E+04, .1035124267578E+04},
 {    3342, .8373059570312E+04, -.1408076660156E+04, .1038180786133E+04},
 {    3343, .8384333007812E+04, -.1400077758789E+04, .1033134155273E+04},
 {    3344, .8393970703125E+04, -.1389518310547E+04, .1028820068359E+04},
 {    3345, .8404549804688E+04, -.1373575683594E+04, .1024083496094E+04},
 {    3346, .8374166992188E+04, -.1410308715820E+04, .1037685302734E+04},
 {    3347, .8385645507812E+04, -.1401943359375E+04, .1032546875000E+04},
 {    3348, .8395687500000E+04, -.1391596191406E+04, .1028051269531E+04},
 {    3349, .8405781250000E+04, -.1375984741211E+04, .1023532714844E+04},
 {    3350, .8371762695312E+04, -.1408076660156E+04, .1035282348633E+04},
 {    3351, .8383035156250E+04, -.1400077758789E+04, .1030236694336E+04},
 {    3352, .8392673828125E+04, -.1389518310547E+04, .1025921142578E+04},
 {    3353, .8403252929688E+04, -.1373575683594E+04, .1021185668945E+04},
 {    3354, .8372871093750E+04, -.1410308715820E+04, .1034787597656E+04},
 {    3355, .8384346679688E+04, -.1401943359375E+04, .1029648803711E+04},
 {    3356, .8394391601562E+04, -.1391596191406E+04, .1025153076172E+04},
 {    3357, .8404485351562E+04, -.1375984741211E+04, .1020634521484E+04},
 {    3358, .8366573242188E+04, -.1408076660156E+04, .1023691284180E+04},
 {    3359, .8377846679688E+04, -.1400077758789E+04, .1018644836426E+04},
 {    3360, .8387482421875E+04, -.1389518310547E+04, .1014330566406E+04},
 {    3361, .8398064453125E+04, -.1373575683594E+04, .1009594238281E+04},
 {    3362, .8367679687500E+04, -.1410308715820E+04, .1023195800781E+04},
 {    3363, .8379159179688E+04, -.1401943359375E+04, .1018057434082E+04},
 {    3364, .8389201171875E+04, -.1391596191406E+04, .1013561523438E+04},
 {    3365, .8399293945312E+04, -.1375984741211E+04, .1009042358398E+04},
 {    3366, .8361383789062E+04, -.1408076660156E+04, .1012099426270E+04},
 {    3367, .8372656250000E+04, -.1400077758789E+04, .1007053344727E+04},
 {    3368, .8382294921875E+04, -.1389518310547E+04, .1002739135742E+04},
 {    3369, .8392873046875E+04, -.1373575683594E+04, .9980029296875E+03},
 {    3370, .8362491210938E+04, -.1410308715820E+04, .1011604553223E+04},
 {    3371, .8373969726562E+04, -.1401943359375E+04, .1006465942383E+04},
 {    3372, .8384011718750E+04, -.1391596191406E+04, .1001970092773E+04},
 {    3373, .8394105468750E+04, -.1375984741211E+04, .9974515991211E+03},
 {    3374, .8360087890625E+04, -.1408076660156E+04, .1009201477051E+04},
 {    3375, .8371360351562E+04, -.1400077758789E+04, .1004155456543E+04},
 {    3376, .8380996093750E+04, -.1389518310547E+04, .9998408813477E+03},
 {    3377, .8391576171875E+04, -.1373575683594E+04, .9951052246094E+03},
 {    3378, .8361193359375E+04, -.1410308715820E+04, .1008706420898E+04},
 {    3379, .8372671875000E+04, -.1401943359375E+04, .1003568115234E+04},
 {    3380, .8382714843750E+04, -.1391596191406E+04, .9990728149414E+03},
 {    3381, .8392807617188E+04, -.1375984741211E+04, .9945540161133E+03},
 {    3382, .8354898437500E+04, -.1408076660156E+04, .9976102294922E+03},
 {    3383, .8366171875000E+04, -.1400077758789E+04, .9925642089844E+03},
 {    3384, .8375808593750E+04, -.1389518310547E+04, .9882491455078E+03},
 {    3385, .8386387695312E+04, -.1373575683594E+04, .9835132446289E+03},
 {    3386, .8356005859375E+04, -.1410308715820E+04, .9971148681641E+03},
 {    3387, .8367482421875E+04, -.1401943359375E+04, .9919765014648E+03},
 {    3388, .8377526367188E+04, -.1391596191406E+04, .9874804687500E+03},
 {    3389, .8387620117188E+04, -.1375984741211E+04, .9829624023438E+03},
 {    3390, .8349708984375E+04, -.1408076660156E+04, .9860187988281E+03},
 {    3391, .8360981445312E+04, -.1400077880859E+04, .9809725341797E+03},
 {    3392, .8370618164062E+04, -.1389518310547E+04, .9766577148438E+03},
 {    3393, .8381199218750E+04, -.1373575683594E+04, .9719219970703E+03},
 {    3394, .8350816406250E+04, -.1410308715820E+04, .9855231323242E+03},
 {    3395, .8362293945312E+04, -.1401943359375E+04, .9803850097656E+03},
 {    3396, .8372334960938E+04, -.1391596313477E+04, .9758894042969E+03},
 {    3397, .8382429687500E+04, -.1375984741211E+04, .9713704833984E+03},
 {    3398, .8348412109375E+04, -.1408076660156E+04, .9831212158203E+03},
 {    3399, .8359683593750E+04, -.1400077880859E+04, .9780749511719E+03},
 {    3400, .8369321289062E+04, -.1389518310547E+04, .9737595214844E+03},
 {    3401, .8379900390625E+04, -.1373575683594E+04, .9690239257812E+03},
 {    3402, .8349520507812E+04, -.1410308715820E+04, .9826252441406E+03},
 {    3403, .8360996093750E+04, -.1401943359375E+04, .9774871826172E+03},
 {    3404, .8371040039062E+04, -.1391596313477E+04, .9729910888672E+03},
 {    3405, .8381133789062E+04, -.1375984741211E+04, .9684728393555E+03},
 {    3406, .8343223632812E+04, -.1408076660156E+04, .9715290527344E+03},
 {    3407, .8354495117188E+04, -.1400077880859E+04, .9664827880859E+03},
 {    3408, .8364132812500E+04, -.1389518310547E+04, .9621687011719E+03},
 {    3409, .8374713867188E+04, -.1373575683594E+04, .9574324951172E+03},
 {    3410, .8344329101562E+04, -.1410308715820E+04, .9710339965820E+03},
 {    3411, .8355807617188E+04, -.1401943359375E+04, .9658959350586E+03},
 {    3412, .8365851562500E+04, -.1391596313477E+04, .9613994140625E+03},
 {    3413, .8375942382812E+04, -.1375984741211E+04, .9568811645508E+03},
 {    3414, .8338034179688E+04, -.1408076660156E+04, .9599376220703E+03},
 {    3415, .8349305664062E+04, -.1400077880859E+04, .9548915405273E+03},
 {    3416, .8358945312500E+04, -.1389518310547E+04, .9505769653320E+03},
 {    3417, .8369522460938E+04, -.1373575683594E+04, .9458411865234E+03},
 {    3418, .8339141601562E+04, -.1410308715820E+04, .9594423828125E+03},
 {    3419, .8350618164062E+04, -.1401943359375E+04, .9543040161133E+03},
 {    3420, .8360660156250E+04, -.1391596313477E+04, .9498082885742E+03},
 {    3421, .8370754882812E+04, -.1375984741211E+04, .9452899169922E+03},
 {    3422, .8336736328125E+04, -.1408076660156E+04, .9570397949219E+03},
 {    3423, .8348008789062E+04, -.1400077880859E+04, .9519936523438E+03},
 {    3424, .8357646484375E+04, -.1389518310547E+04, .9476791992188E+03},
 {    3425, .8368225585938E+04, -.1373575683594E+04, .9429432983398E+03},
 {    3426, .8337843750000E+04, -.1410308715820E+04, .9565447998047E+03},
 {    3427, .8349319335938E+04, -.1401943359375E+04, .9514063110352E+03},
 {    3428, .8359364257812E+04, -.1391596313477E+04, .9469100952148E+03},
 {    3429, .8369458007812E+04, -.1375984741211E+04, .9423917846680E+03},
 {    3430, .8331548828125E+04, -.1408076660156E+04, .9454482421875E+03},
 {    3431, .8342818359375E+04, -.1400077880859E+04, .9404022216797E+03},
 {    3432, .8352458007812E+04, -.1389518310547E+04, .9360877075195E+03},
 {    3433, .8363039062500E+04, -.1373575683594E+04, .9313516235352E+03},
 {    3434, .8332654296875E+04, -.1410308715820E+04, .9449530029297E+03},
 {    3435, .8344132812500E+04, -.1401943359375E+04, .9398144531250E+03},
 {    3436, .8354176757812E+04, -.1391596313477E+04, .9353189086914E+03},
 {    3437, .8364268554688E+04, -.1375984741211E+04, .9308005371094E+03},
 {    3438, .8326359375000E+04, -.1408076660156E+04, .9338565673828E+03},
 {    3439, .8337629882812E+04, -.1400077880859E+04, .9288106689453E+03},
 {    3440, .8347267578125E+04, -.1389518310547E+04, .9244961547852E+03},
 {    3441, .8357849609375E+04, -.1373575683594E+04, .9197601928711E+03},
 {    3442, .8327464843750E+04, -.1410308715820E+04, .9333614501953E+03},
 {    3443, .8338943359375E+04, -.1401943359375E+04, .9282229614258E+03},
 {    3444, .8348985351562E+04, -.1391596313477E+04, .9237270507812E+03},
 {    3445, .8359079101562E+04, -.1375984741211E+04, .9192086791992E+03},
 {    3446, .8251616210938E+04, -.1373575683594E+04, .1120375976562E+04},
 {    3447, .8260720703125E+04, -.1387901855469E+04, .1116300048828E+04},
 {    3448, .8273143554688E+04, -.1401514648438E+04, .1110738403320E+04},
 {    3449, .8283105468750E+04, -.1408076660156E+04, .1106278564453E+04},
 {    3450, .8249857421875E+04, -.1375029052734E+04, .1121162475586E+04},
 {    3451, .8259072265625E+04, -.1389839477539E+04, .1117037597656E+04},
 {    3452, .8271983398438E+04, -.1403186767578E+04, .1111258056641E+04},
 {    3453, .8282237304688E+04, -.1409924194336E+04, .1106667724609E+04},
 {    3454, .8246426757812E+04, -.1373575683594E+04, .1108784057617E+04},
 {    3455, .8255530273438E+04, -.1387901855469E+04, .1104708251953E+04},
 {    3456, .8267955078125E+04, -.1401514648438E+04, .1099146484375E+04},
 {    3457, .8277916992188E+04, -.1408076660156E+04, .1094687500000E+04},
 {    3458, .8244669921875E+04, -.1375029052734E+04, .1109570678711E+04},
 {    3459, .8253881835938E+04, -.1389839477539E+04, .1105445800781E+04},
 {    3460, .8266795898438E+04, -.1403186767578E+04, .1099666015625E+04},
 {    3461, .8277047851562E+04, -.1409924194336E+04, .1095076293945E+04},
 {    3462, .8241239257812E+04, -.1373575683594E+04, .1097191772461E+04},
 {    3463, .8250342773438E+04, -.1387901855469E+04, .1093116943359E+04},
 {    3464, .8262765625000E+04, -.1401514648438E+04, .1087555175781E+04},
 {    3465, .8272727539062E+04, -.1408076660156E+04, .1083095947266E+04},
 {    3466, .8239479492188E+04, -.1375029052734E+04, .1097979003906E+04},
 {    3467, .8248697265625E+04, -.1389839477539E+04, .1093853881836E+04},
 {    3468, .8261606445312E+04, -.1403186767578E+04, .1088074462891E+04},
 {    3469, .8271857421875E+04, -.1409924194336E+04, .1083484375000E+04},
 {    3470, .8239940429688E+04, -.1373575683594E+04, .1094294677734E+04},
 {    3471, .8249044921875E+04, -.1387901855469E+04, .1090219360352E+04},
 {    3472, .8261469726562E+04, -.1401514648438E+04, .1084656982422E+04},
 {    3473, .8271429687500E+04, -.1408076660156E+04, .1080197875977E+04},
 {    3474, .8238182617188E+04, -.1375029052734E+04, .1095081542969E+04},
 {    3475, .8247399414062E+04, -.1389839477539E+04, .1090955932617E+04},
 {    3476, .8260309570312E+04, -.1403186767578E+04, .1085176269531E+04},
 {    3477, .8270560546875E+04, -.1409924194336E+04, .1080586669922E+04},
 {    3478, .8234751953125E+04, -.1373575683594E+04, .1082702880859E+04},
 {    3479, .8243856445312E+04, -.1387901855469E+04, .1078627441406E+04},
 {    3480, .8256280273438E+04, -.1401514648438E+04, .1073065429688E+04},
 {    3481, .8266241210938E+04, -.1408076660156E+04, .1068606323242E+04},
 {    3482, .8232994140625E+04, -.1375029052734E+04, .1083489624023E+04},
 {    3483, .8242206054688E+04, -.1389839477539E+04, .1079364624023E+04},
 {    3484, .8255119140625E+04, -.1403186767578E+04, .1073584960938E+04},
 {    3485, .8265372070312E+04, -.1409924194336E+04, .1068995361328E+04},
 {    3486, .8229562500000E+04, -.1373575683594E+04, .1071111083984E+04},
 {    3487, .8238665039062E+04, -.1387901855469E+04, .1067035644531E+04},
 {    3488, .8251092773438E+04, -.1401514648438E+04, .1061473754883E+04},
 {    3489, .8261052734375E+04, -.1408076660156E+04, .1057014770508E+04},
 {    3490, .8227803710938E+04, -.1375029052734E+04, .1071897705078E+04},
 {    3491, .8237017578125E+04, -.1389839477539E+04, .1067773803711E+04},
 {    3492, .8249930664062E+04, -.1403186767578E+04, .1061993408203E+04},
 {    3493, .8260183593750E+04, -.1409924194336E+04, .1057403442383E+04},
 {    3494, .8228262695312E+04, -.1373575683594E+04, .1068213745117E+04},
 {    3495, .8237367187500E+04, -.1387901855469E+04, .1064138183594E+04},
 {    3496, .8249794921875E+04, -.1401514648438E+04, .1058575927734E+04},
 {    3497, .8259752929688E+04, -.1408076660156E+04, .1054117675781E+04},
 {    3498, .8226509765625E+04, -.1375029052734E+04, .1069000610352E+04},
 {    3499, .8235722656250E+04, -.1389839477539E+04, .1064875000000E+04},
 {    3500, .8248633789062E+04, -.1403186767578E+04, .1059095458984E+04},
 {    3501, .8258886718750E+04, -.1409924194336E+04, .1054505371094E+04},
 {    3502, .8223076171875E+04, -.1373575683594E+04, .1056622314453E+04},
 {    3503, .8232178710938E+04, -.1387901855469E+04, .1052546630859E+04},
 {    3504, .8244603515625E+04, -.1401514648438E+04, .1046984497070E+04},
 {    3505, .8254567382812E+04, -.1408076660156E+04, .1042525634766E+04},
 {    3506, .8221319335938E+04, -.1375029052734E+04, .1057408935547E+04},
 {    3507, .8230530273438E+04, -.1389839477539E+04, .1053283935547E+04},
 {    3508, .8243444335938E+04, -.1403186767578E+04, .1047503906250E+04},
 {    3509, .8253695312500E+04, -.1409924194336E+04, .1042914794922E+04},
 {    3510, .8217887695312E+04, -.1373575683594E+04, .1045030639648E+04},
 {    3511, .8226990234375E+04, -.1387901855469E+04, .1040955322266E+04},
 {    3512, .8239416015625E+04, -.1401514648438E+04, .1035392456055E+04},
 {    3513, .8249376953125E+04, -.1408076660156E+04, .1030933715820E+04},
 {    3514, .8216129882812E+04, -.1375029052734E+04, .1045817260742E+04},
 {    3515, .8225341796875E+04, -.1389839477539E+04, .1041692260742E+04},
 {    3516, .8238255859375E+04, -.1403186767578E+04, .1035912841797E+04},
 {    3517, .8248505859375E+04, -.1409924194336E+04, .1031323242188E+04},
 {    3518, .8216587890625E+04, -.1373575683594E+04, .1042132934570E+04},
 {    3519, .8225691406250E+04, -.1387901855469E+04, .1038057495117E+04},
 {    3520, .8238119140625E+04, -.1401514648438E+04, .1032494873047E+04},
 {    3521, .8248080078125E+04, -.1408076660156E+04, .1028035766602E+04},
 {    3522, .8214831054688E+04, -.1375029052734E+04, .1042919433594E+04},
 {    3523, .8224047851562E+04, -.1389839477539E+04, .1038794189453E+04},
 {    3524, .8236958984375E+04, -.1403186767578E+04, .1033014404297E+04},
 {    3525, .8247210937500E+04, -.1409924194336E+04, .1028424560547E+04},
 {    3526, .8211399414062E+04, -.1373575683594E+04, .1030541015625E+04},
 {    3527, .8220503906250E+04, -.1387901855469E+04, .1026465820312E+04},
 {    3528, .8232926757812E+04, -.1401514648438E+04, .1020904113770E+04},
 {    3529, .8242891601562E+04, -.1408076660156E+04, .1016444213867E+04},
 {    3530, .8209641601562E+04, -.1375029052734E+04, .1031328125000E+04},
 {    3531, .8218858398438E+04, -.1389839477539E+04, .1027202636719E+04},
 {    3532, .8231766601562E+04, -.1403186767578E+04, .1021423583984E+04},
 {    3533, .8242021484375E+04, -.1409924194336E+04, .1016833374023E+04},
 {    3534, .8206210937500E+04, -.1373575683594E+04, .1018949707031E+04},
 {    3535, .8215314453125E+04, -.1387901855469E+04, .1014873901367E+04},
 {    3536, .8227737304688E+04, -.1401514648438E+04, .1009312683105E+04},
 {    3537, .8237700195312E+04, -.1408076660156E+04, .1004853393555E+04},
 {    3538, .8204453125000E+04, -.1375029052734E+04, .1019736328125E+04},
 {    3539, .8213670898438E+04, -.1389839477539E+04, .1015610961914E+04},
 {    3540, .8226579101562E+04, -.1403186767578E+04, .1009831542969E+04},
 {    3541, .8236829101562E+04, -.1409924194336E+04, .1005242065430E+04},
 {    3542, .8204914062500E+04, -.1373575683594E+04, .1016051696777E+04},
 {    3543, .8214018554688E+04, -.1387901855469E+04, .1011976379395E+04},
 {    3544, .8226443359375E+04, -.1401514648438E+04, .1006413940430E+04},
 {    3545, .8236402343750E+04, -.1408076660156E+04, .1001955200195E+04},
 {    3546, .8203156250000E+04, -.1375029052734E+04, .1016838378906E+04},
 {    3547, .8212370117188E+04, -.1389839477539E+04, .1012713623047E+04},
 {    3548, .8225283203125E+04, -.1403186767578E+04, .1006933715820E+04},
 {    3549, .8235535156250E+04, -.1409924194336E+04, .1002343627930E+04},
 {    3550, .8199724609375E+04, -.1373575683594E+04, .1004460632324E+04},
 {    3551, .8208828125000E+04, -.1387901855469E+04, .1000385009766E+04},
 {    3552, .8221254882812E+04, -.1401514648438E+04, .9948225097656E+03},
 {    3553, .8231215820312E+04, -.1408076660156E+04, .9903632812500E+03},
 {    3554, .8197966796875E+04, -.1375029052734E+04, .1005246948242E+04},
 {    3555, .8207180664062E+04, -.1389839477539E+04, .1001122314453E+04},
 {    3556, .8220092773438E+04, -.1403186767578E+04, .9953419799805E+03},
 {    3557, .8230346679688E+04, -.1409924194336E+04, .9907523193359E+03},
 {    3558, .8194537109375E+04, -.1373575683594E+04, .9928685302734E+03},
 {    3559, .8203639648438E+04, -.1387901855469E+04, .9887930297852E+03},
 {    3560, .8216064453125E+04, -.1401514648438E+04, .9832310791016E+03},
 {    3561, .8226023437500E+04, -.1408076660156E+04, .9787721557617E+03},
 {    3562, .8192779296875E+04, -.1375029052734E+04, .9936555175781E+03},
 {    3563, .8201994140625E+04, -.1389839477539E+04, .9895301513672E+03},
 {    3564, .8214904296875E+04, -.1403186767578E+04, .9837504882812E+03},
 {    3565, .8225159179688E+04, -.1409924194336E+04, .9791605834961E+03},
 {    3566, .8283105468750E+04, -.1163107421875E+04, .1106278564453E+04},
 {    3567, .8273306640625E+04, -.1169489868164E+04, .1110664794922E+04},
 {    3568, .8260720703125E+04, -.1183282226562E+04, .1116299804688E+04},
 {    3569, .8251616210938E+04, -.1197608398438E+04, .1120375976562E+04},
 {    3570, .8282037109375E+04, -.1161390625000E+04, .1106756591797E+04},
 {    3571, .8271983398438E+04, -.1167997314453E+04, .1111258056641E+04},
 {    3572, .8259072265625E+04, -.1181344604492E+04, .1117037597656E+04},
 {    3573, .8249857421875E+04, -.1196155029297E+04, .1121162475586E+04},
 {    3574, .8277916992188E+04, -.1163107421875E+04, .1094687500000E+04},
 {    3575, .8268120117188E+04, -.1169489868164E+04, .1099072753906E+04},
 {    3576, .8255530273438E+04, -.1183282226562E+04, .1104708251953E+04},
 {    3577, .8246426757812E+04, -.1197608398438E+04, .1108784057617E+04},
 {    3578, .8276848632812E+04, -.1161390625000E+04, .1095165283203E+04},
 {    3579, .8266795898438E+04, -.1167997314453E+04, .1099665771484E+04},
 {    3580, .8253881835938E+04, -.1181344604492E+04, .1105445800781E+04},
 {    3581, .8244669921875E+04, -.1196155029297E+04, .1109570678711E+04},
 {    3582, .8272727539062E+04, -.1163107421875E+04, .1083095947266E+04},
 {    3583, .8262929687500E+04, -.1169489868164E+04, .1087481689453E+04},
 {    3584, .8250341796875E+04, -.1183282226562E+04, .1093116943359E+04},
 {    3585, .8241239257812E+04, -.1197608398438E+04, .1097191772461E+04},
 {    3586, .8271660156250E+04, -.1161390625000E+04, .1083572753906E+04},
 {    3587, .8261606445312E+04, -.1167997314453E+04, .1088074462891E+04},
 {    3588, .8248697265625E+04, -.1181344604492E+04, .1093853637695E+04},
 {    3589, .8239479492188E+04, -.1196155029297E+04, .1097979003906E+04},
 {    3590, .8271429687500E+04, -.1163107421875E+04, .1080197875977E+04},
 {    3591, .8261630859375E+04, -.1169489868164E+04, .1084583862305E+04},
 {    3592, .8249044921875E+04, -.1183282226562E+04, .1090219360352E+04},
 {    3593, .8239940429688E+04, -.1197608398438E+04, .1094294677734E+04},
 {    3594, .8270363281250E+04, -.1161390625000E+04, .1080675781250E+04},
 {    3595, .8260309570312E+04, -.1167997314453E+04, .1085176269531E+04},
 {    3596, .8247399414062E+04, -.1181344604492E+04, .1090955932617E+04},
 {    3597, .8238182617188E+04, -.1196155029297E+04, .1095081542969E+04},
 {    3598, .8266241210938E+04, -.1163107421875E+04, .1068606323242E+04},
 {    3599, .8256441406250E+04, -.1169489868164E+04, .1072992431641E+04},
 {    3600, .8243856445312E+04, -.1183282226562E+04, .1078627441406E+04},
 {    3601, .8234751953125E+04, -.1197608398438E+04, .1082702880859E+04},
 {    3602, .8265173828125E+04, -.1161390625000E+04, .1069084472656E+04},
 {    3603, .8255119140625E+04, -.1167997314453E+04, .1073584960938E+04},
 {    3604, .8242206054688E+04, -.1181344604492E+04, .1079364624023E+04},
 {    3605, .8232994140625E+04, -.1196155029297E+04, .1083489624023E+04},
 {    3606, .8261052734375E+04, -.1163107421875E+04, .1057014770508E+04},
 {    3607, .8251253906250E+04, -.1169489868164E+04, .1061400756836E+04},
 {    3608, .8238665039062E+04, -.1183282226562E+04, .1067035644531E+04},
 {    3609, .8229562500000E+04, -.1197608398438E+04, .1071111083984E+04},
 {    3610, .8259985351562E+04, -.1161390625000E+04, .1057492675781E+04},
 {    3611, .8249930664062E+04, -.1167997314453E+04, .1061993408203E+04},
 {    3612, .8237017578125E+04, -.1181344604492E+04, .1067773803711E+04},
 {    3613, .8227803710938E+04, -.1196155029297E+04, .1071897705078E+04},
 {    3614, .8259752929688E+04, -.1163107421875E+04, .1054117675781E+04},
 {    3615, .8249957031250E+04, -.1169489868164E+04, .1058503173828E+04},
 {    3616, .8237367187500E+04, -.1183282226562E+04, .1064138183594E+04},
 {    3617, .8228262695312E+04, -.1197608398438E+04, .1068213745117E+04},
 {    3618, .8258687500000E+04, -.1161390625000E+04, .1054594482422E+04},
 {    3619, .8248633789062E+04, -.1167997314453E+04, .1059095214844E+04},
 {    3620, .8235722656250E+04, -.1181344604492E+04, .1064875000000E+04},
 {    3621, .8226509765625E+04, -.1196155029297E+04, .1069000610352E+04},
 {    3622, .8254567382812E+04, -.1163107421875E+04, .1042525634766E+04},
 {    3623, .8244766601562E+04, -.1169489868164E+04, .1046911376953E+04},
 {    3624, .8232178710938E+04, -.1183282226562E+04, .1052546630859E+04},
 {    3625, .8223076171875E+04, -.1197608398438E+04, .1056622314453E+04},
 {    3626, .8253498046875E+04, -.1161390625000E+04, .1043003173828E+04},
 {    3627, .8243443359375E+04, -.1167997314453E+04, .1047503662109E+04},
 {    3628, .8230530273438E+04, -.1181344604492E+04, .1053283935547E+04},
 {    3629, .8221319335938E+04, -.1196155029297E+04, .1057408691406E+04},
 {    3630, .8249376953125E+04, -.1163107421875E+04, .1030933715820E+04},
 {    3631, .8239580078125E+04, -.1169489868164E+04, .1035319335938E+04},
 {    3632, .8226990234375E+04, -.1183282226562E+04, .1040955322266E+04},
 {    3633, .8217887695312E+04, -.1197608398438E+04, .1045030639648E+04},
 {    3634, .8248308593750E+04, -.1161390625000E+04, .1031411376953E+04},
 {    3635, .8238255859375E+04, -.1167997314453E+04, .1035912597656E+04},
 {    3636, .8225341796875E+04, -.1181344604492E+04, .1041692260742E+04},
 {    3637, .8216129882812E+04, -.1196155029297E+04, .1045817260742E+04},
 {    3638, .8248080078125E+04, -.1163107421875E+04, .1028035766602E+04},
 {    3639, .8238281250000E+04, -.1169489868164E+04, .1032421875000E+04},
 {    3640, .8225690429688E+04, -.1183282226562E+04, .1038057861328E+04},
 {    3641, .8216587890625E+04, -.1197608398438E+04, .1042132934570E+04},
 {    3642, .8247010742188E+04, -.1161390625000E+04, .1028513671875E+04},
 {    3643, .8236958984375E+04, -.1167997314453E+04, .1033014404297E+04},
 {    3644, .8224047851562E+04, -.1181344604492E+04, .1038794189453E+04},
 {    3645, .8214831054688E+04, -.1196155029297E+04, .1042919433594E+04},
 {    3646, .8242891601562E+04, -.1163107421875E+04, .1016444213867E+04},
 {    3647, .8233091796875E+04, -.1169489868164E+04, .1020830566406E+04},
 {    3648, .8220503906250E+04, -.1183282226562E+04, .1026465820312E+04},
 {    3649, .8211399414062E+04, -.1197608398438E+04, .1030541015625E+04},
 {    3650, .8241822265625E+04, -.1161390625000E+04, .1016922241211E+04},
 {    3651, .8231766601562E+04, -.1167997314453E+04, .1021423583984E+04},
 {    3652, .8218858398438E+04, -.1181344604492E+04, .1027202636719E+04},
 {    3653, .8209641601562E+04, -.1196155029297E+04, .1031328125000E+04},
 {    3654, .8237700195312E+04, -.1163107421875E+04, .1004853393555E+04},
 {    3655, .8227902343750E+04, -.1169489868164E+04, .1009238891602E+04},
 {    3656, .8215314453125E+04, -.1183282226562E+04, .1014873901367E+04},
 {    3657, .8206210937500E+04, -.1197608398438E+04, .1018949707031E+04},
 {    3658, .8236632812500E+04, -.1161390625000E+04, .1005330688477E+04},
 {    3659, .8226579101562E+04, -.1167997314453E+04, .1009831298828E+04},
 {    3660, .8213670898438E+04, -.1181344604492E+04, .1015610961914E+04},
 {    3661, .8204453125000E+04, -.1196155029297E+04, .1019736328125E+04},
 {    3662, .8236402343750E+04, -.1163107421875E+04, .1001955200195E+04},
 {    3663, .8226605468750E+04, -.1169489868164E+04, .1006340820312E+04},
 {    3664, .8214018554688E+04, -.1183282226562E+04, .1011976379395E+04},
 {    3665, .8204914062500E+04, -.1197608398438E+04, .1016051696777E+04},
 {    3666, .8235334960938E+04, -.1161390625000E+04, .1002432739258E+04},
 {    3667, .8225283203125E+04, -.1167997314453E+04, .1006933715820E+04},
 {    3668, .8212370117188E+04, -.1181344604492E+04, .1012713623047E+04},
 {    3669, .8203156250000E+04, -.1196155029297E+04, .1016838378906E+04},
 {    3670, .8231215820312E+04, -.1163107421875E+04, .9903632812500E+03},
 {    3671, .8221416992188E+04, -.1169489868164E+04, .9947493896484E+03},
 {    3672, .8208828125000E+04, -.1183282226562E+04, .1000384765625E+04},
 {    3673, .8199724609375E+04, -.1197608398438E+04, .1004460632324E+04},
 {    3674, .8230148437500E+04, -.1161390625000E+04, .9908409423828E+03},
 {    3675, .8220092773438E+04, -.1167997314453E+04, .9953419799805E+03},
 {    3676, .8207181640625E+04, -.1181344604492E+04, .1001121643066E+04},
 {    3677, .8197966796875E+04, -.1196155029297E+04, .1005246948242E+04},
 {    3678, .8226023437500E+04, -.1163107421875E+04, .9787721557617E+03},
 {    3679, .8216228515625E+04, -.1169489868164E+04, .9831574707031E+03},
 {    3680, .8203639648438E+04, -.1183282226562E+04, .9887927856445E+03},
 {    3681, .8194537109375E+04, -.1197608398438E+04, .9928685302734E+03},
 {    3682, .8224958007812E+04, -.1161390625000E+04, .9792498168945E+03},
 {    3683, .8214904296875E+04, -.1167997314453E+04, .9837504882812E+03},
 {    3684, .8201994140625E+04, -.1181344604492E+04, .9895301513672E+03},
 {    3685, .8192779296875E+04, -.1196155029297E+04, .9936555175781E+03},
 {    3686, .8245729492188E+04, -.1336392089844E+04, .1136925170898E+04},
 {    3687, .8248625000000E+04, -.1336392089844E+04, .1135628295898E+04},
 {    3688, .8245729492188E+04, -.1323692016602E+04, .1136925170898E+04},
 {    3689, .8248625000000E+04, -.1323692016602E+04, .1135628295898E+04},
 {    3690, .8240538085938E+04, -.1336392089844E+04, .1125334472656E+04},
 {    3691, .8243438476562E+04, -.1336392089844E+04, .1124036499023E+04},
 {    3692, .8240538085938E+04, -.1323692016602E+04, .1125334472656E+04},
 {    3693, .8243438476562E+04, -.1323692016602E+04, .1124036499023E+04},
 {    3694, .8235350585938E+04, -.1336392089844E+04, .1113742431641E+04},
 {    3695, .8238247070312E+04, -.1336392089844E+04, .1112445312500E+04},
 {    3696, .8235350585938E+04, -.1323692016602E+04, .1113742431641E+04},
 {    3697, .8238247070312E+04, -.1323692016602E+04, .1112445312500E+04},
 {    3698, .8230163085938E+04, -.1336392089844E+04, .1102150634766E+04},
 {    3699, .8233059570312E+04, -.1336392089844E+04, .1100853637695E+04},
 {    3700, .8230163085938E+04, -.1323692016602E+04, .1102150634766E+04},
 {    3701, .8233059570312E+04, -.1323692016602E+04, .1100853637695E+04},
 {    3702, .8228862304688E+04, -.1336392089844E+04, .1099253173828E+04},
 {    3703, .8231761718750E+04, -.1336392089844E+04, .1097955688477E+04},
 {    3704, .8228862304688E+04, -.1323692016602E+04, .1099253173828E+04},
 {    3705, .8231761718750E+04, -.1323692016602E+04, .1097955688477E+04},
 {    3706, .8223675781250E+04, -.1336392089844E+04, .1087661376953E+04},
 {    3707, .8226575195312E+04, -.1336392089844E+04, .1086364501953E+04},
 {    3708, .8223675781250E+04, -.1323692016602E+04, .1087661376953E+04},
 {    3709, .8226575195312E+04, -.1323692016602E+04, .1086364501953E+04},
 {    3710, .8218486328125E+04, -.1336392089844E+04, .1076069580078E+04},
 {    3711, .8221383789062E+04, -.1336392089844E+04, .1074772827148E+04},
 {    3712, .8218486328125E+04, -.1323692016602E+04, .1076069580078E+04},
 {    3713, .8221383789062E+04, -.1323692016602E+04, .1074772827148E+04},
 {    3714, .8217188476562E+04, -.1336392089844E+04, .1073171875000E+04},
 {    3715, .8220084960938E+04, -.1336392089844E+04, .1071875122070E+04},
 {    3716, .8217188476562E+04, -.1323692016602E+04, .1073171875000E+04},
 {    3717, .8220084960938E+04, -.1323692016602E+04, .1071875122070E+04},
 {    3718, .8212000000000E+04, -.1336392089844E+04, .1061580444336E+04},
 {    3719, .8214895507812E+04, -.1336392089844E+04, .1060283203125E+04},
 {    3720, .8212000000000E+04, -.1323692016602E+04, .1061580444336E+04},
 {    3721, .8214895507812E+04, -.1323692016602E+04, .1060283203125E+04},
 {    3722, .8206809570312E+04, -.1336392089844E+04, .1049989257812E+04},
 {    3723, .8209708984375E+04, -.1336392089844E+04, .1048691894531E+04},
 {    3724, .8206809570312E+04, -.1323692016602E+04, .1049989257812E+04},
 {    3725, .8209708984375E+04, -.1323692016602E+04, .1048691894531E+04},
 {    3726, .8205513671875E+04, -.1336392089844E+04, .1047091064453E+04},
 {    3727, .8208410156250E+04, -.1336392089844E+04, .1045794067383E+04},
 {    3728, .8205513671875E+04, -.1323692016602E+04, .1047091064453E+04},
 {    3729, .8208410156250E+04, -.1323692016602E+04, .1045794067383E+04},
 {    3730, .8200321289062E+04, -.1336392089844E+04, .1035499633789E+04},
 {    3731, .8203223632812E+04, -.1336392089844E+04, .1034202270508E+04},
 {    3732, .8200321289062E+04, -.1323692016602E+04, .1035499633789E+04},
 {    3733, .8203223632812E+04, -.1323692016602E+04, .1034202270508E+04},
 {    3734, .8195135742188E+04, -.1336392089844E+04, .1023908081055E+04},
 {    3735, .8198030273438E+04, -.1336392089844E+04, .1022611267090E+04},
 {    3736, .8195135742188E+04, -.1323692016602E+04, .1023908081055E+04},
 {    3737, .8198030273438E+04, -.1323692016602E+04, .1022611267090E+04},
 {    3738, .8193837890625E+04, -.1336392089844E+04, .1021010009766E+04},
 {    3739, .8196735351562E+04, -.1336392089844E+04, .1019712768555E+04},
 {    3740, .8193837890625E+04, -.1323692016602E+04, .1021010009766E+04},
 {    3741, .8196735351562E+04, -.1323692016602E+04, .1019712768555E+04},
 {    3742, .8188649414062E+04, -.1336392089844E+04, .1009418762207E+04},
 {    3743, .8191546875000E+04, -.1336392089844E+04, .1008121154785E+04},
 {    3744, .8188649414062E+04, -.1323692016602E+04, .1009418762207E+04},
 {    3745, .8191546875000E+04, -.1323692016602E+04, .1008121154785E+04},
 {    3746, .8183458007812E+04, -.1336392089844E+04, .9978272094727E+03},
 {    3747, .8186355957031E+04, -.1336392089844E+04, .9965302734375E+03},
 {    3748, .8183458007812E+04, -.1323692016602E+04, .9978272094727E+03},
 {    3749, .8186355957031E+04, -.1323692016602E+04, .9965302734375E+03},
 {    3750, .8178270019531E+04, -.1336392089844E+04, .9862356567383E+03},
 {    3751, .8181168945312E+04, -.1336392089844E+04, .9849380493164E+03},
 {    3752, .8178270019531E+04, -.1323692016602E+04, .9862356567383E+03},
 {    3753, .8181168945312E+04, -.1323692016602E+04, .9849380493164E+03},
 {    3754, .8245729492188E+04, -.1305911987305E+04, .1136925170898E+04},
 {    3755, .8248625000000E+04, -.1305911987305E+04, .1135628295898E+04},
 {    3756, .8245729492188E+04, -.1288132080078E+04, .1136925170898E+04},
 {    3757, .8248625000000E+04, -.1288132080078E+04, .1135628295898E+04},
 {    3758, .8240538085938E+04, -.1305911987305E+04, .1125334472656E+04},
 {    3759, .8243438476562E+04, -.1305911987305E+04, .1124036499023E+04},
 {    3760, .8240538085938E+04, -.1288132080078E+04, .1125334472656E+04},
 {    3761, .8243438476562E+04, -.1288132080078E+04, .1124036499023E+04},
 {    3762, .8235350585938E+04, -.1305911987305E+04, .1113742431641E+04},
 {    3763, .8238247070312E+04, -.1305911987305E+04, .1112445312500E+04},
 {    3764, .8235350585938E+04, -.1288132080078E+04, .1113742431641E+04},
 {    3765, .8238247070312E+04, -.1288132080078E+04, .1112445312500E+04},
 {    3766, .8230163085938E+04, -.1305911987305E+04, .1102150634766E+04},
 {    3767, .8233059570312E+04, -.1305911987305E+04, .1100853637695E+04},
 {    3768, .8230163085938E+04, -.1288132080078E+04, .1102150634766E+04},
 {    3769, .8233059570312E+04, -.1288132080078E+04, .1100853637695E+04},
 {    3770, .8228862304688E+04, -.1305911987305E+04, .1099253173828E+04},
 {    3771, .8231761718750E+04, -.1305911987305E+04, .1097955688477E+04},
 {    3772, .8228862304688E+04, -.1288132080078E+04, .1099253173828E+04},
 {    3773, .8231761718750E+04, -.1288132080078E+04, .1097955688477E+04},
 {    3774, .8223675781250E+04, -.1305911987305E+04, .1087661376953E+04},
 {    3775, .8226575195312E+04, -.1305911987305E+04, .1086364501953E+04},
 {    3776, .8223675781250E+04, -.1288132080078E+04, .1087661376953E+04},
 {    3777, .8226575195312E+04, -.1288132080078E+04, .1086364501953E+04},
 {    3778, .8218486328125E+04, -.1305911987305E+04, .1076069580078E+04},
 {    3779, .8221383789062E+04, -.1305911987305E+04, .1074772827148E+04},
 {    3780, .8218486328125E+04, -.1288132080078E+04, .1076069580078E+04},
 {    3781, .8221383789062E+04, -.1288132080078E+04, .1074772827148E+04},
 {    3782, .8217188476562E+04, -.1305911987305E+04, .1073171875000E+04},
 {    3783, .8220084960938E+04, -.1305911987305E+04, .1071875122070E+04},
 {    3784, .8217188476562E+04, -.1288132080078E+04, .1073171875000E+04},
 {    3785, .8220084960938E+04, -.1288132080078E+04, .1071875122070E+04},
 {    3786, .8212000000000E+04, -.1305911987305E+04, .1061580444336E+04},
 {    3787, .8214895507812E+04, -.1305911987305E+04, .1060283203125E+04},
 {    3788, .8212000000000E+04, -.1288132080078E+04, .1061580444336E+04},
 {    3789, .8214895507812E+04, -.1288132080078E+04, .1060283203125E+04},
 {    3790, .8206809570312E+04, -.1305911987305E+04, .1049989257812E+04},
 {    3791, .8209708984375E+04, -.1305911987305E+04, .1048691894531E+04},
 {    3792, .8206809570312E+04, -.1288132080078E+04, .1049989257812E+04},
 {    3793, .8209708984375E+04, -.1288132080078E+04, .1048691894531E+04},
 {    3794, .8205513671875E+04, -.1305911987305E+04, .1047091064453E+04},
 {    3795, .8208410156250E+04, -.1305911987305E+04, .1045794067383E+04},
 {    3796, .8205513671875E+04, -.1288132080078E+04, .1047091064453E+04},
 {    3797, .8208410156250E+04, -.1288132080078E+04, .1045794067383E+04},
 {    3798, .8200321289062E+04, -.1305912109375E+04, .1035499633789E+04},
 {    3799, .8203223632812E+04, -.1305912109375E+04, .1034202270508E+04},
 {    3800, .8200321289062E+04, -.1288132080078E+04, .1035499633789E+04},
 {    3801, .8203223632812E+04, -.1288132080078E+04, .1034202270508E+04},
 {    3802, .8195135742188E+04, -.1305912109375E+04, .1023908081055E+04},
 {    3803, .8198030273438E+04, -.1305912109375E+04, .1022611267090E+04},
 {    3804, .8195135742188E+04, -.1288132080078E+04, .1023908081055E+04},
 {    3805, .8198030273438E+04, -.1288132080078E+04, .1022611267090E+04},
 {    3806, .8193837890625E+04, -.1305912109375E+04, .1021010009766E+04},
 {    3807, .8196735351562E+04, -.1305912109375E+04, .1019712768555E+04},
 {    3808, .8193837890625E+04, -.1288132080078E+04, .1021010009766E+04},
 {    3809, .8196735351562E+04, -.1288132080078E+04, .1019712768555E+04},
 {    3810, .8188649414062E+04, -.1305912109375E+04, .1009418762207E+04},
 {    3811, .8191546875000E+04, -.1305912109375E+04, .1008121154785E+04},
 {    3812, .8188649414062E+04, -.1288132080078E+04, .1009418762207E+04},
 {    3813, .8191546875000E+04, -.1288132080078E+04, .1008121154785E+04},
 {    3814, .8183458007812E+04, -.1305912109375E+04, .9978272094727E+03},
 {    3815, .8186355957031E+04, -.1305912109375E+04, .9965302734375E+03},
 {    3816, .8183458007812E+04, -.1288132080078E+04, .9978272094727E+03},
 {    3817, .8186355957031E+04, -.1288132080078E+04, .9965302734375E+03},
 {    3818, .8178270019531E+04, -.1305912109375E+04, .9862356567383E+03},
 {    3819, .8181168945312E+04, -.1305912109375E+04, .9849380493164E+03},
 {    3820, .8178270019531E+04, -.1288132080078E+04, .9862356567383E+03},
 {    3821, .8181168945312E+04, -.1288132080078E+04, .9849380493164E+03},
 {    3822, .8245729492188E+04, -.1283052001953E+04, .1136925170898E+04},
 {    3823, .8248625000000E+04, -.1283052001953E+04, .1135628295898E+04},
 {    3824, .8240538085938E+04, -.1283052001953E+04, .1125334472656E+04},
 {    3825, .8243438476562E+04, -.1283052001953E+04, .1124036499023E+04},
 {    3826, .8235350585938E+04, -.1283052001953E+04, .1113742431641E+04},
 {    3827, .8238247070312E+04, -.1283052001953E+04, .1112445312500E+04},
 {    3828, .8230163085938E+04, -.1283052001953E+04, .1102150634766E+04},
 {    3829, .8233059570312E+04, -.1283052001953E+04, .1100853637695E+04},
 {    3830, .8228862304688E+04, -.1283052001953E+04, .1099253173828E+04},
 {    3831, .8231761718750E+04, -.1283052001953E+04, .1097955688477E+04},
 {    3832, .8223675781250E+04, -.1283052001953E+04, .1087661376953E+04},
 {    3833, .8226575195312E+04, -.1283052001953E+04, .1086364501953E+04},
 {    3834, .8218486328125E+04, -.1283052001953E+04, .1076069580078E+04},
 {    3835, .8221383789062E+04, -.1283052001953E+04, .1074772827148E+04},
 {    3836, .8217188476562E+04, -.1283052001953E+04, .1073171875000E+04},
 {    3837, .8220084960938E+04, -.1283052001953E+04, .1071875122070E+04},
 {    3838, .8212000000000E+04, -.1283052001953E+04, .1061580444336E+04},
 {    3839, .8214895507812E+04, -.1283052001953E+04, .1060283203125E+04},
 {    3840, .8206809570312E+04, -.1283052001953E+04, .1049989257812E+04},
 {    3841, .8209708984375E+04, -.1283052001953E+04, .1048691894531E+04},
 {    3842, .8205513671875E+04, -.1283052001953E+04, .1047091064453E+04},
 {    3843, .8208410156250E+04, -.1283052001953E+04, .1045794067383E+04},
 {    3844, .8200321289062E+04, -.1283052001953E+04, .1035499633789E+04},
 {    3845, .8203223632812E+04, -.1283052001953E+04, .1034202270508E+04},
 {    3846, .8195135742188E+04, -.1283052001953E+04, .1023908081055E+04},
 {    3847, .8198030273438E+04, -.1283052001953E+04, .1022611267090E+04},
 {    3848, .8193837890625E+04, -.1283052001953E+04, .1021010009766E+04},
 {    3849, .8196735351562E+04, -.1283052001953E+04, .1019712768555E+04},
 {    3850, .8188649414062E+04, -.1283052001953E+04, .1009418762207E+04},
 {    3851, .8191546875000E+04, -.1283052001953E+04, .1008121154785E+04},
 {    3852, .8183458007812E+04, -.1283052001953E+04, .9978272094727E+03},
 {    3853, .8186355957031E+04, -.1283052001953E+04, .9965302734375E+03},
 {    3854, .8178270019531E+04, -.1283052001953E+04, .9862356567383E+03},
 {    3855, .8181168945312E+04, -.1283052001953E+04, .9849380493164E+03},
 {    3856, .8245729492188E+04, -.1265272094727E+04, .1136925170898E+04},
 {    3857, .8248625000000E+04, -.1265272094727E+04, .1135628295898E+04},
 {    3858, .8245729492188E+04, -.1247492065430E+04, .1136925170898E+04},
 {    3859, .8248625000000E+04, -.1247492065430E+04, .1135628295898E+04},
 {    3860, .8240538085938E+04, -.1265272094727E+04, .1125334472656E+04},
 {    3861, .8243438476562E+04, -.1265272094727E+04, .1124036499023E+04},
 {    3862, .8240538085938E+04, -.1247492065430E+04, .1125334472656E+04},
 {    3863, .8243438476562E+04, -.1247492065430E+04, .1124036499023E+04},
 {    3864, .8235350585938E+04, -.1265272094727E+04, .1113742431641E+04},
 {    3865, .8238247070312E+04, -.1265272094727E+04, .1112445312500E+04},
 {    3866, .8235350585938E+04, -.1247492065430E+04, .1113742431641E+04},
 {    3867, .8238247070312E+04, -.1247492065430E+04, .1112445312500E+04},
 {    3868, .8230163085938E+04, -.1265272094727E+04, .1102150634766E+04},
 {    3869, .8233059570312E+04, -.1265272094727E+04, .1100853637695E+04},
 {    3870, .8230163085938E+04, -.1247492065430E+04, .1102150634766E+04},
 {    3871, .8233059570312E+04, -.1247492065430E+04, .1100853637695E+04},
 {    3872, .8228862304688E+04, -.1265272094727E+04, .1099253173828E+04},
 {    3873, .8231761718750E+04, -.1265272094727E+04, .1097955688477E+04},
 {    3874, .8228862304688E+04, -.1247492065430E+04, .1099253173828E+04},
 {    3875, .8231761718750E+04, -.1247492065430E+04, .1097955688477E+04},
 {    3876, .8223675781250E+04, -.1265272094727E+04, .1087661376953E+04},
 {    3877, .8226575195312E+04, -.1265272094727E+04, .1086364501953E+04},
 {    3878, .8223675781250E+04, -.1247492065430E+04, .1087661376953E+04},
 {    3879, .8226575195312E+04, -.1247492065430E+04, .1086364501953E+04},
 {    3880, .8218486328125E+04, -.1265272094727E+04, .1076069580078E+04},
 {    3881, .8221383789062E+04, -.1265272094727E+04, .1074772827148E+04},
 {    3882, .8218486328125E+04, -.1247492065430E+04, .1076069580078E+04},
 {    3883, .8221383789062E+04, -.1247492065430E+04, .1074772827148E+04},
 {    3884, .8217188476562E+04, -.1265272094727E+04, .1073171875000E+04},
 {    3885, .8220084960938E+04, -.1265272094727E+04, .1071875122070E+04},
 {    3886, .8217188476562E+04, -.1247492065430E+04, .1073171875000E+04},
 {    3887, .8220084960938E+04, -.1247492065430E+04, .1071875122070E+04},
 {    3888, .8212000000000E+04, -.1265272094727E+04, .1061580444336E+04},
 {    3889, .8214895507812E+04, -.1265272094727E+04, .1060283203125E+04},
 {    3890, .8212000000000E+04, -.1247492065430E+04, .1061580444336E+04},
 {    3891, .8214895507812E+04, -.1247492065430E+04, .1060283203125E+04},
 {    3892, .8206809570312E+04, -.1265272094727E+04, .1049989257812E+04},
 {    3893, .8209708984375E+04, -.1265272094727E+04, .1048691894531E+04},
 {    3894, .8206809570312E+04, -.1247492065430E+04, .1049989257812E+04},
 {    3895, .8209708984375E+04, -.1247492065430E+04, .1048691894531E+04},
 {    3896, .8205513671875E+04, -.1265272094727E+04, .1047091064453E+04},
 {    3897, .8208410156250E+04, -.1265272094727E+04, .1045794067383E+04},
 {    3898, .8205513671875E+04, -.1247492065430E+04, .1047091064453E+04},
 {    3899, .8208410156250E+04, -.1247492065430E+04, .1045794067383E+04},
 {    3900, .8200321289062E+04, -.1265272094727E+04, .1035499633789E+04},
 {    3901, .8203223632812E+04, -.1265272094727E+04, .1034202270508E+04},
 {    3902, .8200321289062E+04, -.1247492065430E+04, .1035499633789E+04},
 {    3903, .8203223632812E+04, -.1247492065430E+04, .1034202270508E+04},
 {    3904, .8195135742188E+04, -.1265272094727E+04, .1023908081055E+04},
 {    3905, .8198030273438E+04, -.1265272094727E+04, .1022611267090E+04},
 {    3906, .8195135742188E+04, -.1247492065430E+04, .1023908081055E+04},
 {    3907, .8198030273438E+04, -.1247492065430E+04, .1022611267090E+04},
 {    3908, .8193837890625E+04, -.1265272094727E+04, .1021010009766E+04},
 {    3909, .8196735351562E+04, -.1265272094727E+04, .1019712768555E+04},
 {    3910, .8193837890625E+04, -.1247492065430E+04, .1021010009766E+04},
 {    3911, .8196735351562E+04, -.1247492065430E+04, .1019712768555E+04},
 {    3912, .8188649414062E+04, -.1265272094727E+04, .1009418762207E+04},
 {    3913, .8191546875000E+04, -.1265272094727E+04, .1008121154785E+04},
 {    3914, .8188649414062E+04, -.1247492065430E+04, .1009418762207E+04},
 {    3915, .8191546875000E+04, -.1247492065430E+04, .1008121154785E+04},
 {    3916, .8183458007812E+04, -.1265272094727E+04, .9978272094727E+03},
 {    3917, .8186355957031E+04, -.1265272094727E+04, .9965302734375E+03},
 {    3918, .8183458007812E+04, -.1247492065430E+04, .9978272094727E+03},
 {    3919, .8186355957031E+04, -.1247492065430E+04, .9965302734375E+03},
 {    3920, .8178270019531E+04, -.1265272094727E+04, .9862356567383E+03},
 {    3921, .8181168945312E+04, -.1265272094727E+04, .9849380493164E+03},
 {    3922, .8178270019531E+04, -.1247492065430E+04, .9862356567383E+03},
 {    3923, .8181168945312E+04, -.1247492065430E+04, .9849380493164E+03},
 {    3924, .8245729492188E+04, -.1234791992188E+04, .1136925170898E+04},
 {    3925, .8248625000000E+04, -.1234791992188E+04, .1135628295898E+04},
 {    3926, .8240538085938E+04, -.1234791992188E+04, .1125334472656E+04},
 {    3927, .8243438476562E+04, -.1234791992188E+04, .1124036499023E+04},
 {    3928, .8235350585938E+04, -.1234791992188E+04, .1113742431641E+04},
 {    3929, .8238247070312E+04, -.1234791992188E+04, .1112445312500E+04},
 {    3930, .8230163085938E+04, -.1234791992188E+04, .1102150634766E+04},
 {    3931, .8233059570312E+04, -.1234791992188E+04, .1100853637695E+04},
 {    3932, .8228862304688E+04, -.1234791992188E+04, .1099253173828E+04},
 {    3933, .8231761718750E+04, -.1234791992188E+04, .1097955688477E+04},
 {    3934, .8223675781250E+04, -.1234791992188E+04, .1087661376953E+04},
 {    3935, .8226575195312E+04, -.1234791992188E+04, .1086364501953E+04},
 {    3936, .8218486328125E+04, -.1234791992188E+04, .1076069580078E+04},
 {    3937, .8221383789062E+04, -.1234791992188E+04, .1074772827148E+04},
 {    3938, .8217188476562E+04, -.1234791992188E+04, .1073171875000E+04},
 {    3939, .8220084960938E+04, -.1234791992188E+04, .1071875122070E+04},
 {    3940, .8212000000000E+04, -.1234791992188E+04, .1061580444336E+04},
 {    3941, .8214895507812E+04, -.1234791992188E+04, .1060283203125E+04},
 {    3942, .8206809570312E+04, -.1234791992188E+04, .1049989257812E+04},
 {    3943, .8209708984375E+04, -.1234791992188E+04, .1048691894531E+04},
 {    3944, .8205513671875E+04, -.1234791992188E+04, .1047091064453E+04},
 {    3945, .8208410156250E+04, -.1234791992188E+04, .1045794067383E+04},
 {    3946, .8200321289062E+04, -.1234791992188E+04, .1035499633789E+04},
 {    3947, .8203223632812E+04, -.1234791992188E+04, .1034202270508E+04},
 {    3948, .8195135742188E+04, -.1234791992188E+04, .1023908081055E+04},
 {    3949, .8198030273438E+04, -.1234791992188E+04, .1022611267090E+04},
 {    3950, .8193837890625E+04, -.1234791992188E+04, .1021010009766E+04},
 {    3951, .8196735351562E+04, -.1234791992188E+04, .1019712768555E+04},
 {    3952, .8188649414062E+04, -.1234791992188E+04, .1009418762207E+04},
 {    3953, .8191546875000E+04, -.1234791992188E+04, .1008121154785E+04},
 {    3954, .8183458007812E+04, -.1234791992188E+04, .9978272094727E+03},
 {    3955, .8186355957031E+04, -.1234791992188E+04, .9965302734375E+03},
 {    3956, .8178270019531E+04, -.1234791992188E+04, .9862356567383E+03},
 {    3957, .8181168945312E+04, -.1234791992188E+04, .9849380493164E+03},
 {    3958, .8290064453125E+04, -.1285592041016E+04, .8738526611328E+03},
 {    3959, .8277605468750E+04, -.1285592041016E+04, .8794305419922E+03},
 {    3960, .8265143554688E+04, -.1285592041016E+04, .8850091552734E+03},
 {    3961, .8291229492188E+04, -.1280829589844E+04, .8733309326172E+03},
 {    3962, .8280437500000E+04, -.1274003295898E+04, .8781619873047E+03},
 {    3963, .8269646484375E+04, -.1267177001953E+04, .8829931030273E+03},
 {    3964, .8294411132812E+04, -.1277343139648E+04, .8719064941406E+03},
 {    3965, .8288180664062E+04, -.1265519775391E+04, .8746956787109E+03},
 {    3966, .8281950195312E+04, -.1253696289062E+04, .8774849853516E+03},
 {    3967, .8298756835938E+04, -.1276067016602E+04, .8699608764648E+03},
 {    3968, .8298756835938E+04, -.1262414550781E+04, .8699608764648E+03},
 {    3969, .8298756835938E+04, -.1248762084961E+04, .8699608764648E+03},
 {    3970, .8303106445312E+04, -.1277343139648E+04, .8680151367188E+03},
 {    3971, .8309336914062E+04, -.1265519775391E+04, .8652255859375E+03},
 {    3972, .8315567382812E+04, -.1253696289062E+04, .8624365844727E+03},
 {    3973, .8306288085938E+04, -.1280829589844E+04, .8665902709961E+03},
 {    3974, .8317078125000E+04, -.1274003295898E+04, .8617597656250E+03},
 {    3975, .8327869140625E+04, -.1267177001953E+04, .8569287719727E+03},
 {    3976, .8307453125000E+04, -.1285592041016E+04, .8660687255859E+03},
 {    3977, .8319914062500E+04, -.1285592041016E+04, .8604906616211E+03},
 {    3978, .8332374023438E+04, -.1285592041016E+04, .8549126586914E+03},
 {    3979, .8306288085938E+04, -.1290354614258E+04, .8665902709961E+03},
 {    3980, .8317078125000E+04, -.1297180786133E+04, .8617597656250E+03},
 {    3981, .8327869140625E+04, -.1304007080078E+04, .8569287719727E+03},
 {    3982, .8303106445312E+04, -.1293840942383E+04, .8680151367188E+03},
 {    3983, .8309336914062E+04, -.1305664306641E+04, .8652255859375E+03},
 {    3984, .8315567382812E+04, -.1317487792969E+04, .8624367065430E+03},
 {    3985, .8298756835938E+04, -.1295117065430E+04, .8699608764648E+03},
 {    3986, .8298756835938E+04, -.1308769531250E+04, .8699608764648E+03},
 {    3987, .8298756835938E+04, -.1322421997070E+04, .8699608764648E+03},
 {    3988, .8294411132812E+04, -.1293840942383E+04, .8719064941406E+03},
 {    3989, .8288180664062E+04, -.1305664306641E+04, .8746956787109E+03},
 {    3990, .8281950195312E+04, -.1317487792969E+04, .8774849853516E+03},
 {    3991, .8291229492188E+04, -.1290354614258E+04, .8733309326172E+03},
 {    3992, .8280437500000E+04, -.1297180786133E+04, .8781619873047E+03},
 {    3993, .8269646484375E+04, -.1304007080078E+04, .8829931030273E+03},
 {    3994, .8279271484375E+04, -.1285592041016E+04, .8497422485352E+03},
 {    3995, .8266810546875E+04, -.1285592041016E+04, .8553202514648E+03},
 {    3996, .8254350585938E+04, -.1285592041016E+04, .8608986816406E+03},
 {    3997, .8280435546875E+04, -.1280829589844E+04, .8492209472656E+03},
 {    3998, .8269645507812E+04, -.1274003295898E+04, .8540517578125E+03},
 {    3999, .8258852539062E+04, -.1267177001953E+04, .8588827514648E+03},
 {    4000, .8283619140625E+04, -.1277343139648E+04, .8477963867188E+03},
 {    4001, .8277387695312E+04, -.1265519775391E+04, .8505855102539E+03},
 {    4002, .8271157226562E+04, -.1253696289062E+04, .8533746337891E+03},
 {    4003, .8287965820312E+04, -.1276067016602E+04, .8458502807617E+03},
 {    4004, .8287965820312E+04, -.1262414550781E+04, .8458502807617E+03},
 {    4005, .8287965820312E+04, -.1248762084961E+04, .8458502807617E+03},
 {    4006, .8292312500000E+04, -.1277343139648E+04, .8439044189453E+03},
 {    4007, .8298541992188E+04, -.1265519775391E+04, .8411154174805E+03},
 {    4008, .8304772460938E+04, -.1253696289062E+04, .8383262329102E+03},
 {    4009, .8295494140625E+04, -.1280829589844E+04, .8424800415039E+03},
 {    4010, .8306285156250E+04, -.1274003295898E+04, .8376492919922E+03},
 {    4011, .8317077148438E+04, -.1267177001953E+04, .8328181762695E+03},
 {    4012, .8296659179688E+04, -.1285592041016E+04, .8419584350586E+03},
 {    4013, .8309119140625E+04, -.1285592041016E+04, .8363804931641E+03},
 {    4014, .8321579101562E+04, -.1285592041016E+04, .8308020019531E+03},
 {    4015, .8295494140625E+04, -.1290354614258E+04, .8424800415039E+03},
 {    4016, .8306285156250E+04, -.1297180786133E+04, .8376492919922E+03},
 {    4017, .8317077148438E+04, -.1304007080078E+04, .8328181762695E+03},
 {    4018, .8292312500000E+04, -.1293840942383E+04, .8439045410156E+03},
 {    4019, .8298541992188E+04, -.1305664306641E+04, .8411154174805E+03},
 {    4020, .8304772460938E+04, -.1317487792969E+04, .8383262329102E+03},
 {    4021, .8287965820312E+04, -.1295117065430E+04, .8458502807617E+03},
 {    4022, .8287965820312E+04, -.1308769531250E+04, .8458502807617E+03},
 {    4023, .8287965820312E+04, -.1322422119141E+04, .8458502807617E+03},
 {    4024, .8283619140625E+04, -.1293840942383E+04, .8477963867188E+03},
 {    4025, .8277387695312E+04, -.1305664306641E+04, .8505855102539E+03},
 {    4026, .8271157226562E+04, -.1317487792969E+04, .8533746337891E+03},
 {    4027, .8280435546875E+04, -.1290354614258E+04, .8492209472656E+03},
 {    4028, .8269645507812E+04, -.1297180786133E+04, .8540517578125E+03},
 {    4029, .8258852539062E+04, -.1304007080078E+04, .8588827514648E+03},
 {    4030, .8268477539062E+04, -.1285592041016E+04, .8256318969727E+03},
 {    4031, .8256016601562E+04, -.1285592041016E+04, .8312100219727E+03},
 {    4032, .8243555664062E+04, -.1285592041016E+04, .8367886962891E+03},
 {    4033, .8269641601562E+04, -.1280829589844E+04, .8251106567383E+03},
 {    4034, .8258852539062E+04, -.1274003295898E+04, .8299414062500E+03},
 {    4035, .8248061523438E+04, -.1267177001953E+04, .8347722778320E+03},
 {    4036, .8272824218750E+04, -.1277343139648E+04, .8236859741211E+03},
 {    4037, .8266593750000E+04, -.1265519775391E+04, .8264750976562E+03},
 {    4038, .8260362304688E+04, -.1253696289062E+04, .8292642822266E+03},
 {    4039, .8277172851562E+04, -.1276067016602E+04, .8217399902344E+03},
 {    4040, .8277172851562E+04, -.1262414550781E+04, .8217399902344E+03},
 {    4041, .8277172851562E+04, -.1248762084961E+04, .8217399902344E+03},
 {    4042, .8281519531250E+04, -.1277343139648E+04, .8197940673828E+03},
 {    4043, .8287749023438E+04, -.1265519775391E+04, .8170050048828E+03},
 {    4044, .8293979492188E+04, -.1253696289062E+04, .8142157592773E+03},
 {    4045, .8284702148438E+04, -.1280829589844E+04, .8183694458008E+03},
 {    4046, .8295492187500E+04, -.1274003295898E+04, .8135386352539E+03},
 {    4047, .8306285156250E+04, -.1267177001953E+04, .8087073974609E+03},
 {    4048, .8285865234375E+04, -.1285592041016E+04, .8178482055664E+03},
 {    4049, .8298325195312E+04, -.1285592041016E+04, .8122700195312E+03},
 {    4050, .8310787109375E+04, -.1285592041016E+04, .8066917114258E+03},
 {    4051, .8284702148438E+04, -.1290354614258E+04, .8183694458008E+03},
 {    4052, .8295492187500E+04, -.1297180786133E+04, .8135386352539E+03},
 {    4053, .8306285156250E+04, -.1304007080078E+04, .8087073974609E+03},
 {    4054, .8281519531250E+04, -.1293840942383E+04, .8197941894531E+03},
 {    4055, .8287749023438E+04, -.1305664306641E+04, .8170050048828E+03},
 {    4056, .8293979492188E+04, -.1317487792969E+04, .8142158813477E+03},
 {    4057, .8277172851562E+04, -.1295117065430E+04, .8217399902344E+03},
 {    4058, .8277172851562E+04, -.1308769531250E+04, .8217399902344E+03},
 {    4059, .8277172851562E+04, -.1322422119141E+04, .8217399902344E+03},
 {    4060, .8272824218750E+04, -.1293840942383E+04, .8236859741211E+03},
 {    4061, .8266593750000E+04, -.1305664306641E+04, .8264750976562E+03},
 {    4062, .8260362304688E+04, -.1317487792969E+04, .8292642822266E+03},
 {    4063, .8269641601562E+04, -.1290354614258E+04, .8251106567383E+03},
 {    4064, .8258852539062E+04, -.1297180786133E+04, .8299414062500E+03},
 {    4065, .8248061523438E+04, -.1304007080078E+04, .8347722778320E+03},
 {    4066, .8257684570312E+04, -.1285592041016E+04, .8015216064453E+03},
 {    4067, .8245223632812E+04, -.1285592041016E+04, .8070999755859E+03},
 {    4068, .8232763671875E+04, -.1285592041016E+04, .8126779174805E+03},
 {    4069, .8258849609375E+04, -.1280829589844E+04, .8010001831055E+03},
 {    4070, .8248057617188E+04, -.1274003295898E+04, .8058309936523E+03},
 {    4071, .8237266601562E+04, -.1267177001953E+04, .8106618652344E+03},
 {    4072, .8262032226562E+04, -.1277343139648E+04, .7995756835938E+03},
 {    4073, .8255801757812E+04, -.1265519775391E+04, .8023648071289E+03},
 {    4074, .8249571289062E+04, -.1253696289062E+04, .8051539916992E+03},
 {    4075, .8266379882812E+04, -.1276067016602E+04, .7976295776367E+03},
 {    4076, .8266379882812E+04, -.1262414550781E+04, .7976295776367E+03},
 {    4077, .8266379882812E+04, -.1248762084961E+04, .7976295776367E+03},
 {    4078, .8270726562500E+04, -.1277343139648E+04, .7956835937500E+03},
 {    4079, .8276956054688E+04, -.1265519775391E+04, .7928944702148E+03},
 {    4080, .8283185546875E+04, -.1253696289062E+04, .7901054687500E+03},
 {    4081, .8273907226562E+04, -.1280829589844E+04, .7942592773438E+03},
 {    4082, .8284698242188E+04, -.1274003295898E+04, .7894284057617E+03},
 {    4083, .8295490234375E+04, -.1267177124023E+04, .7845974121094E+03},
 {    4084, .8275071289062E+04, -.1285592041016E+04, .7937378540039E+03},
 {    4085, .8287533203125E+04, -.1285592041016E+04, .7881596069336E+03},
 {    4086, .8299994140625E+04, -.1285592041016E+04, .7825811767578E+03},
 {    4087, .8273907226562E+04, -.1290354614258E+04, .7942592773438E+03},
 {    4088, .8284698242188E+04, -.1297180786133E+04, .7894284057617E+03},
 {    4089, .8295490234375E+04, -.1304007080078E+04, .7845974121094E+03},
 {    4090, .8270726562500E+04, -.1293840942383E+04, .7956835937500E+03},
 {    4091, .8276956054688E+04, -.1305664306641E+04, .7928944702148E+03},
 {    4092, .8283185546875E+04, -.1317487792969E+04, .7901054687500E+03},
 {    4093, .8266379882812E+04, -.1295117065430E+04, .7976295776367E+03},
 {    4094, .8266379882812E+04, -.1308769531250E+04, .7976295776367E+03},
 {    4095, .8266379882812E+04, -.1322422119141E+04, .7976295776367E+03},
 {    4096, .8262032226562E+04, -.1293840942383E+04, .7995756835938E+03},
 {    4097, .8255801757812E+04, -.1305664306641E+04, .8023648071289E+03},
 {    4098, .8249571289062E+04, -.1317487792969E+04, .8051539916992E+03},
 {    4099, .8258849609375E+04, -.1290354614258E+04, .8010001831055E+03},
 {    4100, .8248057617188E+04, -.1297180786133E+04, .8058309936523E+03},
 {    4101, .8237266601562E+04, -.1304007080078E+04, .8106618652344E+03},
 {    4102, .8246890625000E+04, -.1285592041016E+04, .7774111328125E+03},
 {    4103, .8234429687500E+04, -.1285592041016E+04, .7829895019531E+03},
 {    4104, .8221969726562E+04, -.1285592041016E+04, .7885675659180E+03},
 {    4105, .8248054687500E+04, -.1280829589844E+04, .7768898315430E+03},
 {    4106, .8237263671875E+04, -.1274003295898E+04, .7817205810547E+03},
 {    4107, .8226472656250E+04, -.1267177124023E+04, .7865515136719E+03},
 {    4108, .8251237304688E+04, -.1277343139648E+04, .7754653930664E+03},
 {    4109, .8245006835938E+04, -.1265519775391E+04, .7782544555664E+03},
 {    4110, .8238776367188E+04, -.1253696289062E+04, .7810434570312E+03},
 {    4111, .8255583984375E+04, -.1276067016602E+04, .7735194091797E+03},
 {    4112, .8255583984375E+04, -.1262414550781E+04, .7735193481445E+03},
 {    4113, .8255583984375E+04, -.1248762084961E+04, .7735193481445E+03},
 {    4114, .8259932617188E+04, -.1277343139648E+04, .7715731201172E+03},
 {    4115, .8266160156250E+04, -.1265519775391E+04, .7687843627930E+03},
 {    4116, .8272391601562E+04, -.1253696411133E+04, .7659952392578E+03},
 {    4117, .8263112304688E+04, -.1280829589844E+04, .7701489868164E+03},
 {    4118, .8273905273438E+04, -.1274003295898E+04, .7653179931641E+03},
 {    4119, .8284696289062E+04, -.1267177124023E+04, .7604870605469E+03},
 {    4120, .8264279296875E+04, -.1285592041016E+04, .7696273803711E+03},
 {    4121, .8276740234375E+04, -.1285592041016E+04, .7640490722656E+03},
 {    4122, .8289199218750E+04, -.1285592041016E+04, .7584710083008E+03},
 {    4123, .8263112304688E+04, -.1290354614258E+04, .7701489868164E+03},
 {    4124, .8273905273438E+04, -.1297180786133E+04, .7653179931641E+03},
 {    4125, .8284696289062E+04, -.1304007080078E+04, .7604870605469E+03},
 {    4126, .8259932617188E+04, -.1293840942383E+04, .7715732421875E+03},
 {    4127, .8266160156250E+04, -.1305664306641E+04, .7687843627930E+03},
 {    4128, .8272391601562E+04, -.1317487792969E+04, .7659952392578E+03},
 {    4129, .8255583984375E+04, -.1295117065430E+04, .7735194091797E+03},
 {    4130, .8255583984375E+04, -.1308769531250E+04, .7735194091797E+03},
 {    4131, .8255583984375E+04, -.1322422119141E+04, .7735194091797E+03},
 {    4132, .8251237304688E+04, -.1293840942383E+04, .7754653930664E+03},
 {    4133, .8245006835938E+04, -.1305664306641E+04, .7782544555664E+03},
 {    4134, .8238776367188E+04, -.1317487792969E+04, .7810434570312E+03},
 {    4135, .8248054687500E+04, -.1290354614258E+04, .7768898315430E+03},
 {    4136, .8237263671875E+04, -.1297180786133E+04, .7817205810547E+03},
 {    4137, .8226472656250E+04, -.1304007080078E+04, .7865515136719E+03},
 {    4138, .8360027343750E+04, -.1285592041016E+04, .1215151489258E+04},
 {    4139, .8346401367188E+04, -.1285592041016E+04, .1215998535156E+04},
 {    4140, .8332776367188E+04, -.1285592041016E+04, .1216846923828E+04},
 {    4141, .8361301757812E+04, -.1280829589844E+04, .1215072021484E+04},
 {    4142, .8349500976562E+04, -.1274003295898E+04, .1215806030273E+04},
 {    4143, .8337700195312E+04, -.1267177001953E+04, .1216540649414E+04},
 {    4144, .8364781250000E+04, -.1277343139648E+04, .1214855224609E+04},
 {    4145, .8357966796875E+04, -.1265519775391E+04, .1215278442383E+04},
 {    4146, .8351154296875E+04, -.1253696289062E+04, .1215702880859E+04},
 {    4147, .8369535156250E+04, -.1276067016602E+04, .1214559692383E+04},
 {    4148, .8369535156250E+04, -.1262414550781E+04, .1214559692383E+04},
 {    4149, .8369535156250E+04, -.1248762084961E+04, .1214559692383E+04},
 {    4150, .8374288085938E+04, -.1277343139648E+04, .1214264038086E+04},
 {    4151, .8381101562500E+04, -.1265519775391E+04, .1213840087891E+04},
 {    4152, .8387914062500E+04, -.1253696289062E+04, .1213415649414E+04},
 {    4153, .8377767578125E+04, -.1280829589844E+04, .1214047119141E+04},
 {    4154, .8389568359375E+04, -.1274003295898E+04, .1213312744141E+04},
 {    4155, .8401369140625E+04, -.1267177001953E+04, .1212578369141E+04},
 {    4156, .8379041015625E+04, -.1285592041016E+04, .1213967285156E+04},
 {    4157, .8392666992188E+04, -.1285592041016E+04, .1213119384766E+04},
 {    4158, .8406292968750E+04, -.1285592041016E+04, .1212271972656E+04},
 {    4159, .8377767578125E+04, -.1290354492188E+04, .1214047119141E+04},
 {    4160, .8389568359375E+04, -.1297180786133E+04, .1213312744141E+04},
 {    4161, .8401369140625E+04, -.1304007080078E+04, .1212578369141E+04},
 {    4162, .8374288085938E+04, -.1293840942383E+04, .1214264038086E+04},
 {    4163, .8381101562500E+04, -.1305664306641E+04, .1213840087891E+04},
 {    4164, .8387914062500E+04, -.1317487792969E+04, .1213415649414E+04},
 {    4165, .8369535156250E+04, -.1295117065430E+04, .1214559692383E+04},
 {    4166, .8369535156250E+04, -.1308769531250E+04, .1214559692383E+04},
 {    4167, .8369535156250E+04, -.1322421997070E+04, .1214559692383E+04},
 {    4168, .8364781250000E+04, -.1293840942383E+04, .1214855224609E+04},
 {    4169, .8357966796875E+04, -.1305664306641E+04, .1215278442383E+04},
 {    4170, .8351154296875E+04, -.1317487792969E+04, .1215702880859E+04},
 {    4171, .8361301757812E+04, -.1290354492188E+04, .1215072021484E+04},
 {    4172, .8349500976562E+04, -.1297180786133E+04, .1215806030273E+04},
 {    4173, .8337700195312E+04, -.1304007080078E+04, .1216540649414E+04},
 {    4174, .8361603515625E+04, -.1285592041016E+04, .1240502197266E+04},
 {    4175, .8347981445312E+04, -.1285592041016E+04, .1241349609375E+04},
 {    4176, .8334351562500E+04, -.1285592041016E+04, .1242197998047E+04},
 {    4177, .8362879882812E+04, -.1280829589844E+04, .1240422485352E+04},
 {    4178, .8351080078125E+04, -.1274003295898E+04, .1241156250000E+04},
 {    4179, .8339278320312E+04, -.1267177001953E+04, .1241891113281E+04},
 {    4180, .8366360351562E+04, -.1277343139648E+04, .1240206176758E+04},
 {    4181, .8359545898438E+04, -.1265519775391E+04, .1240629394531E+04},
 {    4182, .8352732421875E+04, -.1253696289062E+04, .1241053588867E+04},
 {    4183, .8371112304688E+04, -.1276067016602E+04, .1239910400391E+04},
 {    4184, .8371112304688E+04, -.1262414550781E+04, .1239910400391E+04},
 {    4185, .8371112304688E+04, -.1248762084961E+04, .1239910400391E+04},
 {    4186, .8375867187500E+04, -.1277343139648E+04, .1239614624023E+04},
 {    4187, .8382679687500E+04, -.1265519775391E+04, .1239191162109E+04},
 {    4188, .8389491210938E+04, -.1253696289062E+04, .1238766845703E+04},
 {    4189, .8379345703125E+04, -.1280829589844E+04, .1239397827148E+04},
 {    4190, .8391144531250E+04, -.1274003295898E+04, .1238663940430E+04},
 {    4191, .8402946289062E+04, -.1267177001953E+04, .1237929931641E+04},
 {    4192, .8380620117188E+04, -.1285592041016E+04, .1239318847656E+04},
 {    4193, .8394244140625E+04, -.1285592041016E+04, .1238471435547E+04},
 {    4194, .8407872070312E+04, -.1285592041016E+04, .1237623413086E+04},
 {    4195, .8379345703125E+04, -.1290354492188E+04, .1239397827148E+04},
 {    4196, .8391144531250E+04, -.1297180786133E+04, .1238663940430E+04},
 {    4197, .8402946289062E+04, -.1304007080078E+04, .1237929931641E+04},
 {    4198, .8375867187500E+04, -.1293840942383E+04, .1239614624023E+04},
 {    4199, .8382679687500E+04, -.1305664306641E+04, .1239191162109E+04},
 {    4200, .8389491210938E+04, -.1317487792969E+04, .1238766845703E+04},
 {    4201, .8371112304688E+04, -.1295117065430E+04, .1239910400391E+04},
 {    4202, .8371112304688E+04, -.1308769531250E+04, .1239910400391E+04},
 {    4203, .8371112304688E+04, -.1322421997070E+04, .1239910400391E+04},
 {    4204, .8366360351562E+04, -.1293840942383E+04, .1240206176758E+04},
 {    4205, .8359545898438E+04, -.1305664306641E+04, .1240629638672E+04},
 {    4206, .8352732421875E+04, -.1317487792969E+04, .1241053588867E+04},
 {    4207, .8362879882812E+04, -.1290354492188E+04, .1240422485352E+04},
 {    4208, .8351080078125E+04, -.1297180786133E+04, .1241156250000E+04},
 {    4209, .8339278320312E+04, -.1304007080078E+04, .1241891113281E+04},
 {    4210, .8363184570312E+04, -.1285592041016E+04, .1265853027344E+04},
 {    4211, .8349556640625E+04, -.1285592041016E+04, .1266700805664E+04},
 {    4212, .8335931640625E+04, -.1285592041016E+04, .1267548339844E+04},
 {    4213, .8364458984375E+04, -.1280829589844E+04, .1265773193359E+04},
 {    4214, .8352655273438E+04, -.1274003295898E+04, .1266507568359E+04},
 {    4215, .8340855468750E+04, -.1267177001953E+04, .1267241943359E+04},
 {    4216, .8367935546875E+04, -.1277343139648E+04, .1265556884766E+04},
 {    4217, .8361125000000E+04, -.1265519775391E+04, .1265981445312E+04},
 {    4218, .8354309570312E+04, -.1253696289062E+04, .1266405273438E+04},
 {    4219, .8372689453125E+04, -.1276067016602E+04, .1265261230469E+04},
 {    4220, .8372689453125E+04, -.1262414550781E+04, .1265261230469E+04},
 {    4221, .8372689453125E+04, -.1248762084961E+04, .1265261230469E+04},
 {    4222, .8377443359375E+04, -.1277343139648E+04, .1264965820312E+04},
 {    4223, .8384255859375E+04, -.1265519775391E+04, .1264541625977E+04},
 {    4224, .8391068359375E+04, -.1253696289062E+04, .1264117431641E+04},
 {    4225, .8380922851562E+04, -.1280829589844E+04, .1264749023438E+04},
 {    4226, .8392721679688E+04, -.1274003295898E+04, .1264015380859E+04},
 {    4227, .8404526367188E+04, -.1267177001953E+04, .1263280273438E+04},
 {    4228, .8382197265625E+04, -.1285592041016E+04, .1264669921875E+04},
 {    4229, .8395821289062E+04, -.1285592041016E+04, .1263822265625E+04},
 {    4230, .8409449218750E+04, -.1285592041016E+04, .1262974243164E+04},
 {    4231, .8380922851562E+04, -.1290354492188E+04, .1264749023438E+04},
 {    4232, .8392721679688E+04, -.1297180786133E+04, .1264015380859E+04},
 {    4233, .8404526367188E+04, -.1304007080078E+04, .1263280273438E+04},
 {    4234, .8377443359375E+04, -.1293840942383E+04, .1264965820312E+04},
 {    4235, .8384255859375E+04, -.1305664306641E+04, .1264541625977E+04},
 {    4236, .8391068359375E+04, -.1317487792969E+04, .1264117431641E+04},
 {    4237, .8372689453125E+04, -.1295117065430E+04, .1265261230469E+04},
 {    4238, .8372689453125E+04, -.1308769531250E+04, .1265261230469E+04},
 {    4239, .8372689453125E+04, -.1322421997070E+04, .1265261230469E+04},
 {    4240, .8367935546875E+04, -.1293840942383E+04, .1265556884766E+04},
 {    4241, .8361125000000E+04, -.1305664306641E+04, .1265981445312E+04},
 {    4242, .8354309570312E+04, -.1317487792969E+04, .1266405273438E+04},
 {    4243, .8364458984375E+04, -.1290354492188E+04, .1265773193359E+04},
 {    4244, .8352655273438E+04, -.1297180786133E+04, .1266507568359E+04},
 {    4245, .8340855468750E+04, -.1304007080078E+04, .1267241943359E+04},
 {    4246, .8364759765625E+04, -.1285592041016E+04, .1291203613281E+04},
 {    4247, .8351133789062E+04, -.1285592041016E+04, .1292051757812E+04},
 {    4248, .8337506835938E+04, -.1285592041016E+04, .1292899536133E+04},
 {    4249, .8366034179688E+04, -.1280829467773E+04, .1291124267578E+04},
 {    4250, .8354232421875E+04, -.1274003295898E+04, .1291859130859E+04},
 {    4251, .8342430664062E+04, -.1267177001953E+04, .1292593261719E+04},
 {    4252, .8369512695312E+04, -.1277343139648E+04, .1290907470703E+04},
 {    4253, .8362700195312E+04, -.1265519775391E+04, .1291331787109E+04},
 {    4254, .8355888671875E+04, -.1253696289062E+04, .1291756103516E+04},
 {    4255, .8374268554688E+04, -.1276067016602E+04, .1290612792969E+04},
 {    4256, .8374268554688E+04, -.1262414550781E+04, .1290612792969E+04},
 {    4257, .8374268554688E+04, -.1248762084961E+04, .1290612792969E+04},
 {    4258, .8379019531250E+04, -.1277343139648E+04, .1290316284180E+04},
 {    4259, .8385833984375E+04, -.1265519775391E+04, .1289892456055E+04},
 {    4260, .8392646484375E+04, -.1253696289062E+04, .1289468994141E+04},
 {    4261, .8382500976562E+04, -.1280829467773E+04, .1290101074219E+04},
 {    4262, .8394299804688E+04, -.1274003295898E+04, .1289366699219E+04},
 {    4263, .8406099609375E+04, -.1267177001953E+04, .1288631835938E+04},
 {    4264, .8383772460938E+04, -.1285592041016E+04, .1290021118164E+04},
 {    4265, .8397399414062E+04, -.1285592041016E+04, .1289173217773E+04},
 {    4266, .8411025390625E+04, -.1285592041016E+04, .1288325927734E+04},
 {    4267, .8382500976562E+04, -.1290354492188E+04, .1290101074219E+04},
 {    4268, .8394299804688E+04, -.1297180786133E+04, .1289366699219E+04},
 {    4269, .8406099609375E+04, -.1304007080078E+04, .1288631835938E+04},
 {    4270, .8379019531250E+04, -.1293840942383E+04, .1290316284180E+04},
 {    4271, .8385833984375E+04, -.1305664306641E+04, .1289892456055E+04},
 {    4272, .8392646484375E+04, -.1317487792969E+04, .1289468994141E+04},
 {    4273, .8374268554688E+04, -.1295117065430E+04, .1290612792969E+04},
 {    4274, .8374268554688E+04, -.1308769531250E+04, .1290612792969E+04},
 {    4275, .8374268554688E+04, -.1322421997070E+04, .1290612792969E+04},
 {    4276, .8369512695312E+04, -.1293840942383E+04, .1290907470703E+04},
 {    4277, .8362700195312E+04, -.1305664306641E+04, .1291331787109E+04},
 {    4278, .8355888671875E+04, -.1317487792969E+04, .1291756103516E+04},
 {    4279, .8366034179688E+04, -.1290354492188E+04, .1291124267578E+04},
 {    4280, .8354232421875E+04, -.1297180786133E+04, .1291859130859E+04},
 {    4281, .8342430664062E+04, -.1304007080078E+04, .1292593261719E+04},
 {    4282, .8366336914062E+04, -.1285592041016E+04, .1316554931641E+04},
 {    4283, .8352710937500E+04, -.1285592041016E+04, .1317402832031E+04},
 {    4284, .8339083984375E+04, -.1285592041016E+04, .1318249755859E+04},
 {    4285, .8367611328125E+04, -.1280829467773E+04, .1316475830078E+04},
 {    4286, .8355811523438E+04, -.1274003295898E+04, .1317209472656E+04},
 {    4287, .8344010742188E+04, -.1267177001953E+04, .1317943847656E+04},
 {    4288, .8371091796875E+04, -.1277343139648E+04, .1316259277344E+04},
 {    4289, .8364277343750E+04, -.1265519775391E+04, .1316682739258E+04},
 {    4290, .8357464843750E+04, -.1253696289062E+04, .1317106811523E+04},
 {    4291, .8375843750000E+04, -.1276067016602E+04, .1315962890625E+04},
 {    4292, .8375843750000E+04, -.1262414550781E+04, .1315962890625E+04},
 {    4293, .8375843750000E+04, -.1248762084961E+04, .1315962890625E+04},
 {    4294, .8380600585938E+04, -.1277343139648E+04, .1315667480469E+04},
 {    4295, .8387410156250E+04, -.1265519775391E+04, .1315244384766E+04},
 {    4296, .8394223632812E+04, -.1253696289062E+04, .1314819213867E+04},
 {    4297, .8384076171875E+04, -.1280829467773E+04, .1315450683594E+04},
 {    4298, .8395876953125E+04, -.1274003295898E+04, .1314717041016E+04},
 {    4299, .8407678710938E+04, -.1267177001953E+04, .1313982666016E+04},
 {    4300, .8385350585938E+04, -.1285592041016E+04, .1315371826172E+04},
 {    4301, .8398976562500E+04, -.1285592041016E+04, .1314524658203E+04},
 {    4302, .8412604492188E+04, -.1285592041016E+04, .1313676269531E+04},
 {    4303, .8384076171875E+04, -.1290354492188E+04, .1315450683594E+04},
 {    4304, .8395876953125E+04, -.1297180786133E+04, .1314717041016E+04},
 {    4305, .8407678710938E+04, -.1304007080078E+04, .1313982666016E+04},
 {    4306, .8380600585938E+04, -.1293840942383E+04, .1315667480469E+04},
 {    4307, .8387410156250E+04, -.1305664306641E+04, .1315244384766E+04},
 {    4308, .8394223632812E+04, -.1317487792969E+04, .1314819213867E+04},
 {    4309, .8375843750000E+04, -.1295117065430E+04, .1315962890625E+04},
 {    4310, .8375843750000E+04, -.1308769531250E+04, .1315962890625E+04},
 {    4311, .8375843750000E+04, -.1322421997070E+04, .1315962890625E+04},
 {    4312, .8371091796875E+04, -.1293840942383E+04, .1316259277344E+04},
 {    4313, .8364277343750E+04, -.1305664306641E+04, .1316682739258E+04},
 {    4314, .8357464843750E+04, -.1317487792969E+04, .1317106811523E+04},
 {    4315, .8367611328125E+04, -.1290354492188E+04, .1316475830078E+04},
 {    4316, .8355811523438E+04, -.1297180786133E+04, .1317209472656E+04},
 {    4317, .8344010742188E+04, -.1304007080078E+04, .1317943847656E+04},
 {    4318, .8367916015625E+04, -.1285592041016E+04, .1341906250000E+04},
 {    4319, .8354288085938E+04, -.1285592041016E+04, .1342754028320E+04},
 {    4320, .8340663085938E+04, -.1285592041016E+04, .1343600708008E+04},
 {    4321, .8369189453125E+04, -.1280829467773E+04, .1341826538086E+04},
 {    4322, .8357387695312E+04, -.1274003295898E+04, .1342560791016E+04},
 {    4323, .8345588867188E+04, -.1267177001953E+04, .1343294677734E+04},
 {    4324, .8372667968750E+04, -.1277343139648E+04, .1341609985352E+04},
 {    4325, .8365855468750E+04, -.1265519775391E+04, .1342033447266E+04},
 {    4326, .8359041992188E+04, -.1253696289062E+04, .1342457031250E+04},
 {    4327, .8377421875000E+04, -.1276067016602E+04, .1341314453125E+04},
 {    4328, .8377421875000E+04, -.1262414550781E+04, .1341314453125E+04},
 {    4329, .8377421875000E+04, -.1248762084961E+04, .1341314453125E+04},
 {    4330, .8382174804688E+04, -.1277343139648E+04, .1341018554688E+04},
 {    4331, .8388986328125E+04, -.1265519775391E+04, .1340594970703E+04},
 {    4332, .8395800781250E+04, -.1253696289062E+04, .1340171142578E+04},
 {    4333, .8385653320312E+04, -.1280829467773E+04, .1340802246094E+04},
 {    4334, .8397456054688E+04, -.1274003295898E+04, .1340067626953E+04},
 {    4335, .8409255859375E+04, -.1267177001953E+04, .1339333618164E+04},
 {    4336, .8386927734375E+04, -.1285592041016E+04, .1340722656250E+04},
 {    4337, .8400553710938E+04, -.1285592041016E+04, .1339874511719E+04},
 {    4338, .8414179687500E+04, -.1285592041016E+04, .1339027832031E+04},
 {    4339, .8385653320312E+04, -.1290354492188E+04, .1340802246094E+04},
 {    4340, .8397456054688E+04, -.1297180786133E+04, .1340067626953E+04},
 {    4341, .8409255859375E+04, -.1304007080078E+04, .1339333618164E+04},
 {    4342, .8382174804688E+04, -.1293840942383E+04, .1341018554688E+04},
 {    4343, .8388986328125E+04, -.1305664306641E+04, .1340594970703E+04},
 {    4344, .8395800781250E+04, -.1317487792969E+04, .1340171142578E+04},
 {    4345, .8377421875000E+04, -.1295117065430E+04, .1341314453125E+04},
 {    4346, .8377421875000E+04, -.1308769531250E+04, .1341314453125E+04},
 {    4347, .8377421875000E+04, -.1322421997070E+04, .1341314453125E+04},
 {    4348, .8372667968750E+04, -.1293840942383E+04, .1341609985352E+04},
 {    4349, .8365855468750E+04, -.1305664306641E+04, .1342033447266E+04},
 {    4350, .8359041992188E+04, -.1317487792969E+04, .1342457031250E+04},
 {    4351, .8369189453125E+04, -.1290354492188E+04, .1341826538086E+04},
 {    4352, .8357387695312E+04, -.1297180786133E+04, .1342560791016E+04},
 {    4353, .8345588867188E+04, -.1304007080078E+04, .1343294677734E+04},
 {    4354, .8285778320312E+04, -.1336392089844E+04, .7321741943359E+03},
 {    4355, .8268388671875E+04, -.1336392089844E+04, .7399581909180E+03},
 {    4356, .8285778320312E+04, -.1317342041016E+04, .7321741943359E+03},
 {    4357, .8273025390625E+04, -.1317342041016E+04, .7378823852539E+03},
 {    4358, .8285778320312E+04, -.1298292114258E+04, .7321741943359E+03},
 {    4359, .8277663085938E+04, -.1298292114258E+04, .7358067016602E+03},
 {    4360, .8275400390625E+04, -.1336392089844E+04, .7089911499023E+03},
 {    4361, .8258010742188E+04, -.1336392089844E+04, .7167747802734E+03},
 {    4362, .8275400390625E+04, -.1317342041016E+04, .7089911499023E+03},
 {    4363, .8262648437500E+04, -.1317342041016E+04, .7146995239258E+03},
 {    4364, .8275400390625E+04, -.1298292114258E+04, .7089911499023E+03},
 {    4365, .8267286132812E+04, -.1298292114258E+04, .7126237182617E+03},
 {    4366, .8285778320312E+04, -.1272892089844E+04, .7321741943359E+03},
 {    4367, .8277663085938E+04, -.1272892089844E+04, .7358067016602E+03},
 {    4368, .8275400390625E+04, -.1272892089844E+04, .7089911499023E+03},
 {    4369, .8267286132812E+04, -.1272892089844E+04, .7126237182617E+03},
 {    4370, .8285778320312E+04, -.1253842041016E+04, .7321741943359E+03},
 {    4371, .8273025390625E+04, -.1253842041016E+04, .7378823852539E+03},
 {    4372, .8285778320312E+04, -.1234792114258E+04, .7321741943359E+03},
 {    4373, .8268388671875E+04, -.1234792114258E+04, .7399581909180E+03},
 {    4374, .8275400390625E+04, -.1253842041016E+04, .7089911499023E+03},
 {    4375, .8262648437500E+04, -.1253842041016E+04, .7146995239258E+03},
 {    4376, .8275400390625E+04, -.1234792114258E+04, .7089911499023E+03},
 {    4377, .8258010742188E+04, -.1234792114258E+04, .7167747802734E+03},
 {    4378, .8278768554688E+04, -.1336392089844E+04, .7631411132812E+03},
 {    4379, .8263314453125E+04, -.1336392089844E+04, .7700597534180E+03},
 {    4380, .8247856445312E+04, -.1336392089844E+04, .7769786987305E+03},
 {    4381, .8232401367188E+04, -.1336392089844E+04, .7838974609375E+03},
 {    4382, .8283405273438E+04, -.1317342041016E+04, .7610656127930E+03},
 {    4383, .8264858398438E+04, -.1317342041016E+04, .7693679199219E+03},
 {    4384, .8246311523438E+04, -.1317342041016E+04, .7776707763672E+03},
 {    4385, .8227764648438E+04, -.1317342041016E+04, .7859730224609E+03},
 {    4386, .8288041015625E+04, -.1298292114258E+04, .7589898681641E+03},
 {    4387, .8266404296875E+04, -.1298292114258E+04, .7686760253906E+03},
 {    4388, .8244767578125E+04, -.1298292114258E+04, .7783623657227E+03},
 {    4389, .8223128906250E+04, -.1298292114258E+04, .7880487060547E+03},
 {    4390, .8252934570312E+04, -.1336392089844E+04, .7468768920898E+03},
 {    4391, .8237478515625E+04, -.1336392089844E+04, .7537955932617E+03},
 {    4392, .8222026367188E+04, -.1336392089844E+04, .7607140502930E+03},
 {    4393, .8254480468750E+04, -.1317342041016E+04, .7461848144531E+03},
 {    4394, .8235935546875E+04, -.1317342041016E+04, .7544873657227E+03},
 {    4395, .8217388671875E+04, -.1317342041016E+04, .7627896728516E+03},
 {    4396, .8256026367188E+04, -.1298292114258E+04, .7454929199219E+03},
 {    4397, .8234388671875E+04, -.1298292114258E+04, .7551792602539E+03},
 {    4398, .8212750976562E+04, -.1298292114258E+04, .7648654174805E+03},
 {    4399, .8242556640625E+04, -.1336392089844E+04, .7236938476562E+03},
 {    4400, .8227099609375E+04, -.1336392089844E+04, .7306127319336E+03},
 {    4401, .8211645507812E+04, -.1336392089844E+04, .7375313110352E+03},
 {    4402, .8244101562500E+04, -.1317342041016E+04, .7230019531250E+03},
 {    4403, .8225555664062E+04, -.1317342041016E+04, .7313045043945E+03},
 {    4404, .8207010742188E+04, -.1317342041016E+04, .7396068115234E+03},
 {    4405, .8245647460938E+04, -.1298292114258E+04, .7223100585938E+03},
 {    4406, .8224010742188E+04, -.1298292114258E+04, .7319962158203E+03},
 {    4407, .8202372070312E+04, -.1298292114258E+04, .7416827392578E+03},
 {    4408, .8288041015625E+04, -.1272892089844E+04, .7589898681641E+03},
 {    4409, .8266404296875E+04, -.1272892089844E+04, .7686760253906E+03},
 {    4410, .8244767578125E+04, -.1272892089844E+04, .7783623657227E+03},
 {    4411, .8223128906250E+04, -.1272892089844E+04, .7880487060547E+03},
 {    4412, .8256026367188E+04, -.1272892089844E+04, .7454929199219E+03},
 {    4413, .8234388671875E+04, -.1272892089844E+04, .7551792602539E+03},
 {    4414, .8212750976562E+04, -.1272892089844E+04, .7648654174805E+03},
 {    4415, .8245647460938E+04, -.1272892089844E+04, .7223100585938E+03},
 {    4416, .8224010742188E+04, -.1272892089844E+04, .7319962158203E+03},
 {    4417, .8202372070312E+04, -.1272892089844E+04, .7416827392578E+03},
 {    4418, .8283405273438E+04, -.1253842041016E+04, .7610656127930E+03},
 {    4419, .8264858398438E+04, -.1253842041016E+04, .7693679199219E+03},
 {    4420, .8246311523438E+04, -.1253842041016E+04, .7776707763672E+03},
 {    4421, .8227764648438E+04, -.1253842041016E+04, .7859730224609E+03},
 {    4422, .8278768554688E+04, -.1234792114258E+04, .7631411132812E+03},
 {    4423, .8263314453125E+04, -.1234792114258E+04, .7700597534180E+03},
 {    4424, .8247856445312E+04, -.1234792114258E+04, .7769786987305E+03},
 {    4425, .8232401367188E+04, -.1234792114258E+04, .7838974609375E+03},
 {    4426, .8254480468750E+04, -.1253842041016E+04, .7461848144531E+03},
 {    4427, .8235935546875E+04, -.1253842041016E+04, .7544873657227E+03},
 {    4428, .8217388671875E+04, -.1253842041016E+04, .7627896728516E+03},
 {    4429, .8252934570312E+04, -.1234792114258E+04, .7468768920898E+03},
 {    4430, .8237478515625E+04, -.1234792114258E+04, .7537954711914E+03},
 {    4431, .8222026367188E+04, -.1234792114258E+04, .7607140502930E+03},
 {    4432, .8244101562500E+04, -.1253842041016E+04, .7230019531250E+03},
 {    4433, .8225555664062E+04, -.1253842041016E+04, .7313045043945E+03},
 {    4434, .8207010742188E+04, -.1253842041016E+04, .7396068115234E+03},
 {    4435, .8242556640625E+04, -.1234792114258E+04, .7236937255859E+03},
 {    4436, .8227099609375E+04, -.1234792114258E+04, .7306126708984E+03},
 {    4437, .8211645507812E+04, -.1234792114258E+04, .7375313110352E+03},
 {    4438, .8204635742188E+04, -.1336392089844E+04, .7684982910156E+03},
 {    4439, .8204635742188E+04, -.1317342041016E+04, .7684982910156E+03},
 {    4440, .8204635742188E+04, -.1298292114258E+04, .7684982910156E+03},
 {    4441, .8194258789062E+04, -.1336392089844E+04, .7453149414062E+03},
 {    4442, .8194258789062E+04, -.1317342041016E+04, .7453149414062E+03},
 {    4443, .8194258789062E+04, -.1298292114258E+04, .7453149414062E+03},
 {    4444, .8204635742188E+04, -.1272892089844E+04, .7684982910156E+03},
 {    4445, .8194258789062E+04, -.1272892089844E+04, .7453149414062E+03},
 {    4446, .8204635742188E+04, -.1253842041016E+04, .7684982910156E+03},
 {    4447, .8204635742188E+04, -.1234792114258E+04, .7684982910156E+03},
 {    4448, .8194258789062E+04, -.1253842041016E+04, .7453149414062E+03},
 {    4449, .8194258789062E+04, -.1234792114258E+04, .7453149414062E+03},
 {    4450, .8441018554688E+04, -.1316072021484E+04, .1063415771484E+04},
 {    4451, .8446815429688E+04, -.1316072021484E+04, .1060821289062E+04},
 {    4452, .8452613281250E+04, -.1316072021484E+04, .1058226318359E+04},
 {    4453, .8441018554688E+04, -.1300832031250E+04, .1063415771484E+04},
 {    4454, .8446815429688E+04, -.1300832031250E+04, .1060821289062E+04},
 {    4455, .8452613281250E+04, -.1300832031250E+04, .1058226318359E+04},
 {    4456, .8441018554688E+04, -.1285592041016E+04, .1063415771484E+04},
 {    4457, .8446815429688E+04, -.1285592041016E+04, .1060821289062E+04},
 {    4458, .8452613281250E+04, -.1285592041016E+04, .1058226318359E+04},
 {    4459, .8441018554688E+04, -.1270352050781E+04, .1063415771484E+04},
 {    4460, .8446815429688E+04, -.1270352050781E+04, .1060821289062E+04},
 {    4461, .8452613281250E+04, -.1270352050781E+04, .1058226318359E+04},
 {    4462, .8441018554688E+04, -.1255112060547E+04, .1063415771484E+04},
 {    4463, .8446815429688E+04, -.1255112060547E+04, .1060821289062E+04},
 {    4464, .8452613281250E+04, -.1255112060547E+04, .1058226318359E+04},
 {    4465, .8435829101562E+04, -.1316072021484E+04, .1051824462891E+04},
 {    4466, .8441626953125E+04, -.1316072021484E+04, .1049229736328E+04},
 {    4467, .8447420898438E+04, -.1316072021484E+04, .1046635253906E+04},
 {    4468, .8435829101562E+04, -.1300832031250E+04, .1051824462891E+04},
 {    4469, .8441626953125E+04, -.1300832031250E+04, .1049229736328E+04},
 {    4470, .8447420898438E+04, -.1300832031250E+04, .1046635253906E+04},
 {    4471, .8435829101562E+04, -.1285592041016E+04, .1051824462891E+04},
 {    4472, .8441626953125E+04, -.1285592041016E+04, .1049229736328E+04},
 {    4473, .8447420898438E+04, -.1285592041016E+04, .1046635253906E+04},
 {    4474, .8435829101562E+04, -.1270352050781E+04, .1051824462891E+04},
 {    4475, .8441626953125E+04, -.1270352050781E+04, .1049229736328E+04},
 {    4476, .8447420898438E+04, -.1270352050781E+04, .1046635253906E+04},
 {    4477, .8435829101562E+04, -.1255112060547E+04, .1051824462891E+04},
 {    4478, .8441626953125E+04, -.1255112060547E+04, .1049229736328E+04},
 {    4479, .8447420898438E+04, -.1255112060547E+04, .1046635253906E+04},
 {    4480, .8430640625000E+04, -.1316072021484E+04, .1040232788086E+04},
 {    4481, .8436436523438E+04, -.1316072021484E+04, .1037638305664E+04},
 {    4482, .8442232421875E+04, -.1316072021484E+04, .1035043945312E+04},
 {    4483, .8430640625000E+04, -.1300832031250E+04, .1040232788086E+04},
 {    4484, .8436436523438E+04, -.1300832031250E+04, .1037638305664E+04},
 {    4485, .8442232421875E+04, -.1300832031250E+04, .1035043945312E+04},
 {    4486, .8430640625000E+04, -.1285592041016E+04, .1040232788086E+04},
 {    4487, .8436436523438E+04, -.1285592041016E+04, .1037638305664E+04},
 {    4488, .8442232421875E+04, -.1285592041016E+04, .1035043945312E+04},
 {    4489, .8430640625000E+04, -.1270352050781E+04, .1040232788086E+04},
 {    4490, .8436436523438E+04, -.1270352050781E+04, .1037638305664E+04},
 {    4491, .8442232421875E+04, -.1270352050781E+04, .1035043945312E+04},
 {    4492, .8430640625000E+04, -.1255112060547E+04, .1040232788086E+04},
 {    4493, .8436436523438E+04, -.1255112060547E+04, .1037638305664E+04},
 {    4494, .8442232421875E+04, -.1255112060547E+04, .1035043945312E+04},
 {    4495, .8425451171875E+04, -.1316072021484E+04, .1028641723633E+04},
 {    4496, .8431246093750E+04, -.1316072021484E+04, .1026047363281E+04},
 {    4497, .8437041992188E+04, -.1316072021484E+04, .1023452514648E+04},
 {    4498, .8425451171875E+04, -.1300832031250E+04, .1028641723633E+04},
 {    4499, .8431246093750E+04, -.1300832031250E+04, .1026047363281E+04},
 {    4500, .8437041992188E+04, -.1300832031250E+04, .1023452514648E+04},
 {    4501, .8425451171875E+04, -.1285592041016E+04, .1028641723633E+04},
 {    4502, .8431246093750E+04, -.1285592041016E+04, .1026047363281E+04},
 {    4503, .8437041992188E+04, -.1285592041016E+04, .1023452514648E+04},
 {    4504, .8425451171875E+04, -.1270352050781E+04, .1028641723633E+04},
 {    4505, .8431246093750E+04, -.1270352050781E+04, .1026047363281E+04},
 {    4506, .8437041992188E+04, -.1270352050781E+04, .1023452514648E+04},
 {    4507, .8425451171875E+04, -.1255112060547E+04, .1028641723633E+04},
 {    4508, .8431246093750E+04, -.1255112060547E+04, .1026047363281E+04},
 {    4509, .8437041992188E+04, -.1255112060547E+04, .1023452514648E+04},
 {    4510, .8420261718750E+04, -.1316072021484E+04, .1017049621582E+04},
 {    4511, .8426059570312E+04, -.1316072021484E+04, .1014454711914E+04},
 {    4512, .8431854492188E+04, -.1316072021484E+04, .1011860656738E+04},
 {    4513, .8420261718750E+04, -.1300832031250E+04, .1017049621582E+04},
 {    4514, .8426059570312E+04, -.1300832031250E+04, .1014454711914E+04},
 {    4515, .8431854492188E+04, -.1300832031250E+04, .1011860656738E+04},
 {    4516, .8420261718750E+04, -.1285592041016E+04, .1017049621582E+04},
 {    4517, .8426059570312E+04, -.1285592041016E+04, .1014454711914E+04},
 {    4518, .8431854492188E+04, -.1285592041016E+04, .1011860656738E+04},
 {    4519, .8420261718750E+04, -.1270352050781E+04, .1017049621582E+04},
 {    4520, .8426059570312E+04, -.1270352050781E+04, .1014454711914E+04},
 {    4521, .8431854492188E+04, -.1270352050781E+04, .1011860656738E+04},
 {    4522, .8420261718750E+04, -.1255112060547E+04, .1017049621582E+04},
 {    4523, .8426059570312E+04, -.1255112060547E+04, .1014454711914E+04},
 {    4524, .8431854492188E+04, -.1255112060547E+04, .1011860656738E+04},
 {    4525, .8418965820312E+04, -.1316072021484E+04, .1014152038574E+04},
 {    4526, .8424761718750E+04, -.1316072021484E+04, .1011557006836E+04},
 {    4527, .8430557617188E+04, -.1316072021484E+04, .1008962524414E+04},
 {    4528, .8418965820312E+04, -.1300832031250E+04, .1014152038574E+04},
 {    4529, .8424761718750E+04, -.1300832031250E+04, .1011557006836E+04},
 {    4530, .8430557617188E+04, -.1300832031250E+04, .1008962524414E+04},
 {    4531, .8418965820312E+04, -.1285592041016E+04, .1014152038574E+04},
 {    4532, .8424761718750E+04, -.1285592041016E+04, .1011557006836E+04},
 {    4533, .8430557617188E+04, -.1285592041016E+04, .1008962524414E+04},
 {    4534, .8418965820312E+04, -.1270352050781E+04, .1014152038574E+04},
 {    4535, .8424761718750E+04, -.1270352050781E+04, .1011557006836E+04},
 {    4536, .8430557617188E+04, -.1270352050781E+04, .1008962524414E+04},
 {    4537, .8418965820312E+04, -.1255112060547E+04, .1014152038574E+04},
 {    4538, .8424761718750E+04, -.1255112060547E+04, .1011557006836E+04},
 {    4539, .8430557617188E+04, -.1255112060547E+04, .1008962524414E+04},
 {    4540, .8413776367188E+04, -.1316072021484E+04, .1002560485840E+04},
 {    4541, .8419572265625E+04, -.1316072021484E+04, .9999659423828E+03},
 {    4542, .8425366210938E+04, -.1316072021484E+04, .9973714599609E+03},
 {    4543, .8413776367188E+04, -.1300832031250E+04, .1002560485840E+04},
 {    4544, .8419572265625E+04, -.1300832031250E+04, .9999659423828E+03},
 {    4545, .8425366210938E+04, -.1300832031250E+04, .9973714599609E+03},
 {    4546, .8413776367188E+04, -.1285592041016E+04, .1002560485840E+04},
 {    4547, .8419572265625E+04, -.1285592041016E+04, .9999659423828E+03},
 {    4548, .8425366210938E+04, -.1285592041016E+04, .9973714599609E+03},
 {    4549, .8413776367188E+04, -.1270352050781E+04, .1002560485840E+04},
 {    4550, .8419572265625E+04, -.1270352050781E+04, .9999659423828E+03},
 {    4551, .8425366210938E+04, -.1270352050781E+04, .9973714599609E+03},
 {    4552, .8413776367188E+04, -.1255112060547E+04, .1002560485840E+04},
 {    4553, .8419572265625E+04, -.1255112060547E+04, .9999659423828E+03},
 {    4554, .8425366210938E+04, -.1255112060547E+04, .9973714599609E+03},
 {    4555, .8408587890625E+04, -.1316072021484E+04, .9909688720703E+03},
 {    4556, .8414383789062E+04, -.1316072021484E+04, .9883745117188E+03},
 {    4557, .8420177734375E+04, -.1316072021484E+04, .9857799072266E+03},
 {    4558, .8408587890625E+04, -.1300832031250E+04, .9909688720703E+03},
 {    4559, .8414383789062E+04, -.1300832031250E+04, .9883745117188E+03},
 {    4560, .8420177734375E+04, -.1300832031250E+04, .9857799072266E+03},
 {    4561, .8408587890625E+04, -.1285592041016E+04, .9909688720703E+03},
 {    4562, .8414383789062E+04, -.1285592041016E+04, .9883745117188E+03},
 {    4563, .8420177734375E+04, -.1285592041016E+04, .9857799072266E+03},
 {    4564, .8408587890625E+04, -.1270352050781E+04, .9909688720703E+03},
 {    4565, .8414383789062E+04, -.1270352050781E+04, .9883745117188E+03},
 {    4566, .8420177734375E+04, -.1270352050781E+04, .9857799072266E+03},
 {    4567, .8408587890625E+04, -.1255112060547E+04, .9909688720703E+03},
 {    4568, .8414383789062E+04, -.1255112060547E+04, .9883745117188E+03},
 {    4569, .8420177734375E+04, -.1255112060547E+04, .9857799072266E+03},
 {    4570, .8407289062500E+04, -.1316072021484E+04, .9880708007812E+03},
 {    4571, .8413086914062E+04, -.1316072021484E+04, .9854764404297E+03},
 {    4572, .8418881835938E+04, -.1316072021484E+04, .9828820800781E+03},
 {    4573, .8407289062500E+04, -.1300832031250E+04, .9880708007812E+03},
 {    4574, .8413086914062E+04, -.1300832031250E+04, .9854764404297E+03},
 {    4575, .8418881835938E+04, -.1300832031250E+04, .9828820800781E+03},
 {    4576, .8407289062500E+04, -.1285592041016E+04, .9880708007812E+03},
 {    4577, .8413086914062E+04, -.1285592041016E+04, .9854764404297E+03},
 {    4578, .8418881835938E+04, -.1285592041016E+04, .9828820800781E+03},
 {    4579, .8407289062500E+04, -.1270352050781E+04, .9880708007812E+03},
 {    4580, .8413086914062E+04, -.1270352050781E+04, .9854764404297E+03},
 {    4581, .8418881835938E+04, -.1270352050781E+04, .9828820800781E+03},
 {    4582, .8407289062500E+04, -.1255112060547E+04, .9880708007812E+03},
 {    4583, .8413086914062E+04, -.1255112060547E+04, .9854764404297E+03},
 {    4584, .8418881835938E+04, -.1255112060547E+04, .9828820800781E+03},
 {    4585, .8402100585938E+04, -.1316072021484E+04, .9764794921875E+03},
 {    4586, .8407896484375E+04, -.1316072021484E+04, .9738850097656E+03},
 {    4587, .8413689453125E+04, -.1316072021484E+04, .9712902832031E+03},
 {    4588, .8402100585938E+04, -.1300832031250E+04, .9764794921875E+03},
 {    4589, .8407896484375E+04, -.1300832031250E+04, .9738850097656E+03},
 {    4590, .8413689453125E+04, -.1300832031250E+04, .9712902832031E+03},
 {    4591, .8402100585938E+04, -.1285592041016E+04, .9764794921875E+03},
 {    4592, .8407896484375E+04, -.1285592041016E+04, .9738850097656E+03},
 {    4593, .8413689453125E+04, -.1285592041016E+04, .9712902832031E+03},
 {    4594, .8402100585938E+04, -.1270352050781E+04, .9764794921875E+03},
 {    4595, .8407896484375E+04, -.1270352050781E+04, .9738850097656E+03},
 {    4596, .8413689453125E+04, -.1270352050781E+04, .9712902832031E+03},
 {    4597, .8402100585938E+04, -.1255112060547E+04, .9764794921875E+03},
 {    4598, .8407896484375E+04, -.1255112060547E+04, .9738850097656E+03},
 {    4599, .8413689453125E+04, -.1255112060547E+04, .9712902832031E+03},
 {    4600, .8396912109375E+04, -.1316072021484E+04, .9648877563477E+03},
 {    4601, .8402708007812E+04, -.1316072021484E+04, .9622937011719E+03},
 {    4602, .8408500976562E+04, -.1316072021484E+04, .9596988525391E+03},
 {    4603, .8396912109375E+04, -.1300832031250E+04, .9648877563477E+03},
 {    4604, .8402708007812E+04, -.1300832031250E+04, .9622937011719E+03},
 {    4605, .8408500976562E+04, -.1300832031250E+04, .9596988525391E+03},
 {    4606, .8396912109375E+04, -.1285592041016E+04, .9648877563477E+03},
 {    4607, .8402708007812E+04, -.1285592041016E+04, .9622937011719E+03},
 {    4608, .8408500976562E+04, -.1285592041016E+04, .9596988525391E+03},
 {    4609, .8396912109375E+04, -.1270352050781E+04, .9648877563477E+03},
 {    4610, .8402708007812E+04, -.1270352050781E+04, .9622937011719E+03},
 {    4611, .8408500976562E+04, -.1270352050781E+04, .9596988525391E+03},
 {    4612, .8396912109375E+04, -.1255112060547E+04, .9648877563477E+03},
 {    4613, .8402708007812E+04, -.1255112060547E+04, .9622937011719E+03},
 {    4614, .8408500976562E+04, -.1255112060547E+04, .9596988525391E+03},
 {    4615, .8395613281250E+04, -.1316072021484E+04, .9619902343750E+03},
 {    4616, .8401409179688E+04, -.1316072021484E+04, .9593955078125E+03},
 {    4617, .8407206054688E+04, -.1316072021484E+04, .9568010253906E+03},
 {    4618, .8395613281250E+04, -.1300832031250E+04, .9619902343750E+03},
 {    4619, .8401409179688E+04, -.1300832031250E+04, .9593955078125E+03},
 {    4620, .8407206054688E+04, -.1300832031250E+04, .9568010253906E+03},
 {    4621, .8395613281250E+04, -.1285592041016E+04, .9619902343750E+03},
 {    4622, .8401409179688E+04, -.1285592041016E+04, .9593955078125E+03},
 {    4623, .8407206054688E+04, -.1285592041016E+04, .9568010253906E+03},
 {    4624, .8395613281250E+04, -.1270352050781E+04, .9619902343750E+03},
 {    4625, .8401409179688E+04, -.1270352050781E+04, .9593955078125E+03},
 {    4626, .8407206054688E+04, -.1270352050781E+04, .9568010253906E+03},
 {    4627, .8395613281250E+04, -.1255112060547E+04, .9619902343750E+03},
 {    4628, .8401409179688E+04, -.1255112060547E+04, .9593955078125E+03},
 {    4629, .8407206054688E+04, -.1255112060547E+04, .9568010253906E+03},
 {    4630, .8390424804688E+04, -.1316072021484E+04, .9503986206055E+03},
 {    4631, .8396221679688E+04, -.1316072021484E+04, .9478041992188E+03},
 {    4632, .8402015625000E+04, -.1316072021484E+04, .9452095947266E+03},
 {    4633, .8390424804688E+04, -.1300832031250E+04, .9503986206055E+03},
 {    4634, .8396221679688E+04, -.1300832031250E+04, .9478041992188E+03},
 {    4635, .8402015625000E+04, -.1300832031250E+04, .9452095947266E+03},
 {    4636, .8390424804688E+04, -.1285592041016E+04, .9503986206055E+03},
 {    4637, .8396221679688E+04, -.1285592041016E+04, .9478041992188E+03},
 {    4638, .8402015625000E+04, -.1285592041016E+04, .9452095947266E+03},
 {    4639, .8390424804688E+04, -.1270352050781E+04, .9503986206055E+03},
 {    4640, .8396221679688E+04, -.1270352050781E+04, .9478041992188E+03},
 {    4641, .8402015625000E+04, -.1270352050781E+04, .9452095947266E+03},
 {    4642, .8390424804688E+04, -.1255112060547E+04, .9503986206055E+03},
 {    4643, .8396221679688E+04, -.1255112060547E+04, .9478041992188E+03},
 {    4644, .8402015625000E+04, -.1255112060547E+04, .9452095947266E+03},
 {    4645, .8385236328125E+04, -.1316072021484E+04, .9388069458008E+03},
 {    4646, .8391031250000E+04, -.1316072021484E+04, .9362123413086E+03},
 {    4647, .8396826171875E+04, -.1316072021484E+04, .9336179199219E+03},
 {    4648, .8385236328125E+04, -.1300832031250E+04, .9388069458008E+03},
 {    4649, .8391031250000E+04, -.1300832031250E+04, .9362123413086E+03},
 {    4650, .8396826171875E+04, -.1300832031250E+04, .9336179199219E+03},
 {    4651, .8385236328125E+04, -.1285592041016E+04, .9388069458008E+03},
 {    4652, .8391031250000E+04, -.1285592041016E+04, .9362123413086E+03},
 {    4653, .8396826171875E+04, -.1285592041016E+04, .9336179199219E+03},
 {    4654, .8385236328125E+04, -.1270352050781E+04, .9388069458008E+03},
 {    4655, .8391031250000E+04, -.1270352050781E+04, .9362123413086E+03},
 {    4656, .8396826171875E+04, -.1270352050781E+04, .9336179199219E+03},
 {    4657, .8385236328125E+04, -.1255112060547E+04, .9388069458008E+03},
 {    4658, .8391031250000E+04, -.1255112060547E+04, .9362123413086E+03},
 {    4659, .8396826171875E+04, -.1255112060547E+04, .9336179199219E+03},
 {    4660, .8383940429688E+04, -.1316072021484E+04, .9359089965820E+03},
 {    4661, .8389734375000E+04, -.1316072021484E+04, .9333146362305E+03},
 {    4662, .8395529296875E+04, -.1316072021484E+04, .9307202758789E+03},
 {    4663, .8383940429688E+04, -.1300832031250E+04, .9359089965820E+03},
 {    4664, .8389734375000E+04, -.1300832031250E+04, .9333146362305E+03},
 {    4665, .8395529296875E+04, -.1300832031250E+04, .9307202758789E+03},
 {    4666, .8383940429688E+04, -.1285592041016E+04, .9359089965820E+03},
 {    4667, .8389734375000E+04, -.1285592041016E+04, .9333146362305E+03},
 {    4668, .8395529296875E+04, -.1285592041016E+04, .9307202758789E+03},
 {    4669, .8383940429688E+04, -.1270352050781E+04, .9359089965820E+03},
 {    4670, .8389734375000E+04, -.1270352050781E+04, .9333146362305E+03},
 {    4671, .8395529296875E+04, -.1270352050781E+04, .9307202758789E+03},
 {    4672, .8383940429688E+04, -.1255112060547E+04, .9359089965820E+03},
 {    4673, .8389734375000E+04, -.1255112060547E+04, .9333146362305E+03},
 {    4674, .8395529296875E+04, -.1255112060547E+04, .9307202758789E+03},
 {    4675, .8378748046875E+04, -.1316072021484E+04, .9243178710938E+03},
 {    4676, .8384543945312E+04, -.1316072021484E+04, .9217230224609E+03},
 {    4677, .8390341796875E+04, -.1316072021484E+04, .9191286621094E+03},
 {    4678, .8378748046875E+04, -.1300832031250E+04, .9243178710938E+03},
 {    4679, .8384543945312E+04, -.1300832031250E+04, .9217230224609E+03},
 {    4680, .8390341796875E+04, -.1300832031250E+04, .9191286621094E+03},
 {    4681, .8378748046875E+04, -.1285592041016E+04, .9243178710938E+03},
 {    4682, .8384543945312E+04, -.1285592041016E+04, .9217230224609E+03},
 {    4683, .8390341796875E+04, -.1285592041016E+04, .9191286621094E+03},
 {    4684, .8378748046875E+04, -.1270352050781E+04, .9243178710938E+03},
 {    4685, .8384543945312E+04, -.1270352050781E+04, .9217230224609E+03},
 {    4686, .8390341796875E+04, -.1270352050781E+04, .9191286621094E+03},
 {    4687, .8378748046875E+04, -.1255112060547E+04, .9243178710938E+03},
 {    4688, .8384543945312E+04, -.1255112060547E+04, .9217230224609E+03},
 {    4689, .8390341796875E+04, -.1255112060547E+04, .9191286621094E+03},
 {    4690, .8373558593750E+04, -.1316072021484E+04, .9127261962891E+03},
 {    4691, .8379356445312E+04, -.1316072021484E+04, .9101314697266E+03},
 {    4692, .8385152343750E+04, -.1316072021484E+04, .9075369873047E+03},
 {    4693, .8373558593750E+04, -.1300832031250E+04, .9127261962891E+03},
 {    4694, .8379356445312E+04, -.1300832031250E+04, .9101314697266E+03},
 {    4695, .8385152343750E+04, -.1300832031250E+04, .9075369873047E+03},
 {    4696, .8373558593750E+04, -.1285592041016E+04, .9127261962891E+03},
 {    4697, .8379356445312E+04, -.1285592041016E+04, .9101314697266E+03},
 {    4698, .8385152343750E+04, -.1285592041016E+04, .9075369873047E+03},
 {    4699, .8373558593750E+04, -.1270352050781E+04, .9127261962891E+03},
 {    4700, .8379356445312E+04, -.1270352050781E+04, .9101314697266E+03},
 {    4701, .8385152343750E+04, -.1270352050781E+04, .9075369873047E+03},
 {    4702, .8373558593750E+04, -.1255112060547E+04, .9127261962891E+03},
 {    4703, .8379356445312E+04, -.1255112060547E+04, .9101314697266E+03},
 {    4704, .8385152343750E+04, -.1255112060547E+04, .9075369873047E+03},
 {    4705, .8432866210938E+04, -.1346320190430E+04, .1067066284180E+04},
 {    4706, .8436389648438E+04, -.1346337890625E+04, .1065488525391E+04},
 {    4707, .8439912109375E+04, -.1346355468750E+04, .1063911376953E+04},
 {    4708, .8434066406250E+04, -.1331312011719E+04, .1066529052734E+04},
 {    4709, .8437540039062E+04, -.1331312011719E+04, .1064972778320E+04},
 {    4710, .8441018554688E+04, -.1331312011719E+04, .1063415771484E+04},
 {    4711, .8427674804688E+04, -.1346320190430E+04, .1055474365234E+04},
 {    4712, .8431199218750E+04, -.1346337890625E+04, .1053896972656E+04},
 {    4713, .8434723632812E+04, -.1346355468750E+04, .1052319702148E+04},
 {    4714, .8428875976562E+04, -.1331312011719E+04, .1054938110352E+04},
 {    4715, .8432352539062E+04, -.1331312011719E+04, .1053380981445E+04},
 {    4716, .8435829101562E+04, -.1331312011719E+04, .1051824462891E+04},
 {    4717, .8422486328125E+04, -.1346320190430E+04, .1043883300781E+04},
 {    4718, .8426010742188E+04, -.1346337890625E+04, .1042305541992E+04},
 {    4719, .8429534179688E+04, -.1346355468750E+04, .1040727661133E+04},
 {    4720, .8423685546875E+04, -.1331312011719E+04, .1043346679688E+04},
 {    4721, .8427162109375E+04, -.1331312011719E+04, .1041789916992E+04},
 {    4722, .8430640625000E+04, -.1331312011719E+04, .1040232788086E+04},
 {    4723, .8417297851562E+04, -.1346320190430E+04, .1032291748047E+04},
 {    4724, .8420820312500E+04, -.1346337890625E+04, .1030714355469E+04},
 {    4725, .8424345703125E+04, -.1346355468750E+04, .1029136962891E+04},
 {    4726, .8418497070312E+04, -.1331312011719E+04, .1031754394531E+04},
 {    4727, .8421972656250E+04, -.1331312011719E+04, .1030198242188E+04},
 {    4728, .8425451171875E+04, -.1331312011719E+04, .1028641723633E+04},
 {    4729, .8412106445312E+04, -.1346320190430E+04, .1020699951172E+04},
 {    4730, .8415631835938E+04, -.1346337890625E+04, .1019122680664E+04},
 {    4731, .8419157226562E+04, -.1346355468750E+04, .1017545288086E+04},
 {    4732, .8413306640625E+04, -.1331312011719E+04, .1020163574219E+04},
 {    4733, .8416784179688E+04, -.1331312011719E+04, .1018606567383E+04},
 {    4734, .8420261718750E+04, -.1331312011719E+04, .1017049621582E+04},
 {    4735, .8410809570312E+04, -.1346320190430E+04, .1017802490234E+04},
 {    4736, .8414334960938E+04, -.1346337890625E+04, .1016224731445E+04},
 {    4737, .8417860351562E+04, -.1346355468750E+04, .1014647338867E+04},
 {    4738, .8412009765625E+04, -.1331312011719E+04, .1017265747070E+04},
 {    4739, .8415489257812E+04, -.1331312011719E+04, .1015708374023E+04},
 {    4740, .8418965820312E+04, -.1331312011719E+04, .1014152038574E+04},
 {    4741, .8405622070312E+04, -.1346320190430E+04, .1006210815430E+04},
 {    4742, .8409144531250E+04, -.1346337890625E+04, .1004633666992E+04},
 {    4743, .8412669921875E+04, -.1346355468750E+04, .1003055786133E+04},
 {    4744, .8406821289062E+04, -.1331312011719E+04, .1005673706055E+04},
 {    4745, .8410297851562E+04, -.1331312011719E+04, .1004116821289E+04},
 {    4746, .8413776367188E+04, -.1331312011719E+04, .1002560485840E+04},
 {    4747, .8400432617188E+04, -.1346320190430E+04, .9946193237305E+03},
 {    4748, .8403958007812E+04, -.1346337890625E+04, .9930415039062E+03},
 {    4749, .8407480468750E+04, -.1346355468750E+04, .9914648437500E+03},
 {    4750, .8401631835938E+04, -.1331312011719E+04, .9940820312500E+03},
 {    4751, .8405110351562E+04, -.1331312011719E+04, .9925257568359E+03},
 {    4752, .8408587890625E+04, -.1331312011719E+04, .9909688720703E+03},
 {    4753, .8399136718750E+04, -.1346320190430E+04, .9917211303711E+03},
 {    4754, .8402660156250E+04, -.1346337890625E+04, .9901436767578E+03},
 {    4755, .8406183593750E+04, -.1346355468750E+04, .9885661010742E+03},
 {    4756, .8400334960938E+04, -.1331312011719E+04, .9911846923828E+03},
 {    4757, .8403811523438E+04, -.1331312011719E+04, .9896278076172E+03},
 {    4758, .8407289062500E+04, -.1331312011719E+04, .9880708007812E+03},
 {    4759, .8393945312500E+04, -.1346320190430E+04, .9801302490234E+03},
 {    4760, .8397470703125E+04, -.1346337890625E+04, .9785526123047E+03},
 {    4761, .8400995117188E+04, -.1346355468750E+04, .9769745483398E+03},
 {    4762, .8395144531250E+04, -.1331312011719E+04, .9795933837891E+03},
 {    4763, .8398622070312E+04, -.1331312011719E+04, .9780361328125E+03},
 {    4764, .8402100585938E+04, -.1331312011719E+04, .9764794921875E+03},
 {    4765, .8388756835938E+04, -.1346320190430E+04, .9685386962891E+03},
 {    4766, .8392280273438E+04, -.1346337890625E+04, .9669611206055E+03},
 {    4767, .8395807617188E+04, -.1346355468750E+04, .9653829345703E+03},
 {    4768, .8389957031250E+04, -.1331312011719E+04, .9680015869141E+03},
 {    4769, .8393433593750E+04, -.1331312011719E+04, .9664445190430E+03},
 {    4770, .8396912109375E+04, -.1331312011719E+04, .9648877563477E+03},
 {    4771, .8387458984375E+04, -.1346320190430E+04, .9656406250000E+03},
 {    4772, .8390984375000E+04, -.1346337890625E+04, .9640627441406E+03},
 {    4773, .8394507812500E+04, -.1346355468750E+04, .9624852905273E+03},
 {    4774, .8388660156250E+04, -.1331312011719E+04, .9651035156250E+03},
 {    4775, .8392136718750E+04, -.1331312011719E+04, .9635468139648E+03},
 {    4776, .8395613281250E+04, -.1331312011719E+04, .9619902343750E+03},
 {    4777, .8382271484375E+04, -.1346320190430E+04, .9540488891602E+03},
 {    4778, .8385794921875E+04, -.1346337890625E+04, .9524712524414E+03},
 {    4779, .8389321289062E+04, -.1346355468750E+04, .9508933105469E+03},
 {    4780, .8383468750000E+04, -.1331312011719E+04, .9535125122070E+03},
 {    4781, .8386948242188E+04, -.1331312011719E+04, .9519552612305E+03},
 {    4782, .8390424804688E+04, -.1331312011719E+04, .9503986206055E+03},
 {    4783, .8377081054688E+04, -.1346320190430E+04, .9424575195312E+03},
 {    4784, .8380605468750E+04, -.1346337890625E+04, .9408801269531E+03},
 {    4785, .8384129882812E+04, -.1346355468750E+04, .9393023681641E+03},
 {    4786, .8378281250000E+04, -.1331312011719E+04, .9419204711914E+03},
 {    4787, .8381758789062E+04, -.1331312011719E+04, .9403638305664E+03},
 {    4788, .8385236328125E+04, -.1331312011719E+04, .9388069458008E+03},
 {    4789, .8375783203125E+04, -.1346320190430E+04, .9395596923828E+03},
 {    4790, .8379309570312E+04, -.1346337890625E+04, .9379819335938E+03},
 {    4791, .8382831054688E+04, -.1346355468750E+04, .9364044189453E+03},
 {    4792, .8376984375000E+04, -.1331312011719E+04, .9390224609375E+03},
 {    4793, .8380461914062E+04, -.1331312011719E+04, .9374660034180E+03},
 {    4794, .8383940429688E+04, -.1331312011719E+04, .9359089965820E+03},
 {    4795, .8370595703125E+04, -.1346320190430E+04, .9279678344727E+03},
 {    4796, .8374120117188E+04, -.1346337890625E+04, .9263905029297E+03},
 {    4797, .8377643554688E+04, -.1346355590820E+04, .9248126831055E+03},
 {    4798, .8371793945312E+04, -.1331312011719E+04, .9274310302734E+03},
 {    4799, .8375271484375E+04, -.1331312011719E+04, .9258743896484E+03},
 {    4800, .8378748046875E+04, -.1331312011719E+04, .9243178710938E+03},
 {    4801, .8365405273438E+04, -.1346320190430E+04, .9163764648438E+03},
 {    4802, .8368930664062E+04, -.1346337890625E+04, .9147989501953E+03},
 {    4803, .8372456054688E+04, -.1346355590820E+04, .9132211914062E+03},
 {    4804, .8366604492188E+04, -.1331312011719E+04, .9158396606445E+03},
 {    4805, .8370084960938E+04, -.1331312011719E+04, .9142827148438E+03},
 {    4806, .8373558593750E+04, -.1331312011719E+04, .9127261962891E+03},
 {    4807, .8358142578125E+04, -.1346320190430E+04, .9001481933594E+03},
 {    4808, .8361666992188E+04, -.1346337890625E+04, .8985707397461E+03},
 {    4809, .8365190429688E+04, -.1346355590820E+04, .8969929199219E+03},
 {    4810, .8359339843750E+04, -.1331312011719E+04, .8996115722656E+03},
 {    4811, .8362818359375E+04, -.1331312011719E+04, .8980548706055E+03},
 {    4812, .8366295898438E+04, -.1331312011719E+04, .8964980468750E+03},
 {    4813, .8434066406250E+04, -.1326232055664E+04, .1066529052734E+04},
 {    4814, .8437540039062E+04, -.1326232055664E+04, .1064972778320E+04},
 {    4815, .8441018554688E+04, -.1326232055664E+04, .1063415771484E+04},
 {    4816, .8434066406250E+04, -.1321152099609E+04, .1066529052734E+04},
 {    4817, .8437540039062E+04, -.1321152099609E+04, .1064972778320E+04},
 {    4818, .8441018554688E+04, -.1321152099609E+04, .1063415771484E+04},
 {    4819, .8437540039062E+04, -.1316072021484E+04, .1064972778320E+04},
 {    4820, .8428875976562E+04, -.1326232055664E+04, .1054938110352E+04},
 {    4821, .8432352539062E+04, -.1326232055664E+04, .1053380981445E+04},
 {    4822, .8435829101562E+04, -.1326232055664E+04, .1051824462891E+04},
 {    4823, .8428875976562E+04, -.1321152099609E+04, .1054938110352E+04},
 {    4824, .8432352539062E+04, -.1321152099609E+04, .1053380981445E+04},
 {    4825, .8435829101562E+04, -.1321152099609E+04, .1051824462891E+04},
 {    4826, .8432352539062E+04, -.1316072021484E+04, .1053380981445E+04},
 {    4827, .8423685546875E+04, -.1326232055664E+04, .1043346679688E+04},
 {    4828, .8427162109375E+04, -.1326232055664E+04, .1041789916992E+04},
 {    4829, .8430640625000E+04, -.1326232055664E+04, .1040232788086E+04},
 {    4830, .8423685546875E+04, -.1321152099609E+04, .1043346679688E+04},
 {    4831, .8427162109375E+04, -.1321152099609E+04, .1041789916992E+04},
 {    4832, .8430640625000E+04, -.1321152099609E+04, .1040232788086E+04},
 {    4833, .8427162109375E+04, -.1316072021484E+04, .1041789916992E+04},
 {    4834, .8418497070312E+04, -.1326232055664E+04, .1031754394531E+04},
 {    4835, .8421972656250E+04, -.1326232055664E+04, .1030198242188E+04},
 {    4836, .8425451171875E+04, -.1326232055664E+04, .1028641723633E+04},
 {    4837, .8418497070312E+04, -.1321152099609E+04, .1031754394531E+04},
 {    4838, .8421972656250E+04, -.1321152099609E+04, .1030198242188E+04},
 {    4839, .8425451171875E+04, -.1321152099609E+04, .1028641723633E+04},
 {    4840, .8421972656250E+04, -.1316072021484E+04, .1030198242188E+04},
 {    4841, .8413306640625E+04, -.1326232055664E+04, .1020163574219E+04},
 {    4842, .8416784179688E+04, -.1326232055664E+04, .1018606567383E+04},
 {    4843, .8420261718750E+04, -.1326232055664E+04, .1017049621582E+04},
 {    4844, .8413306640625E+04, -.1321152099609E+04, .1020163574219E+04},
 {    4845, .8416784179688E+04, -.1321152099609E+04, .1018606567383E+04},
 {    4846, .8420261718750E+04, -.1321152099609E+04, .1017049621582E+04},
 {    4847, .8416784179688E+04, -.1316072021484E+04, .1018606567383E+04},
 {    4848, .8412009765625E+04, -.1326232055664E+04, .1017265747070E+04},
 {    4849, .8415489257812E+04, -.1326232055664E+04, .1015708374023E+04},
 {    4850, .8418965820312E+04, -.1326232055664E+04, .1014152038574E+04},
 {    4851, .8412009765625E+04, -.1321152099609E+04, .1017265747070E+04},
 {    4852, .8415489257812E+04, -.1321152099609E+04, .1015708374023E+04},
 {    4853, .8418965820312E+04, -.1321152099609E+04, .1014152038574E+04},
 {    4854, .8415489257812E+04, -.1316072021484E+04, .1015708374023E+04},
 {    4855, .8406821289062E+04, -.1326232055664E+04, .1005673706055E+04},
 {    4856, .8410297851562E+04, -.1326232055664E+04, .1004116821289E+04},
 {    4857, .8413776367188E+04, -.1326232055664E+04, .1002560485840E+04},
 {    4858, .8406821289062E+04, -.1321152099609E+04, .1005673706055E+04},
 {    4859, .8410297851562E+04, -.1321152099609E+04, .1004116821289E+04},
 {    4860, .8413776367188E+04, -.1321152099609E+04, .1002560485840E+04},
 {    4861, .8410297851562E+04, -.1316072021484E+04, .1004116821289E+04},
 {    4862, .8401631835938E+04, -.1326232055664E+04, .9940820312500E+03},
 {    4863, .8405110351562E+04, -.1326232055664E+04, .9925257568359E+03},
 {    4864, .8408587890625E+04, -.1326232055664E+04, .9909688720703E+03},
 {    4865, .8401631835938E+04, -.1321152099609E+04, .9940820312500E+03},
 {    4866, .8405110351562E+04, -.1321152099609E+04, .9925257568359E+03},
 {    4867, .8408587890625E+04, -.1321152099609E+04, .9909688720703E+03},
 {    4868, .8405110351562E+04, -.1316072021484E+04, .9925257568359E+03},
 {    4869, .8400334960938E+04, -.1326232055664E+04, .9911846923828E+03},
 {    4870, .8403811523438E+04, -.1326232055664E+04, .9896278076172E+03},
 {    4871, .8407289062500E+04, -.1326232055664E+04, .9880708007812E+03},
 {    4872, .8400334960938E+04, -.1321152099609E+04, .9911846923828E+03},
 {    4873, .8403811523438E+04, -.1321152099609E+04, .9896278076172E+03},
 {    4874, .8407289062500E+04, -.1321152099609E+04, .9880708007812E+03},
 {    4875, .8403811523438E+04, -.1316072021484E+04, .9896278076172E+03},
 {    4876, .8395144531250E+04, -.1326232055664E+04, .9795933837891E+03},
 {    4877, .8398622070312E+04, -.1326232055664E+04, .9780361328125E+03},
 {    4878, .8402100585938E+04, -.1326232055664E+04, .9764794921875E+03},
 {    4879, .8395144531250E+04, -.1321152099609E+04, .9795933837891E+03},
 {    4880, .8398622070312E+04, -.1321152099609E+04, .9780361328125E+03},
 {    4881, .8402100585938E+04, -.1321152099609E+04, .9764794921875E+03},
 {    4882, .8398622070312E+04, -.1316072021484E+04, .9780361328125E+03},
 {    4883, .8389957031250E+04, -.1326232055664E+04, .9680015869141E+03},
 {    4884, .8393433593750E+04, -.1326232055664E+04, .9664445190430E+03},
 {    4885, .8396912109375E+04, -.1326232055664E+04, .9648877563477E+03},
 {    4886, .8389957031250E+04, -.1321152099609E+04, .9680015869141E+03},
 {    4887, .8393433593750E+04, -.1321152099609E+04, .9664445190430E+03},
 {    4888, .8396912109375E+04, -.1321152099609E+04, .9648877563477E+03},
 {    4889, .8393433593750E+04, -.1316072021484E+04, .9664445190430E+03},
 {    4890, .8388660156250E+04, -.1326232055664E+04, .9651035156250E+03},
 {    4891, .8392136718750E+04, -.1326232055664E+04, .9635468139648E+03},
 {    4892, .8395613281250E+04, -.1326232055664E+04, .9619902343750E+03},
 {    4893, .8388660156250E+04, -.1321152099609E+04, .9651035156250E+03},
 {    4894, .8392136718750E+04, -.1321152099609E+04, .9635468139648E+03},
 {    4895, .8395613281250E+04, -.1321152099609E+04, .9619902343750E+03},
 {    4896, .8392136718750E+04, -.1316072021484E+04, .9635468139648E+03},
 {    4897, .8383468750000E+04, -.1326232055664E+04, .9535125122070E+03},
 {    4898, .8386948242188E+04, -.1326232055664E+04, .9519552612305E+03},
 {    4899, .8390424804688E+04, -.1326232055664E+04, .9503986206055E+03},
 {    4900, .8383468750000E+04, -.1321152099609E+04, .9535125122070E+03},
 {    4901, .8386948242188E+04, -.1321152099609E+04, .9519552612305E+03},
 {    4902, .8390424804688E+04, -.1321152099609E+04, .9503986206055E+03},
 {    4903, .8386948242188E+04, -.1316072021484E+04, .9519552612305E+03},
 {    4904, .8378281250000E+04, -.1326232055664E+04, .9419204711914E+03},
 {    4905, .8381758789062E+04, -.1326232055664E+04, .9403638305664E+03},
 {    4906, .8385236328125E+04, -.1326232055664E+04, .9388069458008E+03},
 {    4907, .8378281250000E+04, -.1321152099609E+04, .9419205932617E+03},
 {    4908, .8381758789062E+04, -.1321152099609E+04, .9403638305664E+03},
 {    4909, .8385236328125E+04, -.1321152099609E+04, .9388069458008E+03},
 {    4910, .8381758789062E+04, -.1316072021484E+04, .9403638305664E+03},
 {    4911, .8376984375000E+04, -.1326232055664E+04, .9390224609375E+03},
 {    4912, .8380461914062E+04, -.1326232055664E+04, .9374660034180E+03},
 {    4913, .8383940429688E+04, -.1326232055664E+04, .9359089965820E+03},
 {    4914, .8376984375000E+04, -.1321152099609E+04, .9390224609375E+03},
 {    4915, .8380461914062E+04, -.1321152099609E+04, .9374660034180E+03},
 {    4916, .8383940429688E+04, -.1321152099609E+04, .9359089965820E+03},
 {    4917, .8380461914062E+04, -.1316072021484E+04, .9374660034180E+03},
 {    4918, .8371793945312E+04, -.1326232055664E+04, .9274310302734E+03},
 {    4919, .8375271484375E+04, -.1326232055664E+04, .9258743896484E+03},
 {    4920, .8378748046875E+04, -.1326232055664E+04, .9243178710938E+03},
 {    4921, .8371793945312E+04, -.1321152099609E+04, .9274310302734E+03},
 {    4922, .8375271484375E+04, -.1321152099609E+04, .9258743896484E+03},
 {    4923, .8378748046875E+04, -.1321152099609E+04, .9243178710938E+03},
 {    4924, .8375271484375E+04, -.1316072021484E+04, .9258743896484E+03},
 {    4925, .8366604492188E+04, -.1326232055664E+04, .9158396606445E+03},
 {    4926, .8370084960938E+04, -.1326232055664E+04, .9142827148438E+03},
 {    4927, .8373558593750E+04, -.1326232055664E+04, .9127261962891E+03},
 {    4928, .8366604492188E+04, -.1321152099609E+04, .9158396606445E+03},
 {    4929, .8370084960938E+04, -.1321152099609E+04, .9142827148438E+03},
 {    4930, .8373558593750E+04, -.1321152099609E+04, .9127261962891E+03},
 {    4931, .8370084960938E+04, -.1316072021484E+04, .9142827148438E+03},
 {    4932, .8437540039062E+04, -.1300832031250E+04, .1064972778320E+04},
 {    4933, .8437540039062E+04, -.1285592041016E+04, .1064972778320E+04},
 {    4934, .8437540039062E+04, -.1270352050781E+04, .1064972778320E+04},
 {    4935, .8437540039062E+04, -.1255112060547E+04, .1064972778320E+04},
 {    4936, .8432352539062E+04, -.1300832031250E+04, .1053380981445E+04},
 {    4937, .8432352539062E+04, -.1285592041016E+04, .1053380981445E+04},
 {    4938, .8432352539062E+04, -.1270352050781E+04, .1053380981445E+04},
 {    4939, .8432352539062E+04, -.1255112060547E+04, .1053380981445E+04},
 {    4940, .8427162109375E+04, -.1300832031250E+04, .1041789916992E+04},
 {    4941, .8427162109375E+04, -.1285592041016E+04, .1041789916992E+04},
 {    4942, .8427162109375E+04, -.1270352050781E+04, .1041789916992E+04},
 {    4943, .8427162109375E+04, -.1255112060547E+04, .1041789916992E+04},
 {    4944, .8421972656250E+04, -.1300832031250E+04, .1030198242188E+04},
 {    4945, .8421972656250E+04, -.1285592041016E+04, .1030198242188E+04},
 {    4946, .8421972656250E+04, -.1270352050781E+04, .1030198242188E+04},
 {    4947, .8421972656250E+04, -.1255112060547E+04, .1030198242188E+04},
 {    4948, .8416784179688E+04, -.1300832031250E+04, .1018606567383E+04},
 {    4949, .8416784179688E+04, -.1285592041016E+04, .1018606567383E+04},
 {    4950, .8416784179688E+04, -.1270352050781E+04, .1018606567383E+04},
 {    4951, .8416784179688E+04, -.1255112060547E+04, .1018606567383E+04},
 {    4952, .8415489257812E+04, -.1300832031250E+04, .1015708374023E+04},
 {    4953, .8415489257812E+04, -.1285592041016E+04, .1015708374023E+04},
 {    4954, .8415489257812E+04, -.1270352050781E+04, .1015708374023E+04},
 {    4955, .8415489257812E+04, -.1255112060547E+04, .1015708374023E+04},
 {    4956, .8410297851562E+04, -.1300832031250E+04, .1004116821289E+04},
 {    4957, .8410297851562E+04, -.1285592041016E+04, .1004116821289E+04},
 {    4958, .8410297851562E+04, -.1270352050781E+04, .1004116821289E+04},
 {    4959, .8410297851562E+04, -.1255112060547E+04, .1004116821289E+04},
 {    4960, .8405110351562E+04, -.1300832031250E+04, .9925257568359E+03},
 {    4961, .8405110351562E+04, -.1285592041016E+04, .9925257568359E+03},
 {    4962, .8405110351562E+04, -.1270352050781E+04, .9925257568359E+03},
 {    4963, .8405110351562E+04, -.1255112060547E+04, .9925257568359E+03},
 {    4964, .8403811523438E+04, -.1300832031250E+04, .9896278076172E+03},
 {    4965, .8403811523438E+04, -.1285592041016E+04, .9896278076172E+03},
 {    4966, .8403811523438E+04, -.1270352050781E+04, .9896278076172E+03},
 {    4967, .8403811523438E+04, -.1255112060547E+04, .9896278076172E+03},
 {    4968, .8398622070312E+04, -.1300832031250E+04, .9780361328125E+03},
 {    4969, .8398622070312E+04, -.1285592041016E+04, .9780361328125E+03},
 {    4970, .8398622070312E+04, -.1270352050781E+04, .9780361328125E+03},
 {    4971, .8398622070312E+04, -.1255112060547E+04, .9780361328125E+03},
 {    4972, .8393433593750E+04, -.1300832031250E+04, .9664445190430E+03},
 {    4973, .8393433593750E+04, -.1285592041016E+04, .9664445190430E+03},
 {    4974, .8393433593750E+04, -.1270352050781E+04, .9664445190430E+03},
 {    4975, .8393433593750E+04, -.1255112060547E+04, .9664445190430E+03},
 {    4976, .8392136718750E+04, -.1300832031250E+04, .9635468139648E+03},
 {    4977, .8392136718750E+04, -.1285592041016E+04, .9635468139648E+03},
 {    4978, .8392136718750E+04, -.1270352050781E+04, .9635468139648E+03},
 {    4979, .8392136718750E+04, -.1255112060547E+04, .9635468139648E+03},
 {    4980, .8386948242188E+04, -.1300832031250E+04, .9519552612305E+03},
 {    4981, .8386948242188E+04, -.1285592041016E+04, .9519552612305E+03},
 {    4982, .8386948242188E+04, -.1270352050781E+04, .9519552612305E+03},
 {    4983, .8386948242188E+04, -.1255112060547E+04, .9519552612305E+03},
 {    4984, .8381758789062E+04, -.1300832031250E+04, .9403638305664E+03},
 {    4985, .8381758789062E+04, -.1285592041016E+04, .9403638305664E+03},
 {    4986, .8381758789062E+04, -.1270352050781E+04, .9403638305664E+03},
 {    4987, .8381758789062E+04, -.1255112060547E+04, .9403638305664E+03},
 {    4988, .8380461914062E+04, -.1300832031250E+04, .9374660034180E+03},
 {    4989, .8380461914062E+04, -.1285592041016E+04, .9374660034180E+03},
 {    4990, .8380461914062E+04, -.1270352050781E+04, .9374660034180E+03},
 {    4991, .8380461914062E+04, -.1255112060547E+04, .9374660034180E+03},
 {    4992, .8375271484375E+04, -.1300832031250E+04, .9258743896484E+03},
 {    4993, .8375271484375E+04, -.1285592041016E+04, .9258743896484E+03},
 {    4994, .8375271484375E+04, -.1270352050781E+04, .9258743896484E+03},
 {    4995, .8375271484375E+04, -.1255112060547E+04, .9258743896484E+03},
 {    4996, .8370084960938E+04, -.1300832031250E+04, .9142827148438E+03},
 {    4997, .8370084960938E+04, -.1285592041016E+04, .9142827148438E+03},
 {    4998, .8370084960938E+04, -.1270352050781E+04, .9142827148438E+03},
 {    4999, .8370084960938E+04, -.1255112060547E+04, .9142827148438E+03},
 {    5000, .8434066406250E+04, -.1250031982422E+04, .1066529052734E+04},
 {    5001, .8437540039062E+04, -.1250031982422E+04, .1064972778320E+04},
 {    5002, .8441018554688E+04, -.1250031982422E+04, .1063415771484E+04},
 {    5003, .8434066406250E+04, -.1244952026367E+04, .1066529052734E+04},
 {    5004, .8437540039062E+04, -.1244952026367E+04, .1064972778320E+04},
 {    5005, .8441018554688E+04, -.1244952026367E+04, .1063415771484E+04},
 {    5006, .8434066406250E+04, -.1239872070312E+04, .1066529052734E+04},
 {    5007, .8437540039062E+04, -.1239872070312E+04, .1064972778320E+04},
 {    5008, .8441018554688E+04, -.1239872070312E+04, .1063415771484E+04},
 {    5009, .8428875976562E+04, -.1250031982422E+04, .1054938110352E+04},
 {    5010, .8432352539062E+04, -.1250031982422E+04, .1053380981445E+04},
 {    5011, .8435829101562E+04, -.1250031982422E+04, .1051824462891E+04},
 {    5012, .8428875976562E+04, -.1244952026367E+04, .1054938110352E+04},
 {    5013, .8432352539062E+04, -.1244952026367E+04, .1053380981445E+04},
 {    5014, .8435829101562E+04, -.1244952026367E+04, .1051824462891E+04},
 {    5015, .8428875976562E+04, -.1239872070312E+04, .1054938110352E+04},
 {    5016, .8432352539062E+04, -.1239872070312E+04, .1053380981445E+04},
 {    5017, .8435829101562E+04, -.1239872070312E+04, .1051824462891E+04},
 {    5018, .8423685546875E+04, -.1250031982422E+04, .1043346679688E+04},
 {    5019, .8427162109375E+04, -.1250031982422E+04, .1041789916992E+04},
 {    5020, .8430640625000E+04, -.1250031982422E+04, .1040232788086E+04},
 {    5021, .8423685546875E+04, -.1244952026367E+04, .1043346679688E+04},
 {    5022, .8427162109375E+04, -.1244952026367E+04, .1041789916992E+04},
 {    5023, .8430640625000E+04, -.1244952026367E+04, .1040232788086E+04},
 {    5024, .8423685546875E+04, -.1239872070312E+04, .1043346679688E+04},
 {    5025, .8427162109375E+04, -.1239872070312E+04, .1041789916992E+04},
 {    5026, .8430640625000E+04, -.1239872070312E+04, .1040232788086E+04},
 {    5027, .8418497070312E+04, -.1250031982422E+04, .1031754394531E+04},
 {    5028, .8421972656250E+04, -.1250031982422E+04, .1030198242188E+04},
 {    5029, .8425451171875E+04, -.1250031982422E+04, .1028641723633E+04},
 {    5030, .8418497070312E+04, -.1244952026367E+04, .1031754394531E+04},
 {    5031, .8421972656250E+04, -.1244952026367E+04, .1030198242188E+04},
 {    5032, .8425451171875E+04, -.1244952026367E+04, .1028641723633E+04},
 {    5033, .8418497070312E+04, -.1239872070312E+04, .1031754394531E+04},
 {    5034, .8421972656250E+04, -.1239872070312E+04, .1030198242188E+04},
 {    5035, .8425451171875E+04, -.1239872070312E+04, .1028641723633E+04},
 {    5036, .8413306640625E+04, -.1250031982422E+04, .1020163574219E+04},
 {    5037, .8416784179688E+04, -.1250031982422E+04, .1018606567383E+04},
 {    5038, .8420261718750E+04, -.1250031982422E+04, .1017049621582E+04},
 {    5039, .8413306640625E+04, -.1244952026367E+04, .1020163574219E+04},
 {    5040, .8416784179688E+04, -.1244952026367E+04, .1018606567383E+04},
 {    5041, .8420261718750E+04, -.1244952026367E+04, .1017049621582E+04},
 {    5042, .8413306640625E+04, -.1239872070312E+04, .1020163574219E+04},
 {    5043, .8416784179688E+04, -.1239872070312E+04, .1018606567383E+04},
 {    5044, .8420261718750E+04, -.1239872070312E+04, .1017049621582E+04},
 {    5045, .8412009765625E+04, -.1250031982422E+04, .1017265747070E+04},
 {    5046, .8415489257812E+04, -.1250031982422E+04, .1015708374023E+04},
 {    5047, .8418965820312E+04, -.1250031982422E+04, .1014152038574E+04},
 {    5048, .8412009765625E+04, -.1244952026367E+04, .1017265747070E+04},
 {    5049, .8415489257812E+04, -.1244952026367E+04, .1015708374023E+04},
 {    5050, .8418965820312E+04, -.1244952026367E+04, .1014152038574E+04},
 {    5051, .8412009765625E+04, -.1239872070312E+04, .1017265747070E+04},
 {    5052, .8415489257812E+04, -.1239872070312E+04, .1015708374023E+04},
 {    5053, .8418965820312E+04, -.1239872070312E+04, .1014152038574E+04},
 {    5054, .8406821289062E+04, -.1250031982422E+04, .1005673706055E+04},
 {    5055, .8410297851562E+04, -.1250031982422E+04, .1004116821289E+04},
 {    5056, .8413776367188E+04, -.1250031982422E+04, .1002560485840E+04},
 {    5057, .8406821289062E+04, -.1244952026367E+04, .1005673706055E+04},
 {    5058, .8410297851562E+04, -.1244952026367E+04, .1004116821289E+04},
 {    5059, .8413776367188E+04, -.1244952026367E+04, .1002560485840E+04},
 {    5060, .8406821289062E+04, -.1239872070312E+04, .1005673706055E+04},
 {    5061, .8410297851562E+04, -.1239872070312E+04, .1004116821289E+04},
 {    5062, .8413776367188E+04, -.1239872070312E+04, .1002560485840E+04},
 {    5063, .8401631835938E+04, -.1250031982422E+04, .9940820312500E+03},
 {    5064, .8405110351562E+04, -.1250031982422E+04, .9925257568359E+03},
 {    5065, .8408587890625E+04, -.1250031982422E+04, .9909688720703E+03},
 {    5066, .8401631835938E+04, -.1244952026367E+04, .9940820312500E+03},
 {    5067, .8405110351562E+04, -.1244952026367E+04, .9925257568359E+03},
 {    5068, .8408587890625E+04, -.1244952026367E+04, .9909688720703E+03},
 {    5069, .8401631835938E+04, -.1239872070312E+04, .9940820312500E+03},
 {    5070, .8405110351562E+04, -.1239872070312E+04, .9925257568359E+03},
 {    5071, .8408587890625E+04, -.1239872070312E+04, .9909688720703E+03},
 {    5072, .8400334960938E+04, -.1250031982422E+04, .9911846923828E+03},
 {    5073, .8403811523438E+04, -.1250031982422E+04, .9896278076172E+03},
 {    5074, .8407289062500E+04, -.1250031982422E+04, .9880708007812E+03},
 {    5075, .8400334960938E+04, -.1244952026367E+04, .9911846923828E+03},
 {    5076, .8403811523438E+04, -.1244952026367E+04, .9896278076172E+03},
 {    5077, .8407289062500E+04, -.1244952026367E+04, .9880708007812E+03},
 {    5078, .8400334960938E+04, -.1239872070312E+04, .9911846923828E+03},
 {    5079, .8403811523438E+04, -.1239872070312E+04, .9896278076172E+03},
 {    5080, .8407289062500E+04, -.1239872070312E+04, .9880708007812E+03},
 {    5081, .8395144531250E+04, -.1250031982422E+04, .9795933837891E+03},
 {    5082, .8398622070312E+04, -.1250031982422E+04, .9780361328125E+03},
 {    5083, .8402100585938E+04, -.1250031982422E+04, .9764794921875E+03},
 {    5084, .8395144531250E+04, -.1244952026367E+04, .9795933837891E+03},
 {    5085, .8398622070312E+04, -.1244952026367E+04, .9780361328125E+03},
 {    5086, .8402100585938E+04, -.1244952026367E+04, .9764794921875E+03},
 {    5087, .8395144531250E+04, -.1239872070312E+04, .9795933837891E+03},
 {    5088, .8398622070312E+04, -.1239872070312E+04, .9780361328125E+03},
 {    5089, .8402100585938E+04, -.1239872070312E+04, .9764794921875E+03},
 {    5090, .8389957031250E+04, -.1250031982422E+04, .9680015869141E+03},
 {    5091, .8393433593750E+04, -.1250031982422E+04, .9664445190430E+03},
 {    5092, .8396912109375E+04, -.1250031982422E+04, .9648877563477E+03},
 {    5093, .8389957031250E+04, -.1244952026367E+04, .9680015869141E+03},
 {    5094, .8393433593750E+04, -.1244952026367E+04, .9664445190430E+03},
 {    5095, .8396912109375E+04, -.1244952026367E+04, .9648877563477E+03},
 {    5096, .8389957031250E+04, -.1239872070312E+04, .9680015869141E+03},
 {    5097, .8393433593750E+04, -.1239872070312E+04, .9664445190430E+03},
 {    5098, .8396912109375E+04, -.1239872070312E+04, .9648877563477E+03},
 {    5099, .8388660156250E+04, -.1250031982422E+04, .9651035156250E+03},
 {    5100, .8392136718750E+04, -.1250031982422E+04, .9635468139648E+03},
 {    5101, .8395613281250E+04, -.1250031982422E+04, .9619902343750E+03},
 {    5102, .8388660156250E+04, -.1244952026367E+04, .9651035156250E+03},
 {    5103, .8392136718750E+04, -.1244952026367E+04, .9635468139648E+03},
 {    5104, .8395613281250E+04, -.1244952026367E+04, .9619902343750E+03},
 {    5105, .8388660156250E+04, -.1239872070312E+04, .9651035156250E+03},
 {    5106, .8392136718750E+04, -.1239872070312E+04, .9635468139648E+03},
 {    5107, .8395613281250E+04, -.1239872070312E+04, .9619902343750E+03},
 {    5108, .8383468750000E+04, -.1250031982422E+04, .9535125122070E+03},
 {    5109, .8386948242188E+04, -.1250031982422E+04, .9519552612305E+03},
 {    5110, .8390424804688E+04, -.1250031982422E+04, .9503986206055E+03},
 {    5111, .8383468750000E+04, -.1244952026367E+04, .9535125122070E+03},
 {    5112, .8386948242188E+04, -.1244952026367E+04, .9519552612305E+03},
 {    5113, .8390424804688E+04, -.1244952026367E+04, .9503986206055E+03},
 {    5114, .8383468750000E+04, -.1239872070312E+04, .9535125122070E+03},
 {    5115, .8386948242188E+04, -.1239872070312E+04, .9519552612305E+03},
 {    5116, .8390424804688E+04, -.1239872070312E+04, .9503986206055E+03},
 {    5117, .8378281250000E+04, -.1250031982422E+04, .9419205932617E+03},
 {    5118, .8381758789062E+04, -.1250031982422E+04, .9403638305664E+03},
 {    5119, .8385236328125E+04, -.1250031982422E+04, .9388069458008E+03},
 {    5120, .8378281250000E+04, -.1244952026367E+04, .9419204711914E+03},
 {    5121, .8381758789062E+04, -.1244952026367E+04, .9403638305664E+03},
 {    5122, .8385236328125E+04, -.1244952026367E+04, .9388069458008E+03},
 {    5123, .8378281250000E+04, -.1239872070312E+04, .9419204711914E+03},
 {    5124, .8381758789062E+04, -.1239872070312E+04, .9403638305664E+03},
 {    5125, .8385236328125E+04, -.1239872070312E+04, .9388069458008E+03},
 {    5126, .8376984375000E+04, -.1250031982422E+04, .9390224609375E+03},
 {    5127, .8380461914062E+04, -.1250031982422E+04, .9374660034180E+03},
 {    5128, .8383940429688E+04, -.1250031982422E+04, .9359089965820E+03},
 {    5129, .8376984375000E+04, -.1244952026367E+04, .9390224609375E+03},
 {    5130, .8380461914062E+04, -.1244952026367E+04, .9374660034180E+03},
 {    5131, .8383940429688E+04, -.1244952026367E+04, .9359089965820E+03},
 {    5132, .8376984375000E+04, -.1239872070312E+04, .9390224609375E+03},
 {    5133, .8380461914062E+04, -.1239872070312E+04, .9374660034180E+03},
 {    5134, .8383940429688E+04, -.1239872070312E+04, .9359089965820E+03},
 {    5135, .8371793945312E+04, -.1250031982422E+04, .9274310302734E+03},
 {    5136, .8375271484375E+04, -.1250031982422E+04, .9258743896484E+03},
 {    5137, .8378748046875E+04, -.1250031982422E+04, .9243178710938E+03},
 {    5138, .8371793945312E+04, -.1244952026367E+04, .9274310302734E+03},
 {    5139, .8375271484375E+04, -.1244952026367E+04, .9258743896484E+03},
 {    5140, .8378748046875E+04, -.1244952026367E+04, .9243178710938E+03},
 {    5141, .8371793945312E+04, -.1239872070312E+04, .9274310302734E+03},
 {    5142, .8375271484375E+04, -.1239872070312E+04, .9258743896484E+03},
 {    5143, .8378748046875E+04, -.1239872070312E+04, .9243178710938E+03},
 {    5144, .8366604492188E+04, -.1250031982422E+04, .9158396606445E+03},
 {    5145, .8370084960938E+04, -.1250031982422E+04, .9142827148438E+03},
 {    5146, .8373558593750E+04, -.1250031982422E+04, .9127261962891E+03},
 {    5147, .8366604492188E+04, -.1244952026367E+04, .9158396606445E+03},
 {    5148, .8370084960938E+04, -.1244952026367E+04, .9142827148438E+03},
 {    5149, .8373558593750E+04, -.1244952026367E+04, .9127261962891E+03},
 {    5150, .8366604492188E+04, -.1239872070312E+04, .9158396606445E+03},
 {    5151, .8370084960938E+04, -.1239872070312E+04, .9142827148438E+03},
 {    5152, .8373558593750E+04, -.1239872070312E+04, .9127261962891E+03},
 {    5153, .8432866210938E+04, -.1224863891602E+04, .1067066284180E+04},
 {    5154, .8436389648438E+04, -.1224846191406E+04, .1065488525391E+04},
 {    5155, .8439912109375E+04, -.1224828613281E+04, .1063911132812E+04},
 {    5156, .8427674804688E+04, -.1224863891602E+04, .1055474365234E+04},
 {    5157, .8431199218750E+04, -.1224846191406E+04, .1053896972656E+04},
 {    5158, .8434723632812E+04, -.1224828613281E+04, .1052319702148E+04},
 {    5159, .8422486328125E+04, -.1224863891602E+04, .1043883300781E+04},
 {    5160, .8426010742188E+04, -.1224846191406E+04, .1042305541992E+04},
 {    5161, .8429534179688E+04, -.1224828613281E+04, .1040727661133E+04},
 {    5162, .8417297851562E+04, -.1224863891602E+04, .1032291748047E+04},
 {    5163, .8420820312500E+04, -.1224846191406E+04, .1030714355469E+04},
 {    5164, .8424345703125E+04, -.1224828613281E+04, .1029136962891E+04},
 {    5165, .8412106445312E+04, -.1224863891602E+04, .1020699951172E+04},
 {    5166, .8415631835938E+04, -.1224846191406E+04, .1019122680664E+04},
 {    5167, .8419157226562E+04, -.1224828613281E+04, .1017545288086E+04},
 {    5168, .8410809570312E+04, -.1224863891602E+04, .1017802490234E+04},
 {    5169, .8414334960938E+04, -.1224846191406E+04, .1016224731445E+04},
 {    5170, .8417860351562E+04, -.1224828613281E+04, .1014647338867E+04},
 {    5171, .8405622070312E+04, -.1224863891602E+04, .1006210815430E+04},
 {    5172, .8409144531250E+04, -.1224846191406E+04, .1004633422852E+04},
 {    5173, .8412669921875E+04, -.1224828613281E+04, .1003055786133E+04},
 {    5174, .8400432617188E+04, -.1224863891602E+04, .9946193237305E+03},
 {    5175, .8403958007812E+04, -.1224846191406E+04, .9930415039062E+03},
 {    5176, .8407480468750E+04, -.1224828613281E+04, .9914648437500E+03},
 {    5177, .8399136718750E+04, -.1224863891602E+04, .9917211303711E+03},
 {    5178, .8402660156250E+04, -.1224846191406E+04, .9901436767578E+03},
 {    5179, .8406183593750E+04, -.1224828613281E+04, .9885661010742E+03},
 {    5180, .8393945312500E+04, -.1224863891602E+04, .9801302490234E+03},
 {    5181, .8397470703125E+04, -.1224846191406E+04, .9785526123047E+03},
 {    5182, .8400995117188E+04, -.1224828613281E+04, .9769745483398E+03},
 {    5183, .8388756835938E+04, -.1224863891602E+04, .9685386962891E+03},
 {    5184, .8392280273438E+04, -.1224846191406E+04, .9669611206055E+03},
 {    5185, .8395807617188E+04, -.1224828613281E+04, .9653829345703E+03},
 {    5186, .8387458984375E+04, -.1224863891602E+04, .9656406250000E+03},
 {    5187, .8390984375000E+04, -.1224846191406E+04, .9640627441406E+03},
 {    5188, .8394507812500E+04, -.1224828613281E+04, .9624852905273E+03},
 {    5189, .8382271484375E+04, -.1224863891602E+04, .9540488891602E+03},
 {    5190, .8385794921875E+04, -.1224846191406E+04, .9524712524414E+03},
 {    5191, .8389321289062E+04, -.1224828613281E+04, .9508933105469E+03},
 {    5192, .8377081054688E+04, -.1224863891602E+04, .9424575195312E+03},
 {    5193, .8380605468750E+04, -.1224846191406E+04, .9408801269531E+03},
 {    5194, .8384129882812E+04, -.1224828613281E+04, .9393023681641E+03},
 {    5195, .8375783203125E+04, -.1224863891602E+04, .9395596923828E+03},
 {    5196, .8379309570312E+04, -.1224846191406E+04, .9379819335938E+03},
 {    5197, .8382831054688E+04, -.1224828613281E+04, .9364044189453E+03},
 {    5198, .8370595703125E+04, -.1224863891602E+04, .9279678344727E+03},
 {    5199, .8374120117188E+04, -.1224846313477E+04, .9263905029297E+03},
 {    5200, .8377643554688E+04, -.1224828613281E+04, .9248126831055E+03},
 {    5201, .8365405273438E+04, -.1224863891602E+04, .9163764648438E+03},
 {    5202, .8368930664062E+04, -.1224846313477E+04, .9147989501953E+03},
 {    5203, .8372456054688E+04, -.1224828613281E+04, .9132211914062E+03},
 {    5204, .8359339843750E+04, -.1239872070312E+04, .8996115722656E+03},
 {    5205, .8362818359375E+04, -.1239872070312E+04, .8980548706055E+03},
 {    5206, .8366295898438E+04, -.1239872070312E+04, .8964980468750E+03},
 {    5207, .8358142578125E+04, -.1224863891602E+04, .9001481933594E+03},
 {    5208, .8361666992188E+04, -.1224846313477E+04, .8985707397461E+03},
 {    5209, .8365190429688E+04, -.1224828613281E+04, .8969929199219E+03},
 {    5210, .8417889648438E+04, -.1239872070312E+04, .1045940917969E+04},
 {    5211, .8416601562500E+04, -.1224901245117E+04, .1046518066406E+04},
 {    5212, .8412700195312E+04, -.1239872070312E+04, .1034349243164E+04},
 {    5213, .8411412109375E+04, -.1224901245117E+04, .1034926757812E+04},
 {    5214, .8407511718750E+04, -.1239872070312E+04, .1022758117676E+04},
 {    5215, .8406222656250E+04, -.1224901245117E+04, .1023335388184E+04},
 {    5216, .8406216796875E+04, -.1239872070312E+04, .1019859497070E+04},
 {    5217, .8404924804688E+04, -.1224901245117E+04, .1020437500000E+04},
 {    5218, .8401024414062E+04, -.1239872070312E+04, .1008268310547E+04},
 {    5219, .8399735351562E+04, -.1224901245117E+04, .1008845825195E+04},
 {    5220, .8395836914062E+04, -.1239872070312E+04, .9966770019531E+03},
 {    5221, .8394545898438E+04, -.1224901245117E+04, .9972546386719E+03},
 {    5222, .8394540039062E+04, -.1239872070312E+04, .9937788085938E+03},
 {    5223, .8393249023438E+04, -.1224901245117E+04, .9943563232422E+03},
 {    5224, .8389348632812E+04, -.1239872070312E+04, .9821878051758E+03},
 {    5225, .8388059570312E+04, -.1224901245117E+04, .9827647094727E+03},
 {    5226, .8384160156250E+04, -.1239872070312E+04, .9705960693359E+03},
 {    5227, .8382872070312E+04, -.1224901245117E+04, .9711729736328E+03},
 {    5228, .8382863281250E+04, -.1239872070312E+04, .9676982421875E+03},
 {    5229, .8381574218750E+04, -.1224901245117E+04, .9682755126953E+03},
 {    5230, .8377673828125E+04, -.1239872070312E+04, .9561064453125E+03},
 {    5231, .8376383789062E+04, -.1224901245117E+04, .9566840820312E+03},
 {    5232, .8372485351562E+04, -.1239872070312E+04, .9445149536133E+03},
 {    5233, .8371196289062E+04, -.1224901245117E+04, .9450922241211E+03},
 {    5234, .8371188476562E+04, -.1239872070312E+04, .9416169433594E+03},
 {    5235, .8369897460938E+04, -.1224901245117E+04, .9421945190430E+03},
 {    5236, .8365998046875E+04, -.1239872070312E+04, .9300255126953E+03},
 {    5237, .8364712890625E+04, -.1224901245117E+04, .9306029052734E+03},
 {    5238, .8360809570312E+04, -.1239872070312E+04, .9184338378906E+03},
 {    5239, .8359521484375E+04, -.1224901245117E+04, .9190114135742E+03},
 {    5240, .8417889648438E+04, -.1331312011719E+04, .1045940917969E+04},
 {    5241, .8416601562500E+04, -.1346282836914E+04, .1046518066406E+04},
 {    5242, .8412700195312E+04, -.1331312011719E+04, .1034349487305E+04},
 {    5243, .8411412109375E+04, -.1346282836914E+04, .1034926757812E+04},
 {    5244, .8407511718750E+04, -.1331312011719E+04, .1022758117676E+04},
 {    5245, .8406222656250E+04, -.1346282836914E+04, .1023335388184E+04},
 {    5246, .8406216796875E+04, -.1331312011719E+04, .1019859497070E+04},
 {    5247, .8404924804688E+04, -.1346282836914E+04, .1020437744141E+04},
 {    5248, .8401024414062E+04, -.1331312011719E+04, .1008268310547E+04},
 {    5249, .8399735351562E+04, -.1346282836914E+04, .1008845825195E+04},
 {    5250, .8395836914062E+04, -.1331312011719E+04, .9966770019531E+03},
 {    5251, .8394545898438E+04, -.1346282836914E+04, .9972546386719E+03},
 {    5252, .8394540039062E+04, -.1331312011719E+04, .9937788085938E+03},
 {    5253, .8393249023438E+04, -.1346282836914E+04, .9943565673828E+03},
 {    5254, .8389348632812E+04, -.1331312011719E+04, .9821878051758E+03},
 {    5255, .8388059570312E+04, -.1346282836914E+04, .9827649536133E+03},
 {    5256, .8384160156250E+04, -.1331312011719E+04, .9705960693359E+03},
 {    5257, .8382872070312E+04, -.1346282836914E+04, .9711729736328E+03},
 {    5258, .8382863281250E+04, -.1331312011719E+04, .9676982421875E+03},
 {    5259, .8381574218750E+04, -.1346282836914E+04, .9682755126953E+03},
 {    5260, .8377673828125E+04, -.1331312011719E+04, .9561064453125E+03},
 {    5261, .8376383789062E+04, -.1346282836914E+04, .9566840820312E+03},
 {    5262, .8372485351562E+04, -.1331312011719E+04, .9445149536133E+03},
 {    5263, .8371196289062E+04, -.1346282836914E+04, .9450922241211E+03},
 {    5264, .8371188476562E+04, -.1331312011719E+04, .9416169433594E+03},
 {    5265, .8369897460938E+04, -.1346282836914E+04, .9421945190430E+03},
 {    5266, .8365998046875E+04, -.1331312011719E+04, .9300255126953E+03},
 {    5267, .8364712890625E+04, -.1346282958984E+04, .9306029052734E+03},
 {    5268, .8360809570312E+04, -.1331312011719E+04, .9184338378906E+03},
 {    5269, .8359521484375E+04, -.1346282958984E+04, .9190114135742E+03},
 {    5270, .8358530273438E+04, -.1159862060547E+04, .1078079589844E+04},
 {    5271, .8352735351562E+04, -.1159862060547E+04, .1080674316406E+04},
 {    5272, .8346940429688E+04, -.1159862060547E+04, .1083268554688E+04},
 {    5273, .8341141601562E+04, -.1159862060547E+04, .1085863403320E+04},
 {    5274, .8335346679688E+04, -.1159862060547E+04, .1088457763672E+04},
 {    5275, .8329552734375E+04, -.1159862060547E+04, .1091052490234E+04},
 {    5276, .8323755859375E+04, -.1159862060547E+04, .1093646728516E+04},
 {    5277, .8317958984375E+04, -.1159862060547E+04, .1096241699219E+04},
 {    5278, .8312165039062E+04, -.1159862060547E+04, .1098835937500E+04},
 {    5279, .8358530273438E+04, -.1153512084961E+04, .1078079589844E+04},
 {    5280, .8352735351562E+04, -.1153512084961E+04, .1080674316406E+04},
 {    5281, .8346940429688E+04, -.1153512084961E+04, .1083268554688E+04},
 {    5282, .8341141601562E+04, -.1153512084961E+04, .1085863403320E+04},
 {    5283, .8335346679688E+04, -.1153512084961E+04, .1088457763672E+04},
 {    5284, .8329552734375E+04, -.1153512084961E+04, .1091052490234E+04},
 {    5285, .8323755859375E+04, -.1153512084961E+04, .1093646728516E+04},
 {    5286, .8317958984375E+04, -.1153512084961E+04, .1096241699219E+04},
 {    5287, .8312165039062E+04, -.1153512084961E+04, .1098835937500E+04},
 {    5288, .8356454101562E+04, -.1159862060547E+04, .1073442993164E+04},
 {    5289, .8350658203125E+04, -.1159862060547E+04, .1076037597656E+04},
 {    5290, .8344863281250E+04, -.1159862060547E+04, .1078632080078E+04},
 {    5291, .8339066406250E+04, -.1159862060547E+04, .1081226562500E+04},
 {    5292, .8333272460938E+04, -.1159862060547E+04, .1083821044922E+04},
 {    5293, .8327475585938E+04, -.1159862060547E+04, .1086415771484E+04},
 {    5294, .8321680664062E+04, -.1159862060547E+04, .1089010131836E+04},
 {    5295, .8315884765625E+04, -.1159862060547E+04, .1091604980469E+04},
 {    5296, .8310089843750E+04, -.1159862060547E+04, .1094199707031E+04},
 {    5297, .8350658203125E+04, -.1153512084961E+04, .1076037597656E+04},
 {    5298, .8339066406250E+04, -.1153512084961E+04, .1081226562500E+04},
 {    5299, .8327475585938E+04, -.1153512084961E+04, .1086415771484E+04},
 {    5300, .8315884765625E+04, -.1153512084961E+04, .1091604980469E+04},
 {    5301, .8351264648438E+04, -.1159862060547E+04, .1061851684570E+04},
 {    5302, .8345468750000E+04, -.1159862060547E+04, .1064446044922E+04},
 {    5303, .8339673828125E+04, -.1159862060547E+04, .1067040649414E+04},
 {    5304, .8333877929688E+04, -.1159862060547E+04, .1069635131836E+04},
 {    5305, .8328083007812E+04, -.1159862060547E+04, .1072229858398E+04},
 {    5306, .8322289062500E+04, -.1159862060547E+04, .1074823974609E+04},
 {    5307, .8316491210938E+04, -.1159862060547E+04, .1077418945312E+04},
 {    5308, .8310696289062E+04, -.1159862060547E+04, .1080013427734E+04},
 {    5309, .8304899414062E+04, -.1159862060547E+04, .1082608154297E+04},
 {    5310, .8345468750000E+04, -.1153512084961E+04, .1064446044922E+04},
 {    5311, .8333877929688E+04, -.1153512084961E+04, .1069635131836E+04},
 {    5312, .8322289062500E+04, -.1153512084961E+04, .1074823974609E+04},
 {    5313, .8310696289062E+04, -.1153512084961E+04, .1080013427734E+04},
 {    5314, .8346075195312E+04, -.1159862060547E+04, .1050260009766E+04},
 {    5315, .8340279296875E+04, -.1159862060547E+04, .1052854492188E+04},
 {    5316, .8334484375000E+04, -.1159862060547E+04, .1055449218750E+04},
 {    5317, .8328690429688E+04, -.1159862060547E+04, .1058043334961E+04},
 {    5318, .8322892578125E+04, -.1159862060547E+04, .1060638183594E+04},
 {    5319, .8317096679688E+04, -.1159862060547E+04, .1063233032227E+04},
 {    5320, .8311302734375E+04, -.1159862060547E+04, .1065827270508E+04},
 {    5321, .8305505859375E+04, -.1159862060547E+04, .1068421630859E+04},
 {    5322, .8299710937500E+04, -.1159862060547E+04, .1071016357422E+04},
 {    5323, .8340279296875E+04, -.1153512084961E+04, .1052854492188E+04},
 {    5324, .8328690429688E+04, -.1153512084961E+04, .1058043334961E+04},
 {    5325, .8317096679688E+04, -.1153512084961E+04, .1063233032227E+04},
 {    5326, .8305505859375E+04, -.1153512084961E+04, .1068421630859E+04},
 {    5327, .8344782226562E+04, -.1159862060547E+04, .1047361816406E+04},
 {    5328, .8338984375000E+04, -.1159862060547E+04, .1049956420898E+04},
 {    5329, .8333187500000E+04, -.1159862060547E+04, .1052551025391E+04},
 {    5330, .8327390625000E+04, -.1159862060547E+04, .1055145629883E+04},
 {    5331, .8321595703125E+04, -.1159862060547E+04, .1057740356445E+04},
 {    5332, .8315798828125E+04, -.1159862060547E+04, .1060335449219E+04},
 {    5333, .8310006835938E+04, -.1159862060547E+04, .1062929321289E+04},
 {    5334, .8304208007812E+04, -.1159862060547E+04, .1065523925781E+04},
 {    5335, .8298413085938E+04, -.1159862060547E+04, .1068118286133E+04},
 {    5336, .8338984375000E+04, -.1153512084961E+04, .1049956420898E+04},
 {    5337, .8327390625000E+04, -.1153512084961E+04, .1055145629883E+04},
 {    5338, .8315798828125E+04, -.1153512084961E+04, .1060335449219E+04},
 {    5339, .8304208007812E+04, -.1153512084961E+04, .1065523925781E+04},
 {    5340, .8339590820312E+04, -.1159862060547E+04, .1035770751953E+04},
 {    5341, .8333795898438E+04, -.1159862060547E+04, .1038365356445E+04},
 {    5342, .8327998046875E+04, -.1159862060547E+04, .1040959594727E+04},
 {    5343, .8322202148438E+04, -.1159862060547E+04, .1043554321289E+04},
 {    5344, .8316409179688E+04, -.1159862060547E+04, .1046148437500E+04},
 {    5345, .8310611328125E+04, -.1159862060547E+04, .1048743408203E+04},
 {    5346, .8304816406250E+04, -.1159862060547E+04, .1051337646484E+04},
 {    5347, .8299019531250E+04, -.1159862060547E+04, .1053931884766E+04},
 {    5348, .8293222656250E+04, -.1159862060547E+04, .1056526855469E+04},
 {    5349, .8333795898438E+04, -.1153512084961E+04, .1038365356445E+04},
 {    5350, .8322202148438E+04, -.1153512084961E+04, .1043554321289E+04},
 {    5351, .8310611328125E+04, -.1153512084961E+04, .1048743408203E+04},
 {    5352, .8299019531250E+04, -.1153512084961E+04, .1053931884766E+04},
 {    5353, .8334400390625E+04, -.1159862060547E+04, .1024179321289E+04},
 {    5354, .8328605468750E+04, -.1159862060547E+04, .1026773681641E+04},
 {    5355, .8322810546875E+04, -.1159862060547E+04, .1029367919922E+04},
 {    5356, .8317013671875E+04, -.1159862060547E+04, .1031962402344E+04},
 {    5357, .8311216796875E+04, -.1159862060547E+04, .1034557128906E+04},
 {    5358, .8305422851562E+04, -.1159862060547E+04, .1037151611328E+04},
 {    5359, .8299626953125E+04, -.1159862060547E+04, .1039746093750E+04},
 {    5360, .8293831054688E+04, -.1159862060547E+04, .1042341308594E+04},
 {    5361, .8288036132812E+04, -.1159862060547E+04, .1044935058594E+04},
 {    5362, .8328605468750E+04, -.1153512084961E+04, .1026773681641E+04},
 {    5363, .8317013671875E+04, -.1153512084961E+04, .1031962402344E+04},
 {    5364, .8305422851562E+04, -.1153512084961E+04, .1037151611328E+04},
 {    5365, .8293831054688E+04, -.1153512084961E+04, .1042341308594E+04},
 {    5366, .8333103515625E+04, -.1159862060547E+04, .1021281066895E+04},
 {    5367, .8327308593750E+04, -.1159862060547E+04, .1023875549316E+04},
 {    5368, .8321513671875E+04, -.1159862060547E+04, .1026470092773E+04},
 {    5369, .8315716796875E+04, -.1159862060547E+04, .1029065063477E+04},
 {    5370, .8309919921875E+04, -.1159862060547E+04, .1031659179688E+04},
 {    5371, .8304125000000E+04, -.1159862060547E+04, .1034253662109E+04},
 {    5372, .8298330078125E+04, -.1159862060547E+04, .1036848388672E+04},
 {    5373, .8292533203125E+04, -.1159862060547E+04, .1039442871094E+04},
 {    5374, .8286740234375E+04, -.1159862060547E+04, .1042037475586E+04},
 {    5375, .8327308593750E+04, -.1153512084961E+04, .1023875549316E+04},
 {    5376, .8315716796875E+04, -.1153512084961E+04, .1029065063477E+04},
 {    5377, .8304125000000E+04, -.1153512084961E+04, .1034253662109E+04},
 {    5378, .8292533203125E+04, -.1153512084961E+04, .1039442871094E+04},
 {    5379, .8327915039062E+04, -.1159862060547E+04, .1009689575195E+04},
 {    5380, .8322119140625E+04, -.1159862060547E+04, .1012283935547E+04},
 {    5381, .8316325195312E+04, -.1159862060547E+04, .1014878845215E+04},
 {    5382, .8310527343750E+04, -.1159862060547E+04, .1017473144531E+04},
 {    5383, .8304731445312E+04, -.1159862060547E+04, .1020067871094E+04},
 {    5384, .8298936523438E+04, -.1159862060547E+04, .1022662475586E+04},
 {    5385, .8293141601562E+04, -.1159862060547E+04, .1025256958008E+04},
 {    5386, .8287344726562E+04, -.1159862060547E+04, .1027851440430E+04},
 {    5387, .8281547851562E+04, -.1159862060547E+04, .1030446166992E+04},
 {    5388, .8322119140625E+04, -.1153512084961E+04, .1012283935547E+04},
 {    5389, .8310527343750E+04, -.1153512084961E+04, .1017473144531E+04},
 {    5390, .8298936523438E+04, -.1153512084961E+04, .1022662231445E+04},
 {    5391, .8287344726562E+04, -.1153512084961E+04, .1027851440430E+04},
 {    5392, .8322724609375E+04, -.1159862060547E+04, .9980984497070E+03},
 {    5393, .8316929687500E+04, -.1159862060547E+04, .1000692810059E+04},
 {    5394, .8311132812500E+04, -.1159862060547E+04, .1003287475586E+04},
 {    5395, .8305338867188E+04, -.1159862060547E+04, .1005881713867E+04},
 {    5396, .8299541992188E+04, -.1159862060547E+04, .1008476074219E+04},
 {    5397, .8293746093750E+04, -.1159862060547E+04, .1011070922852E+04},
 {    5398, .8287951171875E+04, -.1159862060547E+04, .1013665771484E+04},
 {    5399, .8282156250000E+04, -.1159862060547E+04, .1016260009766E+04},
 {    5400, .8276358398438E+04, -.1159862060547E+04, .1018854675293E+04},
 {    5401, .8316929687500E+04, -.1153512084961E+04, .1000692810059E+04},
 {    5402, .8305338867188E+04, -.1153512084961E+04, .1005881713867E+04},
 {    5403, .8293746093750E+04, -.1153512084961E+04, .1011070922852E+04},
 {    5404, .8282156250000E+04, -.1153512084961E+04, .1016260009766E+04},
 {    5405, .8321427734375E+04, -.1159862060547E+04, .9951999511719E+03},
 {    5406, .8315631835938E+04, -.1159862060547E+04, .9977947998047E+03},
 {    5407, .8309836914062E+04, -.1159862060547E+04, .1000389099121E+04},
 {    5408, .8304040039062E+04, -.1159862060547E+04, .1002984252930E+04},
 {    5409, .8298244140625E+04, -.1159862060547E+04, .1005578613281E+04},
 {    5410, .8292449218750E+04, -.1159862060547E+04, .1008172973633E+04},
 {    5411, .8286653320312E+04, -.1159862060547E+04, .1010767395020E+04},
 {    5412, .8280858398438E+04, -.1159862060547E+04, .1013362121582E+04},
 {    5413, .8275063476562E+04, -.1159862060547E+04, .1015956665039E+04},
 {    5414, .8315631835938E+04, -.1153512084961E+04, .9977947998047E+03},
 {    5415, .8304040039062E+04, -.1153512084961E+04, .1002984252930E+04},
 {    5416, .8292449218750E+04, -.1153512084961E+04, .1008172973633E+04},
 {    5417, .8280858398438E+04, -.1153512084961E+04, .1013362121582E+04},
 {    5418, .8316240234375E+04, -.1159862060547E+04, .9836082763672E+03},
 {    5419, .8310444335938E+04, -.1159862060547E+04, .9862033691406E+03},
 {    5420, .8304648437500E+04, -.1159862060547E+04, .9887977294922E+03},
 {    5421, .8298852539062E+04, -.1159862060547E+04, .9913925781250E+03},
 {    5422, .8293055664062E+04, -.1159862060547E+04, .9939868164062E+03},
 {    5423, .8287260742188E+04, -.1159862060547E+04, .9965816650391E+03},
 {    5424, .8281464843750E+04, -.1159862060547E+04, .9991757812500E+03},
 {    5425, .8275667968750E+04, -.1159862060547E+04, .1001770507812E+04},
 {    5426, .8269874023438E+04, -.1159862060547E+04, .1004364807129E+04},
 {    5427, .8310444335938E+04, -.1153512084961E+04, .9862033691406E+03},
 {    5428, .8298852539062E+04, -.1153512084961E+04, .9913925781250E+03},
 {    5429, .8287260742188E+04, -.1153512084961E+04, .9965816650391E+03},
 {    5430, .8275667968750E+04, -.1153512084961E+04, .1001770507812E+04},
 {    5431, .8311048828125E+04, -.1159862060547E+04, .9720169677734E+03},
 {    5432, .8305254882812E+04, -.1159862060547E+04, .9746119384766E+03},
 {    5433, .8299458007812E+04, -.1159862060547E+04, .9772065429688E+03},
 {    5434, .8293663085938E+04, -.1159862060547E+04, .9798010253906E+03},
 {    5435, .8287866210938E+04, -.1159862060547E+04, .9823952636719E+03},
 {    5436, .8282072265625E+04, -.1159862060547E+04, .9849899291992E+03},
 {    5437, .8276275390625E+04, -.1159862060547E+04, .9875843505859E+03},
 {    5438, .8270480468750E+04, -.1159862060547E+04, .9901790161133E+03},
 {    5439, .8264683593750E+04, -.1159862060547E+04, .9927739257812E+03},
 {    5440, .8305254882812E+04, -.1153512084961E+04, .9746119384766E+03},
 {    5441, .8293663085938E+04, -.1153512084961E+04, .9798010253906E+03},
 {    5442, .8282072265625E+04, -.1153512084961E+04, .9849899291992E+03},
 {    5443, .8270480468750E+04, -.1153512084961E+04, .9901790161133E+03},
 {    5444, .8309751953125E+04, -.1159862060547E+04, .9691195068359E+03},
 {    5445, .8303958007812E+04, -.1159862060547E+04, .9717136230469E+03},
 {    5446, .8298160156250E+04, -.1159862060547E+04, .9743084106445E+03},
 {    5447, .8292365234375E+04, -.1159862060547E+04, .9769032592773E+03},
 {    5448, .8286571289062E+04, -.1159862060547E+04, .9794973144531E+03},
 {    5449, .8280773437500E+04, -.1159862060547E+04, .9820920410156E+03},
 {    5450, .8274979492188E+04, -.1159862060547E+04, .9846864624023E+03},
 {    5451, .8269183593750E+04, -.1159862060547E+04, .9872810058594E+03},
 {    5452, .8263387695312E+04, -.1159862060547E+04, .9898752441406E+03},
 {    5453, .8303958007812E+04, -.1153512084961E+04, .9717136230469E+03},
 {    5454, .8292365234375E+04, -.1153512084961E+04, .9769032592773E+03},
 {    5455, .8280773437500E+04, -.1153512084961E+04, .9820920410156E+03},
 {    5456, .8269183593750E+04, -.1153512084961E+04, .9872810058594E+03},
 {    5457, .8304563476562E+04, -.1159862060547E+04, .9575277099609E+03},
 {    5458, .8298767578125E+04, -.1159862060547E+04, .9601221313477E+03},
 {    5459, .8292974609375E+04, -.1159862060547E+04, .9627166748047E+03},
 {    5460, .8287175781250E+04, -.1159862060547E+04, .9653112792969E+03},
 {    5461, .8281380859375E+04, -.1159862060547E+04, .9679062500000E+03},
 {    5462, .8275585937500E+04, -.1159862060547E+04, .9705003662109E+03},
 {    5463, .8269791015625E+04, -.1159862060547E+04, .9730949707031E+03},
 {    5464, .8263994140625E+04, -.1159862060547E+04, .9756896362305E+03},
 {    5465, .8258200195312E+04, -.1159862060547E+04, .9782839355469E+03},
 {    5466, .8298767578125E+04, -.1153512084961E+04, .9601221313477E+03},
 {    5467, .8287175781250E+04, -.1153512084961E+04, .9653112792969E+03},
 {    5468, .8275585937500E+04, -.1153512084961E+04, .9705003662109E+03},
 {    5469, .8263994140625E+04, -.1153512084961E+04, .9756896362305E+03},
 {    5470, .8299374023438E+04, -.1159862060547E+04, .9459361572266E+03},
 {    5471, .8293578125000E+04, -.1159862060547E+04, .9485307617188E+03},
 {    5472, .8287781250000E+04, -.1159862060547E+04, .9511254882812E+03},
 {    5473, .8281987304688E+04, -.1159862060547E+04, .9537197875977E+03},
 {    5474, .8276192382812E+04, -.1159862060547E+04, .9563143310547E+03},
 {    5475, .8270395507812E+04, -.1159862060547E+04, .9589091796875E+03},
 {    5476, .8264600585938E+04, -.1159862060547E+04, .9615036621094E+03},
 {    5477, .8258804687500E+04, -.1159862060547E+04, .9640978393555E+03},
 {    5478, .8253008789062E+04, -.1159862060547E+04, .9666925048828E+03},
 {    5479, .8293578125000E+04, -.1153512084961E+04, .9485307617188E+03},
 {    5480, .8281987304688E+04, -.1153512084961E+04, .9537197875977E+03},
 {    5481, .8270395507812E+04, -.1153512084961E+04, .9589091796875E+03},
 {    5482, .8258804687500E+04, -.1153512084961E+04, .9640978393555E+03},
 {    5483, .8297298828125E+04, -.1159862060547E+04, .9412995605469E+03},
 {    5484, .8291503906250E+04, -.1159862060547E+04, .9438941040039E+03},
 {    5485, .8285707031250E+04, -.1159862060547E+04, .9464887084961E+03},
 {    5486, .8279911132812E+04, -.1159862060547E+04, .9490833740234E+03},
 {    5487, .8274116210938E+04, -.1159862060547E+04, .9516777343750E+03},
 {    5488, .8268319335938E+04, -.1159862060547E+04, .9542723388672E+03},
 {    5489, .8262524414062E+04, -.1159862060547E+04, .9568668823242E+03},
 {    5490, .8256730468750E+04, -.1159862060547E+04, .9594612426758E+03},
 {    5491, .8250930664062E+04, -.1159862060547E+04, .9620561523438E+03},
 {    5492, .8297298828125E+04, -.1153512084961E+04, .9412995605469E+03},
 {    5493, .8291503906250E+04, -.1153512084961E+04, .9438941040039E+03},
 {    5494, .8285707031250E+04, -.1153512084961E+04, .9464887084961E+03},
 {    5495, .8279911132812E+04, -.1153512084961E+04, .9490833740234E+03},
 {    5496, .8274116210938E+04, -.1153512084961E+04, .9516777343750E+03},
 {    5497, .8268319335938E+04, -.1153512084961E+04, .9542723388672E+03},
 {    5498, .8262524414062E+04, -.1153512084961E+04, .9568668823242E+03},
 {    5499, .8256730468750E+04, -.1153512084961E+04, .9594612426758E+03},
 {    5500, .8250930664062E+04, -.1153512084961E+04, .9620561523438E+03},
 {    5501, .8346075195312E+04, -.1171291992188E+04, .1050260009766E+04},
 {    5502, .8334484375000E+04, -.1171291992188E+04, .1055449218750E+04},
 {    5503, .8322892578125E+04, -.1171291992188E+04, .1060638183594E+04},
 {    5504, .8344782226562E+04, -.1171291992188E+04, .1047361816406E+04},
 {    5505, .8333187500000E+04, -.1171291992188E+04, .1052551025391E+04},
 {    5506, .8321595703125E+04, -.1171291992188E+04, .1057740356445E+04},
 {    5507, .8339590820312E+04, -.1171291992188E+04, .1035770751953E+04},
 {    5508, .8327998046875E+04, -.1171291992188E+04, .1040959594727E+04},
 {    5509, .8316409179688E+04, -.1171291992188E+04, .1046148437500E+04},
 {    5510, .8334400390625E+04, -.1171291992188E+04, .1024179321289E+04},
 {    5511, .8322810546875E+04, -.1171291992188E+04, .1029367919922E+04},
 {    5512, .8311216796875E+04, -.1171291992188E+04, .1034557128906E+04},
 {    5513, .8333103515625E+04, -.1171291992188E+04, .1021281066895E+04},
 {    5514, .8321513671875E+04, -.1171291992188E+04, .1026470092773E+04},
 {    5515, .8309919921875E+04, -.1171291992188E+04, .1031659179688E+04},
 {    5516, .8327915039062E+04, -.1171291992188E+04, .1009689575195E+04},
 {    5517, .8316325195312E+04, -.1171291992188E+04, .1014878845215E+04},
 {    5518, .8304731445312E+04, -.1171291992188E+04, .1020067871094E+04},
 {    5519, .8322724609375E+04, -.1171291992188E+04, .9980984497070E+03},
 {    5520, .8311132812500E+04, -.1171291992188E+04, .1003287475586E+04},
 {    5521, .8299541992188E+04, -.1171291992188E+04, .1008476074219E+04},
 {    5522, .8321427734375E+04, -.1171291992188E+04, .9951999511719E+03},
 {    5523, .8309836914062E+04, -.1171291992188E+04, .1000389099121E+04},
 {    5524, .8298244140625E+04, -.1171291992188E+04, .1005578613281E+04},
 {    5525, .8316240234375E+04, -.1171291992188E+04, .9836082763672E+03},
 {    5526, .8304648437500E+04, -.1171291992188E+04, .9887977294922E+03},
 {    5527, .8293055664062E+04, -.1171291992188E+04, .9939868164062E+03},
 {    5528, .8311048828125E+04, -.1171291992188E+04, .9720169677734E+03},
 {    5529, .8299458007812E+04, -.1171291992188E+04, .9772065429688E+03},
 {    5530, .8287866210938E+04, -.1171291992188E+04, .9823952636719E+03},
 {    5531, .8309751953125E+04, -.1171291992188E+04, .9691195068359E+03},
 {    5532, .8298160156250E+04, -.1171291992188E+04, .9743084106445E+03},
 {    5533, .8286571289062E+04, -.1171291992188E+04, .9794973144531E+03},
 {    5534, .8311302734375E+04, -.1171291992188E+04, .1065827270508E+04},
 {    5535, .8299710937500E+04, -.1171291992188E+04, .1071016357422E+04},
 {    5536, .8310006835938E+04, -.1171291992188E+04, .1062929321289E+04},
 {    5537, .8298413085938E+04, -.1171291992188E+04, .1068118286133E+04},
 {    5538, .8304816406250E+04, -.1171291992188E+04, .1051337646484E+04},
 {    5539, .8293222656250E+04, -.1171291992188E+04, .1056526855469E+04},
 {    5540, .8299626953125E+04, -.1171291992188E+04, .1039746093750E+04},
 {    5541, .8288036132812E+04, -.1171291992188E+04, .1044935058594E+04},
 {    5542, .8286653320312E+04, -.1171291992188E+04, .1010767395020E+04},
 {    5543, .8275063476562E+04, -.1171291992188E+04, .1015956665039E+04},
 {    5544, .8281464843750E+04, -.1171291992188E+04, .9991757812500E+03},
 {    5545, .8269874023438E+04, -.1171291992188E+04, .1004364807129E+04},
 {    5546, .8276275390625E+04, -.1171291992188E+04, .9875843505859E+03},
 {    5547, .8264683593750E+04, -.1171291992188E+04, .9927739257812E+03},
 {    5548, .8274979492188E+04, -.1171291992188E+04, .9846864624023E+03},
 {    5549, .8263387695312E+04, -.1171291992188E+04, .9898752441406E+03},
 {    5550, .8358530273438E+04, -.1411322021484E+04, .1078079589844E+04},
 {    5551, .8352735351562E+04, -.1411322021484E+04, .1080674316406E+04},
 {    5552, .8346940429688E+04, -.1411322021484E+04, .1083268798828E+04},
 {    5553, .8341141601562E+04, -.1411322021484E+04, .1085863403320E+04},
 {    5554, .8335346679688E+04, -.1411322021484E+04, .1088457763672E+04},
 {    5555, .8329552734375E+04, -.1411322021484E+04, .1091052490234E+04},
 {    5556, .8323755859375E+04, -.1411322021484E+04, .1093646728516E+04},
 {    5557, .8317958984375E+04, -.1411322021484E+04, .1096241699219E+04},
 {    5558, .8312165039062E+04, -.1411322021484E+04, .1098835937500E+04},
 {    5559, .8358530273438E+04, -.1417671997070E+04, .1078079589844E+04},
 {    5560, .8352735351562E+04, -.1417671997070E+04, .1080674316406E+04},
 {    5561, .8346940429688E+04, -.1417671997070E+04, .1083268798828E+04},
 {    5562, .8341141601562E+04, -.1417671997070E+04, .1085863403320E+04},
 {    5563, .8335346679688E+04, -.1417671997070E+04, .1088457763672E+04},
 {    5564, .8329552734375E+04, -.1417671997070E+04, .1091052490234E+04},
 {    5565, .8323755859375E+04, -.1417671997070E+04, .1093646728516E+04},
 {    5566, .8317958984375E+04, -.1417671997070E+04, .1096241699219E+04},
 {    5567, .8312165039062E+04, -.1417671997070E+04, .1098835937500E+04},
 {    5568, .8356454101562E+04, -.1411322021484E+04, .1073442993164E+04},
 {    5569, .8350658203125E+04, -.1411322021484E+04, .1076037597656E+04},
 {    5570, .8344863281250E+04, -.1411322021484E+04, .1078632080078E+04},
 {    5571, .8339066406250E+04, -.1411322021484E+04, .1081226562500E+04},
 {    5572, .8333272460938E+04, -.1411322021484E+04, .1083821044922E+04},
 {    5573, .8327475585938E+04, -.1411322021484E+04, .1086415771484E+04},
 {    5574, .8321680664062E+04, -.1411322021484E+04, .1089010131836E+04},
 {    5575, .8315884765625E+04, -.1411322021484E+04, .1091604980469E+04},
 {    5576, .8310089843750E+04, -.1411322021484E+04, .1094199707031E+04},
 {    5577, .8350658203125E+04, -.1417671997070E+04, .1076037597656E+04},
 {    5578, .8339066406250E+04, -.1417671997070E+04, .1081226562500E+04},
 {    5579, .8327475585938E+04, -.1417671997070E+04, .1086415771484E+04},
 {    5580, .8315884765625E+04, -.1417671997070E+04, .1091604980469E+04},
 {    5581, .8351264648438E+04, -.1411322021484E+04, .1061851684570E+04},
 {    5582, .8345468750000E+04, -.1411322021484E+04, .1064446044922E+04},
 {    5583, .8339673828125E+04, -.1411322021484E+04, .1067040649414E+04},
 {    5584, .8333877929688E+04, -.1411322021484E+04, .1069635131836E+04},
 {    5585, .8328083007812E+04, -.1411322021484E+04, .1072229858398E+04},
 {    5586, .8322289062500E+04, -.1411322021484E+04, .1074823974609E+04},
 {    5587, .8316491210938E+04, -.1411322021484E+04, .1077418945312E+04},
 {    5588, .8310696289062E+04, -.1411322021484E+04, .1080013427734E+04},
 {    5589, .8304899414062E+04, -.1411322021484E+04, .1082608154297E+04},
 {    5590, .8345468750000E+04, -.1417671997070E+04, .1064446044922E+04},
 {    5591, .8333877929688E+04, -.1417671997070E+04, .1069635131836E+04},
 {    5592, .8322289062500E+04, -.1417671997070E+04, .1074823974609E+04},
 {    5593, .8310696289062E+04, -.1417671997070E+04, .1080013427734E+04},
 {    5594, .8346075195312E+04, -.1411322021484E+04, .1050260009766E+04},
 {    5595, .8340279296875E+04, -.1411322021484E+04, .1052854492188E+04},
 {    5596, .8334484375000E+04, -.1411322021484E+04, .1055449218750E+04},
 {    5597, .8328690429688E+04, -.1411322021484E+04, .1058043579102E+04},
 {    5598, .8322892578125E+04, -.1411322021484E+04, .1060638183594E+04},
 {    5599, .8317096679688E+04, -.1411322021484E+04, .1063233032227E+04},
 {    5600, .8311302734375E+04, -.1411322021484E+04, .1065827270508E+04},
 {    5601, .8305505859375E+04, -.1411322021484E+04, .1068421630859E+04},
 {    5602, .8299710937500E+04, -.1411322021484E+04, .1071016357422E+04},
 {    5603, .8340279296875E+04, -.1417671997070E+04, .1052854492188E+04},
 {    5604, .8328690429688E+04, -.1417671997070E+04, .1058043579102E+04},
 {    5605, .8317096679688E+04, -.1417671997070E+04, .1063233032227E+04},
 {    5606, .8305505859375E+04, -.1417671997070E+04, .1068421630859E+04},
 {    5607, .8344782226562E+04, -.1411322021484E+04, .1047361816406E+04},
 {    5608, .8338984375000E+04, -.1411322021484E+04, .1049956420898E+04},
 {    5609, .8333187500000E+04, -.1411322021484E+04, .1052551025391E+04},
 {    5610, .8327390625000E+04, -.1411322021484E+04, .1055145629883E+04},
 {    5611, .8321595703125E+04, -.1411322021484E+04, .1057740356445E+04},
 {    5612, .8315798828125E+04, -.1411322021484E+04, .1060335449219E+04},
 {    5613, .8310006835938E+04, -.1411322021484E+04, .1062929321289E+04},
 {    5614, .8304208007812E+04, -.1411322021484E+04, .1065523925781E+04},
 {    5615, .8298413085938E+04, -.1411322021484E+04, .1068118286133E+04},
 {    5616, .8338984375000E+04, -.1417671997070E+04, .1049956420898E+04},
 {    5617, .8327390625000E+04, -.1417671997070E+04, .1055145629883E+04},
 {    5618, .8315798828125E+04, -.1417671997070E+04, .1060335449219E+04},
 {    5619, .8304208007812E+04, -.1417671997070E+04, .1065523925781E+04},
 {    5620, .8339590820312E+04, -.1411322021484E+04, .1035770751953E+04},
 {    5621, .8333795898438E+04, -.1411322021484E+04, .1038365356445E+04},
 {    5622, .8327998046875E+04, -.1411322021484E+04, .1040959594727E+04},
 {    5623, .8322202148438E+04, -.1411322021484E+04, .1043554565430E+04},
 {    5624, .8316409179688E+04, -.1411322021484E+04, .1046148437500E+04},
 {    5625, .8310612304688E+04, -.1411322021484E+04, .1048743408203E+04},
 {    5626, .8304816406250E+04, -.1411322021484E+04, .1051337646484E+04},
 {    5627, .8299019531250E+04, -.1411322021484E+04, .1053931884766E+04},
 {    5628, .8293222656250E+04, -.1411322021484E+04, .1056526855469E+04},
 {    5629, .8333795898438E+04, -.1417671997070E+04, .1038365356445E+04},
 {    5630, .8322202148438E+04, -.1417671997070E+04, .1043554565430E+04},
 {    5631, .8310612304688E+04, -.1417671997070E+04, .1048743408203E+04},
 {    5632, .8299019531250E+04, -.1417671997070E+04, .1053931884766E+04},
 {    5633, .8334400390625E+04, -.1411322021484E+04, .1024179321289E+04},
 {    5634, .8328605468750E+04, -.1411322021484E+04, .1026773681641E+04},
 {    5635, .8322810546875E+04, -.1411322021484E+04, .1029367919922E+04},
 {    5636, .8317013671875E+04, -.1411322021484E+04, .1031962402344E+04},
 {    5637, .8311216796875E+04, -.1411322021484E+04, .1034557128906E+04},
 {    5638, .8305422851562E+04, -.1411322021484E+04, .1037151611328E+04},
 {    5639, .8299626953125E+04, -.1411322021484E+04, .1039746093750E+04},
 {    5640, .8293831054688E+04, -.1411322021484E+04, .1042341308594E+04},
 {    5641, .8288036132812E+04, -.1411322021484E+04, .1044935058594E+04},
 {    5642, .8328605468750E+04, -.1417671997070E+04, .1026773681641E+04},
 {    5643, .8317013671875E+04, -.1417671997070E+04, .1031962402344E+04},
 {    5644, .8305422851562E+04, -.1417671997070E+04, .1037151611328E+04},
 {    5645, .8293831054688E+04, -.1417671997070E+04, .1042341308594E+04},
 {    5646, .8333103515625E+04, -.1411322021484E+04, .1021281066895E+04},
 {    5647, .8327308593750E+04, -.1411322021484E+04, .1023875549316E+04},
 {    5648, .8321513671875E+04, -.1411322021484E+04, .1026470336914E+04},
 {    5649, .8315716796875E+04, -.1411322021484E+04, .1029065063477E+04},
 {    5650, .8309919921875E+04, -.1411322021484E+04, .1031659423828E+04},
 {    5651, .8304125000000E+04, -.1411322021484E+04, .1034253662109E+04},
 {    5652, .8298330078125E+04, -.1411322021484E+04, .1036848388672E+04},
 {    5653, .8292533203125E+04, -.1411322021484E+04, .1039442871094E+04},
 {    5654, .8286740234375E+04, -.1411322021484E+04, .1042037475586E+04},
 {    5655, .8327308593750E+04, -.1417671997070E+04, .1023875549316E+04},
 {    5656, .8315716796875E+04, -.1417671997070E+04, .1029065063477E+04},
 {    5657, .8304125000000E+04, -.1417671997070E+04, .1034253662109E+04},
 {    5658, .8292533203125E+04, -.1417671997070E+04, .1039442871094E+04},
 {    5659, .8327915039062E+04, -.1411322021484E+04, .1009689575195E+04},
 {    5660, .8322119140625E+04, -.1411322021484E+04, .1012283935547E+04},
 {    5661, .8316325195312E+04, -.1411322021484E+04, .1014878845215E+04},
 {    5662, .8310527343750E+04, -.1411322021484E+04, .1017473144531E+04},
 {    5663, .8304731445312E+04, -.1411322021484E+04, .1020067871094E+04},
 {    5664, .8298936523438E+04, -.1411322021484E+04, .1022662475586E+04},
 {    5665, .8293141601562E+04, -.1411322021484E+04, .1025256958008E+04},
 {    5666, .8287344726562E+04, -.1411322021484E+04, .1027851440430E+04},
 {    5667, .8281547851562E+04, -.1411322021484E+04, .1030446166992E+04},
 {    5668, .8322119140625E+04, -.1417671997070E+04, .1012283935547E+04},
 {    5669, .8310527343750E+04, -.1417671997070E+04, .1017473144531E+04},
 {    5670, .8298936523438E+04, -.1417671997070E+04, .1022662475586E+04},
 {    5671, .8287344726562E+04, -.1417671997070E+04, .1027851440430E+04},
 {    5672, .8322724609375E+04, -.1411322021484E+04, .9980984497070E+03},
 {    5673, .8316929687500E+04, -.1411322021484E+04, .1000692810059E+04},
 {    5674, .8311132812500E+04, -.1411322021484E+04, .1003287475586E+04},
 {    5675, .8305338867188E+04, -.1411322021484E+04, .1005881713867E+04},
 {    5676, .8299541992188E+04, -.1411322021484E+04, .1008476074219E+04},
 {    5677, .8293746093750E+04, -.1411322021484E+04, .1011070922852E+04},
 {    5678, .8287951171875E+04, -.1411322021484E+04, .1013665771484E+04},
 {    5679, .8282156250000E+04, -.1411322021484E+04, .1016260253906E+04},
 {    5680, .8276358398438E+04, -.1411322021484E+04, .1018854675293E+04},
 {    5681, .8316929687500E+04, -.1417671997070E+04, .1000692810059E+04},
 {    5682, .8305338867188E+04, -.1417671997070E+04, .1005881713867E+04},
 {    5683, .8293746093750E+04, -.1417671997070E+04, .1011070922852E+04},
 {    5684, .8282156250000E+04, -.1417671997070E+04, .1016260253906E+04},
 {    5685, .8321427734375E+04, -.1411322021484E+04, .9951999511719E+03},
 {    5686, .8315631835938E+04, -.1411322021484E+04, .9977950439453E+03},
 {    5687, .8309836914062E+04, -.1411322021484E+04, .1000389099121E+04},
 {    5688, .8304040039062E+04, -.1411322021484E+04, .1002984252930E+04},
 {    5689, .8298244140625E+04, -.1411322021484E+04, .1005578613281E+04},
 {    5690, .8292449218750E+04, -.1411322021484E+04, .1008172973633E+04},
 {    5691, .8286653320312E+04, -.1411322021484E+04, .1010767395020E+04},
 {    5692, .8280858398438E+04, -.1411322021484E+04, .1013362121582E+04},
 {    5693, .8275063476562E+04, -.1411322021484E+04, .1015956665039E+04},
 {    5694, .8315631835938E+04, -.1417671997070E+04, .9977950439453E+03},
 {    5695, .8304040039062E+04, -.1417671997070E+04, .1002984252930E+04},
 {    5696, .8292449218750E+04, -.1417671997070E+04, .1008172973633E+04},
 {    5697, .8280858398438E+04, -.1417671997070E+04, .1013362121582E+04},
 {    5698, .8316240234375E+04, -.1411322021484E+04, .9836082763672E+03},
 {    5699, .8310444335938E+04, -.1411322021484E+04, .9862033691406E+03},
 {    5700, .8304648437500E+04, -.1411322021484E+04, .9887977294922E+03},
 {    5701, .8298852539062E+04, -.1411322021484E+04, .9913925781250E+03},
 {    5702, .8293055664062E+04, -.1411322021484E+04, .9939868164062E+03},
 {    5703, .8287260742188E+04, -.1411322021484E+04, .9965816650391E+03},
 {    5704, .8281464843750E+04, -.1411322021484E+04, .9991757812500E+03},
 {    5705, .8275667968750E+04, -.1411322021484E+04, .1001770507812E+04},
 {    5706, .8269874023438E+04, -.1411322021484E+04, .1004364807129E+04},
 {    5707, .8310444335938E+04, -.1417671997070E+04, .9862033691406E+03},
 {    5708, .8298852539062E+04, -.1417671997070E+04, .9913928222656E+03},
 {    5709, .8287260742188E+04, -.1417671997070E+04, .9965816650391E+03},
 {    5710, .8275667968750E+04, -.1417671997070E+04, .1001770507812E+04},
 {    5711, .8311048828125E+04, -.1411322021484E+04, .9720169677734E+03},
 {    5712, .8305254882812E+04, -.1411322021484E+04, .9746121826172E+03},
 {    5713, .8299458007812E+04, -.1411322021484E+04, .9772065429688E+03},
 {    5714, .8293663085938E+04, -.1411322021484E+04, .9798010253906E+03},
 {    5715, .8287866210938E+04, -.1411322021484E+04, .9823955078125E+03},
 {    5716, .8282072265625E+04, -.1411322021484E+04, .9849899291992E+03},
 {    5717, .8276275390625E+04, -.1411322021484E+04, .9875843505859E+03},
 {    5718, .8270480468750E+04, -.1411322021484E+04, .9901790161133E+03},
 {    5719, .8264683593750E+04, -.1411322021484E+04, .9927739257812E+03},
 {    5720, .8305254882812E+04, -.1417671997070E+04, .9746121826172E+03},
 {    5721, .8293663085938E+04, -.1417671997070E+04, .9798010253906E+03},
 {    5722, .8282072265625E+04, -.1417671997070E+04, .9849899291992E+03},
 {    5723, .8270480468750E+04, -.1417671997070E+04, .9901790161133E+03},
 {    5724, .8309751953125E+04, -.1411322021484E+04, .9691195068359E+03},
 {    5725, .8303958007812E+04, -.1411322021484E+04, .9717136230469E+03},
 {    5726, .8298160156250E+04, -.1411322021484E+04, .9743084106445E+03},
 {    5727, .8292365234375E+04, -.1411322021484E+04, .9769032592773E+03},
 {    5728, .8286571289062E+04, -.1411322021484E+04, .9794973144531E+03},
 {    5729, .8280773437500E+04, -.1411322021484E+04, .9820920410156E+03},
 {    5730, .8274979492188E+04, -.1411322021484E+04, .9846864624023E+03},
 {    5731, .8269183593750E+04, -.1411322021484E+04, .9872812500000E+03},
 {    5732, .8263387695312E+04, -.1411322021484E+04, .9898752441406E+03},
 {    5733, .8303958007812E+04, -.1417671997070E+04, .9717136230469E+03},
 {    5734, .8292365234375E+04, -.1417671997070E+04, .9769032592773E+03},
 {    5735, .8280773437500E+04, -.1417671997070E+04, .9820920410156E+03},
 {    5736, .8269183593750E+04, -.1417671997070E+04, .9872812500000E+03},
 {    5737, .8304563476562E+04, -.1411322021484E+04, .9575277099609E+03},
 {    5738, .8298767578125E+04, -.1411322021484E+04, .9601221313477E+03},
 {    5739, .8292974609375E+04, -.1411322021484E+04, .9627166748047E+03},
 {    5740, .8287175781250E+04, -.1411322021484E+04, .9653112792969E+03},
 {    5741, .8281380859375E+04, -.1411322021484E+04, .9679062500000E+03},
 {    5742, .8275585937500E+04, -.1411322021484E+04, .9705003662109E+03},
 {    5743, .8269791015625E+04, -.1411322021484E+04, .9730949707031E+03},
 {    5744, .8263994140625E+04, -.1411322021484E+04, .9756896362305E+03},
 {    5745, .8258200195312E+04, -.1411322021484E+04, .9782839355469E+03},
 {    5746, .8298767578125E+04, -.1417671997070E+04, .9601221313477E+03},
 {    5747, .8287175781250E+04, -.1417671997070E+04, .9653112792969E+03},
 {    5748, .8275585937500E+04, -.1417671997070E+04, .9705003662109E+03},
 {    5749, .8263994140625E+04, -.1417671997070E+04, .9756896362305E+03},
 {    5750, .8299374023438E+04, -.1411322021484E+04, .9459361572266E+03},
 {    5751, .8293578125000E+04, -.1411322021484E+04, .9485307617188E+03},
 {    5752, .8287782226562E+04, -.1411322021484E+04, .9511254882812E+03},
 {    5753, .8281987304688E+04, -.1411322021484E+04, .9537197875977E+03},
 {    5754, .8276192382812E+04, -.1411322021484E+04, .9563143310547E+03},
 {    5755, .8270395507812E+04, -.1411322021484E+04, .9589091796875E+03},
 {    5756, .8264600585938E+04, -.1411322021484E+04, .9615036621094E+03},
 {    5757, .8258804687500E+04, -.1411322021484E+04, .9640978393555E+03},
 {    5758, .8253008789062E+04, -.1411322021484E+04, .9666925048828E+03},
 {    5759, .8293578125000E+04, -.1417671997070E+04, .9485307617188E+03},
 {    5760, .8281987304688E+04, -.1417671997070E+04, .9537197875977E+03},
 {    5761, .8270395507812E+04, -.1417671997070E+04, .9589091796875E+03},
 {    5762, .8258804687500E+04, -.1417671997070E+04, .9640978393555E+03},
 {    5763, .8297298828125E+04, -.1411322021484E+04, .9412995605469E+03},
 {    5764, .8291503906250E+04, -.1411322021484E+04, .9438941040039E+03},
 {    5765, .8285707031250E+04, -.1411322021484E+04, .9464887084961E+03},
 {    5766, .8279911132812E+04, -.1411322021484E+04, .9490833740234E+03},
 {    5767, .8274116210938E+04, -.1411322021484E+04, .9516777343750E+03},
 {    5768, .8268319335938E+04, -.1411322021484E+04, .9542723388672E+03},
 {    5769, .8262524414062E+04, -.1411322021484E+04, .9568668823242E+03},
 {    5770, .8256730468750E+04, -.1411322021484E+04, .9594612426758E+03},
 {    5771, .8250930664062E+04, -.1411322021484E+04, .9620561523438E+03},
 {    5772, .8297298828125E+04, -.1417671997070E+04, .9412995605469E+03},
 {    5773, .8291503906250E+04, -.1417671997070E+04, .9438941040039E+03},
 {    5774, .8285707031250E+04, -.1417671997070E+04, .9464887084961E+03},
 {    5775, .8279911132812E+04, -.1417671997070E+04, .9490833740234E+03},
 {    5776, .8274116210938E+04, -.1417671997070E+04, .9516777343750E+03},
 {    5777, .8268319335938E+04, -.1417671997070E+04, .9542723388672E+03},
 {    5778, .8262524414062E+04, -.1417671997070E+04, .9568668823242E+03},
 {    5779, .8256730468750E+04, -.1417671997070E+04, .9594612426758E+03},
 {    5780, .8250930664062E+04, -.1417671997070E+04, .9620561523438E+03},
 {    5781, .8346075195312E+04, -.1399892089844E+04, .1050260009766E+04},
 {    5782, .8334484375000E+04, -.1399892089844E+04, .1055449218750E+04},
 {    5783, .8322892578125E+04, -.1399892089844E+04, .1060638183594E+04},
 {    5784, .8344782226562E+04, -.1399892089844E+04, .1047361816406E+04},
 {    5785, .8333187500000E+04, -.1399892089844E+04, .1052551025391E+04},
 {    5786, .8321595703125E+04, -.1399892089844E+04, .1057740356445E+04},
 {    5787, .8339590820312E+04, -.1399892089844E+04, .1035770751953E+04},
 {    5788, .8327998046875E+04, -.1399892089844E+04, .1040959594727E+04},
 {    5789, .8316409179688E+04, -.1399892089844E+04, .1046148437500E+04},
 {    5790, .8334400390625E+04, -.1399892089844E+04, .1024179321289E+04},
 {    5791, .8322810546875E+04, -.1399892089844E+04, .1029367919922E+04},
 {    5792, .8311216796875E+04, -.1399892089844E+04, .1034557128906E+04},
 {    5793, .8333103515625E+04, -.1399892089844E+04, .1021281066895E+04},
 {    5794, .8321513671875E+04, -.1399892089844E+04, .1026470336914E+04},
 {    5795, .8309919921875E+04, -.1399892089844E+04, .1031659179688E+04},
 {    5796, .8327915039062E+04, -.1399892089844E+04, .1009689575195E+04},
 {    5797, .8316325195312E+04, -.1399892089844E+04, .1014878845215E+04},
 {    5798, .8304731445312E+04, -.1399892089844E+04, .1020067871094E+04},
 {    5799, .8322724609375E+04, -.1399892089844E+04, .9980984497070E+03},
 {    5800, .8311132812500E+04, -.1399892089844E+04, .1003287475586E+04},
 {    5801, .8299541992188E+04, -.1399892089844E+04, .1008476074219E+04},
 {    5802, .8321427734375E+04, -.1399892089844E+04, .9951999511719E+03},
 {    5803, .8309836914062E+04, -.1399892089844E+04, .1000389099121E+04},
 {    5804, .8298244140625E+04, -.1399892089844E+04, .1005578613281E+04},
 {    5805, .8316240234375E+04, -.1399892089844E+04, .9836082763672E+03},
 {    5806, .8304648437500E+04, -.1399892089844E+04, .9887977294922E+03},
 {    5807, .8293055664062E+04, -.1399892089844E+04, .9939868164062E+03},
 {    5808, .8311048828125E+04, -.1399892089844E+04, .9720169677734E+03},
 {    5809, .8299458007812E+04, -.1399892089844E+04, .9772065429688E+03},
 {    5810, .8287866210938E+04, -.1399892089844E+04, .9823955078125E+03},
 {    5811, .8309751953125E+04, -.1399892089844E+04, .9691195068359E+03},
 {    5812, .8298160156250E+04, -.1399892089844E+04, .9743084106445E+03},
 {    5813, .8286571289062E+04, -.1399892089844E+04, .9794973144531E+03},
 {    5814, .8311302734375E+04, -.1399892089844E+04, .1065827270508E+04},
 {    5815, .8299710937500E+04, -.1399892089844E+04, .1071016357422E+04},
 {    5816, .8310006835938E+04, -.1399892089844E+04, .1062929321289E+04},
 {    5817, .8298413085938E+04, -.1399892089844E+04, .1068118286133E+04},
 {    5818, .8304816406250E+04, -.1399892089844E+04, .1051337646484E+04},
 {    5819, .8293222656250E+04, -.1399892089844E+04, .1056526855469E+04},
 {    5820, .8299626953125E+04, -.1399892089844E+04, .1039746093750E+04},
 {    5821, .8288036132812E+04, -.1399892089844E+04, .1044935058594E+04},
 {    5822, .8286653320312E+04, -.1399892089844E+04, .1010767395020E+04},
 {    5823, .8275063476562E+04, -.1399892089844E+04, .1015956665039E+04},
 {    5824, .8281464843750E+04, -.1399892089844E+04, .9991757812500E+03},
 {    5825, .8269874023438E+04, -.1399892089844E+04, .1004364807129E+04},
 {    5826, .8276275390625E+04, -.1399892089844E+04, .9875843505859E+03},
 {    5827, .8264683593750E+04, -.1399892089844E+04, .9927739257812E+03},
 {    5828, .8274979492188E+04, -.1399892089844E+04, .9846864624023E+03},
 {    5829, .8263387695312E+04, -.1399892089844E+04, .9898752441406E+03},
 {    5830, .8305422851562E+04, -.1412592041016E+04, .1037151611328E+04},
 {    5831, .8296728515625E+04, -.1412592041016E+04, .1041043579102E+04},
 {    5832, .8305422851562E+04, -.1404972045898E+04, .1037151611328E+04},
 {    5833, .8296728515625E+04, -.1404972045898E+04, .1041043579102E+04},
 {    5834, .8304125000000E+04, -.1412592041016E+04, .1034253662109E+04},
 {    5835, .8295432617188E+04, -.1412592041016E+04, .1038145751953E+04},
 {    5836, .8304125000000E+04, -.1404972045898E+04, .1034253662109E+04},
 {    5837, .8295432617188E+04, -.1404972045898E+04, .1038145751953E+04},
 {    5838, .8298936523438E+04, -.1412592041016E+04, .1022662475586E+04},
 {    5839, .8290245117188E+04, -.1412592041016E+04, .1026553833008E+04},
 {    5840, .8298936523438E+04, -.1404972045898E+04, .1022662475586E+04},
 {    5841, .8290245117188E+04, -.1404972045898E+04, .1026553833008E+04},
 {    5842, .8293746093750E+04, -.1412592041016E+04, .1011070922852E+04},
 {    5843, .8285053710938E+04, -.1412592041016E+04, .1014962463379E+04},
 {    5844, .8293746093750E+04, -.1404972045898E+04, .1011070922852E+04},
 {    5845, .8285053710938E+04, -.1404972045898E+04, .1014962463379E+04},
 {    5846, .8292449218750E+04, -.1412592041016E+04, .1008172973633E+04},
 {    5847, .8283754882812E+04, -.1412592041016E+04, .1012065063477E+04},
 {    5848, .8292449218750E+04, -.1404972045898E+04, .1008172973633E+04},
 {    5849, .8283754882812E+04, -.1404972045898E+04, .1012065063477E+04},
 {    5850, .8305422851562E+04, -.1394812011719E+04, .1037151611328E+04},
 {    5851, .8296728515625E+04, -.1394812011719E+04, .1041043579102E+04},
 {    5852, .8305422851562E+04, -.1384652099609E+04, .1037151611328E+04},
 {    5853, .8296728515625E+04, -.1384652099609E+04, .1041043579102E+04},
 {    5854, .8304125000000E+04, -.1394812011719E+04, .1034253662109E+04},
 {    5855, .8295432617188E+04, -.1394812011719E+04, .1038145751953E+04},
 {    5856, .8304125000000E+04, -.1384652099609E+04, .1034253662109E+04},
 {    5857, .8295432617188E+04, -.1384652099609E+04, .1038145751953E+04},
 {    5858, .8293746093750E+04, -.1394812011719E+04, .1011070922852E+04},
 {    5859, .8285053710938E+04, -.1394812011719E+04, .1014962463379E+04},
 {    5860, .8293746093750E+04, -.1384652099609E+04, .1011070922852E+04},
 {    5861, .8285053710938E+04, -.1384652099609E+04, .1014962463379E+04},
 {    5862, .8292449218750E+04, -.1394812011719E+04, .1008172973633E+04},
 {    5863, .8283754882812E+04, -.1394812011719E+04, .1012065063477E+04},
 {    5864, .8292449218750E+04, -.1384652099609E+04, .1008172973633E+04},
 {    5865, .8283754882812E+04, -.1384652099609E+04, .1012065063477E+04},
 {    5866, .8305422851562E+04, -.1374492065430E+04, .1037151611328E+04},
 {    5867, .8296728515625E+04, -.1374492065430E+04, .1041043579102E+04},
 {    5868, .8304125000000E+04, -.1374492065430E+04, .1034253662109E+04},
 {    5869, .8295432617188E+04, -.1374492065430E+04, .1038145751953E+04},
 {    5870, .8298936523438E+04, -.1384652099609E+04, .1022662475586E+04},
 {    5871, .8289083984375E+04, -.1384652099609E+04, .1027073120117E+04},
 {    5872, .8298936523438E+04, -.1374492065430E+04, .1022662475586E+04},
 {    5873, .8290245117188E+04, -.1374492065430E+04, .1026553833008E+04},
 {    5874, .8293746093750E+04, -.1374492065430E+04, .1011070922852E+04},
 {    5875, .8285053710938E+04, -.1374492065430E+04, .1014962463379E+04},
 {    5876, .8292449218750E+04, -.1374492065430E+04, .1008172973633E+04},
 {    5877, .8283754882812E+04, -.1374492065430E+04, .1012065063477E+04},
 {    5878, .8288036132812E+04, -.1412592041016E+04, .1044935058594E+04},
 {    5879, .8288036132812E+04, -.1404972045898E+04, .1044935058594E+04},
 {    5880, .8286740234375E+04, -.1412592041016E+04, .1042037475586E+04},
 {    5881, .8286740234375E+04, -.1404972045898E+04, .1042037475586E+04},
 {    5882, .8281547851562E+04, -.1412592041016E+04, .1030446166992E+04},
 {    5883, .8281547851562E+04, -.1404972045898E+04, .1030446166992E+04},
 {    5884, .8276358398438E+04, -.1412592041016E+04, .1018854675293E+04},
 {    5885, .8276358398438E+04, -.1404972045898E+04, .1018854675293E+04},
 {    5886, .8275063476562E+04, -.1412592041016E+04, .1015956665039E+04},
 {    5887, .8275063476562E+04, -.1404972045898E+04, .1015956665039E+04},
 {    5888, .8288036132812E+04, -.1394812011719E+04, .1044935058594E+04},
 {    5889, .8288036132812E+04, -.1384652099609E+04, .1044935058594E+04},
 {    5890, .8286740234375E+04, -.1394812011719E+04, .1042037475586E+04},
 {    5891, .8286740234375E+04, -.1384652099609E+04, .1042037475586E+04},
 {    5892, .8276358398438E+04, -.1394812011719E+04, .1018854675293E+04},
 {    5893, .8276358398438E+04, -.1384652099609E+04, .1018854675293E+04},
 {    5894, .8275063476562E+04, -.1394812011719E+04, .1015956665039E+04},
 {    5895, .8275063476562E+04, -.1384652099609E+04, .1015956665039E+04},
 {    5896, .8288036132812E+04, -.1374492065430E+04, .1044935058594E+04},
 {    5897, .8286740234375E+04, -.1374492065430E+04, .1042037475586E+04},
 {    5898, .8281547851562E+04, -.1384652099609E+04, .1030446166992E+04},
 {    5899, .8281547851562E+04, -.1374492065430E+04, .1030446166992E+04},
 {    5900, .8276358398438E+04, -.1374492065430E+04, .1018854675293E+04},
 {    5901, .8275063476562E+04, -.1374492065430E+04, .1015956665039E+04},
 {    5902, .8410052734375E+04, -.1204849121094E+04, .1055015747070E+04},
 {    5903, .8398058593750E+04, -.1191707885742E+04, .1060385131836E+04},
 {    5904, .8387867187500E+04, -.1180542480469E+04, .1064946655273E+04},
 {    5905, .8378083984375E+04, -.1169826049805E+04, .1069325927734E+04},
 {    5906, .8413117187500E+04, -.1200779663086E+04, .1053643310547E+04},
 {    5907, .8402361328125E+04, -.1186821533203E+04, .1058457641602E+04},
 {    5908, .8392325195312E+04, -.1175824340820E+04, .1062950561523E+04},
 {    5909, .8381799804688E+04, -.1166466796875E+04, .1067663085938E+04},
 {    5910, .8416183593750E+04, -.1196710449219E+04, .1052270507812E+04},
 {    5911, .8406669921875E+04, -.1181935180664E+04, .1056529174805E+04},
 {    5912, .8396785156250E+04, -.1171106323242E+04, .1060954101562E+04},
 {    5913, .8385511718750E+04, -.1163107421875E+04, .1066000122070E+04},
 {    5914, .8407976562500E+04, -.1204849121094E+04, .1050379394531E+04},
 {    5915, .8395981445312E+04, -.1191707885742E+04, .1055748291016E+04},
 {    5916, .8385790039062E+04, -.1180542480469E+04, .1060310546875E+04},
 {    5917, .8376007812500E+04, -.1169826049805E+04, .1064689086914E+04},
 {    5918, .8411041992188E+04, -.1200779663086E+04, .1049006225586E+04},
 {    5919, .8400289062500E+04, -.1186821533203E+04, .1053820312500E+04},
 {    5920, .8390250000000E+04, -.1175824340820E+04, .1058313964844E+04},
 {    5921, .8379723632812E+04, -.1166466796875E+04, .1063026611328E+04},
 {    5922, .8402789062500E+04, -.1204849121094E+04, .1038786865234E+04},
 {    5923, .8390792968750E+04, -.1191707885742E+04, .1044156738281E+04},
 {    5924, .8380602539062E+04, -.1180542480469E+04, .1048718627930E+04},
 {    5925, .8370820312500E+04, -.1169826049805E+04, .1053097412109E+04},
 {    5926, .8405852539062E+04, -.1200779663086E+04, .1037415039062E+04},
 {    5927, .8395097656250E+04, -.1186821533203E+04, .1042229248047E+04},
 {    5928, .8385062500000E+04, -.1175824340820E+04, .1046722534180E+04},
 {    5929, .8374534179688E+04, -.1166466796875E+04, .1051435180664E+04},
 {    5930, .8397598632812E+04, -.1204849121094E+04, .1027196533203E+04},
 {    5931, .8385602539062E+04, -.1191707885742E+04, .1032565795898E+04},
 {    5932, .8375414062500E+04, -.1180542480469E+04, .1037127929688E+04},
 {    5933, .8365631835938E+04, -.1169826049805E+04, .1041506103516E+04},
 {    5934, .8400664062500E+04, -.1200779663086E+04, .1025823120117E+04},
 {    5935, .8389908203125E+04, -.1186821533203E+04, .1030637817383E+04},
 {    5936, .8379871093750E+04, -.1175824340820E+04, .1035131347656E+04},
 {    5937, .8369345703125E+04, -.1166466796875E+04, .1039843139648E+04},
 {    5938, .8396299804688E+04, -.1204849121094E+04, .1024298095703E+04},
 {    5939, .8384306640625E+04, -.1191707885742E+04, .1029667236328E+04},
 {    5940, .8374114257812E+04, -.1180542480469E+04, .1034229248047E+04},
 {    5941, .8364333984375E+04, -.1169826049805E+04, .1038607910156E+04},
 {    5942, .8399366210938E+04, -.1200779663086E+04, .1022925659180E+04},
 {    5943, .8388612304688E+04, -.1186821533203E+04, .1027739746094E+04},
 {    5944, .8378574218750E+04, -.1175824340820E+04, .1032232910156E+04},
 {    5945, .8368048828125E+04, -.1166466796875E+04, .1036945556641E+04},
 {    5946, .8391111328125E+04, -.1204849121094E+04, .1012706970215E+04},
 {    5947, .8379118164062E+04, -.1191708007812E+04, .1018075927734E+04},
 {    5948, .8368925781250E+04, -.1180542480469E+04, .1022638305664E+04},
 {    5949, .8359146484375E+04, -.1169826049805E+04, .1027016357422E+04},
 {    5950, .8394177734375E+04, -.1200779785156E+04, .1011333801270E+04},
 {    5951, .8383423828125E+04, -.1186821533203E+04, .1016148437500E+04},
 {    5952, .8373385742188E+04, -.1175824340820E+04, .1020641235352E+04},
 {    5953, .8362860351562E+04, -.1166466796875E+04, .1025353881836E+04},
 {    5954, .8385921875000E+04, -.1204849121094E+04, .1001115112305E+04},
 {    5955, .8373929687500E+04, -.1191708007812E+04, .1006484985352E+04},
 {    5956, .8363735351562E+04, -.1180542480469E+04, .1011046630859E+04},
 {    5957, .8353957031250E+04, -.1169826049805E+04, .1015425292969E+04},
 {    5958, .8388987304688E+04, -.1200779785156E+04, .9997425537109E+03},
 {    5959, .8378234375000E+04, -.1186821533203E+04, .1004556457520E+04},
 {    5960, .8368197265625E+04, -.1175824340820E+04, .1009049743652E+04},
 {    5961, .8357671875000E+04, -.1166466796875E+04, .1013762207031E+04},
 {    5962, .8384625000000E+04, -.1204849121094E+04, .9982170410156E+03},
 {    5963, .8372631835938E+04, -.1191708007812E+04, .1003586181641E+04},
 {    5964, .8362438476562E+04, -.1180542480469E+04, .1008148193359E+04},
 {    5965, .8352659179688E+04, -.1169826049805E+04, .1012526977539E+04},
 {    5966, .8387691406250E+04, -.1200779785156E+04, .9968448486328E+03},
 {    5967, .8376937500000E+04, -.1186821533203E+04, .1001658691406E+04},
 {    5968, .8366899414062E+04, -.1175824340820E+04, .1006151855469E+04},
 {    5969, .8356373046875E+04, -.1166466796875E+04, .1010864379883E+04},
 {    5970, .8379433593750E+04, -.1204849121094E+04, .9866258544922E+03},
 {    5971, .8367441406250E+04, -.1191708007812E+04, .9919949340820E+03},
 {    5972, .8357250976562E+04, -.1180542480469E+04, .9965565185547E+03},
 {    5973, .8347470703125E+04, -.1169826049805E+04, .1000935791016E+04},
 {    5974, .8382500976562E+04, -.1200779785156E+04, .9852527465820E+03},
 {    5975, .8371749023438E+04, -.1186821533203E+04, .9900670776367E+03},
 {    5976, .8361709960938E+04, -.1175824340820E+04, .9945605468750E+03},
 {    5977, .8351184570312E+04, -.1166466796875E+04, .9992730712891E+03},
 {    5978, .8374247070312E+04, -.1204849121094E+04, .9750340576172E+03},
 {    5979, .8362250976562E+04, -.1191708007812E+04, .9804036254883E+03},
 {    5980, .8352061523438E+04, -.1180542480469E+04, .9849656982422E+03},
 {    5981, .8342281250000E+04, -.1169826049805E+04, .9893442382812E+03},
 {    5982, .8377312500000E+04, -.1200779785156E+04, .9736614990234E+03},
 {    5983, .8366558593750E+04, -.1186821533203E+04, .9784755859375E+03},
 {    5984, .8356519531250E+04, -.1175824340820E+04, .9829691162109E+03},
 {    5985, .8345996093750E+04, -.1166466796875E+04, .9876814575195E+03},
 {    5986, .8372952148438E+04, -.1204849121094E+04, .9721361083984E+03},
 {    5987, .8360955078125E+04, -.1191708007812E+04, .9775054321289E+03},
 {    5988, .8350763671875E+04, -.1180542480469E+04, .9820677490234E+03},
 {    5989, .8340982421875E+04, -.1169826049805E+04, .9864465332031E+03},
 {    5990, .8376017578125E+04, -.1200779785156E+04, .9707634277344E+03},
 {    5991, .8365260742188E+04, -.1186821533203E+04, .9755781250000E+03},
 {    5992, .8355223632812E+04, -.1175824340820E+04, .9800710449219E+03},
 {    5993, .8344697265625E+04, -.1166466796875E+04, .9847835083008E+03},
 {    5994, .8367760742188E+04, -.1204849121094E+04, .9605444335938E+03},
 {    5995, .8355766601562E+04, -.1191708007812E+04, .9659140625000E+03},
 {    5996, .8345575195312E+04, -.1180542480469E+04, .9704758300781E+03},
 {    5997, .8335793945312E+04, -.1169826049805E+04, .9748542480469E+03},
 {    5998, .8370823242188E+04, -.1200779785156E+04, .9591724243164E+03},
 {    5999, .8360072265625E+04, -.1186821533203E+04, .9639863281250E+03},
 {    6000, .8350035156250E+04, -.1175824340820E+04, .9684794311523E+03},
 {    6001, .8339507812500E+04, -.1166466796875E+04, .9731922607422E+03},
 {    6002, .8362571289062E+04, -.1204849121094E+04, .9489532470703E+03},
 {    6003, .8350576171875E+04, -.1191708007812E+04, .9543225097656E+03},
 {    6004, .8340387695312E+04, -.1180542480469E+04, .9588843383789E+03},
 {    6005, .8330605468750E+04, -.1169826049805E+04, .9632632446289E+03},
 {    6006, .8365636718750E+04, -.1200779785156E+04, .9475803833008E+03},
 {    6007, .8354884765625E+04, -.1186821533203E+04, .9523945312500E+03},
 {    6008, .8344844726562E+04, -.1175824340820E+04, .9568877563477E+03},
 {    6009, .8334320312500E+04, -.1166466796875E+04, .9616002197266E+03},
 {    6010, .8361274414062E+04, -.1204849121094E+04, .9460551757812E+03},
 {    6011, .8349280273438E+04, -.1191708007812E+04, .9514244995117E+03},
 {    6012, .8339087890625E+04, -.1180542480469E+04, .9559864501953E+03},
 {    6013, .8329307617188E+04, -.1169826049805E+04, .9603653564453E+03},
 {    6014, .8364340820312E+04, -.1200779785156E+04, .9446827392578E+03},
 {    6015, .8353587890625E+04, -.1186821533203E+04, .9494965820312E+03},
 {    6016, .8343549804688E+04, -.1175824340820E+04, .9539900512695E+03},
 {    6017, .8333022460938E+04, -.1166466796875E+04, .9587027587891E+03},
 {    6018, .8356086914062E+04, -.1204849121094E+04, .9344635620117E+03},
 {    6019, .8344090820312E+04, -.1191708007812E+04, .9398328857422E+03},
 {    6020, .8333899414062E+04, -.1180542480469E+04, .9443953247070E+03},
 {    6021, .8324117187500E+04, -.1169826049805E+04, .9487739868164E+03},
 {    6022, .8359151367188E+04, -.1200779785156E+04, .9330910644531E+03},
 {    6023, .8348396484375E+04, -.1186821533203E+04, .9379051513672E+03},
 {    6024, .8338360351562E+04, -.1175824340820E+04, .9423988037109E+03},
 {    6025, .8327832031250E+04, -.1166466796875E+04, .9471110839844E+03},
 {    6026, .8350895507812E+04, -.1204849121094E+04, .9228720703125E+03},
 {    6027, .8338900390625E+04, -.1191708007812E+04, .9282416992188E+03},
 {    6028, .8328709960938E+04, -.1180542480469E+04, .9328036499023E+03},
 {    6029, .8318929687500E+04, -.1169826049805E+04, .9371823730469E+03},
 {    6030, .8353960937500E+04, -.1200779785156E+04, .9214998779297E+03},
 {    6031, .8343207031250E+04, -.1186821533203E+04, .9263137207031E+03},
 {    6032, .8333169921875E+04, -.1175824340820E+04, .9308072509766E+03},
 {    6033, .8322645507812E+04, -.1166466796875E+04, .9355192871094E+03},
 {    6034, .8348819335938E+04, -.1204849121094E+04, .9182355346680E+03},
 {    6035, .8336826171875E+04, -.1191708007812E+04, .9236049194336E+03},
 {    6036, .8326634765625E+04, -.1180542480469E+04, .9281667480469E+03},
 {    6037, .8316853515625E+04, -.1169826049805E+04, .9325457763672E+03},
 {    6038, .8351886718750E+04, -.1200779785156E+04, .9168629760742E+03},
 {    6039, .8341131835938E+04, -.1186821533203E+04, .9216771850586E+03},
 {    6040, .8331093750000E+04, -.1175824340820E+04, .9261706542969E+03},
 {    6041, .8320569335938E+04, -.1166466796875E+04, .9308826904297E+03},
 {    6042, .8354953125000E+04, -.1196710449219E+04, .9154902343750E+03},
 {    6043, .8345439453125E+04, -.1181935180664E+04, .9197494506836E+03},
 {    6044, .8335553710938E+04, -.1171106323242E+04, .9241740722656E+03},
 {    6045, .8324280273438E+04, -.1163107421875E+04, .9292204589844E+03},
 {    6046, .8378083984375E+04, -.1401358032227E+04, .1069325927734E+04},
 {    6047, .8387867187500E+04, -.1390641601562E+04, .1064946655273E+04},
 {    6048, .8397811523438E+04, -.1379745483398E+04, .1060495117188E+04},
 {    6049, .8410871093750E+04, -.1365437011719E+04, .1054648315430E+04},
 {    6050, .8381799804688E+04, -.1404717285156E+04, .1067663085938E+04},
 {    6051, .8392325195312E+04, -.1395359741211E+04, .1062950561523E+04},
 {    6052, .8402117187500E+04, -.1384631958008E+04, .1058567626953E+04},
 {    6053, .8413935546875E+04, -.1369506347656E+04, .1053276611328E+04},
 {    6054, .8385511718750E+04, -.1408076660156E+04, .1066000122070E+04},
 {    6055, .8396785156250E+04, -.1400077758789E+04, .1060954101562E+04},
 {    6056, .8406422851562E+04, -.1389518310547E+04, .1056639404297E+04},
 {    6057, .8417002929688E+04, -.1373575683594E+04, .1051903442383E+04},
 {    6058, .8376007812500E+04, -.1401358032227E+04, .1064689086914E+04},
 {    6059, .8385790039062E+04, -.1390641601562E+04, .1060310546875E+04},
 {    6060, .8395737304688E+04, -.1379745483398E+04, .1055858520508E+04},
 {    6061, .8408795898438E+04, -.1365437011719E+04, .1050012207031E+04},
 {    6062, .8379723632812E+04, -.1404717285156E+04, .1063026611328E+04},
 {    6063, .8390250000000E+04, -.1395359741211E+04, .1058313964844E+04},
 {    6064, .8400041992188E+04, -.1384631958008E+04, .1053930786133E+04},
 {    6065, .8411861328125E+04, -.1369506347656E+04, .1048639648438E+04},
 {    6066, .8370820312500E+04, -.1401358032227E+04, .1053097412109E+04},
 {    6067, .8380602539062E+04, -.1390641601562E+04, .1048718627930E+04},
 {    6068, .8390545898438E+04, -.1379745483398E+04, .1044266967773E+04},
 {    6069, .8403606445312E+04, -.1365437011719E+04, .1038420898438E+04},
 {    6070, .8374534179688E+04, -.1404717285156E+04, .1051435180664E+04},
 {    6071, .8385062500000E+04, -.1395359741211E+04, .1046722534180E+04},
 {    6072, .8394854492188E+04, -.1384631835938E+04, .1042339111328E+04},
 {    6073, .8406672851562E+04, -.1369506347656E+04, .1037047851562E+04},
 {    6074, .8365631835938E+04, -.1401358032227E+04, .1041506103516E+04},
 {    6075, .8375414062500E+04, -.1390641601562E+04, .1037127929688E+04},
 {    6076, .8385357421875E+04, -.1379745483398E+04, .1032675170898E+04},
 {    6077, .8398416015625E+04, -.1365437011719E+04, .1026828979492E+04},
 {    6078, .8369345703125E+04, -.1404717285156E+04, .1039843139648E+04},
 {    6079, .8379871093750E+04, -.1395359741211E+04, .1035131347656E+04},
 {    6080, .8389663085938E+04, -.1384631958008E+04, .1030748046875E+04},
 {    6081, .8401482421875E+04, -.1369506347656E+04, .1025456542969E+04},
 {    6082, .8364333984375E+04, -.1401358032227E+04, .1038607910156E+04},
 {    6083, .8374114257812E+04, -.1390641601562E+04, .1034229248047E+04},
 {    6084, .8384060546875E+04, -.1379745483398E+04, .1029777954102E+04},
 {    6085, .8397119140625E+04, -.1365437011719E+04, .1023931396484E+04},
 {    6086, .8368048828125E+04, -.1404717285156E+04, .1036945556641E+04},
 {    6087, .8378574218750E+04, -.1395359741211E+04, .1032232910156E+04},
 {    6088, .8388365234375E+04, -.1384631958008E+04, .1027849853516E+04},
 {    6089, .8400184570312E+04, -.1369506347656E+04, .1022558410645E+04},
 {    6090, .8359146484375E+04, -.1401358032227E+04, .1027016357422E+04},
 {    6091, .8368925781250E+04, -.1390641601562E+04, .1022638305664E+04},
 {    6092, .8378872070312E+04, -.1379745483398E+04, .1018186157227E+04},
 {    6093, .8391929687500E+04, -.1365437011719E+04, .1012339599609E+04},
 {    6094, .8362860351562E+04, -.1404717285156E+04, .1025353881836E+04},
 {    6095, .8373385742188E+04, -.1395359741211E+04, .1020641235352E+04},
 {    6096, .8383177734375E+04, -.1384631958008E+04, .1016257934570E+04},
 {    6097, .8394997070312E+04, -.1369506347656E+04, .1010966796875E+04},
 {    6098, .8353957031250E+04, -.1401358032227E+04, .1015425292969E+04},
 {    6099, .8363735351562E+04, -.1390641601562E+04, .1011046630859E+04},
 {    6100, .8373681640625E+04, -.1379745483398E+04, .1006594238281E+04},
 {    6101, .8386742187500E+04, -.1365437011719E+04, .1000747802734E+04},
 {    6102, .8357671875000E+04, -.1404717285156E+04, .1013762207031E+04},
 {    6103, .8368197265625E+04, -.1395359741211E+04, .1009049743652E+04},
 {    6104, .8377989257812E+04, -.1384631958008E+04, .1004666870117E+04},
 {    6105, .8389808593750E+04, -.1369506347656E+04, .9993753662109E+03},
 {    6106, .8352659179688E+04, -.1401358032227E+04, .1012526977539E+04},
 {    6107, .8362438476562E+04, -.1390641601562E+04, .1008148193359E+04},
 {    6108, .8372386718750E+04, -.1379745483398E+04, .1003696166992E+04},
 {    6109, .8385445312500E+04, -.1365437011719E+04, .9978502197266E+03},
 {    6110, .8356373046875E+04, -.1404717285156E+04, .1010864379883E+04},
 {    6111, .8366899414062E+04, -.1395359741211E+04, .1006151855469E+04},
 {    6112, .8376692382812E+04, -.1384631958008E+04, .1001768737793E+04},
 {    6113, .8388509765625E+04, -.1369506347656E+04, .9964776611328E+03},
 {    6114, .8347470703125E+04, -.1401358032227E+04, .1000935791016E+04},
 {    6115, .8357250976562E+04, -.1390641601562E+04, .9965565185547E+03},
 {    6116, .8367198242188E+04, -.1379745483398E+04, .9921044921875E+03},
 {    6117, .8380254882812E+04, -.1365437011719E+04, .9862587890625E+03},
 {    6118, .8351184570312E+04, -.1404717285156E+04, .9992730712891E+03},
 {    6119, .8361709960938E+04, -.1395359741211E+04, .9945605468750E+03},
 {    6120, .8371502929688E+04, -.1384631958008E+04, .9901776123047E+03},
 {    6121, .8383321289062E+04, -.1369506347656E+04, .9848861083984E+03},
 {    6122, .8342281250000E+04, -.1401358032227E+04, .9893442382812E+03},
 {    6123, .8352061523438E+04, -.1390641601562E+04, .9849656982422E+03},
 {    6124, .8362006835938E+04, -.1379745483398E+04, .9805135498047E+03},
 {    6125, .8375066406250E+04, -.1365437011719E+04, .9746672363281E+03},
 {    6126, .8345996093750E+04, -.1404717285156E+04, .9876814575195E+03},
 {    6127, .8356519531250E+04, -.1395359741211E+04, .9829691162109E+03},
 {    6128, .8366313476562E+04, -.1384631958008E+04, .9785855712891E+03},
 {    6129, .8378132812500E+04, -.1369506347656E+04, .9732945556641E+03},
 {    6130, .8340982421875E+04, -.1401358032227E+04, .9864465332031E+03},
 {    6131, .8350763671875E+04, -.1390641601562E+04, .9820677490234E+03},
 {    6132, .8360708984375E+04, -.1379745483398E+04, .9776159057617E+03},
 {    6133, .8373769531250E+04, -.1365437011719E+04, .9717693481445E+03},
 {    6134, .8344697265625E+04, -.1404717285156E+04, .9847835083008E+03},
 {    6135, .8355223632812E+04, -.1395359741211E+04, .9800710449219E+03},
 {    6136, .8365015625000E+04, -.1384631958008E+04, .9756875000000E+03},
 {    6137, .8376834960938E+04, -.1369506347656E+04, .9703967285156E+03},
 {    6138, .8335793945312E+04, -.1401358032227E+04, .9748542480469E+03},
 {    6139, .8345575195312E+04, -.1390641601562E+04, .9704758300781E+03},
 {    6140, .8355520507812E+04, -.1379745483398E+04, .9660242919922E+03},
 {    6141, .8368581054688E+04, -.1365437011719E+04, .9601776123047E+03},
 {    6142, .8339507812500E+04, -.1404717285156E+04, .9731923828125E+03},
 {    6143, .8350035156250E+04, -.1395359741211E+04, .9684794311523E+03},
 {    6144, .8359826171875E+04, -.1384631958008E+04, .9640964355469E+03},
 {    6145, .8371645507812E+04, -.1369506347656E+04, .9588054199219E+03},
 {    6146, .8330605468750E+04, -.1401358032227E+04, .9632632446289E+03},
 {    6147, .8340387695312E+04, -.1390641601562E+04, .9588843383789E+03},
 {    6148, .8350333007812E+04, -.1379745483398E+04, .9544322509766E+03},
 {    6149, .8363390625000E+04, -.1365437011719E+04, .9485863037109E+03},
 {    6150, .8334320312500E+04, -.1404717285156E+04, .9616002197266E+03},
 {    6151, .8344844726562E+04, -.1395359741211E+04, .9568877563477E+03},
 {    6152, .8354637695312E+04, -.1384631958008E+04, .9525048828125E+03},
 {    6153, .8366458007812E+04, -.1369506347656E+04, .9472134399414E+03},
 {    6154, .8329307617188E+04, -.1401358032227E+04, .9603653564453E+03},
 {    6155, .8339087890625E+04, -.1390641601562E+04, .9559864501953E+03},
 {    6156, .8349034179688E+04, -.1379745483398E+04, .9515345458984E+03},
 {    6157, .8362093750000E+04, -.1365437011719E+04, .9456883544922E+03},
 {    6158, .8333022460938E+04, -.1404717285156E+04, .9587027587891E+03},
 {    6159, .8343549804688E+04, -.1395359741211E+04, .9539900512695E+03},
 {    6160, .8353340820312E+04, -.1384631958008E+04, .9496066894531E+03},
 {    6161, .8365160156250E+04, -.1369506347656E+04, .9443159179688E+03},
 {    6162, .8324117187500E+04, -.1401358032227E+04, .9487739868164E+03},
 {    6163, .8333899414062E+04, -.1390641601562E+04, .9443954467773E+03},
 {    6164, .8343845703125E+04, -.1379745605469E+04, .9399429321289E+03},
 {    6165, .8356906250000E+04, -.1365437011719E+04, .9340969238281E+03},
 {    6166, .8327832031250E+04, -.1404717285156E+04, .9471110839844E+03},
 {    6167, .8338360351562E+04, -.1395359741211E+04, .9423988037109E+03},
 {    6168, .8348150390625E+04, -.1384631958008E+04, .9380154418945E+03},
 {    6169, .8359971679688E+04, -.1369506347656E+04, .9327243041992E+03},
 {    6170, .8318929687500E+04, -.1401358032227E+04, .9371823730469E+03},
 {    6171, .8328709960938E+04, -.1390641601562E+04, .9328036499023E+03},
 {    6172, .8338656250000E+04, -.1379745605469E+04, .9283515625000E+03},
 {    6173, .8351715820312E+04, -.1365437011719E+04, .9225053100586E+03},
 {    6174, .8322645507812E+04, -.1404717285156E+04, .9355192871094E+03},
 {    6175, .8333169921875E+04, -.1395359741211E+04, .9308072509766E+03},
 {    6176, .8342962890625E+04, -.1384631958008E+04, .9264238281250E+03},
 {    6177, .8354781250000E+04, -.1369506347656E+04, .9211328735352E+03},
 {    6178, .8316854492188E+04, -.1401358032227E+04, .9325457763672E+03},
 {    6179, .8326634765625E+04, -.1390641601562E+04, .9281667480469E+03},
 {    6180, .8336580078125E+04, -.1379745605469E+04, .9237149047852E+03},
 {    6181, .8349639648438E+04, -.1365437011719E+04, .9178687744141E+03},
 {    6182, .8320570312500E+04, -.1404717285156E+04, .9308826904297E+03},
 {    6183, .8331093750000E+04, -.1395359741211E+04, .9261706542969E+03},
 {    6184, .8340886718750E+04, -.1384631958008E+04, .9217869873047E+03},
 {    6185, .8352706054688E+04, -.1369506347656E+04, .9164960327148E+03},
 {    6186, .8324280273438E+04, -.1408076660156E+04, .9292204589844E+03},
 {    6187, .8335553710938E+04, -.1400077880859E+04, .9241740722656E+03},
 {    6188, .8345192382812E+04, -.1389518310547E+04, .9198593750000E+03},
 {    6189, .8355771484375E+04, -.1373575683594E+04, .9151234130859E+03},
 {    6190, .8259824218750E+04, -.1365437011719E+04, .1122266845703E+04},
 {    6191, .8271407226562E+04, -.1378129150391E+04, .1117081298828E+04},
 {    6192, .8284141601562E+04, -.1392078369141E+04, .1111381469727E+04},
 {    6193, .8292609375000E+04, -.1401358032227E+04, .1107589843750E+04},
 {    6194, .8256755859375E+04, -.1369506347656E+04, .1123639770508E+04},
 {    6195, .8267101562500E+04, -.1383015502930E+04, .1119008911133E+04},
 {    6196, .8279680664062E+04, -.1396796508789E+04, .1113378051758E+04},
 {    6197, .8288894531250E+04, -.1404717285156E+04, .1109252685547E+04},
 {    6198, .8253691406250E+04, -.1373575683594E+04, .1125011962891E+04},
 {    6199, .8262795898438E+04, -.1387901855469E+04, .1120936523438E+04},
 {    6200, .8275220703125E+04, -.1401514648438E+04, .1115374755859E+04},
 {    6201, .8285181640625E+04, -.1408076660156E+04, .1110915771484E+04},
 {    6202, .8257747070312E+04, -.1365437011719E+04, .1117630615234E+04},
 {    6203, .8269332031250E+04, -.1378129150391E+04, .1112445068359E+04},
 {    6204, .8282063476562E+04, -.1392078369141E+04, .1106745361328E+04},
 {    6205, .8290533203125E+04, -.1401358032227E+04, .1102953247070E+04},
 {    6206, .8254681640625E+04, -.1369506347656E+04, .1119002807617E+04},
 {    6207, .8265026367188E+04, -.1383015502930E+04, .1114372558594E+04},
 {    6208, .8277602539062E+04, -.1396796508789E+04, .1108741577148E+04},
 {    6209, .8286819335938E+04, -.1404717285156E+04, .1104615844727E+04},
 {    6210, .8252558593750E+04, -.1365437011719E+04, .1106039184570E+04},
 {    6211, .8264143554688E+04, -.1378129150391E+04, .1100852661133E+04},
 {    6212, .8276875000000E+04, -.1392078369141E+04, .1095153198242E+04},
 {    6213, .8285345703125E+04, -.1401358032227E+04, .1091361694336E+04},
 {    6214, .8249492187500E+04, -.1369506347656E+04, .1107411010742E+04},
 {    6215, .8259836914062E+04, -.1383015502930E+04, .1102780883789E+04},
 {    6216, .8272414062500E+04, -.1396796508789E+04, .1097149780273E+04},
 {    6217, .8281630859375E+04, -.1404717285156E+04, .1093024414062E+04},
 {    6218, .8247369140625E+04, -.1365437011719E+04, .1094447021484E+04},
 {    6219, .8258953125000E+04, -.1378129150391E+04, .1089261840820E+04},
 {    6220, .8271684570312E+04, -.1392078369141E+04, .1083561523438E+04},
 {    6221, .8280155273438E+04, -.1401358032227E+04, .1079770263672E+04},
 {    6222, .8244302734375E+04, -.1369506347656E+04, .1095820068359E+04},
 {    6223, .8254646484375E+04, -.1383015502930E+04, .1091188964844E+04},
 {    6224, .8267224609375E+04, -.1396796508789E+04, .1085559082031E+04},
 {    6225, .8276440429688E+04, -.1404717285156E+04, .1081433471680E+04},
 {    6226, .8246073242188E+04, -.1365437011719E+04, .1091549804688E+04},
 {    6227, .8257654296875E+04, -.1378129150391E+04, .1086363769531E+04},
 {    6228, .8270387695312E+04, -.1392078369141E+04, .1080664306641E+04},
 {    6229, .8278858398438E+04, -.1401358032227E+04, .1076872558594E+04},
 {    6230, .8243006835938E+04, -.1369506347656E+04, .1092921997070E+04},
 {    6231, .8253350585938E+04, -.1383015502930E+04, .1088291259766E+04},
 {    6232, .8265929687500E+04, -.1396796508789E+04, .1082660522461E+04},
 {    6233, .8275143554688E+04, -.1404717285156E+04, .1078535522461E+04},
 {    6234, .8240881835938E+04, -.1365437011719E+04, .1079958007812E+04},
 {    6235, .8252468750000E+04, -.1378129150391E+04, .1074772094727E+04},
 {    6236, .8265198242188E+04, -.1392078369141E+04, .1069072631836E+04},
 {    6237, .8273668945312E+04, -.1401358032227E+04, .1065280883789E+04},
 {    6238, .8237816406250E+04, -.1369506347656E+04, .1081330688477E+04},
 {    6239, .8248161132812E+04, -.1383015502930E+04, .1076699707031E+04},
 {    6240, .8260738281250E+04, -.1396796508789E+04, .1071069458008E+04},
 {    6241, .8269955078125E+04, -.1404717285156E+04, .1066943603516E+04},
 {    6242, .8235694335938E+04, -.1365437011719E+04, .1068366699219E+04},
 {    6243, .8247277343750E+04, -.1378129150391E+04, .1063180419922E+04},
 {    6244, .8260009765625E+04, -.1392078369141E+04, .1057480957031E+04},
 {    6245, .8268481445312E+04, -.1401358032227E+04, .1053689697266E+04},
 {    6246, .8232630859375E+04, -.1369506347656E+04, .1069739013672E+04},
 {    6247, .8242972656250E+04, -.1383015502930E+04, .1065108398438E+04},
 {    6248, .8255550781250E+04, -.1396796508789E+04, .1059477172852E+04},
 {    6249, .8264765625000E+04, -.1404717285156E+04, .1055351928711E+04},
 {    6250, .8234397460938E+04, -.1365437011719E+04, .1065468017578E+04},
 {    6251, .8245982421875E+04, -.1378129150391E+04, .1060282226562E+04},
 {    6252, .8258715820312E+04, -.1392078369141E+04, .1054582763672E+04},
 {    6253, .8267181640625E+04, -.1401358032227E+04, .1050791503906E+04},
 {    6254, .8231331054688E+04, -.1369506347656E+04, .1066841552734E+04},
 {    6255, .8241674804688E+04, -.1383015502930E+04, .1062209960938E+04},
 {    6256, .8254253906250E+04, -.1396796508789E+04, .1056579345703E+04},
 {    6257, .8263467773438E+04, -.1404717285156E+04, .1052454345703E+04},
 {    6258, .8229207031250E+04, -.1365437011719E+04, .1053877197266E+04},
 {    6259, .8240790039062E+04, -.1378129150391E+04, .1048691650391E+04},
 {    6260, .8253524414062E+04, -.1392078369141E+04, .1042991577148E+04},
 {    6261, .8261993164062E+04, -.1401358032227E+04, .1039200195312E+04},
 {    6262, .8226141601562E+04, -.1369506347656E+04, .1055249145508E+04},
 {    6263, .8236485351562E+04, -.1383015502930E+04, .1050618774414E+04},
 {    6264, .8249064453125E+04, -.1396796508789E+04, .1044987915039E+04},
 {    6265, .8258279296875E+04, -.1404717285156E+04, .1040862915039E+04},
 {    6266, .8224018554688E+04, -.1365437011719E+04, .1042285156250E+04},
 {    6267, .8235604492188E+04, -.1378129150391E+04, .1037099365234E+04},
 {    6268, .8248335937500E+04, -.1392078369141E+04, .1031399658203E+04},
 {    6269, .8256803710938E+04, -.1401358032227E+04, .1027608764648E+04},
 {    6270, .8220954101562E+04, -.1369506347656E+04, .1043657470703E+04},
 {    6271, .8231294921875E+04, -.1383015502930E+04, .1039027343750E+04},
 {    6272, .8243876953125E+04, -.1396796508789E+04, .1033396606445E+04},
 {    6273, .8253089843750E+04, -.1404717407227E+04, .1029271362305E+04},
 {    6274, .8222724609375E+04, -.1365437011719E+04, .1039386840820E+04},
 {    6275, .8234306640625E+04, -.1378129150391E+04, .1034201538086E+04},
 {    6276, .8247039062500E+04, -.1392078369141E+04, .1028501953125E+04},
 {    6277, .8255507812500E+04, -.1401358032227E+04, .1024711059570E+04},
 {    6278, .8219654296875E+04, -.1369506347656E+04, .1040760253906E+04},
 {    6279, .8229999023438E+04, -.1383015502930E+04, .1036129638672E+04},
 {    6280, .8242576171875E+04, -.1396796508789E+04, .1030498901367E+04},
 {    6281, .8251792968750E+04, -.1404717407227E+04, .1026373046875E+04},
 {    6282, .8217531250000E+04, -.1365437011719E+04, .1027796142578E+04},
 {    6283, .8229119140625E+04, -.1378129150391E+04, .1022610229492E+04},
 {    6284, .8241848632812E+04, -.1392078369141E+04, .1016910461426E+04},
 {    6285, .8250316406250E+04, -.1401358032227E+04, .1013119323730E+04},
 {    6286, .8214467773438E+04, -.1369506347656E+04, .1029168579102E+04},
 {    6287, .8224809570312E+04, -.1383015502930E+04, .1024538085938E+04},
 {    6288, .8237389648438E+04, -.1396796508789E+04, .1018907348633E+04},
 {    6289, .8246600585938E+04, -.1404717407227E+04, .1014782470703E+04},
 {    6290, .8212344726562E+04, -.1365437011719E+04, .1016204467773E+04},
 {    6291, .8223927734375E+04, -.1378129150391E+04, .1011018676758E+04},
 {    6292, .8236660156250E+04, -.1392078369141E+04, .1005318481445E+04},
 {    6293, .8245130859375E+04, -.1401358032227E+04, .1001527038574E+04},
 {    6294, .8209277343750E+04, -.1369506347656E+04, .1017576904297E+04},
 {    6295, .8219621093750E+04, -.1383015502930E+04, .1012946533203E+04},
 {    6296, .8232198242188E+04, -.1396796508789E+04, .1007316162109E+04},
 {    6297, .8241415039062E+04, -.1404717407227E+04, .1003190063477E+04},
 {    6298, .8211044921875E+04, -.1365437011719E+04, .1013306823730E+04},
 {    6299, .8222627929688E+04, -.1378129150391E+04, .1008120849609E+04},
 {    6300, .8235363281250E+04, -.1392078369141E+04, .1002420471191E+04},
 {    6301, .8243831054688E+04, -.1401358032227E+04, .9986295776367E+03},
 {    6302, .8207980468750E+04, -.1369506347656E+04, .1014679565430E+04},
 {    6303, .8218324218750E+04, -.1383015502930E+04, .1010048034668E+04},
 {    6304, .8230904296875E+04, -.1396796508789E+04, .1004417358398E+04},
 {    6305, .8240119140625E+04, -.1404717407227E+04, .1000292236328E+04},
 {    6306, .8205858398438E+04, -.1365437011719E+04, .1001715087891E+04},
 {    6307, .8217441406250E+04, -.1378129150391E+04, .9965289306641E+03},
 {    6308, .8230173828125E+04, -.1392078369141E+04, .9908295898438E+03},
 {    6309, .8238644531250E+04, -.1401358032227E+04, .9870379028320E+03},
 {    6310, .8202791015625E+04, -.1369506347656E+04, .1003087646484E+04},
 {    6311, .8213133789062E+04, -.1383015502930E+04, .9984571533203E+03},
 {    6312, .8225712890625E+04, -.1396796508789E+04, .9928261108398E+03},
 {    6313, .8234931640625E+04, -.1404717407227E+04, .9887004394531E+03},
 {    6314, .8200668945312E+04, -.1365437011719E+04, .9901234130859E+03},
 {    6315, .8212250976562E+04, -.1378129150391E+04, .9849379272461E+03},
 {    6316, .8224984375000E+04, -.1392078369141E+04, .9792382812500E+03},
 {    6317, .8233452148438E+04, -.1401358032227E+04, .9754467773438E+03},
 {    6318, .8197600585938E+04, -.1369506347656E+04, .9914962158203E+03},
 {    6319, .8207945312500E+04, -.1383015502930E+04, .9868653564453E+03},
 {    6320, .8220524414062E+04, -.1396796508789E+04, .9812348632812E+03},
 {    6321, .8229739257812E+04, -.1404717407227E+04, .9771093750000E+03},
 {    6322, .8198592773438E+04, -.1365437011719E+04, .9854865722656E+03},
 {    6323, .8210175781250E+04, -.1378129150391E+04, .9803011474609E+03},
 {    6324, .8222911132812E+04, -.1392078369141E+04, .9746013183594E+03},
 {    6325, .8231378906250E+04, -.1401358032227E+04, .9708096923828E+03},
 {    6326, .8195523437500E+04, -.1369506347656E+04, .9868599243164E+03},
 {    6327, .8205870117188E+04, -.1383015502930E+04, .9822286987305E+03},
 {    6328, .8218449218750E+04, -.1396796508789E+04, .9765979003906E+03},
 {    6329, .8227663085938E+04, -.1404717407227E+04, .9724725341797E+03},
 {    6330, .8192460937500E+04, -.1373575683594E+04, .9882319335938E+03},
 {    6331, .8201565429688E+04, -.1387901855469E+04, .9841562500000E+03},
 {    6332, .8213990234375E+04, -.1401514648438E+04, .9785944824219E+03},
 {    6333, .8223949218750E+04, -.1408076660156E+04, .9741352539062E+03},
 {    6334, .8292609375000E+04, -.1169826049805E+04, .1107589843750E+04},
 {    6335, .8284302734375E+04, -.1178926025391E+04, .1111308227539E+04},
 {    6336, .8271407226562E+04, -.1193054931641E+04, .1117081298828E+04},
 {    6337, .8259824218750E+04, -.1205747070312E+04, .1122266845703E+04},
 {    6338, .8288894531250E+04, -.1166466796875E+04, .1109252685547E+04},
 {    6339, .8279843750000E+04, -.1174208007812E+04, .1113304687500E+04},
 {    6340, .8267101562500E+04, -.1188168579102E+04, .1119008911133E+04},
 {    6341, .8256755859375E+04, -.1201677734375E+04, .1123639770508E+04},
 {    6342, .8285181640625E+04, -.1163107421875E+04, .1110915527344E+04},
 {    6343, .8275382812500E+04, -.1169489868164E+04, .1115301147461E+04},
 {    6344, .8262795898438E+04, -.1183282226562E+04, .1120936523438E+04},
 {    6345, .8253691406250E+04, -.1197608398438E+04, .1125011962891E+04},
 {    6346, .8290533203125E+04, -.1169826049805E+04, .1102953247070E+04},
 {    6347, .8282228515625E+04, -.1178926025391E+04, .1106671508789E+04},
 {    6348, .8269332031250E+04, -.1193054931641E+04, .1112445068359E+04},
 {    6349, .8257747070312E+04, -.1205747070312E+04, .1117630615234E+04},
 {    6350, .8286819335938E+04, -.1166466796875E+04, .1104615844727E+04},
 {    6351, .8277768554688E+04, -.1174208007812E+04, .1108668212891E+04},
 {    6352, .8265026367188E+04, -.1188168579102E+04, .1114372558594E+04},
 {    6353, .8254681640625E+04, -.1201677734375E+04, .1119002807617E+04},
 {    6354, .8285345703125E+04, -.1169826049805E+04, .1091361694336E+04},
 {    6355, .8277039062500E+04, -.1178926025391E+04, .1095079833984E+04},
 {    6356, .8264143554688E+04, -.1193054931641E+04, .1100852661133E+04},
 {    6357, .8252558593750E+04, -.1205747070312E+04, .1106039184570E+04},
 {    6358, .8281630859375E+04, -.1166466796875E+04, .1093024414062E+04},
 {    6359, .8272578125000E+04, -.1174208007812E+04, .1097076660156E+04},
 {    6360, .8259836914062E+04, -.1188168579102E+04, .1102780883789E+04},
 {    6361, .8249492187500E+04, -.1201677734375E+04, .1107411010742E+04},
 {    6362, .8280155273438E+04, -.1169826049805E+04, .1079770263672E+04},
 {    6363, .8271850585938E+04, -.1178926025391E+04, .1083488525391E+04},
 {    6364, .8258953125000E+04, -.1193054931641E+04, .1089261840820E+04},
 {    6365, .8247369140625E+04, -.1205747070312E+04, .1094447021484E+04},
 {    6366, .8276440429688E+04, -.1166466796875E+04, .1081433471680E+04},
 {    6367, .8267388671875E+04, -.1174208007812E+04, .1085485229492E+04},
 {    6368, .8254646484375E+04, -.1188168579102E+04, .1091188964844E+04},
 {    6369, .8244302734375E+04, -.1201677734375E+04, .1095820068359E+04},
 {    6370, .8278858398438E+04, -.1169826049805E+04, .1076872558594E+04},
 {    6371, .8270551757812E+04, -.1178926025391E+04, .1080590698242E+04},
 {    6372, .8257654296875E+04, -.1193054931641E+04, .1086363769531E+04},
 {    6373, .8246073242188E+04, -.1205747070312E+04, .1091549804688E+04},
 {    6374, .8275143554688E+04, -.1166466796875E+04, .1078535522461E+04},
 {    6375, .8266089843750E+04, -.1174208007812E+04, .1082587646484E+04},
 {    6376, .8253350585938E+04, -.1188168579102E+04, .1088291259766E+04},
 {    6377, .8243006835938E+04, -.1201677734375E+04, .1092921997070E+04},
 {    6378, .8273668945312E+04, -.1169826049805E+04, .1065280883789E+04},
 {    6379, .8265365234375E+04, -.1178926025391E+04, .1068999267578E+04},
 {    6380, .8252468750000E+04, -.1193054931641E+04, .1074772094727E+04},
 {    6381, .8240881835938E+04, -.1205747070312E+04, .1079958007812E+04},
 {    6382, .8269955078125E+04, -.1166466796875E+04, .1066943603516E+04},
 {    6383, .8260902343750E+04, -.1174208007812E+04, .1070995483398E+04},
 {    6384, .8248161132812E+04, -.1188168579102E+04, .1076699707031E+04},
 {    6385, .8237816406250E+04, -.1201677734375E+04, .1081330688477E+04},
 {    6386, .8268481445312E+04, -.1169826049805E+04, .1053689697266E+04},
 {    6387, .8260173828125E+04, -.1178926025391E+04, .1057406982422E+04},
 {    6388, .8247277343750E+04, -.1193054931641E+04, .1063180419922E+04},
 {    6389, .8235694335938E+04, -.1205747070312E+04, .1068366699219E+04},
 {    6390, .8264765625000E+04, -.1166466796875E+04, .1055351928711E+04},
 {    6391, .8255714843750E+04, -.1174208007812E+04, .1059404296875E+04},
 {    6392, .8242972656250E+04, -.1188168579102E+04, .1065108398438E+04},
 {    6393, .8232630859375E+04, -.1201677734375E+04, .1069739013672E+04},
 {    6394, .8267181640625E+04, -.1169826049805E+04, .1050791503906E+04},
 {    6395, .8258877929688E+04, -.1178926025391E+04, .1054509521484E+04},
 {    6396, .8245982421875E+04, -.1193054931641E+04, .1060282226562E+04},
 {    6397, .8234397460938E+04, -.1205747070312E+04, .1065468017578E+04},
 {    6398, .8263467773438E+04, -.1166466796875E+04, .1052454345703E+04},
 {    6399, .8254417968750E+04, -.1174208007812E+04, .1056506103516E+04},
 {    6400, .8241674804688E+04, -.1188168579102E+04, .1062209960938E+04},
 {    6401, .8231331054688E+04, -.1201677734375E+04, .1066841552734E+04},
 {    6402, .8261993164062E+04, -.1169826049805E+04, .1039200195312E+04},
 {    6403, .8253686523438E+04, -.1178926025391E+04, .1042918701172E+04},
 {    6404, .8240790039062E+04, -.1193054931641E+04, .1048691650391E+04},
 {    6405, .8229207031250E+04, -.1205747070312E+04, .1053877197266E+04},
 {    6406, .8258279296875E+04, -.1166466796875E+04, .1040862915039E+04},
 {    6407, .8249225585938E+04, -.1174208007812E+04, .1044915283203E+04},
 {    6408, .8236485351562E+04, -.1188168579102E+04, .1050618774414E+04},
 {    6409, .8226141601562E+04, -.1201677734375E+04, .1055249145508E+04},
 {    6410, .8256803710938E+04, -.1169826049805E+04, .1027608764648E+04},
 {    6411, .8248498046875E+04, -.1178926025391E+04, .1031326782227E+04},
 {    6412, .8235604492188E+04, -.1193054931641E+04, .1037099365234E+04},
 {    6413, .8224018554688E+04, -.1205747070312E+04, .1042285156250E+04},
 {    6414, .8253089843750E+04, -.1166466796875E+04, .1029271362305E+04},
 {    6415, .8244037109375E+04, -.1174208007812E+04, .1033322998047E+04},
 {    6416, .8231294921875E+04, -.1188168579102E+04, .1039027343750E+04},
 {    6417, .8220954101562E+04, -.1201677734375E+04, .1043657470703E+04},
 {    6418, .8255507812500E+04, -.1169826049805E+04, .1024711059570E+04},
 {    6419, .8247202148438E+04, -.1178926025391E+04, .1028429077148E+04},
 {    6420, .8234306640625E+04, -.1193054931641E+04, .1034201538086E+04},
 {    6421, .8222724609375E+04, -.1205747070312E+04, .1039386840820E+04},
 {    6422, .8251792968750E+04, -.1166466796875E+04, .1026373046875E+04},
 {    6423, .8242741210938E+04, -.1174208007812E+04, .1030425170898E+04},
 {    6424, .8229999023438E+04, -.1188168579102E+04, .1036129638672E+04},
 {    6425, .8219654296875E+04, -.1201677734375E+04, .1040760253906E+04},
 {    6426, .8250316406250E+04, -.1169826049805E+04, .1013119323730E+04},
 {    6427, .8242013671875E+04, -.1178926025391E+04, .1016836730957E+04},
 {    6428, .8229119140625E+04, -.1193054931641E+04, .1022610229492E+04},
 {    6429, .8217531250000E+04, -.1205747070312E+04, .1027796142578E+04},
 {    6430, .8246600585938E+04, -.1166466796875E+04, .1014782470703E+04},
 {    6431, .8237552734375E+04, -.1174208007812E+04, .1018833374023E+04},
 {    6432, .8224809570312E+04, -.1188168579102E+04, .1024538085938E+04},
 {    6433, .8214467773438E+04, -.1201677734375E+04, .1029168579102E+04},
 {    6434, .8245130859375E+04, -.1169826049805E+04, .1001527038574E+04},
 {    6435, .8236822265625E+04, -.1178926025391E+04, .1005246093750E+04},
 {    6436, .8223927734375E+04, -.1193054931641E+04, .1011018432617E+04},
 {    6437, .8212344726562E+04, -.1205747070312E+04, .1016204467773E+04},
 {    6438, .8241415039062E+04, -.1166466796875E+04, .1003190063477E+04},
 {    6439, .8232363281250E+04, -.1174208007812E+04, .1007242065430E+04},
 {    6440, .8219621093750E+04, -.1188168579102E+04, .1012946533203E+04},
 {    6441, .8209277343750E+04, -.1201677734375E+04, .1017576904297E+04},
 {    6442, .8243831054688E+04, -.1169826049805E+04, .9986295776367E+03},
 {    6443, .8235526367188E+04, -.1178926025391E+04, .1002347900391E+04},
 {    6444, .8222627929688E+04, -.1193054931641E+04, .1008120849609E+04},
 {    6445, .8211044921875E+04, -.1205747070312E+04, .1013306823730E+04},
 {    6446, .8240119140625E+04, -.1166466796875E+04, .1000292236328E+04},
 {    6447, .8231068359375E+04, -.1174208007812E+04, .1004343811035E+04},
 {    6448, .8218324218750E+04, -.1188168579102E+04, .1010048034668E+04},
 {    6449, .8207980468750E+04, -.1201677734375E+04, .1014679565430E+04},
 {    6450, .8238644531250E+04, -.1169826049805E+04, .9870379028320E+03},
 {    6451, .8230337890625E+04, -.1178926025391E+04, .9907561035156E+03},
 {    6452, .8217441406250E+04, -.1193054931641E+04, .9965289306641E+03},
 {    6453, .8205858398438E+04, -.1205747070312E+04, .1001715087891E+04},
 {    6454, .8234931640625E+04, -.1166466796875E+04, .9887003173828E+03},
 {    6455, .8225876953125E+04, -.1174208007812E+04, .9927526855469E+03},
 {    6456, .8213133789062E+04, -.1188168579102E+04, .9984571533203E+03},
 {    6457, .8202791015625E+04, -.1201677734375E+04, .1003087402344E+04},
 {    6458, .8233452148438E+04, -.1169826049805E+04, .9754467773438E+03},
 {    6459, .8225150390625E+04, -.1178926025391E+04, .9791641845703E+03},
 {    6460, .8212250976562E+04, -.1193054931641E+04, .9849378051758E+03},
 {    6461, .8200668945312E+04, -.1205747070312E+04, .9901234130859E+03},
 {    6462, .8229739257812E+04, -.1166466796875E+04, .9771093750000E+03},
 {    6463, .8220689453125E+04, -.1174208007812E+04, .9811609497070E+03},
 {    6464, .8207945312500E+04, -.1188168579102E+04, .9868653564453E+03},
 {    6465, .8197600585938E+04, -.1201677734375E+04, .9914962158203E+03},
 {    6466, .8231378906250E+04, -.1169826049805E+04, .9708096923828E+03},
 {    6467, .8223073242188E+04, -.1178926025391E+04, .9745277099609E+03},
 {    6468, .8210175781250E+04, -.1193054931641E+04, .9803011474609E+03},
 {    6469, .8198592773438E+04, -.1205747070312E+04, .9854865722656E+03},
 {    6470, .8227663085938E+04, -.1166466796875E+04, .9724725341797E+03},
 {    6471, .8218613281250E+04, -.1174208007812E+04, .9765247192383E+03},
 {    6472, .8205870117188E+04, -.1188168579102E+04, .9822286987305E+03},
 {    6473, .8195523437500E+04, -.1201677734375E+04, .9868599243164E+03},
 {    6474, .8223949218750E+04, -.1163107421875E+04, .9741352539062E+03},
 {    6475, .8214153320312E+04, -.1169489868164E+04, .9785209350586E+03},
 {    6476, .8201565429688E+04, -.1183282226562E+04, .9841562500000E+03},
 {    6477, .8192460937500E+04, -.1197608398438E+04, .9882318115234E+03},
 {    6478, .8235901367188E+04, -.1323692016602E+04, .1127409667969E+04},
 {    6479, .8235901367188E+04, -.1305911987305E+04, .1127409667969E+04},
 {    6480, .8235901367188E+04, -.1288132080078E+04, .1127409667969E+04},
 {    6481, .8230715820312E+04, -.1323692016602E+04, .1115818359375E+04},
 {    6482, .8230715820312E+04, -.1305911987305E+04, .1115818359375E+04},
 {    6483, .8230715820312E+04, -.1288132080078E+04, .1115818359375E+04},
 {    6484, .8225525390625E+04, -.1323692016602E+04, .1104226562500E+04},
 {    6485, .8225525390625E+04, -.1305911987305E+04, .1104226562500E+04},
 {    6486, .8225525390625E+04, -.1288132080078E+04, .1104226562500E+04},
 {    6487, .8224225585938E+04, -.1323692016602E+04, .1101328613281E+04},
 {    6488, .8224225585938E+04, -.1305911987305E+04, .1101328613281E+04},
 {    6489, .8224225585938E+04, -.1288132080078E+04, .1101328613281E+04},
 {    6490, .8219039062500E+04, -.1323692016602E+04, .1089737060547E+04},
 {    6491, .8219039062500E+04, -.1305911987305E+04, .1089737060547E+04},
 {    6492, .8219039062500E+04, -.1288132080078E+04, .1089737060547E+04},
 {    6493, .8213849609375E+04, -.1323692016602E+04, .1078145507812E+04},
 {    6494, .8213849609375E+04, -.1305911987305E+04, .1078145507812E+04},
 {    6495, .8213849609375E+04, -.1288132080078E+04, .1078145507812E+04},
 {    6496, .8212553710938E+04, -.1323692016602E+04, .1075247558594E+04},
 {    6497, .8212553710938E+04, -.1305911987305E+04, .1075247558594E+04},
 {    6498, .8212553710938E+04, -.1288132080078E+04, .1075247558594E+04},
 {    6499, .8207362304688E+04, -.1323692016602E+04, .1063656616211E+04},
 {    6500, .8207362304688E+04, -.1305911987305E+04, .1063656616211E+04},
 {    6501, .8207362304688E+04, -.1288132080078E+04, .1063656616211E+04},
 {    6502, .8202173828125E+04, -.1323692016602E+04, .1052065063477E+04},
 {    6503, .8202173828125E+04, -.1305911987305E+04, .1052065063477E+04},
 {    6504, .8202173828125E+04, -.1288132080078E+04, .1052065063477E+04},
 {    6505, .8200876953125E+04, -.1323692016602E+04, .1049166992188E+04},
 {    6506, .8200876953125E+04, -.1305911987305E+04, .1049166992188E+04},
 {    6507, .8200876953125E+04, -.1288132080078E+04, .1049166992188E+04},
 {    6508, .8195686523438E+04, -.1323692016602E+04, .1037575439453E+04},
 {    6509, .8195686523438E+04, -.1305912109375E+04, .1037575439453E+04},
 {    6510, .8195686523438E+04, -.1288132080078E+04, .1037575439453E+04},
 {    6511, .8190498535156E+04, -.1323692016602E+04, .1025983886719E+04},
 {    6512, .8190498535156E+04, -.1305912109375E+04, .1025983886719E+04},
 {    6513, .8190498535156E+04, -.1288132080078E+04, .1025983886719E+04},
 {    6514, .8189201660156E+04, -.1323692016602E+04, .1023085693359E+04},
 {    6515, .8189201660156E+04, -.1305912109375E+04, .1023085693359E+04},
 {    6516, .8189201660156E+04, -.1288132080078E+04, .1023085693359E+04},
 {    6517, .8184013183594E+04, -.1323692016602E+04, .1011494079590E+04},
 {    6518, .8184013183594E+04, -.1305912109375E+04, .1011494079590E+04},
 {    6519, .8184013183594E+04, -.1288132080078E+04, .1011494079590E+04},
 {    6520, .8178822265625E+04, -.1323692016602E+04, .9999027709961E+03},
 {    6521, .8178822265625E+04, -.1305912109375E+04, .9999027709961E+03},
 {    6522, .8178822265625E+04, -.1288132080078E+04, .9999027709961E+03},
 {    6523, .8235901367188E+04, -.1283052001953E+04, .1127409667969E+04},
 {    6524, .8230715820312E+04, -.1283052001953E+04, .1115818359375E+04},
 {    6525, .8225525390625E+04, -.1283052001953E+04, .1104226562500E+04},
 {    6526, .8224225585938E+04, -.1283052001953E+04, .1101328613281E+04},
 {    6527, .8219039062500E+04, -.1283052001953E+04, .1089737060547E+04},
 {    6528, .8213849609375E+04, -.1283052001953E+04, .1078145507812E+04},
 {    6529, .8212553710938E+04, -.1283052001953E+04, .1075247558594E+04},
 {    6530, .8207362304688E+04, -.1283052001953E+04, .1063656616211E+04},
 {    6531, .8202173828125E+04, -.1283052001953E+04, .1052065063477E+04},
 {    6532, .8200876953125E+04, -.1283052001953E+04, .1049166992188E+04},
 {    6533, .8195686523438E+04, -.1283052001953E+04, .1037575439453E+04},
 {    6534, .8190498535156E+04, -.1283052001953E+04, .1025983886719E+04},
 {    6535, .8189201660156E+04, -.1283052001953E+04, .1023085693359E+04},
 {    6536, .8184013183594E+04, -.1283052001953E+04, .1011494079590E+04},
 {    6537, .8178822265625E+04, -.1283052001953E+04, .9999027709961E+03},
 {    6538, .8235901367188E+04, -.1265272094727E+04, .1127409667969E+04},
 {    6539, .8235901367188E+04, -.1247492065430E+04, .1127409667969E+04},
 {    6540, .8230715820312E+04, -.1265272094727E+04, .1115818359375E+04},
 {    6541, .8230715820312E+04, -.1247492065430E+04, .1115818359375E+04},
 {    6542, .8225525390625E+04, -.1265272094727E+04, .1104226562500E+04},
 {    6543, .8225525390625E+04, -.1247492065430E+04, .1104226562500E+04},
 {    6544, .8224225585938E+04, -.1265272094727E+04, .1101328613281E+04},
 {    6545, .8224225585938E+04, -.1247492065430E+04, .1101328613281E+04},
 {    6546, .8219039062500E+04, -.1265272094727E+04, .1089737060547E+04},
 {    6547, .8219039062500E+04, -.1247492065430E+04, .1089737060547E+04},
 {    6548, .8213849609375E+04, -.1265272094727E+04, .1078145507812E+04},
 {    6549, .8213849609375E+04, -.1247492065430E+04, .1078145507812E+04},
 {    6550, .8212553710938E+04, -.1265272094727E+04, .1075247558594E+04},
 {    6551, .8212553710938E+04, -.1247492065430E+04, .1075247558594E+04},
 {    6552, .8207362304688E+04, -.1265272094727E+04, .1063656616211E+04},
 {    6553, .8207362304688E+04, -.1247492065430E+04, .1063656616211E+04},
 {    6554, .8202173828125E+04, -.1265272094727E+04, .1052065063477E+04},
 {    6555, .8202173828125E+04, -.1247492065430E+04, .1052065063477E+04},
 {    6556, .8200876953125E+04, -.1265272094727E+04, .1049166992188E+04},
 {    6557, .8200876953125E+04, -.1247492065430E+04, .1049166992188E+04},
 {    6558, .8195686523438E+04, -.1265272094727E+04, .1037575439453E+04},
 {    6559, .8195686523438E+04, -.1247492065430E+04, .1037575439453E+04},
 {    6560, .8190498535156E+04, -.1265272094727E+04, .1025983886719E+04},
 {    6561, .8190498535156E+04, -.1247492065430E+04, .1025983886719E+04},
 {    6562, .8189201660156E+04, -.1265272094727E+04, .1023085693359E+04},
 {    6563, .8189201660156E+04, -.1247492065430E+04, .1023085693359E+04},
 {    6564, .8184013183594E+04, -.1265272094727E+04, .1011494079590E+04},
 {    6565, .8184013183594E+04, -.1247492065430E+04, .1011494079590E+04},
 {    6566, .8178822265625E+04, -.1265272094727E+04, .9999027709961E+03},
 {    6567, .8178822265625E+04, -.1247492065430E+04, .9999027709961E+03},
 {    6568, .8254424804688E+04, -.1336392089844E+04, .1133033447266E+04},
 {    6569, .8260219726562E+04, -.1336392089844E+04, .1130439453125E+04},
 {    6570, .8254424804688E+04, -.1323692016602E+04, .1133033447266E+04},
 {    6571, .8260219726562E+04, -.1323692016602E+04, .1130439453125E+04},
 {    6572, .8249233398438E+04, -.1336392089844E+04, .1121441894531E+04},
 {    6573, .8255029296875E+04, -.1336392089844E+04, .1118847412109E+04},
 {    6574, .8249233398438E+04, -.1323692016602E+04, .1121441894531E+04},
 {    6575, .8255029296875E+04, -.1323692016602E+04, .1118847412109E+04},
 {    6576, .8244044921875E+04, -.1336392089844E+04, .1109850585938E+04},
 {    6577, .8249837890625E+04, -.1336392089844E+04, .1107256591797E+04},
 {    6578, .8244044921875E+04, -.1323692016602E+04, .1109850585938E+04},
 {    6579, .8249837890625E+04, -.1323692016602E+04, .1107256591797E+04},
 {    6580, .8238854492188E+04, -.1336392089844E+04, .1098259033203E+04},
 {    6581, .8244649414062E+04, -.1336392089844E+04, .1095664794922E+04},
 {    6582, .8238854492188E+04, -.1323692016602E+04, .1098259033203E+04},
 {    6583, .8244649414062E+04, -.1323692016602E+04, .1095664794922E+04},
 {    6584, .8237558593750E+04, -.1336392089844E+04, .1095361206055E+04},
 {    6585, .8243356445312E+04, -.1336392089844E+04, .1092766601562E+04},
 {    6586, .8237558593750E+04, -.1323692016602E+04, .1095361206055E+04},
 {    6587, .8243356445312E+04, -.1323692016602E+04, .1092766601562E+04},
 {    6588, .8232369140625E+04, -.1336392089844E+04, .1083769287109E+04},
 {    6589, .8238166015625E+04, -.1336392089844E+04, .1081174926758E+04},
 {    6590, .8232369140625E+04, -.1323692016602E+04, .1083769287109E+04},
 {    6591, .8238166015625E+04, -.1323692016602E+04, .1081174926758E+04},
 {    6592, .8227179687500E+04, -.1336392089844E+04, .1072178100586E+04},
 {    6593, .8232976562500E+04, -.1336392089844E+04, .1069583129883E+04},
 {    6594, .8227179687500E+04, -.1323692016602E+04, .1072178100586E+04},
 {    6595, .8232976562500E+04, -.1323692016602E+04, .1069583129883E+04},
 {    6596, .8225882812500E+04, -.1336392089844E+04, .1069280273438E+04},
 {    6597, .8231680664062E+04, -.1336392089844E+04, .1066685424805E+04},
 {    6598, .8225882812500E+04, -.1323692016602E+04, .1069280273438E+04},
 {    6599, .8231680664062E+04, -.1323692016602E+04, .1066685424805E+04},
 {    6600, .8220692382812E+04, -.1336392089844E+04, .1057688842773E+04},
 {    6601, .8226489257812E+04, -.1336392089844E+04, .1055094482422E+04},
 {    6602, .8220692382812E+04, -.1323692016602E+04, .1057688842773E+04},
 {    6603, .8226489257812E+04, -.1323692016602E+04, .1055094482422E+04},
 {    6604, .8215502929688E+04, -.1336392089844E+04, .1046097167969E+04},
 {    6605, .8221301757812E+04, -.1336392089844E+04, .1043502807617E+04},
 {    6606, .8215502929688E+04, -.1323692016602E+04, .1046097167969E+04},
 {    6607, .8221301757812E+04, -.1323692016602E+04, .1043502807617E+04},
 {    6608, .8214208007812E+04, -.1336392089844E+04, .1043198730469E+04},
 {    6609, .8220001953125E+04, -.1336392089844E+04, .1040605102539E+04},
 {    6610, .8214208007812E+04, -.1323692016602E+04, .1043198730469E+04},
 {    6611, .8220001953125E+04, -.1323692016602E+04, .1040605102539E+04},
 {    6612, .8209017578125E+04, -.1336392089844E+04, .1031608154297E+04},
 {    6613, .8214813476562E+04, -.1336392089844E+04, .1029013183594E+04},
 {    6614, .8209017578125E+04, -.1323692016602E+04, .1031608154297E+04},
 {    6615, .8214813476562E+04, -.1323692016602E+04, .1029013183594E+04},
 {    6616, .8203829101562E+04, -.1336392089844E+04, .1020016174316E+04},
 {    6617, .8209624023438E+04, -.1336392089844E+04, .1017422119141E+04},
 {    6618, .8203829101562E+04, -.1323692016602E+04, .1020016174316E+04},
 {    6619, .8209624023438E+04, -.1323692016602E+04, .1017422119141E+04},
 {    6620, .8202531250000E+04, -.1336392089844E+04, .1017118347168E+04},
 {    6621, .8208327148438E+04, -.1336392089844E+04, .1014523742676E+04},
 {    6622, .8202531250000E+04, -.1323692016602E+04, .1017118347168E+04},
 {    6623, .8208327148438E+04, -.1323692016602E+04, .1014523742676E+04},
 {    6624, .8197340820312E+04, -.1336392089844E+04, .1005527099609E+04},
 {    6625, .8203137695312E+04, -.1336392089844E+04, .1002932495117E+04},
 {    6626, .8197340820312E+04, -.1323692016602E+04, .1005527099609E+04},
 {    6627, .8203137695312E+04, -.1323692016602E+04, .1002932495117E+04},
 {    6628, .8192153320312E+04, -.1336392089844E+04, .9939351806641E+03},
 {    6629, .8197948242188E+04, -.1336392089844E+04, .9913408813477E+03},
 {    6630, .8192153320312E+04, -.1323692016602E+04, .9939351806641E+03},
 {    6631, .8197948242188E+04, -.1323692016602E+04, .9913408813477E+03},
 {    6632, .8186963867188E+04, -.1336392089844E+04, .9823437500000E+03},
 {    6633, .8192758789062E+04, -.1336392089844E+04, .9797492065430E+03},
 {    6634, .8186963867188E+04, -.1323692016602E+04, .9823437500000E+03},
 {    6635, .8192758789062E+04, -.1323692016602E+04, .9797492065430E+03},
 {    6636, .8254424804688E+04, -.1305911987305E+04, .1133033447266E+04},
 {    6637, .8260219726562E+04, -.1305911987305E+04, .1130439453125E+04},
 {    6638, .8254424804688E+04, -.1288132080078E+04, .1133033447266E+04},
 {    6639, .8260219726562E+04, -.1288132080078E+04, .1130439453125E+04},
 {    6640, .8249233398438E+04, -.1305911987305E+04, .1121441894531E+04},
 {    6641, .8255029296875E+04, -.1305911987305E+04, .1118847412109E+04},
 {    6642, .8249233398438E+04, -.1288132080078E+04, .1121441894531E+04},
 {    6643, .8255029296875E+04, -.1288132080078E+04, .1118847412109E+04},
 {    6644, .8244044921875E+04, -.1305911987305E+04, .1109850585938E+04},
 {    6645, .8249837890625E+04, -.1305911987305E+04, .1107256591797E+04},
 {    6646, .8244044921875E+04, -.1288132080078E+04, .1109850585938E+04},
 {    6647, .8249837890625E+04, -.1288132080078E+04, .1107256591797E+04},
 {    6648, .8238854492188E+04, -.1305911987305E+04, .1098259033203E+04},
 {    6649, .8244649414062E+04, -.1305911987305E+04, .1095664794922E+04},
 {    6650, .8238854492188E+04, -.1288132080078E+04, .1098259033203E+04},
 {    6651, .8244649414062E+04, -.1288132080078E+04, .1095664794922E+04},
 {    6652, .8237558593750E+04, -.1305911987305E+04, .1095361206055E+04},
 {    6653, .8243356445312E+04, -.1305911987305E+04, .1092766601562E+04},
 {    6654, .8237558593750E+04, -.1288132080078E+04, .1095361206055E+04},
 {    6655, .8243356445312E+04, -.1288132080078E+04, .1092766601562E+04},
 {    6656, .8232369140625E+04, -.1305911987305E+04, .1083769287109E+04},
 {    6657, .8238166015625E+04, -.1305911987305E+04, .1081174926758E+04},
 {    6658, .8232369140625E+04, -.1288132080078E+04, .1083769287109E+04},
 {    6659, .8238166015625E+04, -.1288132080078E+04, .1081174926758E+04},
 {    6660, .8227179687500E+04, -.1305911987305E+04, .1072178100586E+04},
 {    6661, .8232976562500E+04, -.1305911987305E+04, .1069583129883E+04},
 {    6662, .8227179687500E+04, -.1288132080078E+04, .1072178100586E+04},
 {    6663, .8232976562500E+04, -.1288132080078E+04, .1069583129883E+04},
 {    6664, .8225882812500E+04, -.1305911987305E+04, .1069280273438E+04},
 {    6665, .8231680664062E+04, -.1305911987305E+04, .1066685424805E+04},
 {    6666, .8225882812500E+04, -.1288132080078E+04, .1069280273438E+04},
 {    6667, .8231680664062E+04, -.1288132080078E+04, .1066685424805E+04},
 {    6668, .8220692382812E+04, -.1305911987305E+04, .1057688842773E+04},
 {    6669, .8226489257812E+04, -.1305911987305E+04, .1055094482422E+04},
 {    6670, .8220692382812E+04, -.1288132080078E+04, .1057688842773E+04},
 {    6671, .8226489257812E+04, -.1288132080078E+04, .1055094482422E+04},
 {    6672, .8215502929688E+04, -.1305911987305E+04, .1046097167969E+04},
 {    6673, .8221301757812E+04, -.1305911987305E+04, .1043502807617E+04},
 {    6674, .8215502929688E+04, -.1288132080078E+04, .1046097167969E+04},
 {    6675, .8221301757812E+04, -.1288132080078E+04, .1043502807617E+04},
 {    6676, .8214208007812E+04, -.1305911987305E+04, .1043198730469E+04},
 {    6677, .8220001953125E+04, -.1305911987305E+04, .1040605102539E+04},
 {    6678, .8214208007812E+04, -.1288132080078E+04, .1043198730469E+04},
 {    6679, .8220001953125E+04, -.1288132080078E+04, .1040605102539E+04},
 {    6680, .8209017578125E+04, -.1305912109375E+04, .1031608154297E+04},
 {    6681, .8214813476562E+04, -.1305912109375E+04, .1029013183594E+04},
 {    6682, .8209017578125E+04, -.1288132080078E+04, .1031608154297E+04},
 {    6683, .8214813476562E+04, -.1288132080078E+04, .1029013183594E+04},
 {    6684, .8203829101562E+04, -.1305912109375E+04, .1020016174316E+04},
 {    6685, .8209624023438E+04, -.1305912109375E+04, .1017422119141E+04},
 {    6686, .8203829101562E+04, -.1288132080078E+04, .1020016174316E+04},
 {    6687, .8209624023438E+04, -.1288132080078E+04, .1017422119141E+04},
 {    6688, .8202531250000E+04, -.1305912109375E+04, .1017118347168E+04},
 {    6689, .8208327148438E+04, -.1305912109375E+04, .1014523742676E+04},
 {    6690, .8202531250000E+04, -.1288132080078E+04, .1017118347168E+04},
 {    6691, .8208327148438E+04, -.1288132080078E+04, .1014523742676E+04},
 {    6692, .8197340820312E+04, -.1305912109375E+04, .1005527099609E+04},
 {    6693, .8203137695312E+04, -.1305912109375E+04, .1002932495117E+04},
 {    6694, .8197340820312E+04, -.1288132080078E+04, .1005527099609E+04},
 {    6695, .8203137695312E+04, -.1288132080078E+04, .1002932495117E+04},
 {    6696, .8192153320312E+04, -.1305912109375E+04, .9939351806641E+03},
 {    6697, .8197948242188E+04, -.1305912109375E+04, .9913408813477E+03},
 {    6698, .8192153320312E+04, -.1288132080078E+04, .9939351806641E+03},
 {    6699, .8197948242188E+04, -.1288132080078E+04, .9913408813477E+03},
 {    6700, .8186963867188E+04, -.1305912109375E+04, .9823437500000E+03},
 {    6701, .8192758789062E+04, -.1305912109375E+04, .9797492065430E+03},
 {    6702, .8186963867188E+04, -.1288132080078E+04, .9823437500000E+03},
 {    6703, .8192758789062E+04, -.1288132080078E+04, .9797492065430E+03},
 {    6704, .8254424804688E+04, -.1283052001953E+04, .1133033447266E+04},
 {    6705, .8260219726562E+04, -.1283052001953E+04, .1130439453125E+04},
 {    6706, .8249233398438E+04, -.1283052001953E+04, .1121441894531E+04},
 {    6707, .8255029296875E+04, -.1283052001953E+04, .1118847412109E+04},
 {    6708, .8244044921875E+04, -.1283052001953E+04, .1109850585938E+04},
 {    6709, .8249837890625E+04, -.1283052001953E+04, .1107256591797E+04},
 {    6710, .8238854492188E+04, -.1283052001953E+04, .1098259033203E+04},
 {    6711, .8244649414062E+04, -.1283052001953E+04, .1095664794922E+04},
 {    6712, .8237558593750E+04, -.1283052001953E+04, .1095361206055E+04},
 {    6713, .8243356445312E+04, -.1283052001953E+04, .1092766601562E+04},
 {    6714, .8232369140625E+04, -.1283052001953E+04, .1083769287109E+04},
 {    6715, .8238166015625E+04, -.1283052001953E+04, .1081174926758E+04},
 {    6716, .8227179687500E+04, -.1283052001953E+04, .1072178100586E+04},
 {    6717, .8232976562500E+04, -.1283052001953E+04, .1069583129883E+04},
 {    6718, .8225882812500E+04, -.1283052001953E+04, .1069280273438E+04},
 {    6719, .8231680664062E+04, -.1283052001953E+04, .1066685424805E+04},
 {    6720, .8220692382812E+04, -.1283052001953E+04, .1057688842773E+04},
 {    6721, .8226489257812E+04, -.1283052001953E+04, .1055094482422E+04},
 {    6722, .8215502929688E+04, -.1283052001953E+04, .1046097167969E+04},
 {    6723, .8221301757812E+04, -.1283052001953E+04, .1043502807617E+04},
 {    6724, .8214208007812E+04, -.1283052001953E+04, .1043198730469E+04},
 {    6725, .8220001953125E+04, -.1283052001953E+04, .1040605102539E+04},
 {    6726, .8209017578125E+04, -.1283052001953E+04, .1031608154297E+04},
 {    6727, .8214813476562E+04, -.1283052001953E+04, .1029013183594E+04},
 {    6728, .8203829101562E+04, -.1283052001953E+04, .1020016174316E+04},
 {    6729, .8209624023438E+04, -.1283052001953E+04, .1017422119141E+04},
 {    6730, .8202531250000E+04, -.1283052001953E+04, .1017118347168E+04},
 {    6731, .8208327148438E+04, -.1283052001953E+04, .1014523742676E+04},
 {    6732, .8197340820312E+04, -.1283052001953E+04, .1005527099609E+04},
 {    6733, .8203137695312E+04, -.1283052001953E+04, .1002932495117E+04},
 {    6734, .8192154296875E+04, -.1283052001953E+04, .9939351196289E+03},
 {    6735, .8197948242188E+04, -.1283052001953E+04, .9913408813477E+03},
 {    6736, .8186963867188E+04, -.1283052001953E+04, .9823437500000E+03},
 {    6737, .8192758789062E+04, -.1283052001953E+04, .9797492065430E+03},
 {    6738, .8254424804688E+04, -.1265272094727E+04, .1133033447266E+04},
 {    6739, .8260219726562E+04, -.1265272094727E+04, .1130439453125E+04},
 {    6740, .8254424804688E+04, -.1247492065430E+04, .1133033447266E+04},
 {    6741, .8260219726562E+04, -.1247492065430E+04, .1130439453125E+04},
 {    6742, .8249233398438E+04, -.1265272094727E+04, .1121441894531E+04},
 {    6743, .8255029296875E+04, -.1265272094727E+04, .1118847412109E+04},
 {    6744, .8249233398438E+04, -.1247492065430E+04, .1121441894531E+04},
 {    6745, .8255029296875E+04, -.1247492065430E+04, .1118847412109E+04},
 {    6746, .8244044921875E+04, -.1265272094727E+04, .1109850585938E+04},
 {    6747, .8249837890625E+04, -.1265272094727E+04, .1107256591797E+04},
 {    6748, .8244044921875E+04, -.1247492065430E+04, .1109850585938E+04},
 {    6749, .8249837890625E+04, -.1247492065430E+04, .1107256591797E+04},
 {    6750, .8238854492188E+04, -.1265272094727E+04, .1098259033203E+04},
 {    6751, .8244649414062E+04, -.1265272094727E+04, .1095664794922E+04},
 {    6752, .8238854492188E+04, -.1247492065430E+04, .1098259033203E+04},
 {    6753, .8244649414062E+04, -.1247492065430E+04, .1095664794922E+04},
 {    6754, .8237558593750E+04, -.1265272094727E+04, .1095361206055E+04},
 {    6755, .8243356445312E+04, -.1265272094727E+04, .1092766601562E+04},
 {    6756, .8237558593750E+04, -.1247492065430E+04, .1095361206055E+04},
 {    6757, .8243356445312E+04, -.1247492065430E+04, .1092766601562E+04},
 {    6758, .8232369140625E+04, -.1265272094727E+04, .1083769287109E+04},
 {    6759, .8238166015625E+04, -.1265272094727E+04, .1081174926758E+04},
 {    6760, .8232369140625E+04, -.1247492065430E+04, .1083769287109E+04},
 {    6761, .8238166015625E+04, -.1247492065430E+04, .1081174926758E+04},
 {    6762, .8227179687500E+04, -.1265272094727E+04, .1072178100586E+04},
 {    6763, .8232976562500E+04, -.1265272094727E+04, .1069583129883E+04},
 {    6764, .8227179687500E+04, -.1247492065430E+04, .1072178100586E+04},
 {    6765, .8232976562500E+04, -.1247492065430E+04, .1069583129883E+04},
 {    6766, .8225882812500E+04, -.1265272094727E+04, .1069280273438E+04},
 {    6767, .8231680664062E+04, -.1265272094727E+04, .1066685424805E+04},
 {    6768, .8225882812500E+04, -.1247492065430E+04, .1069280273438E+04},
 {    6769, .8231680664062E+04, -.1247492065430E+04, .1066685424805E+04},
 {    6770, .8220692382812E+04, -.1265272094727E+04, .1057688842773E+04},
 {    6771, .8226489257812E+04, -.1265272094727E+04, .1055094482422E+04},
 {    6772, .8220692382812E+04, -.1247492065430E+04, .1057688842773E+04},
 {    6773, .8226489257812E+04, -.1247492065430E+04, .1055094482422E+04},
 {    6774, .8215502929688E+04, -.1265272094727E+04, .1046097167969E+04},
 {    6775, .8221301757812E+04, -.1265272094727E+04, .1043502807617E+04},
 {    6776, .8215502929688E+04, -.1247492065430E+04, .1046097167969E+04},
 {    6777, .8221301757812E+04, -.1247492065430E+04, .1043502807617E+04},
 {    6778, .8214208007812E+04, -.1265272094727E+04, .1043198730469E+04},
 {    6779, .8220001953125E+04, -.1265272094727E+04, .1040605102539E+04},
 {    6780, .8214208007812E+04, -.1247492065430E+04, .1043198730469E+04},
 {    6781, .8220001953125E+04, -.1247492065430E+04, .1040605102539E+04},
 {    6782, .8209017578125E+04, -.1265272094727E+04, .1031608154297E+04},
 {    6783, .8214813476562E+04, -.1265272094727E+04, .1029013183594E+04},
 {    6784, .8209017578125E+04, -.1247492065430E+04, .1031608154297E+04},
 {    6785, .8214813476562E+04, -.1247492065430E+04, .1029013183594E+04},
 {    6786, .8203829101562E+04, -.1265272094727E+04, .1020016174316E+04},
 {    6787, .8209624023438E+04, -.1265272094727E+04, .1017422119141E+04},
 {    6788, .8203829101562E+04, -.1247492065430E+04, .1020016174316E+04},
 {    6789, .8209624023438E+04, -.1247492065430E+04, .1017422119141E+04},
 {    6790, .8202531250000E+04, -.1265272094727E+04, .1017118347168E+04},
 {    6791, .8208327148438E+04, -.1265272094727E+04, .1014523742676E+04},
 {    6792, .8202531250000E+04, -.1247492065430E+04, .1017118347168E+04},
 {    6793, .8208327148438E+04, -.1247492065430E+04, .1014523742676E+04},
 {    6794, .8197340820312E+04, -.1265272094727E+04, .1005527099609E+04},
 {    6795, .8203137695312E+04, -.1265272094727E+04, .1002932495117E+04},
 {    6796, .8197340820312E+04, -.1247492065430E+04, .1005527099609E+04},
 {    6797, .8203137695312E+04, -.1247492065430E+04, .1002932495117E+04},
 {    6798, .8192154296875E+04, -.1265272094727E+04, .9939351196289E+03},
 {    6799, .8197948242188E+04, -.1265272094727E+04, .9913408813477E+03},
 {    6800, .8192154296875E+04, -.1247492065430E+04, .9939351196289E+03},
 {    6801, .8197948242188E+04, -.1247492065430E+04, .9913408813477E+03},
 {    6802, .8186963867188E+04, -.1265272094727E+04, .9823437500000E+03},
 {    6803, .8192758789062E+04, -.1265272094727E+04, .9797492065430E+03},
 {    6804, .8186963867188E+04, -.1247492065430E+04, .9823437500000E+03},
 {    6805, .8192758789062E+04, -.1247492065430E+04, .9797492065430E+03},
 {    6806, .8254424804688E+04, -.1234791992188E+04, .1133033447266E+04},
 {    6807, .8260219726562E+04, -.1234791992188E+04, .1130439453125E+04},
 {    6808, .8249233398438E+04, -.1234791992188E+04, .1121441894531E+04},
 {    6809, .8255029296875E+04, -.1234791992188E+04, .1118847412109E+04},
 {    6810, .8244044921875E+04, -.1234791992188E+04, .1109850585938E+04},
 {    6811, .8249837890625E+04, -.1234791992188E+04, .1107256591797E+04},
 {    6812, .8238854492188E+04, -.1234791992188E+04, .1098259033203E+04},
 {    6813, .8244649414062E+04, -.1234791992188E+04, .1095664794922E+04},
 {    6814, .8237558593750E+04, -.1234791992188E+04, .1095361206055E+04},
 {    6815, .8243356445312E+04, -.1234791992188E+04, .1092766601562E+04},
 {    6816, .8232369140625E+04, -.1234791992188E+04, .1083769287109E+04},
 {    6817, .8238166015625E+04, -.1234791992188E+04, .1081174926758E+04},
 {    6818, .8227179687500E+04, -.1234791992188E+04, .1072178100586E+04},
 {    6819, .8232976562500E+04, -.1234791992188E+04, .1069583129883E+04},
 {    6820, .8225882812500E+04, -.1234791992188E+04, .1069280273438E+04},
 {    6821, .8231680664062E+04, -.1234791992188E+04, .1066685424805E+04},
 {    6822, .8220692382812E+04, -.1234791992188E+04, .1057688842773E+04},
 {    6823, .8226489257812E+04, -.1234791992188E+04, .1055094482422E+04},
 {    6824, .8215502929688E+04, -.1234791992188E+04, .1046097167969E+04},
 {    6825, .8221301757812E+04, -.1234791992188E+04, .1043502807617E+04},
 {    6826, .8214208007812E+04, -.1234791992188E+04, .1043198730469E+04},
 {    6827, .8220001953125E+04, -.1234791992188E+04, .1040605102539E+04},
 {    6828, .8209017578125E+04, -.1234791992188E+04, .1031608154297E+04},
 {    6829, .8214813476562E+04, -.1234791992188E+04, .1029013183594E+04},
 {    6830, .8203829101562E+04, -.1234791992188E+04, .1020016174316E+04},
 {    6831, .8209624023438E+04, -.1234791992188E+04, .1017422119141E+04},
 {    6832, .8202531250000E+04, -.1234791992188E+04, .1017118347168E+04},
 {    6833, .8208327148438E+04, -.1234791992188E+04, .1014523742676E+04},
 {    6834, .8197340820312E+04, -.1234791992188E+04, .1005527099609E+04},
 {    6835, .8203137695312E+04, -.1234791992188E+04, .1002932495117E+04},
 {    6836, .8192154296875E+04, -.1234791992188E+04, .9939351196289E+03},
 {    6837, .8197948242188E+04, -.1234791992188E+04, .9913408813477E+03},
 {    6838, .8186963867188E+04, -.1234791992188E+04, .9823437500000E+03},
 {    6839, .8192758789062E+04, -.1234791992188E+04, .9797492065430E+03},
 {    6840, .8426041015625E+04, -.1341724365234E+04, .1371152099609E+04},
 {    6841, .8422049804688E+04, -.1335270507812E+04, .1371400634766E+04},
 {    6842, .8443809570312E+04, -.1327334960938E+04, .1370047119141E+04},
 {    6843, .8437889648438E+04, -.1322570922852E+04, .1370415283203E+04},
 {    6844, .8456097656250E+04, -.1308037963867E+04, .1369283203125E+04},
 {    6845, .8448925781250E+04, -.1305512084961E+04, .1369728515625E+04},
 {    6846, .8460579101562E+04, -.1285592041016E+04, .1369003662109E+04},
 {    6847, .8452972656250E+04, -.1285592041016E+04, .1369477539062E+04},
 {    6848, .8426290039062E+04, -.1340045410156E+04, .1386405517578E+04},
 {    6849, .8422206054688E+04, -.1333810668945E+04, .1384918212891E+04},
 {    6850, .8442291015625E+04, -.1325939086914E+04, .1389075317383E+04},
 {    6851, .8436479492188E+04, -.1321361083984E+04, .1387301025391E+04},
 {    6852, .8453527343750E+04, -.1307054443359E+04, .1390946777344E+04},
 {    6853, .8446577148438E+04, -.1304648437500E+04, .1388968017578E+04},
 {    6854, .8457492187500E+04, -.1285592041016E+04, .1391684814453E+04},
 {    6855, .8450163085938E+04, -.1285592041016E+04, .1389610351562E+04},
 {    6856, .8424702148438E+04, -.1335365112305E+04, .1400936523438E+04},
 {    6857, .8420763671875E+04, -.1329675048828E+04, .1397789794922E+04},
 {    6858, .8435911132812E+04, -.1321664306641E+04, .1406681152344E+04},
 {    6859, .8430772460938E+04, -.1317551025391E+04, .1402878784180E+04},
 {    6860, .8443622070312E+04, -.1304489501953E+04, .1410483642578E+04},
 {    6861, .8437663085938E+04, -.1302357177734E+04, .1406267822266E+04},
 {    6862, .8446400390625E+04, -.1285592041016E+04, .1411709716797E+04},
 {    6863, .8440187500000E+04, -.1285592041016E+04, .1407322753906E+04},
 {    6864, .8421275390625E+04, -.1328045166016E+04, .1413984619141E+04},
 {    6865, .8417715820312E+04, -.1323193847656E+04, .1409345947266E+04},
 {    6866, .8425952148438E+04, -.1315235107422E+04, .1421027954102E+04},
 {    6867, .8421871093750E+04, -.1311849121094E+04, .1415581054688E+04},
 {    6868, .8428724609375E+04, -.1300831542969E+04, .1425544921875E+04},
 {    6869, .8424361328125E+04, -.1299092285156E+04, .1419569580078E+04},
 {    6870, .8429528320312E+04, -.1285592041016E+04, .1427176757812E+04},
 {    6871, .8425131835938E+04, -.1285592041016E+04, .1420984375000E+04},
 {    6872, .8456097656250E+04, -.1263146118164E+04, .1369283203125E+04},
 {    6873, .8448925781250E+04, -.1265671875000E+04, .1369728515625E+04},
 {    6874, .8443809570312E+04, -.1243849121094E+04, .1370047119141E+04},
 {    6875, .8437889648438E+04, -.1248613159180E+04, .1370415283203E+04},
 {    6876, .8426041015625E+04, -.1229459716797E+04, .1371152099609E+04},
 {    6877, .8422049804688E+04, -.1235913452148E+04, .1371400634766E+04},
 {    6878, .8453527343750E+04, -.1264129638672E+04, .1390946777344E+04},
 {    6879, .8446577148438E+04, -.1266535522461E+04, .1388968017578E+04},
 {    6880, .8442291015625E+04, -.1245244995117E+04, .1389075317383E+04},
 {    6881, .8436479492188E+04, -.1249822998047E+04, .1387301025391E+04},
 {    6882, .8426290039062E+04, -.1231138549805E+04, .1386405517578E+04},
 {    6883, .8422206054688E+04, -.1237373413086E+04, .1384918212891E+04},
 {    6884, .8443622070312E+04, -.1266694458008E+04, .1410483642578E+04},
 {    6885, .8437663085938E+04, -.1268826904297E+04, .1406267822266E+04},
 {    6886, .8435911132812E+04, -.1249519775391E+04, .1406681152344E+04},
 {    6887, .8430772460938E+04, -.1253633056641E+04, .1402878784180E+04},
 {    6888, .8424702148438E+04, -.1235818969727E+04, .1400936523438E+04},
 {    6889, .8420763671875E+04, -.1241509033203E+04, .1397789794922E+04},
 {    6890, .8428724609375E+04, -.1270352416992E+04, .1425544921875E+04},
 {    6891, .8424361328125E+04, -.1272091674805E+04, .1419569580078E+04},
 {    6892, .8425950195312E+04, -.1255948974609E+04, .1421027832031E+04},
 {    6893, .8421871093750E+04, -.1259334838867E+04, .1415581054688E+04},
 {    6894, .8421275390625E+04, -.1243138916016E+04, .1413984619141E+04},
 {    6895, .8417715820312E+04, -.1247990112305E+04, .1409345947266E+04},
 {    6896, .8411498046875E+04, -.1348585083008E+04, .1372057617188E+04},
 {    6897, .8395965820312E+04, -.1352731811523E+04, .1373024291992E+04},
 {    6898, .8379957031250E+04, -.1354165283203E+04, .1374020263672E+04},
 {    6899, .8408718750000E+04, -.1341506835938E+04, .1372230590820E+04},
 {    6900, .8394496093750E+04, -.1345259765625E+04, .1373115600586E+04},
 {    6901, .8379839843750E+04, -.1346546997070E+04, .1374027832031E+04},
 {    6902, .8412057617188E+04, -.1346533325195E+04, .1388656372070E+04},
 {    6903, .8396776367188E+04, -.1350473754883E+04, .1390447021484E+04},
 {    6904, .8381058593750E+04, -.1351828613281E+04, .1391734619141E+04},
 {    6905, .8409172851562E+04, -.1339697753906E+04, .1386969970703E+04},
 {    6906, .8395190429688E+04, -.1343256347656E+04, .1388601318359E+04},
 {    6907, .8380813476562E+04, -.1344469970703E+04, .1389774169922E+04},
 {    6908, .8411224609375E+04, -.1340635742188E+04, .1404374511719E+04},
 {    6909, .8396828125000E+04, -.1343846313477E+04, .1406822387695E+04},
 {    6910, .8382024414062E+04, -.1344978759766E+04, .1408245239258E+04},
 {    6911, .8408409179688E+04, -.1334465332031E+04, .1400926513672E+04},
 {    6912, .8395221679688E+04, -.1337365966797E+04, .1403155273438E+04},
 {    6913, .8381664062500E+04, -.1338381103516E+04, .1404450683594E+04},
 {    6914, .8408982421875E+04, -.1331379760742E+04, .1418090087891E+04},
 {    6915, .8396054687500E+04, -.1333391845703E+04, .1420911010742E+04},
 {    6916, .8382775390625E+04, -.1334082397461E+04, .1422429199219E+04},
 {    6917, .8406413085938E+04, -.1326241699219E+04, .1413101806641E+04},
 {    6918, .8394530273438E+04, -.1328073120117E+04, .1415676757812E+04},
 {    6919, .8382329101562E+04, -.1328695434570E+04, .1417059082031E+04},
 {    6920, .8409665039062E+04, -.1314213745117E+04, .1421139404297E+04},
 {    6921, .8396570312500E+04, -.1315619140625E+04, .1424860595703E+04},
 {    6922, .8383052734375E+04, -.1316070434570E+04, .1426718994141E+04},
 {    6923, .8411617187500E+04, -.1300331542969E+04, .1426260742188E+04},
 {    6924, .8397806640625E+04, -.1301091308594E+04, .1430684692383E+04},
 {    6925, .8383490234375E+04, -.1301368896484E+04, .1432792724609E+04},
 {    6926, .8412191406250E+04, -.1285592041016E+04, .1428037475586E+04},
 {    6927, .8398200195312E+04, -.1285592041016E+04, .1432668212891E+04},
 {    6928, .8383625000000E+04, -.1285592041016E+04, .1434864379883E+04},
 {    6929, .8412638671875E+04, -.1317828735352E+04, .1427137451172E+04},
 {    6930, .8398351562500E+04, -.1319378784180E+04, .1431242675781E+04},
 {    6931, .8383582031250E+04, -.1319879516602E+04, .1433295898438E+04},
 {    6932, .8414810546875E+04, -.1302193237305E+04, .1432910644531E+04},
 {    6933, .8399722656250E+04, -.1303031860352E+04, .1437797607422E+04},
 {    6934, .8384069335938E+04, -.1303340698242E+04, .1440129272461E+04},
 {    6935, .8415410156250E+04, -.1285592041016E+04, .1434929443359E+04},
 {    6936, .8400135742188E+04, -.1285592041016E+04, .1440033935547E+04},
 {    6937, .8384215820312E+04, -.1285592041016E+04, .1442461303711E+04},
 {    6938, .8411617187500E+04, -.1270852661133E+04, .1426260742188E+04},
 {    6939, .8397806640625E+04, -.1270092895508E+04, .1430684692383E+04},
 {    6940, .8383490234375E+04, -.1269815307617E+04, .1432792724609E+04},
 {    6941, .8409665039062E+04, -.1256970336914E+04, .1421139404297E+04},
 {    6942, .8396570312500E+04, -.1255565063477E+04, .1424860839844E+04},
 {    6943, .8383052734375E+04, -.1255113769531E+04, .1426718994141E+04},
 {    6944, .8406413085938E+04, -.1244942260742E+04, .1413101806641E+04},
 {    6945, .8394530273438E+04, -.1243110961914E+04, .1415676757812E+04},
 {    6946, .8382329101562E+04, -.1242488647461E+04, .1417059082031E+04},
 {    6947, .8414810546875E+04, -.1268990844727E+04, .1432910644531E+04},
 {    6948, .8399722656250E+04, -.1268152343750E+04, .1437797607422E+04},
 {    6949, .8384069335938E+04, -.1267843627930E+04, .1440129272461E+04},
 {    6950, .8412638671875E+04, -.1253355346680E+04, .1427137451172E+04},
 {    6951, .8398350585938E+04, -.1251805419922E+04, .1431242797852E+04},
 {    6952, .8383582031250E+04, -.1251304687500E+04, .1433296142578E+04},
 {    6953, .8408982421875E+04, -.1239804321289E+04, .1418090087891E+04},
 {    6954, .8396054687500E+04, -.1237792114258E+04, .1420911010742E+04},
 {    6955, .8382775390625E+04, -.1237101562500E+04, .1422429199219E+04},
 {    6956, .8408718750000E+04, -.1229677246094E+04, .1372230590820E+04},
 {    6957, .8394496093750E+04, -.1225924316406E+04, .1373115600586E+04},
 {    6958, .8379839843750E+04, -.1224637084961E+04, .1374027832031E+04},
 {    6959, .8411498046875E+04, -.1222598999023E+04, .1372057617188E+04},
 {    6960, .8395965820312E+04, -.1218452148438E+04, .1373024291992E+04},
 {    6961, .8379957031250E+04, -.1217018798828E+04, .1374020263672E+04},
 {    6962, .8409172851562E+04, -.1231486206055E+04, .1386969970703E+04},
 {    6963, .8395190429688E+04, -.1227927734375E+04, .1388601318359E+04},
 {    6964, .8380813476562E+04, -.1226714111328E+04, .1389774169922E+04},
 {    6965, .8412057617188E+04, -.1224650634766E+04, .1388656372070E+04},
 {    6966, .8396776367188E+04, -.1220710327148E+04, .1390447021484E+04},
 {    6967, .8381058593750E+04, -.1219355468750E+04, .1391734619141E+04},
 {    6968, .8408409179688E+04, -.1236718750000E+04, .1400926513672E+04},
 {    6969, .8395221679688E+04, -.1233817993164E+04, .1403155273438E+04},
 {    6970, .8381664062500E+04, -.1232802856445E+04, .1404450683594E+04},
 {    6971, .8411224609375E+04, -.1230548217773E+04, .1404374511719E+04},
 {    6972, .8396828125000E+04, -.1227337768555E+04, .1406822387695E+04},
 {    6973, .8382024414062E+04, -.1226205322266E+04, .1408245239258E+04},
 {    6974, .8357625000000E+04, -.1352058837891E+04, .1375409912109E+04},
 {    6975, .8336184570312E+04, -.1345451416016E+04, .1376743286133E+04},
 {    6976, .8316801757812E+04, -.1334136718750E+04, .1377949707031E+04},
 {    6977, .8359244140625E+04, -.1344623291016E+04, .1375309082031E+04},
 {    6978, .8339450195312E+04, -.1338615722656E+04, .1376540527344E+04},
 {    6979, .8321532226562E+04, -.1328261474609E+04, .1377655517578E+04},
 {    6980, .8359000000000E+04, -.1349842407227E+04, .1392623291016E+04},
 {    6981, .8337671875000E+04, -.1343536254883E+04, .1392540771484E+04},
 {    6982, .8318395507812E+04, -.1332824462891E+04, .1391391601562E+04},
 {    6983, .8360494140625E+04, -.1342658691406E+04, .1390594726562E+04},
 {    6984, .8340827148438E+04, -.1336937866211E+04, .1390535766602E+04},
 {    6985, .8323023437500E+04, -.1327154785156E+04, .1389492187500E+04},
 {    6986, .8361015625000E+04, -.1343287597656E+04, .1408754150391E+04},
 {    6987, .8340555664062E+04, -.1338070556641E+04, .1407397094727E+04},
 {    6988, .8321794921875E+04, -.1329257934570E+04, .1404066650391E+04},
 {    6989, .8362271484375E+04, -.1336833251953E+04, .1404928833008E+04},
 {    6990, .8343364257812E+04, -.1332077026367E+04, .1403706176758E+04},
 {    6991, .8326014648438E+04, -.1323990112305E+04, .1400654296875E+04},
 {    6992, .8363442382812E+04, -.1332961669922E+04, .1422509033203E+04},
 {    6993, .8344529296875E+04, -.1329494262695E+04, .1420211669922E+04},
 {    6994, .8326718750000E+04, -.1323597045898E+04, .1415410644531E+04},
 {    6995, .8364445312500E+04, -.1327662353516E+04, .1417136962891E+04},
 {    6996, .8346936523438E+04, -.1324490356445E+04, .1415048828125E+04},
 {    6997, .8330444335938E+04, -.1319065917969E+04, .1410639404297E+04},
 {    6998, .8363604492188E+04, -.1315343139648E+04, .1426377929688E+04},
 {    6999, .8344552734375E+04, -.1312948608398E+04, .1422797973633E+04},
 {    7000, .8326957031250E+04, -.1308825317383E+04, .1415790039062E+04},
 {    7001, .8363084960938E+04, -.1300926391602E+04, .1432246459961E+04},
 {    7002, .8343142578125E+04, -.1299645751953E+04, .1427755615234E+04},
 {    7003, .8324864257812E+04, -.1297498779297E+04, .1419091430664E+04},
 {    7004, .8362911132812E+04, -.1285592041016E+04, .1434225830078E+04},
 {    7005, .8342742187500E+04, -.1285592041016E+04, .1429461914062E+04},
 {    7006, .8324180664062E+04, -.1285592041016E+04, .1420242187500E+04},
 {    7007, .8362518554688E+04, -.1319082885742E+04, .1432912597656E+04},
 {    7008, .8341896484375E+04, -.1316457275391E+04, .1428967773438E+04},
 {    7009, .8322871093750E+04, -.1311969360352E+04, .1421322509766E+04},
 {    7010, .8361916992188E+04, -.1302858154297E+04, .1439516723633E+04},
 {    7011, .8340287109375E+04, -.1301451538086E+04, .1434544067383E+04},
 {    7012, .8320489257812E+04, -.1299107177734E+04, .1425043579102E+04},
 {    7013, .8361750976562E+04, -.1285592041016E+04, .1441748046875E+04},
 {    7014, .8339899414062E+04, -.1285592041016E+04, .1436487792969E+04},
 {    7015, .8319815429688E+04, -.1285592041016E+04, .1426400390625E+04},
 {    7016, .8363084960938E+04, -.1270257812500E+04, .1432246948242E+04},
 {    7017, .8343142578125E+04, -.1271538330078E+04, .1427755859375E+04},
 {    7018, .8324864257812E+04, -.1273685302734E+04, .1419091430664E+04},
 {    7019, .8363605468750E+04, -.1255841064453E+04, .1426378173828E+04},
 {    7020, .8344552734375E+04, -.1258235473633E+04, .1422797973633E+04},
 {    7021, .8326957031250E+04, -.1262358642578E+04, .1415790039062E+04},
 {    7022, .8364445312500E+04, -.1243521728516E+04, .1417136962891E+04},
 {    7023, .8346936523438E+04, -.1246693603516E+04, .1415048828125E+04},
 {    7024, .8330444335938E+04, -.1252118041992E+04, .1410639404297E+04},
 {    7025, .8361916992188E+04, -.1268326049805E+04, .1439516723633E+04},
 {    7026, .8340287109375E+04, -.1269732543945E+04, .1434544067383E+04},
 {    7027, .8320489257812E+04, -.1272076782227E+04, .1425043579102E+04},
 {    7028, .8362518554688E+04, -.1252101318359E+04, .1432912597656E+04},
 {    7029, .8341896484375E+04, -.1254726806641E+04, .1428968017578E+04},
 {    7030, .8322871093750E+04, -.1259214721680E+04, .1421322509766E+04},
 {    7031, .8363442382812E+04, -.1238222412109E+04, .1422509033203E+04},
 {    7032, .8344529296875E+04, -.1241689819336E+04, .1420211669922E+04},
 {    7033, .8326718750000E+04, -.1247587036133E+04, .1415410644531E+04},
 {    7034, .8359244140625E+04, -.1226560668945E+04, .1375309082031E+04},
 {    7035, .8339450195312E+04, -.1232568237305E+04, .1376540527344E+04},
 {    7036, .8321532226562E+04, -.1242922485352E+04, .1377655517578E+04},
 {    7037, .8357625000000E+04, -.1219125244141E+04, .1375409912109E+04},
 {    7038, .8336184570312E+04, -.1225732543945E+04, .1376743286133E+04},
 {    7039, .8316801757812E+04, -.1237047363281E+04, .1377949707031E+04},
 {    7040, .8360494140625E+04, -.1228525268555E+04, .1390594726562E+04},
 {    7041, .8340827148438E+04, -.1234246093750E+04, .1390535766602E+04},
 {    7042, .8323023437500E+04, -.1244029296875E+04, .1389492187500E+04},
 {    7043, .8359000000000E+04, -.1221341674805E+04, .1392623291016E+04},
 {    7044, .8337671875000E+04, -.1227647827148E+04, .1392540771484E+04},
 {    7045, .8318395507812E+04, -.1238359619141E+04, .1391391601562E+04},
 {    7046, .8362271484375E+04, -.1234350830078E+04, .1404928833008E+04},
 {    7047, .8343364257812E+04, -.1239106933594E+04, .1403706176758E+04},
 {    7048, .8326014648438E+04, -.1247193969727E+04, .1400654296875E+04},
 {    7049, .8361015625000E+04, -.1227896362305E+04, .1408754150391E+04},
 {    7050, .8340555664062E+04, -.1233113403320E+04, .1407397094727E+04},
 {    7051, .8321794921875E+04, -.1241926025391E+04, .1404066650391E+04},
 {    7052, .8309599609375E+04, -.1316570556641E+04, .1378397949219E+04},
 {    7053, .8303335937500E+04, -.1320806884766E+04, .1378787109375E+04},
 {    7054, .8301347656250E+04, -.1302037353516E+04, .1378911010742E+04},
 {    7055, .8294083007812E+04, -.1304258789062E+04, .1379362548828E+04},
 {    7056, .8298333984375E+04, -.1285592041016E+04, .1379098144531E+04},
 {    7057, .8290727539062E+04, -.1285592041016E+04, .1379572021484E+04},
 {    7058, .8312389648438E+04, -.1315682739258E+04, .1392474121094E+04},
 {    7059, .8306428710938E+04, -.1319756225586E+04, .1394776855469E+04},
 {    7060, .8304990234375E+04, -.1301418334961E+04, .1394541503906E+04},
 {    7061, .8298144531250E+04, -.1303533081055E+04, .1397085937500E+04},
 {    7062, .8302369140625E+04, -.1285592041016E+04, .1395324707031E+04},
 {    7063, .8295243164062E+04, -.1285592041016E+04, .1397993896484E+04},
 {    7064, .8318474609375E+04, -.1312948242188E+04, .1405254638672E+04},
 {    7065, .8313308593750E+04, -.1316689697266E+04, .1409324462891E+04},
 {    7066, .8313375000000E+04, -.1299814819336E+04, .1408311035156E+04},
 {    7067, .8307546875000E+04, -.1301742553711E+04, .1412756591797E+04},
 {    7068, .8311523437500E+04, -.1285592041016E+04, .1409316406250E+04},
 {    7069, .8305521484375E+04, -.1285592041016E+04, .1413933837891E+04},
 {    7070, .8301347656250E+04, -.1269146728516E+04, .1378911010742E+04},
 {    7071, .8294083007812E+04, -.1266925292969E+04, .1379362548828E+04},
 {    7072, .8309599609375E+04, -.1254613403320E+04, .1378397949219E+04},
 {    7073, .8303335937500E+04, -.1250377197266E+04, .1378787109375E+04},
 {    7074, .8304990234375E+04, -.1269765747070E+04, .1394541503906E+04},
 {    7075, .8298144531250E+04, -.1267651000977E+04, .1397085937500E+04},
 {    7076, .8312389648438E+04, -.1255501220703E+04, .1392474121094E+04},
 {    7077, .8306428710938E+04, -.1251427856445E+04, .1394776855469E+04},
 {    7078, .8313375000000E+04, -.1271369262695E+04, .1408311035156E+04},
 {    7079, .8307546875000E+04, -.1269441406250E+04, .1412756591797E+04},
 {    7080, .8318474609375E+04, -.1258235839844E+04, .1405254638672E+04},
 {    7081, .8313308593750E+04, -.1254494384766E+04, .1409324462891E+04},
 {    7082, .8430102539062E+04, -.1348144653320E+04, .1370900146484E+04},
 {    7083, .8449763671875E+04, -.1332063232422E+04, .1369677001953E+04},
 {    7084, .8463281250000E+04, -.1310541137695E+04, .1368836181641E+04},
 {    7085, .8468185546875E+04, -.1285592041016E+04, .1368531005859E+04},
 {    7086, .8430441406250E+04, -.1346246337891E+04, .1387881591797E+04},
 {    7087, .8448137695312E+04, -.1330483642578E+04, .1390833007812E+04},
 {    7088, .8460495117188E+04, -.1309439819336E+04, .1392903076172E+04},
 {    7089, .8464830078125E+04, -.1285592041016E+04, .1393736572266E+04},
 {    7090, .8428708984375E+04, -.1341025512695E+04, .1404062988281E+04},
 {    7091, .8441127929688E+04, -.1325735961914E+04, .1410435424805E+04},
 {    7092, .8449621093750E+04, -.1306606323242E+04, .1414664062500E+04},
 {    7093, .8452648437500E+04, -.1285592041016E+04, .1416058837891E+04},
 {    7094, .8424914062500E+04, -.1332875000000E+04, .1418597167969E+04},
 {    7095, .8430101562500E+04, -.1318604125977E+04, .1426440673828E+04},
 {    7096, .8433154296875E+04, -.1302561645508E+04, .1431481933594E+04},
 {    7097, .8433989257812E+04, -.1285592041016E+04, .1433331909180E+04},
 {    7098, .8463281250000E+04, -.1260642944336E+04, .1368836181641E+04},
 {    7099, .8449763671875E+04, -.1239120727539E+04, .1369677001953E+04},
 {    7100, .8430102539062E+04, -.1223039306641E+04, .1370900146484E+04},
 {    7101, .8460495117188E+04, -.1261744140625E+04, .1392903076172E+04},
 {    7102, .8448137695312E+04, -.1240700439453E+04, .1390833007812E+04},
 {    7103, .8430441406250E+04, -.1224937744141E+04, .1387881591797E+04},
 {    7104, .8449621093750E+04, -.1264577758789E+04, .1414664062500E+04},
 {    7105, .8441127929688E+04, -.1245448120117E+04, .1410435424805E+04},
 {    7106, .8428708984375E+04, -.1230158569336E+04, .1404062988281E+04},
 {    7107, .8433154296875E+04, -.1268622436523E+04, .1431481933594E+04},
 {    7108, .8430101562500E+04, -.1252579833984E+04, .1426440673828E+04},
 {    7109, .8424914062500E+04, -.1238308959961E+04, .1418597167969E+04},
 {    7110, .8414327148438E+04, -.1355647949219E+04, .1371881835938E+04},
 {    7111, .8397466796875E+04, -.1360199829102E+04, .1372930908203E+04},
 {    7112, .8380076171875E+04, -.1361783447266E+04, .1374012939453E+04},
 {    7113, .8414995117188E+04, -.1353353393555E+04, .1390334350586E+04},
 {    7114, .8398394531250E+04, -.1357687011719E+04, .1392289428711E+04},
 {    7115, .8381307617188E+04, -.1359187133789E+04, .1393693969727E+04},
 {    7116, .8414091796875E+04, -.1346793090820E+04, .1407809570312E+04},
 {    7117, .8398463867188E+04, -.1350322753906E+04, .1410485351562E+04},
 {    7118, .8382387695312E+04, -.1351576171875E+04, .1412039062500E+04},
 {    7119, .8411607421875E+04, -.1336508056641E+04, .1423064941406E+04},
 {    7120, .8397609375000E+04, -.1338708129883E+04, .1426140380859E+04},
 {    7121, .8383223632812E+04, -.1339469482422E+04, .1427798706055E+04},
 {    7122, .8415666015625E+04, -.1321436157227E+04, .1433118041992E+04},
 {    7123, .8400151367188E+04, -.1323136108398E+04, .1437619628906E+04},
 {    7124, .8384118164062E+04, -.1323688598633E+04, .1439872558594E+04},
 {    7125, .8418056640625E+04, -.1304050537109E+04, .1439542602539E+04},
 {    7126, .8401666015625E+04, -.1304971069336E+04, .1444904052734E+04},
 {    7127, .8384654296875E+04, -.1305312377930E+04, .1447465332031E+04},
 {    7128, .8418677734375E+04, -.1285592041016E+04, .1441802612305E+04},
 {    7129, .8402099609375E+04, -.1285592041016E+04, .1447394531250E+04},
 {    7130, .8384806640625E+04, -.1285592041016E+04, .1450056762695E+04},
 {    7131, .8418056640625E+04, -.1267133544922E+04, .1439542602539E+04},
 {    7132, .8401666015625E+04, -.1266213134766E+04, .1444904052734E+04},
 {    7133, .8384654296875E+04, -.1265871826172E+04, .1447465576172E+04},
 {    7134, .8415666015625E+04, -.1249747924805E+04, .1433118041992E+04},
 {    7135, .8400151367188E+04, -.1248048095703E+04, .1437619628906E+04},
 {    7136, .8384118164062E+04, -.1247495605469E+04, .1439872558594E+04},
 {    7137, .8411607421875E+04, -.1234676025391E+04, .1423064941406E+04},
 {    7138, .8397609375000E+04, -.1232475952148E+04, .1426140380859E+04},
 {    7139, .8383223632812E+04, -.1231714599609E+04, .1427798706055E+04},
 {    7140, .8414327148438E+04, -.1215536132812E+04, .1371881835938E+04},
 {    7141, .8397466796875E+04, -.1210984252930E+04, .1372930908203E+04},
 {    7142, .8380076171875E+04, -.1209400634766E+04, .1374012939453E+04},
 {    7143, .8414995117188E+04, -.1217830566406E+04, .1390334350586E+04},
 {    7144, .8398394531250E+04, -.1213496948242E+04, .1392289428711E+04},
 {    7145, .8381307617188E+04, -.1211996948242E+04, .1393693969727E+04},
 {    7146, .8414091796875E+04, -.1224390869141E+04, .1407809570312E+04},
 {    7147, .8398463867188E+04, -.1220861328125E+04, .1410485351562E+04},
 {    7148, .8382387695312E+04, -.1219607788086E+04, .1412039062500E+04},
 {    7149, .8355956054688E+04, -.1359487182617E+04, .1375513671875E+04},
 {    7150, .8332826171875E+04, -.1352257202148E+04, .1376952148438E+04},
 {    7151, .8311947265625E+04, -.1339940185547E+04, .1378251953125E+04},
 {    7152, .8357562500000E+04, -.1357033325195E+04, .1394651855469E+04},
 {    7153, .8334590820312E+04, -.1350170410156E+04, .1394563964844E+04},
 {    7154, .8313870117188E+04, -.1338562500000E+04, .1393336914062E+04},
 {    7155, .8359802734375E+04, -.1349743164062E+04, .1412593505859E+04},
 {    7156, .8337814453125E+04, -.1344075927734E+04, .1411134277344E+04},
 {    7157, .8317679687500E+04, -.1334540039062E+04, .1407564086914E+04},
 {    7158, .8362559570312E+04, -.1338277832031E+04, .1427890869141E+04},
 {    7159, .8342341796875E+04, -.1334561645508E+04, .1425425048828E+04},
 {    7160, .8323300781250E+04, -.1328263183594E+04, .1420298339844E+04},
 {    7161, .8361471679688E+04, -.1322839965820E+04, .1439445556641E+04},
 {    7162, .8339308593750E+04, -.1320017822266E+04, .1435146240234E+04},
 {    7163, .8318878906250E+04, -.1315204589844E+04, .1426863159180E+04},
 {    7164, .8360806640625E+04, -.1304793090820E+04, .1446791137695E+04},
 {    7165, .8337501953125E+04, -.1303279296875E+04, .1441364257812E+04},
 {    7166, .8316216796875E+04, -.1300767089844E+04, .1431058349609E+04},
 {    7167, .8360544921875E+04, -.1285592041016E+04, .1449265869141E+04},
 {    7168, .8336965820312E+04, -.1285592041016E+04, .1443489379883E+04},
 {    7169, .8315322265625E+04, -.1285592041016E+04, .1432494873047E+04},
 {    7170, .8360806640625E+04, -.1266391113281E+04, .1446791137695E+04},
 {    7171, .8337501953125E+04, -.1267904785156E+04, .1441364257812E+04},
 {    7172, .8316216796875E+04, -.1270416992188E+04, .1431058349609E+04},
 {    7173, .8361471679688E+04, -.1248344238281E+04, .1439445800781E+04},
 {    7174, .8339308593750E+04, -.1251166259766E+04, .1435146484375E+04},
 {    7175, .8318878906250E+04, -.1255979492188E+04, .1426863159180E+04},
 {    7176, .8362559570312E+04, -.1232906127930E+04, .1427890869141E+04},
 {    7177, .8342341796875E+04, -.1236622436523E+04, .1425425048828E+04},
 {    7178, .8323300781250E+04, -.1242920898438E+04, .1420298339844E+04},
 {    7179, .8355956054688E+04, -.1211696899414E+04, .1375513671875E+04},
 {    7180, .8332826171875E+04, -.1218926757812E+04, .1376952148438E+04},
 {    7181, .8311947265625E+04, -.1231243774414E+04, .1378251953125E+04},
 {    7182, .8357562500000E+04, -.1214150756836E+04, .1394651123047E+04},
 {    7183, .8334590820312E+04, -.1221013671875E+04, .1394563964844E+04},
 {    7184, .8313870117188E+04, -.1232621582031E+04, .1393336914062E+04},
 {    7185, .8359802734375E+04, -.1221440795898E+04, .1412593505859E+04},
 {    7186, .8337814453125E+04, -.1227108154297E+04, .1411134277344E+04},
 {    7187, .8317679687500E+04, -.1236644042969E+04, .1407564086914E+04},
 {    7188, .8297002929688E+04, -.1324975830078E+04, .1379181884766E+04},
 {    7189, .8286802734375E+04, -.1306438110352E+04, .1379815673828E+04},
 {    7190, .8283123046875E+04, -.1285592041016E+04, .1380044921875E+04},
 {    7191, .8300498046875E+04, -.1323879638672E+04, .1397088623047E+04},
 {    7192, .8291315429688E+04, -.1305677490234E+04, .1399659912109E+04},
 {    7193, .8288097656250E+04, -.1285592041016E+04, .1400621582031E+04},
 {    7194, .8308167968750E+04, -.1320447265625E+04, .1413409057617E+04},
 {    7195, .8301751953125E+04, -.1303681274414E+04, .1417247436523E+04},
 {    7196, .8299449218750E+04, -.1285592041016E+04, .1418489257812E+04},
 {    7197, .8286802734375E+04, -.1264745849609E+04, .1379815673828E+04},
 {    7198, .8297002929688E+04, -.1246208251953E+04, .1379181884766E+04},
 {    7199, .8291315429688E+04, -.1265506591797E+04, .1399659912109E+04},
 {    7200, .8300498046875E+04, -.1247304321289E+04, .1397088623047E+04},
 {    7201, .8301751953125E+04, -.1267502807617E+04, .1417247436523E+04},
 {    7202, .8308167968750E+04, -.1250736816406E+04, .1413409057617E+04},
 {    7203, .8417290039062E+04, -.1327818969727E+04, .1320799072266E+04},
 {    7204, .8412272460938E+04, -.1322098754883E+04, .1321111572266E+04},
 {    7205, .8428000976562E+04, -.1315719482422E+04, .1320132568359E+04},
 {    7206, .8421558593750E+04, -.1311670654297E+04, .1320533691406E+04},
 {    7207, .8434862304688E+04, -.1301082031250E+04, .1319705566406E+04},
 {    7208, .8427534179688E+04, -.1299041992188E+04, .1320162353516E+04},
 {    7209, .8437134765625E+04, -.1285072021484E+04, .1319563476562E+04},
 {    7210, .8429532226562E+04, -.1285210205078E+04, .1320037597656E+04},
 {    7211, .8423672851562E+04, -.1338306030273E+04, .1345851074219E+04},
 {    7212, .8419420898438E+04, -.1332012695312E+04, .1346115722656E+04},
 {    7213, .8439601562500E+04, -.1324167358398E+04, .1344859863281E+04},
 {    7214, .8433529296875E+04, -.1319597290039E+04, .1345238159180E+04},
 {    7215, .8450302734375E+04, -.1305735961914E+04, .1344194580078E+04},
 {    7216, .8443067382812E+04, -.1303393310547E+04, .1344644531250E+04},
 {    7217, .8453915039062E+04, -.1284722778320E+04, .1343969970703E+04},
 {    7218, .8446312500000E+04, -.1284863769531E+04, .1344442138672E+04},
 {    7219, .8444029296875E+04, -.1327088500977E+04, .1370033813477E+04},
 {    7220, .8438080078125E+04, -.1322361328125E+04, .1370404052734E+04},
 {    7221, .8456347656250E+04, -.1307424438477E+04, .1369267333984E+04},
 {    7222, .8449145507812E+04, -.1304987304688E+04, .1369715820312E+04},
 {    7223, .8460558593750E+04, -.1284594116211E+04, .1369005615234E+04},
 {    7224, .8452956054688E+04, -.1284735351562E+04, .1369478271484E+04},
 {    7225, .8434657226562E+04, -.1269439819336E+04, .1319718872070E+04},
 {    7226, .8427381835938E+04, -.1271656005859E+04, .1320171142578E+04},
 {    7227, .8427809570312E+04, -.1255175903320E+04, .1320144287109E+04},
 {    7228, .8421418945312E+04, -.1259300903320E+04, .1320542236328E+04},
 {    7229, .8417290039062E+04, -.1243365112305E+04, .1320799072266E+04},
 {    7230, .8412272460938E+04, -.1249085205078E+04, .1321111572266E+04},
 {    7231, .8449885742188E+04, -.1264368164062E+04, .1344219970703E+04},
 {    7232, .8442712890625E+04, -.1266887329102E+04, .1344666503906E+04},
 {    7233, .8439232421875E+04, -.1246573120117E+04, .1344883300781E+04},
 {    7234, .8433221679688E+04, -.1251213745117E+04, .1345257202148E+04},
 {    7235, .8423672851562E+04, -.1232878051758E+04, .1345851074219E+04},
 {    7236, .8419420898438E+04, -.1239171386719E+04, .1346115722656E+04},
 {    7237, .8455847656250E+04, -.1262530639648E+04, .1369298583984E+04},
 {    7238, .8448708007812E+04, -.1265145263672E+04, .1369742919922E+04},
 {    7239, .8443588867188E+04, -.1243601318359E+04, .1370060913086E+04},
 {    7240, .8437699218750E+04, -.1248402343750E+04, .1370427368164E+04},
 {    7241, .8404849609375E+04, -.1336060668945E+04, .1321573242188E+04},
 {    7242, .8390801757812E+04, -.1341091796875E+04, .1322447265625E+04},
 {    7243, .8375976562500E+04, -.1342738525391E+04, .1323369873047E+04},
 {    7244, .8401365234375E+04, -.1329289062500E+04, .1321789306641E+04},
 {    7245, .8389063476562E+04, -.1333676147461E+04, .1322555419922E+04},
 {    7246, .8376084960938E+04, -.1335119873047E+04, .1323362548828E+04},
 {    7247, .8409228515625E+04, -.1345753906250E+04, .1346749755859E+04},
 {    7248, .8393606445312E+04, -.1350203613281E+04, .1347721679688E+04},
 {    7249, .8377422851562E+04, -.1351626220703E+04, .1348728637695E+04},
 {    7250, .8406329101562E+04, -.1338718017578E+04, .1346930419922E+04},
 {    7251, .8392181640625E+04, -.1342721191406E+04, .1347810302734E+04},
 {    7252, .8377537109375E+04, -.1344007812500E+04, .1348721923828E+04},
 {    7253, .8411183593750E+04, -.1348697753906E+04, .1372077270508E+04},
 {    7254, .8395309570312E+04, -.1352840087891E+04, .1373065307617E+04},
 {    7255, .8378955078125E+04, -.1354165283203E+04, .1374082275391E+04},
 {    7256, .8408476562500E+04, -.1341591796875E+04, .1372244873047E+04},
 {    7257, .8393990234375E+04, -.1345341308594E+04, .1373147216797E+04},
 {    7258, .8379074218750E+04, -.1346546997070E+04, .1374074951172E+04},
 {    7259, .8401365234375E+04, -.1241895019531E+04, .1321789306641E+04},
 {    7260, .8389063476562E+04, -.1237507934570E+04, .1322555419922E+04},
 {    7261, .8376084960938E+04, -.1236064208984E+04, .1323362548828E+04},
 {    7262, .8404849609375E+04, -.1235123413086E+04, .1321573242188E+04},
 {    7263, .8390801757812E+04, -.1230092285156E+04, .1322447265625E+04},
 {    7264, .8375976562500E+04, -.1228445434570E+04, .1323369873047E+04},
 {    7265, .8406329101562E+04, -.1232466064453E+04, .1346930419922E+04},
 {    7266, .8392181640625E+04, -.1228462890625E+04, .1347810302734E+04},
 {    7267, .8377537109375E+04, -.1227176269531E+04, .1348721923828E+04},
 {    7268, .8409228515625E+04, -.1225430175781E+04, .1346749755859E+04},
 {    7269, .8393606445312E+04, -.1220980346680E+04, .1347721679688E+04},
 {    7270, .8377422851562E+04, -.1219557861328E+04, .1348728637695E+04},
 {    7271, .8408476562500E+04, -.1229592163086E+04, .1372244873047E+04},
 {    7272, .8393990234375E+04, -.1225842773438E+04, .1373147216797E+04},
 {    7273, .8379074218750E+04, -.1224637084961E+04, .1374074951172E+04},
 {    7274, .8411183593750E+04, -.1222486328125E+04, .1372077270508E+04},
 {    7275, .8395309570312E+04, -.1218343994141E+04, .1373065307617E+04},
 {    7276, .8378955078125E+04, -.1217018798828E+04, .1374082275391E+04},
 {    7277, .8356789062500E+04, -.1341491577148E+04, .1324562988281E+04},
 {    7278, .8337928710938E+04, -.1337738159180E+04, .1325736816406E+04},
 {    7279, .8319833984375E+04, -.1331215454102E+04, .1326862670898E+04},
 {    7280, .8357921875000E+04, -.1333978759766E+04, .1324492187500E+04},
 {    7281, .8340053710938E+04, -.1330520996094E+04, .1325604736328E+04},
 {    7282, .8322888671875E+04, -.1324460693359E+04, .1326672119141E+04},
 {    7283, .8356162109375E+04, -.1349730957031E+04, .1350051025391E+04},
 {    7284, .8335574218750E+04, -.1344100952148E+04, .1351332641602E+04},
 {    7285, .8316517578125E+04, -.1334470581055E+04, .1352518188477E+04},
 {    7286, .8357782226562E+04, -.1342299560547E+04, .1349950683594E+04},
 {    7287, .8338624023438E+04, -.1337180908203E+04, .1351142700195E+04},
 {    7288, .8320872070312E+04, -.1328335205078E+04, .1352247314453E+04},
 {    7289, .8356969726562E+04, -.1351923461914E+04, .1375450195312E+04},
 {    7290, .8335873046875E+04, -.1345319702148E+04, .1376762939453E+04},
 {    7291, .8358743164062E+04, -.1344522216797E+04, .1375340087891E+04},
 {    7292, .8339211914062E+04, -.1338517089844E+04, .1376555419922E+04},
 {    7293, .8357921875000E+04, -.1237205200195E+04, .1324492187500E+04},
 {    7294, .8340053710938E+04, -.1240663085938E+04, .1325604736328E+04},
 {    7295, .8322888671875E+04, -.1246723388672E+04, .1326672119141E+04},
 {    7296, .8356789062500E+04, -.1229692504883E+04, .1324562988281E+04},
 {    7297, .8337928710938E+04, -.1233445922852E+04, .1325736816406E+04},
 {    7298, .8319833984375E+04, -.1239968627930E+04, .1326862670898E+04},
 {    7299, .8357782226562E+04, -.1228884521484E+04, .1349950683594E+04},
 {    7300, .8338624023438E+04, -.1234003173828E+04, .1351142700195E+04},
 {    7301, .8320872070312E+04, -.1242848876953E+04, .1352247314453E+04},
 {    7302, .8356162109375E+04, -.1221453125000E+04, .1350051025391E+04},
 {    7303, .8335573242188E+04, -.1227083129883E+04, .1351333007812E+04},
 {    7304, .8316517578125E+04, -.1236713500977E+04, .1352518188477E+04},
 {    7305, .8358743164062E+04, -.1226661865234E+04, .1375340087891E+04},
 {    7306, .8339211914062E+04, -.1232666992188E+04, .1376555419922E+04},
 {    7307, .8356969726562E+04, -.1219260620117E+04, .1375450195312E+04},
 {    7308, .8335873046875E+04, -.1225864379883E+04, .1376762939453E+04},
 {    7309, .8307448242188E+04, -.1315373046875E+04, .1327632934570E+04},
 {    7310, .8302007812500E+04, -.1320470092773E+04, .1327972045898E+04},
 {    7311, .8295170898438E+04, -.1302306518555E+04, .1328396850586E+04},
 {    7312, .8288076171875E+04, -.1304989013672E+04, .1328838623047E+04},
 {    7313, .8290124023438E+04, -.1285089965820E+04, .1328711181641E+04},
 {    7314, .8282525390625E+04, -.1284899902344E+04, .1329183349609E+04},
 {    7315, .8307425781250E+04, -.1317081665039E+04, .1353083984375E+04},
 {    7316, .8301312500000E+04, -.1321512573242E+04, .1353463623047E+04},
 {    7317, .8297782226562E+04, -.1302428466797E+04, .1353684326172E+04},
 {    7318, .8290527343750E+04, -.1304684692383E+04, .1354134643555E+04},
 {    7319, .8294228515625E+04, -.1285242309570E+04, .1353904907227E+04},
 {    7320, .8286628906250E+04, -.1285070434570E+04, .1354377563477E+04},
 {    7321, .8309544921875E+04, -.1316502319336E+04, .1378401123047E+04},
 {    7322, .8303249023438E+04, -.1320694946289E+04, .1378792602539E+04},
 {    7323, .8301289062500E+04, -.1301871582031E+04, .1378914550781E+04},
 {    7324, .8293988281250E+04, -.1303989257812E+04, .1379369140625E+04},
 {    7325, .8298340820312E+04, -.1285326171875E+04, .1379097900391E+04},
 {    7326, .8290737304688E+04, -.1285161132812E+04, .1379571289062E+04},
 {    7327, .8295525390625E+04, -.1268322753906E+04, .1328375000000E+04},
 {    7328, .8288554687500E+04, -.1265419311523E+04, .1328808349609E+04},
 {    7329, .8307706054688E+04, -.1255612915039E+04, .1327617187500E+04},
 {    7330, .8302361328125E+04, -.1250429443359E+04, .1327949951172E+04},
 {    7331, .8297970703125E+04, -.1268330566406E+04, .1353672119141E+04},
 {    7332, .8290793945312E+04, -.1265862182617E+04, .1354118530273E+04},
 {    7333, .8307584960938E+04, -.1253933471680E+04, .1353073364258E+04},
 {    7334, .8301542968750E+04, -.1249414916992E+04, .1353449584961E+04},
 {    7335, .8301407226562E+04, -.1268979736328E+04, .1378907226562E+04},
 {    7336, .8294177734375E+04, -.1266654296875E+04, .1379357177734E+04},
 {    7337, .8309654296875E+04, -.1254544677734E+04, .1378393920898E+04},
 {    7338, .8303422851562E+04, -.1250264404297E+04, .1378781982422E+04},
 {    7339, .8421827148438E+04, -.1333951660156E+04, .1320517333984E+04},
 {    7340, .8434208007812E+04, -.1320121948242E+04, .1319746337891E+04},
 {    7341, .8442130859375E+04, -.1303327514648E+04, .1319253540039E+04},
 {    7342, .8444737304688E+04, -.1284935058594E+04, .1319091796875E+04},
 {    7343, .8427987304688E+04, -.1344563598633E+04, .1345582519531E+04},
 {    7344, .8445709960938E+04, -.1328701538086E+04, .1344479980469E+04},
 {    7345, .8457543945312E+04, -.1308057250977E+04, .1343742919922E+04},
 {    7346, .8461517578125E+04, -.1284583496094E+04, .1343496337891E+04},
 {    7347, .8450011718750E+04, -.1331780273438E+04, .1369661865234E+04},
 {    7348, .8463561523438E+04, -.1309840087891E+04, .1368818359375E+04},
 {    7349, .8468163085938E+04, -.1284454589844E+04, .1368531738281E+04},
 {    7350, .8441867187500E+04, -.1267022460938E+04, .1319270019531E+04},
 {    7351, .8433960937500E+04, -.1250700927734E+04, .1319761230469E+04},
 {    7352, .8421827148438E+04, -.1237232543945E+04, .1320517333984E+04},
 {    7353, .8457067382812E+04, -.1261871826172E+04, .1343773193359E+04},
 {    7354, .8445280273438E+04, -.1241967651367E+04, .1344506835938E+04},
 {    7355, .8427987304688E+04, -.1226620483398E+04, .1345582519531E+04},
 {    7356, .8462997070312E+04, -.1259939697266E+04, .1368853759766E+04},
 {    7357, .8449513671875E+04, -.1238836303711E+04, .1369692626953E+04},
 {    7358, .8407950195312E+04, -.1343015258789E+04, .1321379882812E+04},
 {    7359, .8392332031250E+04, -.1348553466797E+04, .1322351318359E+04},
 {    7360, .8375864257812E+04, -.1350357177734E+04, .1323376464844E+04},
 {    7361, .8412172851562E+04, -.1352774047852E+04, .1346566406250E+04},
 {    7362, .8395047851562E+04, -.1357680786133E+04, .1347631958008E+04},
 {    7363, .8377304687500E+04, -.1359244506836E+04, .1348736572266E+04},
 {    7364, .8413941406250E+04, -.1355789306641E+04, .1371905761719E+04},
 {    7365, .8396650390625E+04, -.1360335815430E+04, .1372981445312E+04},
 {    7366, .8378835937500E+04, -.1361783447266E+04, .1374089355469E+04},
 {    7367, .8407950195312E+04, -.1228168823242E+04, .1321379882812E+04},
 {    7368, .8392332031250E+04, -.1222630615234E+04, .1322351318359E+04},
 {    7369, .8375864257812E+04, -.1220826904297E+04, .1323376464844E+04},
 {    7370, .8412334960938E+04, -.1218476562500E+04, .1346556762695E+04},
 {    7371, .8395391601562E+04, -.1213566040039E+04, .1347610351562E+04},
 {    7372, .8377831054688E+04, -.1211932617188E+04, .1348703613281E+04},
 {    7373, .8413941406250E+04, -.1215394653320E+04, .1371905761719E+04},
 {    7374, .8396650390625E+04, -.1210848144531E+04, .1372981201172E+04},
 {    7375, .8378835937500E+04, -.1209400634766E+04, .1374089355469E+04},
 {    7376, .8355511718750E+04, -.1348983154297E+04, .1324642822266E+04},
 {    7377, .8335527343750E+04, -.1344889892578E+04, .1325886474609E+04},
 {    7378, .8316380859375E+04, -.1337839477539E+04, .1327077148438E+04},
 {    7379, .8354767578125E+04, -.1357202880859E+04, .1350137695312E+04},
 {    7380, .8332947265625E+04, -.1351193603516E+04, .1351496459961E+04},
 {    7381, .8312741210938E+04, -.1340990600586E+04, .1352753173828E+04},
 {    7382, .8355147460938E+04, -.1359315795898E+04, .1375563598633E+04},
 {    7383, .8332448242188E+04, -.1352090942383E+04, .1376975585938E+04},
 {    7384, .8355511718750E+04, -.1222200927734E+04, .1324642822266E+04},
 {    7385, .8335527343750E+04, -.1226294189453E+04, .1325886474609E+04},
 {    7386, .8316380859375E+04, -.1233344604492E+04, .1327077148438E+04},
 {    7387, .8355114257812E+04, -.1213921630859E+04, .1350116699219E+04},
 {    7388, .8333112304688E+04, -.1219928100586E+04, .1351485595703E+04},
 {    7389, .8312741210938E+04, -.1230193481445E+04, .1352753173828E+04},
 {    7390, .8355147460938E+04, -.1211868286133E+04, .1375563598633E+04},
 {    7391, .8332446289062E+04, -.1219093139648E+04, .1376975585938E+04},
 {    7392, .8296334960938E+04, -.1325418823242E+04, .1328324707031E+04},
 {    7393, .8280916015625E+04, -.1307561279297E+04, .1329284423828E+04},
 {    7394, .8274921875000E+04, -.1284723266602E+04, .1329656494141E+04},
 {    7395, .8295495117188E+04, -.1326303710938E+04, .1353825683594E+04},
 {    7396, .8283361328125E+04, -.1307163085938E+04, .1354580688477E+04},
 {    7397, .8279028320312E+04, -.1284906738281E+04, .1354849853516E+04},
 {    7398, .8296886718750E+04, -.1324821166992E+04, .1379188964844E+04},
 {    7399, .8286677734375E+04, -.1306068115234E+04, .1379823730469E+04},
 {    7400, .8283136718750E+04, -.1285002563477E+04, .1380044433594E+04},
 {    7401, .8281496093750E+04, -.1262635986328E+04, .1329247558594E+04},
 {    7402, .8296778320312E+04, -.1245410766602E+04, .1328297241211E+04},
 {    7403, .8283705078125E+04, -.1263179443359E+04, .1354559448242E+04},
 {    7404, .8295791992188E+04, -.1244538940430E+04, .1353807373047E+04},
 {    7405, .8286936523438E+04, -.1264376342773E+04, .1379807617188E+04},
 {    7406, .8297123046875E+04, -.1246052001953E+04, .1379173583984E+04},
 {    7407, .8396583007812E+04, -.1308452026367E+04, .1322087890625E+04},
 {    7408, .8396583007812E+04, -.1300832031250E+04, .1322087890625E+04},
 {    7409, .8396583007812E+04, -.1293212036133E+04, .1322087890625E+04},
 {    7410, .8396583007812E+04, -.1285592041016E+04, .1322087890625E+04},
 {    7411, .8416537109375E+04, -.1327764526367E+04, .1333570434570E+04},
 {    7412, .8397370117188E+04, -.1308452026367E+04, .1334763183594E+04},
 {    7413, .8428543945312E+04, -.1316176147461E+04, .1332823242188E+04},
 {    7414, .8397370117188E+04, -.1300832031250E+04, .1334762939453E+04},
 {    7415, .8436498046875E+04, -.1301495971680E+04, .1332328125000E+04},
 {    7416, .8397370117188E+04, -.1293212036133E+04, .1334762939453E+04},
 {    7417, .8439189453125E+04, -.1285011352539E+04, .1332161132812E+04},
 {    7418, .8397370117188E+04, -.1285592041016E+04, .1334762939453E+04},
 {    7419, .8396583007812E+04, -.1277972045898E+04, .1322087890625E+04},
 {    7420, .8396583007812E+04, -.1270352050781E+04, .1322087890625E+04},
 {    7421, .8396583007812E+04, -.1262732055664E+04, .1322087890625E+04},
 {    7422, .8436244140625E+04, -.1268958496094E+04, .1332344482422E+04},
 {    7423, .8397370117188E+04, -.1277972045898E+04, .1334762939453E+04},
 {    7424, .8428304687500E+04, -.1254706787109E+04, .1332838134766E+04},
 {    7425, .8397370117188E+04, -.1270352050781E+04, .1334762939453E+04},
 {    7426, .8416537109375E+04, -.1243419555664E+04, .1333570434570E+04},
 {    7427, .8397370117188E+04, -.1262732055664E+04, .1334762939453E+04},
 {    7428, .8389823242188E+04, -.1308452026367E+04, .1322508056641E+04},
 {    7429, .8383062500000E+04, -.1308452026367E+04, .1322928466797E+04},
 {    7430, .8376301757812E+04, -.1308452026367E+04, .1323349365234E+04},
 {    7431, .8404273437500E+04, -.1334692871094E+04, .1334333007812E+04},
 {    7432, .8390820312500E+04, -.1338843261719E+04, .1335170654297E+04},
 {    7433, .8376804687500E+04, -.1340198852539E+04, .1336042480469E+04},
 {    7434, .8390611328125E+04, -.1308452026367E+04, .1335182861328E+04},
 {    7435, .8383849609375E+04, -.1308452026367E+04, .1335604003906E+04},
 {    7436, .8377090820312E+04, -.1308452026367E+04, .1336024536133E+04},
 {    7437, .8389823242188E+04, -.1300832031250E+04, .1322508056641E+04},
 {    7438, .8383062500000E+04, -.1300832031250E+04, .1322928466797E+04},
 {    7439, .8376301757812E+04, -.1300832031250E+04, .1323349365234E+04},
 {    7440, .8389823242188E+04, -.1293212036133E+04, .1322508056641E+04},
 {    7441, .8383062500000E+04, -.1293212036133E+04, .1322928466797E+04},
 {    7442, .8376301757812E+04, -.1293212036133E+04, .1323349365234E+04},
 {    7443, .8389823242188E+04, -.1285592041016E+04, .1322508056641E+04},
 {    7444, .8383062500000E+04, -.1285592041016E+04, .1322928466797E+04},
 {    7445, .8376301757812E+04, -.1285592041016E+04, .1323349365234E+04},
 {    7446, .8390611328125E+04, -.1300832031250E+04, .1335182861328E+04},
 {    7447, .8383849609375E+04, -.1300832031250E+04, .1335604003906E+04},
 {    7448, .8377090820312E+04, -.1300832031250E+04, .1336024536133E+04},
 {    7449, .8390611328125E+04, -.1293212036133E+04, .1335182861328E+04},
 {    7450, .8383849609375E+04, -.1293212036133E+04, .1335604003906E+04},
 {    7451, .8377090820312E+04, -.1293212036133E+04, .1336024536133E+04},
 {    7452, .8390611328125E+04, -.1285592041016E+04, .1335182861328E+04},
 {    7453, .8383849609375E+04, -.1285592041016E+04, .1335604003906E+04},
 {    7454, .8377090820312E+04, -.1285592041016E+04, .1336024536133E+04},
 {    7455, .8389823242188E+04, -.1277972045898E+04, .1322508056641E+04},
 {    7456, .8383062500000E+04, -.1277972045898E+04, .1322928466797E+04},
 {    7457, .8376301757812E+04, -.1277972045898E+04, .1323349365234E+04},
 {    7458, .8389823242188E+04, -.1270352050781E+04, .1322508056641E+04},
 {    7459, .8383062500000E+04, -.1270352050781E+04, .1322928466797E+04},
 {    7460, .8376301757812E+04, -.1270352050781E+04, .1323349365234E+04},
 {    7461, .8389823242188E+04, -.1262732055664E+04, .1322508056641E+04},
 {    7462, .8383062500000E+04, -.1262732055664E+04, .1322928466797E+04},
 {    7463, .8376301757812E+04, -.1262732055664E+04, .1323349365234E+04},
 {    7464, .8390611328125E+04, -.1277972045898E+04, .1335182861328E+04},
 {    7465, .8383849609375E+04, -.1277972045898E+04, .1335604003906E+04},
 {    7466, .8377090820312E+04, -.1277972045898E+04, .1336024536133E+04},
 {    7467, .8390611328125E+04, -.1270352050781E+04, .1335182861328E+04},
 {    7468, .8383849609375E+04, -.1270352050781E+04, .1335604003906E+04},
 {    7469, .8377090820312E+04, -.1270352050781E+04, .1336024536133E+04},
 {    7470, .8390611328125E+04, -.1262732055664E+04, .1335182861328E+04},
 {    7471, .8383849609375E+04, -.1262732055664E+04, .1335604003906E+04},
 {    7472, .8377090820312E+04, -.1262732055664E+04, .1336024536133E+04},
 {    7473, .8404273437500E+04, -.1236491210938E+04, .1334333007812E+04},
 {    7474, .8390820312500E+04, -.1232340820312E+04, .1335170654297E+04},
 {    7475, .8376804687500E+04, -.1230985229492E+04, .1336042480469E+04},
 {    7476, .8361936523438E+04, -.1308452026367E+04, .1324243164062E+04},
 {    7477, .8347570312500E+04, -.1308452026367E+04, .1325136474609E+04},
 {    7478, .8333205078125E+04, -.1308452026367E+04, .1326030151367E+04},
 {    7479, .8357809570312E+04, -.1338767456055E+04, .1337224121094E+04},
 {    7480, .8339248046875E+04, -.1334473999023E+04, .1338379638672E+04},
 {    7481, .8321722656250E+04, -.1326990722656E+04, .1339469970703E+04},
 {    7482, .8362726562500E+04, -.1308452026367E+04, .1336918457031E+04},
 {    7483, .8348358398438E+04, -.1308452026367E+04, .1337812500000E+04},
 {    7484, .8333993164062E+04, -.1308452026367E+04, .1338706054688E+04},
 {    7485, .8361936523438E+04, -.1300832031250E+04, .1324243164062E+04},
 {    7486, .8347570312500E+04, -.1300832031250E+04, .1325136474609E+04},
 {    7487, .8333205078125E+04, -.1300832031250E+04, .1326030151367E+04},
 {    7488, .8361936523438E+04, -.1293212036133E+04, .1324243164062E+04},
 {    7489, .8347570312500E+04, -.1293212036133E+04, .1325136474609E+04},
 {    7490, .8333205078125E+04, -.1293212036133E+04, .1326030151367E+04},
 {    7491, .8361936523438E+04, -.1285592041016E+04, .1324243164062E+04},
 {    7492, .8347570312500E+04, -.1285592041016E+04, .1325136474609E+04},
 {    7493, .8333205078125E+04, -.1285592041016E+04, .1326030151367E+04},
 {    7494, .8362726562500E+04, -.1300832031250E+04, .1336918457031E+04},
 {    7495, .8348358398438E+04, -.1300832031250E+04, .1337812500000E+04},
 {    7496, .8333993164062E+04, -.1300832031250E+04, .1338706054688E+04},
 {    7497, .8362726562500E+04, -.1293212036133E+04, .1336918457031E+04},
 {    7498, .8348358398438E+04, -.1293212036133E+04, .1337812500000E+04},
 {    7499, .8333993164062E+04, -.1293212036133E+04, .1338706054688E+04},
 {    7500, .8362726562500E+04, -.1285592041016E+04, .1336918457031E+04},
 {    7501, .8348358398438E+04, -.1285592041016E+04, .1337812500000E+04},
 {    7502, .8333993164062E+04, -.1285592041016E+04, .1338706054688E+04},
 {    7503, .8361936523438E+04, -.1277972045898E+04, .1324243164062E+04},
 {    7504, .8347570312500E+04, -.1277972045898E+04, .1325136474609E+04},
 {    7505, .8333205078125E+04, -.1277972045898E+04, .1326030151367E+04},
 {    7506, .8361936523438E+04, -.1270352050781E+04, .1324243164062E+04},
 {    7507, .8347570312500E+04, -.1270352050781E+04, .1325136474609E+04},
 {    7508, .8333205078125E+04, -.1270352050781E+04, .1326030151367E+04},
 {    7509, .8361936523438E+04, -.1262732055664E+04, .1324243164062E+04},
 {    7510, .8347570312500E+04, -.1262732055664E+04, .1325136474609E+04},
 {    7511, .8333205078125E+04, -.1262732055664E+04, .1326030151367E+04},
 {    7512, .8362726562500E+04, -.1277972045898E+04, .1336918457031E+04},
 {    7513, .8348358398438E+04, -.1277972045898E+04, .1337812500000E+04},
 {    7514, .8333993164062E+04, -.1277972045898E+04, .1338706054688E+04},
 {    7515, .8362726562500E+04, -.1270352050781E+04, .1336918457031E+04},
 {    7516, .8348358398438E+04, -.1270352050781E+04, .1337812500000E+04},
 {    7517, .8333993164062E+04, -.1270352050781E+04, .1338706054688E+04},
 {    7518, .8362726562500E+04, -.1262732055664E+04, .1336918457031E+04},
 {    7519, .8348358398438E+04, -.1262732055664E+04, .1337812500000E+04},
 {    7520, .8333993164062E+04, -.1262732055664E+04, .1338706054688E+04},
 {    7521, .8357809570312E+04, -.1232416503906E+04, .1337224121094E+04},
 {    7522, .8339248046875E+04, -.1236710083008E+04, .1338379638672E+04},
 {    7523, .8321722656250E+04, -.1244193359375E+04, .1339469970703E+04},
 {    7524, .8307575195312E+04, -.1315470947266E+04, .1327625000000E+04},
 {    7525, .8295340820312E+04, -.1302585083008E+04, .1328386596680E+04},
 {    7526, .8290109375000E+04, -.1285592041016E+04, .1328711914062E+04},
 {    7527, .8307332031250E+04, -.1316724121094E+04, .1340365234375E+04},
 {    7528, .8296475585938E+04, -.1302757812500E+04, .1341040771484E+04},
 {    7529, .8292163085938E+04, -.1285592041016E+04, .1341308959961E+04},
 {    7530, .8295340820312E+04, -.1268598999023E+04, .1328386596680E+04},
 {    7531, .8307575195312E+04, -.1255713134766E+04, .1327625000000E+04},
 {    7532, .8296475585938E+04, -.1268426269531E+04, .1341040771484E+04},
 {    7533, .8307332031250E+04, -.1254459960938E+04, .1340365234375E+04},
 {    7534, .8369994140625E+04, -.1323692016602E+04, .1221945312500E+04},
 {    7535, .8369910156250E+04, -.1328770629883E+04, .1221950439453E+04},
 {    7536, .8360150390625E+04, -.1322393798828E+04, .1222557495117E+04},
 {    7537, .8358428710938E+04, -.1327356079102E+04, .1222663940430E+04},
 {    7538, .8350977539062E+04, -.1318587646484E+04, .1223127807617E+04},
 {    7539, .8347621093750E+04, -.1323220092773E+04, .1223337524414E+04},
 {    7540, .8343103515625E+04, -.1312532836914E+04, .1223618408203E+04},
 {    7541, .8338168945312E+04, -.1316535888672E+04, .1223925537109E+04},
 {    7542, .8337060546875E+04, -.1304642089844E+04, .1223994140625E+04},
 {    7543, .8330760742188E+04, -.1307634399414E+04, .1224385986328E+04},
 {    7544, .8333261718750E+04, -.1295453002930E+04, .1224230468750E+04},
 {    7545, .8326006835938E+04, -.1297067871094E+04, .1224681884766E+04},
 {    7546, .8331967773438E+04, -.1285592041016E+04, .1224311279297E+04},
 {    7547, .8324361328125E+04, -.1285595458984E+04, .1224784179688E+04},
 {    7548, .8333261718750E+04, -.1275731079102E+04, .1224230468750E+04},
 {    7549, .8326004882812E+04, -.1274122802734E+04, .1224682373047E+04},
 {    7550, .8337060546875E+04, -.1266541992188E+04, .1223994140625E+04},
 {    7551, .8330756835938E+04, -.1263555419922E+04, .1224386718750E+04},
 {    7552, .8343103515625E+04, -.1258651245117E+04, .1223618408203E+04},
 {    7553, .8338164062500E+04, -.1254652832031E+04, .1223925659180E+04},
 {    7554, .8350977539062E+04, -.1252596435547E+04, .1223127807617E+04},
 {    7555, .8347615234375E+04, -.1247967163086E+04, .1223338012695E+04},
 {    7556, .8360150390625E+04, -.1248790283203E+04, .1222557495117E+04},
 {    7557, .8358421875000E+04, -.1243829589844E+04, .1222664794922E+04},
 {    7558, .8369994140625E+04, -.1247492065430E+04, .1221945312500E+04},
 {    7559, .8369903320312E+04, -.1242413818359E+04, .1221950683594E+04},
 {    7560, .8371569335938E+04, -.1323692016602E+04, .1247296142578E+04},
 {    7561, .8371481445312E+04, -.1328770507812E+04, .1247301757812E+04},
 {    7562, .8361728515625E+04, -.1322393798828E+04, .1247909057617E+04},
 {    7563, .8360346679688E+04, -.1327275268555E+04, .1247993652344E+04},
 {    7564, .8352555664062E+04, -.1318587646484E+04, .1248478271484E+04},
 {    7565, .8349970703125E+04, -.1322956909180E+04, .1248640014648E+04},
 {    7566, .8344680664062E+04, -.1312532836914E+04, .1248969482422E+04},
 {    7567, .8341070312500E+04, -.1316089599609E+04, .1249193969727E+04},
 {    7568, .8338637695312E+04, -.1304642089844E+04, .1249344970703E+04},
 {    7569, .8334234375000E+04, -.1307157348633E+04, .1249618896484E+04},
 {    7570, .8334838867188E+04, -.1295453002930E+04, .1249581542969E+04},
 {    7571, .8329944335938E+04, -.1296753540039E+04, .1249885864258E+04},
 {    7572, .8333543945312E+04, -.1285592041016E+04, .1249662109375E+04},
 {    7573, .8328473632812E+04, -.1285594238281E+04, .1249978271484E+04},
 {    7574, .8334838867188E+04, -.1275731079102E+04, .1249581542969E+04},
 {    7575, .8329943359375E+04, -.1274434692383E+04, .1249885986328E+04},
 {    7576, .8338637695312E+04, -.1266541992188E+04, .1249344970703E+04},
 {    7577, .8334232421875E+04, -.1264030517578E+04, .1249619140625E+04},
 {    7578, .8344680664062E+04, -.1258651245117E+04, .1248969482422E+04},
 {    7579, .8341067382812E+04, -.1255097534180E+04, .1249194335938E+04},
 {    7580, .8352555664062E+04, -.1252596435547E+04, .1248478271484E+04},
 {    7581, .8349967773438E+04, -.1248229370117E+04, .1248640136719E+04},
 {    7582, .8361728515625E+04, -.1248790283203E+04, .1247909057617E+04},
 {    7583, .8360342773438E+04, -.1243909912109E+04, .1247994873047E+04},
 {    7584, .8371569335938E+04, -.1247492065430E+04, .1247296142578E+04},
 {    7585, .8371477539062E+04, -.1242413818359E+04, .1247302246094E+04},
 {    7586, .8372358398438E+04, -.1323692016602E+04, .1259971923828E+04},
 {    7587, .8372272460938E+04, -.1328770507812E+04, .1259976806641E+04},
 {    7588, .8362516601562E+04, -.1322393798828E+04, .1260583618164E+04},
 {    7589, .8360963867188E+04, -.1327316894531E+04, .1260681396484E+04},
 {    7590, .8353346679688E+04, -.1318587646484E+04, .1261154785156E+04},
 {    7591, .8350372070312E+04, -.1323092651367E+04, .1261339599609E+04},
 {    7592, .8345470703125E+04, -.1312532836914E+04, .1261644653320E+04},
 {    7593, .8341194335938E+04, -.1316316162109E+04, .1261911132812E+04},
 {    7594, .8339426757812E+04, -.1304642089844E+04, .1262020629883E+04},
 {    7595, .8334071289062E+04, -.1307397583008E+04, .1262353515625E+04},
 {    7596, .8335627929688E+04, -.1295453002930E+04, .1262257568359E+04},
 {    7597, .8329552734375E+04, -.1296910400391E+04, .1262635253906E+04},
 {    7598, .8334331054688E+04, -.1285592041016E+04, .1262337646484E+04},
 {    7599, .8327995117188E+04, -.1285594848633E+04, .1262732177734E+04},
 {    7600, .8335627929688E+04, -.1275731079102E+04, .1262257568359E+04},
 {    7601, .8329550781250E+04, -.1274279052734E+04, .1262635009766E+04},
 {    7602, .8339426757812E+04, -.1266541992188E+04, .1262020629883E+04},
 {    7603, .8334069335938E+04, -.1263791259766E+04, .1262354003906E+04},
 {    7604, .8345470703125E+04, -.1258651245117E+04, .1261644653320E+04},
 {    7605, .8341190429688E+04, -.1254871826172E+04, .1261911010742E+04},
 {    7606, .8353346679688E+04, -.1252596435547E+04, .1261154785156E+04},
 {    7607, .8350368164062E+04, -.1248094116211E+04, .1261340209961E+04},
 {    7608, .8362516601562E+04, -.1248790283203E+04, .1260583618164E+04},
 {    7609, .8360958007812E+04, -.1243868530273E+04, .1260681274414E+04},
 {    7610, .8372358398438E+04, -.1247492065430E+04, .1259971923828E+04},
 {    7611, .8372266601562E+04, -.1242413818359E+04, .1259977905273E+04},
 {    7612, .8373148437500E+04, -.1323692016602E+04, .1272647583008E+04},
 {    7613, .8373076171875E+04, -.1328770996094E+04, .1272651367188E+04},
 {    7614, .8363305664062E+04, -.1322393798828E+04, .1273259643555E+04},
 {    7615, .8360541992188E+04, -.1327540771484E+04, .1273431640625E+04},
 {    7616, .8354134765625E+04, -.1318587646484E+04, .1273830200195E+04},
 {    7617, .8348495117188E+04, -.1323859619141E+04, .1274180908203E+04},
 {    7618, .8346257812500E+04, -.1312532836914E+04, .1274320312500E+04},
 {    7619, .8337518554688E+04, -.1317677124023E+04, .1274863647461E+04},
 {    7620, .8340215820312E+04, -.1304641967773E+04, .1274696411133E+04},
 {    7621, .8328399414062E+04, -.1308974975586E+04, .1275430908203E+04},
 {    7622, .8336416992188E+04, -.1295453002930E+04, .1274932617188E+04},
 {    7623, .8322166992188E+04, -.1298011474609E+04, .1275819091797E+04},
 {    7624, .8335121093750E+04, -.1285592041016E+04, .1275013305664E+04},
 {    7625, .8319910156250E+04, -.1285598388672E+04, .1275959716797E+04},
 {    7626, .8336416992188E+04, -.1275731079102E+04, .1274932617188E+04},
 {    7627, .8322162109375E+04, -.1273184448242E+04, .1275818847656E+04},
 {    7628, .8340215820312E+04, -.1266541992188E+04, .1274696411133E+04},
 {    7629, .8328391601562E+04, -.1262218994141E+04, .1275431396484E+04},
 {    7630, .8346257812500E+04, -.1258651245117E+04, .1274320312500E+04},
 {    7631, .8337508789062E+04, -.1253514648438E+04, .1274864501953E+04},
 {    7632, .8354134765625E+04, -.1252596435547E+04, .1273830200195E+04},
 {    7633, .8348483398438E+04, -.1247329345703E+04, .1274182373047E+04},
 {    7634, .8363305664062E+04, -.1248790283203E+04, .1273259643555E+04},
 {    7635, .8360529296875E+04, -.1243645629883E+04, .1273432861328E+04},
 {    7636, .8373148437500E+04, -.1247492065430E+04, .1272647583008E+04},
 {    7637, .8373063476562E+04, -.1242413696289E+04, .1272652587891E+04},
 {    7638, .8373935546875E+04, -.1323692016602E+04, .1285322753906E+04},
 {    7639, .8373880859375E+04, -.1328771484375E+04, .1285326049805E+04},
 {    7640, .8364093750000E+04, -.1322393798828E+04, .1285935424805E+04},
 {    7641, .8358826171875E+04, -.1327779052734E+04, .1286262451172E+04},
 {    7642, .8354922851562E+04, -.1318587646484E+04, .1286505859375E+04},
 {    7643, .8344044921875E+04, -.1324749267578E+04, .1287182373047E+04},
 {    7644, .8347049804688E+04, -.1312532836914E+04, .1286995239258E+04},
 {    7645, .8329909179688E+04, -.1319458007812E+04, .1288061523438E+04},
 {    7646, .8341003906250E+04, -.1304641967773E+04, .1287371826172E+04},
 {    7647, .8317107421875E+04, -.1311455444336E+04, .1288858642578E+04},
 {    7648, .8337206054688E+04, -.1295453002930E+04, .1287608154297E+04},
 {    7649, .8307105468750E+04, -.1300135498047E+04, .1289480712891E+04},
 {    7650, .8335910156250E+04, -.1285592041016E+04, .1287688964844E+04},
 {    7651, .8302954101562E+04, -.1285601684570E+04, .1289739135742E+04},
 {    7652, .8337206054688E+04, -.1275731079102E+04, .1287608154297E+04},
 {    7653, .8307095703125E+04, -.1271064941406E+04, .1289481445312E+04},
 {    7654, .8341003906250E+04, -.1266541992188E+04, .1287371826172E+04},
 {    7655, .8317092773438E+04, -.1259740356445E+04, .1288859497070E+04},
 {    7656, .8347049804688E+04, -.1258651245117E+04, .1286995239258E+04},
 {    7657, .8329892578125E+04, -.1251734375000E+04, .1288062744141E+04},
 {    7658, .8354922851562E+04, -.1252596435547E+04, .1286505859375E+04},
 {    7659, .8344026367188E+04, -.1246439941406E+04, .1287183837891E+04},
 {    7660, .8364093750000E+04, -.1248790283203E+04, .1285935424805E+04},
 {    7661, .8358807617188E+04, -.1243407592773E+04, .1286263916016E+04},
 {    7662, .8373935546875E+04, -.1247492065430E+04, .1285322753906E+04},
 {    7663, .8373863281250E+04, -.1242413330078E+04, .1285327392578E+04},
 {    7664, .8374723632812E+04, -.1323692016602E+04, .1297997802734E+04},
 {    7665, .8374642578125E+04, -.1331311157227E+04, .1298003662109E+04},
 {    7666, .8364881835938E+04, -.1322393798828E+04, .1298610839844E+04},
 {    7667, .8358941406250E+04, -.1330241577148E+04, .1298980224609E+04},
 {    7668, .8355709960938E+04, -.1318587646484E+04, .1299182006836E+04},
 {    7669, .8343544921875E+04, -.1326989135742E+04, .1299938232422E+04},
 {    7670, .8347834960938E+04, -.1312532836914E+04, .1299671875000E+04},
 {    7671, .8328863281250E+04, -.1321317871094E+04, .1300851562500E+04},
 {    7672, .8341792968750E+04, -.1304641967773E+04, .1300046875000E+04},
 {    7673, .8315631835938E+04, -.1312783081055E+04, .1301674804688E+04},
 {    7674, .8337995117188E+04, -.1295453002930E+04, .1300283081055E+04},
 {    7675, .8305403320312E+04, -.1300801879883E+04, .1302311035156E+04},
 {    7676, .8336699218750E+04, -.1285592041016E+04, .1300364257812E+04},
 {    7677, .8301206054688E+04, -.1285606811523E+04, .1302572265625E+04},
 {    7678, .8337995117188E+04, -.1275731079102E+04, .1300283081055E+04},
 {    7679, .8305389648438E+04, -.1270407714844E+04, .1302312011719E+04},
 {    7680, .8341792968750E+04, -.1266541992188E+04, .1300046875000E+04},
 {    7681, .8315609375000E+04, -.1258419433594E+04, .1301676513672E+04},
 {    7682, .8347834960938E+04, -.1258651245117E+04, .1299671875000E+04},
 {    7683, .8328836914062E+04, -.1249879150391E+04, .1300853515625E+04},
 {    7684, .8355709960938E+04, -.1252596435547E+04, .1299182006836E+04},
 {    7685, .8343517578125E+04, -.1244203125000E+04, .1299939941406E+04},
 {    7686, .8364881835938E+04, -.1248790283203E+04, .1298610839844E+04},
 {    7687, .8358913085938E+04, -.1240946533203E+04, .1298982421875E+04},
 {    7688, .8374723632812E+04, -.1247492065430E+04, .1297997802734E+04},
 {    7689, .8374612304688E+04, -.1239874145508E+04, .1298005126953E+04},
 {    7690, .8376301757812E+04, -.1323692016602E+04, .1323349365234E+04},
 {    7691, .8376186523438E+04, -.1335120849609E+04, .1323356689453E+04},
 {    7692, .8366458984375E+04, -.1322393798828E+04, .1323962402344E+04},
 {    7693, .8358232421875E+04, -.1334020263672E+04, .1324473632812E+04},
 {    7694, .8357288085938E+04, -.1318587646484E+04, .1324532470703E+04},
 {    7695, .8340564453125E+04, -.1330657714844E+04, .1325572753906E+04},
 {    7696, .8349412109375E+04, -.1312532836914E+04, .1325021728516E+04},
 {    7697, .8323565429688E+04, -.1324765136719E+04, .1326630737305E+04},
 {    7698, .8343369140625E+04, -.1304641967773E+04, .1325397949219E+04},
 {    7699, .8307975585938E+04, -.1315777221680E+04, .1327599853516E+04},
 {    7700, .8339570312500E+04, -.1295453002930E+04, .1325634277344E+04},
 {    7701, .8295489257812E+04, -.1302806030273E+04, .1328377197266E+04},
 {    7702, .8338275390625E+04, -.1285592041016E+04, .1325714721680E+04},
 {    7703, .8339570312500E+04, -.1275730957031E+04, .1325634277344E+04},
 {    7704, .8295469726562E+04, -.1268407592773E+04, .1328378906250E+04},
 {    7705, .8343369140625E+04, -.1266541992188E+04, .1325397949219E+04},
 {    7706, .8307948242188E+04, -.1255428222656E+04, .1327602294922E+04},
 {    7707, .8349412109375E+04, -.1258651245117E+04, .1325021728516E+04},
 {    7708, .8323534179688E+04, -.1246432983398E+04, .1326632080078E+04},
 {    7709, .8357288085938E+04, -.1252596435547E+04, .1324532470703E+04},
 {    7710, .8340530273438E+04, -.1240535400391E+04, .1325574951172E+04},
 {    7711, .8366458984375E+04, -.1248790283203E+04, .1323962402344E+04},
 {    7712, .8358198242188E+04, -.1237168457031E+04, .1324475585938E+04},
 {    7713, .8376301757812E+04, -.1247492065430E+04, .1323349365234E+04},
 {    7714, .8376151367188E+04, -.1236064453125E+04, .1323358520508E+04},
 {    7715, .8379835937500E+04, -.1248790283203E+04, .1221332153320E+04},
 {    7716, .8380557617188E+04, -.1244006713867E+04, .1221288085938E+04},
 {    7717, .8389005859375E+04, -.1252596435547E+04, .1220762451172E+04},
 {    7718, .8390294921875E+04, -.1248629394531E+04, .1220682006836E+04},
 {    7719, .8396881835938E+04, -.1258651245117E+04, .1220272338867E+04},
 {    7720, .8398389648438E+04, -.1255752075195E+04, .1220178710938E+04},
 {    7721, .8402924804688E+04, -.1266541992188E+04, .1219895629883E+04},
 {    7722, .8404384765625E+04, -.1264721435547E+04, .1219805786133E+04},
 {    7723, .8406723632812E+04, -.1275731079102E+04, .1219660034180E+04},
 {    7724, .8408052734375E+04, -.1274871582031E+04, .1219577270508E+04},
 {    7725, .8408020507812E+04, -.1285592041016E+04, .1219579345703E+04},
 {    7726, .8409285156250E+04, -.1285595336914E+04, .1219500488281E+04},
 {    7727, .8406723632812E+04, -.1295453002930E+04, .1219660034180E+04},
 {    7728, .8408052734375E+04, -.1296318969727E+04, .1219577270508E+04},
 {    7729, .8402924804688E+04, -.1304642089844E+04, .1219895629883E+04},
 {    7730, .8404381835938E+04, -.1306468627930E+04, .1219805664062E+04},
 {    7731, .8396881835938E+04, -.1312532836914E+04, .1220272338867E+04},
 {    7732, .8398385742188E+04, -.1315437133789E+04, .1220178955078E+04},
 {    7733, .8389004882812E+04, -.1318587646484E+04, .1220762451172E+04},
 {    7734, .8390290039062E+04, -.1322558349609E+04, .1220682128906E+04},
 {    7735, .8379835937500E+04, -.1322393798828E+04, .1221332397461E+04},
 {    7736, .8380551757812E+04, -.1327179321289E+04, .1221287963867E+04},
 {    7737, .8381411132812E+04, -.1248790283203E+04, .1246684326172E+04},
 {    7738, .8382133789062E+04, -.1244006103516E+04, .1246639160156E+04},
 {    7739, .8390583007812E+04, -.1252596435547E+04, .1246113159180E+04},
 {    7740, .8391872070312E+04, -.1248628295898E+04, .1246032958984E+04},
 {    7741, .8398461914062E+04, -.1258651245117E+04, .1245623046875E+04},
 {    7742, .8399967773438E+04, -.1255750732422E+04, .1245529296875E+04},
 {    7743, .8404502929688E+04, -.1266541992188E+04, .1245247314453E+04},
 {    7744, .8405961914062E+04, -.1264719970703E+04, .1245156494141E+04},
 {    7745, .8408301757812E+04, -.1275731079102E+04, .1245010498047E+04},
 {    7746, .8409628906250E+04, -.1274870239258E+04, .1244928222656E+04},
 {    7747, .8409595703125E+04, -.1285592041016E+04, .1244930419922E+04},
 {    7748, .8410863281250E+04, -.1285594116211E+04, .1244851806641E+04},
 {    7749, .8408301757812E+04, -.1295453002930E+04, .1245010498047E+04},
 {    7750, .8409627929688E+04, -.1296317993164E+04, .1244928466797E+04},
 {    7751, .8404502929688E+04, -.1304642089844E+04, .1245247314453E+04},
 {    7752, .8405958984375E+04, -.1306467895508E+04, .1245156250000E+04},
 {    7753, .8398461914062E+04, -.1312532836914E+04, .1245623046875E+04},
 {    7754, .8399965820312E+04, -.1315436645508E+04, .1245529418945E+04},
 {    7755, .8390583007812E+04, -.1318587646484E+04, .1246113159180E+04},
 {    7756, .8391869140625E+04, -.1322558105469E+04, .1246033325195E+04},
 {    7757, .8381411132812E+04, -.1322393798828E+04, .1246684326172E+04},
 {    7758, .8382129882812E+04, -.1327179199219E+04, .1246638671875E+04},
 {    7759, .8382202148438E+04, -.1248790283203E+04, .1259359130859E+04},
 {    7760, .8382924804688E+04, -.1244006347656E+04, .1259314453125E+04},
 {    7761, .8391372070312E+04, -.1252596435547E+04, .1258788085938E+04},
 {    7762, .8392662109375E+04, -.1248628906250E+04, .1258708496094E+04},
 {    7763, .8399248046875E+04, -.1258651245117E+04, .1258299316406E+04},
 {    7764, .8400754882812E+04, -.1255751464844E+04, .1258204833984E+04},
 {    7765, .8405288085938E+04, -.1266541992188E+04, .1257923095703E+04},
 {    7766, .8406750000000E+04, -.1264720825195E+04, .1257831542969E+04},
 {    7767, .8409087890625E+04, -.1275731079102E+04, .1257686523438E+04},
 {    7768, .8410417968750E+04, -.1274870971680E+04, .1257603759766E+04},
 {    7769, .8410385742188E+04, -.1285592041016E+04, .1257605712891E+04},
 {    7770, .8411650390625E+04, -.1285594848633E+04, .1257526611328E+04},
 {    7771, .8409087890625E+04, -.1295453002930E+04, .1257686523438E+04},
 {    7772, .8410416992188E+04, -.1296318481445E+04, .1257603759766E+04},
 {    7773, .8405288085938E+04, -.1304642089844E+04, .1257923095703E+04},
 {    7774, .8406748046875E+04, -.1306468261719E+04, .1257832275391E+04},
 {    7775, .8399248046875E+04, -.1312532836914E+04, .1258299316406E+04},
 {    7776, .8400750976562E+04, -.1315436889648E+04, .1258205200195E+04},
 {    7777, .8391372070312E+04, -.1318587646484E+04, .1258788085938E+04},
 {    7778, .8392656250000E+04, -.1322558227539E+04, .1258708740234E+04},
 {    7779, .8382202148438E+04, -.1322393798828E+04, .1259359130859E+04},
 {    7780, .8382920898438E+04, -.1327179199219E+04, .1259314697266E+04},
 {    7781, .8382988281250E+04, -.1248790283203E+04, .1272035156250E+04},
 {    7782, .8383718750000E+04, -.1244008178711E+04, .1271989624023E+04},
 {    7783, .8392161132812E+04, -.1252596435547E+04, .1271464355469E+04},
 {    7784, .8393453125000E+04, -.1248632202148E+04, .1271383544922E+04},
 {    7785, .8400035156250E+04, -.1258651245117E+04, .1270975219727E+04},
 {    7786, .8401545898438E+04, -.1255755493164E+04, .1270881103516E+04},
 {    7787, .8406077148438E+04, -.1266541992188E+04, .1270598754883E+04},
 {    7788, .8407541015625E+04, -.1264725097656E+04, .1270507324219E+04},
 {    7789, .8409875976562E+04, -.1275731079102E+04, .1270362548828E+04},
 {    7790, .8411208007812E+04, -.1274875000000E+04, .1270278808594E+04},
 {    7791, .8411173828125E+04, -.1285592041016E+04, .1270281494141E+04},
 {    7792, .8412440429688E+04, -.1285598388672E+04, .1270202148438E+04},
 {    7793, .8409875976562E+04, -.1295453002930E+04, .1270362548828E+04},
 {    7794, .8411205078125E+04, -.1296321411133E+04, .1270279052734E+04},
 {    7795, .8406077148438E+04, -.1304642089844E+04, .1270598754883E+04},
 {    7796, .8407536132812E+04, -.1306470458984E+04, .1270507568359E+04},
 {    7797, .8400035156250E+04, -.1312532836914E+04, .1270975219727E+04},
 {    7798, .8401538085938E+04, -.1315438232422E+04, .1270881591797E+04},
 {    7799, .8392161132812E+04, -.1318587646484E+04, .1271464355469E+04},
 {    7800, .8393442382812E+04, -.1322558837891E+04, .1271384277344E+04},
 {    7801, .8382988281250E+04, -.1322393798828E+04, .1272035156250E+04},
 {    7802, .8383707031250E+04, -.1327179443359E+04, .1271990722656E+04},
 {    7803, .8383777343750E+04, -.1248790283203E+04, .1284710449219E+04},
 {    7804, .8384860351562E+04, -.1243917114258E+04, .1284642822266E+04},
 {    7805, .8392949218750E+04, -.1252596435547E+04, .1284139892578E+04},
 {    7806, .8395051757812E+04, -.1248320922852E+04, .1284009277344E+04},
 {    7807, .8400823242188E+04, -.1258651245117E+04, .1283649902344E+04},
 {    7808, .8403710937500E+04, -.1255272949219E+04, .1283470458984E+04},
 {    7809, .8406867187500E+04, -.1266541992188E+04, .1283273925781E+04},
 {    7810, .8410284179688E+04, -.1264232299805E+04, .1283060791016E+04},
 {    7811, .8410666015625E+04, -.1275731079102E+04, .1283037231445E+04},
 {    7812, .8414372070312E+04, -.1274569824219E+04, .1282806884766E+04},
 {    7813, .8411963867188E+04, -.1285592041016E+04, .1282956787109E+04},
 {    7814, .8415763671875E+04, -.1285601440430E+04, .1282720703125E+04},
 {    7815, .8410666015625E+04, -.1295453002930E+04, .1283037231445E+04},
 {    7816, .8414367187500E+04, -.1296632568359E+04, .1282807128906E+04},
 {    7817, .8406867187500E+04, -.1304642089844E+04, .1283273925781E+04},
 {    7818, .8410275390625E+04, -.1306968383789E+04, .1283061035156E+04},
 {    7819, .8400823242188E+04, -.1312532836914E+04, .1283649902344E+04},
 {    7820, .8403697265625E+04, -.1315924682617E+04, .1283471679688E+04},
 {    7821, .8392949218750E+04, -.1318587646484E+04, .1284139892578E+04},
 {    7822, .8395036132812E+04, -.1322873046875E+04, .1284010009766E+04},
 {    7823, .8383777343750E+04, -.1322393798828E+04, .1284710449219E+04},
 {    7824, .8384841796875E+04, -.1327271972656E+04, .1284643798828E+04},
 {    7825, .8373843750000E+04, -.1328770385742E+04, .1285328369141E+04},
 {    7826, .8384567382812E+04, -.1248790283203E+04, .1297385253906E+04},
 {    7827, .8386103515625E+04, -.1241500732422E+04, .1297291137695E+04},
 {    7828, .8393738281250E+04, -.1252596435547E+04, .1296815429688E+04},
 {    7829, .8396688476562E+04, -.1246261962891E+04, .1296631591797E+04},
 {    7830, .8401612304688E+04, -.1258651245117E+04, .1296325439453E+04},
 {    7831, .8405602539062E+04, -.1253702514648E+04, .1296076904297E+04},
 {    7832, .8407656250000E+04, -.1266541992188E+04, .1295949707031E+04},
 {    7833, .8412291992188E+04, -.1263201660156E+04, .1295660888672E+04},
 {    7834, .8411454101562E+04, -.1275731079102E+04, .1295713134766E+04},
 {    7835, .8416422851562E+04, -.1274065673828E+04, .1295403808594E+04},
 {    7836, .8412751953125E+04, -.1285592041016E+04, .1295633056641E+04},
 {    7837, .8417820312500E+04, -.1285606567383E+04, .1295317138672E+04},
 {    7838, .8411454101562E+04, -.1295453002930E+04, .1295713134766E+04},
 {    7839, .8416416015625E+04, -.1297146606445E+04, .1295404296875E+04},
 {    7840, .8407656250000E+04, -.1304641967773E+04, .1295949707031E+04},
 {    7841, .8412279296875E+04, -.1308008178711E+04, .1295661621094E+04},
 {    7842, .8401612304688E+04, -.1312532836914E+04, .1296325439453E+04},
 {    7843, .8405582031250E+04, -.1317502807617E+04, .1296078369141E+04},
 {    7844, .8393738281250E+04, -.1318587646484E+04, .1296815429688E+04},
 {    7845, .8396664062500E+04, -.1324937744141E+04, .1296633056641E+04},
 {    7846, .8384567382812E+04, -.1322393798828E+04, .1297385253906E+04},
 {    7847, .8386076171875E+04, -.1329691406250E+04, .1297292480469E+04},
 {    7848, .8374583984375E+04, -.1331309448242E+04, .1298006591797E+04},
 {    7849, .8386143554688E+04, -.1248790283203E+04, .1322736572266E+04},
 {    7850, .8389496093750E+04, -.1237611694336E+04, .1322528808594E+04},
 {    7851, .8395316406250E+04, -.1252596435547E+04, .1322166015625E+04},
 {    7852, .8402095703125E+04, -.1242272705078E+04, .1321744506836E+04},
 {    7853, .8403189453125E+04, -.1258651245117E+04, .1321675903320E+04},
 {    7854, .8413180664062E+04, -.1249873901367E+04, .1321054809570E+04},
 {    7855, .8409233398438E+04, -.1266541992188E+04, .1321300292969E+04},
 {    7856, .8421928710938E+04, -.1260086669922E+04, .1320510253906E+04},
 {    7857, .8413033203125E+04, -.1275731079102E+04, .1321063720703E+04},
 {    7858, .8427578125000E+04, -.1272295776367E+04, .1320159179688E+04},
 {    7859, .8414328125000E+04, -.1285592041016E+04, .1320983398438E+04},
 {    7860, .8429538085938E+04, -.1285609863281E+04, .1320037109375E+04},
 {    7861, .8413033203125E+04, -.1295453002930E+04, .1321063720703E+04},
 {    7862, .8427568359375E+04, -.1298922485352E+04, .1320159912109E+04},
 {    7863, .8409233398438E+04, -.1304641967773E+04, .1321300292969E+04},
 {    7864, .8421909179688E+04, -.1311127197266E+04, .1320512207031E+04},
 {    7865, .8403189453125E+04, -.1312532836914E+04, .1321675903320E+04},
 {    7866, .8413153320312E+04, -.1321333374023E+04, .1321057006836E+04},
 {    7867, .8395316406250E+04, -.1318587646484E+04, .1322166015625E+04},
 {    7868, .8402063476562E+04, -.1328927612305E+04, .1321746337891E+04},
 {    7869, .8386143554688E+04, -.1322393798828E+04, .1322736572266E+04},
 {    7870, .8389460937500E+04, -.1333580932617E+04, .1322531005859E+04},
 {    7871, .8376116210938E+04, -.1335119018555E+04, .1323360839844E+04},
 {    7872, .8369833984375E+04, -.1333849487305E+04, .1221955566406E+04},
 {    7873, .8356708984375E+04, -.1332319824219E+04, .1222771850586E+04},
 {    7874, .8344273437500E+04, -.1327838256836E+04, .1223545654297E+04},
 {    7875, .8333261718750E+04, -.1320519531250E+04, .1224230468750E+04},
 {    7876, .8324483398438E+04, -.1310622680664E+04, .1224776977539E+04},
 {    7877, .8318759765625E+04, -.1298691284180E+04, .1225133300781E+04},
 {    7878, .8316754882812E+04, -.1285604614258E+04, .1225257568359E+04},
 {    7879, .8318751953125E+04, -.1272516967773E+04, .1225132812500E+04},
 {    7880, .8324470703125E+04, -.1260582397461E+04, .1224777832031E+04},
 {    7881, .8333245117188E+04, -.1250680786133E+04, .1224231445312E+04},
 {    7882, .8344250976562E+04, -.1243357055664E+04, .1223546630859E+04},
 {    7883, .8356684570312E+04, -.1238870117188E+04, .1222773681641E+04},
 {    7884, .8369809570312E+04, -.1237335937500E+04, .1221956909180E+04},
 {    7885, .8371426757812E+04, -.1332579711914E+04, .1247305175781E+04},
 {    7886, .8358800781250E+04, -.1331060913086E+04, .1248090454102E+04},
 {    7887, .8346876953125E+04, -.1326624877930E+04, .1248832641602E+04},
 {    7888, .8336383789062E+04, -.1319424438477E+04, .1249484863281E+04},
 {    7889, .8328097656250E+04, -.1309759643555E+04, .1250000732422E+04},
 {    7890, .8322735351562E+04, -.1298205444336E+04, .1250334350586E+04},
 {    7891, .8320869140625E+04, -.1285601074219E+04, .1250449951172E+04},
 {    7892, .8322729492188E+04, -.1272995849609E+04, .1250334960938E+04},
 {    7893, .8328087890625E+04, -.1261439453125E+04, .1250001464844E+04},
 {    7894, .8336370117188E+04, -.1251771362305E+04, .1249486083984E+04},
 {    7895, .8346861328125E+04, -.1244567382812E+04, .1248833984375E+04},
 {    7896, .8358783203125E+04, -.1240127441406E+04, .1248091552734E+04},
 {    7897, .8371408203125E+04, -.1238605224609E+04, .1247306396484E+04},
 {    7898, .8372208007812E+04, -.1332579467773E+04, .1259980468750E+04},
 {    7899, .8359929687500E+04, -.1330983154297E+04, .1260745605469E+04},
 {    7900, .8348434570312E+04, -.1326372436523E+04, .1261460449219E+04},
 {    7901, .8338485351562E+04, -.1318988891602E+04, .1262079711914E+04},
 {    7902, .8330767578125E+04, -.1309286621094E+04, .1262559570312E+04},
 {    7903, .8325877929688E+04, -.1297889282227E+04, .1262863281250E+04},
 {    7904, .8324191406250E+04, -.1285599121094E+04, .1262968994141E+04},
 {    7905, .8325874023438E+04, -.1273308349609E+04, .1262864013672E+04},
 {    7906, .8330759765625E+04, -.1261909423828E+04, .1262560302734E+04},
 {    7907, .8338475585938E+04, -.1252205078125E+04, .1262079956055E+04},
 {    7908, .8348422851562E+04, -.1244818359375E+04, .1261460937500E+04},
 {    7909, .8359916015625E+04, -.1240204589844E+04, .1260746826172E+04},
 {    7910, .8372193359375E+04, -.1238605346680E+04, .1259981933594E+04},
 {    7911, .8373028320312E+04, -.1332580444336E+04, .1272654785156E+04},
 {    7912, .8358991210938E+04, -.1331286743164E+04, .1273528686523E+04},
 {    7913, .8345434570312E+04, -.1327417358398E+04, .1274371337891E+04},
 {    7914, .8332955078125E+04, -.1320859741211E+04, .1275147705078E+04},
 {    7915, .8322397460938E+04, -.1311500854492E+04, .1275804809570E+04},
 {    7916, .8315026367188E+04, -.1299463867188E+04, .1276262695312E+04},
 {    7917, .8312303710938E+04, -.1285607055664E+04, .1276433105469E+04},
 {    7918, .8315015625000E+04, -.1271747924805E+04, .1276263671875E+04},
 {    7919, .8322376953125E+04, -.1259706054688E+04, .1275805664062E+04},
 {    7920, .8332929687500E+04, -.1250340942383E+04, .1275149414062E+04},
 {    7921, .8345407226562E+04, -.1243777587891E+04, .1274373291016E+04},
 {    7922, .8358962890625E+04, -.1239902465820E+04, .1273529785156E+04},
 {    7923, .8372999023438E+04, -.1238604980469E+04, .1272656738281E+04},
 {    7924, .8373847656250E+04, -.1332581176758E+04, .1285328491211E+04},
 {    7925, .8356538085938E+04, -.1331554687500E+04, .1286405273438E+04},
 {    7926, .8339485351562E+04, -.1328408325195E+04, .1287466186523E+04},
 {    7927, .8323044921875E+04, -.1322880615234E+04, .1288488769531E+04},
 {    7928, .8307890625000E+04, -.1314432373047E+04, .1289432373047E+04},
 {    7929, .8295644531250E+04, -.1302133300781E+04, .1290193847656E+04},
 {    7930, .8290279296875E+04, -.1285611572266E+04, .1290527832031E+04},
 {    7931, .8295621093750E+04, -.1269082763672E+04, .1290195312500E+04},
 {    7932, .8307859375000E+04, -.1256774780273E+04, .1289433593750E+04},
 {    7933, .8323009765625E+04, -.1248318481445E+04, .1288491455078E+04},
 {    7934, .8339448242188E+04, -.1242785400391E+04, .1287468505859E+04},
 {    7935, .8356500000000E+04, -.1239634277344E+04, .1286407226562E+04},
 {    7936, .8373810546875E+04, -.1238604370117E+04, .1285330444336E+04},
 {    7937, .8374594726562E+04, -.1336390625000E+04, .1298005615234E+04},
 {    7938, .8356506835938E+04, -.1335241455078E+04, .1299132080078E+04},
 {    7939, .8338721679688E+04, -.1331740478516E+04, .1300237792969E+04},
 {    7940, .8321659179688E+04, -.1325622070312E+04, .1301300537109E+04},
 {    7941, .8306091796875E+04, -.1316313232422E+04, .1302268432617E+04},
 {    7942, .8293757812500E+04, -.1303009887695E+04, .1303036132812E+04},
 {    7943, .8288531250000E+04, -.1285621337891E+04, .1303360961914E+04},
 {    7944, .8293726562500E+04, -.1268223144531E+04, .1303038085938E+04},
 {    7945, .8306046875000E+04, -.1254906494141E+04, .1302271728516E+04},
 {    7946, .8321606445312E+04, -.1245586914062E+04, .1301303466797E+04},
 {    7947, .8338665039062E+04, -.1239458862305E+04, .1300241455078E+04},
 {    7948, .8356449218750E+04, -.1235950439453E+04, .1299135253906E+04},
 {    7949, .8374537109375E+04, -.1234795654297E+04, .1298009277344E+04},
 {    7950, .8376098632812E+04, -.1342739868164E+04, .1323361572266E+04},
 {    7951, .8356219726562E+04, -.1341411499023E+04, .1324598632812E+04},
 {    7952, .8336704101562E+04, -.1337390014648E+04, .1325812866211E+04},
 {    7953, .8318045898438E+04, -.1330377441406E+04, .1326973754883E+04},
 {    7954, .8301160156250E+04, -.1319784545898E+04, .1328023925781E+04},
 {    7955, .8287976562500E+04, -.1304815185547E+04, .1328844604492E+04},
 {    7956, .8282505859375E+04, -.1285619995117E+04, .1329185180664E+04},
 {    7957, .8287950195312E+04, -.1266416870117E+04, .1328846435547E+04},
 {    7958, .8301117187500E+04, -.1251434082031E+04, .1328027832031E+04},
 {    7959, .8317998046875E+04, -.1240830810547E+04, .1326977172852E+04},
 {    7960, .8336650390625E+04, -.1233808959961E+04, .1325816162109E+04},
 {    7961, .8356164062500E+04, -.1229780151367E+04, .1324602050781E+04},
 {    7962, .8376044921875E+04, -.1228446289062E+04, .1323365234375E+04},
 {    7963, .8381285156250E+04, -.1239242187500E+04, .1221243041992E+04},
 {    7964, .8391553710938E+04, -.1244717529297E+04, .1220604003906E+04},
 {    7965, .8399831054688E+04, -.1252909912109E+04, .1220088500977E+04},
 {    7966, .8405796875000E+04, -.1262915771484E+04, .1219718261719E+04},
 {    7967, .8409368164062E+04, -.1274009399414E+04, .1219495361328E+04},
 {    7968, .8410552734375E+04, -.1285604614258E+04, .1219421508789E+04},
 {    7969, .8409364257812E+04, -.1297199462891E+04, .1219495239258E+04},
 {    7970, .8405786132812E+04, -.1308291137695E+04, .1219718627930E+04},
 {    7971, .8399815429688E+04, -.1318294067383E+04, .1220090454102E+04},
 {    7972, .8391534179688E+04, -.1326481933594E+04, .1220604980469E+04},
 {    7973, .8381261718750E+04, -.1331950439453E+04, .1221244750977E+04},
 {    7974, .8369783203125E+04, -.1333847656250E+04, .1221957885742E+04},
 {    7975, .8382723632812E+04, -.1240413940430E+04, .1246602783203E+04},
 {    7976, .8392921875000E+04, -.1245643676758E+04, .1245968139648E+04},
 {    7977, .8401229492188E+04, -.1253549560547E+04, .1245450927734E+04},
 {    7978, .8407273437500E+04, -.1263302124023E+04, .1245074951172E+04},
 {    7979, .8410916015625E+04, -.1274185791016E+04, .1244848266602E+04},
 {    7980, .8412132812500E+04, -.1285600830078E+04, .1244772827148E+04},
 {    7981, .8410913085938E+04, -.1297015502930E+04, .1244849121094E+04},
 {    7982, .8407265625000E+04, -.1307897827148E+04, .1245075683594E+04},
 {    7983, .8401217773438E+04, -.1317648315430E+04, .1245451416016E+04},
 {    7984, .8392907226562E+04, -.1325550537109E+04, .1245969360352E+04},
 {    7985, .8382707031250E+04, -.1330775390625E+04, .1246603027344E+04},
 {    7986, .8371389648438E+04, -.1332578369141E+04, .1247307495117E+04},
 {    7987, .8383507812500E+04, -.1240412963867E+04, .1259278320312E+04},
 {    7988, .8393708984375E+04, -.1245641967773E+04, .1258643554688E+04},
 {    7989, .8402017578125E+04, -.1253547363281E+04, .1258126220703E+04},
 {    7990, .8408061523438E+04, -.1263299926758E+04, .1257750122070E+04},
 {    7991, .8411705078125E+04, -.1274183715820E+04, .1257523559570E+04},
 {    7992, .8412920898438E+04, -.1285598999023E+04, .1257448364258E+04},
 {    7993, .8411701171875E+04, -.1297013916016E+04, .1257523925781E+04},
 {    7994, .8408055664062E+04, -.1307896728516E+04, .1257750488281E+04},
 {    7995, .8402008789062E+04, -.1317647583008E+04, .1258126586914E+04},
 {    7996, .8393697265625E+04, -.1325550170898E+04, .1258643798828E+04},
 {    7997, .8383495117188E+04, -.1330775268555E+04, .1259279174805E+04},
 {    7998, .8372179687500E+04, -.1332578369141E+04, .1259982666016E+04},
 {    7999, .8384311523438E+04, -.1240417236328E+04, .1271952392578E+04},
 {    8000, .8394508789062E+04, -.1245649414062E+04, .1271317626953E+04},
 {    8001, .8402810546875E+04, -.1253556518555E+04, .1270802368164E+04},
 {    8002, .8408853515625E+04, -.1263309326172E+04, .1270425537109E+04},
 {    8003, .8412496093750E+04, -.1274192504883E+04, .1270198486328E+04},
 {    8004, .8413708984375E+04, -.1285606811523E+04, .1270123535156E+04},
 {    8005, .8412489257812E+04, -.1297020263672E+04, .1270199707031E+04},
 {    8006, .8408840820312E+04, -.1307901367188E+04, .1270426025391E+04},
 {    8007, .8402791992188E+04, -.1317650634766E+04, .1270802490234E+04},
 {    8008, .8394484375000E+04, -.1325551635742E+04, .1271319702148E+04},
 {    8009, .8384284179688E+04, -.1330775634766E+04, .1271954345703E+04},
 {    8010, .8372968750000E+04, -.1332578369141E+04, .1272658325195E+04},
 {    8011, .8385632812500E+04, -.1240271118164E+04, .1284594970703E+04},
 {    8012, .8396529296875E+04, -.1245157714844E+04, .1283916992188E+04},
 {    8013, .8405708007812E+04, -.1252801025391E+04, .1283346435547E+04},
 {    8014, .8412600585938E+04, -.1262565307617E+04, .1282917236328E+04},
 {    8015, .8416859375000E+04, -.1273738647461E+04, .1282652099609E+04},
 {    8016, .8418301757812E+04, -.1285611328125E+04, .1282561767578E+04},
 {    8017, .8416849609375E+04, -.1297482788086E+04, .1282652099609E+04},
 {    8018, .8412583007812E+04, -.1308652832031E+04, .1282917968750E+04},
 {    8019, .8405681640625E+04, -.1318411132812E+04, .1283347900391E+04},
 {    8020, .8396496093750E+04, -.1326047119141E+04, .1283918945312E+04},
 {    8021, .8385594726562E+04, -.1330923461914E+04, .1284597900391E+04},
 {    8022, .8373770507812E+04, -.1332578979492E+04, .1285332885742E+04},
 {    8023, .8387013671875E+04, -.1236673828125E+04, .1297234375000E+04},
 {    8024, .8398379882812E+04, -.1242159912109E+04, .1296526855469E+04},
 {    8025, .8407785156250E+04, -.1250585815430E+04, .1295942260742E+04},
 {    8026, .8414717773438E+04, -.1261147583008E+04, .1295510742188E+04},
 {    8027, .8418942382812E+04, -.1273059326172E+04, .1295247314453E+04},
 {    8028, .8420356445312E+04, -.1285620971680E+04, .1295158691406E+04},
 {    8029, .8418928710938E+04, -.1298181030273E+04, .1295247802734E+04},
 {    8030, .8414692382812E+04, -.1310088378906E+04, .1295511718750E+04},
 {    8031, .8407748046875E+04, -.1320642700195E+04, .1295943847656E+04},
 {    8032, .8398331054688E+04, -.1329056396484E+04, .1296529785156E+04},
 {    8033, .8386957031250E+04, -.1334526733398E+04, .1297237060547E+04},
 {    8034, .8374478515625E+04, -.1336387207031E+04, .1298013671875E+04},
 {    8035, .8391379882812E+04, -.1230229614258E+04, .1322410644531E+04},
 {    8036, .8405838867188E+04, -.1235638793945E+04, .1321512207031E+04},
 {    8037, .8418527343750E+04, -.1244447387695E+04, .1320722167969E+04},
 {    8038, .8428501953125E+04, -.1256250244141E+04, .1320101318359E+04},
 {    8039, .8434923828125E+04, -.1270314575195E+04, .1319701904297E+04},
 {    8040, .8437143554688E+04, -.1285619506836E+04, .1319563964844E+04},
 {    8041, .8434908203125E+04, -.1300922241211E+04, .1319702636719E+04},
 {    8042, .8428472656250E+04, -.1314979980469E+04, .1320102783203E+04},
 {    8043, .8418486328125E+04, -.1326772827148E+04, .1320724975586E+04},
 {    8044, .8405791015625E+04, -.1335570678711E+04, .1321514648438E+04},
 {    8045, .8391326171875E+04, -.1340967773438E+04, .1322413574219E+04},
 {    8046, .8369760742188E+04, -.1338928466797E+04, .1221959838867E+04},
 {    8047, .8354990234375E+04, -.1337280883789E+04, .1222878540039E+04},
 {    8048, .8340932617188E+04, -.1332447021484E+04, .1223753417969E+04},
 {    8049, .8328372070312E+04, -.1324487548828E+04, .1224535034180E+04},
 {    8050, .8318222656250E+04, -.1313607788086E+04, .1225166503906E+04},
 {    8051, .8311516601562E+04, -.1300319824219E+04, .1225583740234E+04},
 {    8052, .8309150390625E+04, -.1285618652344E+04, .1225730468750E+04},
 {    8053, .8311500000000E+04, -.1270914794922E+04, .1225584716797E+04},
 {    8054, .8318193359375E+04, -.1257620117188E+04, .1225167968750E+04},
 {    8055, .8328331054688E+04, -.1246729980469E+04, .1224537353516E+04},
 {    8056, .8340884765625E+04, -.1238760131836E+04, .1223756103516E+04},
 {    8057, .8354938476562E+04, -.1233915283203E+04, .1222881835938E+04},
 {    8058, .8369707031250E+04, -.1232258422852E+04, .1221962890625E+04},
 {    8059, .8371369140625E+04, -.1336388793945E+04, .1247308837891E+04},
 {    8060, .8357596679688E+04, -.1334765625000E+04, .1248165283203E+04},
 {    8061, .8344558593750E+04, -.1330028076172E+04, .1248977661133E+04},
 {    8062, .8333030273438E+04, -.1322306640625E+04, .1249694091797E+04},
 {    8063, .8323858398438E+04, -.1311884643555E+04, .1250264892578E+04},
 {    8064, .8317884765625E+04, -.1299345214844E+04, .1250636474609E+04},
 {    8065, .8315798828125E+04, -.1285608886719E+04, .1250765747070E+04},
 {    8066, .8317875000000E+04, -.1271871093750E+04, .1250636718750E+04},
 {    8067, .8323839843750E+04, -.1259327392578E+04, .1250266113281E+04},
 {    8068, .8333003906250E+04, -.1248899169922E+04, .1249696289062E+04},
 {    8069, .8344529296875E+04, -.1241171142578E+04, .1248979125977E+04},
 {    8070, .8357563476562E+04, -.1236426391602E+04, .1248168090820E+04},
 {    8071, .8371333984375E+04, -.1234796997070E+04, .1247311157227E+04},
 {    8072, .8372148437500E+04, -.1336388549805E+04, .1259984619141E+04},
 {    8073, .8358724609375E+04, -.1334690063477E+04, .1260820312500E+04},
 {    8074, .8346112304688E+04, -.1329782836914E+04, .1261604614258E+04},
 {    8075, .8335118164062E+04, -.1321884887695E+04, .1262289306641E+04},
 {    8076, .8326520507812E+04, -.1311415405273E+04, .1262823242188E+04},
 {    8077, .8321024414062E+04, -.1299027954102E+04, .1263165527344E+04},
 {    8078, .8319122070312E+04, -.1285606445312E+04, .1263284301758E+04},
 {    8079, .8321016601562E+04, -.1272183959961E+04, .1263166015625E+04},
 {    8080, .8326504882812E+04, -.1259793090820E+04, .1262824707031E+04},
 {    8081, .8335097656250E+04, -.1249318969727E+04, .1262289794922E+04},
 {    8082, .8346086914062E+04, -.1241414672852E+04, .1261606445312E+04},
 {    8083, .8358695312500E+04, -.1236501098633E+04, .1260822021484E+04},
 {    8084, .8372119140625E+04, -.1234797119141E+04, .1259986083984E+04},
 {    8085, .8372984375000E+04, -.1336389892578E+04, .1272657470703E+04},
 {    8086, .8357440429688E+04, -.1335029296875E+04, .1273624267578E+04},
 {    8087, .8342376953125E+04, -.1330961914062E+04, .1274561767578E+04},
 {    8088, .8328397460938E+04, -.1324022338867E+04, .1275431396484E+04},
 {    8089, .8316416015625E+04, -.1314013427734E+04, .1276177124023E+04},
 {    8090, .8307895507812E+04, -.1300918090820E+04, .1276707519531E+04},
 {    8091, .8304700195312E+04, -.1285618408203E+04, .1276906005859E+04},
 {    8092, .8307875000000E+04, -.1270314453125E+04, .1276708251953E+04},
 {    8093, .8316379882812E+04, -.1257209472656E+04, .1276179199219E+04},
 {    8094, .8328353515625E+04, -.1247189941406E+04, .1275434326172E+04},
 {    8095, .8342329101562E+04, -.1240240600586E+04, .1274564941406E+04},
 {    8096, .8357390625000E+04, -.1236163574219E+04, .1273627563477E+04},
 {    8097, .8372933593750E+04, -.1234796630859E+04, .1272661132812E+04},
 {    8098, .8373818359375E+04, -.1336390991211E+04, .1285330078125E+04},
 {    8099, .8354248046875E+04, -.1335316894531E+04, .1286547851562E+04},
 {    8100, .8334921875000E+04, -.1332037841797E+04, .1287749755859E+04},
 {    8101, .8316192382812E+04, -.1326245361328E+04, .1288915771484E+04},
 {    8102, .8298728515625E+04, -.1317327270508E+04, .1290001953125E+04},
 {    8103, .8284239257812E+04, -.1304102783203E+04, .1290904052734E+04},
 {    8104, .8277602539062E+04, -.1285623657227E+04, .1291316406250E+04},
 {    8105, .8284203125000E+04, -.1267131103516E+04, .1290906005859E+04},
 {    8106, .8298677734375E+04, -.1253890136719E+04, .1290005493164E+04},
 {    8107, .8316136718750E+04, -.1244961303711E+04, .1288919189453E+04},
 {    8108, .8334862304688E+04, -.1239159545898E+04, .1287753906250E+04},
 {    8109, .8354186523438E+04, -.1235873413086E+04, .1286552001953E+04},
 {    8110, .8373756835938E+04, -.1234795410156E+04, .1285333740234E+04},
 {    8111, .8374553710938E+04, -.1341470336914E+04, .1298008178711E+04},
 {    8112, .8353886718750E+04, -.1340248535156E+04, .1299294555664E+04},
 {    8113, .8333523437500E+04, -.1336518066406E+04, .1300561645508E+04},
 {    8114, .8313882812500E+04, -.1329965820312E+04, .1301784545898E+04},
 {    8115, .8295754882812E+04, -.1319949951172E+04, .1302911621094E+04},
 {    8116, .8281062500000E+04, -.1305337890625E+04, .1303825195312E+04},
 {    8117, .8274591796875E+04, -.1285637084961E+04, .1304227783203E+04},
 {    8118, .8281012695312E+04, -.1265919555664E+04, .1303828125000E+04},
 {    8119, .8295681640625E+04, -.1251286743164E+04, .1302915771484E+04},
 {    8120, .8313800781250E+04, -.1241252441406E+04, .1301788574219E+04},
 {    8121, .8333438476562E+04, -.1234688110352E+04, .1300567138672E+04},
 {    8122, .8353798828125E+04, -.1230946777344E+04, .1299300048828E+04},
 {    8123, .8374465820312E+04, -.1229717163086E+04, .1298013427734E+04},
 {    8124, .8376004882812E+04, -.1350358764648E+04, .1323367675781E+04},
 {    8125, .8354192382812E+04, -.1348795532227E+04, .1324725097656E+04},
 {    8126, .8332834960938E+04, -.1344100219727E+04, .1326053222656E+04},
 {    8127, .8312540039062E+04, -.1335942138672E+04, .1327316406250E+04},
 {    8128, .8294367187500E+04, -.1323751098633E+04, .1328447021484E+04},
 {    8129, .8280506835938E+04, -.1306805297852E+04, .1329309692383E+04},
 {    8130, .8274899414062E+04, -.1285627929688E+04, .1329657958984E+04},
 {    8131, .8280472656250E+04, -.1264441650391E+04, .1329311523438E+04},
 {    8132, .8294314453125E+04, -.1247479003906E+04, .1328450927734E+04},
 {    8133, .8312475585938E+04, -.1235274658203E+04, .1327320556641E+04},
 {    8134, .8332765625000E+04, -.1227104248047E+04, .1326058105469E+04},
 {    8135, .8354122070312E+04, -.1222398925781E+04, .1324729003906E+04},
 {    8136, .8375934570312E+04, -.1220828125000E+04, .1323371826172E+04},
 {    8137, .8382005859375E+04, -.1234506713867E+04, .1221198242188E+04},
 {    8138, .8392774414062E+04, -.1240867187500E+04, .1220527832031E+04},
 {    8139, .8401218750000E+04, -.1250104492188E+04, .1220002197266E+04},
 {    8140, .8407154296875E+04, -.1261125732422E+04, .1219632934570E+04},
 {    8141, .8410662109375E+04, -.1273147705078E+04, .1219414672852E+04},
 {    8142, .8411821289062E+04, -.1285618652344E+04, .1219342773438E+04},
 {    8143, .8410652343750E+04, -.1298088745117E+04, .1219415405273E+04},
 {    8144, .8407133789062E+04, -.1310107666016E+04, .1219634277344E+04},
 {    8145, .8401189453125E+04, -.1321123413086E+04, .1220003906250E+04},
 {    8146, .8392733398438E+04, -.1330350708008E+04, .1220530517578E+04},
 {    8147, .8381958007812E+04, -.1336696533203E+04, .1221200927734E+04},
 {    8148, .8369654296875E+04, -.1338924560547E+04, .1221966674805E+04},
 {    8149, .8383307617188E+04, -.1236837402344E+04, .1246565917969E+04},
 {    8150, .8393956054688E+04, -.1242686157227E+04, .1245903442383E+04},
 {    8151, .8402471679688E+04, -.1251362548828E+04, .1245373413086E+04},
 {    8152, .8408564453125E+04, -.1261889160156E+04, .1244994628906E+04},
 {    8153, .8412194335938E+04, -.1273500976562E+04, .1244769287109E+04},
 {    8154, .8413399414062E+04, -.1285609008789E+04, .1244693115234E+04},
 {    8155, .8412187500000E+04, -.1297716430664E+04, .1244769897461E+04},
 {    8156, .8408550781250E+04, -.1309326049805E+04, .1244995361328E+04},
 {    8157, .8402451171875E+04, -.1319848266602E+04, .1245374755859E+04},
 {    8158, .8393932617188E+04, -.1328518798828E+04, .1245904785156E+04},
 {    8159, .8383276367188E+04, -.1334358398438E+04, .1246567626953E+04},
 {    8160, .8371302734375E+04, -.1336386352539E+04, .1247313476562E+04},
 {    8161, .8384092773438E+04, -.1236835815430E+04, .1259241455078E+04},
 {    8162, .8394744140625E+04, -.1242683593750E+04, .1258578735352E+04},
 {    8163, .8403258789062E+04, -.1251359619141E+04, .1258049560547E+04},
 {    8164, .8409353515625E+04, -.1261886108398E+04, .1257669921875E+04},
 {    8165, .8412982421875E+04, -.1273498168945E+04, .1257444702148E+04},
 {    8166, .8414189453125E+04, -.1285606567383E+04, .1257369873047E+04},
 {    8167, .8412978515625E+04, -.1297714477539E+04, .1257444091797E+04},
 {    8168, .8409341796875E+04, -.1309324584961E+04, .1257670654297E+04},
 {    8169, .8403242187500E+04, -.1319847412109E+04, .1258050537109E+04},
 {    8170, .8394720703125E+04, -.1328518310547E+04, .1258580322266E+04},
 {    8171, .8384064453125E+04, -.1334358276367E+04, .1259243652344E+04},
 {    8172, .8372089843750E+04, -.1336386352539E+04, .1259988525391E+04},
 {    8173, .8384900390625E+04, -.1236843383789E+04, .1271916259766E+04},
 {    8174, .8395548828125E+04, -.1242695800781E+04, .1271253417969E+04},
 {    8175, .8404060546875E+04, -.1251373779297E+04, .1270722900391E+04},
 {    8176, .8410145507812E+04, -.1261900756836E+04, .1270345214844E+04},
 {    8177, .8413775390625E+04, -.1273511718750E+04, .1270118896484E+04},
 {    8178, .8414975585938E+04, -.1285618408203E+04, .1270044433594E+04},
 {    8179, .8413765625000E+04, -.1297724121094E+04, .1270119873047E+04},
 {    8180, .8410125000000E+04, -.1309331909180E+04, .1270346435547E+04},
 {    8181, .8404027343750E+04, -.1319852050781E+04, .1270726196289E+04},
 {    8182, .8395506835938E+04, -.1328520874023E+04, .1271255859375E+04},
 {    8183, .8384851562500E+04, -.1334359008789E+04, .1271918945312E+04},
 {    8184, .8372878906250E+04, -.1336386352539E+04, .1272663696289E+04},
 {    8185, .8386403320312E+04, -.1236626831055E+04, .1284546997070E+04},
 {    8186, .8398001953125E+04, -.1241999145508E+04, .1283825073242E+04},
 {    8187, .8407699218750E+04, -.1250334838867E+04, .1283221923828E+04},
 {    8188, .8414915039062E+04, -.1260900512695E+04, .1282772949219E+04},
 {    8189, .8419343750000E+04, -.1272908325195E+04, .1282497314453E+04},
 {    8190, .8420833984375E+04, -.1285622802734E+04, .1282405029297E+04},
 {    8191, .8419330078125E+04, -.1298335693359E+04, .1282498046875E+04},
 {    8192, .8414886718750E+04, -.1310338500977E+04, .1282775146484E+04},
 {    8193, .8407658203125E+04, -.1320895507812E+04, .1283224365234E+04},
 {    8194, .8397951171875E+04, -.1329218505859E+04, .1283828247070E+04},
 {    8195, .8386343750000E+04, -.1334574462891E+04, .1284550781250E+04},
 {    8196, .8373695312500E+04, -.1336387451172E+04, .1285337890625E+04},
 {    8197, .8388100585938E+04, -.1231800781250E+04, .1297165771484E+04},
 {    8198, .8400475585938E+04, -.1237901123047E+04, .1296396484375E+04},
 {    8199, .8410656250000E+04, -.1247225341797E+04, .1295762939453E+04},
 {    8200, .8418120117188E+04, -.1258845825195E+04, .1295298339844E+04},
 {    8201, .8422649414062E+04, -.1271899536133E+04, .1295016235352E+04},
 {    8202, .8424158203125E+04, -.1285636108398E+04, .1294922973633E+04},
 {    8203, .8422628906250E+04, -.1299370483398E+04, .1295017700195E+04},
 {    8204, .8418081054688E+04, -.1312417602539E+04, .1295300537109E+04},
 {    8205, .8410601562500E+04, -.1324026977539E+04, .1295766357422E+04},
 {    8206, .8400402343750E+04, -.1333332641602E+04, .1296400512695E+04},
 {    8207, .8388015625000E+04, -.1339408935547E+04, .1297171508789E+04},
 {    8208, .8374374023438E+04, -.1341465087891E+04, .1298019775391E+04},
 {    8209, .8393257812500E+04, -.1222846801758E+04, .1322294067383E+04},
 {    8210, .8409581054688E+04, -.1229003662109E+04, .1321278564453E+04},
 {    8211, .8423870117188E+04, -.1239020385742E+04, .1320389648438E+04},
 {    8212, .8435078125000E+04, -.1252411987305E+04, .1319692138672E+04},
 {    8213, .8442263671875E+04, -.1268331665039E+04, .1319245605469E+04},
 {    8214, .8444748046875E+04, -.1285628051758E+04, .1319090576172E+04},
 {    8215, .8442245117188E+04, -.1302921508789E+04, .1319246337891E+04},
 {    8216, .8435038085938E+04, -.1318832519531E+04, .1319695068359E+04},
 {    8217, .8423816406250E+04, -.1332211914062E+04, .1320392333984E+04},
 {    8218, .8409516601562E+04, -.1342213745117E+04, .1321282592773E+04},
 {    8219, .8393189453125E+04, -.1348354858398E+04, .1322298828125E+04},
 {    8220, .8442519531250E+04, -.1239348510742E+04, .1048829833984E+04},
 {    8221, .8439310546875E+04, -.1218246704102E+04, .1050265625000E+04},
 {    8222, .8432572265625E+04, -.1198169311523E+04, .1053283203125E+04},
 {    8223, .8422535156250E+04, -.1179819580078E+04, .1057776367188E+04},
 {    8224, .8409551757812E+04, -.1163840087891E+04, .1063587768555E+04},
 {    8225, .8394079101562E+04, -.1150791015625E+04, .1070513916016E+04},
 {    8226, .8376659179688E+04, -.1141129516602E+04, .1078313110352E+04},
 {    8227, .8357899414062E+04, -.1135193969727E+04, .1086710327148E+04},
 {    8228, .8338461914062E+04, -.1133192016602E+04, .1095413208008E+04},
 {    8230, .8442716796875E+04, -.1217321411133E+04, .1048741699219E+04},
 {    8231, .8436559570312E+04, -.1195620605469E+04, .1051496948242E+04},
 {    8232, .8426675781250E+04, -.1175634399414E+04, .1055922485352E+04},
 {    8233, .8413436523438E+04, -.1158124877930E+04, .1061849243164E+04},
 {    8234, .8397342773438E+04, -.1143760498047E+04, .1069054321289E+04},
 {    8235, .8379006835938E+04, -.1133089965820E+04, .1077262207031E+04},
 {    8236, .8359127929688E+04, -.1126520141602E+04, .1086161254883E+04},
 {    8237, .8338461914062E+04, -.1124302001953E+04, .1095413208008E+04},
 {    8239, .8446118164062E+04, -.1216396118164E+04, .1047217773438E+04},
 {    8240, .8440551757812E+04, -.1193072021484E+04, .1049710693359E+04},
 {    8241, .8430818359375E+04, -.1171449340820E+04, .1054067626953E+04},
 {    8242, .8417319335938E+04, -.1152409667969E+04, .1060111083984E+04},
 {    8243, .8400602539062E+04, -.1136730102539E+04, .1067594238281E+04},
 {    8244, .8381351562500E+04, -.1125050415039E+04, .1076211669922E+04},
 {    8245, .8360352539062E+04, -.1117846435547E+04, .1085612426758E+04},
 {    8246, .8338461914062E+04, -.1115411987305E+04, .1095413208008E+04},
 {    8247, .8437331054688E+04, -.1239348510742E+04, .1037238403320E+04},
 {    8248, .8434123046875E+04, -.1218246704102E+04, .1038673706055E+04},
 {    8249, .8427382812500E+04, -.1198169311523E+04, .1041691284180E+04},
 {    8250, .8417343750000E+04, -.1179819580078E+04, .1046184570312E+04},
 {    8251, .8404362304688E+04, -.1163840087891E+04, .1051996582031E+04},
 {    8252, .8388892578125E+04, -.1150791015625E+04, .1058922607422E+04},
 {    8253, .8371469726562E+04, -.1141129516602E+04, .1066721191406E+04},
 {    8254, .8352710937500E+04, -.1135193969727E+04, .1075119140625E+04},
 {    8255, .8333272460938E+04, -.1133192016602E+04, .1083821044922E+04},
 {    8257, .8437526367188E+04, -.1217321411133E+04, .1037150024414E+04},
 {    8258, .8431372070312E+04, -.1195620605469E+04, .1039905761719E+04},
 {    8259, .8421487304688E+04, -.1175634399414E+04, .1044330200195E+04},
 {    8260, .8408247070312E+04, -.1158124877930E+04, .1050258056641E+04},
 {    8261, .8392152343750E+04, -.1143760498047E+04, .1057462890625E+04},
 {    8262, .8373817382812E+04, -.1133089965820E+04, .1065670654297E+04},
 {    8263, .8353939453125E+04, -.1126520141602E+04, .1074569580078E+04},
 {    8264, .8333272460938E+04, -.1124302001953E+04, .1083821044922E+04},
 {    8266, .8440931640625E+04, -.1216396118164E+04, .1035626220703E+04},
 {    8267, .8435361328125E+04, -.1193072021484E+04, .1038119262695E+04},
 {    8268, .8425627929688E+04, -.1171449340820E+04, .1042476196289E+04},
 {    8269, .8412127929688E+04, -.1152409667969E+04, .1048519775391E+04},
 {    8270, .8395413085938E+04, -.1136730102539E+04, .1056002685547E+04},
 {    8271, .8376161132812E+04, -.1125050415039E+04, .1064620727539E+04},
 {    8272, .8355163085938E+04, -.1117846435547E+04, .1074020996094E+04},
 {    8273, .8333272460938E+04, -.1115411987305E+04, .1083821044922E+04},
 {    8274, .8431495117188E+04, -.1239348510742E+04, .1024197265625E+04},
 {    8275, .8428287109375E+04, -.1218246704102E+04, .1025633300781E+04},
 {    8276, .8421544921875E+04, -.1198169311523E+04, .1028651123047E+04},
 {    8277, .8411506835938E+04, -.1179819580078E+04, .1033143920898E+04},
 {    8278, .8398525390625E+04, -.1163840087891E+04, .1038955810547E+04},
 {    8279, .8383054687500E+04, -.1150791015625E+04, .1045882324219E+04},
 {    8280, .8365632812500E+04, -.1141129516602E+04, .1053680908203E+04},
 {    8281, .8346875000000E+04, -.1135193969727E+04, .1062078247070E+04},
 {    8282, .8327435546875E+04, -.1133192016602E+04, .1070780395508E+04},
 {    8284, .8431688476562E+04, -.1217321411133E+04, .1024109863281E+04},
 {    8285, .8425534179688E+04, -.1195620605469E+04, .1026864990234E+04},
 {    8286, .8415651367188E+04, -.1175634399414E+04, .1031290039062E+04},
 {    8287, .8402410156250E+04, -.1158124877930E+04, .1037217529297E+04},
 {    8288, .8386314453125E+04, -.1143760498047E+04, .1044422363281E+04},
 {    8289, .8367979492188E+04, -.1133089965820E+04, .1052630371094E+04},
 {    8290, .8348099609375E+04, -.1126520141602E+04, .1061529663086E+04},
 {    8291, .8327435546875E+04, -.1124302001953E+04, .1070780395508E+04},
 {    8293, .8435093750000E+04, -.1216396118164E+04, .1022585693359E+04},
 {    8294, .8429522460938E+04, -.1193072021484E+04, .1025079345703E+04},
 {    8295, .8419791015625E+04, -.1171449340820E+04, .1029435791016E+04},
 {    8296, .8406290039062E+04, -.1152409667969E+04, .1035479370117E+04},
 {    8297, .8389577148438E+04, -.1136730102539E+04, .1042962158203E+04},
 {    8298, .8370324218750E+04, -.1125050415039E+04, .1051579833984E+04},
 {    8299, .8349326171875E+04, -.1117846435547E+04, .1060980712891E+04},
 {    8300, .8327435546875E+04, -.1115411987305E+04, .1070780395508E+04},
 {    8301, .8425655273438E+04, -.1239348510742E+04, .1011156982422E+04},
 {    8302, .8422446289062E+04, -.1218246704102E+04, .1012593200684E+04},
 {    8303, .8415706054688E+04, -.1198169311523E+04, .1015610839844E+04},
 {    8304, .8405670898438E+04, -.1179819580078E+04, .1020103881836E+04},
 {    8305, .8392688476562E+04, -.1163840087891E+04, .1025915039062E+04},
 {    8306, .8377215820312E+04, -.1150791015625E+04, .1032841796875E+04},
 {    8307, .8359793945312E+04, -.1141129516602E+04, .1040640380859E+04},
 {    8308, .8341037109375E+04, -.1135193969727E+04, .1049037719727E+04},
 {    8309, .8321595703125E+04, -.1133192016602E+04, .1057740356445E+04},
 {    8311, .8425851562500E+04, -.1217321411133E+04, .1011069213867E+04},
 {    8312, .8419696289062E+04, -.1195620605469E+04, .1013824218750E+04},
 {    8313, .8409812500000E+04, -.1175634399414E+04, .1018249267578E+04},
 {    8314, .8396570312500E+04, -.1158124877930E+04, .1024176391602E+04},
 {    8315, .8380475585938E+04, -.1143760498047E+04, .1031381835938E+04},
 {    8316, .8362143554688E+04, -.1133089965820E+04, .1039589355469E+04},
 {    8317, .8342260742188E+04, -.1126520141602E+04, .1048489501953E+04},
 {    8318, .8321595703125E+04, -.1124302001953E+04, .1057740356445E+04},
 {    8320, .8429255859375E+04, -.1216396118164E+04, .1009545288086E+04},
 {    8321, .8423685546875E+04, -.1193072021484E+04, .1012038696289E+04},
 {    8322, .8413953125000E+04, -.1171449340820E+04, .1016395202637E+04},
 {    8323, .8400454101562E+04, -.1152409667969E+04, .1022438354492E+04},
 {    8324, .8383739257812E+04, -.1136730102539E+04, .1029921508789E+04},
 {    8325, .8364488281250E+04, -.1125050415039E+04, .1038539428711E+04},
 {    8326, .8343487304688E+04, -.1117846435547E+04, .1047939819336E+04},
 {    8327, .8321595703125E+04, -.1115411987305E+04, .1057740356445E+04},
 {    8328, .8413980468750E+04, -.1239348510742E+04, .9850762329102E+03},
 {    8329, .8410772460938E+04, -.1218246704102E+04, .9865120849609E+03},
 {    8330, .8404031250000E+04, -.1198169311523E+04, .9895295410156E+03},
 {    8331, .8393994140625E+04, -.1179819580078E+04, .9940228271484E+03},
 {    8332, .8381010742188E+04, -.1163840087891E+04, .9998345947266E+03},
 {    8333, .8365541992188E+04, -.1150791015625E+04, .1006760986328E+04},
 {    8334, .8348119140625E+04, -.1141129516602E+04, .1014559631348E+04},
 {    8335, .8329360351562E+04, -.1135193969727E+04, .1022956909180E+04},
 {    8336, .8309919921875E+04, -.1133192016602E+04, .1031659179688E+04},
 {    8338, .8414174804688E+04, -.1217321411133E+04, .9849887084961E+03},
 {    8339, .8408020507812E+04, -.1195620605469E+04, .9877436523438E+03},
 {    8340, .8398135742188E+04, -.1175634399414E+04, .9921684570312E+03},
 {    8341, .8384894531250E+04, -.1158124877930E+04, .9980961914062E+03},
 {    8342, .8368799804688E+04, -.1143760498047E+04, .1005300781250E+04},
 {    8343, .8350466796875E+04, -.1133089965820E+04, .1013508911133E+04},
 {    8344, .8330586914062E+04, -.1126520141602E+04, .1022408325195E+04},
 {    8345, .8309919921875E+04, -.1124302001953E+04, .1031659179688E+04},
 {    8347, .8417580078125E+04, -.1216396118164E+04, .9834643554688E+03},
 {    8348, .8412010742188E+04, -.1193072021484E+04, .9859576416016E+03},
 {    8349, .8402276367188E+04, -.1171449340820E+04, .9903144531250E+03},
 {    8350, .8388777343750E+04, -.1152409667969E+04, .9963574218750E+03},
 {    8351, .8372062500000E+04, -.1136730102539E+04, .1003840515137E+04},
 {    8352, .8352810546875E+04, -.1125050415039E+04, .1012458618164E+04},
 {    8353, .8331811523438E+04, -.1117846435547E+04, .1021858886719E+04},
 {    8354, .8309919921875E+04, -.1115411987305E+04, .1031659179688E+04},
 {    8355, .8402303710938E+04, -.1239348510742E+04, .9589953613281E+03},
 {    8356, .8399095703125E+04, -.1218246704102E+04, .9604311523438E+03},
 {    8357, .8392356445312E+04, -.1198169311523E+04, .9634486083984E+03},
 {    8358, .8382320312500E+04, -.1179819580078E+04, .9679415893555E+03},
 {    8359, .8369336914062E+04, -.1163840087891E+04, .9737531738281E+03},
 {    8360, .8353864257812E+04, -.1150791015625E+04, .9806799316406E+03},
 {    8361, .8336441406250E+04, -.1141129516602E+04, .9884785766602E+03},
 {    8362, .8317685546875E+04, -.1135193969727E+04, .9968760375977E+03},
 {    8363, .8298244140625E+04, -.1133192016602E+04, .1005578613281E+04},
 {    8365, .8402500000000E+04, -.1217321411133E+04, .9589072265625E+03},
 {    8366, .8396344726562E+04, -.1195620605469E+04, .9616627197266E+03},
 {    8367, .8386460937500E+04, -.1175634521484E+04, .9660875244141E+03},
 {    8368, .8373218750000E+04, -.1158124877930E+04, .9720150146484E+03},
 {    8369, .8357126953125E+04, -.1143760498047E+04, .9792196655273E+03},
 {    8370, .8338791015625E+04, -.1133089965820E+04, .9874279785156E+03},
 {    8371, .8318911132812E+04, -.1126520141602E+04, .9963272705078E+03},
 {    8372, .8298244140625E+04, -.1124302001953E+04, .1005578613281E+04},
 {    8374, .8405904296875E+04, -.1216396118164E+04, .9573835449219E+03},
 {    8375, .8400335937500E+04, -.1193072021484E+04, .9598762207031E+03},
 {    8376, .8390602539062E+04, -.1171449340820E+04, .9642335815430E+03},
 {    8377, .8377102539062E+04, -.1152409667969E+04, .9702769775391E+03},
 {    8378, .8360386718750E+04, -.1136730102539E+04, .9777602539062E+03},
 {    8379, .8341136718750E+04, -.1125050415039E+04, .9863776855469E+03},
 {    8380, .8320136718750E+04, -.1117846435547E+04, .9957780761719E+03},
 {    8381, .8298244140625E+04, -.1115412109375E+04, .1005578613281E+04},
 {    8382, .8390627929688E+04, -.1239348510742E+04, .9329145507812E+03},
 {    8383, .8387419921875E+04, -.1218246704102E+04, .9343503417969E+03},
 {    8384, .8380680664062E+04, -.1198169311523E+04, .9373677978516E+03},
 {    8385, .8370646484375E+04, -.1179819580078E+04, .9418606567383E+03},
 {    8386, .8357660156250E+04, -.1163840087891E+04, .9476726684570E+03},
 {    8387, .8342189453125E+04, -.1150791015625E+04, .9545991821289E+03},
 {    8388, .8324768554688E+04, -.1141129516602E+04, .9623973388672E+03},
 {    8389, .8306009765625E+04, -.1135193969727E+04, .9707949829102E+03},
 {    8390, .8286571289062E+04, -.1133192016602E+04, .9794973144531E+03},
 {    8392, .8390825195312E+04, -.1217321411133E+04, .9328261718750E+03},
 {    8393, .8384670898438E+04, -.1195620605469E+04, .9355817871094E+03},
 {    8394, .8374784179688E+04, -.1175634521484E+04, .9400067138672E+03},
 {    8395, .8361543945312E+04, -.1158124877930E+04, .9459339599609E+03},
 {    8396, .8345449218750E+04, -.1143760498047E+04, .9531389770508E+03},
 {    8397, .8327114257812E+04, -.1133089965820E+04, .9613471679688E+03},
 {    8398, .8307237304688E+04, -.1126520141602E+04, .9702460327148E+03},
 {    8399, .8286571289062E+04, -.1124302001953E+04, .9794973144531E+03},
 {    8401, .8394229492188E+04, -.1216396118164E+04, .9313027343750E+03},
 {    8402, .8388660156250E+04, -.1193072021484E+04, .9337952880859E+03},
 {    8403, .8378925781250E+04, -.1171449340820E+04, .9381528320312E+03},
 {    8404, .8365427734375E+04, -.1152409667969E+04, .9441959838867E+03},
 {    8405, .8348711914062E+04, -.1136730102539E+04, .9516792602539E+03},
 {    8406, .8329461914062E+04, -.1125050415039E+04, .9602965087891E+03},
 {    8407, .8308460937500E+04, -.1117846435547E+04, .9696973266602E+03},
 {    8408, .8286571289062E+04, -.1115412109375E+04, .9794973144531E+03},
 {    8409, .8385440429688E+04, -.1239348510742E+04, .9213228759766E+03},
 {    8410, .8382232421875E+04, -.1218246704102E+04, .9227584228516E+03},
 {    8411, .8375492187500E+04, -.1198169311523E+04, .9257759399414E+03},
 {    8412, .8365455078125E+04, -.1179819580078E+04, .9302692871094E+03},
 {    8413, .8352471679688E+04, -.1163840087891E+04, .9360811767578E+03},
 {    8414, .8337000000000E+04, -.1150791015625E+04, .9430073852539E+03},
 {    8415, .8319578125000E+04, -.1141129516602E+04, .9508060913086E+03},
 {    8416, .8300821289062E+04, -.1135193969727E+04, .9592035522461E+03},
 {    8417, .8281380859375E+04, -.1133192016602E+04, .9679062500000E+03},
 {    8419, .8385636718750E+04, -.1217321411133E+04, .9212347412109E+03},
 {    8420, .8379480468750E+04, -.1195620727539E+04, .9239902954102E+03},
 {    8421, .8369596679688E+04, -.1175634521484E+04, .9284151000977E+03},
 {    8422, .8356356445312E+04, -.1158124877930E+04, .9343424682617E+03},
 {    8423, .8340259765625E+04, -.1143760498047E+04, .9415477294922E+03},
 {    8424, .8321925781250E+04, -.1133089965820E+04, .9497557373047E+03},
 {    8425, .8302046875000E+04, -.1126520141602E+04, .9586547851562E+03},
 {    8426, .8281380859375E+04, -.1124302001953E+04, .9679062500000E+03},
 {    8428, .8389039062500E+04, -.1216396118164E+04, .9197109375000E+03},
 {    8429, .8383468750000E+04, -.1193072021484E+04, .9222044677734E+03},
 {    8430, .8373737304688E+04, -.1171449340820E+04, .9265612792969E+03},
 {    8431, .8360238281250E+04, -.1152409667969E+04, .9326045532227E+03},
 {    8432, .8343522460938E+04, -.1136730102539E+04, .9400874023438E+03},
 {    8433, .8324271484375E+04, -.1125050415039E+04, .9487050781250E+03},
 {    8434, .8303273437500E+04, -.1117846435547E+04, .9581055908203E+03},
 {    8435, .8281380859375E+04, -.1115412109375E+04, .9679062500000E+03},
 {    8436, .8380252929688E+04, -.1239348510742E+04, .9097310180664E+03},
 {    8437, .8377042968750E+04, -.1218246704102E+04, .9111669921875E+03},
 {    8438, .8370301757812E+04, -.1198169311523E+04, .9141845703125E+03},
 {    8439, .8360266601562E+04, -.1179819580078E+04, .9186773681641E+03},
 {    8440, .8347285156250E+04, -.1163840087891E+04, .9244891967773E+03},
 {    8441, .8331810546875E+04, -.1150791015625E+04, .9314160156250E+03},
 {    8442, .8314390625000E+04, -.1141129516602E+04, .9392144775391E+03},
 {    8443, .8295630859375E+04, -.1135193969727E+04, .9476119384766E+03},
 {    8444, .8276192382812E+04, -.1133192016602E+04, .9563143310547E+03},
 {    8446, .8380446289062E+04, -.1217321411133E+04, .9096433105469E+03},
 {    8447, .8374292968750E+04, -.1195620727539E+04, .9123984375000E+03},
 {    8448, .8364407226562E+04, -.1175634521484E+04, .9168236083984E+03},
 {    8449, .8351166992188E+04, -.1158124877930E+04, .9227509765625E+03},
 {    8450, .8335071289062E+04, -.1143760498047E+04, .9299558715820E+03},
 {    8451, .8316737304688E+04, -.1133089965820E+04, .9381639404297E+03},
 {    8452, .8296858398438E+04, -.1126520141602E+04, .9470629882812E+03},
 {    8453, .8276192382812E+04, -.1124302001953E+04, .9563143310547E+03},
 {    8455, .8383851562500E+04, -.1216396118164E+04, .9081196289062E+03},
 {    8456, .8378279296875E+04, -.1193072021484E+04, .9106126708984E+03},
 {    8457, .8368549804688E+04, -.1171449340820E+04, .9149694824219E+03},
 {    8458, .8355051757812E+04, -.1152409667969E+04, .9210127563477E+03},
 {    8459, .8338333007812E+04, -.1136730102539E+04, .9284960937500E+03},
 {    8460, .8319083984375E+04, -.1125050415039E+04, .9371135253906E+03},
 {    8461, .8298083984375E+04, -.1117846435547E+04, .9465142211914E+03},
 {    8462, .8276192382812E+04, -.1115412109375E+04, .9563143310547E+03},
 {    8463, .8375061523438E+04, -.1239348510742E+04, .8981396484375E+03},
 {    8464, .8371854492188E+04, -.1218246704102E+04, .8995756225586E+03},
 {    8465, .8365113281250E+04, -.1198169311523E+04, .9025930175781E+03},
 {    8466, .8355077148438E+04, -.1179819580078E+04, .9070859985352E+03},
 {    8467, .8342094726562E+04, -.1163840087891E+04, .9128980102539E+03},
 {    8468, .8326620117188E+04, -.1150791015625E+04, .9198244628906E+03},
 {    8469, .8309200195312E+04, -.1141129516602E+04, .9276232299805E+03},
 {    8470, .8290443359375E+04, -.1135193969727E+04, .9360202636719E+03},
 {    8471, .8271002929688E+04, -.1133192016602E+04, .9447230224609E+03},
 {    8473, .8375256835938E+04, -.1217321411133E+04, .8980517578125E+03},
 {    8474, .8369101562500E+04, -.1195620727539E+04, .9008072509766E+03},
 {    8475, .8359217773438E+04, -.1175634521484E+04, .9052319335938E+03},
 {    8476, .8345976562500E+04, -.1158124877930E+04, .9111595458984E+03},
 {    8477, .8329882812500E+04, -.1143760498047E+04, .9183644409180E+03},
 {    8478, .8311546875000E+04, -.1133089965820E+04, .9265723876953E+03},
 {    8479, .8291667968750E+04, -.1126520141602E+04, .9354713745117E+03},
 {    8480, .8271002929688E+04, -.1124302001953E+04, .9447230224609E+03},
 {    8482, .8378662109375E+04, -.1216396118164E+04, .8965280151367E+03},
 {    8483, .8373092773438E+04, -.1193072021484E+04, .8990208129883E+03},
 {    8484, .8363361328125E+04, -.1171449340820E+04, .9033778686523E+03},
 {    8485, .8349859375000E+04, -.1152409667969E+04, .9094213867188E+03},
 {    8486, .8333142578125E+04, -.1136730102539E+04, .9169044799805E+03},
 {    8487, .8313894531250E+04, -.1125050415039E+04, .9255219726562E+03},
 {    8488, .8292895507812E+04, -.1117846435547E+04, .9349226074219E+03},
 {    8489, .8271002929688E+04, -.1115412109375E+04, .9447230224609E+03},
 {    8490, .8318960937500E+04, -.1135206542969E+04, .1104142333984E+04},
 {    8491, .8300147460938E+04, -.1141179199219E+04, .1112564086914E+04},
 {    8492, .8282684570312E+04, -.1150899414062E+04, .1120381347656E+04},
 {    8493, .8267190429688E+04, -.1164024902344E+04, .1127318359375E+04},
 {    8494, .8254203125000E+04, -.1180092651367E+04, .1133131225586E+04},
 {    8495, .8244192382812E+04, -.1198536132812E+04, .1137613525391E+04},
 {    8496, .8237499023438E+04, -.1218705200195E+04, .1140609375000E+04},
 {    8497, .8234367187500E+04, -.1239888916016E+04, .1142011596680E+04},
 {    8498, .8317786132812E+04, -.1126521728516E+04, .1104668090820E+04},
 {    8499, .8297896484375E+04, -.1133096191406E+04, .1113572021484E+04},
 {    8500, .8279554687500E+04, -.1143774414062E+04, .1121782592773E+04},
 {    8501, .8263457031250E+04, -.1158148925781E+04, .1128989501953E+04},
 {    8502, .8250209960938E+04, -.1175670898438E+04, .1134919189453E+04},
 {    8503, .8240326171875E+04, -.1195671264648E+04, .1139343994141E+04},
 {    8504, .8234177734375E+04, -.1217387207031E+04, .1142098022461E+04},
 {    8505, .8231989257812E+04, -.1239990722656E+04, .1143076171875E+04},
 {    8506, .8316610351562E+04, -.1117836914062E+04, .1105194458008E+04},
 {    8507, .8295650390625E+04, -.1125013183594E+04, .1114578125000E+04},
 {    8508, .8276424804688E+04, -.1136649291992E+04, .1123183349609E+04},
 {    8509, .8259722656250E+04, -.1152272949219E+04, .1130661132812E+04},
 {    8510, .8246217773438E+04, -.1171249145508E+04, .1136706542969E+04},
 {    8511, .8236459960938E+04, -.1192806396484E+04, .1141074340820E+04},
 {    8512, .8230848632812E+04, -.1216069213867E+04, .1143586425781E+04},
 {    8513, .8229608398438E+04, -.1240092529297E+04, .1144141845703E+04},
 {    8514, .8313771484375E+04, -.1135206542969E+04, .1092551269531E+04},
 {    8515, .8294958984375E+04, -.1141179199219E+04, .1100972656250E+04},
 {    8516, .8277495117188E+04, -.1150899414062E+04, .1108789794922E+04},
 {    8517, .8261999023438E+04, -.1164024902344E+04, .1115727050781E+04},
 {    8518, .8249014648438E+04, -.1180092651367E+04, .1121540161133E+04},
 {    8519, .8239000976562E+04, -.1198536132812E+04, .1126022705078E+04},
 {    8520, .8232313476562E+04, -.1218705200195E+04, .1129017333984E+04},
 {    8521, .8229177734375E+04, -.1239888916016E+04, .1130419677734E+04},
 {    8522, .8312596679688E+04, -.1126521728516E+04, .1093076904297E+04},
 {    8523, .8292709960938E+04, -.1133096191406E+04, .1101979492188E+04},
 {    8524, .8274368164062E+04, -.1143774414062E+04, .1110190551758E+04},
 {    8525, .8258265625000E+04, -.1158148925781E+04, .1117398437500E+04},
 {    8526, .8245022460938E+04, -.1175670898438E+04, .1123327026367E+04},
 {    8527, .8235137695312E+04, -.1195671264648E+04, .1127752929688E+04},
 {    8528, .8228985351562E+04, -.1217387207031E+04, .1130506347656E+04},
 {    8529, .8226797851562E+04, -.1239990722656E+04, .1131485473633E+04},
 {    8530, .8311421875000E+04, -.1117836914062E+04, .1093602539062E+04},
 {    8531, .8290460937500E+04, -.1125013183594E+04, .1102986206055E+04},
 {    8532, .8271234375000E+04, -.1136649291992E+04, .1111591918945E+04},
 {    8533, .8254533203125E+04, -.1152272949219E+04, .1119069580078E+04},
 {    8534, .8241029296875E+04, -.1171249145508E+04, .1125114501953E+04},
 {    8535, .8231269531250E+04, -.1192806396484E+04, .1129482421875E+04},
 {    8536, .8225661132812E+04, -.1216069213867E+04, .1131995117188E+04},
 {    8537, .8224417968750E+04, -.1240092529297E+04, .1132550537109E+04},
 {    8538, .8307932617188E+04, -.1135206542969E+04, .1079510498047E+04},
 {    8539, .8289121093750E+04, -.1141179199219E+04, .1087932128906E+04},
 {    8540, .8271659179688E+04, -.1150899414062E+04, .1095749511719E+04},
 {    8541, .8256161132812E+04, -.1164024902344E+04, .1102686523438E+04},
 {    8542, .8243177734375E+04, -.1180092651367E+04, .1108499145508E+04},
 {    8543, .8233164062500E+04, -.1198536132812E+04, .1112981933594E+04},
 {    8544, .8226472656250E+04, -.1218705200195E+04, .1115976928711E+04},
 {    8545, .8223339843750E+04, -.1239888916016E+04, .1117379638672E+04},
 {    8546, .8306758789062E+04, -.1126521728516E+04, .1080036132812E+04},
 {    8547, .8286873046875E+04, -.1133096191406E+04, .1088939331055E+04},
 {    8548, .8268528320312E+04, -.1143774414062E+04, .1097150634766E+04},
 {    8549, .8252427734375E+04, -.1158148925781E+04, .1104358398438E+04},
 {    8550, .8239181640625E+04, -.1175670898438E+04, .1110286743164E+04},
 {    8551, .8229302734375E+04, -.1195671264648E+04, .1114711303711E+04},
 {    8552, .8223146484375E+04, -.1217387207031E+04, .1117465698242E+04},
 {    8553, .8220958007812E+04, -.1239990722656E+04, .1118444946289E+04},
 {    8554, .8305583984375E+04, -.1117836914062E+04, .1080562133789E+04},
 {    8555, .8284621093750E+04, -.1125013183594E+04, .1089946289062E+04},
 {    8556, .8265397460938E+04, -.1136649291992E+04, .1098551635742E+04},
 {    8557, .8248693359375E+04, -.1152272949219E+04, .1106029052734E+04},
 {    8558, .8235192382812E+04, -.1171249145508E+04, .1112074096680E+04},
 {    8559, .8225434570312E+04, -.1192806396484E+04, .1116442016602E+04},
 {    8560, .8219823242188E+04, -.1216069213867E+04, .1118954833984E+04},
 {    8561, .8218581054688E+04, -.1240092529297E+04, .1119510253906E+04},
 {    8562, .8302099609375E+04, -.1135206542969E+04, .1066469238281E+04},
 {    8563, .8283282226562E+04, -.1141179199219E+04, .1074891845703E+04},
 {    8564, .8265819335938E+04, -.1150899414062E+04, .1082709106445E+04},
 {    8565, .8250323242188E+04, -.1164024902344E+04, .1089646362305E+04},
 {    8566, .8237337890625E+04, -.1180092651367E+04, .1095459106445E+04},
 {    8567, .8227326171875E+04, -.1198536132812E+04, .1099941284180E+04},
 {    8568, .8220633789062E+04, -.1218705200195E+04, .1102936523438E+04},
 {    8569, .8217502929688E+04, -.1239888916016E+04, .1104338867188E+04},
 {    8570, .8300920898438E+04, -.1126521728516E+04, .1066995727539E+04},
 {    8571, .8281034179688E+04, -.1133096191406E+04, .1075898803711E+04},
 {    8572, .8262691406250E+04, -.1143774414062E+04, .1084109863281E+04},
 {    8573, .8246588867188E+04, -.1158148925781E+04, .1091317504883E+04},
 {    8574, .8233345703125E+04, -.1175670898438E+04, .1097246337891E+04},
 {    8575, .8223462890625E+04, -.1195671264648E+04, .1101671386719E+04},
 {    8576, .8217308593750E+04, -.1217387207031E+04, .1104425537109E+04},
 {    8577, .8215123046875E+04, -.1239990722656E+04, .1105403930664E+04},
 {    8578, .8299747070312E+04, -.1117836914062E+04, .1067521484375E+04},
 {    8579, .8278784179688E+04, -.1125013183594E+04, .1076906127930E+04},
 {    8580, .8259560546875E+04, -.1136649291992E+04, .1085510742188E+04},
 {    8581, .8242859375000E+04, -.1152272949219E+04, .1092988281250E+04},
 {    8582, .8229350585938E+04, -.1171249145508E+04, .1099034057617E+04},
 {    8583, .8219596679688E+04, -.1192806396484E+04, .1103401733398E+04},
 {    8584, .8213984375000E+04, -.1216069213867E+04, .1105913818359E+04},
 {    8585, .8212744140625E+04, -.1240092529297E+04, .1106469604492E+04},
 {    8586, .8290421875000E+04, -.1135206542969E+04, .1040389282227E+04},
 {    8587, .8271608398438E+04, -.1141179199219E+04, .1048811157227E+04},
 {    8588, .8254144531250E+04, -.1150899414062E+04, .1056627685547E+04},
 {    8589, .8238650390625E+04, -.1164024902344E+04, .1063564941406E+04},
 {    8590, .8225664062500E+04, -.1180092651367E+04, .1069377685547E+04},
 {    8591, .8215651367188E+04, -.1198536132812E+04, .1073860717773E+04},
 {    8592, .8208959960938E+04, -.1218705200195E+04, .1076855346680E+04},
 {    8593, .8205828125000E+04, -.1239888916016E+04, .1078257568359E+04},
 {    8594, .8289246093750E+04, -.1126521728516E+04, .1040914550781E+04},
 {    8595, .8269361328125E+04, -.1133096191406E+04, .1049817382812E+04},
 {    8596, .8251015625000E+04, -.1143774414062E+04, .1058029052734E+04},
 {    8597, .8234912109375E+04, -.1158148925781E+04, .1065236816406E+04},
 {    8598, .8221671875000E+04, -.1175670898438E+04, .1071165039062E+04},
 {    8599, .8211786132812E+04, -.1195671264648E+04, .1075589965820E+04},
 {    8600, .8205633789062E+04, -.1217387207031E+04, .1078344970703E+04},
 {    8601, .8203447265625E+04, -.1239990722656E+04, .1079322998047E+04},
 {    8602, .8288071289062E+04, -.1117836914062E+04, .1041441040039E+04},
 {    8603, .8267108398438E+04, -.1125013183594E+04, .1050824829102E+04},
 {    8604, .8247885742188E+04, -.1136649291992E+04, .1059430175781E+04},
 {    8605, .8231182617188E+04, -.1152272949219E+04, .1066907714844E+04},
 {    8606, .8217679687500E+04, -.1171249145508E+04, .1072952880859E+04},
 {    8607, .8207920898438E+04, -.1192806396484E+04, .1077320922852E+04},
 {    8608, .8202309570312E+04, -.1216069213867E+04, .1079833251953E+04},
 {    8609, .8201068359375E+04, -.1240092529297E+04, .1080388427734E+04},
 {    8610, .8278745117188E+04, -.1135206542969E+04, .1014307922363E+04},
 {    8611, .8259934570312E+04, -.1141179199219E+04, .1022729980469E+04},
 {    8612, .8242470703125E+04, -.1150899536133E+04, .1030547363281E+04},
 {    8613, .8226974609375E+04, -.1164024902344E+04, .1037484130859E+04},
 {    8614, .8213989257812E+04, -.1180092651367E+04, .1043297119141E+04},
 {    8615, .8203974609375E+04, -.1198536132812E+04, .1047779418945E+04},
 {    8616, .8197284179688E+04, -.1218705200195E+04, .1050774658203E+04},
 {    8617, .8194154296875E+04, -.1239888916016E+04, .1052176879883E+04},
 {    8618, .8277570312500E+04, -.1126521728516E+04, .1014833862305E+04},
 {    8619, .8257681640625E+04, -.1133096191406E+04, .1023736938477E+04},
 {    8620, .8239339843750E+04, -.1143774414062E+04, .1031948364258E+04},
 {    8621, .8223239257812E+04, -.1158148925781E+04, .1039155273438E+04},
 {    8622, .8209996093750E+04, -.1175670898438E+04, .1045084838867E+04},
 {    8623, .8200112304688E+04, -.1195671264648E+04, .1049509643555E+04},
 {    8624, .8193959960938E+04, -.1217387207031E+04, .1052263549805E+04},
 {    8625, .8191771484375E+04, -.1239990722656E+04, .1053242553711E+04},
 {    8626, .8276395507812E+04, -.1117836914062E+04, .1015359985352E+04},
 {    8627, .8255431640625E+04, -.1125013183594E+04, .1024744140625E+04},
 {    8628, .8236209960938E+04, -.1136649291992E+04, .1033349365234E+04},
 {    8629, .8219506835938E+04, -.1152272949219E+04, .1040826416016E+04},
 {    8630, .8206003906250E+04, -.1171249145508E+04, .1046871948242E+04},
 {    8631, .8196246093750E+04, -.1192806396484E+04, .1051239501953E+04},
 {    8632, .8190631347656E+04, -.1216069213867E+04, .1053752441406E+04},
 {    8633, .8189393066406E+04, -.1240092651367E+04, .1054307495117E+04},
 {    8634, .8267069335938E+04, -.1135206542969E+04, .9882270507812E+03},
 {    8635, .8248258789062E+04, -.1141179199219E+04, .9966486816406E+03},
 {    8636, .8230792968750E+04, -.1150899536133E+04, .1004466430664E+04},
 {    8637, .8215297851562E+04, -.1164024902344E+04, .1011403381348E+04},
 {    8638, .8202315429688E+04, -.1180092651367E+04, .1017215454102E+04},
 {    8639, .8192301757812E+04, -.1198536132812E+04, .1021698852539E+04},
 {    8640, .8185608886719E+04, -.1218705200195E+04, .1024694091797E+04},
 {    8641, .8182478515625E+04, -.1239888916016E+04, .1026095458984E+04},
 {    8642, .8265894531250E+04, -.1126521728516E+04, .9887529296875E+03},
 {    8643, .8246007812500E+04, -.1133096191406E+04, .9976555175781E+03},
 {    8644, .8227665039062E+04, -.1143774414062E+04, .1005867187500E+04},
 {    8645, .8211561523438E+04, -.1158148925781E+04, .1013075073242E+04},
 {    8646, .8198318359375E+04, -.1175670898438E+04, .1019003417969E+04},
 {    8647, .8188434570312E+04, -.1195671264648E+04, .1023429077148E+04},
 {    8648, .8182281250000E+04, -.1217387207031E+04, .1026182739258E+04},
 {    8649, .8180096191406E+04, -.1239990722656E+04, .1027161621094E+04},
 {    8650, .8264719726562E+04, -.1117836914062E+04, .9892788085938E+03},
 {    8651, .8243757812500E+04, -.1125013183594E+04, .9986630859375E+03},
 {    8652, .8224534179688E+04, -.1136649291992E+04, .1007268371582E+04},
 {    8653, .8207832031250E+04, -.1152272949219E+04, .1014745727539E+04},
 {    8654, .8194326171875E+04, -.1171249145508E+04, .1020791259766E+04},
 {    8655, .8184569335938E+04, -.1192806396484E+04, .1025158691406E+04},
 {    8656, .8178958496094E+04, -.1216069213867E+04, .1027671264648E+04},
 {    8657, .8177716308594E+04, -.1240092651367E+04, .1028226928711E+04},
 {    8658, .8261879882812E+04, -.1135206542969E+04, .9766353759766E+03},
 {    8659, .8243068359375E+04, -.1141179199219E+04, .9850572509766E+03},
 {    8660, .8225605468750E+04, -.1150899536133E+04, .9928741455078E+03},
 {    8661, .8210108398438E+04, -.1164024902344E+04, .9998118286133E+03},
 {    8662, .8197124023438E+04, -.1180092651367E+04, .1005624633789E+04},
 {    8663, .8187110839844E+04, -.1198536132812E+04, .1010106567383E+04},
 {    8664, .8180420410156E+04, -.1218705200195E+04, .1013102172852E+04},
 {    8665, .8177286132812E+04, -.1239888916016E+04, .1014504577637E+04},
 {    8666, .8260705078125E+04, -.1126521728516E+04, .9771614379883E+03},
 {    8667, .8240818359375E+04, -.1133096191406E+04, .9860640869141E+03},
 {    8668, .8222476562500E+04, -.1143774414062E+04, .9942760009766E+03},
 {    8669, .8206377929688E+04, -.1158148925781E+04, .1001482727051E+04},
 {    8670, .8193130859375E+04, -.1175670898438E+04, .1007411987305E+04},
 {    8671, .8183246093750E+04, -.1195671264648E+04, .1011836914062E+04},
 {    8672, .8177093261719E+04, -.1217387207031E+04, .1014591552734E+04},
 {    8673, .8174909179688E+04, -.1239990722656E+04, .1015569824219E+04},
 {    8674, .8259531250000E+04, -.1117836914062E+04, .9776872558594E+03},
 {    8675, .8238565429688E+04, -.1125013183594E+04, .9870718994141E+03},
 {    8676, .8219344726562E+04, -.1136649291992E+04, .9956768798828E+03},
 {    8677, .8202644531250E+04, -.1152272949219E+04, .1003153686523E+04},
 {    8678, .8189138183594E+04, -.1171249145508E+04, .1009199584961E+04},
 {    8679, .8179381835938E+04, -.1192806396484E+04, .1013567199707E+04},
 {    8680, .8173768554688E+04, -.1216069335938E+04, .1016079589844E+04},
 {    8681, .8172526367188E+04, -.1240092651367E+04, .1016635498047E+04},
 {    8682, .8256692382812E+04, -.1135206542969E+04, .9650437622070E+03},
 {    8683, .8237877929688E+04, -.1141179199219E+04, .9734658813477E+03},
 {    8684, .8220416015625E+04, -.1150899536133E+04, .9812830810547E+03},
 {    8685, .8204917968750E+04, -.1164024902344E+04, .9882203369141E+03},
 {    8686, .8191936523438E+04, -.1180092651367E+04, .9940324096680E+03},
 {    8687, .8181922363281E+04, -.1198536132812E+04, .9985152587891E+03},
 {    8688, .8175230468750E+04, -.1218705200195E+04, .1001510742188E+04},
 {    8689, .8172100585938E+04, -.1239888916016E+04, .1002912353516E+04},
 {    8690, .8255515625000E+04, -.1126521728516E+04, .9655699462891E+03},
 {    8691, .8235626953125E+04, -.1133096191406E+04, .9744730224609E+03},
 {    8692, .8217285156250E+04, -.1143774414062E+04, .9826840820312E+03},
 {    8693, .8201186523438E+04, -.1158148925781E+04, .9898918457031E+03},
 {    8694, .8187939941406E+04, -.1175670898438E+04, .9958207397461E+03},
 {    8695, .8178055664062E+04, -.1195671264648E+04, .1000245971680E+04},
 {    8696, .8171906250000E+04, -.1217387207031E+04, .1002999267578E+04},
 {    8697, .8169720703125E+04, -.1239990722656E+04, .1003978027344E+04},
 {    8698, .8254343750000E+04, -.1117836914062E+04, .9660954589844E+03},
 {    8699, .8233379882812E+04, -.1125013183594E+04, .9754797363281E+03},
 {    8700, .8214157226562E+04, -.1136649291992E+04, .9840851440430E+03},
 {    8701, .8197452148438E+04, -.1152272949219E+04, .9915626220703E+03},
 {    8702, .8183947753906E+04, -.1171249145508E+04, .9976080322266E+03},
 {    8703, .8174192382812E+04, -.1192806396484E+04, .1001975708008E+04},
 {    8704, .8168580078125E+04, -.1216069335938E+04, .1004488098145E+04},
 {    8705, .8167338378906E+04, -.1240092651367E+04, .1005043945312E+04},
 {    8706, .8251500976562E+04, -.1135206542969E+04, .9534526367188E+03},
 {    8707, .8232691406250E+04, -.1141179199219E+04, .9618740844727E+03},
 {    8708, .8215225585938E+04, -.1150899536133E+04, .9696917724609E+03},
 {    8709, .8199730468750E+04, -.1164024902344E+04, .9766282958984E+03},
 {    8710, .8186746582031E+04, -.1180092651367E+04, .9824411621094E+03},
 {    8711, .8176730957031E+04, -.1198536132812E+04, .9869241943359E+03},
 {    8712, .8170043945312E+04, -.1218705200195E+04, .9899189453125E+03},
 {    8713, .8166911132812E+04, -.1239888916016E+04, .9913211669922E+03},
 {    8714, .8250328125000E+04, -.1126521728516E+04, .9539782104492E+03},
 {    8715, .8230437500000E+04, -.1133096191406E+04, .9628814697266E+03},
 {    8716, .8212095703125E+04, -.1143774414062E+04, .9710927124023E+03},
 {    8717, .8195996093750E+04, -.1158148925781E+04, .9782998046875E+03},
 {    8718, .8182752929688E+04, -.1175670898438E+04, .9842291870117E+03},
 {    8719, .8172869140625E+04, -.1195671264648E+04, .9886541748047E+03},
 {    8720, .8166716796875E+04, -.1217387207031E+04, .9914078369141E+03},
 {    8721, .8164530761719E+04, -.1239990722656E+04, .9923865966797E+03},
 {    8722, .8249152343750E+04, -.1117836914062E+04, .9545041503906E+03},
 {    8723, .8228189453125E+04, -.1125013183594E+04, .9638881225586E+03},
 {    8724, .8208966796875E+04, -.1136649291992E+04, .9724938964844E+03},
 {    8725, .8192263671875E+04, -.1152272949219E+04, .9799709472656E+03},
 {    8726, .8178759277344E+04, -.1171249145508E+04, .9860163574219E+03},
 {    8727, .8169003417969E+04, -.1192806396484E+04, .9903842163086E+03},
 {    8728, .8163390625000E+04, -.1216069335938E+04, .9928967285156E+03},
 {    8729, .8162149902344E+04, -.1240092651367E+04, .9934521484375E+03},
 {    8730, .8234250976562E+04, -.1262740478516E+04, .1142062377930E+04},
 {    8731, .8234134765625E+04, -.1285592041016E+04, .1142114868164E+04},
 {    8732, .8231902343750E+04, -.1262791381836E+04, .1143114501953E+04},
 {    8733, .8231818359375E+04, -.1285592041016E+04, .1143152832031E+04},
 {    8734, .8229554687500E+04, -.1262842285156E+04, .1144165893555E+04},
 {    8735, .8229499023438E+04, -.1285592041016E+04, .1144190429688E+04},
 {    8736, .8229063476562E+04, -.1262740478516E+04, .1130471679688E+04},
 {    8737, .8228947265625E+04, -.1285592041016E+04, .1130523315430E+04},
 {    8738, .8226712890625E+04, -.1262791381836E+04, .1131523559570E+04},
 {    8739, .8226626953125E+04, -.1285592041016E+04, .1131561279297E+04},
 {    8740, .8224366210938E+04, -.1262842285156E+04, .1132574584961E+04},
 {    8741, .8224312500000E+04, -.1285592041016E+04, .1132598632812E+04},
 {    8742, .8223227539062E+04, -.1262740478516E+04, .1117430664062E+04},
 {    8743, .8223108398438E+04, -.1285592041016E+04, .1117482788086E+04},
 {    8744, .8220876953125E+04, -.1262791381836E+04, .1118482543945E+04},
 {    8745, .8220790039062E+04, -.1285592041016E+04, .1118520507812E+04},
 {    8746, .8218527343750E+04, -.1262842285156E+04, .1119534423828E+04},
 {    8747, .8218474609375E+04, -.1285592041016E+04, .1119558105469E+04},
 {    8748, .8217389648438E+04, -.1262740478516E+04, .1104390258789E+04},
 {    8749, .8217269531250E+04, -.1285592041016E+04, .1104442504883E+04},
 {    8750, .8215039062500E+04, -.1262791381836E+04, .1105442138672E+04},
 {    8751, .8214955078125E+04, -.1285592041016E+04, .1105479736328E+04},
 {    8752, .8212689453125E+04, -.1262842285156E+04, .1106493286133E+04},
 {    8753, .8212635742188E+04, -.1285592041016E+04, .1106517578125E+04},
 {    8754, .8205712890625E+04, -.1262740478516E+04, .1078309570312E+04},
 {    8755, .8205597656250E+04, -.1285592041016E+04, .1078361328125E+04},
 {    8756, .8203362304688E+04, -.1262791381836E+04, .1079361572266E+04},
 {    8757, .8203278320312E+04, -.1285592041016E+04, .1079398681641E+04},
 {    8758, .8201015625000E+04, -.1262842285156E+04, .1080412353516E+04},
 {    8759, .8200959960938E+04, -.1285592041016E+04, .1080436767578E+04},
 {    8760, .8194037109375E+04, -.1262740478516E+04, .1052228027344E+04},
 {    8761, .8193920898438E+04, -.1285592041016E+04, .1052280273438E+04},
 {    8762, .8191687500000E+04, -.1262791381836E+04, .1053279663086E+04},
 {    8763, .8191603027344E+04, -.1285592041016E+04, .1053317871094E+04},
 {    8764, .8189339843750E+04, -.1262842285156E+04, .1054331542969E+04},
 {    8765, .8189285644531E+04, -.1285592041016E+04, .1054355957031E+04},
 {    8766, .8182361328125E+04, -.1262740478516E+04, .1026147705078E+04},
 {    8767, .8182247558594E+04, -.1285592041016E+04, .1026198974609E+04},
 {    8768, .8180013183594E+04, -.1262791381836E+04, .1027198974609E+04},
 {    8769, .8179927246094E+04, -.1285592041016E+04, .1027237182617E+04},
 {    8770, .8177662109375E+04, -.1262842285156E+04, .1028251098633E+04},
 {    8771, .8177610351562E+04, -.1285592041016E+04, .1028274780273E+04},
 {    8772, .8177172851562E+04, -.1262740478516E+04, .1014555908203E+04},
 {    8773, .8177056152344E+04, -.1285592041016E+04, .1014607910156E+04},
 {    8774, .8174823242188E+04, -.1262791381836E+04, .1015607299805E+04},
 {    8775, .8174738281250E+04, -.1285592041016E+04, .1015645507812E+04},
 {    8776, .8172475585938E+04, -.1262842285156E+04, .1016659057617E+04},
 {    8777, .8172420410156E+04, -.1285592041016E+04, .1016683105469E+04},
 {    8778, .8171982421875E+04, -.1262740478516E+04, .1002964355469E+04},
 {    8779, .8171867675781E+04, -.1285592041016E+04, .1003016174316E+04},
 {    8780, .8169634277344E+04, -.1262791381836E+04, .1004015991211E+04},
 {    8781, .8169549316406E+04, -.1285592041016E+04, .1004053771973E+04},
 {    8782, .8167285156250E+04, -.1262842285156E+04, .1005067687988E+04},
 {    8783, .8167229980469E+04, -.1285592041016E+04, .1005092102051E+04},
 {    8784, .8166795410156E+04, -.1262740478516E+04, .9913728637695E+03},
 {    8785, .8166678222656E+04, -.1285592041016E+04, .9914249267578E+03},
 {    8786, .8164444824219E+04, -.1262791381836E+04, .9924248046875E+03},
 {    8787, .8164359375000E+04, -.1285592041016E+04, .9924627685547E+03},
 {    8788, .8162095214844E+04, -.1262842285156E+04, .9934760742188E+03},
 {    8789, .8162042480469E+04, -.1285592041016E+04, .9935001220703E+03},
 {    8790, .8234250976562E+04, -.1308443603516E+04, .1142062377930E+04},
 {    8791, .8234367187500E+04, -.1331295166016E+04, .1142011596680E+04},
 {    8792, .8231902343750E+04, -.1308392700195E+04, .1143114501953E+04},
 {    8793, .8231989257812E+04, -.1331193359375E+04, .1143076171875E+04},
 {    8794, .8229554687500E+04, -.1308341796875E+04, .1144165893555E+04},
 {    8795, .8229608398438E+04, -.1331091552734E+04, .1144141845703E+04},
 {    8796, .8229063476562E+04, -.1308443603516E+04, .1130471679688E+04},
 {    8797, .8229177734375E+04, -.1331295166016E+04, .1130419677734E+04},
 {    8798, .8226712890625E+04, -.1308392700195E+04, .1131523559570E+04},
 {    8799, .8226797851562E+04, -.1331193359375E+04, .1131485473633E+04},
 {    8800, .8224366210938E+04, -.1308341796875E+04, .1132574584961E+04},
 {    8801, .8224417968750E+04, -.1331091552734E+04, .1132550537109E+04},
 {    8802, .8223227539062E+04, -.1308443603516E+04, .1117430664062E+04},
 {    8803, .8223339843750E+04, -.1331295166016E+04, .1117379638672E+04},
 {    8804, .8220876953125E+04, -.1308392700195E+04, .1118482543945E+04},
 {    8805, .8220958007812E+04, -.1331193359375E+04, .1118444946289E+04},
 {    8806, .8218527343750E+04, -.1308341796875E+04, .1119534423828E+04},
 {    8807, .8218581054688E+04, -.1331091552734E+04, .1119510253906E+04},
 {    8808, .8217389648438E+04, -.1308443603516E+04, .1104390258789E+04},
 {    8809, .8217502929688E+04, -.1331295166016E+04, .1104338867188E+04},
 {    8810, .8215039062500E+04, -.1308392700195E+04, .1105442138672E+04},
 {    8811, .8215123046875E+04, -.1331193359375E+04, .1105403930664E+04},
 {    8812, .8212689453125E+04, -.1308341796875E+04, .1106493286133E+04},
 {    8813, .8212744140625E+04, -.1331091552734E+04, .1106469848633E+04},
 {    8814, .8205712890625E+04, -.1308443603516E+04, .1078309570312E+04},
 {    8815, .8205828125000E+04, -.1331295166016E+04, .1078257568359E+04},
 {    8816, .8203362304688E+04, -.1308392700195E+04, .1079361572266E+04},
 {    8817, .8203447265625E+04, -.1331193359375E+04, .1079322998047E+04},
 {    8818, .8201015625000E+04, -.1308341796875E+04, .1080412353516E+04},
 {    8819, .8201068359375E+04, -.1331091552734E+04, .1080388671875E+04},
 {    8820, .8194037109375E+04, -.1308443603516E+04, .1052228027344E+04},
 {    8821, .8194154296875E+04, -.1331295166016E+04, .1052176879883E+04},
 {    8822, .8191687500000E+04, -.1308392700195E+04, .1053279663086E+04},
 {    8823, .8191771484375E+04, -.1331193359375E+04, .1053242553711E+04},
 {    8824, .8189339843750E+04, -.1308341796875E+04, .1054331542969E+04},
 {    8825, .8189393066406E+04, -.1331091552734E+04, .1054307495117E+04},
 {    8826, .8182361328125E+04, -.1308443603516E+04, .1026147705078E+04},
 {    8827, .8182478515625E+04, -.1331295166016E+04, .1026095458984E+04},
 {    8828, .8180013183594E+04, -.1308392700195E+04, .1027198974609E+04},
 {    8829, .8180096191406E+04, -.1331193359375E+04, .1027161621094E+04},
 {    8830, .8177662109375E+04, -.1308341796875E+04, .1028251098633E+04},
 {    8831, .8177716308594E+04, -.1331091552734E+04, .1028226928711E+04},
 {    8832, .8177172851562E+04, -.1308443603516E+04, .1014555908203E+04},
 {    8833, .8177286132812E+04, -.1331295166016E+04, .1014504577637E+04},
 {    8834, .8174823242188E+04, -.1308392700195E+04, .1015607299805E+04},
 {    8835, .8174909179688E+04, -.1331193359375E+04, .1015569824219E+04},
 {    8836, .8172475585938E+04, -.1308341796875E+04, .1016659057617E+04},
 {    8837, .8172526367188E+04, -.1331091552734E+04, .1016635498047E+04},
 {    8838, .8171982421875E+04, -.1308443603516E+04, .1002964355469E+04},
 {    8839, .8172100585938E+04, -.1331295166016E+04, .1002912353516E+04},
 {    8840, .8169634277344E+04, -.1308392700195E+04, .1004015991211E+04},
 {    8841, .8169720703125E+04, -.1331193359375E+04, .1003978027344E+04},
 {    8842, .8167285156250E+04, -.1308341796875E+04, .1005067687988E+04},
 {    8843, .8167338378906E+04, -.1331091552734E+04, .1005043945312E+04},
 {    8844, .8166795410156E+04, -.1308443603516E+04, .9913728637695E+03},
 {    8845, .8166911132812E+04, -.1331295166016E+04, .9913211669922E+03},
 {    8846, .8164444824219E+04, -.1308392700195E+04, .9924248046875E+03},
 {    8847, .8164530761719E+04, -.1331193359375E+04, .9923865966797E+03},
 {    8848, .8162095214844E+04, -.1308341796875E+04, .9934760742188E+03},
 {    8849, .8162149902344E+04, -.1331091552734E+04, .9934521484375E+03},
 {    8850, .8236053710938E+04, -.1345494140625E+04, .1141256835938E+04},
 {    8851, .8239341796875E+04, -.1359350952148E+04, .1139783935547E+04},
 {    8852, .8244192382812E+04, -.1372648193359E+04, .1137613525391E+04},
 {    8853, .8250514648438E+04, -.1385177246094E+04, .1134782226562E+04},
 {    8854, .8258223632812E+04, -.1396741333008E+04, .1131332275391E+04},
 {    8855, .8267190429688E+04, -.1407159179688E+04, .1127318359375E+04},
 {    8856, .8277272460938E+04, -.1416267211914E+04, .1122805053711E+04},
 {    8857, .8288315429688E+04, -.1423922363281E+04, .1117860595703E+04},
 {    8858, .8300147460938E+04, -.1430004760742E+04, .1112564331055E+04},
 {    8859, .8312578125000E+04, -.1434418823242E+04, .1106999267578E+04},
 {    8860, .8325416992188E+04, -.1437095214844E+04, .1101251464844E+04},
 {    8861, .8338461914062E+04, -.1437992065430E+04, .1095413452148E+04},
 {    8862, .8232999023438E+04, -.1346318969727E+04, .1142624145508E+04},
 {    8863, .8235792968750E+04, -.1361176269531E+04, .1141373168945E+04},
 {    8864, .8240326171875E+04, -.1375513183594E+04, .1139343994141E+04},
 {    8865, .8246522460938E+04, -.1389086059570E+04, .1136570312500E+04},
 {    8866, .8254275390625E+04, -.1401664672852E+04, .1133099365234E+04},
 {    8867, .8263457031250E+04, -.1413035156250E+04, .1128989501953E+04},
 {    8868, .8273909179688E+04, -.1423004394531E+04, .1124310668945E+04},
 {    8869, .8285453125000E+04, -.1431402832031E+04, .1119142089844E+04},
 {    8870, .8297896484375E+04, -.1438087768555E+04, .1113572021484E+04},
 {    8871, .8311033203125E+04, -.1442945556641E+04, .1107692260742E+04},
 {    8872, .8324628906250E+04, -.1445893798828E+04, .1101605224609E+04},
 {    8873, .8338461914062E+04, -.1446882080078E+04, .1095413452148E+04},
 {    8874, .8229945312500E+04, -.1347143798828E+04, .1143991699219E+04},
 {    8875, .8232245117188E+04, -.1363001586914E+04, .1142962402344E+04},
 {    8876, .8236459960938E+04, -.1378378051758E+04, .1141074340820E+04},
 {    8877, .8242527343750E+04, -.1392994995117E+04, .1138358886719E+04},
 {    8878, .8250325195312E+04, -.1406588012695E+04, .1134867187500E+04},
 {    8879, .8259722656250E+04, -.1418911132812E+04, .1130661132812E+04},
 {    8880, .8270543945312E+04, -.1429741577148E+04, .1125817504883E+04},
 {    8881, .8282589843750E+04, -.1438883178711E+04, .1120424682617E+04},
 {    8882, .8295649414062E+04, -.1446170776367E+04, .1114578857422E+04},
 {    8883, .8309482421875E+04, -.1451472412109E+04, .1108385253906E+04},
 {    8884, .8323838867188E+04, -.1454692260742E+04, .1101958618164E+04},
 {    8885, .8338461914062E+04, -.1455772094727E+04, .1095413452148E+04},
 {    8886, .8230862304688E+04, -.1345494140625E+04, .1129665283203E+04},
 {    8887, .8234156250000E+04, -.1359350952148E+04, .1128192138672E+04},
 {    8888, .8239000976562E+04, -.1372648193359E+04, .1126022705078E+04},
 {    8889, .8245328125000E+04, -.1385177246094E+04, .1123190551758E+04},
 {    8890, .8253033203125E+04, -.1396741333008E+04, .1119740356445E+04},
 {    8891, .8261999023438E+04, -.1407159179688E+04, .1115727050781E+04},
 {    8892, .8272083984375E+04, -.1416267211914E+04, .1111212890625E+04},
 {    8893, .8283126953125E+04, -.1423922363281E+04, .1106269531250E+04},
 {    8894, .8294958984375E+04, -.1430004760742E+04, .1100972656250E+04},
 {    8895, .8307389648438E+04, -.1434418823242E+04, .1095407714844E+04},
 {    8896, .8320229492188E+04, -.1437095214844E+04, .1089660400391E+04},
 {    8897, .8333272460938E+04, -.1437992065430E+04, .1083821044922E+04},
 {    8898, .8227806640625E+04, -.1346318969727E+04, .1131032958984E+04},
 {    8899, .8230602539062E+04, -.1361176269531E+04, .1129781738281E+04},
 {    8900, .8235137695312E+04, -.1375513183594E+04, .1127752929688E+04},
 {    8901, .8241333984375E+04, -.1389086059570E+04, .1124978759766E+04},
 {    8902, .8249085937500E+04, -.1401664672852E+04, .1121508300781E+04},
 {    8903, .8258265625000E+04, -.1413035156250E+04, .1117398437500E+04},
 {    8904, .8268716796875E+04, -.1423004394531E+04, .1112719604492E+04},
 {    8905, .8280263671875E+04, -.1431402832031E+04, .1107551025391E+04},
 {    8906, .8292708984375E+04, -.1438087768555E+04, .1101979736328E+04},
 {    8907, .8305841796875E+04, -.1442945556641E+04, .1096101074219E+04},
 {    8908, .8319438476562E+04, -.1445893798828E+04, .1090013305664E+04},
 {    8909, .8333272460938E+04, -.1446882080078E+04, .1083821044922E+04},
 {    8910, .8224752929688E+04, -.1347143798828E+04, .1132400268555E+04},
 {    8911, .8227052734375E+04, -.1363001586914E+04, .1131371093750E+04},
 {    8912, .8231270507812E+04, -.1378378051758E+04, .1129482299805E+04},
 {    8913, .8237336914062E+04, -.1392994995117E+04, .1126767578125E+04},
 {    8914, .8245138671875E+04, -.1406588012695E+04, .1123274902344E+04},
 {    8915, .8254533203125E+04, -.1418911132812E+04, .1119069580078E+04},
 {    8916, .8265353515625E+04, -.1429741577148E+04, .1114225952148E+04},
 {    8917, .8277401367188E+04, -.1438883178711E+04, .1108832275391E+04},
 {    8918, .8290459960938E+04, -.1446170776367E+04, .1102986572266E+04},
 {    8919, .8304292968750E+04, -.1451472412109E+04, .1096794189453E+04},
 {    8920, .8318648437500E+04, -.1454692260742E+04, .1090367187500E+04},
 {    8921, .8333272460938E+04, -.1455772094727E+04, .1083821044922E+04},
 {    8922, .8225024414062E+04, -.1345494140625E+04, .1116625732422E+04},
 {    8923, .8228316406250E+04, -.1359350952148E+04, .1115151489258E+04},
 {    8924, .8233164062500E+04, -.1372648193359E+04, .1112981933594E+04},
 {    8925, .8239490234375E+04, -.1385177246094E+04, .1110149902344E+04},
 {    8926, .8247196289062E+04, -.1396741333008E+04, .1106699707031E+04},
 {    8927, .8256161132812E+04, -.1407159179688E+04, .1102686523438E+04},
 {    8928, .8266246093750E+04, -.1416267211914E+04, .1098172485352E+04},
 {    8929, .8277288085938E+04, -.1423922363281E+04, .1093228759766E+04},
 {    8930, .8289121093750E+04, -.1430004760742E+04, .1087932128906E+04},
 {    8931, .8301552734375E+04, -.1434418823242E+04, .1082366821289E+04},
 {    8932, .8314392578125E+04, -.1437095214844E+04, .1076619262695E+04},
 {    8933, .8327435546875E+04, -.1437992065430E+04, .1070780395508E+04},
 {    8934, .8221971679688E+04, -.1346318969727E+04, .1117992553711E+04},
 {    8935, .8224767578125E+04, -.1361176269531E+04, .1116740844727E+04},
 {    8936, .8229302734375E+04, -.1375513183594E+04, .1114711303711E+04},
 {    8937, .8235492187500E+04, -.1389086059570E+04, .1111938720703E+04},
 {    8938, .8243248046875E+04, -.1401664672852E+04, .1108467407227E+04},
 {    8939, .8252427734375E+04, -.1413035156250E+04, .1104358398438E+04},
 {    8940, .8262880859375E+04, -.1423004394531E+04, .1099679077148E+04},
 {    8941, .8274427734375E+04, -.1431402832031E+04, .1094510131836E+04},
 {    8942, .8286873046875E+04, -.1438087768555E+04, .1088939331055E+04},
 {    8943, .8300003906250E+04, -.1442945556641E+04, .1083060546875E+04},
 {    8944, .8313602539062E+04, -.1445893798828E+04, .1076973022461E+04},
 {    8945, .8327435546875E+04, -.1446882080078E+04, .1070780395508E+04},
 {    8946, .8218916992188E+04, -.1347143798828E+04, .1119359619141E+04},
 {    8947, .8221213867188E+04, -.1363001586914E+04, .1118331176758E+04},
 {    8948, .8225432617188E+04, -.1378378051758E+04, .1116442138672E+04},
 {    8949, .8231498046875E+04, -.1392994995117E+04, .1113727050781E+04},
 {    8950, .8239299804688E+04, -.1406588012695E+04, .1110234619141E+04},
 {    8951, .8248693359375E+04, -.1418911132812E+04, .1106029052734E+04},
 {    8952, .8259514648438E+04, -.1429741577148E+04, .1101185791016E+04},
 {    8953, .8271561523438E+04, -.1438883178711E+04, .1095792236328E+04},
 {    8954, .8284620117188E+04, -.1446170776367E+04, .1089946777344E+04},
 {    8955, .8298454101562E+04, -.1451472412109E+04, .1083753662109E+04},
 {    8956, .8312812500000E+04, -.1454692260742E+04, .1077326538086E+04},
 {    8957, .8327435546875E+04, -.1455772094727E+04, .1070780395508E+04},
 {    8958, .8219188476562E+04, -.1345494140625E+04, .1103584594727E+04},
 {    8959, .8222475585938E+04, -.1359350952148E+04, .1102111450195E+04},
 {    8960, .8227326171875E+04, -.1372648193359E+04, .1099941284180E+04},
 {    8961, .8233650390625E+04, -.1385177246094E+04, .1097109375000E+04},
 {    8962, .8241358398438E+04, -.1396741333008E+04, .1093659423828E+04},
 {    8963, .8250323242188E+04, -.1407159179688E+04, .1089646362305E+04},
 {    8964, .8260410156250E+04, -.1416267211914E+04, .1085131713867E+04},
 {    8965, .8271452148438E+04, -.1423922363281E+04, .1080187988281E+04},
 {    8966, .8283281250000E+04, -.1430004760742E+04, .1074891845703E+04},
 {    8967, .8295714843750E+04, -.1434418823242E+04, .1069326293945E+04},
 {    8968, .8308554687500E+04, -.1437095214844E+04, .1063578979492E+04},
 {    8969, .8321595703125E+04, -.1437992065430E+04, .1057740600586E+04},
 {    8970, .8216134765625E+04, -.1346318969727E+04, .1104951660156E+04},
 {    8971, .8218927734375E+04, -.1361176269531E+04, .1103700683594E+04},
 {    8972, .8223462890625E+04, -.1375513183594E+04, .1101671142578E+04},
 {    8973, .8229655273438E+04, -.1389086059570E+04, .1098897949219E+04},
 {    8974, .8237412109375E+04, -.1401664672852E+04, .1095426513672E+04},
 {    8975, .8246588867188E+04, -.1413035156250E+04, .1091317504883E+04},
 {    8976, .8257044921875E+04, -.1423004394531E+04, .1086638671875E+04},
 {    8977, .8268588867188E+04, -.1431402832031E+04, .1081469726562E+04},
 {    8978, .8281034179688E+04, -.1438087768555E+04, .1075899047852E+04},
 {    8979, .8294166992188E+04, -.1442945556641E+04, .1070019531250E+04},
 {    8980, .8307763671875E+04, -.1445893798828E+04, .1063932495117E+04},
 {    8981, .8321595703125E+04, -.1446882080078E+04, .1057740600586E+04},
 {    8982, .8213080078125E+04, -.1347143798828E+04, .1106319458008E+04},
 {    8983, .8215378906250E+04, -.1363001586914E+04, .1105290527344E+04},
 {    8984, .8219596679688E+04, -.1378378051758E+04, .1103401733398E+04},
 {    8985, .8225662109375E+04, -.1392994995117E+04, .1100686401367E+04},
 {    8986, .8233462890625E+04, -.1406588012695E+04, .1097194458008E+04},
 {    8987, .8242859375000E+04, -.1418911132812E+04, .1092988281250E+04},
 {    8988, .8253676757812E+04, -.1429741577148E+04, .1088145263672E+04},
 {    8989, .8265726562500E+04, -.1438883178711E+04, .1082751342773E+04},
 {    8990, .8278784179688E+04, -.1446170776367E+04, .1076906127930E+04},
 {    8991, .8292618164062E+04, -.1451472412109E+04, .1070713134766E+04},
 {    8992, .8306974609375E+04, -.1454692260742E+04, .1064285888672E+04},
 {    8993, .8321595703125E+04, -.1455772094727E+04, .1057740600586E+04},
 {    8994, .8207511718750E+04, -.1345494140625E+04, .1077503662109E+04},
 {    8995, .8210803710938E+04, -.1359350952148E+04, .1076030151367E+04},
 {    8996, .8215651367188E+04, -.1372648193359E+04, .1073860717773E+04},
 {    8997, .8221978515625E+04, -.1385177246094E+04, .1071028076172E+04},
 {    8998, .8229682617188E+04, -.1396741333008E+04, .1067578857422E+04},
 {    8999, .8238650390625E+04, -.1407159179688E+04, .1063564941406E+04},
 {    9000, .8248732421875E+04, -.1416267211914E+04, .1059051269531E+04},
 {    9001, .8259776367188E+04, -.1423922363281E+04, .1054107177734E+04},
 {    9002, .8271608398438E+04, -.1430004760742E+04, .1048811157227E+04},
 {    9003, .8284040039062E+04, -.1434418823242E+04, .1043245483398E+04},
 {    9004, .8296877929688E+04, -.1437095214844E+04, .1037498046875E+04},
 {    9005, .8309919921875E+04, -.1437992065430E+04, .1031659423828E+04},
 {    9006, .8204457031250E+04, -.1346318969727E+04, .1078871215820E+04},
 {    9007, .8207251953125E+04, -.1361176269531E+04, .1077620117188E+04},
 {    9008, .8211786132812E+04, -.1375513183594E+04, .1075589965820E+04},
 {    9009, .8217983398438E+04, -.1389086059570E+04, .1072816894531E+04},
 {    9010, .8225734375000E+04, -.1401664672852E+04, .1069346191406E+04},
 {    9011, .8234912109375E+04, -.1413035156250E+04, .1065236816406E+04},
 {    9012, .8245370117188E+04, -.1423004394531E+04, .1060557250977E+04},
 {    9013, .8256914062500E+04, -.1431402832031E+04, .1055388793945E+04},
 {    9014, .8269359375000E+04, -.1438087768555E+04, .1049817382812E+04},
 {    9015, .8282492187500E+04, -.1442945556641E+04, .1043938842773E+04},
 {    9016, .8296087890625E+04, -.1445893798828E+04, .1037851562500E+04},
 {    9017, .8309919921875E+04, -.1446882080078E+04, .1031659423828E+04},
 {    9018, .8201403320312E+04, -.1347143798828E+04, .1080238769531E+04},
 {    9019, .8203701171875E+04, -.1363001586914E+04, .1079209594727E+04},
 {    9020, .8207920898438E+04, -.1378378051758E+04, .1077320922852E+04},
 {    9021, .8213987304688E+04, -.1392994995117E+04, .1074605346680E+04},
 {    9022, .8221787109375E+04, -.1406588012695E+04, .1071114013672E+04},
 {    9023, .8231182617188E+04, -.1418911132812E+04, .1066907714844E+04},
 {    9024, .8242001953125E+04, -.1429741577148E+04, .1062063720703E+04},
 {    9025, .8254048828125E+04, -.1438883178711E+04, .1056671264648E+04},
 {    9026, .8267108398438E+04, -.1446170776367E+04, .1050825073242E+04},
 {    9027, .8280941406250E+04, -.1451472412109E+04, .1044632202148E+04},
 {    9028, .8295298828125E+04, -.1454692260742E+04, .1038205322266E+04},
 {    9029, .8309919921875E+04, -.1455772094727E+04, .1031659423828E+04},
 {    9030, .8195837890625E+04, -.1345494140625E+04, .1051422363281E+04},
 {    9031, .8199129882812E+04, -.1359350952148E+04, .1049949218750E+04},
 {    9032, .8203974609375E+04, -.1372648193359E+04, .1047779418945E+04},
 {    9033, .8210300781250E+04, -.1385177246094E+04, .1044948120117E+04},
 {    9034, .8218006835938E+04, -.1396741333008E+04, .1041497680664E+04},
 {    9035, .8226974609375E+04, -.1407159179688E+04, .1037484130859E+04},
 {    9036, .8237057617188E+04, -.1416267211914E+04, .1032970336914E+04},
 {    9037, .8248102539062E+04, -.1423922363281E+04, .1028025878906E+04},
 {    9038, .8259933593750E+04, -.1430004760742E+04, .1022729736328E+04},
 {    9039, .8272363281250E+04, -.1434418823242E+04, .1017164733887E+04},
 {    9040, .8285202148438E+04, -.1437095214844E+04, .1011417480469E+04},
 {    9041, .8298244140625E+04, -.1437992065430E+04, .1005578613281E+04},
 {    9042, .8192784179688E+04, -.1346318969727E+04, .1052789672852E+04},
 {    9043, .8195578125000E+04, -.1361176269531E+04, .1051538452148E+04},
 {    9044, .8200112304688E+04, -.1375513183594E+04, .1049509643555E+04},
 {    9045, .8206305664062E+04, -.1389086059570E+04, .1046736083984E+04},
 {    9046, .8214061523438E+04, -.1401664672852E+04, .1043264892578E+04},
 {    9047, .8223239257812E+04, -.1413035156250E+04, .1039155273438E+04},
 {    9048, .8233690429688E+04, -.1423004394531E+04, .1034476806641E+04},
 {    9049, .8245239257812E+04, -.1431402832031E+04, .1029307739258E+04},
 {    9050, .8257681640625E+04, -.1438087768555E+04, .1023736938477E+04},
 {    9051, .8270815429688E+04, -.1442945556641E+04, .1017858154297E+04},
 {    9052, .8284414062500E+04, -.1445893798828E+04, .1011770996094E+04},
 {    9053, .8298244140625E+04, -.1446882080078E+04, .1005578613281E+04},
 {    9054, .8189727539062E+04, -.1347143798828E+04, .1054157226562E+04},
 {    9055, .8192025390625E+04, -.1363001586914E+04, .1053128906250E+04},
 {    9056, .8196246093750E+04, -.1378378051758E+04, .1051239501953E+04},
 {    9057, .8202312500000E+04, -.1392994995117E+04, .1048524169922E+04},
 {    9058, .8210112304688E+04, -.1406588012695E+04, .1045032226562E+04},
 {    9059, .8219506835938E+04, -.1418911132812E+04, .1040826416016E+04},
 {    9060, .8230326171875E+04, -.1429741577148E+04, .1035983520508E+04},
 {    9061, .8242375000000E+04, -.1438883178711E+04, .1030589599609E+04},
 {    9062, .8255431640625E+04, -.1446170776367E+04, .1024744140625E+04},
 {    9063, .8269264648438E+04, -.1451472412109E+04, .1018551574707E+04},
 {    9064, .8283624023438E+04, -.1454692260742E+04, .1012123901367E+04},
 {    9065, .8298244140625E+04, -.1455772094727E+04, .1005578613281E+04},
 {    9066, .8184162109375E+04, -.1345494140625E+04, .1025341796875E+04},
 {    9067, .8187451660156E+04, -.1359350952148E+04, .1023868286133E+04},
 {    9068, .8192301757812E+04, -.1372648193359E+04, .1021698852539E+04},
 {    9069, .8198627929688E+04, -.1385177246094E+04, .1018866394043E+04},
 {    9070, .8206333007812E+04, -.1396741333008E+04, .1015416748047E+04},
 {    9071, .8215297851562E+04, -.1407159179688E+04, .1011403381348E+04},
 {    9072, .8225379882812E+04, -.1416267211914E+04, .1006889160156E+04},
 {    9073, .8236424804688E+04, -.1423922363281E+04, .1001945373535E+04},
 {    9074, .8248258789062E+04, -.1430004760742E+04, .9966486816406E+03},
 {    9075, .8260687500000E+04, -.1434418823242E+04, .9910838623047E+03},
 {    9076, .8273526367188E+04, -.1437095214844E+04, .9853363647461E+03},
 {    9077, .8286571289062E+04, -.1437992065430E+04, .9794973144531E+03},
 {    9078, .8181107910156E+04, -.1346318969727E+04, .1026709472656E+04},
 {    9079, .8183900390625E+04, -.1361176269531E+04, .1025458251953E+04},
 {    9080, .8188434570312E+04, -.1375513183594E+04, .1023429077148E+04},
 {    9081, .8194631835938E+04, -.1389086059570E+04, .1020655395508E+04},
 {    9082, .8202384765625E+04, -.1401664672852E+04, .1017183593750E+04},
 {    9083, .8211561523438E+04, -.1413035156250E+04, .1013075073242E+04},
 {    9084, .8222015625000E+04, -.1423004394531E+04, .1008395996094E+04},
 {    9085, .8233563476562E+04, -.1431402832031E+04, .1003227172852E+04},
 {    9086, .8246005859375E+04, -.1438087768555E+04, .9976560668945E+03},
 {    9087, .8259139648438E+04, -.1442945556641E+04, .9917767944336E+03},
 {    9088, .8272739257812E+04, -.1445893798828E+04, .9856898803711E+03},
 {    9089, .8286571289062E+04, -.1446882080078E+04, .9794973144531E+03},
 {    9090, .8178052246094E+04, -.1347143798828E+04, .1028076782227E+04},
 {    9091, .8180352539062E+04, -.1363001586914E+04, .1027047973633E+04},
 {    9092, .8184569335938E+04, -.1378378051758E+04, .1025158691406E+04},
 {    9093, .8190636230469E+04, -.1392994995117E+04, .1022443603516E+04},
 {    9094, .8198437500000E+04, -.1406588012695E+04, .1018950988770E+04},
 {    9095, .8207832031250E+04, -.1418911132812E+04, .1014745971680E+04},
 {    9096, .8218648437500E+04, -.1429741577148E+04, .1009902954102E+04},
 {    9097, .8230698242188E+04, -.1438883178711E+04, .1004508483887E+04},
 {    9098, .8243757812500E+04, -.1446170776367E+04, .9986630859375E+03},
 {    9099, .8257590820312E+04, -.1451472412109E+04, .9924700927734E+03},
 {    9100, .8271948242188E+04, -.1454692260742E+04, .9860432128906E+03},
 {    9101, .8286571289062E+04, -.1455772094727E+04, .9794973144531E+03},
 {    9102, .8178971191406E+04, -.1345494140625E+04, .1013750610352E+04},
 {    9103, .8182264648438E+04, -.1359350952148E+04, .1012276367188E+04},
 {    9104, .8187110839844E+04, -.1372648193359E+04, .1010106567383E+04},
 {    9105, .8193436523438E+04, -.1385177246094E+04, .1007275146484E+04},
 {    9106, .8201144531250E+04, -.1396741333008E+04, .1003825317383E+04},
 {    9107, .8210108398438E+04, -.1407159179688E+04, .9998118286133E+03},
 {    9108, .8220194335938E+04, -.1416267211914E+04, .9952976074219E+03},
 {    9109, .8231237304688E+04, -.1423922363281E+04, .9903530273438E+03},
 {    9110, .8243068359375E+04, -.1430004760742E+04, .9850574951172E+03},
 {    9111, .8255500976562E+04, -.1434418823242E+04, .9794918823242E+03},
 {    9112, .8268338867188E+04, -.1437095214844E+04, .9737446289062E+03},
 {    9113, .8281380859375E+04, -.1437992065430E+04, .9679062500000E+03},
 {    9114, .8175918945312E+04, -.1346318969727E+04, .1015117431641E+04},
 {    9115, .8178712402344E+04, -.1361176269531E+04, .1013866821289E+04},
 {    9116, .8183246093750E+04, -.1375513183594E+04, .1011836914062E+04},
 {    9117, .8189440917969E+04, -.1389086059570E+04, .1009064086914E+04},
 {    9118, .8197195312500E+04, -.1401664672852E+04, .1005592407227E+04},
 {    9119, .8206377929688E+04, -.1413035156250E+04, .1001482727051E+04},
 {    9120, .8216827148438E+04, -.1423004394531E+04, .9968044433594E+03},
 {    9121, .8228374023438E+04, -.1431402832031E+04, .9916352539062E+03},
 {    9122, .8240817382812E+04, -.1438087768555E+04, .9860642089844E+03},
 {    9123, .8253950195312E+04, -.1442945556641E+04, .9801857910156E+03},
 {    9124, .8267547851562E+04, -.1445893798828E+04, .9740985717773E+03},
 {    9125, .8281380859375E+04, -.1446882080078E+04, .9679062500000E+03},
 {    9126, .8172863769531E+04, -.1347143798828E+04, .1016484985352E+04},
 {    9127, .8175162597656E+04, -.1363001586914E+04, .1015456298828E+04},
 {    9128, .8179382812500E+04, -.1378378051758E+04, .1013567077637E+04},
 {    9129, .8185448242188E+04, -.1392994995117E+04, .1010851440430E+04},
 {    9130, .8193247070312E+04, -.1406588012695E+04, .1007360046387E+04},
 {    9131, .8202644531250E+04, -.1418911132812E+04, .1003153686523E+04},
 {    9132, .8213463867188E+04, -.1429741577148E+04, .9983107910156E+03},
 {    9133, .8225509765625E+04, -.1438883178711E+04, .9929174804688E+03},
 {    9134, .8238565429688E+04, -.1446170776367E+04, .9870721435547E+03},
 {    9135, .8252401367188E+04, -.1451472412109E+04, .9808787841797E+03},
 {    9136, .8266759765625E+04, -.1454692260742E+04, .9744518432617E+03},
 {    9137, .8281380859375E+04, -.1455772094727E+04, .9679062500000E+03},
 {    9138, .8173783691406E+04, -.1345494140625E+04, .1002158935547E+04},
 {    9139, .8177074707031E+04, -.1359350952148E+04, .1000685058594E+04},
 {    9140, .8181922363281E+04, -.1372648193359E+04, .9985152587891E+03},
 {    9141, .8188246582031E+04, -.1385177246094E+04, .9956837158203E+03},
 {    9142, .8195955078125E+04, -.1396741333008E+04, .9922335205078E+03},
 {    9143, .8204917968750E+04, -.1407159179688E+04, .9882203369141E+03},
 {    9144, .8215002929688E+04, -.1416267211914E+04, .9837064819336E+03},
 {    9145, .8226046875000E+04, -.1423922363281E+04, .9787622680664E+03},
 {    9146, .8237876953125E+04, -.1430004760742E+04, .9734661254883E+03},
 {    9147, .8250309570312E+04, -.1434418823242E+04, .9679006347656E+03},
 {    9148, .8263148437500E+04, -.1437095214844E+04, .9621533203125E+03},
 {    9149, .8276192382812E+04, -.1437992065430E+04, .9563143310547E+03},
 {    9150, .8170728027344E+04, -.1346318969727E+04, .1003526245117E+04},
 {    9151, .8173523925781E+04, -.1361176269531E+04, .1002275146484E+04},
 {    9152, .8178056640625E+04, -.1375513183594E+04, .1000245727539E+04},
 {    9153, .8184254882812E+04, -.1389086059570E+04, .9974719238281E+03},
 {    9154, .8192005859375E+04, -.1401664672852E+04, .9940010375977E+03},
 {    9155, .8201186523438E+04, -.1413035156250E+04, .9898918457031E+03},
 {    9156, .8211635742188E+04, -.1423004394531E+04, .9852130737305E+03},
 {    9157, .8223183593750E+04, -.1431402832031E+04, .9800443725586E+03},
 {    9158, .8235626953125E+04, -.1438087768555E+04, .9744730224609E+03},
 {    9159, .8248761718750E+04, -.1442945556641E+04, .9685936279297E+03},
 {    9160, .8262359375000E+04, -.1445893798828E+04, .9625065917969E+03},
 {    9161, .8276192382812E+04, -.1446882080078E+04, .9563143310547E+03},
 {    9162, .8167674316406E+04, -.1347143798828E+04, .1004893432617E+04},
 {    9163, .8169973632812E+04, -.1363001586914E+04, .1003864746094E+04},
 {    9164, .8174192382812E+04, -.1378378051758E+04, .1001975708008E+04},
 {    9165, .8180256347656E+04, -.1392994995117E+04, .9992603759766E+03},
 {    9166, .8188059082031E+04, -.1406588012695E+04, .9957686767578E+03},
 {    9167, .8197452148438E+04, -.1418911132812E+04, .9915626220703E+03},
 {    9168, .8208273437500E+04, -.1429741577148E+04, .9867194213867E+03},
 {    9169, .8220318359375E+04, -.1438883178711E+04, .9813261718750E+03},
 {    9170, .8233379882812E+04, -.1446170776367E+04, .9754797363281E+03},
 {    9171, .8247211914062E+04, -.1451472412109E+04, .9692873535156E+03},
 {    9172, .8261571289062E+04, -.1454692260742E+04, .9628599853516E+03},
 {    9173, .8276192382812E+04, -.1455772094727E+04, .9563143310547E+03},
 {    9174, .8168592773438E+04, -.1345494140625E+04, .9905673217773E+03},
 {    9175, .8171883789062E+04, -.1359350952148E+04, .9890938720703E+03},
 {    9176, .8176731933594E+04, -.1372648193359E+04, .9869240722656E+03},
 {    9177, .8183058593750E+04, -.1385177246094E+04, .9840921630859E+03},
 {    9178, .8190762695312E+04, -.1396741333008E+04, .9806427612305E+03},
 {    9179, .8199730468750E+04, -.1407159179688E+04, .9766282958984E+03},
 {    9180, .8209815429688E+04, -.1416267211914E+04, .9721143798828E+03},
 {    9181, .8220859375000E+04, -.1423922363281E+04, .9671704101562E+03},
 {    9182, .8232691406250E+04, -.1430004760742E+04, .9618742065430E+03},
 {    9183, .8245122070312E+04, -.1434418823242E+04, .9563088378906E+03},
 {    9184, .8257960937500E+04, -.1437095214844E+04, .9505616455078E+03},
 {    9185, .8271002929688E+04, -.1437992065430E+04, .9447231445312E+03},
 {    9186, .8165538085938E+04, -.1346318969727E+04, .9919350585938E+03},
 {    9187, .8168333496094E+04, -.1361176269531E+04, .9906836547852E+03},
 {    9188, .8172869140625E+04, -.1375513183594E+04, .9886541748047E+03},
 {    9189, .8179063964844E+04, -.1389086059570E+04, .9858805541992E+03},
 {    9190, .8186817382812E+04, -.1401664672852E+04, .9824099121094E+03},
 {    9191, .8195996093750E+04, -.1413035156250E+04, .9782998046875E+03},
 {    9192, .8206447265625E+04, -.1423004394531E+04, .9736213378906E+03},
 {    9193, .8217996093750E+04, -.1431402832031E+04, .9684520263672E+03},
 {    9194, .8230437500000E+04, -.1438087768555E+04, .9628815917969E+03},
 {    9195, .8243571289062E+04, -.1442945556641E+04, .9570025634766E+03},
 {    9196, .8257170898438E+04, -.1445893798828E+04, .9509149780273E+03},
 {    9197, .8271002929688E+04, -.1446882080078E+04, .9447231445312E+03},
 {    9198, .8162482910156E+04, -.1347143798828E+04, .9933021850586E+03},
 {    9199, .8164782226562E+04, -.1363001586914E+04, .9922732543945E+03},
 {    9200, .8169003417969E+04, -.1378378051758E+04, .9903842163086E+03},
 {    9201, .8175068847656E+04, -.1392994995117E+04, .9876690063477E+03},
 {    9202, .8182869628906E+04, -.1406588012695E+04, .9841770019531E+03},
 {    9203, .8192263671875E+04, -.1418911132812E+04, .9799709472656E+03},
 {    9204, .8203082031250E+04, -.1429741577148E+04, .9751278076172E+03},
 {    9205, .8215132812500E+04, -.1438883178711E+04, .9697344970703E+03},
 {    9206, .8228189453125E+04, -.1446170776367E+04, .9638882446289E+03},
 {    9207, .8242023437500E+04, -.1451472412109E+04, .9576959228516E+03},
 {    9208, .8256380859375E+04, -.1454692260742E+04, .9512684936523E+03},
 {    9209, .8271002929688E+04, -.1455772094727E+04, .9447231445312E+03},
 {    9210, .8351462890625E+04, -.1437100830078E+04, .1089592285156E+04},
 {    9211, .8364262695312E+04, -.1434441162109E+04, .1083862670898E+04},
 {    9212, .8376659179688E+04, -.1430054443359E+04, .1078313110352E+04},
 {    9213, .8388461914062E+04, -.1424009033203E+04, .1073029541016E+04},
 {    9214, .8399481445312E+04, -.1416399414062E+04, .1068095703125E+04},
 {    9215, .8409551757812E+04, -.1407343994141E+04, .1063587768555E+04},
 {    9216, .8418514648438E+04, -.1396984130859E+04, .1059575561523E+04},
 {    9217, .8426226562500E+04, -.1385481323242E+04, .1056123291016E+04},
 {    9218, .8432572265625E+04, -.1373015014648E+04, .1053283203125E+04},
 {    9219, .8437447265625E+04, -.1359779541016E+04, .1051099975586E+04},
 {    9220, .8440783203125E+04, -.1345981323242E+04, .1049607666016E+04},
 {    9221, .8442519531250E+04, -.1331835571289E+04, .1048829833984E+04},
 {    9222, .8352287109375E+04, -.1445894409180E+04, .1089223022461E+04},
 {    9223, .8365878906250E+04, -.1442948364258E+04, .1083139038086E+04},
 {    9224, .8379006835938E+04, -.1438093994141E+04, .1077262207031E+04},
 {    9225, .8391444335938E+04, -.1431413818359E+04, .1071693603516E+04},
 {    9226, .8402988281250E+04, -.1423021240234E+04, .1066526733398E+04},
 {    9227, .8413436523438E+04, -.1413059204102E+04, .1061849243164E+04},
 {    9228, .8422613281250E+04, -.1401696777344E+04, .1057740844727E+04},
 {    9229, .8430366210938E+04, -.1389127075195E+04, .1054270385742E+04},
 {    9230, .8436559570312E+04, -.1375563720703E+04, .1051496948242E+04},
 {    9231, .8441096679688E+04, -.1361236938477E+04, .1049466796875E+04},
 {    9232, .8443895507812E+04, -.1346389892578E+04, .1048214233398E+04},
 {    9234, .8353111328125E+04, -.1454687988281E+04, .1088854492188E+04},
 {    9235, .8367495117188E+04, -.1451455566406E+04, .1082414916992E+04},
 {    9236, .8381351562500E+04, -.1446133544922E+04, .1076211669922E+04},
 {    9237, .8394430664062E+04, -.1438818481445E+04, .1070356933594E+04},
 {    9238, .8406491210938E+04, -.1429643188477E+04, .1064958129883E+04},
 {    9239, .8417319335938E+04, -.1418774414062E+04, .1060111328125E+04},
 {    9240, .8426710937500E+04, -.1406409423828E+04, .1055906616211E+04},
 {    9241, .8434502929688E+04, -.1392772827148E+04, .1052417968750E+04},
 {    9242, .8440551757812E+04, -.1378112426758E+04, .1049710693359E+04},
 {    9243, .8444743164062E+04, -.1362694335938E+04, .1047834228516E+04},
 {    9244, .8447007812500E+04, -.1346798461914E+04, .1046820800781E+04},
 {    9246, .8346273437500E+04, -.1437100830078E+04, .1078000732422E+04},
 {    9247, .8359072265625E+04, -.1434441162109E+04, .1072270751953E+04},
 {    9248, .8371469726562E+04, -.1430054443359E+04, .1066721191406E+04},
 {    9249, .8383271484375E+04, -.1424009033203E+04, .1061437988281E+04},
 {    9250, .8394292968750E+04, -.1416399414062E+04, .1056504272461E+04},
 {    9251, .8404362304688E+04, -.1407343994141E+04, .1051996582031E+04},
 {    9252, .8413324218750E+04, -.1396984130859E+04, .1047984497070E+04},
 {    9253, .8421038085938E+04, -.1385481323242E+04, .1044531738281E+04},
 {    9254, .8427382812500E+04, -.1373015014648E+04, .1041691284180E+04},
 {    9255, .8432258789062E+04, -.1359779541016E+04, .1039508544922E+04},
 {    9256, .8435592773438E+04, -.1345981323242E+04, .1038015991211E+04},
 {    9257, .8437331054688E+04, -.1331835571289E+04, .1037238403320E+04},
 {    9258, .8347099609375E+04, -.1445894409180E+04, .1077631835938E+04},
 {    9259, .8360690429688E+04, -.1442948364258E+04, .1071547241211E+04},
 {    9260, .8373817382812E+04, -.1438093994141E+04, .1065670410156E+04},
 {    9261, .8386255859375E+04, -.1431413818359E+04, .1060101928711E+04},
 {    9262, .8397796875000E+04, -.1423021240234E+04, .1054935546875E+04},
 {    9263, .8408247070312E+04, -.1413059204102E+04, .1050258056641E+04},
 {    9264, .8417425781250E+04, -.1401696777344E+04, .1046149658203E+04},
 {    9265, .8425175781250E+04, -.1389127075195E+04, .1042678955078E+04},
 {    9266, .8431372070312E+04, -.1375563720703E+04, .1039905761719E+04},
 {    9267, .8435906250000E+04, -.1361236938477E+04, .1037875488281E+04},
 {    9268, .8438704101562E+04, -.1346389892578E+04, .1036622558594E+04},
 {    9270, .8347920898438E+04, -.1454687988281E+04, .1077263183594E+04},
 {    9271, .8362308593750E+04, -.1451455566406E+04, .1070823242188E+04},
 {    9272, .8376162109375E+04, -.1446133544922E+04, .1064620605469E+04},
 {    9273, .8389241210938E+04, -.1438818481445E+04, .1058765991211E+04},
 {    9274, .8401302734375E+04, -.1429643188477E+04, .1053366455078E+04},
 {    9275, .8412127929688E+04, -.1418774414062E+04, .1048519775391E+04},
 {    9276, .8421524414062E+04, -.1406409423828E+04, .1044314453125E+04},
 {    9277, .8429314453125E+04, -.1392772827148E+04, .1040826660156E+04},
 {    9278, .8435361328125E+04, -.1378112426758E+04, .1038119506836E+04},
 {    9279, .8439553710938E+04, -.1362694335938E+04, .1036242187500E+04},
 {    9280, .8441818359375E+04, -.1346798461914E+04, .1035229003906E+04},
 {    9282, .8340435546875E+04, -.1437100830078E+04, .1064960205078E+04},
 {    9283, .8353233398438E+04, -.1434441162109E+04, .1059230712891E+04},
 {    9284, .8365632812500E+04, -.1430054443359E+04, .1053680908203E+04},
 {    9285, .8377434570312E+04, -.1424009033203E+04, .1048397705078E+04},
 {    9286, .8388456054688E+04, -.1416399414062E+04, .1043463867188E+04},
 {    9287, .8398525390625E+04, -.1407343994141E+04, .1038955810547E+04},
 {    9288, .8407487304688E+04, -.1396984130859E+04, .1034944824219E+04},
 {    9289, .8415199218750E+04, -.1385481323242E+04, .1031491210938E+04},
 {    9290, .8421544921875E+04, -.1373015014648E+04, .1028651123047E+04},
 {    9291, .8426421875000E+04, -.1359779541016E+04, .1026467773438E+04},
 {    9292, .8429753906250E+04, -.1345981323242E+04, .1024976074219E+04},
 {    9293, .8431495117188E+04, -.1331835571289E+04, .1024197265625E+04},
 {    9294, .8341260742188E+04, -.1445894409180E+04, .1064591308594E+04},
 {    9295, .8354852539062E+04, -.1442948364258E+04, .1058506835938E+04},
 {    9296, .8367979492188E+04, -.1438093994141E+04, .1052630371094E+04},
 {    9297, .8380418945312E+04, -.1431413818359E+04, .1047062011719E+04},
 {    9298, .8391962890625E+04, -.1423021240234E+04, .1041894531250E+04},
 {    9299, .8402410156250E+04, -.1413059204102E+04, .1037217529297E+04},
 {    9300, .8411587890625E+04, -.1401696777344E+04, .1033108642578E+04},
 {    9301, .8419339843750E+04, -.1389127075195E+04, .1029638061523E+04},
 {    9302, .8425534179688E+04, -.1375563720703E+04, .1026864990234E+04},
 {    9303, .8430068359375E+04, -.1361236938477E+04, .1024835449219E+04},
 {    9304, .8432869140625E+04, -.1346389892578E+04, .1023582275391E+04},
 {    9306, .8342083984375E+04, -.1454687988281E+04, .1064222045898E+04},
 {    9307, .8356469726562E+04, -.1451455566406E+04, .1057783203125E+04},
 {    9308, .8370324218750E+04, -.1446133544922E+04, .1051579833984E+04},
 {    9309, .8383405273438E+04, -.1438818481445E+04, .1045724609375E+04},
 {    9310, .8395464843750E+04, -.1429643188477E+04, .1040325805664E+04},
 {    9311, .8406290039062E+04, -.1418774414062E+04, .1035479370117E+04},
 {    9312, .8415686523438E+04, -.1406409423828E+04, .1031273437500E+04},
 {    9313, .8423476562500E+04, -.1392772827148E+04, .1027785888672E+04},
 {    9314, .8429523437500E+04, -.1378112426758E+04, .1025079589844E+04},
 {    9315, .8433716796875E+04, -.1362694335938E+04, .1023201904297E+04},
 {    9316, .8435979492188E+04, -.1346798461914E+04, .1022189270020E+04},
 {    9318, .8334597656250E+04, -.1437100830078E+04, .1051919677734E+04},
 {    9319, .8347397460938E+04, -.1434441162109E+04, .1046189697266E+04},
 {    9320, .8359794921875E+04, -.1430054443359E+04, .1040639892578E+04},
 {    9321, .8371597656250E+04, -.1424009033203E+04, .1035356933594E+04},
 {    9322, .8382617187500E+04, -.1416399414062E+04, .1030423217773E+04},
 {    9323, .8392688476562E+04, -.1407343994141E+04, .1025915039062E+04},
 {    9324, .8401648437500E+04, -.1396984130859E+04, .1021903747559E+04},
 {    9325, .8409361328125E+04, -.1385481323242E+04, .1018450866699E+04},
 {    9326, .8415706054688E+04, -.1373015014648E+04, .1015610839844E+04},
 {    9327, .8420583984375E+04, -.1359779541016E+04, .1013427124023E+04},
 {    9328, .8423917968750E+04, -.1345981323242E+04, .1011935180664E+04},
 {    9329, .8425655273438E+04, -.1331835571289E+04, .1011156982422E+04},
 {    9330, .8335421875000E+04, -.1445894409180E+04, .1051550781250E+04},
 {    9331, .8349012695312E+04, -.1442948364258E+04, .1045466430664E+04},
 {    9332, .8362143554688E+04, -.1438093994141E+04, .1039589355469E+04},
 {    9333, .8374580078125E+04, -.1431413818359E+04, .1034020996094E+04},
 {    9334, .8386122070312E+04, -.1423021240234E+04, .1028854003906E+04},
 {    9335, .8396570312500E+04, -.1413059204102E+04, .1024176635742E+04},
 {    9336, .8405749023438E+04, -.1401696777344E+04, .1020068725586E+04},
 {    9337, .8413500976562E+04, -.1389127075195E+04, .1016597839355E+04},
 {    9338, .8419696289062E+04, -.1375563720703E+04, .1013824218750E+04},
 {    9339, .8424233398438E+04, -.1361236938477E+04, .1011794311523E+04},
 {    9340, .8427029296875E+04, -.1346389892578E+04, .1010541625977E+04},
 {    9342, .8336246093750E+04, -.1454687988281E+04, .1051182006836E+04},
 {    9343, .8350630859375E+04, -.1451455566406E+04, .1044742919922E+04},
 {    9344, .8364488281250E+04, -.1446133544922E+04, .1038539184570E+04},
 {    9345, .8377564453125E+04, -.1438818481445E+04, .1032685058594E+04},
 {    9346, .8389626953125E+04, -.1429643188477E+04, .1027285156250E+04},
 {    9347, .8400454101562E+04, -.1418774414062E+04, .1022438598633E+04},
 {    9348, .8409847656250E+04, -.1406409423828E+04, .1018233276367E+04},
 {    9349, .8417638671875E+04, -.1392772827148E+04, .1014745544434E+04},
 {    9350, .8423685546875E+04, -.1378112426758E+04, .1012038696289E+04},
 {    9351, .8427877929688E+04, -.1362694335938E+04, .1010161621094E+04},
 {    9352, .8430143554688E+04, -.1346798461914E+04, .1009148254395E+04},
 {    9354, .8322922851562E+04, -.1437100830078E+04, .1025838623047E+04},
 {    9355, .8335721679688E+04, -.1434441162109E+04, .1020109558105E+04},
 {    9356, .8348119140625E+04, -.1430054443359E+04, .1014559631348E+04},
 {    9357, .8359921875000E+04, -.1424009033203E+04, .1009276367188E+04},
 {    9358, .8370941406250E+04, -.1416399414062E+04, .1004342224121E+04},
 {    9359, .8381010742188E+04, -.1407343994141E+04, .9998345947266E+03},
 {    9360, .8389973632812E+04, -.1396984130859E+04, .9958225708008E+03},
 {    9361, .8397687500000E+04, -.1385481323242E+04, .9923696899414E+03},
 {    9362, .8404031250000E+04, -.1373015014648E+04, .9895295410156E+03},
 {    9363, .8408909179688E+04, -.1359779541016E+04, .9873461914062E+03},
 {    9364, .8412242187500E+04, -.1345981323242E+04, .9858543701172E+03},
 {    9365, .8413980468750E+04, -.1331835571289E+04, .9850762329102E+03},
 {    9366, .8323746093750E+04, -.1445894409180E+04, .1025469970703E+04},
 {    9367, .8337338867188E+04, -.1442948364258E+04, .1019385620117E+04},
 {    9368, .8350466796875E+04, -.1438093994141E+04, .1013508666992E+04},
 {    9369, .8362904296875E+04, -.1431413818359E+04, .1007940185547E+04},
 {    9370, .8374447265625E+04, -.1423021240234E+04, .1002773193359E+04},
 {    9371, .8384894531250E+04, -.1413059204102E+04, .9980961914062E+03},
 {    9372, .8394074218750E+04, -.1401696777344E+04, .9939877319336E+03},
 {    9373, .8401825195312E+04, -.1389127075195E+04, .9905170898438E+03},
 {    9374, .8408020507812E+04, -.1375563720703E+04, .9877436523438E+03},
 {    9375, .8412557617188E+04, -.1361236938477E+04, .9857133789062E+03},
 {    9376, .8415354492188E+04, -.1346389892578E+04, .9844610595703E+03},
 {    9378, .8324572265625E+04, -.1454687988281E+04, .1025100830078E+04},
 {    9379, .8338956054688E+04, -.1451455566406E+04, .1018661499023E+04},
 {    9380, .8352812500000E+04, -.1446133544922E+04, .1012458374023E+04},
 {    9381, .8365890625000E+04, -.1438818481445E+04, .1006603393555E+04},
 {    9382, .8377950195312E+04, -.1429643188477E+04, .1001204223633E+04},
 {    9383, .8388777343750E+04, -.1418774414062E+04, .9963576660156E+03},
 {    9384, .8398172851562E+04, -.1406409423828E+04, .9921522827148E+03},
 {    9385, .8405962890625E+04, -.1392772827148E+04, .9886646728516E+03},
 {    9386, .8412010742188E+04, -.1378112426758E+04, .9859576416016E+03},
 {    9387, .8416203125000E+04, -.1362694335938E+04, .9840812377930E+03},
 {    9388, .8418466796875E+04, -.1346798461914E+04, .9830673217773E+03},
 {    9390, .8311246093750E+04, -.1437100830078E+04, .9997579345703E+03},
 {    9391, .8324047851562E+04, -.1434441162109E+04, .9940277099609E+03},
 {    9392, .8336444335938E+04, -.1430054443359E+04, .9884782104492E+03},
 {    9393, .8348246093750E+04, -.1424009033203E+04, .9831954345703E+03},
 {    9394, .8359264648438E+04, -.1416399414062E+04, .9782612304688E+03},
 {    9395, .8369336914062E+04, -.1407343994141E+04, .9737531738281E+03},
 {    9396, .8378296875000E+04, -.1396984130859E+04, .9697418212891E+03},
 {    9397, .8386011718750E+04, -.1385481323242E+04, .9662888183594E+03},
 {    9398, .8392356445312E+04, -.1373015014648E+04, .9634486083984E+03},
 {    9399, .8397233398438E+04, -.1359779541016E+04, .9612656250000E+03},
 {    9400, .8400567382812E+04, -.1345981323242E+04, .9597734375000E+03},
 {    9401, .8402303710938E+04, -.1331835571289E+04, .9589953613281E+03},
 {    9402, .8312072265625E+04, -.1445894409180E+04, .9993889160156E+03},
 {    9403, .8325664062500E+04, -.1442948364258E+04, .9933045043945E+03},
 {    9404, .8338791015625E+04, -.1438093994141E+04, .9874279785156E+03},
 {    9405, .8351228515625E+04, -.1431413818359E+04, .9818591918945E+03},
 {    9406, .8362770507812E+04, -.1423021240234E+04, .9766923217773E+03},
 {    9407, .8373218750000E+04, -.1413059204102E+04, .9720150146484E+03},
 {    9408, .8382398437500E+04, -.1401696777344E+04, .9679062500000E+03},
 {    9409, .8390149414062E+04, -.1389127075195E+04, .9644364013672E+03},
 {    9410, .8396344726562E+04, -.1375563720703E+04, .9616628417969E+03},
 {    9411, .8400880859375E+04, -.1361236938477E+04, .9596322631836E+03},
 {    9412, .8403679687500E+04, -.1346389892578E+04, .9583799438477E+03},
 {    9414, .8312897460938E+04, -.1454687988281E+04, .9990200195312E+03},
 {    9415, .8327279296875E+04, -.1451455688477E+04, .9925809936523E+03},
 {    9416, .8341136718750E+04, -.1446133544922E+04, .9863776855469E+03},
 {    9417, .8354214843750E+04, -.1438818481445E+04, .9805228881836E+03},
 {    9418, .8366276367188E+04, -.1429643188477E+04, .9751231689453E+03},
 {    9419, .8377102539062E+04, -.1418774414062E+04, .9702769775391E+03},
 {    9420, .8386497070312E+04, -.1406409423828E+04, .9660716552734E+03},
 {    9421, .8394289062500E+04, -.1392772949219E+04, .9625834960938E+03},
 {    9422, .8400333984375E+04, -.1378112426758E+04, .9598768310547E+03},
 {    9423, .8404528320312E+04, -.1362694335938E+04, .9579998779297E+03},
 {    9424, .8406791992188E+04, -.1346798461914E+04, .9569868774414E+03},
 {    9426, .8299573242188E+04, -.1437100830078E+04, .9736770019531E+03},
 {    9427, .8312372070312E+04, -.1434441162109E+04, .9679470825195E+03},
 {    9428, .8324768554688E+04, -.1430054443359E+04, .9623973388672E+03},
 {    9429, .8336569335938E+04, -.1424009033203E+04, .9571144409180E+03},
 {    9430, .8347588867188E+04, -.1416399414062E+04, .9521807250977E+03},
 {    9431, .8357660156250E+04, -.1407343994141E+04, .9476726684570E+03},
 {    9432, .8366622070312E+04, -.1396984130859E+04, .9436605834961E+03},
 {    9433, .8374337890625E+04, -.1385481323242E+04, .9402077026367E+03},
 {    9434, .8380680664062E+04, -.1373015014648E+04, .9373677978516E+03},
 {    9435, .8385557617188E+04, -.1359779541016E+04, .9351845703125E+03},
 {    9436, .8388891601562E+04, -.1345981323242E+04, .9336923828125E+03},
 {    9437, .8390627929688E+04, -.1331835571289E+04, .9329145507812E+03},
 {    9438, .8300396484375E+04, -.1445894409180E+04, .9733081054688E+03},
 {    9439, .8313987304688E+04, -.1442948364258E+04, .9672237548828E+03},
 {    9440, .8327114257812E+04, -.1438093994141E+04, .9613470458984E+03},
 {    9441, .8339556640625E+04, -.1431413818359E+04, .9557781372070E+03},
 {    9442, .8351095703125E+04, -.1423021240234E+04, .9506113281250E+03},
 {    9443, .8361543945312E+04, -.1413059204102E+04, .9459339599609E+03},
 {    9444, .8370722656250E+04, -.1401696777344E+04, .9418255615234E+03},
 {    9445, .8378474609375E+04, -.1389127075195E+04, .9383551635742E+03},
 {    9446, .8384670898438E+04, -.1375563720703E+04, .9355819091797E+03},
 {    9447, .8389206054688E+04, -.1361236938477E+04, .9335515136719E+03},
 {    9448, .8392002929688E+04, -.1346389892578E+04, .9322990722656E+03},
 {    9450, .8301220703125E+04, -.1454687988281E+04, .9729389648438E+03},
 {    9451, .8315604492188E+04, -.1451455688477E+04, .9664996337891E+03},
 {    9452, .8329462890625E+04, -.1446133544922E+04, .9602962646484E+03},
 {    9453, .8342539062500E+04, -.1438818481445E+04, .9544420166016E+03},
 {    9454, .8354600585938E+04, -.1429643188477E+04, .9490423583984E+03},
 {    9455, .8365427734375E+04, -.1418774414062E+04, .9441959838867E+03},
 {    9456, .8374823242188E+04, -.1406409423828E+04, .9399902954102E+03},
 {    9457, .8382613281250E+04, -.1392772949219E+04, .9365028076172E+03},
 {    9458, .8388660156250E+04, -.1378112426758E+04, .9337952880859E+03},
 {    9459, .8392850585938E+04, -.1362694335938E+04, .9319188842773E+03},
 {    9460, .8395116210938E+04, -.1346798461914E+04, .9309057617188E+03},
 {    9462, .8294381835938E+04, -.1437100830078E+04, .9620854492188E+03},
 {    9463, .8307182617188E+04, -.1434441162109E+04, .9563554077148E+03},
 {    9464, .8319578125000E+04, -.1430054443359E+04, .9508060913086E+03},
 {    9465, .8331381835938E+04, -.1424009033203E+04, .9455229492188E+03},
 {    9466, .8342403320312E+04, -.1416399414062E+04, .9405887451172E+03},
 {    9467, .8352471679688E+04, -.1407343994141E+04, .9360811767578E+03},
 {    9468, .8361432617188E+04, -.1396984130859E+04, .9320693359375E+03},
 {    9469, .8369147460938E+04, -.1385481323242E+04, .9286163330078E+03},
 {    9470, .8375492187500E+04, -.1373015014648E+04, .9257759399414E+03},
 {    9471, .8380369140625E+04, -.1359779541016E+04, .9235928955078E+03},
 {    9472, .8383703125000E+04, -.1345981323242E+04, .9221005859375E+03},
 {    9473, .8385440429688E+04, -.1331835571289E+04, .9213228759766E+03},
 {    9474, .8295207031250E+04, -.1445894409180E+04, .9617164306641E+03},
 {    9475, .8308798828125E+04, -.1442948364258E+04, .9556322631836E+03},
 {    9476, .8321926757812E+04, -.1438093994141E+04, .9497553710938E+03},
 {    9477, .8334363281250E+04, -.1431413818359E+04, .9441870117188E+03},
 {    9478, .8345906250000E+04, -.1423021240234E+04, .9390198364258E+03},
 {    9479, .8356356445312E+04, -.1413059204102E+04, .9343424682617E+03},
 {    9480, .8365534179688E+04, -.1401696777344E+04, .9302342529297E+03},
 {    9481, .8373285156250E+04, -.1389127075195E+04, .9267637939453E+03},
 {    9482, .8379480468750E+04, -.1375563720703E+04, .9239905395508E+03},
 {    9483, .8384015625000E+04, -.1361236938477E+04, .9219601440430E+03},
 {    9484, .8386814453125E+04, -.1346389892578E+04, .9207072753906E+03},
 {    9486, .8296032226562E+04, -.1454687988281E+04, .9613473510742E+03},
 {    9487, .8310416015625E+04, -.1451455688477E+04, .9549080200195E+03},
 {    9488, .8324271484375E+04, -.1446133544922E+04, .9487050781250E+03},
 {    9489, .8337351562500E+04, -.1438818481445E+04, .9428501586914E+03},
 {    9490, .8349412109375E+04, -.1429643188477E+04, .9374510498047E+03},
 {    9491, .8360238281250E+04, -.1418774414062E+04, .9326045532227E+03},
 {    9492, .8369631835938E+04, -.1406409423828E+04, .9283994140625E+03},
 {    9493, .8377423828125E+04, -.1392772949219E+04, .9249114379883E+03},
 {    9494, .8383468750000E+04, -.1378112426758E+04, .9222044677734E+03},
 {    9495, .8387664062500E+04, -.1362694335938E+04, .9203271484375E+03},
 {    9496, .8389927734375E+04, -.1346798461914E+04, .9193142089844E+03},
 {    9498, .8289193359375E+04, -.1437100830078E+04, .9504938964844E+03},
 {    9499, .8301991210938E+04, -.1434441162109E+04, .9447644042969E+03},
 {    9500, .8314392578125E+04, -.1430054443359E+04, .9392141113281E+03},
 {    9501, .8326192382812E+04, -.1424009033203E+04, .9339314575195E+03},
 {    9502, .8337213867188E+04, -.1416399414062E+04, .9289973144531E+03},
 {    9503, .8347285156250E+04, -.1407343994141E+04, .9244891967773E+03},
 {    9504, .8356245117188E+04, -.1396984130859E+04, .9204776000977E+03},
 {    9505, .8363958984375E+04, -.1385481323242E+04, .9170246582031E+03},
 {    9506, .8370301757812E+04, -.1373015014648E+04, .9141845703125E+03},
 {    9507, .8375179687500E+04, -.1359779541016E+04, .9120015869141E+03},
 {    9508, .8378514648438E+04, -.1345981323242E+04, .9105090942383E+03},
 {    9509, .8380252929688E+04, -.1331835571289E+04, .9097310180664E+03},
 {    9510, .8290018554688E+04, -.1445894409180E+04, .9501248779297E+03},
 {    9511, .8303610351562E+04, -.1442948364258E+04, .9440401611328E+03},
 {    9512, .8316737304688E+04, -.1438093994141E+04, .9381639404297E+03},
 {    9513, .8329175781250E+04, -.1431413818359E+04, .9325953979492E+03},
 {    9514, .8340718750000E+04, -.1423021240234E+04, .9274283447266E+03},
 {    9515, .8351166992188E+04, -.1413059204102E+04, .9227509765625E+03},
 {    9516, .8360343750000E+04, -.1401696777344E+04, .9186427612305E+03},
 {    9517, .8368096679688E+04, -.1389127075195E+04, .9151721801758E+03},
 {    9518, .8374292968750E+04, -.1375563720703E+04, .9123985595703E+03},
 {    9519, .8378827148438E+04, -.1361236938477E+04, .9103685302734E+03},
 {    9520, .8381623046875E+04, -.1346389892578E+04, .9091159667969E+03},
 {    9522, .8290840820312E+04, -.1454687988281E+04, .9497559814453E+03},
 {    9523, .8305226562500E+04, -.1451455688477E+04, .9433165893555E+03},
 {    9524, .8319083984375E+04, -.1446133544922E+04, .9371134033203E+03},
 {    9525, .8332161132812E+04, -.1438818481445E+04, .9312589111328E+03},
 {    9526, .8344222656250E+04, -.1429643188477E+04, .9258593139648E+03},
 {    9527, .8355051757812E+04, -.1418774414062E+04, .9210127563477E+03},
 {    9528, .8364443359375E+04, -.1406409423828E+04, .9168078002930E+03},
 {    9529, .8372234375000E+04, -.1392772949219E+04, .9133197631836E+03},
 {    9530, .8378279296875E+04, -.1378112426758E+04, .9106125488281E+03},
 {    9531, .8382474609375E+04, -.1362694335938E+04, .9087354125977E+03},
 {    9532, .8384737304688E+04, -.1346798461914E+04, .9077226562500E+03},
 {    9534, .8284005859375E+04, -.1437100830078E+04, .9389019775391E+03},
 {    9535, .8296804687500E+04, -.1434441162109E+04, .9331726074219E+03},
 {    9536, .8309201171875E+04, -.1430054443359E+04, .9276229248047E+03},
 {    9537, .8321003906250E+04, -.1424009033203E+04, .9223397216797E+03},
 {    9538, .8332024414062E+04, -.1416399414062E+04, .9174059448242E+03},
 {    9539, .8342094726562E+04, -.1407343994141E+04, .9128980102539E+03},
 {    9540, .8351055664062E+04, -.1396984130859E+04, .9088862304688E+03},
 {    9541, .8358769531250E+04, -.1385481323242E+04, .9054331665039E+03},
 {    9542, .8365113281250E+04, -.1373015014648E+04, .9025930175781E+03},
 {    9543, .8369991210938E+04, -.1359779541016E+04, .9004100341797E+03},
 {    9544, .8373323242188E+04, -.1345981323242E+04, .8989176025391E+03},
 {    9545, .8375061523438E+04, -.1331835571289E+04, .8981396484375E+03},
 {    9546, .8284829101562E+04, -.1445894409180E+04, .9385336914062E+03},
 {    9547, .8298420898438E+04, -.1442948364258E+04, .9324487915039E+03},
 {    9548, .8311546875000E+04, -.1438093994141E+04, .9265722656250E+03},
 {    9549, .8323988281250E+04, -.1431413818359E+04, .9210035400391E+03},
 {    9550, .8335528320312E+04, -.1423021240234E+04, .9158368530273E+03},
 {    9551, .8345976562500E+04, -.1413059204102E+04, .9111595458984E+03},
 {    9552, .8355155273438E+04, -.1401696777344E+04, .9070510253906E+03},
 {    9553, .8362907226562E+04, -.1389127075195E+04, .9035806884766E+03},
 {    9554, .8369101562500E+04, -.1375563720703E+04, .9008073730469E+03},
 {    9555, .8373636718750E+04, -.1361236938477E+04, .8987772216797E+03},
 {    9556, .8376435546875E+04, -.1346389892578E+04, .8975242919922E+03},
 {    9558, .8285652343750E+04, -.1454687988281E+04, .9381646118164E+03},
 {    9559, .8300037109375E+04, -.1451455688477E+04, .9317251586914E+03},
 {    9560, .8313894531250E+04, -.1446133544922E+04, .9255218505859E+03},
 {    9561, .8326972656250E+04, -.1438818481445E+04, .9196674194336E+03},
 {    9562, .8339037109375E+04, -.1429643188477E+04, .9142673950195E+03},
 {    9563, .8349859375000E+04, -.1418774414062E+04, .9094213867188E+03},
 {    9564, .8359255859375E+04, -.1406409423828E+04, .9052159423828E+03},
 {    9565, .8367047851562E+04, -.1392772949219E+04, .9017278442383E+03},
 {    9566, .8373092773438E+04, -.1378112426758E+04, .8990209350586E+03},
 {    9567, .8377287109375E+04, -.1362694335938E+04, .8971441040039E+03},
 {    9568, .8379548828125E+04, -.1346798461914E+04, .8961311035156E+03},
 {    9570, .8419711914062E+04, -.1202382934570E+04, .1045124511719E+04},
 {    9572, .8422875976562E+04, -.1200798950195E+04, .1043709350586E+04},
 {    9573, .8418489257812E+04, -.1191932617188E+04, .1045672363281E+04},
 {    9574, .8414524414062E+04, -.1202382934570E+04, .1033533081055E+04},
 {    9576, .8417685546875E+04, -.1200798950195E+04, .1032117431641E+04},
 {    9577, .8413298828125E+04, -.1191932617188E+04, .1034080688477E+04},
 {    9578, .8409334960938E+04, -.1202382934570E+04, .1021941223145E+04},
 {    9580, .8412496093750E+04, -.1200798950195E+04, .1020526123047E+04},
 {    9581, .8408112304688E+04, -.1191932617188E+04, .1022489257812E+04},
 {    9582, .8426039062500E+04, -.1199214843750E+04, .1042293090820E+04},
 {    9583, .8421426757812E+04, -.1189894165039E+04, .1044357177734E+04},
 {    9584, .8420850585938E+04, -.1199214843750E+04, .1030701538086E+04},
 {    9585, .8416237304688E+04, -.1189894165039E+04, .1032766357422E+04},
 {    9586, .8415661132812E+04, -.1199214843750E+04, .1019110229492E+04},
 {    9587, .8411046875000E+04, -.1189894165039E+04, .1021174560547E+04},
 {    9591, .8371952148438E+04, -.1154726684570E+04, .1066505126953E+04},
 {    9594, .8408650390625E+04, -.1177040649414E+04, .1050076171875E+04},
 {    9595, .8398184570312E+04, -.1166256225586E+04, .1054761962891E+04},
 {    9596, .8386220703125E+04, -.1157537475586E+04, .1060117797852E+04},
 {    9597, .8373097656250E+04, -.1151129028320E+04, .1065992675781E+04},
 {    9598, .8357102539062E+04, -.1147019042969E+04, .1073153442383E+04},
 {    9599, .8344863281250E+04, -.1145892089844E+04, .1078632080078E+04},
 {    9603, .8366762695312E+04, -.1154726684570E+04, .1054913818359E+04},
 {    9606, .8403463867188E+04, -.1177040649414E+04, .1038485107422E+04},
 {    9607, .8392996093750E+04, -.1166256225586E+04, .1043170410156E+04},
 {    9608, .8381033203125E+04, -.1157537475586E+04, .1048526123047E+04},
 {    9609, .8367907226562E+04, -.1151129028320E+04, .1054401123047E+04},
 {    9610, .8351912109375E+04, -.1147019042969E+04, .1061562011719E+04},
 {    9611, .8339673828125E+04, -.1145892089844E+04, .1067040649414E+04},
 {    9615, .8361575195312E+04, -.1154726684570E+04, .1043322509766E+04},
 {    9618, .8398273437500E+04, -.1177040649414E+04, .1026893554688E+04},
 {    9619, .8387805664062E+04, -.1166256225586E+04, .1031579345703E+04},
 {    9620, .8375843750000E+04, -.1157537475586E+04, .1036934936523E+04},
 {    9621, .8362716796875E+04, -.1151129028320E+04, .1042809814453E+04},
 {    9622, .8346723632812E+04, -.1147019042969E+04, .1049970336914E+04},
 {    9623, .8334484375000E+04, -.1145892089844E+04, .1055449218750E+04},
 {    9624, .8411239257812E+04, -.1174493408203E+04, .1048919067383E+04},
 {    9625, .8400345703125E+04, -.1163271850586E+04, .1053794921875E+04},
 {    9626, .8387897460938E+04, -.1154199584961E+04, .1059367309570E+04},
 {    9627, .8374240234375E+04, -.1147531250000E+04, .1065480712891E+04},
 {    9628, .8357681640625E+04, -.1143262573242E+04, .1072893432617E+04},
 {    9629, .8344863281250E+04, -.1142082031250E+04, .1078632080078E+04},
 {    9630, .8406048828125E+04, -.1174493408203E+04, .1037327148438E+04},
 {    9631, .8395157226562E+04, -.1163271850586E+04, .1042202636719E+04},
 {    9632, .8382708007812E+04, -.1154199584961E+04, .1047775634766E+04},
 {    9633, .8369051757812E+04, -.1147531250000E+04, .1053889038086E+04},
 {    9634, .8352493164062E+04, -.1143262573242E+04, .1061302001953E+04},
 {    9635, .8339673828125E+04, -.1142082031250E+04, .1067040649414E+04},
 {    9636, .8400859375000E+04, -.1174493408203E+04, .1025735229492E+04},
 {    9637, .8389969726562E+04, -.1163271850586E+04, .1030611328125E+04},
 {    9638, .8377520507812E+04, -.1154199584961E+04, .1036184204102E+04},
 {    9639, .8363862304688E+04, -.1147531250000E+04, .1042297729492E+04},
 {    9640, .8347303710938E+04, -.1143262573242E+04, .1049710937500E+04},
 {    9641, .8334484375000E+04, -.1142082031250E+04, .1055449218750E+04},
 {    9644, .8333272460938E+04, -.1145892089844E+04, .1083821044922E+04},
 {    9645, .8321680664062E+04, -.1145892089844E+04, .1089010131836E+04},
 {    9648, .8328083007812E+04, -.1145892089844E+04, .1072229858398E+04},
 {    9649, .8316491210938E+04, -.1145892089844E+04, .1077418945312E+04},
 {    9652, .8322892578125E+04, -.1145892089844E+04, .1060638183594E+04},
 {    9653, .8311302734375E+04, -.1145892089844E+04, .1065827270508E+04},
 {    9654, .8333272460938E+04, -.1142082031250E+04, .1083821044922E+04},
 {    9655, .8321680664062E+04, -.1142082031250E+04, .1089010131836E+04},
 {    9656, .8328083007812E+04, -.1142082031250E+04, .1072229858398E+04},
 {    9657, .8316491210938E+04, -.1142082031250E+04, .1077418945312E+04},
 {    9658, .8322892578125E+04, -.1142082031250E+04, .1060638183594E+04},
 {    9659, .8311302734375E+04, -.1142082031250E+04, .1065827270508E+04},
 {    9665, .8242452148438E+04, -.1215458862305E+04, .1124476562500E+04},
 {    9666, .8309171875000E+04, -.1146974853516E+04, .1094610229492E+04},
 {    9667, .8280581054688E+04, -.1157930908203E+04, .1107408813477E+04},
 {    9668, .8269883789062E+04, -.1164960327148E+04, .1112197265625E+04},
 {    9669, .8256430664062E+04, -.1178871582031E+04, .1118221191406E+04},
 {    9670, .8246790039062E+04, -.1194361083984E+04, .1122535522461E+04},
 {    9671, .8239105468750E+04, -.1214427368164E+04, .1125975463867E+04},
 {    9677, .8237266601562E+04, -.1215458862305E+04, .1112884887695E+04},
 {    9678, .8303983398438E+04, -.1146974853516E+04, .1083018310547E+04},
 {    9679, .8275394531250E+04, -.1157930908203E+04, .1095816894531E+04},
 {    9680, .8264694335938E+04, -.1164960327148E+04, .1100606445312E+04},
 {    9681, .8251239257812E+04, -.1178871582031E+04, .1106629882812E+04},
 {    9682, .8241603515625E+04, -.1194361083984E+04, .1110943847656E+04},
 {    9683, .8233917968750E+04, -.1214427368164E+04, .1114383789062E+04},
 {    9689, .8232075195312E+04, -.1215458862305E+04, .1101293945312E+04},
 {    9690, .8298792968750E+04, -.1146974853516E+04, .1071427246094E+04},
 {    9691, .8270203125000E+04, -.1157930908203E+04, .1084225830078E+04},
 {    9692, .8259505859375E+04, -.1164960327148E+04, .1089014404297E+04},
 {    9693, .8246049804688E+04, -.1178871582031E+04, .1095038452148E+04},
 {    9694, .8236412109375E+04, -.1194361083984E+04, .1099352905273E+04},
 {    9695, .8228728515625E+04, -.1214427368164E+04, .1102792358398E+04},
 {    9696, .8308424804688E+04, -.1143253540039E+04, .1094944213867E+04},
 {    9697, .8279124023438E+04, -.1154471313477E+04, .1108061279297E+04},
 {    9698, .8267785156250E+04, -.1161923339844E+04, .1113137695312E+04},
 {    9699, .8253783203125E+04, -.1176398559570E+04, .1119405517578E+04},
 {    9700, .8243722656250E+04, -.1192567016602E+04, .1123909423828E+04},
 {    9701, .8235757812500E+04, -.1213395874023E+04, .1127474243164E+04},
 {    9702, .8303238281250E+04, -.1143253540039E+04, .1083352416992E+04},
 {    9703, .8273935546875E+04, -.1154471313477E+04, .1096469238281E+04},
 {    9704, .8262595703125E+04, -.1161923339844E+04, .1101545898438E+04},
 {    9705, .8248590820312E+04, -.1176398559570E+04, .1107814697266E+04},
 {    9706, .8238535156250E+04, -.1192567016602E+04, .1112317138672E+04},
 {    9707, .8230570312500E+04, -.1213395874023E+04, .1115882690430E+04},
 {    9708, .8298047851562E+04, -.1143253540039E+04, .1071760742188E+04},
 {    9709, .8268746093750E+04, -.1154471313477E+04, .1084878051758E+04},
 {    9710, .8257405273438E+04, -.1161923339844E+04, .1089954956055E+04},
 {    9711, .8243403320312E+04, -.1176398559570E+04, .1096222167969E+04},
 {    9712, .8233343750000E+04, -.1192567016602E+04, .1100726318359E+04},
 {    9713, .8225382812500E+04, -.1213395874023E+04, .1104290893555E+04},
 {    9714, .8239856445312E+04, -.1230180419922E+04, .1125639648438E+04},
 {    9715, .8236400390625E+04, -.1229770874023E+04, .1127187011719E+04},
 {    9716, .8234666015625E+04, -.1230180419922E+04, .1114048095703E+04},
 {    9717, .8231211914062E+04, -.1229770874023E+04, .1115595214844E+04},
 {    9718, .8229478515625E+04, -.1230180419922E+04, .1102456420898E+04},
 {    9719, .8226023437500E+04, -.1229770874023E+04, .1104003784180E+04},
 {    9720, .8232941406250E+04, -.1229361450195E+04, .1128734863281E+04},
 {    9721, .8227752929688E+04, -.1229361450195E+04, .1117143188477E+04},
 {    9722, .8222564453125E+04, -.1229361450195E+04, .1105552001953E+04},
 {    9723, .8408037109375E+04, -.1202382934570E+04, .1019044189453E+04},
 {    9725, .8411199218750E+04, -.1200798950195E+04, .1017627929688E+04},
 {    9726, .8406813476562E+04, -.1191932617188E+04, .1019591613770E+04},
 {    9727, .8402847656250E+04, -.1202382934570E+04, .1007452026367E+04},
 {    9729, .8406011718750E+04, -.1200798950195E+04, .1006036499023E+04},
 {    9730, .8401625000000E+04, -.1191932617188E+04, .1007999633789E+04},
 {    9731, .8397659179688E+04, -.1202382934570E+04, .9958609008789E+03},
 {    9733, .8400821289062E+04, -.1200798950195E+04, .9944456176758E+03},
 {    9734, .8396436523438E+04, -.1191932617188E+04, .9964083251953E+03},
 {    9735, .8414363281250E+04, -.1199214843750E+04, .1016212158203E+04},
 {    9736, .8409751953125E+04, -.1189894165039E+04, .1018276428223E+04},
 {    9737, .8409173828125E+04, -.1199214843750E+04, .1004620971680E+04},
 {    9738, .8404561523438E+04, -.1189894165039E+04, .1006684326172E+04},
 {    9739, .8403985351562E+04, -.1199214843750E+04, .9930291748047E+03},
 {    9740, .8399372070312E+04, -.1189894165039E+04, .9950935668945E+03},
 {    9744, .8360277343750E+04, -.1154726684570E+04, .1040424072266E+04},
 {    9747, .8396976562500E+04, -.1177040649414E+04, .1023995361328E+04},
 {    9748, .8386509765625E+04, -.1166256225586E+04, .1028680908203E+04},
 {    9749, .8374545898438E+04, -.1157537475586E+04, .1034036621094E+04},
 {    9750, .8361422851562E+04, -.1151129028320E+04, .1039911987305E+04},
 {    9751, .8345427734375E+04, -.1147019042969E+04, .1047071655273E+04},
 {    9752, .8333187500000E+04, -.1145892089844E+04, .1052551025391E+04},
 {    9756, .8355086914062E+04, -.1154726684570E+04, .1028832397461E+04},
 {    9759, .8391787109375E+04, -.1177040649414E+04, .1012403808594E+04},
 {    9760, .8381321289062E+04, -.1166256225586E+04, .1017090332031E+04},
 {    9761, .8369357421875E+04, -.1157537475586E+04, .1022445068359E+04},
 {    9762, .8356234375000E+04, -.1151129028320E+04, .1028320556641E+04},
 {    9763, .8340237304688E+04, -.1147019042969E+04, .1035481201172E+04},
 {    9764, .8327998046875E+04, -.1145892089844E+04, .1040959594727E+04},
 {    9768, .8349899414062E+04, -.1154726684570E+04, .1017241699219E+04},
 {    9771, .8386598632812E+04, -.1177040649414E+04, .1000812438965E+04},
 {    9772, .8376132812500E+04, -.1166256225586E+04, .1005497802734E+04},
 {    9773, .8364167968750E+04, -.1157537475586E+04, .1010854064941E+04},
 {    9774, .8351043945312E+04, -.1151129028320E+04, .1016728881836E+04},
 {    9775, .8335046875000E+04, -.1147019042969E+04, .1023889282227E+04},
 {    9776, .8322810546875E+04, -.1145892089844E+04, .1029367919922E+04},
 {    9777, .8399562500000E+04, -.1174493408203E+04, .1022837768555E+04},
 {    9778, .8388670898438E+04, -.1163271850586E+04, .1027713623047E+04},
 {    9779, .8376223632812E+04, -.1154199584961E+04, .1033285888672E+04},
 {    9780, .8362566406250E+04, -.1147531250000E+04, .1039399536133E+04},
 {    9781, .8346006835938E+04, -.1143262573242E+04, .1046812500000E+04},
 {    9782, .8333187500000E+04, -.1142082031250E+04, .1052551025391E+04},
 {    9783, .8394375000000E+04, -.1174493408203E+04, .1011246093750E+04},
 {    9784, .8383481445312E+04, -.1163271850586E+04, .1016121948242E+04},
 {    9785, .8371033203125E+04, -.1154199584961E+04, .1021694824219E+04},
 {    9786, .8357376953125E+04, -.1147531250000E+04, .1027807617188E+04},
 {    9787, .8340817382812E+04, -.1143262573242E+04, .1035220825195E+04},
 {    9788, .8327998046875E+04, -.1142082031250E+04, .1040959594727E+04},
 {    9789, .8389184570312E+04, -.1174493408203E+04, .9996542968750E+03},
 {    9790, .8378293945312E+04, -.1163271850586E+04, .1004530456543E+04},
 {    9791, .8365845703125E+04, -.1154199584961E+04, .1010103088379E+04},
 {    9792, .8352188476562E+04, -.1147531250000E+04, .1016216796875E+04},
 {    9793, .8335628906250E+04, -.1143262573242E+04, .1023629333496E+04},
 {    9794, .8322810546875E+04, -.1142082031250E+04, .1029367919922E+04},
 {    9797, .8321595703125E+04, -.1145892089844E+04, .1057740356445E+04},
 {    9798, .8310006835938E+04, -.1145892089844E+04, .1062929321289E+04},
 {    9801, .8316409179688E+04, -.1145892089844E+04, .1046148437500E+04},
 {    9802, .8304816406250E+04, -.1145892089844E+04, .1051337646484E+04},
 {    9805, .8311216796875E+04, -.1145892089844E+04, .1034557128906E+04},
 {    9806, .8299626953125E+04, -.1145892089844E+04, .1039746093750E+04},
 {    9807, .8321595703125E+04, -.1142082031250E+04, .1057740356445E+04},
 {    9808, .8310006835938E+04, -.1142082031250E+04, .1062929321289E+04},
 {    9809, .8316409179688E+04, -.1142082031250E+04, .1046148437500E+04},
 {    9810, .8304816406250E+04, -.1142082031250E+04, .1051337646484E+04},
 {    9811, .8311216796875E+04, -.1142082031250E+04, .1034557128906E+04},
 {    9812, .8299626953125E+04, -.1142082031250E+04, .1039746093750E+04},
 {    9818, .8230775390625E+04, -.1215458862305E+04, .1098395996094E+04},
 {    9819, .8297496093750E+04, -.1146974853516E+04, .1068529052734E+04},
 {    9820, .8268904296875E+04, -.1157930908203E+04, .1081328125000E+04},
 {    9821, .8258208984375E+04, -.1164960327148E+04, .1086116455078E+04},
 {    9822, .8244751953125E+04, -.1178871582031E+04, .1092140747070E+04},
 {    9823, .8235114257812E+04, -.1194361083984E+04, .1096454833984E+04},
 {    9824, .8227430664062E+04, -.1214427368164E+04, .1099894531250E+04},
 {    9830, .8225588867188E+04, -.1215458984375E+04, .1086804809570E+04},
 {    9831, .8292307617188E+04, -.1146974853516E+04, .1056937500000E+04},
 {    9832, .8263715820312E+04, -.1157930908203E+04, .1069736572266E+04},
 {    9833, .8253019531250E+04, -.1164960327148E+04, .1074525024414E+04},
 {    9834, .8239565429688E+04, -.1178871582031E+04, .1080548339844E+04},
 {    9835, .8229926757812E+04, -.1194361083984E+04, .1084863403320E+04},
 {    9836, .8222243164062E+04, -.1214427368164E+04, .1088302856445E+04},
 {    9842, .8220398437500E+04, -.1215458984375E+04, .1075213012695E+04},
 {    9843, .8287117187500E+04, -.1146974853516E+04, .1045346069336E+04},
 {    9844, .8258527343750E+04, -.1157930908203E+04, .1058144653320E+04},
 {    9845, .8247830078125E+04, -.1164960327148E+04, .1062933105469E+04},
 {    9846, .8234373046875E+04, -.1178871582031E+04, .1068957519531E+04},
 {    9847, .8224735351562E+04, -.1194361083984E+04, .1073271606445E+04},
 {    9848, .8217052734375E+04, -.1214427368164E+04, .1076711547852E+04},
 {    9849, .8296750000000E+04, -.1143253540039E+04, .1068862792969E+04},
 {    9850, .8267450195312E+04, -.1154471313477E+04, .1081979858398E+04},
 {    9851, .8256109375000E+04, -.1161923339844E+04, .1087056518555E+04},
 {    9852, .8242104492188E+04, -.1176398559570E+04, .1093324829102E+04},
 {    9853, .8232045898438E+04, -.1192567016602E+04, .1097827758789E+04},
 {    9854, .8224082031250E+04, -.1213395874023E+04, .1101393310547E+04},
 {    9855, .8291560546875E+04, -.1143253540039E+04, .1057271240234E+04},
 {    9856, .8262259765625E+04, -.1154471313477E+04, .1070388061523E+04},
 {    9857, .8250919921875E+04, -.1161923339844E+04, .1075464965820E+04},
 {    9858, .8236916015625E+04, -.1176398559570E+04, .1081733520508E+04},
 {    9859, .8226856445312E+04, -.1192567016602E+04, .1086236816406E+04},
 {    9860, .8218893554688E+04, -.1213395874023E+04, .1089802124023E+04},
 {    9861, .8286373046875E+04, -.1143253540039E+04, .1045679931641E+04},
 {    9862, .8257071289062E+04, -.1154471313477E+04, .1058797363281E+04},
 {    9863, .8245730468750E+04, -.1161923339844E+04, .1063873535156E+04},
 {    9864, .8231725585938E+04, -.1176398559570E+04, .1070142089844E+04},
 {    9865, .8221668945312E+04, -.1192567138672E+04, .1074645629883E+04},
 {    9866, .8213703125000E+04, -.1213395874023E+04, .1078210205078E+04},
 {    9867, .8228183593750E+04, -.1230180419922E+04, .1099558349609E+04},
 {    9868, .8224724609375E+04, -.1229770874023E+04, .1101106811523E+04},
 {    9869, .8222994140625E+04, -.1230180419922E+04, .1087966308594E+04},
 {    9870, .8219534179688E+04, -.1229770874023E+04, .1089515014648E+04},
 {    9871, .8217803710938E+04, -.1230180419922E+04, .1076375488281E+04},
 {    9872, .8214348632812E+04, -.1229770874023E+04, .1077922607422E+04},
 {    9873, .8221268554688E+04, -.1229361450195E+04, .1102653930664E+04},
 {    9874, .8216077148438E+04, -.1229361450195E+04, .1091062622070E+04},
 {    9875, .8210889648438E+04, -.1229361450195E+04, .1079470336914E+04},
 {    9876, .8396362304688E+04, -.1202382934570E+04, .9929628906250E+03},
 {    9878, .8399525390625E+04, -.1200798950195E+04, .9915468750000E+03},
 {    9879, .8395138671875E+04, -.1191932617188E+04, .9935108642578E+03},
 {    9880, .8391173828125E+04, -.1202382934570E+04, .9813710327148E+03},
 {    9882, .8394333984375E+04, -.1200798950195E+04, .9799558105469E+03},
 {    9883, .8389948242188E+04, -.1191932617188E+04, .9819192504883E+03},
 {    9884, .8385983398438E+04, -.1202382934570E+04, .9697799072266E+03},
 {    9886, .8389146484375E+04, -.1200798950195E+04, .9683641357422E+03},
 {    9887, .8384760742188E+04, -.1191932617188E+04, .9703276367188E+03},
 {    9888, .8402686523438E+04, -.1199214843750E+04, .9901316528320E+03},
 {    9889, .8398077148438E+04, -.1189894165039E+04, .9921954345703E+03},
 {    9890, .8397497070312E+04, -.1199214843750E+04, .9785399780273E+03},
 {    9891, .8392886718750E+04, -.1189894165039E+04, .9806035766602E+03},
 {    9892, .8392309570312E+04, -.1199214843750E+04, .9669484252930E+03},
 {    9893, .8387697265625E+04, -.1189894165039E+04, .9690126953125E+03},
 {    9897, .8348600585938E+04, -.1154726684570E+04, .1014343322754E+04},
 {    9900, .8385300781250E+04, -.1177040649414E+04, .9979141845703E+03},
 {    9901, .8374835937500E+04, -.1166256225586E+04, .1002599975586E+04},
 {    9902, .8362870117188E+04, -.1157537475586E+04, .1007956176758E+04},
 {    9903, .8349747070312E+04, -.1151129028320E+04, .1013830993652E+04},
 {    9904, .8333752929688E+04, -.1147019042969E+04, .1020991271973E+04},
 {    9905, .8321513671875E+04, -.1145892089844E+04, .1026470092773E+04},
 {    9909, .8343415039062E+04, -.1154726684570E+04, .1002751831055E+04},
 {    9912, .8380111328125E+04, -.1177040649414E+04, .9863228759766E+03},
 {    9913, .8369644531250E+04, -.1166256225586E+04, .9910084838867E+03},
 {    9914, .8357681640625E+04, -.1157537475586E+04, .9963640136719E+03},
 {    9915, .8344557617188E+04, -.1151129028320E+04, .1002239746094E+04},
 {    9916, .8328561523438E+04, -.1147019042969E+04, .1009399780273E+04},
 {    9917, .8316325195312E+04, -.1145892089844E+04, .1014878845215E+04},
 {    9921, .8338223632812E+04, -.1154726684570E+04, .9911601562500E+03},
 {    9924, .8374922851562E+04, -.1177040649414E+04, .9747314453125E+03},
 {    9925, .8364456054688E+04, -.1166256225586E+04, .9794169921875E+03},
 {    9926, .8352493164062E+04, -.1157537475586E+04, .9847727050781E+03},
 {    9927, .8339369140625E+04, -.1151129028320E+04, .9906474609375E+03},
 {    9928, .8323372070312E+04, -.1147019165039E+04, .9978082275391E+03},
 {    9929, .8311132812500E+04, -.1145892089844E+04, .1003287475586E+04},
 {    9930, .8387886718750E+04, -.1174493408203E+04, .9967568359375E+03},
 {    9931, .8376995117188E+04, -.1163271850586E+04, .1001632446289E+04},
 {    9932, .8364545898438E+04, -.1154199584961E+04, .1007205200195E+04},
 {    9933, .8350892578125E+04, -.1147531250000E+04, .1013318420410E+04},
 {    9934, .8334333007812E+04, -.1143262573242E+04, .1020731201172E+04},
 {    9935, .8321513671875E+04, -.1142082031250E+04, .1026470092773E+04},
 {    9936, .8382698242188E+04, -.1174493408203E+04, .9851648559570E+03},
 {    9937, .8371805664062E+04, -.1163271850586E+04, .9900411987305E+03},
 {    9938, .8359357421875E+04, -.1154199584961E+04, .9956135253906E+03},
 {    9939, .8345701171875E+04, -.1147531250000E+04, .1001727416992E+04},
 {    9940, .8329141601562E+04, -.1143262573242E+04, .1009140380859E+04},
 {    9941, .8316325195312E+04, -.1142082031250E+04, .1014878845215E+04},
 {    9942, .8377509765625E+04, -.1174493408203E+04, .9735735473633E+03},
 {    9943, .8366617187500E+04, -.1163271850586E+04, .9784497070312E+03},
 {    9944, .8354169921875E+04, -.1154199584961E+04, .9840219726562E+03},
 {    9945, .8340513671875E+04, -.1147531250000E+04, .9901351928711E+03},
 {    9946, .8323953125000E+04, -.1143262573242E+04, .9975488891602E+03},
 {    9947, .8311132812500E+04, -.1142082031250E+04, .1003287475586E+04},
 {    9950, .8309919921875E+04, -.1145892089844E+04, .1031659179688E+04},
 {    9951, .8298330078125E+04, -.1145892089844E+04, .1036848388672E+04},
 {    9954, .8304731445312E+04, -.1145892089844E+04, .1020067871094E+04},
 {    9955, .8293141601562E+04, -.1145892089844E+04, .1025256958008E+04},
 {    9958, .8299541992188E+04, -.1145892089844E+04, .1008476074219E+04},
 {    9959, .8287951171875E+04, -.1145892089844E+04, .1013665771484E+04},
 {    9960, .8309919921875E+04, -.1142082031250E+04, .1031659179688E+04},
 {    9961, .8298330078125E+04, -.1142082031250E+04, .1036848388672E+04},
 {    9962, .8304731445312E+04, -.1142082031250E+04, .1020067871094E+04},
 {    9963, .8293141601562E+04, -.1142082031250E+04, .1025256958008E+04},
 {    9964, .8299541992188E+04, -.1142082031250E+04, .1008476074219E+04},
 {    9965, .8287951171875E+04, -.1142082031250E+04, .1013665771484E+04},
 {    9971, .8219102539062E+04, -.1215458984375E+04, .1072315063477E+04},
 {    9972, .8285819335938E+04, -.1146974853516E+04, .1042448364258E+04},
 {    9973, .8257229492188E+04, -.1157930908203E+04, .1055246704102E+04},
 {    9974, .8246533203125E+04, -.1164960327148E+04, .1060035644531E+04},
 {    9975, .8233076171875E+04, -.1178871582031E+04, .1066059814453E+04},
 {    9976, .8223436523438E+04, -.1194361083984E+04, .1070374023438E+04},
 {    9977, .8215752929688E+04, -.1214427368164E+04, .1073814208984E+04},
 {    9983, .8213915039062E+04, -.1215458984375E+04, .1060723388672E+04},
 {    9984, .8280632812500E+04, -.1146974853516E+04, .1030856689453E+04},
 {    9985, .8252040039062E+04, -.1157930908203E+04, .1043655395508E+04},
 {    9986, .8241343750000E+04, -.1164960327148E+04, .1048444091797E+04},
 {    9987, .8227887695312E+04, -.1178871582031E+04, .1054468383789E+04},
 {    9988, .8218249023438E+04, -.1194361083984E+04, .1058781982422E+04},
 {    9989, .8210566406250E+04, -.1214427368164E+04, .1062222045898E+04},
 {    9995, .8208722656250E+04, -.1215458984375E+04, .1049131835938E+04},
 {    9996, .8275442382812E+04, -.1146974853516E+04, .1019265014648E+04},
 {    9997, .8246851562500E+04, -.1157930908203E+04, .1032063964844E+04},
 {    9998, .8236155273438E+04, -.1164960327148E+04, .1036852294922E+04},
 {    9999, .8222698242188E+04, -.1178871582031E+04, .1042876586914E+04},
 {   10000, .8213060546875E+04, -.1194361083984E+04, .1047190673828E+04},
 {   10001, .8205376953125E+04, -.1214427368164E+04, .1050630371094E+04},
 {   10002, .8285074218750E+04, -.1143253540039E+04, .1042781982422E+04},
 {   10003, .8255773437500E+04, -.1154471313477E+04, .1055899047852E+04},
 {   10004, .8244435546875E+04, -.1161923339844E+04, .1060974975586E+04},
 {   10005, .8230431640625E+04, -.1176398559570E+04, .1067243774414E+04},
 {   10006, .8220372070312E+04, -.1192567138672E+04, .1071747558594E+04},
 {   10007, .8212409179688E+04, -.1213395874023E+04, .1075311889648E+04},
 {   10008, .8279885742188E+04, -.1143253540039E+04, .1031190307617E+04},
 {   10009, .8250586914062E+04, -.1154471313477E+04, .1044307250977E+04},
 {   10010, .8239244140625E+04, -.1161923339844E+04, .1049384155273E+04},
 {   10011, .8225243164062E+04, -.1176398559570E+04, .1055651977539E+04},
 {   10012, .8215180664062E+04, -.1192567016602E+04, .1060156005859E+04},
 {   10013, .8207219726562E+04, -.1213395874023E+04, .1063720581055E+04},
 {   10014, .8274697265625E+04, -.1143253540039E+04, .1019599121094E+04},
 {   10015, .8245396484375E+04, -.1154471313477E+04, .1032715820312E+04},
 {   10016, .8234056640625E+04, -.1161923339844E+04, .1037792968750E+04},
 {   10017, .8220054687500E+04, -.1176398559570E+04, .1044060791016E+04},
 {   10018, .8209992187500E+04, -.1192567138672E+04, .1048563964844E+04},
 {   10019, .8202030273438E+04, -.1213395874023E+04, .1052129028320E+04},
 {   10020, .8216506835938E+04, -.1230180419922E+04, .1073477661133E+04},
 {   10021, .8213048828125E+04, -.1229770874023E+04, .1075025512695E+04},
 {   10022, .8211317382812E+04, -.1230180419922E+04, .1061886108398E+04},
 {   10023, .8207861328125E+04, -.1229770874023E+04, .1063433471680E+04},
 {   10024, .8206129882812E+04, -.1230180419922E+04, .1050294189453E+04},
 {   10025, .8202668945312E+04, -.1229770874023E+04, .1051842529297E+04},
 {   10026, .8209591796875E+04, -.1229361450195E+04, .1076572753906E+04},
 {   10027, .8204403320312E+04, -.1229361450195E+04, .1064980957031E+04},
 {   10028, .8199211914062E+04, -.1229361450195E+04, .1053390258789E+04},
 {   10029, .8384685546875E+04, -.1202382934570E+04, .9668822021484E+03},
 {   10031, .8387847656250E+04, -.1200798950195E+04, .9654664306641E+03},
 {   10032, .8383462890625E+04, -.1191932617188E+04, .9674299316406E+03},
 {   10033, .8379497070312E+04, -.1202382934570E+04, .9552908325195E+03},
 {   10035, .8382659179688E+04, -.1200798950195E+04, .9538746948242E+03},
 {   10036, .8378274414062E+04, -.1191932617188E+04, .9558381347656E+03},
 {   10037, .8374308593750E+04, -.1202382934570E+04, .9436990966797E+03},
 {   10039, .8377469726562E+04, -.1200798950195E+04, .9422832031250E+03},
 {   10040, .8373084960938E+04, -.1191932617188E+04, .9442466430664E+03},
 {   10041, .8391012695312E+04, -.1199214843750E+04, .9640502929688E+03},
 {   10042, .8386399414062E+04, -.1189894165039E+04, .9661143798828E+03},
 {   10043, .8385822265625E+04, -.1199214843750E+04, .9524589233398E+03},
 {   10044, .8381212890625E+04, -.1189894165039E+04, .9545227050781E+03},
 {   10045, .8380632812500E+04, -.1199214843750E+04, .9408675537109E+03},
 {   10046, .8376022460938E+04, -.1189894165039E+04, .9429315185547E+03},
 {   10050, .8336925781250E+04, -.1154726684570E+04, .9882623291016E+03},
 {   10053, .8373625976562E+04, -.1177040649414E+04, .9718335571289E+03},
 {   10054, .8363158203125E+04, -.1166256225586E+04, .9765191650391E+03},
 {   10055, .8351195312500E+04, -.1157537475586E+04, .9818750000000E+03},
 {   10056, .8338071289062E+04, -.1151129028320E+04, .9877503051758E+03},
 {   10057, .8322076171875E+04, -.1147019165039E+04, .9949102783203E+03},
 {   10058, .8309836914062E+04, -.1145892089844E+04, .1000389099121E+04},
 {   10062, .8331736328125E+04, -.1154726684570E+04, .9766710205078E+03},
 {   10065, .8368436523438E+04, -.1177040649414E+04, .9602418212891E+03},
 {   10066, .8357969726562E+04, -.1166256225586E+04, .9649278564453E+03},
 {   10067, .8346005859375E+04, -.1157537475586E+04, .9702834472656E+03},
 {   10068, .8332882812500E+04, -.1151129028320E+04, .9761584472656E+03},
 {   10069, .8316885742188E+04, -.1147019165039E+04, .9833192138672E+03},
 {   10070, .8304648437500E+04, -.1145892089844E+04, .9887977294922E+03},
 {   10074, .8326548828125E+04, -.1154726684570E+04, .9650794067383E+03},
 {   10077, .8363247070312E+04, -.1177040649414E+04, .9486503295898E+03},
 {   10078, .8352780273438E+04, -.1166256225586E+04, .9533363647461E+03},
 {   10079, .8340816406250E+04, -.1157537475586E+04, .9586919555664E+03},
 {   10080, .8327693359375E+04, -.1151129028320E+04, .9645670776367E+03},
 {   10081, .8311698242188E+04, -.1147019165039E+04, .9717271728516E+03},
 {   10082, .8299458007812E+04, -.1145892089844E+04, .9772065429688E+03},
 {   10083, .8376210937500E+04, -.1174493408203E+04, .9706757812500E+03},
 {   10084, .8365319335938E+04, -.1163271850586E+04, .9755517578125E+03},
 {   10085, .8352872070312E+04, -.1154199584961E+04, .9811243896484E+03},
 {   10086, .8339217773438E+04, -.1147531250000E+04, .9872373046875E+03},
 {   10087, .8322656250000E+04, -.1143262573242E+04, .9946506347656E+03},
 {   10088, .8309836914062E+04, -.1142082031250E+04, .1000389099121E+04},
 {   10089, .8371021484375E+04, -.1174493408203E+04, .9590845947266E+03},
 {   10090, .8360131835938E+04, -.1163271850586E+04, .9639602050781E+03},
 {   10091, .8347682617188E+04, -.1154199584961E+04, .9695328369141E+03},
 {   10092, .8334025390625E+04, -.1147531250000E+04, .9756461791992E+03},
 {   10093, .8317466796875E+04, -.1143262573242E+04, .9830590209961E+03},
 {   10094, .8304648437500E+04, -.1142082031250E+04, .9887977294922E+03},
 {   10095, .8365835937500E+04, -.1174493408203E+04, .9474926147461E+03},
 {   10096, .8354942382812E+04, -.1163271850586E+04, .9523685913086E+03},
 {   10097, .8342493164062E+04, -.1154199584961E+04, .9579416503906E+03},
 {   10098, .8328836914062E+04, -.1147531250000E+04, .9640546264648E+03},
 {   10099, .8312277343750E+04, -.1143262573242E+04, .9714676513672E+03},
 {   10100, .8299458007812E+04, -.1142082031250E+04, .9772065429688E+03},
 {   10103, .8298244140625E+04, -.1145892089844E+04, .1005578613281E+04},
 {   10104, .8286653320312E+04, -.1145892089844E+04, .1010767395020E+04},
 {   10107, .8293055664062E+04, -.1145892089844E+04, .9939868164062E+03},
 {   10108, .8281464843750E+04, -.1145892089844E+04, .9991757812500E+03},
 {   10111, .8287866210938E+04, -.1145892089844E+04, .9823952636719E+03},
 {   10112, .8276275390625E+04, -.1145892089844E+04, .9875843505859E+03},
 {   10113, .8298244140625E+04, -.1142082031250E+04, .1005578613281E+04},
 {   10114, .8286653320312E+04, -.1142082031250E+04, .1010767395020E+04},
 {   10115, .8293055664062E+04, -.1142082031250E+04, .9939868164062E+03},
 {   10116, .8281464843750E+04, -.1142082031250E+04, .9991757812500E+03},
 {   10117, .8287866210938E+04, -.1142082031250E+04, .9823952636719E+03},
 {   10118, .8276275390625E+04, -.1142082031250E+04, .9875843505859E+03},
 {   10124, .8207427734375E+04, -.1215458984375E+04, .1046233642578E+04},
 {   10125, .8274144531250E+04, -.1146974853516E+04, .1016367248535E+04},
 {   10126, .8245555664062E+04, -.1157930908203E+04, .1029165893555E+04},
 {   10127, .8234858398438E+04, -.1164960327148E+04, .1033954467773E+04},
 {   10128, .8221403320312E+04, -.1178871582031E+04, .1039978393555E+04},
 {   10129, .8211764648438E+04, -.1194361083984E+04, .1044292602539E+04},
 {   10130, .8204080078125E+04, -.1214427368164E+04, .1047732788086E+04},
 {   10136, .8202239257812E+04, -.1215458984375E+04, .1034642089844E+04},
 {   10137, .8268955078125E+04, -.1146974853516E+04, .1004775756836E+04},
 {   10138, .8240365234375E+04, -.1157930908203E+04, .1017574218750E+04},
 {   10139, .8229667968750E+04, -.1164960327148E+04, .1022363647461E+04},
 {   10140, .8216210937500E+04, -.1178871582031E+04, .1028387084961E+04},
 {   10141, .8206573242188E+04, -.1194361083984E+04, .1032701660156E+04},
 {   10142, .8198888671875E+04, -.1214427368164E+04, .1036141113281E+04},
 {   10148, .8197049804688E+04, -.1215458984375E+04, .1023051025391E+04},
 {   10149, .8263766601562E+04, -.1146974853516E+04, .9931839599609E+03},
 {   10150, .8235176757812E+04, -.1157930908203E+04, .1005982788086E+04},
 {   10151, .8224478515625E+04, -.1164960327148E+04, .1010771301270E+04},
 {   10152, .8211023437500E+04, -.1178871582031E+04, .1016795654297E+04},
 {   10153, .8201384765625E+04, -.1194361083984E+04, .1021109741211E+04},
 {   10154, .8193701171875E+04, -.1214427368164E+04, .1024549926758E+04},
 {   10155, .8273400390625E+04, -.1143253540039E+04, .1016700622559E+04},
 {   10156, .8244097656250E+04, -.1154471313477E+04, .1029818237305E+04},
 {   10157, .8232757812500E+04, -.1161923339844E+04, .1034894775391E+04},
 {   10158, .8218757812500E+04, -.1176398559570E+04, .1041162841797E+04},
 {   10159, .8208695312500E+04, -.1192567138672E+04, .1045665893555E+04},
 {   10160, .8200732421875E+04, -.1213395874023E+04, .1049231201172E+04},
 {   10161, .8268210937500E+04, -.1143253540039E+04, .1005109863281E+04},
 {   10162, .8238908203125E+04, -.1154471313477E+04, .1018226928711E+04},
 {   10163, .8227570312500E+04, -.1161923339844E+04, .1023303222656E+04},
 {   10164, .8213566406250E+04, -.1176398559570E+04, .1029571289062E+04},
 {   10165, .8203508789062E+04, -.1192567016602E+04, .1034074584961E+04},
 {   10166, .8195544921875E+04, -.1213395874023E+04, .1037639526367E+04},
 {   10167, .8263021484375E+04, -.1143253540039E+04, .9935179443359E+03},
 {   10168, .8233721679688E+04, -.1154471313477E+04, .1006634887695E+04},
 {   10169, .8222380859375E+04, -.1161923339844E+04, .1011711547852E+04},
 {   10170, .8208380859375E+04, -.1176398559570E+04, .1017979980469E+04},
 {   10171, .8198319335938E+04, -.1192567138672E+04, .1022482788086E+04},
 {   10172, .8190354492188E+04, -.1213395874023E+04, .1026048095703E+04},
 {   10173, .8204830078125E+04, -.1230180419922E+04, .1047396484375E+04},
 {   10174, .8201372070312E+04, -.1229770874023E+04, .1048944702148E+04},
 {   10175, .8199640625000E+04, -.1230180419922E+04, .1035805053711E+04},
 {   10176, .8196182617188E+04, -.1229770874023E+04, .1037353149414E+04},
 {   10177, .8194452148438E+04, -.1230180419922E+04, .1024213745117E+04},
 {   10178, .8190997558594E+04, -.1229770874023E+04, .1025761230469E+04},
 {   10179, .8197916992188E+04, -.1229361450195E+04, .1050492309570E+04},
 {   10180, .8192726562500E+04, -.1229361450195E+04, .1038900634766E+04},
 {   10181, .8187536621094E+04, -.1229361450195E+04, .1027308959961E+04},
 {   10182, .8373010742188E+04, -.1202382934570E+04, .9408011474609E+03},
 {   10184, .8376174804688E+04, -.1200798950195E+04, .9393851318359E+03},
 {   10185, .8371789062500E+04, -.1191932617188E+04, .9413486328125E+03},
 {   10186, .8367821289062E+04, -.1202383056641E+04, .9292096557617E+03},
 {   10188, .8370983398438E+04, -.1200798950195E+04, .9277935791016E+03},
 {   10189, .8366597656250E+04, -.1191932617188E+04, .9297575683594E+03},
 {   10190, .8362632812500E+04, -.1202383056641E+04, .9176179199219E+03},
 {   10192, .8365794921875E+04, -.1200798950195E+04, .9162022094727E+03},
 {   10193, .8361410156250E+04, -.1191932617188E+04, .9181655273438E+03},
 {   10194, .8379334960938E+04, -.1199214843750E+04, .9379694213867E+03},
 {   10195, .8374726562500E+04, -.1189894165039E+04, .9400333251953E+03},
 {   10196, .8374147460938E+04, -.1199214843750E+04, .9263778686523E+03},
 {   10197, .8369537109375E+04, -.1189894165039E+04, .9284418945312E+03},
 {   10198, .8368958984375E+04, -.1199214843750E+04, .9147861938477E+03},
 {   10199, .8364347656250E+04, -.1189894165039E+04, .9168504638672E+03},
 {   10203, .8325250976562E+04, -.1154726684570E+04, .9621815795898E+03},
 {   10206, .8361949218750E+04, -.1177040649414E+04, .9457529296875E+03},
 {   10207, .8351482421875E+04, -.1166256225586E+04, .9504384155273E+03},
 {   10208, .8339519531250E+04, -.1157537475586E+04, .9557940063477E+03},
 {   10209, .8326396484375E+04, -.1151129028320E+04, .9616689453125E+03},
 {   10210, .8310400390625E+04, -.1147019165039E+04, .9688295288086E+03},
 {   10211, .8298160156250E+04, -.1145892089844E+04, .9743084106445E+03},
 {   10215, .8320062500000E+04, -.1154726684570E+04, .9505900268555E+03},
 {   10218, .8356760742188E+04, -.1177040649414E+04, .9341608886719E+03},
 {   10219, .8346293945312E+04, -.1166256225586E+04, .9388468017578E+03},
 {   10220, .8334331054688E+04, -.1157537475586E+04, .9442023925781E+03},
 {   10221, .8321206054688E+04, -.1151129028320E+04, .9500776367188E+03},
 {   10222, .8305210937500E+04, -.1147019165039E+04, .9572383422852E+03},
 {   10223, .8292974609375E+04, -.1145892089844E+04, .9627166748047E+03},
 {   10227, .8314873046875E+04, -.1154726684570E+04, .9389984741211E+03},
 {   10230, .8351572265625E+04, -.1177040649414E+04, .9225694580078E+03},
 {   10231, .8341104492188E+04, -.1166256225586E+04, .9272556152344E+03},
 {   10232, .8329143554688E+04, -.1157537475586E+04, .9326107177734E+03},
 {   10233, .8316017578125E+04, -.1151129028320E+04, .9384859619141E+03},
 {   10234, .8300022460938E+04, -.1147019165039E+04, .9456466674805E+03},
 {   10235, .8287781250000E+04, -.1145892089844E+04, .9511254882812E+03},
 {   10236, .8364538085938E+04, -.1174493408203E+04, .9445949707031E+03},
 {   10237, .8353644531250E+04, -.1163271850586E+04, .9494708251953E+03},
 {   10238, .8341197265625E+04, -.1154199584961E+04, .9550435791016E+03},
 {   10239, .8327540039062E+04, -.1147531250000E+04, .9611566162109E+03},
 {   10240, .8310982421875E+04, -.1143262573242E+04, .9685698242188E+03},
 {   10241, .8298160156250E+04, -.1142082031250E+04, .9743084106445E+03},
 {   10242, .8359346679688E+04, -.1174493408203E+04, .9330032958984E+03},
 {   10243, .8348454101562E+04, -.1163271850586E+04, .9378791503906E+03},
 {   10244, .8336008789062E+04, -.1154199584961E+04, .9434520263672E+03},
 {   10245, .8322352539062E+04, -.1147531250000E+04, .9495649414062E+03},
 {   10246, .8305791992188E+04, -.1143262573242E+04, .9569781494141E+03},
 {   10247, .8292974609375E+04, -.1142082031250E+04, .9627166748047E+03},
 {   10248, .8354158203125E+04, -.1174493408203E+04, .9214119873047E+03},
 {   10249, .8343266601562E+04, -.1163271850586E+04, .9262877197266E+03},
 {   10250, .8330817382812E+04, -.1154199584961E+04, .9318605346680E+03},
 {   10251, .8317161132812E+04, -.1147531250000E+04, .9379735717773E+03},
 {   10252, .8300602539062E+04, -.1143262573242E+04, .9453867187500E+03},
 {   10253, .8287781250000E+04, -.1142082031250E+04, .9511254882812E+03},
 {   10256, .8286571289062E+04, -.1145892089844E+04, .9794973144531E+03},
 {   10257, .8274979492188E+04, -.1145892089844E+04, .9846864624023E+03},
 {   10260, .8281380859375E+04, -.1145892089844E+04, .9679062500000E+03},
 {   10261, .8269791015625E+04, -.1145892089844E+04, .9730949707031E+03},
 {   10264, .8276192382812E+04, -.1145892089844E+04, .9563143310547E+03},
 {   10265, .8264600585938E+04, -.1145892089844E+04, .9615036621094E+03},
 {   10266, .8286571289062E+04, -.1142082031250E+04, .9794973144531E+03},
 {   10267, .8274979492188E+04, -.1142082031250E+04, .9846864624023E+03},
 {   10268, .8281380859375E+04, -.1142082031250E+04, .9679062500000E+03},
 {   10269, .8269791015625E+04, -.1142082031250E+04, .9730949707031E+03},
 {   10270, .8276192382812E+04, -.1142082031250E+04, .9563143310547E+03},
 {   10271, .8264600585938E+04, -.1142082031250E+04, .9615036621094E+03},
 {   10277, .8195753906250E+04, -.1215458984375E+04, .1020152832031E+04},
 {   10278, .8262468750000E+04, -.1146974853516E+04, .9902864990234E+03},
 {   10279, .8233879882812E+04, -.1157930908203E+04, .1003084960938E+04},
 {   10280, .8223180664062E+04, -.1164960327148E+04, .1007873840332E+04},
 {   10281, .8209722656250E+04, -.1178871582031E+04, .1013898193359E+04},
 {   10282, .8200087890625E+04, -.1194361083984E+04, .1018211669922E+04},
 {   10283, .8192405273438E+04, -.1214427368164E+04, .1021651489258E+04},
 {   10289, .8190562500000E+04, -.1215458984375E+04, .1008562133789E+04},
 {   10290, .8257280273438E+04, -.1146974853516E+04, .9786949462891E+03},
 {   10291, .8228691406250E+04, -.1157930908203E+04, .9914932861328E+03},
 {   10292, .8217992187500E+04, -.1164960327148E+04, .9962824707031E+03},
 {   10293, .8204539062500E+04, -.1178871582031E+04, .1002305664062E+04},
 {   10294, .8194900390625E+04, -.1194361083984E+04, .1006620117188E+04},
 {   10295, .8187217285156E+04, -.1214427368164E+04, .1010060058594E+04},
 {   10301, .8185374023438E+04, -.1215458984375E+04, .9969697265625E+03},
 {   10302, .8252089843750E+04, -.1146974853516E+04, .9671033325195E+03},
 {   10303, .8223502929688E+04, -.1157930908203E+04, .9799019165039E+03},
 {   10304, .8212803710938E+04, -.1164960327148E+04, .9846909179688E+03},
 {   10305, .8199348632812E+04, -.1178871582031E+04, .9907144165039E+03},
 {   10306, .8189710449219E+04, -.1194361083984E+04, .9950286865234E+03},
 {   10307, .8182025390625E+04, -.1214427368164E+04, .9984688720703E+03},
 {   10308, .8261724609375E+04, -.1143253540039E+04, .9906200561523E+03},
 {   10309, .8232422851562E+04, -.1154471313477E+04, .1003736694336E+04},
 {   10310, .8221083007812E+04, -.1161923339844E+04, .1008813842773E+04},
 {   10311, .8207079101562E+04, -.1176398559570E+04, .1015082153320E+04},
 {   10312, .8197020507812E+04, -.1192567138672E+04, .1019585327148E+04},
 {   10313, .8189055175781E+04, -.1213395874023E+04, .1023150268555E+04},
 {   10314, .8256536132812E+04, -.1143253540039E+04, .9790284423828E+03},
 {   10315, .8227234375000E+04, -.1154471313477E+04, .9921453247070E+03},
 {   10316, .8215892578125E+04, -.1161923339844E+04, .9972222290039E+03},
 {   10317, .8201891601562E+04, -.1176398559570E+04, .1003490234375E+04},
 {   10318, .8191831054688E+04, -.1192567138672E+04, .1007993652344E+04},
 {   10319, .8183867187500E+04, -.1213395874023E+04, .1011558898926E+04},
 {   10320, .8251347656250E+04, -.1143253540039E+04, .9674368896484E+03},
 {   10321, .8222044921875E+04, -.1154471313477E+04, .9805541992188E+03},
 {   10322, .8210705078125E+04, -.1161923339844E+04, .9856306762695E+03},
 {   10323, .8196702148438E+04, -.1176398559570E+04, .9918986816406E+03},
 {   10324, .8186642578125E+04, -.1192567138672E+04, .9964017333984E+03},
 {   10325, .8178680175781E+04, -.1213395874023E+04, .9999671020508E+03},
 {   10326, .8193154296875E+04, -.1230180419922E+04, .1021315612793E+04},
 {   10327, .8189698730469E+04, -.1229770874023E+04, .1022863159180E+04},
 {   10328, .8187967285156E+04, -.1230180419922E+04, .1009723876953E+04},
 {   10329, .8184507324219E+04, -.1229770874023E+04, .1011271972656E+04},
 {   10330, .8182776367188E+04, -.1230180419922E+04, .9981324462891E+03},
 {   10331, .8179319824219E+04, -.1229770874023E+04, .9996801757812E+03},
 {   10332, .8186241699219E+04, -.1229361450195E+04, .1024410888672E+04},
 {   10333, .8181050781250E+04, -.1229361450195E+04, .1012819458008E+04},
 {   10334, .8175862304688E+04, -.1229361450195E+04, .1001227722168E+04},
 {   10335, .8409334960938E+04, -.1368801147461E+04, .1021941223145E+04},
 {   10337, .8412496093750E+04, -.1370385131836E+04, .1020526123047E+04},
 {   10338, .8408718750000E+04, -.1378023315430E+04, .1022217407227E+04},
 {   10339, .8414524414062E+04, -.1368801147461E+04, .1033533081055E+04},
 {   10341, .8417685546875E+04, -.1370385131836E+04, .1032117431641E+04},
 {   10342, .8413908203125E+04, -.1378023315430E+04, .1033809082031E+04},
 {   10343, .8419711914062E+04, -.1368801147461E+04, .1045124511719E+04},
 {   10345, .8422875976562E+04, -.1370385131836E+04, .1043709350586E+04},
 {   10346, .8419100585938E+04, -.1378023315430E+04, .1045400268555E+04},
 {   10347, .8415661132812E+04, -.1371969238281E+04, .1019110229492E+04},
 {   10348, .8411657226562E+04, -.1380061889648E+04, .1020902099609E+04},
 {   10349, .8420850585938E+04, -.1371969238281E+04, .1030701538086E+04},
 {   10350, .8416845703125E+04, -.1380061889648E+04, .1032493652344E+04},
 {   10351, .8426039062500E+04, -.1371969238281E+04, .1042293090820E+04},
 {   10352, .8422036132812E+04, -.1380061889648E+04, .1044085449219E+04},
 {   10356, .8361575195312E+04, -.1416457397461E+04, .1043322509766E+04},
 {   10359, .8398273437500E+04, -.1394143432617E+04, .1026893554688E+04},
 {   10360, .8387805664062E+04, -.1404927734375E+04, .1031579345703E+04},
 {   10361, .8375843750000E+04, -.1413646484375E+04, .1036934936523E+04},
 {   10362, .8362716796875E+04, -.1420055053711E+04, .1042810058594E+04},
 {   10363, .8346954101562E+04, -.1424143676758E+04, .1049866577148E+04},
 {   10364, .8334484375000E+04, -.1425291992188E+04, .1055449218750E+04},
 {   10368, .8366762695312E+04, -.1416457397461E+04, .1054913818359E+04},
 {   10371, .8403463867188E+04, -.1394143432617E+04, .1038485107422E+04},
 {   10372, .8392996093750E+04, -.1404927734375E+04, .1043170410156E+04},
 {   10373, .8381033203125E+04, -.1413646484375E+04, .1048526123047E+04},
 {   10374, .8367907226562E+04, -.1420055053711E+04, .1054401367188E+04},
 {   10375, .8352145507812E+04, -.1424143676758E+04, .1061458251953E+04},
 {   10376, .8339673828125E+04, -.1425291992188E+04, .1067040649414E+04},
 {   10380, .8371952148438E+04, -.1416457397461E+04, .1066505371094E+04},
 {   10383, .8408650390625E+04, -.1394143432617E+04, .1050076416016E+04},
 {   10384, .8398184570312E+04, -.1404927734375E+04, .1054761962891E+04},
 {   10385, .8386220703125E+04, -.1413646484375E+04, .1060117797852E+04},
 {   10386, .8373097656250E+04, -.1420055053711E+04, .1065992675781E+04},
 {   10387, .8357333007812E+04, -.1424143676758E+04, .1073050170898E+04},
 {   10388, .8344863281250E+04, -.1425291992188E+04, .1078632080078E+04},
 {   10389, .8400859375000E+04, -.1396690673828E+04, .1025735473633E+04},
 {   10390, .8389969726562E+04, -.1407912231445E+04, .1030611328125E+04},
 {   10391, .8377520507812E+04, -.1416984375000E+04, .1036184204102E+04},
 {   10392, .8363862304688E+04, -.1423652709961E+04, .1042297729492E+04},
 {   10393, .8347536132812E+04, -.1427900268555E+04, .1049607055664E+04},
 {   10394, .8334484375000E+04, -.1429102050781E+04, .1055449218750E+04},
 {   10395, .8406048828125E+04, -.1396690673828E+04, .1037327148438E+04},
 {   10396, .8395157226562E+04, -.1407912231445E+04, .1042202636719E+04},
 {   10397, .8382708007812E+04, -.1416984375000E+04, .1047775634766E+04},
 {   10398, .8369051757812E+04, -.1423652709961E+04, .1053889038086E+04},
 {   10399, .8352724609375E+04, -.1427900268555E+04, .1061198608398E+04},
 {   10400, .8339673828125E+04, -.1429102050781E+04, .1067040649414E+04},
 {   10401, .8411239257812E+04, -.1396690673828E+04, .1048919067383E+04},
 {   10402, .8400345703125E+04, -.1407912231445E+04, .1053794921875E+04},
 {   10403, .8387897460938E+04, -.1416984375000E+04, .1059367309570E+04},
 {   10404, .8374240234375E+04, -.1423652709961E+04, .1065480712891E+04},
 {   10405, .8357914062500E+04, -.1427900268555E+04, .1072789916992E+04},
 {   10406, .8344863281250E+04, -.1429102050781E+04, .1078632080078E+04},
 {   10409, .8322892578125E+04, -.1425291992188E+04, .1060638427734E+04},
 {   10410, .8311302734375E+04, -.1425291992188E+04, .1065827270508E+04},
 {   10413, .8328083007812E+04, -.1425291992188E+04, .1072229858398E+04},
 {   10414, .8316491210938E+04, -.1425291992188E+04, .1077418945312E+04},
 {   10417, .8333272460938E+04, -.1425291992188E+04, .1083821044922E+04},
 {   10418, .8321680664062E+04, -.1425291992188E+04, .1089010131836E+04},
 {   10419, .8322892578125E+04, -.1429102050781E+04, .1060638427734E+04},
 {   10420, .8311302734375E+04, -.1429102050781E+04, .1065827270508E+04},
 {   10421, .8328083007812E+04, -.1429102050781E+04, .1072229858398E+04},
 {   10422, .8316491210938E+04, -.1429102050781E+04, .1077418945312E+04},
 {   10423, .8333272460938E+04, -.1429102050781E+04, .1083821044922E+04},
 {   10424, .8321680664062E+04, -.1429102050781E+04, .1089010131836E+04},
 {   10430, .8232075195312E+04, -.1355725097656E+04, .1101293945312E+04},
 {   10431, .8298997070312E+04, -.1424336425781E+04, .1071335693359E+04},
 {   10432, .8270402343750E+04, -.1413383789062E+04, .1084136962891E+04},
 {   10433, .8259505859375E+04, -.1406223754883E+04, .1089014404297E+04},
 {   10434, .8246049804688E+04, -.1392312500000E+04, .1095038452148E+04},
 {   10435, .8236412109375E+04, -.1376822998047E+04, .1099352905273E+04},
 {   10436, .8228728515625E+04, -.1356756713867E+04, .1102792358398E+04},
 {   10442, .8237266601562E+04, -.1355725097656E+04, .1112884887695E+04},
 {   10443, .8304185546875E+04, -.1424336425781E+04, .1082927734375E+04},
 {   10444, .8275591796875E+04, -.1413383789062E+04, .1095728149414E+04},
 {   10445, .8264694335938E+04, -.1406223754883E+04, .1100606445312E+04},
 {   10446, .8251239257812E+04, -.1392312500000E+04, .1106629882812E+04},
 {   10447, .8241603515625E+04, -.1376822998047E+04, .1110943847656E+04},
 {   10448, .8233917968750E+04, -.1356756713867E+04, .1114384033203E+04},
 {   10454, .8242452148438E+04, -.1355725097656E+04, .1124476562500E+04},
 {   10455, .8309373046875E+04, -.1424336425781E+04, .1094518920898E+04},
 {   10456, .8280781250000E+04, -.1413383789062E+04, .1107319702148E+04},
 {   10457, .8269883789062E+04, -.1406223754883E+04, .1112197265625E+04},
 {   10458, .8256430664062E+04, -.1392312500000E+04, .1118221191406E+04},
 {   10459, .8246790039062E+04, -.1376822998047E+04, .1122535522461E+04},
 {   10460, .8239105468750E+04, -.1356756713867E+04, .1125975463867E+04},
 {   10461, .8298250000000E+04, -.1428057861328E+04, .1071670410156E+04},
 {   10462, .8268945312500E+04, -.1416843505859E+04, .1084789062500E+04},
 {   10463, .8257405273438E+04, -.1409260742188E+04, .1089954956055E+04},
 {   10464, .8243403320312E+04, -.1394785522461E+04, .1096222167969E+04},
 {   10465, .8233343750000E+04, -.1378616943359E+04, .1100726318359E+04},
 {   10466, .8225382812500E+04, -.1357788208008E+04, .1104290893555E+04},
 {   10467, .8303440429688E+04, -.1428057861328E+04, .1083261352539E+04},
 {   10468, .8274134765625E+04, -.1416843505859E+04, .1096380249023E+04},
 {   10469, .8262595703125E+04, -.1409260742188E+04, .1101545898438E+04},
 {   10470, .8248590820312E+04, -.1394785522461E+04, .1107814697266E+04},
 {   10471, .8238535156250E+04, -.1378617065430E+04, .1112317382812E+04},
 {   10472, .8230570312500E+04, -.1357788208008E+04, .1115882690430E+04},
 {   10473, .8308628906250E+04, -.1428057861328E+04, .1094852783203E+04},
 {   10474, .8279323242188E+04, -.1416843505859E+04, .1107972290039E+04},
 {   10475, .8267785156250E+04, -.1409260742188E+04, .1113137695312E+04},
 {   10476, .8253783203125E+04, -.1394785522461E+04, .1119405517578E+04},
 {   10477, .8243722656250E+04, -.1378616943359E+04, .1123909423828E+04},
 {   10478, .8235757812500E+04, -.1357788208008E+04, .1127474243164E+04},
 {   10479, .8229478515625E+04, -.1341003662109E+04, .1102456420898E+04},
 {   10480, .8226023437500E+04, -.1341413208008E+04, .1104003784180E+04},
 {   10481, .8234666015625E+04, -.1341003662109E+04, .1114048095703E+04},
 {   10482, .8231211914062E+04, -.1341413208008E+04, .1115595214844E+04},
 {   10483, .8239856445312E+04, -.1341003662109E+04, .1125639648438E+04},
 {   10484, .8236400390625E+04, -.1341413208008E+04, .1127187011719E+04},
 {   10485, .8222564453125E+04, -.1341822631836E+04, .1105552001953E+04},
 {   10486, .8227752929688E+04, -.1341822631836E+04, .1117143188477E+04},
 {   10487, .8232941406250E+04, -.1341822631836E+04, .1128734863281E+04},
 {   10488, .8397659179688E+04, -.1368801147461E+04, .9958609008789E+03},
 {   10490, .8400821289062E+04, -.1370385131836E+04, .9944456176758E+03},
 {   10491, .8397044921875E+04, -.1378023315430E+04, .9961365356445E+03},
 {   10492, .8402847656250E+04, -.1368801147461E+04, .1007452026367E+04},
 {   10494, .8406011718750E+04, -.1370385131836E+04, .1006036499023E+04},
 {   10495, .8402232421875E+04, -.1378023315430E+04, .1007727966309E+04},
 {   10496, .8408037109375E+04, -.1368801147461E+04, .1019044189453E+04},
 {   10498, .8411199218750E+04, -.1370385131836E+04, .1017627929688E+04},
 {   10499, .8407421875000E+04, -.1378023315430E+04, .1019319702148E+04},
 {   10500, .8403986328125E+04, -.1371969238281E+04, .9930291748047E+03},
 {   10501, .8399981445312E+04, -.1380061889648E+04, .9948212890625E+03},
 {   10502, .8409173828125E+04, -.1371969238281E+04, .1004620971680E+04},
 {   10503, .8405171875000E+04, -.1380061889648E+04, .1006413146973E+04},
 {   10504, .8414363281250E+04, -.1371969238281E+04, .1016212158203E+04},
 {   10505, .8410359375000E+04, -.1380061889648E+04, .1018004394531E+04},
 {   10509, .8349899414062E+04, -.1416457397461E+04, .1017241699219E+04},
 {   10512, .8386598632812E+04, -.1394143432617E+04, .1000812438965E+04},
 {   10513, .8376132812500E+04, -.1404927734375E+04, .1005497802734E+04},
 {   10514, .8364167968750E+04, -.1413646484375E+04, .1010854064941E+04},
 {   10515, .8351043945312E+04, -.1420055053711E+04, .1016728881836E+04},
 {   10516, .8335279296875E+04, -.1424143676758E+04, .1023785766602E+04},
 {   10517, .8322810546875E+04, -.1425291992188E+04, .1029367919922E+04},
 {   10521, .8355086914062E+04, -.1416457397461E+04, .1028832641602E+04},
 {   10524, .8391787109375E+04, -.1394143432617E+04, .1012403808594E+04},
 {   10525, .8381321289062E+04, -.1404927734375E+04, .1017090332031E+04},
 {   10526, .8369357421875E+04, -.1413646484375E+04, .1022445068359E+04},
 {   10527, .8356234375000E+04, -.1420055053711E+04, .1028320556641E+04},
 {   10528, .8340467773438E+04, -.1424143676758E+04, .1035377563477E+04},
 {   10529, .8327998046875E+04, -.1425291992188E+04, .1040959594727E+04},
 {   10533, .8360277343750E+04, -.1416457397461E+04, .1040424072266E+04},
 {   10536, .8396976562500E+04, -.1394143432617E+04, .1023995361328E+04},
 {   10537, .8386509765625E+04, -.1404927734375E+04, .1028680908203E+04},
 {   10538, .8374545898438E+04, -.1413646484375E+04, .1034036621094E+04},
 {   10539, .8361422851562E+04, -.1420055053711E+04, .1039911987305E+04},
 {   10540, .8345657226562E+04, -.1424143676758E+04, .1046968994141E+04},
 {   10541, .8333187500000E+04, -.1425291992188E+04, .1052551025391E+04},
 {   10542, .8389185546875E+04, -.1396690673828E+04, .9996546020508E+03},
 {   10543, .8378293945312E+04, -.1407912231445E+04, .1004530456543E+04},
 {   10544, .8365845703125E+04, -.1416984375000E+04, .1010103088379E+04},
 {   10545, .8352188476562E+04, -.1423652709961E+04, .1016216796875E+04},
 {   10546, .8335858398438E+04, -.1427900268555E+04, .1023526611328E+04},
 {   10547, .8322810546875E+04, -.1429102050781E+04, .1029367919922E+04},
 {   10548, .8394375000000E+04, -.1396690673828E+04, .1011246093750E+04},
 {   10549, .8383481445312E+04, -.1407912231445E+04, .1016121948242E+04},
 {   10550, .8371033203125E+04, -.1416984375000E+04, .1021694824219E+04},
 {   10551, .8357376953125E+04, -.1423652709961E+04, .1027807861328E+04},
 {   10552, .8341049804688E+04, -.1427900268555E+04, .1035117553711E+04},
 {   10553, .8327998046875E+04, -.1429102050781E+04, .1040959594727E+04},
 {   10554, .8399562500000E+04, -.1396690673828E+04, .1022837768555E+04},
 {   10555, .8388670898438E+04, -.1407912231445E+04, .1027713623047E+04},
 {   10556, .8376223632812E+04, -.1416984375000E+04, .1033285888672E+04},
 {   10557, .8362566406250E+04, -.1423652709961E+04, .1039399780273E+04},
 {   10558, .8346237304688E+04, -.1427900268555E+04, .1046709716797E+04},
 {   10559, .8333187500000E+04, -.1429102050781E+04, .1052551025391E+04},
 {   10562, .8311216796875E+04, -.1425291992188E+04, .1034557128906E+04},
 {   10563, .8299626953125E+04, -.1425291992188E+04, .1039746093750E+04},
 {   10566, .8316409179688E+04, -.1425291992188E+04, .1046148681641E+04},
 {   10567, .8304816406250E+04, -.1425291992188E+04, .1051337890625E+04},
 {   10570, .8321595703125E+04, -.1425291992188E+04, .1057740600586E+04},
 {   10571, .8310006835938E+04, -.1425291992188E+04, .1062929321289E+04},
 {   10572, .8311216796875E+04, -.1429102050781E+04, .1034557128906E+04},
 {   10573, .8299626953125E+04, -.1429102050781E+04, .1039746093750E+04},
 {   10574, .8316409179688E+04, -.1429102050781E+04, .1046148681641E+04},
 {   10575, .8304816406250E+04, -.1429102050781E+04, .1051337890625E+04},
 {   10576, .8321595703125E+04, -.1429102050781E+04, .1057740600586E+04},
 {   10577, .8310006835938E+04, -.1429102050781E+04, .1062929321289E+04},
 {   10583, .8220398437500E+04, -.1355725219727E+04, .1075213012695E+04},
 {   10584, .8287321289062E+04, -.1424336425781E+04, .1045254638672E+04},
 {   10585, .8258725585938E+04, -.1413383789062E+04, .1058056030273E+04},
 {   10586, .8247830078125E+04, -.1406223754883E+04, .1062933349609E+04},
 {   10587, .8234373046875E+04, -.1392312500000E+04, .1068957519531E+04},
 {   10588, .8224735351562E+04, -.1376822998047E+04, .1073271606445E+04},
 {   10589, .8217052734375E+04, -.1356756713867E+04, .1076711547852E+04},
 {   10595, .8225588867188E+04, -.1355725219727E+04, .1086804809570E+04},
 {   10596, .8292508789062E+04, -.1424336425781E+04, .1056846557617E+04},
 {   10597, .8263917968750E+04, -.1413383789062E+04, .1069647216797E+04},
 {   10598, .8253019531250E+04, -.1406223754883E+04, .1074525024414E+04},
 {   10599, .8239565429688E+04, -.1392312500000E+04, .1080548583984E+04},
 {   10600, .8229926757812E+04, -.1376822998047E+04, .1084863403320E+04},
 {   10601, .8222243164062E+04, -.1356756713867E+04, .1088302856445E+04},
 {   10607, .8230775390625E+04, -.1355725097656E+04, .1098395996094E+04},
 {   10608, .8297699218750E+04, -.1424336425781E+04, .1068437622070E+04},
 {   10609, .8269103515625E+04, -.1413383789062E+04, .1081239624023E+04},
 {   10610, .8258208984375E+04, -.1406223754883E+04, .1086116455078E+04},
 {   10611, .8244751953125E+04, -.1392312500000E+04, .1092140747070E+04},
 {   10612, .8235114257812E+04, -.1376822998047E+04, .1096454833984E+04},
 {   10613, .8227430664062E+04, -.1356756713867E+04, .1099894531250E+04},
 {   10614, .8286574218750E+04, -.1428057861328E+04, .1045588745117E+04},
 {   10615, .8257268554688E+04, -.1416843505859E+04, .1058707763672E+04},
 {   10616, .8245730468750E+04, -.1409260742188E+04, .1063873535156E+04},
 {   10617, .8231726562500E+04, -.1394785522461E+04, .1070142333984E+04},
 {   10618, .8221668945312E+04, -.1378617065430E+04, .1074645874023E+04},
 {   10619, .8213703125000E+04, -.1357788208008E+04, .1078210205078E+04},
 {   10620, .8291766601562E+04, -.1428057861328E+04, .1057180175781E+04},
 {   10621, .8262459960938E+04, -.1416843505859E+04, .1070299316406E+04},
 {   10622, .8250919921875E+04, -.1409260742188E+04, .1075464965820E+04},
 {   10623, .8236916015625E+04, -.1394785522461E+04, .1081733520508E+04},
 {   10624, .8226856445312E+04, -.1378617065430E+04, .1086236816406E+04},
 {   10625, .8218893554688E+04, -.1357788208008E+04, .1089802124023E+04},
 {   10626, .8296953125000E+04, -.1428057861328E+04, .1068772216797E+04},
 {   10627, .8267648437500E+04, -.1416843505859E+04, .1081890869141E+04},
 {   10628, .8256109375000E+04, -.1409260742188E+04, .1087056518555E+04},
 {   10629, .8242104492188E+04, -.1394785522461E+04, .1093324829102E+04},
 {   10630, .8232045898438E+04, -.1378616943359E+04, .1097827758789E+04},
 {   10631, .8224082031250E+04, -.1357788208008E+04, .1101393310547E+04},
 {   10632, .8217803710938E+04, -.1341003662109E+04, .1076375488281E+04},
 {   10633, .8214348632812E+04, -.1341413208008E+04, .1077922607422E+04},
 {   10634, .8222994140625E+04, -.1341003662109E+04, .1087966308594E+04},
 {   10635, .8219534179688E+04, -.1341413208008E+04, .1089515014648E+04},
 {   10636, .8228183593750E+04, -.1341003662109E+04, .1099558349609E+04},
 {   10637, .8224724609375E+04, -.1341413208008E+04, .1101106811523E+04},
 {   10638, .8210889648438E+04, -.1341822753906E+04, .1079470336914E+04},
 {   10639, .8216077148438E+04, -.1341822753906E+04, .1091062622070E+04},
 {   10640, .8221268554688E+04, -.1341822631836E+04, .1102653930664E+04},
 {   10641, .8385983398438E+04, -.1368801147461E+04, .9697799072266E+03},
 {   10643, .8389146484375E+04, -.1370385131836E+04, .9683641357422E+03},
 {   10644, .8385367187500E+04, -.1378023315430E+04, .9700554199219E+03},
 {   10645, .8391173828125E+04, -.1368801147461E+04, .9813710327148E+03},
 {   10647, .8394333984375E+04, -.1370385131836E+04, .9799558105469E+03},
 {   10648, .8390558593750E+04, -.1378023315430E+04, .9816467285156E+03},
 {   10649, .8396362304688E+04, -.1368801147461E+04, .9929628906250E+03},
 {   10651, .8399525390625E+04, -.1370385131836E+04, .9915468750000E+03},
 {   10652, .8395747070312E+04, -.1378023315430E+04, .9932383422852E+03},
 {   10653, .8392309570312E+04, -.1371969238281E+04, .9669484252930E+03},
 {   10654, .8388306640625E+04, -.1380061889648E+04, .9687402343750E+03},
 {   10655, .8397497070312E+04, -.1371969238281E+04, .9785399780273E+03},
 {   10656, .8393496093750E+04, -.1380061889648E+04, .9803315429688E+03},
 {   10657, .8402686523438E+04, -.1371969238281E+04, .9901316528320E+03},
 {   10658, .8398684570312E+04, -.1380061889648E+04, .9919235229492E+03},
 {   10662, .8338223632812E+04, -.1416457397461E+04, .9911601562500E+03},
 {   10665, .8374922851562E+04, -.1394143432617E+04, .9747314453125E+03},
 {   10666, .8364456054688E+04, -.1404927856445E+04, .9794169921875E+03},
 {   10667, .8352493164062E+04, -.1413646606445E+04, .9847729492188E+03},
 {   10668, .8339369140625E+04, -.1420055053711E+04, .9906474609375E+03},
 {   10669, .8323603515625E+04, -.1424143676758E+04, .9977050170898E+03},
 {   10670, .8311132812500E+04, -.1425291992188E+04, .1003287475586E+04},
 {   10674, .8343415039062E+04, -.1416457397461E+04, .1002751831055E+04},
 {   10677, .8380111328125E+04, -.1394143432617E+04, .9863228759766E+03},
 {   10678, .8369644531250E+04, -.1404927734375E+04, .9910084838867E+03},
 {   10679, .8357681640625E+04, -.1413646484375E+04, .9963640136719E+03},
 {   10680, .8344557617188E+04, -.1420055053711E+04, .1002239746094E+04},
 {   10681, .8328793945312E+04, -.1424143676758E+04, .1009296752930E+04},
 {   10682, .8316325195312E+04, -.1425291992188E+04, .1014878845215E+04},
 {   10686, .8348600585938E+04, -.1416457397461E+04, .1014343322754E+04},
 {   10689, .8385300781250E+04, -.1394143432617E+04, .9979141845703E+03},
 {   10690, .8374835937500E+04, -.1404927734375E+04, .1002599975586E+04},
 {   10691, .8362870117188E+04, -.1413646484375E+04, .1007956176758E+04},
 {   10692, .8349747070312E+04, -.1420055053711E+04, .1013830993652E+04},
 {   10693, .8333981445312E+04, -.1424143676758E+04, .1020888000488E+04},
 {   10694, .8321513671875E+04, -.1425291992188E+04, .1026470336914E+04},
 {   10695, .8377509765625E+04, -.1396690673828E+04, .9735737915039E+03},
 {   10696, .8366617187500E+04, -.1407912231445E+04, .9784497070312E+03},
 {   10697, .8354169921875E+04, -.1416984497070E+04, .9840219726562E+03},
 {   10698, .8340513671875E+04, -.1423652832031E+04, .9901354370117E+03},
 {   10699, .8324184570312E+04, -.1427900268555E+04, .9974450683594E+03},
 {   10700, .8311132812500E+04, -.1429102050781E+04, .1003287475586E+04},
 {   10701, .8382698242188E+04, -.1396690673828E+04, .9851651000977E+03},
 {   10702, .8371805664062E+04, -.1407912231445E+04, .9900411987305E+03},
 {   10703, .8359357421875E+04, -.1416984375000E+04, .9956135253906E+03},
 {   10704, .8345701171875E+04, -.1423652709961E+04, .1001727416992E+04},
 {   10705, .8329373046875E+04, -.1427900268555E+04, .1009036621094E+04},
 {   10706, .8316325195312E+04, -.1429102050781E+04, .1014878845215E+04},
 {   10707, .8387886718750E+04, -.1396690673828E+04, .9967568359375E+03},
 {   10708, .8376995117188E+04, -.1407912231445E+04, .1001632446289E+04},
 {   10709, .8364545898438E+04, -.1416984375000E+04, .1007205200195E+04},
 {   10710, .8350892578125E+04, -.1423652709961E+04, .1013318664551E+04},
 {   10711, .8334561523438E+04, -.1427900268555E+04, .1020628356934E+04},
 {   10712, .8321513671875E+04, -.1429102050781E+04, .1026470336914E+04},
 {   10715, .8299541992188E+04, -.1425291992188E+04, .1008476074219E+04},
 {   10716, .8287951171875E+04, -.1425291992188E+04, .1013665771484E+04},
 {   10719, .8304731445312E+04, -.1425291992188E+04, .1020067871094E+04},
 {   10720, .8293141601562E+04, -.1425291992188E+04, .1025256958008E+04},
 {   10723, .8309919921875E+04, -.1425291992188E+04, .1031659423828E+04},
 {   10724, .8298330078125E+04, -.1425291992188E+04, .1036848388672E+04},
 {   10725, .8299541992188E+04, -.1429102050781E+04, .1008476074219E+04},
 {   10726, .8287951171875E+04, -.1429102050781E+04, .1013665771484E+04},
 {   10727, .8304731445312E+04, -.1429102050781E+04, .1020067871094E+04},
 {   10728, .8293141601562E+04, -.1429102050781E+04, .1025256958008E+04},
 {   10729, .8309919921875E+04, -.1429102050781E+04, .1031659423828E+04},
 {   10730, .8298330078125E+04, -.1429102050781E+04, .1036848388672E+04},
 {   10736, .8208722656250E+04, -.1355725219727E+04, .1049131835938E+04},
 {   10737, .8275645507812E+04, -.1424336425781E+04, .1019173583984E+04},
 {   10738, .8247053710938E+04, -.1413383789062E+04, .1031974975586E+04},
 {   10739, .8236155273438E+04, -.1406223754883E+04, .1036852294922E+04},
 {   10740, .8222698242188E+04, -.1392312500000E+04, .1042876831055E+04},
 {   10741, .8213060546875E+04, -.1376822998047E+04, .1047190673828E+04},
 {   10742, .8205376953125E+04, -.1356756713867E+04, .1050630371094E+04},
 {   10748, .8213915039062E+04, -.1355725219727E+04, .1060723388672E+04},
 {   10749, .8280835937500E+04, -.1424336425781E+04, .1030765380859E+04},
 {   10750, .8252241210938E+04, -.1413383789062E+04, .1043566772461E+04},
 {   10751, .8241343750000E+04, -.1406223754883E+04, .1048444091797E+04},
 {   10752, .8227887695312E+04, -.1392312500000E+04, .1054468627930E+04},
 {   10753, .8218249023438E+04, -.1376822998047E+04, .1058781982422E+04},
 {   10754, .8210566406250E+04, -.1356756713867E+04, .1062222045898E+04},
 {   10760, .8219102539062E+04, -.1355725219727E+04, .1072315063477E+04},
 {   10761, .8286022460938E+04, -.1424336425781E+04, .1042357299805E+04},
 {   10762, .8257429687500E+04, -.1413383789062E+04, .1055157836914E+04},
 {   10763, .8246533203125E+04, -.1406223754883E+04, .1060035644531E+04},
 {   10764, .8233076171875E+04, -.1392312500000E+04, .1066059814453E+04},
 {   10765, .8223436523438E+04, -.1376822998047E+04, .1070374023438E+04},
 {   10766, .8215752929688E+04, -.1356756713867E+04, .1073814208984E+04},
 {   10767, .8274900390625E+04, -.1428057861328E+04, .1019508056641E+04},
 {   10768, .8245593750000E+04, -.1416843505859E+04, .1032626831055E+04},
 {   10769, .8234056640625E+04, -.1409260742188E+04, .1037792968750E+04},
 {   10770, .8220054687500E+04, -.1394785522461E+04, .1044060791016E+04},
 {   10771, .8209992187500E+04, -.1378617065430E+04, .1048563964844E+04},
 {   10772, .8202030273438E+04, -.1357788208008E+04, .1052129028320E+04},
 {   10773, .8280087890625E+04, -.1428057861328E+04, .1031099365234E+04},
 {   10774, .8250783203125E+04, -.1416843505859E+04, .1044218505859E+04},
 {   10775, .8239244140625E+04, -.1409260742188E+04, .1049384155273E+04},
 {   10776, .8225243164062E+04, -.1394785522461E+04, .1055651977539E+04},
 {   10777, .8215180664062E+04, -.1378617065430E+04, .1060156005859E+04},
 {   10778, .8207219726562E+04, -.1357788208008E+04, .1063720581055E+04},
 {   10779, .8285277343750E+04, -.1428057861328E+04, .1042691284180E+04},
 {   10780, .8255970703125E+04, -.1416843505859E+04, .1055810302734E+04},
 {   10781, .8244435546875E+04, -.1409260742188E+04, .1060974975586E+04},
 {   10782, .8230431640625E+04, -.1394785522461E+04, .1067243774414E+04},
 {   10783, .8220372070312E+04, -.1378617065430E+04, .1071747558594E+04},
 {   10784, .8212409179688E+04, -.1357788208008E+04, .1075311889648E+04},
 {   10785, .8206129882812E+04, -.1341003662109E+04, .1050294189453E+04},
 {   10786, .8202668945312E+04, -.1341413208008E+04, .1051842529297E+04},
 {   10787, .8211317382812E+04, -.1341003662109E+04, .1061886352539E+04},
 {   10788, .8207861328125E+04, -.1341413208008E+04, .1063433471680E+04},
 {   10789, .8216506835938E+04, -.1341003662109E+04, .1073477661133E+04},
 {   10790, .8213048828125E+04, -.1341413208008E+04, .1075025512695E+04},
 {   10791, .8199211914062E+04, -.1341822753906E+04, .1053390258789E+04},
 {   10792, .8204403320312E+04, -.1341822753906E+04, .1064980957031E+04},
 {   10793, .8209591796875E+04, -.1341822753906E+04, .1076572753906E+04},
 {   10794, .8374308593750E+04, -.1368801147461E+04, .9436990966797E+03},
 {   10796, .8377469726562E+04, -.1370385131836E+04, .9422832031250E+03},
 {   10797, .8373692382812E+04, -.1378023315430E+04, .9439748535156E+03},
 {   10798, .8379497070312E+04, -.1368801147461E+04, .9552908325195E+03},
 {   10800, .8382659179688E+04, -.1370385131836E+04, .9538746948242E+03},
 {   10801, .8378882812500E+04, -.1378023315430E+04, .9555660400391E+03},
 {   10802, .8384685546875E+04, -.1368801147461E+04, .9668822021484E+03},
 {   10804, .8387847656250E+04, -.1370385131836E+04, .9654666748047E+03},
 {   10805, .8384070312500E+04, -.1378023315430E+04, .9671577148438E+03},
 {   10806, .8380632812500E+04, -.1371969238281E+04, .9408677978516E+03},
 {   10807, .8376629882812E+04, -.1380061889648E+04, .9426599121094E+03},
 {   10808, .8385822265625E+04, -.1371969238281E+04, .9524589233398E+03},
 {   10809, .8381819335938E+04, -.1380061889648E+04, .9542507324219E+03},
 {   10810, .8391012695312E+04, -.1371969238281E+04, .9640502929688E+03},
 {   10811, .8387008789062E+04, -.1380061889648E+04, .9658424072266E+03},
 {   10815, .8326548828125E+04, -.1416457397461E+04, .9650794067383E+03},
 {   10818, .8363247070312E+04, -.1394143432617E+04, .9486505737305E+03},
 {   10819, .8352780273438E+04, -.1404927856445E+04, .9533363647461E+03},
 {   10820, .8340816406250E+04, -.1413646606445E+04, .9586920776367E+03},
 {   10821, .8327693359375E+04, -.1420055053711E+04, .9645670776367E+03},
 {   10822, .8311927734375E+04, -.1424143676758E+04, .9716242675781E+03},
 {   10823, .8299458007812E+04, -.1425291992188E+04, .9772065429688E+03},
 {   10827, .8331737304688E+04, -.1416457397461E+04, .9766710205078E+03},
 {   10830, .8368436523438E+04, -.1394143432617E+04, .9602418212891E+03},
 {   10831, .8357969726562E+04, -.1404927856445E+04, .9649278564453E+03},
 {   10832, .8346005859375E+04, -.1413646606445E+04, .9702834472656E+03},
 {   10833, .8332882812500E+04, -.1420055053711E+04, .9761585693359E+03},
 {   10834, .8317118164062E+04, -.1424143676758E+04, .9832154541016E+03},
 {   10835, .8304648437500E+04, -.1425291992188E+04, .9887977294922E+03},
 {   10839, .8336925781250E+04, -.1416457397461E+04, .9882623291016E+03},
 {   10842, .8373625976562E+04, -.1394143432617E+04, .9718335571289E+03},
 {   10843, .8363159179688E+04, -.1404927856445E+04, .9765194091797E+03},
 {   10844, .8351195312500E+04, -.1413646606445E+04, .9818750000000E+03},
 {   10845, .8338071289062E+04, -.1420055053711E+04, .9877503051758E+03},
 {   10846, .8322305664062E+04, -.1424143676758E+04, .9948072509766E+03},
 {   10847, .8309836914062E+04, -.1425291992188E+04, .1000389099121E+04},
 {   10848, .8365835937500E+04, -.1396690673828E+04, .9474926147461E+03},
 {   10849, .8354942382812E+04, -.1407912231445E+04, .9523685913086E+03},
 {   10850, .8342493164062E+04, -.1416984497070E+04, .9579417724609E+03},
 {   10851, .8328836914062E+04, -.1423652832031E+04, .9640548706055E+03},
 {   10852, .8312507812500E+04, -.1427900268555E+04, .9713647460938E+03},
 {   10853, .8299458007812E+04, -.1429102050781E+04, .9772065429688E+03},
 {   10854, .8371021484375E+04, -.1396690673828E+04, .9590845947266E+03},
 {   10855, .8360131835938E+04, -.1407912231445E+04, .9639602050781E+03},
 {   10856, .8347682617188E+04, -.1416984497070E+04, .9695328369141E+03},
 {   10857, .8334025390625E+04, -.1423652832031E+04, .9756461791992E+03},
 {   10858, .8317698242188E+04, -.1427900268555E+04, .9829556884766E+03},
 {   10859, .8304648437500E+04, -.1429102050781E+04, .9887977294922E+03},
 {   10860, .8376210937500E+04, -.1396690673828E+04, .9706757812500E+03},
 {   10861, .8365319335938E+04, -.1407912231445E+04, .9755517578125E+03},
 {   10862, .8352872070312E+04, -.1416984497070E+04, .9811243896484E+03},
 {   10863, .8339217773438E+04, -.1423652832031E+04, .9872373046875E+03},
 {   10864, .8322886718750E+04, -.1427900268555E+04, .9945474853516E+03},
 {   10865, .8309836914062E+04, -.1429102050781E+04, .1000389099121E+04},
 {   10868, .8287866210938E+04, -.1425291992188E+04, .9823955078125E+03},
 {   10869, .8276275390625E+04, -.1425291992188E+04, .9875843505859E+03},
 {   10872, .8293055664062E+04, -.1425291992188E+04, .9939868164062E+03},
 {   10873, .8281464843750E+04, -.1425291992188E+04, .9991760253906E+03},
 {   10876, .8298244140625E+04, -.1425291992188E+04, .1005578613281E+04},
 {   10877, .8286653320312E+04, -.1425291992188E+04, .1010767395020E+04},
 {   10878, .8287866210938E+04, -.1429102050781E+04, .9823955078125E+03},
 {   10879, .8276275390625E+04, -.1429102050781E+04, .9875843505859E+03},
 {   10880, .8293055664062E+04, -.1429102050781E+04, .9939868164062E+03},
 {   10881, .8281464843750E+04, -.1429102050781E+04, .9991760253906E+03},
 {   10882, .8298244140625E+04, -.1429102050781E+04, .1005578613281E+04},
 {   10883, .8286653320312E+04, -.1429102050781E+04, .1010767395020E+04},
 {   10889, .8197049804688E+04, -.1355725219727E+04, .1023051025391E+04},
 {   10890, .8263970703125E+04, -.1424336425781E+04, .9930931396484E+03},
 {   10891, .8235375976562E+04, -.1413383789062E+04, .1005894165039E+04},
 {   10892, .8224478515625E+04, -.1406223754883E+04, .1010771545410E+04},
 {   10893, .8211023437500E+04, -.1392312500000E+04, .1016795654297E+04},
 {   10894, .8201384765625E+04, -.1376822998047E+04, .1021109741211E+04},
 {   10895, .8193701171875E+04, -.1356756713867E+04, .1024549926758E+04},
 {   10901, .8202239257812E+04, -.1355725219727E+04, .1034642089844E+04},
 {   10902, .8269160156250E+04, -.1424336425781E+04, .1004684570312E+04},
 {   10903, .8240566406250E+04, -.1413383789062E+04, .1017485229492E+04},
 {   10904, .8229667968750E+04, -.1406223754883E+04, .1022363647461E+04},
 {   10905, .8216210937500E+04, -.1392312500000E+04, .1028387084961E+04},
 {   10906, .8206573242188E+04, -.1376822998047E+04, .1032701660156E+04},
 {   10907, .8198888671875E+04, -.1356756713867E+04, .1036141113281E+04},
 {   10913, .8207427734375E+04, -.1355725219727E+04, .1046233642578E+04},
 {   10914, .8274347656250E+04, -.1424336425781E+04, .1016276306152E+04},
 {   10915, .8245753906250E+04, -.1413383789062E+04, .1029076904297E+04},
 {   10916, .8234858398438E+04, -.1406223754883E+04, .1033954467773E+04},
 {   10917, .8221404296875E+04, -.1392312500000E+04, .1039978515625E+04},
 {   10918, .8211764648438E+04, -.1376822998047E+04, .1044292602539E+04},
 {   10919, .8204080078125E+04, -.1356756713867E+04, .1047732788086E+04},
 {   10920, .8263224609375E+04, -.1428057861328E+04, .9934270019531E+03},
 {   10921, .8233918945312E+04, -.1416843505859E+04, .1006545898438E+04},
 {   10922, .8222380859375E+04, -.1409260742188E+04, .1011711791992E+04},
 {   10923, .8208380859375E+04, -.1394785522461E+04, .1017979980469E+04},
 {   10924, .8198319335938E+04, -.1378617065430E+04, .1022482788086E+04},
 {   10925, .8190354492188E+04, -.1357788208008E+04, .1026048095703E+04},
 {   10926, .8268413085938E+04, -.1428057861328E+04, .1005018432617E+04},
 {   10927, .8239107421875E+04, -.1416843505859E+04, .1018137207031E+04},
 {   10928, .8227570312500E+04, -.1409260742188E+04, .1023303222656E+04},
 {   10929, .8213566406250E+04, -.1394785522461E+04, .1029571289062E+04},
 {   10930, .8203508789062E+04, -.1378617065430E+04, .1034074584961E+04},
 {   10931, .8195544921875E+04, -.1357788208008E+04, .1037639526367E+04},
 {   10932, .8273602539062E+04, -.1428057861328E+04, .1016609985352E+04},
 {   10933, .8244295898438E+04, -.1416843505859E+04, .1029729003906E+04},
 {   10934, .8232757812500E+04, -.1409260742188E+04, .1034894775391E+04},
 {   10935, .8218757812500E+04, -.1394785522461E+04, .1041162841797E+04},
 {   10936, .8208695312500E+04, -.1378617065430E+04, .1045665893555E+04},
 {   10937, .8200732421875E+04, -.1357788208008E+04, .1049231445312E+04},
 {   10938, .8194452148438E+04, -.1341003662109E+04, .1024213745117E+04},
 {   10939, .8190997558594E+04, -.1341413208008E+04, .1025761230469E+04},
 {   10940, .8199640625000E+04, -.1341003662109E+04, .1035805053711E+04},
 {   10941, .8196182617188E+04, -.1341413208008E+04, .1037353149414E+04},
 {   10942, .8204830078125E+04, -.1341003662109E+04, .1047396484375E+04},
 {   10943, .8201372070312E+04, -.1341413208008E+04, .1048944702148E+04},
 {   10944, .8187536621094E+04, -.1341822753906E+04, .1027309204102E+04},
 {   10945, .8192726562500E+04, -.1341822753906E+04, .1038900634766E+04},
 {   10946, .8197916992188E+04, -.1341822753906E+04, .1050492309570E+04},
 {   10947, .8362632812500E+04, -.1368801147461E+04, .9176179199219E+03},
 {   10949, .8365794921875E+04, -.1370385131836E+04, .9162022094727E+03},
 {   10950, .8362016601562E+04, -.1378023315430E+04, .9178937988281E+03},
 {   10951, .8367821289062E+04, -.1368801147461E+04, .9292096557617E+03},
 {   10953, .8370983398438E+04, -.1370385131836E+04, .9277937011719E+03},
 {   10954, .8367207031250E+04, -.1378023315430E+04, .9294855346680E+03},
 {   10955, .8373010742188E+04, -.1368801147461E+04, .9408011474609E+03},
 {   10957, .8376174804688E+04, -.1370385131836E+04, .9393851318359E+03},
 {   10958, .8372394531250E+04, -.1378023315430E+04, .9410769042969E+03},
 {   10959, .8368958984375E+04, -.1371969238281E+04, .9147863159180E+03},
 {   10960, .8364955078125E+04, -.1380061889648E+04, .9165784912109E+03},
 {   10961, .8374147460938E+04, -.1371969238281E+04, .9263778686523E+03},
 {   10962, .8370144531250E+04, -.1380061889648E+04, .9281700439453E+03},
 {   10963, .8379334960938E+04, -.1371969238281E+04, .9379694213867E+03},
 {   10964, .8375333007812E+04, -.1380061889648E+04, .9397619018555E+03},
 {   10968, .8314873046875E+04, -.1416457397461E+04, .9389984741211E+03},
 {   10971, .8351572265625E+04, -.1394143432617E+04, .9225694580078E+03},
 {   10972, .8341104492188E+04, -.1404927856445E+04, .9272556152344E+03},
 {   10973, .8329143554688E+04, -.1413646606445E+04, .9326108398438E+03},
 {   10974, .8316017578125E+04, -.1420055053711E+04, .9384860839844E+03},
 {   10975, .8300252929688E+04, -.1424143676758E+04, .9455427246094E+03},
 {   10976, .8287782226562E+04, -.1425291992188E+04, .9511254882812E+03},
 {   10980, .8320062500000E+04, -.1416457397461E+04, .9505900268555E+03},
 {   10983, .8356759765625E+04, -.1394143432617E+04, .9341611328125E+03},
 {   10984, .8346293945312E+04, -.1404927856445E+04, .9388468017578E+03},
 {   10985, .8334331054688E+04, -.1413646606445E+04, .9442025146484E+03},
 {   10986, .8321206054688E+04, -.1420055053711E+04, .9500776367188E+03},
 {   10987, .8305441406250E+04, -.1424143676758E+04, .9571346435547E+03},
 {   10988, .8292974609375E+04, -.1425291992188E+04, .9627166748047E+03},
 {   10992, .8325250976562E+04, -.1416457397461E+04, .9621814575195E+03},
 {   10995, .8361949218750E+04, -.1394143432617E+04, .9457529296875E+03},
 {   10996, .8351482421875E+04, -.1404927856445E+04, .9504385375977E+03},
 {   10997, .8339519531250E+04, -.1413646606445E+04, .9557941284180E+03},
 {   10998, .8326396484375E+04, -.1420055053711E+04, .9616689453125E+03},
 {   10999, .8310628906250E+04, -.1424143676758E+04, .9687261962891E+03},
 {   11000, .8298160156250E+04, -.1425291992188E+04, .9743084106445E+03},
 {   11001, .8354158203125E+04, -.1396690673828E+04, .9214119873047E+03},
 {   11002, .8343266601562E+04, -.1407912231445E+04, .9262877197266E+03},
 {   11003, .8330817382812E+04, -.1416984497070E+04, .9318605346680E+03},
 {   11004, .8317161132812E+04, -.1423652832031E+04, .9379736938477E+03},
 {   11005, .8300833007812E+04, -.1427900268555E+04, .9452835693359E+03},
 {   11006, .8287782226562E+04, -.1429102050781E+04, .9511254882812E+03},
 {   11007, .8359346679688E+04, -.1396690673828E+04, .9330034179688E+03},
 {   11008, .8348454101562E+04, -.1407912231445E+04, .9378792724609E+03},
 {   11009, .8336008789062E+04, -.1416984497070E+04, .9434520263672E+03},
 {   11010, .8322352539062E+04, -.1423652832031E+04, .9495649414062E+03},
 {   11011, .8306023437500E+04, -.1427900268555E+04, .9568748779297E+03},
 {   11012, .8292974609375E+04, -.1429102050781E+04, .9627166748047E+03},
 {   11013, .8364538085938E+04, -.1396690673828E+04, .9445949707031E+03},
 {   11014, .8353644531250E+04, -.1407912231445E+04, .9494708251953E+03},
 {   11015, .8341197265625E+04, -.1416984497070E+04, .9550435791016E+03},
 {   11016, .8327540039062E+04, -.1423652832031E+04, .9611567382812E+03},
 {   11017, .8311211914062E+04, -.1427900268555E+04, .9684664306641E+03},
 {   11018, .8298160156250E+04, -.1429102050781E+04, .9743084106445E+03},
 {   11021, .8276192382812E+04, -.1425291992188E+04, .9563143310547E+03},
 {   11022, .8264600585938E+04, -.1425291992188E+04, .9615036621094E+03},
 {   11025, .8281380859375E+04, -.1425291992188E+04, .9679062500000E+03},
 {   11026, .8269791015625E+04, -.1425291992188E+04, .9730949707031E+03},
 {   11029, .8286571289062E+04, -.1425291992188E+04, .9794973144531E+03},
 {   11030, .8274979492188E+04, -.1425291992188E+04, .9846864624023E+03},
 {   11031, .8276192382812E+04, -.1429102050781E+04, .9563143310547E+03},
 {   11032, .8264600585938E+04, -.1429102050781E+04, .9615036621094E+03},
 {   11033, .8281380859375E+04, -.1429102050781E+04, .9679062500000E+03},
 {   11034, .8269791015625E+04, -.1429102050781E+04, .9730949707031E+03},
 {   11035, .8286571289062E+04, -.1429102050781E+04, .9794973144531E+03},
 {   11036, .8274979492188E+04, -.1429102050781E+04, .9846864624023E+03},
 {   11042, .8185374023438E+04, -.1355725219727E+04, .9969697265625E+03},
 {   11043, .8252296875000E+04, -.1424336425781E+04, .9670120849609E+03},
 {   11044, .8223698242188E+04, -.1413383789062E+04, .9798132324219E+03},
 {   11045, .8212803710938E+04, -.1406223754883E+04, .9846909179688E+03},
 {   11046, .8199348632812E+04, -.1392312500000E+04, .9907144165039E+03},
 {   11047, .8189710449219E+04, -.1376822998047E+04, .9950286865234E+03},
 {   11048, .8182025390625E+04, -.1356756713867E+04, .9984691162109E+03},
 {   11054, .8190562500000E+04, -.1355725219727E+04, .1008562133789E+04},
 {   11055, .8257483398438E+04, -.1424336425781E+04, .9786036376953E+03},
 {   11056, .8228887695312E+04, -.1413383789062E+04, .9914047851562E+03},
 {   11057, .8217992187500E+04, -.1406223754883E+04, .9962824707031E+03},
 {   11058, .8204539062500E+04, -.1392312500000E+04, .1002305664062E+04},
 {   11059, .8194900390625E+04, -.1376822998047E+04, .1006620361328E+04},
 {   11060, .8187217285156E+04, -.1356756713867E+04, .1010060058594E+04},
 {   11066, .8195753906250E+04, -.1355725219727E+04, .1020152832031E+04},
 {   11067, .8262673828125E+04, -.1424336425781E+04, .9901954956055E+03},
 {   11068, .8234077148438E+04, -.1413383789062E+04, .1002996093750E+04},
 {   11069, .8223180664062E+04, -.1406223754883E+04, .1007873840332E+04},
 {   11070, .8209722656250E+04, -.1392312500000E+04, .1013898193359E+04},
 {   11071, .8200087890625E+04, -.1376822998047E+04, .1018211669922E+04},
 {   11072, .8192405273438E+04, -.1356756713867E+04, .1021651489258E+04},
 {   11073, .8251548828125E+04, -.1428057861328E+04, .9673459472656E+03},
 {   11074, .8222243164062E+04, -.1416843505859E+04, .9804653930664E+03},
 {   11075, .8210705078125E+04, -.1409260742188E+04, .9856306762695E+03},
 {   11076, .8196702148438E+04, -.1394785522461E+04, .9918986816406E+03},
 {   11077, .8186642578125E+04, -.1378617065430E+04, .9964017333984E+03},
 {   11078, .8178680175781E+04, -.1357788208008E+04, .9999671020508E+03},
 {   11079, .8256737304688E+04, -.1428057861328E+04, .9789376220703E+03},
 {   11080, .8227434570312E+04, -.1416843505859E+04, .9920560913086E+03},
 {   11081, .8215892578125E+04, -.1409260742188E+04, .9972222290039E+03},
 {   11082, .8201891601562E+04, -.1394785522461E+04, .1003490234375E+04},
 {   11083, .8191831054688E+04, -.1378617065430E+04, .1007993896484E+04},
 {   11084, .8183867187500E+04, -.1357788208008E+04, .1011558898926E+04},
 {   11085, .8261926757812E+04, -.1428057861328E+04, .9905292358398E+03},
 {   11086, .8232622070312E+04, -.1416843505859E+04, .1003648071289E+04},
 {   11087, .8221083007812E+04, -.1409260742188E+04, .1008813842773E+04},
 {   11088, .8207079101562E+04, -.1394785522461E+04, .1015082153320E+04},
 {   11089, .8197020507812E+04, -.1378617065430E+04, .1019585327148E+04},
 {   11090, .8189055175781E+04, -.1357788208008E+04, .1023150268555E+04},
 {   11091, .8182776367188E+04, -.1341003662109E+04, .9981326904297E+03},
 {   11092, .8179319824219E+04, -.1341413208008E+04, .9996801757812E+03},
 {   11093, .8187967285156E+04, -.1341003662109E+04, .1009723876953E+04},
 {   11094, .8184507324219E+04, -.1341413208008E+04, .1011271972656E+04},
 {   11095, .8193154296875E+04, -.1341003662109E+04, .1021315612793E+04},
 {   11096, .8189698730469E+04, -.1341413208008E+04, .1022863403320E+04},
 {   11097, .8175862304688E+04, -.1341822753906E+04, .1001227722168E+04},
 {   11098, .8181050781250E+04, -.1341822753906E+04, .1012819702148E+04},
 {   11099, .8186241699219E+04, -.1341822753906E+04, .1024410888672E+04},
 {   11100, .8443572265625E+04, -.1387192016602E+04, .1102888671875E+04},
 {   11101, .8417715820312E+04, -.1387192016602E+04, .1109649414062E+04},
 {   11102, .8391859375000E+04, -.1387192016602E+04, .1116410034180E+04},
 {   11103, .8366005859375E+04, -.1387192016602E+04, .1123170776367E+04},
 {   11104, .8443572265625E+04, -.1361791992188E+04, .1102888671875E+04},
 {   11105, .8417715820312E+04, -.1361791992188E+04, .1109649414062E+04},
 {   11106, .8391859375000E+04, -.1361791992188E+04, .1116410034180E+04},
 {   11107, .8366005859375E+04, -.1361791992188E+04, .1123170776367E+04},
 {   11108, .8443572265625E+04, -.1336392089844E+04, .1102888671875E+04},
 {   11109, .8417715820312E+04, -.1336392089844E+04, .1109649414062E+04},
 {   11110, .8391859375000E+04, -.1336392089844E+04, .1116410034180E+04},
 {   11111, .8366005859375E+04, -.1336392089844E+04, .1123170776367E+04},
 {   11112, .8449513671875E+04, -.1387192016602E+04, .1125612792969E+04},
 {   11113, .8424918945312E+04, -.1387192016602E+04, .1132043945312E+04},
 {   11114, .8400327148438E+04, -.1387192016602E+04, .1138474121094E+04},
 {   11115, .8375732421875E+04, -.1387192016602E+04, .1144905151367E+04},
 {   11116, .8449513671875E+04, -.1361791992188E+04, .1125612792969E+04},
 {   11117, .8424918945312E+04, -.1361791992188E+04, .1132043945312E+04},
 {   11118, .8400327148438E+04, -.1361791992188E+04, .1138474121094E+04},
 {   11119, .8375732421875E+04, -.1361791992188E+04, .1144905151367E+04},
 {   11120, .8454465820312E+04, -.1380842041016E+04, .1144550170898E+04},
 {   11121, .8430923828125E+04, -.1382958740234E+04, .1150705444336E+04},
 {   11122, .8407384765625E+04, -.1385075317383E+04, .1156861083984E+04},
 {   11123, .8383843750000E+04, -.1387192016602E+04, .1163016967773E+04},
 {   11124, .8454465820312E+04, -.1358617065430E+04, .1144550170898E+04},
 {   11125, .8430923828125E+04, -.1359675415039E+04, .1150705444336E+04},
 {   11126, .8407384765625E+04, -.1360733642578E+04, .1156861083984E+04},
 {   11127, .8383843750000E+04, -.1361791992188E+04, .1163016967773E+04},
 {   11128, .8454465820312E+04, -.1336392089844E+04, .1144550170898E+04},
 {   11129, .8430923828125E+04, -.1336392089844E+04, .1150705444336E+04},
 {   11130, .8407384765625E+04, -.1336392089844E+04, .1156861083984E+04},
 {   11131, .8383843750000E+04, -.1336392089844E+04, .1163016967773E+04},
 {   11132, .8459418945312E+04, -.1374492065430E+04, .1163487670898E+04},
 {   11133, .8436927734375E+04, -.1378725341797E+04, .1169367431641E+04},
 {   11134, .8414439453125E+04, -.1382958740234E+04, .1175248291016E+04},
 {   11135, .8391950195312E+04, -.1387192016602E+04, .1181129028320E+04},
 {   11136, .8459418945312E+04, -.1355442016602E+04, .1163487670898E+04},
 {   11137, .8436927734375E+04, -.1357558715820E+04, .1169367431641E+04},
 {   11138, .8414439453125E+04, -.1359675415039E+04, .1175248291016E+04},
 {   11139, .8391950195312E+04, -.1361791992188E+04, .1181129028320E+04},
 {   11140, .8459418945312E+04, -.1336392089844E+04, .1163487670898E+04},
 {   11141, .8436927734375E+04, -.1336392089844E+04, .1169367431641E+04},
 {   11142, .8414439453125E+04, -.1336392089844E+04, .1175248291016E+04},
 {   11143, .8391950195312E+04, -.1336392089844E+04, .1181129028320E+04},
 {   11144, .8443572265625E+04, -.1234791992188E+04, .1102888671875E+04},
 {   11145, .8417715820312E+04, -.1234791992188E+04, .1109649414062E+04},
 {   11146, .8391859375000E+04, -.1234791992188E+04, .1116410034180E+04},
 {   11147, .8366005859375E+04, -.1234791992188E+04, .1123170776367E+04},
 {   11148, .8443572265625E+04, -.1209392089844E+04, .1102888671875E+04},
 {   11149, .8417715820312E+04, -.1209392089844E+04, .1109649414062E+04},
 {   11150, .8391859375000E+04, -.1209392089844E+04, .1116410034180E+04},
 {   11151, .8366005859375E+04, -.1209392089844E+04, .1123170776367E+04},
 {   11152, .8443572265625E+04, -.1183992065430E+04, .1102888671875E+04},
 {   11153, .8417715820312E+04, -.1183992065430E+04, .1109649414062E+04},
 {   11154, .8391859375000E+04, -.1183992065430E+04, .1116410034180E+04},
 {   11155, .8366005859375E+04, -.1183992065430E+04, .1123170776367E+04},
 {   11156, .8449513671875E+04, -.1209392089844E+04, .1125612792969E+04},
 {   11157, .8424918945312E+04, -.1209392089844E+04, .1132043945312E+04},
 {   11158, .8400327148438E+04, -.1209392089844E+04, .1138474121094E+04},
 {   11159, .8375732421875E+04, -.1209392089844E+04, .1144905151367E+04},
 {   11160, .8449513671875E+04, -.1183992065430E+04, .1125612792969E+04},
 {   11161, .8424918945312E+04, -.1183992065430E+04, .1132043945312E+04},
 {   11162, .8400327148438E+04, -.1183992065430E+04, .1138474121094E+04},
 {   11163, .8375732421875E+04, -.1183992065430E+04, .1144905151367E+04},
 {   11164, .8454465820312E+04, -.1234791992188E+04, .1144550170898E+04},
 {   11165, .8430923828125E+04, -.1234791992188E+04, .1150705444336E+04},
 {   11166, .8407384765625E+04, -.1234791992188E+04, .1156861083984E+04},
 {   11167, .8383843750000E+04, -.1234791992188E+04, .1163016967773E+04},
 {   11168, .8454465820312E+04, -.1212567016602E+04, .1144550170898E+04},
 {   11169, .8430923828125E+04, -.1211508666992E+04, .1150705444336E+04},
 {   11170, .8407384765625E+04, -.1210450317383E+04, .1156861083984E+04},
 {   11171, .8383843750000E+04, -.1209392089844E+04, .1163016967773E+04},
 {   11172, .8454465820312E+04, -.1190342041016E+04, .1144550170898E+04},
 {   11173, .8430923828125E+04, -.1188225341797E+04, .1150705444336E+04},
 {   11174, .8407384765625E+04, -.1186108642578E+04, .1156861083984E+04},
 {   11175, .8383843750000E+04, -.1183992065430E+04, .1163016967773E+04},
 {   11176, .8459418945312E+04, -.1234791992188E+04, .1163487670898E+04},
 {   11177, .8436927734375E+04, -.1234791992188E+04, .1169367431641E+04},
 {   11178, .8414439453125E+04, -.1234791992188E+04, .1175248291016E+04},
 {   11179, .8391950195312E+04, -.1234791992188E+04, .1181129028320E+04},
 {   11180, .8459418945312E+04, -.1215742065430E+04, .1163487670898E+04},
 {   11181, .8436927734375E+04, -.1213625366211E+04, .1169367431641E+04},
 {   11182, .8414439453125E+04, -.1211508666992E+04, .1175248291016E+04},
 {   11183, .8391950195312E+04, -.1209392089844E+04, .1181129028320E+04},
 {   11184, .8459418945312E+04, -.1196692016602E+04, .1163487670898E+04},
 {   11185, .8436927734375E+04, -.1192458740234E+04, .1169367431641E+04},
 {   11186, .8414439453125E+04, -.1188225341797E+04, .1175248291016E+04},
 {   11187, .8391950195312E+04, -.1183992065430E+04, .1181129028320E+04},
 {   11188, .8338129882812E+04, -.1387192016602E+04, .1130459960938E+04},
 {   11189, .8310255859375E+04, -.1387192016602E+04, .1137748535156E+04},
 {   11190, .8282379882812E+04, -.1387192016602E+04, .1145038208008E+04},
 {   11191, .8338129882812E+04, -.1361791992188E+04, .1130459960938E+04},
 {   11192, .8310255859375E+04, -.1361791992188E+04, .1137748535156E+04},
 {   11193, .8282379882812E+04, -.1361791992188E+04, .1145038208008E+04},
 {   11194, .8338129882812E+04, -.1336392089844E+04, .1130459960938E+04},
 {   11195, .8310255859375E+04, -.1336392089844E+04, .1137748535156E+04},
 {   11196, .8282379882812E+04, -.1336392089844E+04, .1145038208008E+04},
 {   11197, .8347859375000E+04, -.1387192016602E+04, .1152194335938E+04},
 {   11198, .8319983398438E+04, -.1387192016602E+04, .1159483032227E+04},
 {   11199, .8292108398438E+04, -.1387192016602E+04, .1166772827148E+04},
 {   11200, .8347859375000E+04, -.1361791992188E+04, .1152194335938E+04},
 {   11201, .8319983398438E+04, -.1361791992188E+04, .1159483032227E+04},
 {   11202, .8292108398438E+04, -.1361791992188E+04, .1166772827148E+04},
 {   11203, .8347859375000E+04, -.1336392089844E+04, .1152194335938E+04},
 {   11204, .8319983398438E+04, -.1336392089844E+04, .1159483032227E+04},
 {   11205, .8292108398438E+04, -.1336392089844E+04, .1166772827148E+04},
 {   11206, .8357987304688E+04, -.1385075317383E+04, .1169777587891E+04},
 {   11207, .8332132812500E+04, -.1382958740234E+04, .1176538330078E+04},
 {   11208, .8306276367188E+04, -.1380842041016E+04, .1183299072266E+04},
 {   11209, .8356977539062E+04, -.1360733642578E+04, .1170041625977E+04},
 {   11210, .8330111328125E+04, -.1359675415039E+04, .1177066772461E+04},
 {   11211, .8303247070312E+04, -.1358617065430E+04, .1184091552734E+04},
 {   11212, .8355966796875E+04, -.1336392089844E+04, .1170306274414E+04},
 {   11213, .8328090820312E+04, -.1336392089844E+04, .1177595214844E+04},
 {   11214, .8300215820312E+04, -.1336392089844E+04, .1184883789062E+04},
 {   11215, .8368115234375E+04, -.1382958740234E+04, .1187361328125E+04},
 {   11216, .8344278320312E+04, -.1378725341797E+04, .1193593872070E+04},
 {   11217, .8320444335938E+04, -.1374492065430E+04, .1199826660156E+04},
 {   11218, .8366095703125E+04, -.1359675415039E+04, .1187889282227E+04},
 {   11219, .8340242187500E+04, -.1357558715820E+04, .1194650146484E+04},
 {   11220, .8314385742188E+04, -.1355442016602E+04, .1201411376953E+04},
 {   11221, .8364075195312E+04, -.1336392089844E+04, .1188418090820E+04},
 {   11222, .8336200195312E+04, -.1336392089844E+04, .1195706787109E+04},
 {   11223, .8308325195312E+04, -.1336392089844E+04, .1202995727539E+04},
 {   11224, .8366005859375E+04, -.1317342041016E+04, .1123170776367E+04},
 {   11225, .8338129882812E+04, -.1317342041016E+04, .1130459960938E+04},
 {   11226, .8310255859375E+04, -.1317342041016E+04, .1137748535156E+04},
 {   11227, .8282379882812E+04, -.1317342041016E+04, .1145038208008E+04},
 {   11228, .8347859375000E+04, -.1317342041016E+04, .1152194335938E+04},
 {   11229, .8319983398438E+04, -.1317342041016E+04, .1159483032227E+04},
 {   11230, .8292108398438E+04, -.1317342041016E+04, .1166772827148E+04},
 {   11231, .8383843750000E+04, -.1317342041016E+04, .1163016967773E+04},
 {   11232, .8355966796875E+04, -.1317342041016E+04, .1170306274414E+04},
 {   11233, .8328090820312E+04, -.1317342041016E+04, .1177595214844E+04},
 {   11234, .8300215820312E+04, -.1317342041016E+04, .1184883789062E+04},
 {   11235, .8391950195312E+04, -.1317342041016E+04, .1181129028320E+04},
 {   11236, .8364075195312E+04, -.1317342041016E+04, .1188418090820E+04},
 {   11237, .8336200195312E+04, -.1317342041016E+04, .1195706787109E+04},
 {   11238, .8308325195312E+04, -.1317342041016E+04, .1202995727539E+04},
 {   11239, .8366005859375E+04, -.1295117065430E+04, .1123170776367E+04},
 {   11240, .8338129882812E+04, -.1295117065430E+04, .1130459960938E+04},
 {   11241, .8310255859375E+04, -.1295117065430E+04, .1137748535156E+04},
 {   11242, .8282379882812E+04, -.1295117065430E+04, .1145038208008E+04},
 {   11243, .8347859375000E+04, -.1295117065430E+04, .1152194335938E+04},
 {   11244, .8319983398438E+04, -.1295117065430E+04, .1159483032227E+04},
 {   11245, .8292108398438E+04, -.1295117065430E+04, .1166772827148E+04},
 {   11246, .8383843750000E+04, -.1295117065430E+04, .1163016967773E+04},
 {   11247, .8355966796875E+04, -.1295117065430E+04, .1170306274414E+04},
 {   11248, .8328090820312E+04, -.1295117065430E+04, .1177595214844E+04},
 {   11249, .8300215820312E+04, -.1295117065430E+04, .1184883789062E+04},
 {   11250, .8391950195312E+04, -.1295117065430E+04, .1181129028320E+04},
 {   11251, .8364075195312E+04, -.1295117065430E+04, .1188418090820E+04},
 {   11252, .8336200195312E+04, -.1295117065430E+04, .1195706787109E+04},
 {   11253, .8308325195312E+04, -.1295117065430E+04, .1202995727539E+04},
 {   11254, .8366005859375E+04, -.1276067016602E+04, .1123170776367E+04},
 {   11255, .8338129882812E+04, -.1276067016602E+04, .1130459960938E+04},
 {   11256, .8310255859375E+04, -.1276067016602E+04, .1137748535156E+04},
 {   11257, .8282379882812E+04, -.1276067016602E+04, .1145038208008E+04},
 {   11258, .8347859375000E+04, -.1276067016602E+04, .1152194335938E+04},
 {   11259, .8319983398438E+04, -.1276067016602E+04, .1159483032227E+04},
 {   11260, .8292108398438E+04, -.1276067016602E+04, .1166772827148E+04},
 {   11261, .8383843750000E+04, -.1276067016602E+04, .1163016967773E+04},
 {   11262, .8355966796875E+04, -.1276067016602E+04, .1170306274414E+04},
 {   11263, .8328090820312E+04, -.1276067016602E+04, .1177595214844E+04},
 {   11264, .8300215820312E+04, -.1276067016602E+04, .1184883789062E+04},
 {   11265, .8391950195312E+04, -.1276067016602E+04, .1181129028320E+04},
 {   11266, .8364075195312E+04, -.1276067016602E+04, .1188418090820E+04},
 {   11267, .8336200195312E+04, -.1276067016602E+04, .1195706787109E+04},
 {   11268, .8308325195312E+04, -.1276067016602E+04, .1202995727539E+04},
 {   11269, .8366005859375E+04, -.1253842041016E+04, .1123170776367E+04},
 {   11270, .8338129882812E+04, -.1253842041016E+04, .1130459960938E+04},
 {   11271, .8310255859375E+04, -.1253842041016E+04, .1137748535156E+04},
 {   11272, .8282379882812E+04, -.1253842041016E+04, .1145038208008E+04},
 {   11273, .8347859375000E+04, -.1253842041016E+04, .1152194335938E+04},
 {   11274, .8319983398438E+04, -.1253842041016E+04, .1159483032227E+04},
 {   11275, .8292108398438E+04, -.1253842041016E+04, .1166772827148E+04},
 {   11276, .8383843750000E+04, -.1253842041016E+04, .1163016967773E+04},
 {   11277, .8355966796875E+04, -.1253842041016E+04, .1170306274414E+04},
 {   11278, .8328090820312E+04, -.1253842041016E+04, .1177595214844E+04},
 {   11279, .8300215820312E+04, -.1253842041016E+04, .1184883789062E+04},
 {   11280, .8391950195312E+04, -.1253842041016E+04, .1181129028320E+04},
 {   11281, .8364075195312E+04, -.1253842041016E+04, .1188418090820E+04},
 {   11282, .8336200195312E+04, -.1253842041016E+04, .1195706787109E+04},
 {   11283, .8308325195312E+04, -.1253842041016E+04, .1202995727539E+04},
 {   11284, .8338129882812E+04, -.1234791992188E+04, .1130459960938E+04},
 {   11285, .8310255859375E+04, -.1234791992188E+04, .1137748535156E+04},
 {   11286, .8282379882812E+04, -.1234791992188E+04, .1145038208008E+04},
 {   11287, .8347859375000E+04, -.1234791992188E+04, .1152194335938E+04},
 {   11288, .8319983398438E+04, -.1234791992188E+04, .1159483032227E+04},
 {   11289, .8292108398438E+04, -.1234791992188E+04, .1166772827148E+04},
 {   11290, .8355966796875E+04, -.1234791992188E+04, .1170306274414E+04},
 {   11291, .8328090820312E+04, -.1234791992188E+04, .1177595214844E+04},
 {   11292, .8300215820312E+04, -.1234791992188E+04, .1184883789062E+04},
 {   11293, .8364075195312E+04, -.1234791992188E+04, .1188418090820E+04},
 {   11294, .8336200195312E+04, -.1234791992188E+04, .1195706787109E+04},
 {   11295, .8308325195312E+04, -.1234791992188E+04, .1202995727539E+04},
 {   11296, .8338129882812E+04, -.1209392089844E+04, .1130459960938E+04},
 {   11297, .8310255859375E+04, -.1209392089844E+04, .1137748535156E+04},
 {   11298, .8282379882812E+04, -.1209392089844E+04, .1145038208008E+04},
 {   11299, .8338129882812E+04, -.1183992065430E+04, .1130459960938E+04},
 {   11300, .8310255859375E+04, -.1183992065430E+04, .1137748535156E+04},
 {   11301, .8282379882812E+04, -.1183992065430E+04, .1145038208008E+04},
 {   11302, .8347859375000E+04, -.1209392089844E+04, .1152194335938E+04},
 {   11303, .8319983398438E+04, -.1209392089844E+04, .1159483032227E+04},
 {   11304, .8292108398438E+04, -.1209392089844E+04, .1166772827148E+04},
 {   11305, .8347859375000E+04, -.1183992065430E+04, .1152194335938E+04},
 {   11306, .8319983398438E+04, -.1183992065430E+04, .1159483032227E+04},
 {   11307, .8292108398438E+04, -.1183992065430E+04, .1166772827148E+04},
 {   11308, .8356977539062E+04, -.1210450317383E+04, .1170041625977E+04},
 {   11309, .8330111328125E+04, -.1211508666992E+04, .1177066772461E+04},
 {   11310, .8303247070312E+04, -.1212567016602E+04, .1184091552734E+04},
 {   11311, .8357987304688E+04, -.1186108642578E+04, .1169777587891E+04},
 {   11312, .8332132812500E+04, -.1188225341797E+04, .1176538330078E+04},
 {   11313, .8306276367188E+04, -.1190342041016E+04, .1183299072266E+04},
 {   11314, .8366095703125E+04, -.1211508666992E+04, .1187889282227E+04},
 {   11315, .8340242187500E+04, -.1213625366211E+04, .1194650146484E+04},
 {   11316, .8314385742188E+04, -.1215742065430E+04, .1201411376953E+04},
 {   11317, .8368115234375E+04, -.1188225341797E+04, .1187361328125E+04},
 {   11318, .8344278320312E+04, -.1192458740234E+04, .1193593872070E+04},
 {   11319, .8320443359375E+04, -.1196692016602E+04, .1199826416016E+04},
 {   11320, .8404485351562E+04, -.1122758666992E+04, .1121844970703E+04},
 {   11321, .8381972656250E+04, -.1118620239258E+04, .1112112426758E+04},
 {   11322, .8401159179688E+04, -.1100165039062E+04, .1119989013672E+04},
 {   11323, .8382029296875E+04, -.1103046142578E+04, .1112086303711E+04},
 {   11324, .8391325195312E+04, -.1079944824219E+04, .1115582763672E+04},
 {   11325, .8382090820312E+04, -.1087472045898E+04, .1112058715820E+04},
 {   11326, .8409369140625E+04, -.1128391967773E+04, .1094268310547E+04},
 {   11327, .8375225585938E+04, -.1118620239258E+04, .1097043823242E+04},
 {   11328, .8405207031250E+04, -.1098509643555E+04, .1094110473633E+04},
 {   11329, .8375284179688E+04, -.1103046142578E+04, .1097016845703E+04},
 {   11330, .8389226562500E+04, -.1073224121094E+04, .1095620361328E+04},
 {   11331, .8375346679688E+04, -.1087472045898E+04, .1096989501953E+04},
 {   11332, .8402986328125E+04, -.1130790893555E+04, .1066527343750E+04},
 {   11333, .8368478515625E+04, -.1118620239258E+04, .1081974731445E+04},
 {   11334, .8399291015625E+04, -.1098207885742E+04, .1068181640625E+04},
 {   11335, .8368539062500E+04, -.1103046142578E+04, .1081948242188E+04},
 {   11336, .8382629882812E+04, -.1070915771484E+04, .1075640014648E+04},
 {   11337, .8368596679688E+04, -.1087472045898E+04, .1081921508789E+04},
 {   11338, .8387418945312E+04, -.1130790893555E+04, .1031752441406E+04},
 {   11339, .8352910156250E+04, -.1118620239258E+04, .1047200073242E+04},
 {   11340, .8383725585938E+04, -.1098207885742E+04, .1033407104492E+04},
 {   11341, .8352972656250E+04, -.1103046142578E+04, .1047172973633E+04},
 {   11342, .8367062500000E+04, -.1070915771484E+04, .1040865356445E+04},
 {   11343, .8353030273438E+04, -.1087472045898E+04, .1047146728516E+04},
 {   11344, .8371851562500E+04, -.1130790893555E+04, .9969778442383E+03},
 {   11345, .8337343750000E+04, -.1118620239258E+04, .1012425842285E+04},
 {   11346, .8368157226562E+04, -.1098207885742E+04, .9986320800781E+03},
 {   11347, .8337405273438E+04, -.1103046142578E+04, .1012398986816E+04},
 {   11348, .8351494140625E+04, -.1070915771484E+04, .1006090515137E+04},
 {   11349, .8337463867188E+04, -.1087472045898E+04, .1012371765137E+04},
 {   11350, .8353689453125E+04, -.1130791015625E+04, .9564077148438E+03},
 {   11351, .8319183593750E+04, -.1118620239258E+04, .9718551025391E+03},
 {   11352, .8349993164062E+04, -.1098207885742E+04, .9580620727539E+03},
 {   11353, .8319242187500E+04, -.1103046142578E+04, .9718286132812E+03},
 {   11354, .8333335937500E+04, -.1070915771484E+04, .9655201416016E+03},
 {   11355, .8319302734375E+04, -.1087472045898E+04, .9718016357422E+03},
 {   11356, .8335528320312E+04, -.1130791015625E+04, .9158373413086E+03},
 {   11357, .8301020507812E+04, -.1118620239258E+04, .9312851562500E+03},
 {   11358, .8331833984375E+04, -.1098207885742E+04, .9174913330078E+03},
 {   11359, .8301080078125E+04, -.1103046142578E+04, .9312581787109E+03},
 {   11360, .8315170898438E+04, -.1070915771484E+04, .9249499511719E+03},
 {   11361, .8301140625000E+04, -.1087472045898E+04, .9312313232422E+03},
 {   11362, .8319087890625E+04, -.1128391967773E+04, .8925979614258E+03},
 {   11363, .8294276367188E+04, -.1118620239258E+04, .9162157592773E+03},
 {   11364, .8316433593750E+04, -.1098509643555E+04, .8958073730469E+03},
 {   11365, .8294333984375E+04, -.1103046142578E+04, .9161892089844E+03},
 {   11366, .8304663085938E+04, -.1073224121094E+04, .9067205810547E+03},
 {   11367, .8294394531250E+04, -.1087472045898E+04, .9161624145508E+03},
 {   11368, .8295269531250E+04, -.1122758789062E+04, .8778710937500E+03},
 {   11369, .8287529296875E+04, -.1118620239258E+04, .9011470336914E+03},
 {   11370, .8294436523438E+04, -.1100165039062E+04, .8815879516602E+03},
 {   11371, .8287589843750E+04, -.1103046142578E+04, .9011201782227E+03},
 {   11372, .8291172851562E+04, -.1079944824219E+04, .8918577880859E+03},
 {   11373, .8287650390625E+04, -.1087472045898E+04, .9010929565430E+03},
 {   11374, .8389770507812E+04, -.1117541015625E+04, .1144353515625E+04},
 {   11375, .8367351562500E+04, -.1115411987305E+04, .1159951416016E+04},
 {   11376, .8385882812500E+04, -.1093583862305E+04, .1139480834961E+04},
 {   11377, .8364435546875E+04, -.1091147583008E+04, .1153436645508E+04},
 {   11378, .8376462890625E+04, -.1073224121094E+04, .1129073608398E+04},
 {   11379, .8358233398438E+04, -.1070915771484E+04, .1139582275391E+04},
 {   11380, .8367034179688E+04, -.1116215942383E+04, .1118799926758E+04},
 {   11381, .8351951171875E+04, -.1115411987305E+04, .1125551025391E+04},
 {   11382, .8367027343750E+04, -.1101843994141E+04, .1118802490234E+04},
 {   11383, .8351951171875E+04, -.1101442016602E+04, .1125551025391E+04},
 {   11384, .8367021484375E+04, -.1087472045898E+04, .1118804565430E+04},
 {   11385, .8351951171875E+04, -.1087472045898E+04, .1125551025391E+04},
 {   11386, .8360287109375E+04, -.1116215942383E+04, .1103730834961E+04},
 {   11387, .8345205078125E+04, -.1115411987305E+04, .1110482055664E+04},
 {   11388, .8360282226562E+04, -.1101843994141E+04, .1103733520508E+04},
 {   11389, .8345205078125E+04, -.1101442016602E+04, .1110482055664E+04},
 {   11390, .8360277343750E+04, -.1087472045898E+04, .1103736083984E+04},
 {   11391, .8345205078125E+04, -.1087472045898E+04, .1110482055664E+04},
 {   11392, .8353541992188E+04, -.1116215942383E+04, .1088661865234E+04},
 {   11393, .8338461914062E+04, -.1115411987305E+04, .1095413208008E+04},
 {   11394, .8353535156250E+04, -.1101843994141E+04, .1088664550781E+04},
 {   11395, .8338461914062E+04, -.1101442016602E+04, .1095413208008E+04},
 {   11396, .8353531250000E+04, -.1087472045898E+04, .1088666992188E+04},
 {   11397, .8338461914062E+04, -.1087472045898E+04, .1095413208008E+04},
 {   11398, .8337975585938E+04, -.1116215942383E+04, .1053887207031E+04},
 {   11399, .8322892578125E+04, -.1115411987305E+04, .1060638183594E+04},
 {   11400, .8337969726562E+04, -.1101843994141E+04, .1053889648438E+04},
 {   11401, .8322892578125E+04, -.1101442016602E+04, .1060638183594E+04},
 {   11402, .8337963867188E+04, -.1087472045898E+04, .1053892333984E+04},
 {   11403, .8322892578125E+04, -.1087472045898E+04, .1060638183594E+04},
 {   11404, .8322407226562E+04, -.1116215942383E+04, .1019113037109E+04},
 {   11405, .8307327148438E+04, -.1115411987305E+04, .1025863769531E+04},
 {   11406, .8322401367188E+04, -.1101843994141E+04, .1019115295410E+04},
 {   11407, .8307327148438E+04, -.1101442016602E+04, .1025863769531E+04},
 {   11408, .8322395507812E+04, -.1087472045898E+04, .1019117492676E+04},
 {   11409, .8307327148438E+04, -.1087472045898E+04, .1025863769531E+04},
 {   11410, .8304245117188E+04, -.1116216064453E+04, .9785419921875E+03},
 {   11411, .8289163085938E+04, -.1115412109375E+04, .9852933959961E+03},
 {   11412, .8304239257812E+04, -.1101843994141E+04, .9785447998047E+03},
 {   11413, .8289163085938E+04, -.1101442016602E+04, .9852933959961E+03},
 {   11414, .8304234375000E+04, -.1087472045898E+04, .9785473632812E+03},
 {   11415, .8289163085938E+04, -.1087472045898E+04, .9852933959961E+03},
 {   11416, .8286083007812E+04, -.1116216064453E+04, .9379721679688E+03},
 {   11417, .8271002929688E+04, -.1115412109375E+04, .9447230224609E+03},
 {   11418, .8286079101562E+04, -.1101843994141E+04, .9379744873047E+03},
 {   11419, .8271002929688E+04, -.1101442016602E+04, .9447230224609E+03},
 {   11420, .8286072265625E+04, -.1087472045898E+04, .9379769287109E+03},
 {   11421, .8271002929688E+04, -.1087472045898E+04, .9447230224609E+03},
 {   11422, .8279337890625E+04, -.1116216064453E+04, .9229030151367E+03},
 {   11423, .8264257812500E+04, -.1115412109375E+04, .9296538085938E+03},
 {   11424, .8279333007812E+04, -.1101843994141E+04, .9229054565430E+03},
 {   11425, .8264257812500E+04, -.1101442016602E+04, .9296538085938E+03},
 {   11426, .8279328125000E+04, -.1087472045898E+04, .9229077148438E+03},
 {   11427, .8264257812500E+04, -.1087472045898E+04, .9296538085938E+03},
 {   11428, .8272591796875E+04, -.1116216064453E+04, .9078341674805E+03},
 {   11429, .8257511718750E+04, -.1115412109375E+04, .9145847167969E+03},
 {   11430, .8272585937500E+04, -.1101843994141E+04, .9078365478516E+03},
 {   11431, .8257511718750E+04, -.1101442016602E+04, .9145847167969E+03},
 {   11432, .8272580078125E+04, -.1087472045898E+04, .9078391113281E+03},
 {   11433, .8257511718750E+04, -.1087472045898E+04, .9145847167969E+03},
 {   11434, .8268678710938E+04, -.1117541137695E+04, .8738530883789E+03},
 {   11435, .8242110351562E+04, -.1115412109375E+04, .8801839599609E+03},
 {   11436, .8269721679688E+04, -.1093583862305E+04, .8799988403320E+03},
 {   11437, .8245027343750E+04, -.1091147583008E+04, .8866992187500E+03},
 {   11438, .8271210937500E+04, -.1073224121094E+04, .8939567871094E+03},
 {   11439, .8251229492188E+04, -.1070915771484E+04, .9005531616211E+03},
 {   11440, .8371106445312E+04, -.1061086914062E+04, .1107868041992E+04},
 {   11441, .8349082031250E+04, -.1056833251953E+04, .1119139648438E+04},
 {   11442, .8362187500000E+04, -.1056833251953E+04, .1084791381836E+04},
 {   11443, .8338461914062E+04, -.1051912109375E+04, .1095413208008E+04},
 {   11444, .8346622070312E+04, -.1056833251953E+04, .1050016723633E+04},
 {   11445, .8322892578125E+04, -.1051912109375E+04, .1060638183594E+04},
 {   11446, .8331053710938E+04, -.1056833251953E+04, .1015241943359E+04},
 {   11447, .8307327148438E+04, -.1051912109375E+04, .1025863769531E+04},
 {   11448, .8312891601562E+04, -.1056833251953E+04, .9746717529297E+03},
 {   11449, .8289163085938E+04, -.1051912109375E+04, .9852933959961E+03},
 {   11450, .8294728515625E+04, -.1056833251953E+04, .9341013183594E+03},
 {   11451, .8271002929688E+04, -.1051912109375E+04, .9447230224609E+03},
 {   11452, .8283458007812E+04, -.1061086914062E+04, .9120776367188E+03},
 {   11453, .8260381835938E+04, -.1056833251953E+04, .9209960937500E+03},
 {   11454, .8340785156250E+04, -.1117541015625E+04, .1166282348633E+04},
 {   11455, .8314194335938E+04, -.1122758666992E+04, .1162264282227E+04},
 {   11456, .8339740234375E+04, -.1093583862305E+04, .1160136840820E+04},
 {   11457, .8315027343750E+04, -.1100165039062E+04, .1158548095703E+04},
 {   11458, .8338251953125E+04, -.1073224121094E+04, .1146178710938E+04},
 {   11459, .8318291015625E+04, -.1079944824219E+04, .1148277832031E+04},
 {   11460, .8336871093750E+04, -.1116215942383E+04, .1132301513672E+04},
 {   11461, .8321934570312E+04, -.1118620239258E+04, .1138989013672E+04},
 {   11462, .8336878906250E+04, -.1101843994141E+04, .1132299072266E+04},
 {   11463, .8321874023438E+04, -.1103046142578E+04, .1139015258789E+04},
 {   11464, .8336884765625E+04, -.1087472045898E+04, .1132296386719E+04},
 {   11465, .8321814453125E+04, -.1087472045898E+04, .1139042968750E+04},
 {   11466, .8330126953125E+04, -.1116215942383E+04, .1117232666016E+04},
 {   11467, .8315188476562E+04, -.1118620239258E+04, .1123919799805E+04},
 {   11468, .8330132812500E+04, -.1101843994141E+04, .1117230468750E+04},
 {   11469, .8315127929688E+04, -.1103046142578E+04, .1123946655273E+04},
 {   11470, .8330138671875E+04, -.1087472045898E+04, .1117228027344E+04},
 {   11471, .8315067382812E+04, -.1087472045898E+04, .1123973388672E+04},
 {   11472, .8323380859375E+04, -.1116215942383E+04, .1102163574219E+04},
 {   11473, .8308441406250E+04, -.1118620239258E+04, .1108850830078E+04},
 {   11474, .8323384765625E+04, -.1101843994141E+04, .1102160888672E+04},
 {   11475, .8308382812500E+04, -.1103046142578E+04, .1108877441406E+04},
 {   11476, .8323390625000E+04, -.1087472045898E+04, .1102158447266E+04},
 {   11477, .8308323242188E+04, -.1087472045898E+04, .1108904541016E+04},
 {   11478, .8307812500000E+04, -.1116215942383E+04, .1067389404297E+04},
 {   11479, .8292874023438E+04, -.1118620239258E+04, .1074075927734E+04},
 {   11480, .8307818359375E+04, -.1101843994141E+04, .1067386962891E+04},
 {   11481, .8292816406250E+04, -.1103046142578E+04, .1074102783203E+04},
 {   11482, .8307824218750E+04, -.1087472045898E+04, .1067384277344E+04},
 {   11483, .8292755859375E+04, -.1087472045898E+04, .1074129516602E+04},
 {   11484, .8292245117188E+04, -.1116215942383E+04, .1032614257812E+04},
 {   11485, .8277308593750E+04, -.1118620239258E+04, .1039301269531E+04},
 {   11486, .8292250000000E+04, -.1101843994141E+04, .1032612060547E+04},
 {   11487, .8277249023438E+04, -.1103046142578E+04, .1039328247070E+04},
 {   11488, .8292255859375E+04, -.1087472045898E+04, .1032609497070E+04},
 {   11489, .8277189453125E+04, -.1087472045898E+04, .1039355346680E+04},
 {   11490, .8274083984375E+04, -.1116216064453E+04, .9920440673828E+03},
 {   11491, .8259146484375E+04, -.1118620239258E+04, .9987310791016E+03},
 {   11492, .8274088867188E+04, -.1101843994141E+04, .9920412597656E+03},
 {   11493, .8259085937500E+04, -.1103046142578E+04, .9987578125000E+03},
 {   11494, .8274094726562E+04, -.1087472045898E+04, .9920388793945E+03},
 {   11495, .8259026367188E+04, -.1087472045898E+04, .9987851562500E+03},
 {   11496, .8255923828125E+04, -.1116216064453E+04, .9514736328125E+03},
 {   11497, .8240986328125E+04, -.1118620239258E+04, .9581606445312E+03},
 {   11498, .8255927734375E+04, -.1101843994141E+04, .9514712524414E+03},
 {   11499, .8240923828125E+04, -.1103046142578E+04, .9581879882812E+03},
 {   11500, .8255934570312E+04, -.1087472045898E+04, .9514685668945E+03},
 {   11501, .8240865234375E+04, -.1087472045898E+04, .9582145385742E+03},
 {   11502, .8249175781250E+04, -.1116216064453E+04, .9364047851562E+03},
 {   11503, .8234238281250E+04, -.1118620239258E+04, .9430916748047E+03},
 {   11504, .8249181640625E+04, -.1101843994141E+04, .9364023437500E+03},
 {   11505, .8234180664062E+04, -.1103046142578E+04, .9431182861328E+03},
 {   11506, .8249187500000E+04, -.1087472045898E+04, .9363999633789E+03},
 {   11507, .8234119140625E+04, -.1087472045898E+04, .9431454467773E+03},
 {   11508, .8242429687500E+04, -.1116216064453E+04, .9213358764648E+03},
 {   11509, .8227490234375E+04, -.1118620239258E+04, .9280230712891E+03},
 {   11510, .8242436523438E+04, -.1101843994141E+04, .9213330688477E+03},
 {   11511, .8227434570312E+04, -.1103046142578E+04, .9280494384766E+03},
 {   11512, .8242442382812E+04, -.1087472045898E+04, .9213309326172E+03},
 {   11513, .8227373046875E+04, -.1087472045898E+04, .9280765380859E+03},
 {   11514, .8219694335938E+04, -.1117541137695E+04, .8957818603516E+03},
 {   11515, .8204978515625E+04, -.1122758789062E+04, .9182906494141E+03},
 {   11516, .8223579101562E+04, -.1093583862305E+04, .9006544799805E+03},
 {   11517, .8208303710938E+04, -.1100165039062E+04, .9201462402344E+03},
 {   11518, .8233000000000E+04, -.1073224121094E+04, .9110623779297E+03},
 {   11519, .8218137695312E+04, -.1079944824219E+04, .9245528564453E+03},
 {   11520, .8326004882812E+04, -.1061086914062E+04, .1128057983398E+04},
 {   11521, .8304801757812E+04, -.1073224121094E+04, .1133414794922E+04},
 {   11522, .8314734375000E+04, -.1056833251953E+04, .1106033813477E+04},
 {   11523, .8294291015625E+04, -.1070915771484E+04, .1115186157227E+04},
 {   11524, .8299167968750E+04, -.1056833251953E+04, .1071259399414E+04},
 {   11525, .8278723632812E+04, -.1070915771484E+04, .1080411254883E+04},
 {   11526, .8283598632812E+04, -.1056833251953E+04, .1036485351562E+04},
 {   11527, .8263155273438E+04, -.1070915771484E+04, .1045636718750E+04},
 {   11528, .8265437500000E+04, -.1056833251953E+04, .9959149169922E+03},
 {   11529, .8244993164062E+04, -.1070915771484E+04, .1005066650391E+04},
 {   11530, .8247276367188E+04, -.1056833251953E+04, .9553442382812E+03},
 {   11531, .8226833984375E+04, -.1070915771484E+04, .9644958496094E+03},
 {   11532, .8238358398438E+04, -.1061086914062E+04, .9322674560547E+03},
 {   11533, .8220236328125E+04, -.1073224121094E+04, .9445153198242E+03},
 {   11534, .8290374023438E+04, -.1128391967773E+04, .1147537841797E+04},
 {   11535, .8293030273438E+04, -.1098509643555E+04, .1144327880859E+04},
 {   11536, .8273934570312E+04, -.1130790893555E+04, .1124298461914E+04},
 {   11537, .8277630859375E+04, -.1098207885742E+04, .1122643920898E+04},
 {   11538, .8258369140625E+04, -.1130790893555E+04, .1089523437500E+04},
 {   11539, .8262064453125E+04, -.1098207885742E+04, .1087869140625E+04},
 {   11540, .8242800781250E+04, -.1130790893555E+04, .1054749267578E+04},
 {   11541, .8246495117188E+04, -.1098207885742E+04, .1053095214844E+04},
 {   11542, .8224636718750E+04, -.1130791015625E+04, .1014179199219E+04},
 {   11543, .8228334960938E+04, -.1098207885742E+04, .1012524230957E+04},
 {   11544, .8206476562500E+04, -.1130791015625E+04, .9736083984375E+03},
 {   11545, .8210171875000E+04, -.1098207885742E+04, .9719542846680E+03},
 {   11546, .8200092773438E+04, -.1128391967773E+04, .9458676147461E+03},
 {   11547, .8204257812500E+04, -.1098509643555E+04, .9460247802734E+03},
 {   11548, .8314194335938E+04, -.1448425292969E+04, .1162264282227E+04},
 {   11549, .8318018554688E+04, -.1450702758789E+04, .1150647338867E+04},
 {   11550, .8321934570312E+04, -.1452563842773E+04, .1138989013672E+04},
 {   11551, .8315027343750E+04, -.1471019042969E+04, .1158548095703E+04},
 {   11552, .8318426757812E+04, -.1469682495117E+04, .1148792114258E+04},
 {   11553, .8321874023438E+04, -.1468137939453E+04, .1139015258789E+04},
 {   11554, .8318291015625E+04, -.1491239257812E+04, .1148277832031E+04},
 {   11555, .8320052734375E+04, -.1487475585938E+04, .1143660156250E+04},
 {   11556, .8321814453125E+04, -.1483712036133E+04, .1139042968750E+04},
 {   11557, .8297649414062E+04, -.1444463623047E+04, .1153540161133E+04},
 {   11558, .8307375976562E+04, -.1449117065430E+04, .1141315673828E+04},
 {   11559, .8317438476562E+04, -.1452563842773E+04, .1128942749023E+04},
 {   11560, .8299859375000E+04, -.1472313598633E+04, .1150041503906E+04},
 {   11561, .8308534179688E+04, -.1470527343750E+04, .1139542602539E+04},
 {   11562, .8317375976562E+04, -.1468137939453E+04, .1128969482422E+04},
 {   11563, .8309019531250E+04, -.1496188232422E+04, .1138816162109E+04},
 {   11564, .8313169921875E+04, -.1489950073242E+04, .1133906005859E+04},
 {   11565, .8317319335938E+04, -.1483712036133E+04, .1128996337891E+04},
 {   11566, .8283918945312E+04, -.1441495239258E+04, .1140568237305E+04},
 {   11567, .8298151367188E+04, -.1447993286133E+04, .1129856567383E+04},
 {   11568, .8312939453125E+04, -.1452563842773E+04, .1118896362305E+04},
 {   11569, .8286939453125E+04, -.1472885253906E+04, .1137745117188E+04},
 {   11570, .8299772460938E+04, -.1470993408203E+04, .1128396118164E+04},
 {   11571, .8312881835938E+04, -.1468137939453E+04, .1118923217773E+04},
 {   11572, .8300913085938E+04, -.1499238037109E+04, .1127637939453E+04},
 {   11573, .8306866210938E+04, -.1491475097656E+04, .1123294189453E+04},
 {   11574, .8312819335938E+04, -.1483712036133E+04, .1118950683594E+04},
 {   11575, .8273934570312E+04, -.1440393066406E+04, .1124298461914E+04},
 {   11576, .8290863281250E+04, -.1447585205078E+04, .1116720336914E+04},
 {   11577, .8308441406250E+04, -.1452563842773E+04, .1108850830078E+04},
 {   11578, .8277630859375E+04, -.1472976196289E+04, .1122643920898E+04},
 {   11579, .8292843750000E+04, -.1471110351562E+04, .1115833251953E+04},
 {   11580, .8308382812500E+04, -.1468137939453E+04, .1108877441406E+04},
 {   11581, .8294291015625E+04, -.1500268310547E+04, .1115186157227E+04},
 {   11582, .8301306640625E+04, -.1491990112305E+04, .1112044921875E+04},
 {   11583, .8308323242188E+04, -.1483712036133E+04, .1108904541016E+04},
 {   11584, .8263559570312E+04, -.1440393066406E+04, .1101115112305E+04},
 {   11585, .8280483398438E+04, -.1447585205078E+04, .1093537231445E+04},
 {   11586, .8298065429688E+04, -.1452563842773E+04, .1085667236328E+04},
 {   11587, .8267250976562E+04, -.1472976196289E+04, .1099461059570E+04},
 {   11588, .8282466796875E+04, -.1471110351562E+04, .1092650634766E+04},
 {   11589, .8298005859375E+04, -.1468137939453E+04, .1085694213867E+04},
 {   11590, .8283912109375E+04, -.1500268310547E+04, .1092002929688E+04},
 {   11591, .8290930664062E+04, -.1491990112305E+04, .1088862304688E+04},
 {   11592, .8297944335938E+04, -.1483712036133E+04, .1085721435547E+04},
 {   11593, .8253178710938E+04, -.1440393066406E+04, .1077932373047E+04},
 {   11594, .8270107421875E+04, -.1447585205078E+04, .1070353515625E+04},
 {   11595, .8287686523438E+04, -.1452563842773E+04, .1062484252930E+04},
 {   11596, .8256874023438E+04, -.1472976196289E+04, .1076277832031E+04},
 {   11597, .8272086914062E+04, -.1471110351562E+04, .1069467773438E+04},
 {   11598, .8287625976562E+04, -.1468137939453E+04, .1062511474609E+04},
 {   11599, .8273532226562E+04, -.1500268310547E+04, .1068820068359E+04},
 {   11600, .8280550781250E+04, -.1491990112305E+04, .1065679687500E+04},
 {   11601, .8287566406250E+04, -.1483712036133E+04, .1062538330078E+04},
 {   11602, .8242800781250E+04, -.1440393066406E+04, .1054749267578E+04},
 {   11603, .8259726562500E+04, -.1447585205078E+04, .1047171630859E+04},
 {   11604, .8277308593750E+04, -.1452563842773E+04, .1039301269531E+04},
 {   11605, .8246495117188E+04, -.1472976196289E+04, .1053095214844E+04},
 {   11606, .8261708984375E+04, -.1471110351562E+04, .1046284545898E+04},
 {   11607, .8277249023438E+04, -.1468137939453E+04, .1039328247070E+04},
 {   11608, .8263155273438E+04, -.1500268310547E+04, .1045636962891E+04},
 {   11609, .8270171875000E+04, -.1491990112305E+04, .1042495605469E+04},
 {   11610, .8277189453125E+04, -.1483712036133E+04, .1039355346680E+04},
 {   11611, .8233721679688E+04, -.1440393066406E+04, .1034463623047E+04},
 {   11612, .8250650390625E+04, -.1447585205078E+04, .1026885864258E+04},
 {   11613, .8268227539062E+04, -.1452563842773E+04, .1019016235352E+04},
 {   11614, .8237414062500E+04, -.1472976196289E+04, .1032809936523E+04},
 {   11615, .8252629882812E+04, -.1471110351562E+04, .1025998657227E+04},
 {   11616, .8268168945312E+04, -.1468137939453E+04, .1019043273926E+04},
 {   11617, .8254078125000E+04, -.1500268310547E+04, .1025351196289E+04},
 {   11618, .8261091796875E+04, -.1491990112305E+04, .1022210815430E+04},
 {   11619, .8268106445312E+04, -.1483712036133E+04, .1019070129395E+04},
 {   11620, .8224636718750E+04, -.1440393066406E+04, .1014179199219E+04},
 {   11621, .8241568359375E+04, -.1447585205078E+04, .1006600219727E+04},
 {   11622, .8259146484375E+04, -.1452563842773E+04, .9987310791016E+03},
 {   11623, .8228334960938E+04, -.1472976196289E+04, .1012524230957E+04},
 {   11624, .8243547851562E+04, -.1471110351562E+04, .1005714111328E+04},
 {   11625, .8259085937500E+04, -.1468137939453E+04, .9987578125000E+03},
 {   11626, .8244993164062E+04, -.1500268310547E+04, .1005066650391E+04},
 {   11627, .8252010742188E+04, -.1491990112305E+04, .1001925781250E+04},
 {   11628, .8259026367188E+04, -.1483712036133E+04, .9987851562500E+03},
 {   11629, .8215559570312E+04, -.1440393066406E+04, .9938931884766E+03},
 {   11630, .8232486328125E+04, -.1447585205078E+04, .9863156127930E+03},
 {   11631, .8250065429688E+04, -.1452563842773E+04, .9784459228516E+03},
 {   11632, .8219256835938E+04, -.1472976196289E+04, .9922388916016E+03},
 {   11633, .8234468750000E+04, -.1471110351562E+04, .9854283447266E+03},
 {   11634, .8250006835938E+04, -.1468137939453E+04, .9784723510742E+03},
 {   11635, .8235911132812E+04, -.1500268310547E+04, .9847814941406E+03},
 {   11636, .8242930664062E+04, -.1491990112305E+04, .9816403808594E+03},
 {   11637, .8249945312500E+04, -.1483712036133E+04, .9784997558594E+03},
 {   11638, .8206476562500E+04, -.1440393066406E+04, .9736083984375E+03},
 {   11639, .8223406250000E+04, -.1447585205078E+04, .9660299072266E+03},
 {   11640, .8240986328125E+04, -.1452563842773E+04, .9581606445312E+03},
 {   11641, .8210171875000E+04, -.1472976196289E+04, .9719542846680E+03},
 {   11642, .8225387695312E+04, -.1471110351562E+04, .9651434326172E+03},
 {   11643, .8240923828125E+04, -.1468137939453E+04, .9581879882812E+03},
 {   11644, .8226833984375E+04, -.1500268310547E+04, .9644958496094E+03},
 {   11645, .8233849609375E+04, -.1491990112305E+04, .9613551025391E+03},
 {   11646, .8240865234375E+04, -.1483712036133E+04, .9582145385742E+03},
 {   11647, .8200994140625E+04, -.1441495239258E+04, .9553243408203E+03},
 {   11648, .8218462890625E+04, -.1447993286133E+04, .9518438720703E+03},
 {   11649, .8236486328125E+04, -.1452563842773E+04, .9481146240234E+03},
 {   11650, .8205111328125E+04, -.1472885253906E+04, .9549517211914E+03},
 {   11651, .8220630859375E+04, -.1470993408203E+04, .9516088256836E+03},
 {   11652, .8236429687500E+04, -.1468137939453E+04, .9481412963867E+03},
 {   11653, .8221958007812E+04, -.1499238037109E+04, .9512622070312E+03},
 {   11654, .8229163085938E+04, -.1491475097656E+04, .9497152099609E+03},
 {   11655, .8236365234375E+04, -.1483712036133E+04, .9481689453125E+03},
 {   11656, .8200462890625E+04, -.1444463623047E+04, .9364436645508E+03},
 {   11657, .8216060546875E+04, -.1449117065430E+04, .9373301391602E+03},
 {   11658, .8231991210938E+04, -.1452563842773E+04, .9380687255859E+03},
 {   11659, .8204544921875E+04, -.1472313476562E+04, .9371250000000E+03},
 {   11660, .8218157226562E+04, -.1470527343750E+04, .9376472167969E+03},
 {   11661, .8231931640625E+04, -.1468137939453E+04, .9380955810547E+03},
 {   11662, .8219018554688E+04, -.1496188232422E+04, .9377705078125E+03},
 {   11663, .8225442382812E+04, -.1489950195312E+04, .9379465332031E+03},
 {   11664, .8231868164062E+04, -.1483712036133E+04, .9381228637695E+03},
 {   11665, .8204978515625E+04, -.1448425292969E+04, .9182907714844E+03},
 {   11666, .8216186523438E+04, -.1450702758789E+04, .9231781005859E+03},
 {   11667, .8227490234375E+04, -.1452563842773E+04, .9280230712891E+03},
 {   11668, .8208303710938E+04, -.1471019042969E+04, .9201462402344E+03},
 {   11669, .8217843750000E+04, -.1469682495117E+04, .9241086425781E+03},
 {   11670, .8227434570312E+04, -.1468137939453E+04, .9280495605469E+03},
 {   11671, .8218137695312E+04, -.1491239257812E+04, .9245528564453E+03},
 {   11672, .8222755859375E+04, -.1487475585938E+04, .9263146362305E+03},
 {   11673, .8227373046875E+04, -.1483712036133E+04, .9280765380859E+03},
 {   11674, .8340785156250E+04, -.1453642944336E+04, .1166282348633E+04},
 {   11675, .8367351562500E+04, -.1455771972656E+04, .1159951416016E+04},
 {   11676, .8339740234375E+04, -.1477600219727E+04, .1160136840820E+04},
 {   11677, .8364435546875E+04, -.1480036376953E+04, .1153436645508E+04},
 {   11678, .8338251953125E+04, -.1497959838867E+04, .1146178710938E+04},
 {   11679, .8358233398438E+04, -.1500268310547E+04, .1139582275391E+04},
 {   11680, .8338808593750E+04, -.1454382690430E+04, .1149301025391E+04},
 {   11681, .8359652343750E+04, -.1455771972656E+04, .1142751464844E+04},
 {   11682, .8338297851562E+04, -.1473508666992E+04, .1146222900391E+04},
 {   11683, .8358195312500E+04, -.1474889160156E+04, .1139493286133E+04},
 {   11684, .8337568359375E+04, -.1490835937500E+04, .1139237792969E+04},
 {   11685, .8355091796875E+04, -.1491990112305E+04, .1132566406250E+04},
 {   11686, .8336871093750E+04, -.1454968139648E+04, .1132301513672E+04},
 {   11687, .8351951171875E+04, -.1455771972656E+04, .1125551025391E+04},
 {   11688, .8336878906250E+04, -.1469340087891E+04, .1132299072266E+04},
 {   11689, .8351951171875E+04, -.1469741943359E+04, .1125551025391E+04},
 {   11690, .8336884765625E+04, -.1483712036133E+04, .1132296386719E+04},
 {   11691, .8351951171875E+04, -.1483712036133E+04, .1125551025391E+04},
 {   11692, .8332375976562E+04, -.1454968139648E+04, .1122255615234E+04},
 {   11693, .8347455078125E+04, -.1455771972656E+04, .1115504882812E+04},
 {   11694, .8332379882812E+04, -.1469340087891E+04, .1122252563477E+04},
 {   11695, .8347455078125E+04, -.1469741943359E+04, .1115504882812E+04},
 {   11696, .8332385742188E+04, -.1483712036133E+04, .1122250610352E+04},
 {   11697, .8347455078125E+04, -.1483712036133E+04, .1115504882812E+04},
 {   11698, .8327876953125E+04, -.1454968139648E+04, .1112209594727E+04},
 {   11699, .8342958984375E+04, -.1455771972656E+04, .1105459350586E+04},
 {   11700, .8327882812500E+04, -.1469340087891E+04, .1112207031250E+04},
 {   11701, .8342958984375E+04, -.1469741943359E+04, .1105459350586E+04},
 {   11702, .8327888671875E+04, -.1483712036133E+04, .1112204833984E+04},
 {   11703, .8342958984375E+04, -.1483712036133E+04, .1105459350586E+04},
 {   11704, .8323380859375E+04, -.1454968139648E+04, .1102163574219E+04},
 {   11705, .8338461914062E+04, -.1455771972656E+04, .1095413452148E+04},
 {   11706, .8323384765625E+04, -.1469340087891E+04, .1102160888672E+04},
 {   11707, .8338461914062E+04, -.1469741943359E+04, .1095413452148E+04},
 {   11708, .8323389648438E+04, -.1483712036133E+04, .1102158691406E+04},
 {   11709, .8338461914062E+04, -.1483712036133E+04, .1095413452148E+04},
 {   11710, .8313002929688E+04, -.1454968139648E+04, .1078980224609E+04},
 {   11711, .8328083007812E+04, -.1455771972656E+04, .1072229858398E+04},
 {   11712, .8313008789062E+04, -.1469340087891E+04, .1078977783203E+04},
 {   11713, .8328083007812E+04, -.1469741943359E+04, .1072229858398E+04},
 {   11714, .8313014648438E+04, -.1483712036133E+04, .1078975585938E+04},
 {   11715, .8328083007812E+04, -.1483712036133E+04, .1072229858398E+04},
 {   11716, .8302623046875E+04, -.1454968139648E+04, .1055797851562E+04},
 {   11717, .8317705078125E+04, -.1455771972656E+04, .1049046875000E+04},
 {   11718, .8302628906250E+04, -.1469340087891E+04, .1055795410156E+04},
 {   11719, .8317705078125E+04, -.1469741943359E+04, .1049046875000E+04},
 {   11720, .8302634765625E+04, -.1483712036133E+04, .1055793090820E+04},
 {   11721, .8317705078125E+04, -.1483712036133E+04, .1049046875000E+04},
 {   11722, .8292245117188E+04, -.1454968139648E+04, .1032614501953E+04},
 {   11723, .8307327148438E+04, -.1455771972656E+04, .1025863769531E+04},
 {   11724, .8292250000000E+04, -.1469340087891E+04, .1032612060547E+04},
 {   11725, .8307327148438E+04, -.1469741943359E+04, .1025863769531E+04},
 {   11726, .8292255859375E+04, -.1483712036133E+04, .1032609497070E+04},
 {   11727, .8307327148438E+04, -.1483712036133E+04, .1025863769531E+04},
 {   11728, .8283164062500E+04, -.1454968139648E+04, .1012329101562E+04},
 {   11729, .8298244140625E+04, -.1455772094727E+04, .1005578613281E+04},
 {   11730, .8283169921875E+04, -.1469340087891E+04, .1012326660156E+04},
 {   11731, .8298244140625E+04, -.1469742065430E+04, .1005578613281E+04},
 {   11732, .8283175781250E+04, -.1483712036133E+04, .1012324035645E+04},
 {   11733, .8298244140625E+04, -.1483712036133E+04, .1005578613281E+04},
 {   11734, .8274083984375E+04, -.1454968139648E+04, .9920440673828E+03},
 {   11735, .8289163085938E+04, -.1455772094727E+04, .9852933959961E+03},
 {   11736, .8274088867188E+04, -.1469340087891E+04, .9920415039062E+03},
 {   11737, .8289163085938E+04, -.1469742065430E+04, .9852933959961E+03},
 {   11738, .8274094726562E+04, -.1483712036133E+04, .9920388793945E+03},
 {   11739, .8289163085938E+04, -.1483712036133E+04, .9852933959961E+03},
 {   11740, .8265004882812E+04, -.1454968139648E+04, .9717589111328E+03},
 {   11741, .8280083984375E+04, -.1455772094727E+04, .9650081787109E+03},
 {   11742, .8265009765625E+04, -.1469340087891E+04, .9717561645508E+03},
 {   11743, .8280083984375E+04, -.1469742065430E+04, .9650081787109E+03},
 {   11744, .8265014648438E+04, -.1483712036133E+04, .9717538452148E+03},
 {   11745, .8280083984375E+04, -.1483712036133E+04, .9650081787109E+03},
 {   11746, .8255923828125E+04, -.1454968139648E+04, .9514736328125E+03},
 {   11747, .8271002929688E+04, -.1455772094727E+04, .9447231445312E+03},
 {   11748, .8255927734375E+04, -.1469340087891E+04, .9514712524414E+03},
 {   11749, .8271002929688E+04, -.1469742065430E+04, .9447231445312E+03},
 {   11750, .8255934570312E+04, -.1483712036133E+04, .9514685668945E+03},
 {   11751, .8271002929688E+04, -.1483712036133E+04, .9447231445312E+03},
 {   11752, .8251425781250E+04, -.1454968139648E+04, .9414277954102E+03},
 {   11753, .8266504882812E+04, -.1455772094727E+04, .9346771240234E+03},
 {   11754, .8251431640625E+04, -.1469340087891E+04, .9414252319336E+03},
 {   11755, .8266504882812E+04, -.1469742065430E+04, .9346771240234E+03},
 {   11756, .8251438476562E+04, -.1483712036133E+04, .9414225463867E+03},
 {   11757, .8266504882812E+04, -.1483712036133E+04, .9346771240234E+03},
 {   11758, .8246927734375E+04, -.1454968139648E+04, .9313815917969E+03},
 {   11759, .8262008789062E+04, -.1455772094727E+04, .9246307983398E+03},
 {   11760, .8246934570312E+04, -.1469340087891E+04, .9313790893555E+03},
 {   11761, .8262008789062E+04, -.1469742065430E+04, .9246307983398E+03},
 {   11762, .8246939453125E+04, -.1483712036133E+04, .9313767700195E+03},
 {   11763, .8262008789062E+04, -.1483712036133E+04, .9246307983398E+03},
 {   11764, .8242431640625E+04, -.1454968139648E+04, .9213356933594E+03},
 {   11765, .8257511718750E+04, -.1455772094727E+04, .9145848388672E+03},
 {   11766, .8242436523438E+04, -.1469340087891E+04, .9213330688477E+03},
 {   11767, .8257511718750E+04, -.1469742065430E+04, .9145848388672E+03},
 {   11768, .8242442382812E+04, -.1483712036133E+04, .9213309326172E+03},
 {   11769, .8257511718750E+04, -.1483712036133E+04, .9145848388672E+03},
 {   11770, .8231041992188E+04, -.1454382690430E+04, .9085678710938E+03},
 {   11771, .8249811523438E+04, -.1455772094727E+04, .8973844604492E+03},
 {   11772, .8232998046875E+04, -.1473508666992E+04, .9109987792969E+03},
 {   11773, .8251267578125E+04, -.1474889282227E+04, .9006420898438E+03},
 {   11774, .8237721679688E+04, -.1490835937500E+04, .9161964111328E+03},
 {   11775, .8254369140625E+04, -.1491990112305E+04, .9075689697266E+03},
 {   11776, .8219694335938E+04, -.1453643066406E+04, .8957819824219E+03},
 {   11777, .8242110351562E+04, -.1455772094727E+04, .8801839599609E+03},
 {   11778, .8223579101562E+04, -.1477600219727E+04, .9006544799805E+03},
 {   11779, .8245027343750E+04, -.1480036499023E+04, .8866992187500E+03},
 {   11780, .8233000000000E+04, -.1497959960938E+04, .9110623779297E+03},
 {   11781, .8251229492188E+04, -.1500268310547E+04, .9005531616211E+03},
 {   11782, .8331228515625E+04, -.1495278808594E+04, .1128470703125E+04},
 {   11783, .8349909179688E+04, -.1497157226562E+04, .1120988281250E+04},
 {   11784, .8330075195312E+04, -.1506845703125E+04, .1134690795898E+04},
 {   11785, .8352365234375E+04, -.1510602539062E+04, .1126471679688E+04},
 {   11786, .8324966796875E+04, -.1498083496094E+04, .1116592895508E+04},
 {   11787, .8344295898438E+04, -.1500391235352E+04, .1108448486328E+04},
 {   11788, .8322044921875E+04, -.1512454956055E+04, .1120981079102E+04},
 {   11789, .8345634765625E+04, -.1517070556641E+04, .1111438720703E+04},
 {   11790, .8319063476562E+04, -.1499031372070E+04, .1104096923828E+04},
 {   11791, .8338461914062E+04, -.1501491943359E+04, .1095413452148E+04},
 {   11792, .8314734375000E+04, -.1514350830078E+04, .1106033813477E+04},
 {   11793, .8338461914062E+04, -.1519271972656E+04, .1095413452148E+04},
 {   11794, .8308684570312E+04, -.1499031372070E+04, .1080913574219E+04},
 {   11795, .8328083007812E+04, -.1501491943359E+04, .1072229858398E+04},
 {   11796, .8304355468750E+04, -.1514350830078E+04, .1082851196289E+04},
 {   11797, .8328083007812E+04, -.1519271972656E+04, .1072229858398E+04},
 {   11798, .8298308593750E+04, -.1499031372070E+04, .1057729980469E+04},
 {   11799, .8317705078125E+04, -.1501491943359E+04, .1049046875000E+04},
 {   11800, .8293977539062E+04, -.1514350830078E+04, .1059668212891E+04},
 {   11801, .8317705078125E+04, -.1519271972656E+04, .1049046875000E+04},
 {   11802, .8287928710938E+04, -.1499031372070E+04, .1034547607422E+04},
 {   11803, .8307327148438E+04, -.1501491943359E+04, .1025863769531E+04},
 {   11804, .8283598632812E+04, -.1514350830078E+04, .1036485351562E+04},
 {   11805, .8307327148438E+04, -.1519271972656E+04, .1025863769531E+04},
 {   11806, .8278846679688E+04, -.1499031372070E+04, .1014261901855E+04},
 {   11807, .8298244140625E+04, -.1501491943359E+04, .1005578613281E+04},
 {   11808, .8274518554688E+04, -.1514350830078E+04, .1016200317383E+04},
 {   11809, .8298244140625E+04, -.1519271972656E+04, .1005578613281E+04},
 {   11810, .8269765625000E+04, -.1499031372070E+04, .9939766845703E+03},
 {   11811, .8289163085938E+04, -.1501491943359E+04, .9852933959961E+03},
 {   11812, .8265437500000E+04, -.1514350830078E+04, .9959149169922E+03},
 {   11813, .8289163085938E+04, -.1519271972656E+04, .9852933959961E+03},
 {   11814, .8260685546875E+04, -.1499031372070E+04, .9736916503906E+03},
 {   11815, .8280083984375E+04, -.1501491943359E+04, .9650081787109E+03},
 {   11816, .8256356445312E+04, -.1514350830078E+04, .9756295166016E+03},
 {   11817, .8280083984375E+04, -.1519271972656E+04, .9650081787109E+03},
 {   11818, .8251605468750E+04, -.1499031372070E+04, .9534065551758E+03},
 {   11819, .8271002929688E+04, -.1501491943359E+04, .9447231445312E+03},
 {   11820, .8247276367188E+04, -.1514350830078E+04, .9553442382812E+03},
 {   11821, .8271002929688E+04, -.1519271972656E+04, .9447231445312E+03},
 {   11822, .8246217773438E+04, -.1498083496094E+04, .9406787109375E+03},
 {   11823, .8265166992188E+04, -.1500391357422E+04, .9316870117188E+03},
 {   11824, .8240998046875E+04, -.1512455078125E+04, .9399346923828E+03},
 {   11825, .8263829101562E+04, -.1517070556641E+04, .9286972656250E+03},
 {   11826, .8241529296875E+04, -.1495278930664E+04, .9280955810547E+03},
 {   11827, .8259552734375E+04, -.1497157226562E+04, .9191470947266E+03},
 {   11828, .8236119140625E+04, -.1506845703125E+04, .9248145751953E+03},
 {   11829, .8257099609375E+04, -.1510602539062E+04, .9136635742188E+03},
 {   11830, .8389770507812E+04, -.1453642944336E+04, .1144353759766E+04},
 {   11831, .8404485351562E+04, -.1448425292969E+04, .1121844970703E+04},
 {   11832, .8385882812500E+04, -.1477600219727E+04, .1139481079102E+04},
 {   11833, .8401159179688E+04, -.1471019042969E+04, .1119989013672E+04},
 {   11834, .8376462890625E+04, -.1497959838867E+04, .1129073608398E+04},
 {   11835, .8391325195312E+04, -.1491239257812E+04, .1115582763672E+04},
 {   11836, .8378419921875E+04, -.1454382690430E+04, .1131567626953E+04},
 {   11837, .8393274414062E+04, -.1450702758789E+04, .1116958007812E+04},
 {   11838, .8376465820312E+04, -.1473508666992E+04, .1129136962891E+04},
 {   11839, .8391618164062E+04, -.1469682495117E+04, .1116026977539E+04},
 {   11840, .8371743164062E+04, -.1490835937500E+04, .1123939208984E+04},
 {   11841, .8386708984375E+04, -.1487475585938E+04, .1113820800781E+04},
 {   11842, .8367034179688E+04, -.1454968139648E+04, .1118799926758E+04},
 {   11843, .8381972656250E+04, -.1452563842773E+04, .1112112426758E+04},
 {   11844, .8367027343750E+04, -.1469340087891E+04, .1118802490234E+04},
 {   11845, .8382029296875E+04, -.1468137939453E+04, .1112086303711E+04},
 {   11846, .8367021484375E+04, -.1483712036133E+04, .1118804809570E+04},
 {   11847, .8382090820312E+04, -.1483712036133E+04, .1112058959961E+04},
 {   11848, .8362536132812E+04, -.1454968139648E+04, .1108753906250E+04},
 {   11849, .8377472656250E+04, -.1452563842773E+04, .1102066894531E+04},
 {   11850, .8362530273438E+04, -.1469340087891E+04, .1108756347656E+04},
 {   11851, .8377533203125E+04, -.1468137939453E+04, .1102039550781E+04},
 {   11852, .8362524414062E+04, -.1483712036133E+04, .1108758789062E+04},
 {   11853, .8377593750000E+04, -.1483712036133E+04, .1102013793945E+04},
 {   11854, .8358038085938E+04, -.1454968139648E+04, .1098708251953E+04},
 {   11855, .8372975585938E+04, -.1452563842773E+04, .1092020996094E+04},
 {   11856, .8358032226562E+04, -.1469340087891E+04, .1098710571289E+04},
 {   11857, .8373036132812E+04, -.1468137939453E+04, .1091994140625E+04},
 {   11858, .8358026367188E+04, -.1483712036133E+04, .1098713134766E+04},
 {   11859, .8373095703125E+04, -.1483712036133E+04, .1091967773438E+04},
 {   11860, .8353541992188E+04, -.1454968139648E+04, .1088661865234E+04},
 {   11861, .8368478515625E+04, -.1452563842773E+04, .1081974731445E+04},
 {   11862, .8353535156250E+04, -.1469340087891E+04, .1088664550781E+04},
 {   11863, .8368539062500E+04, -.1468137939453E+04, .1081948242188E+04},
 {   11864, .8353531250000E+04, -.1483712036133E+04, .1088666992188E+04},
 {   11865, .8368596679688E+04, -.1483712036133E+04, .1081921508789E+04},
 {   11866, .8343161132812E+04, -.1454968139648E+04, .1065479248047E+04},
 {   11867, .8358099609375E+04, -.1452563842773E+04, .1058792114258E+04},
 {   11868, .8343156250000E+04, -.1469340087891E+04, .1065481323242E+04},
 {   11869, .8358159179688E+04, -.1468137939453E+04, .1058765258789E+04},
 {   11870, .8343151367188E+04, -.1483712036133E+04, .1065483764648E+04},
 {   11871, .8358220703125E+04, -.1483712036133E+04, .1058738159180E+04},
 {   11872, .8332784179688E+04, -.1454968139648E+04, .1042296020508E+04},
 {   11873, .8347723632812E+04, -.1452563842773E+04, .1035608886719E+04},
 {   11874, .8332781250000E+04, -.1469340087891E+04, .1042298217773E+04},
 {   11875, .8347781250000E+04, -.1468137939453E+04, .1035582031250E+04},
 {   11876, .8332774414062E+04, -.1483712036133E+04, .1042301147461E+04},
 {   11877, .8347843750000E+04, -.1483712036133E+04, .1035555297852E+04},
 {   11878, .8322407226562E+04, -.1454968139648E+04, .1019113281250E+04},
 {   11879, .8337343750000E+04, -.1452563842773E+04, .1012425842285E+04},
 {   11880, .8322401367188E+04, -.1469340087891E+04, .1019115295410E+04},
 {   11881, .8337405273438E+04, -.1468137939453E+04, .1012398986816E+04},
 {   11882, .8322395507812E+04, -.1483712036133E+04, .1019117492676E+04},
 {   11883, .8337463867188E+04, -.1483712036133E+04, .1012372009277E+04},
 {   11884, .8313324218750E+04, -.1454968139648E+04, .9988278198242E+03},
 {   11885, .8328265625000E+04, -.1452563842773E+04, .9921403198242E+03},
 {   11886, .8313319335938E+04, -.1469340087891E+04, .9988303222656E+03},
 {   11887, .8328323242188E+04, -.1468137939453E+04, .9921138305664E+03},
 {   11888, .8313313476562E+04, -.1483712036133E+04, .9988328857422E+03},
 {   11889, .8328381835938E+04, -.1483712036133E+04, .9920869140625E+03},
 {   11890, .8304245117188E+04, -.1454968139648E+04, .9785421142578E+03},
 {   11891, .8319183593750E+04, -.1452563842773E+04, .9718551025391E+03},
 {   11892, .8304239257812E+04, -.1469340087891E+04, .9785447998047E+03},
 {   11893, .8319242187500E+04, -.1468137939453E+04, .9718286132812E+03},
 {   11894, .8304234375000E+04, -.1483712036133E+04, .9785473632812E+03},
 {   11895, .8319302734375E+04, -.1483712036133E+04, .9718016357422E+03},
 {   11896, .8295164062500E+04, -.1454968139648E+04, .9582573242188E+03},
 {   11897, .8310101562500E+04, -.1452563842773E+04, .9515703125000E+03},
 {   11898, .8295158203125E+04, -.1469340087891E+04, .9582596435547E+03},
 {   11899, .8310160156250E+04, -.1468137939453E+04, .9515432128906E+03},
 {   11900, .8295152343750E+04, -.1483712036133E+04, .9582623901367E+03},
 {   11901, .8310221679688E+04, -.1483712036133E+04, .9515164184570E+03},
 {   11902, .8286083007812E+04, -.1454968139648E+04, .9379721679688E+03},
 {   11903, .8301020507812E+04, -.1452563842773E+04, .9312851562500E+03},
 {   11904, .8286080078125E+04, -.1469340087891E+04, .9379744262695E+03},
 {   11905, .8301080078125E+04, -.1468137939453E+04, .9312581787109E+03},
 {   11906, .8286072265625E+04, -.1483712036133E+04, .9379769287109E+03},
 {   11907, .8301140625000E+04, -.1483712036133E+04, .9312313232422E+03},
 {   11908, .8281585937500E+04, -.1454968139648E+04, .9279259643555E+03},
 {   11909, .8296522460938E+04, -.1452563842773E+04, .9212391967773E+03},
 {   11910, .8281581054688E+04, -.1469340087891E+04, .9279285888672E+03},
 {   11911, .8296583007812E+04, -.1468137939453E+04, .9212121582031E+03},
 {   11912, .8281574218750E+04, -.1483712036133E+04, .9279310302734E+03},
 {   11913, .8296644531250E+04, -.1483712036133E+04, .9211851196289E+03},
 {   11914, .8277086914062E+04, -.1454968139648E+04, .9178802490234E+03},
 {   11915, .8292025390625E+04, -.1452563842773E+04, .9111931762695E+03},
 {   11916, .8277082031250E+04, -.1469340087891E+04, .9178826904297E+03},
 {   11917, .8292085937500E+04, -.1468137939453E+04, .9111661376953E+03},
 {   11918, .8277076171875E+04, -.1483712036133E+04, .9178851928711E+03},
 {   11919, .8292146484375E+04, -.1483712036133E+04, .9111390991211E+03},
 {   11920, .8272591796875E+04, -.1454968139648E+04, .9078341674805E+03},
 {   11921, .8287529296875E+04, -.1452563842773E+04, .9011470336914E+03},
 {   11922, .8272585937500E+04, -.1469340087891E+04, .9078365478516E+03},
 {   11923, .8287589843750E+04, -.1468137939453E+04, .9011201782227E+03},
 {   11924, .8272580078125E+04, -.1483712036133E+04, .9078392333984E+03},
 {   11925, .8287650390625E+04, -.1483712036133E+04, .9010930786133E+03},
 {   11926, .8270655273438E+04, -.1454382690430E+04, .8908344726562E+03},
 {   11927, .8291445312500E+04, -.1450702758789E+04, .8894880981445E+03},
 {   11928, .8271165039062E+04, -.1473508666992E+04, .8939130859375E+03},
 {   11929, .8291036132812E+04, -.1469682495117E+04, .8913433837891E+03},
 {   11930, .8271893554688E+04, -.1490835937500E+04, .9008980102539E+03},
 {   11931, .8289410156250E+04, -.1487475585938E+04, .8964758300781E+03},
 {   11932, .8268678710938E+04, -.1453643066406E+04, .8738530883789E+03},
 {   11933, .8295269531250E+04, -.1448425292969E+04, .8778710937500E+03},
 {   11934, .8269721679688E+04, -.1477600219727E+04, .8799988403320E+03},
 {   11935, .8294436523438E+04, -.1471019042969E+04, .8815880737305E+03},
 {   11936, .8271210937500E+04, -.1497959960938E+04, .8939567871094E+03},
 {   11937, .8291172851562E+04, -.1491239257812E+04, .8918577880859E+03},
 {   11938, .8367934570312E+04, -.1495278808594E+04, .1112040161133E+04},
 {   11939, .8384018554688E+04, -.1489950073242E+04, .1102189086914E+04},
 {   11940, .8373342773438E+04, -.1506845703125E+04, .1115321289062E+04},
 {   11941, .8390441406250E+04, -.1496188232422E+04, .1102365722656E+04},
 {   11942, .8363247070312E+04, -.1498083496094E+04, .1099457031250E+04},
 {   11943, .8380300781250E+04, -.1491475097656E+04, .1090420288086E+04},
 {   11944, .8368465820312E+04, -.1512454956055E+04, .1100200683594E+04},
 {   11945, .8387504882812E+04, -.1499238037109E+04, .1088873657227E+04},
 {   11946, .8357858398438E+04, -.1499031372070E+04, .1086729125977E+04},
 {   11947, .8375613281250E+04, -.1491990112305E+04, .1078780639648E+04},
 {   11948, .8362187500000E+04, -.1514350830078E+04, .1084791381836E+04},
 {   11949, .8382629882812E+04, -.1500268310547E+04, .1075640258789E+04},
 {   11950, .8347480468750E+04, -.1499031372070E+04, .1063546142578E+04},
 {   11951, .8365235351562E+04, -.1491990112305E+04, .1055597167969E+04},
 {   11952, .8351811523438E+04, -.1514350830078E+04, .1061608398438E+04},
 {   11953, .8372251953125E+04, -.1500268310547E+04, .1052456298828E+04},
 {   11954, .8337102539062E+04, -.1499031372070E+04, .1040363159180E+04},
 {   11955, .8354859375000E+04, -.1491990112305E+04, .1032414184570E+04},
 {   11956, .8341430664062E+04, -.1514350830078E+04, .1038424804688E+04},
 {   11957, .8361874023438E+04, -.1500268310547E+04, .1029273315430E+04},
 {   11958, .8326724609375E+04, -.1499031372070E+04, .1017180297852E+04},
 {   11959, .8344480468750E+04, -.1491990112305E+04, .1009231445312E+04},
 {   11960, .8331053710938E+04, -.1514350830078E+04, .1015241943359E+04},
 {   11961, .8351494140625E+04, -.1500268310547E+04, .1006090759277E+04},
 {   11962, .8317642578125E+04, -.1499031372070E+04, .9968947143555E+03},
 {   11963, .8335399414062E+04, -.1491990112305E+04, .9889459228516E+03},
 {   11964, .8321970703125E+04, -.1514350830078E+04, .9949571533203E+03},
 {   11965, .8342417968750E+04, -.1500268310547E+04, .9858045654297E+03},
 {   11966, .8308562500000E+04, -.1499031372070E+04, .9766095581055E+03},
 {   11967, .8326319335938E+04, -.1491990112305E+04, .9686606445312E+03},
 {   11968, .8312891601562E+04, -.1514350830078E+04, .9746717529297E+03},
 {   11969, .8333335937500E+04, -.1500268310547E+04, .9655201416016E+03},
 {   11970, .8299481445312E+04, -.1499031372070E+04, .9563244628906E+03},
 {   11971, .8317236328125E+04, -.1491990112305E+04, .9483758544922E+03},
 {   11972, .8303812500000E+04, -.1514350830078E+04, .9543862304688E+03},
 {   11973, .8324254882812E+04, -.1500268310547E+04, .9452346801758E+03},
 {   11974, .8290401367188E+04, -.1499031372070E+04, .9360391235352E+03},
 {   11975, .8308159179688E+04, -.1491990112305E+04, .9280902099609E+03},
 {   11976, .8294728515625E+04, -.1514350830078E+04, .9341013183594E+03},
 {   11977, .8315170898438E+04, -.1500268310547E+04, .9249499511719E+03},
 {   11978, .8284496093750E+04, -.1498083496094E+04, .9235427246094E+03},
 {   11979, .8302597656250E+04, -.1491475097656E+04, .9168414306641E+03},
 {   11980, .8287417968750E+04, -.1512455078125E+04, .9191548461914E+03},
 {   11981, .8308548828125E+04, -.1499238037109E+04, .9124978637695E+03},
 {   11982, .8278233398438E+04, -.1495278930664E+04, .9116650390625E+03},
 {   11983, .8296293945312E+04, -.1489950195312E+04, .9062297363281E+03},
 {   11984, .8279388671875E+04, -.1506845703125E+04, .9054448242188E+03},
 {   11985, .8300444335938E+04, -.1496188232422E+04, .9013197021484E+03},
 {   11986, .8393401367188E+04, -.1449117065430E+04, .1102806152344E+04},
 {   11987, .8409002929688E+04, -.1444463623047E+04, .1103692871094E+04},
 {   11988, .8391308593750E+04, -.1470527343750E+04, .1102488281250E+04},
 {   11989, .8404918945312E+04, -.1472313598633E+04, .1103010864258E+04},
 {   11990, .8391002929688E+04, -.1447993286133E+04, .1088291748047E+04},
 {   11991, .8408469726562E+04, -.1441495239258E+04, .1084811279297E+04},
 {   11992, .8388833007812E+04, -.1470993408203E+04, .1088526977539E+04},
 {   11993, .8404352539062E+04, -.1472885253906E+04, .1085183959961E+04},
 {   11994, .8386055664062E+04, -.1447585205078E+04, .1074105468750E+04},
 {   11995, .8402986328125E+04, -.1440393188477E+04, .1066527343750E+04},
 {   11996, .8384078125000E+04, -.1471110351562E+04, .1074991699219E+04},
 {   11997, .8399291015625E+04, -.1472976196289E+04, .1068181640625E+04},
 {   11998, .8375677734375E+04, -.1447585205078E+04, .1050922119141E+04},
 {   11999, .8392608398438E+04, -.1440393188477E+04, .1043344238281E+04},
 {   12000, .8373698242188E+04, -.1471110351562E+04, .1051808837891E+04},
 {   12001, .8388912109375E+04, -.1472976196289E+04, .1044998535156E+04},
 {   12002, .8365301757812E+04, -.1447585205078E+04, .1027739257812E+04},
 {   12003, .8382229492188E+04, -.1440393188477E+04, .1020161010742E+04},
 {   12004, .8363321289062E+04, -.1471110351562E+04, .1028625732422E+04},
 {   12005, .8378534179688E+04, -.1472976196289E+04, .1021815917969E+04},
 {   12006, .8354921875000E+04, -.1447585205078E+04, .1004556396484E+04},
 {   12007, .8371851562500E+04, -.1440393188477E+04, .9969778442383E+03},
 {   12008, .8352943359375E+04, -.1471110351562E+04, .1005442565918E+04},
 {   12009, .8368157226562E+04, -.1472976196289E+04, .9986320800781E+03},
 {   12010, .8345842773438E+04, -.1447585205078E+04, .9842711181641E+03},
 {   12011, .8362769531250E+04, -.1440393188477E+04, .9766927490234E+03},
 {   12012, .8343861328125E+04, -.1471110351562E+04, .9851577148438E+03},
 {   12013, .8359076171875E+04, -.1472976196289E+04, .9783474121094E+03},
 {   12014, .8336760742188E+04, -.1447585205078E+04, .9639862670898E+03},
 {   12015, .8353689453125E+04, -.1440393188477E+04, .9564077148438E+03},
 {   12016, .8334782226562E+04, -.1471110351562E+04, .9648722534180E+03},
 {   12017, .8349993164062E+04, -.1472976196289E+04, .9580620727539E+03},
 {   12018, .8327679687500E+04, -.1447585205078E+04, .9437011718750E+03},
 {   12019, .8344608398438E+04, -.1440393188477E+04, .9361225585938E+03},
 {   12020, .8325699218750E+04, -.1471110351562E+04, .9445873413086E+03},
 {   12021, .8340913085938E+04, -.1472976196289E+04, .9377768554688E+03},
 {   12022, .8318600585938E+04, -.1447585205078E+04, .9234155273438E+03},
 {   12023, .8335528320312E+04, -.1440393188477E+04, .9158373413086E+03},
 {   12024, .8316619140625E+04, -.1471110351562E+04, .9243019409180E+03},
 {   12025, .8331833984375E+04, -.1472976196289E+04, .9174913330078E+03},
 {   12026, .8311312500000E+04, -.1447993286133E+04, .9102791137695E+03},
 {   12027, .8325544921875E+04, -.1441495239258E+04, .8995677490234E+03},
 {   12028, .8309691406250E+04, -.1470993408203E+04, .9117395019531E+03},
 {   12029, .8322523437500E+04, -.1472885253906E+04, .9023908691406E+03},
 {   12030, .8302087890625E+04, -.1449117065430E+04, .8988201904297E+03},
 {   12031, .8311814453125E+04, -.1444463623047E+04, .8865954589844E+03},
 {   12032, .8300927734375E+04, -.1470527343750E+04, .9005933837891E+03},
 {   12033, .8309602539062E+04, -.1472313476562E+04, .8900944213867E+03},
 {   16336, .8426942382812E+04, -.1212568969727E+04, .1041888671875E+04},
 {   16337, .8421750976562E+04, -.1212568969727E+04, .1030297851562E+04},
 {   16338, .8416561523438E+04, -.1212568969727E+04, .1018706237793E+04},
 {   16339, .8415265625000E+04, -.1212568969727E+04, .1015808471680E+04},
 {   16340, .8410077148438E+04, -.1212568969727E+04, .1004216308594E+04},
 {   16341, .8404886718750E+04, -.1212568969727E+04, .9926251220703E+03},
 {   16342, .8403589843750E+04, -.1212568969727E+04, .9897273559570E+03},
 {   16343, .8398401367188E+04, -.1212568969727E+04, .9781357421875E+03},
 {   16344, .8393209960938E+04, -.1212568969727E+04, .9665445556641E+03},
 {   16345, .8391914062500E+04, -.1212568969727E+04, .9636463012695E+03},
 {   16346, .8386726562500E+04, -.1212568969727E+04, .9520548095703E+03},
 {   16347, .8381537109375E+04, -.1212568969727E+04, .9404631347656E+03},
 {   16348, .8380239257812E+04, -.1212568969727E+04, .9375653686523E+03},
 {   16349, .8375050781250E+04, -.1212568969727E+04, .9259735717773E+03},
 {   16350, .8369859375000E+04, -.1212568969727E+04, .9143824462891E+03},
 {   16351, .8416561523438E+04, -.1358615112305E+04, .1018706237793E+04},
 {   16352, .8421750976562E+04, -.1358615112305E+04, .1030297851562E+04},
 {   16353, .8426942382812E+04, -.1358615112305E+04, .1041888671875E+04},
 {   16354, .8404886718750E+04, -.1358615112305E+04, .9926251220703E+03},
 {   16355, .8410077148438E+04, -.1358615112305E+04, .1004216308594E+04},
 {   16356, .8415265625000E+04, -.1358615112305E+04, .1015808471680E+04},
 {   16357, .8393209960938E+04, -.1358615112305E+04, .9665445556641E+03},
 {   16358, .8398401367188E+04, -.1358615112305E+04, .9781357421875E+03},
 {   16359, .8403589843750E+04, -.1358615112305E+04, .9897273559570E+03},
 {   16360, .8381537109375E+04, -.1358615112305E+04, .9404631347656E+03},
 {   16361, .8386725585938E+04, -.1358615112305E+04, .9520546264648E+03},
 {   16362, .8391914062500E+04, -.1358615112305E+04, .9636463012695E+03},
 {   16363, .8369859375000E+04, -.1358615112305E+04, .9143824462891E+03},
 {   16364, .8375050781250E+04, -.1358615112305E+04, .9259735717773E+03},
 {   16365, .8380239257812E+04, -.1358615112305E+04, .9375653686523E+03},
 {   16366, .8403649414062E+04, -.1349092041016E+04, .1241030761719E+04},
 {   16367, .8399874023438E+04, -.1349034057617E+04, .1242720458984E+04},
 {   16368, .8396103515625E+04, -.1348872802734E+04, .1244409790039E+04},
 {   16369, .8392336914062E+04, -.1348608032227E+04, .1246094970703E+04},
 {   16370, .8388576171875E+04, -.1348239257812E+04, .1247778076172E+04},
 {   16371, .8384828125000E+04, -.1347765625000E+04, .1249457031250E+04},
 {   16372, .8381090820312E+04, -.1347183227539E+04, .1251129638672E+04},
 {   16373, .8377371093750E+04, -.1346482177734E+04, .1252793945312E+04},
 {   16374, .8373669921875E+04, -.1345672363281E+04, .1254451416016E+04},
 {   16375, .8393270507812E+04, -.1361791992188E+04, .1217848388672E+04},
 {   16376, .8388418945312E+04, -.1361676025391E+04, .1220020385742E+04},
 {   16377, .8383572265625E+04, -.1361374267578E+04, .1222188964844E+04},
 {   16378, .8378744140625E+04, -.1360839721680E+04, .1224351318359E+04},
 {   16379, .8373938476562E+04, -.1360116821289E+04, .1226503173828E+04},
 {   16380, .8369162109375E+04, -.1359160156250E+04, .1228640136719E+04},
 {   16381, .8364424804688E+04, -.1358009033203E+04, .1230760986328E+04},
 {   16382, .8359740234375E+04, -.1356624389648E+04, .1232858398438E+04},
 {   16383, .8355109375000E+04, -.1355034179688E+04, .1234931640625E+04},
 {   16384, .8388082031250E+04, -.1399891967773E+04, .1206256225586E+04},
 {   16385, .8381340820312E+04, -.1399601928711E+04, .1209274780273E+04},
 {   16386, .8374640625000E+04, -.1398739257812E+04, .1212273681641E+04},
 {   16387, .8368022460938E+04, -.1397311767578E+04, .1215237304688E+04},
 {   16388, .8361521484375E+04, -.1395332031250E+04, .1218146240234E+04},
 {   16389, .8355179687500E+04, -.1392817382812E+04, .1220986450195E+04},
 {   16390, .8349024414062E+04, -.1389788574219E+04, .1223740356445E+04},
 {   16391, .8343091796875E+04, -.1386269775391E+04, .1226396606445E+04},
 {   16392, .8337409179688E+04, -.1382287841797E+04, .1228940795898E+04},
 {   16393, .8385488281250E+04, -.1431641967773E+04, .1200460815430E+04},
 {   16394, .8377363281250E+04, -.1431091186523E+04, .1204098510742E+04},
 {   16395, .8369363281250E+04, -.1429502441406E+04, .1207679809570E+04},
 {   16396, .8361594726562E+04, -.1426941040039E+04, .1211156250000E+04},
 {   16397, .8354151367188E+04, -.1423486938477E+04, .1214488647461E+04},
 {   16398, .8347076171875E+04, -.1419267700195E+04, .1217656738281E+04},
 {   16399, .8340403320312E+04, -.1414377563477E+04, .1220643310547E+04},
 {   16400, .8334158203125E+04, -.1408899780273E+04, .1223438964844E+04},
 {   16401, .8328337890625E+04, -.1402925048828E+04, .1226044433594E+04},
 {   16402, .8382892578125E+04, -.1463391967773E+04, .1194665527344E+04},
 {   16403, .8373588867188E+04, -.1462592285156E+04, .1198830444336E+04},
 {   16404, .8364489257812E+04, -.1460312744141E+04, .1202902954102E+04},
 {   16405, .8355769531250E+04, -.1456673950195E+04, .1206806884766E+04},
 {   16406, .8347555664062E+04, -.1451819580078E+04, .1210483886719E+04},
 {   16407, .8339895507812E+04, -.1445981567383E+04, .1213914184570E+04},
 {   16408, .8332813476562E+04, -.1439320190430E+04, .1217083007812E+04},
 {   16409, .8326329101562E+04, -.1431969848633E+04, .1219987182617E+04},
 {   16410, .8320395507812E+04, -.1424076782227E+04, .1222642700195E+04},
 {   16411, .8377703125000E+04, -.1487521972656E+04, .1183073486328E+04},
 {   16412, .8368129882812E+04, -.1486679199219E+04, .1187359619141E+04},
 {   16413, .8358791992188E+04, -.1484222656250E+04, .1191539794922E+04},
 {   16414, .8349905273438E+04, -.1480249877930E+04, .1195518676758E+04},
 {   16415, .8341652343750E+04, -.1474893066406E+04, .1199212890625E+04},
 {   16416, .8334166992188E+04, -.1468351562500E+04, .1202562622070E+04},
 {   16417, .8327563476562E+04, -.1460810424805E+04, .1205519409180E+04},
 {   16418, .8321926757812E+04, -.1452462036133E+04, .1208042968750E+04},
 {   16419, .8317299804688E+04, -.1443524536133E+04, .1210113525391E+04},
 {   16420, .8372514648438E+04, -.1511651977539E+04, .1171482177734E+04},
 {   16421, .8362908203125E+04, -.1510773681641E+04, .1175782470703E+04},
 {   16422, .8353566406250E+04, -.1508163085938E+04, .1179963989258E+04},
 {   16423, .8344750976562E+04, -.1503892456055E+04, .1183910766602E+04},
 {   16424, .8336703125000E+04, -.1498079833984E+04, .1187513671875E+04},
 {   16425, .8329645507812E+04, -.1490885986328E+04, .1190672851562E+04},
 {   16426, .8323774414062E+04, -.1482510131836E+04, .1193301879883E+04},
 {   16427, .8319249023438E+04, -.1473183715820E+04, .1195327148438E+04},
 {   16428, .8316198242188E+04, -.1463165039062E+04, .1196692138672E+04},
 {   16429, .8362138671875E+04, -.1518002075195E+04, .1148298828125E+04},
 {   16430, .8350589843750E+04, -.1516849243164E+04, .1153472900391E+04},
 {   16431, .8339425781250E+04, -.1513411010742E+04, .1158475463867E+04},
 {   16432, .8329014648438E+04, -.1507801635742E+04, .1163141601562E+04},
 {   16433, .8319702148438E+04, -.1500207153320E+04, .1167314819336E+04},
 {   16434, .8311798828125E+04, -.1490880249023E+04, .1170857788086E+04},
 {   16435, .8305567382812E+04, -.1480131713867E+04, .1173652343750E+04},
 {   16436, .8301219726562E+04, -.1468321289062E+04, .1175602539062E+04},
 {   16437, .8298907226562E+04, -.1455847412109E+04, .1176642822266E+04},
 {   16438, .8351757812500E+04, -.1524352050781E+04, .1125116333008E+04},
 {   16439, .8338183593750E+04, -.1522886962891E+04, .1131192382812E+04},
 {   16440, .8325132812500E+04, -.1518547973633E+04, .1137034545898E+04},
 {   16441, .8313106445312E+04, -.1511502075195E+04, .1142418701172E+04},
 {   16442, .8302565429688E+04, -.1502020019531E+04, .1147137329102E+04},
 {   16443, .8293917968750E+04, -.1490466552734E+04, .1151008666992E+04},
 {   16444, .8287495117188E+04, -.1477285888672E+04, .1153884887695E+04},
 {   16445, .8283540039062E+04, -.1462985107422E+04, .1155654541016E+04},
 {   16446, .8282207031250E+04, -.1448114013672E+04, .1156250976562E+04},
 {   16447, .8341379882812E+04, -.1524352050781E+04, .1101933227539E+04},
 {   16448, .8327807617188E+04, -.1522886962891E+04, .1108008911133E+04},
 {   16449, .8314756835938E+04, -.1518548095703E+04, .1113851196289E+04},
 {   16450, .8302730468750E+04, -.1511502075195E+04, .1119235351562E+04},
 {   16451, .8292189453125E+04, -.1502020019531E+04, .1123953857422E+04},
 {   16452, .8283539062500E+04, -.1490466552734E+04, .1127825683594E+04},
 {   16453, .8277116210938E+04, -.1477285888672E+04, .1130701538086E+04},
 {   16454, .8273162109375E+04, -.1462985107422E+04, .1132472045898E+04},
 {   16455, .8271831054688E+04, -.1448114013672E+04, .1133067260742E+04},
 {   16456, .8331000976562E+04, -.1524352050781E+04, .1078749877930E+04},
 {   16457, .8317427734375E+04, -.1522886962891E+04, .1084826171875E+04},
 {   16458, .8304377929688E+04, -.1518548095703E+04, .1090667968750E+04},
 {   16459, .8292351562500E+04, -.1511502075195E+04, .1096052246094E+04},
 {   16460, .8281810546875E+04, -.1502020019531E+04, .1100770629883E+04},
 {   16461, .8273161132812E+04, -.1490466552734E+04, .1104642944336E+04},
 {   16462, .8266736328125E+04, -.1477285888672E+04, .1107519165039E+04},
 {   16463, .8262781250000E+04, -.1462985107422E+04, .1109289062500E+04},
 {   16464, .8261451171875E+04, -.1448114013672E+04, .1109884277344E+04},
 {   16465, .8320622070312E+04, -.1524352050781E+04, .1055566894531E+04},
 {   16466, .8307050781250E+04, -.1522886962891E+04, .1061642700195E+04},
 {   16467, .8294000000000E+04, -.1518548095703E+04, .1067485473633E+04},
 {   16468, .8281972656250E+04, -.1511502075195E+04, .1072868896484E+04},
 {   16469, .8271431640625E+04, -.1502020019531E+04, .1077587890625E+04},
 {   16470, .8262783203125E+04, -.1490466552734E+04, .1081459716797E+04},
 {   16471, .8256357421875E+04, -.1477285888672E+04, .1084336181641E+04},
 {   16472, .8252406250000E+04, -.1462985107422E+04, .1086105834961E+04},
 {   16473, .8251073242188E+04, -.1448114013672E+04, .1086701293945E+04},
 {   16474, .8310247070312E+04, -.1524352050781E+04, .1032383789062E+04},
 {   16475, .8296671875000E+04, -.1522886962891E+04, .1038459594727E+04},
 {   16476, .8283622070312E+04, -.1518548095703E+04, .1044302246094E+04},
 {   16477, .8271595703125E+04, -.1511502075195E+04, .1049686035156E+04},
 {   16478, .8261054687500E+04, -.1502020019531E+04, .1054405029297E+04},
 {   16479, .8252404296875E+04, -.1490466552734E+04, .1058276855469E+04},
 {   16480, .8245979492188E+04, -.1477285888672E+04, .1061153320312E+04},
 {   16481, .8242026367188E+04, -.1462985107422E+04, .1062922363281E+04},
 {   16482, .8240697265625E+04, -.1448114013672E+04, .1063518188477E+04},
 {   16483, .8299867187500E+04, -.1524352050781E+04, .1009200866699E+04},
 {   16484, .8286293945312E+04, -.1522886962891E+04, .1015276672363E+04},
 {   16485, .8273242187500E+04, -.1518548095703E+04, .1021119262695E+04},
 {   16486, .8261215820312E+04, -.1511502075195E+04, .1026503295898E+04},
 {   16487, .8250675781250E+04, -.1502020019531E+04, .1031221923828E+04},
 {   16488, .8242025390625E+04, -.1490466552734E+04, .1035094116211E+04},
 {   16489, .8235604492188E+04, -.1477285888672E+04, .1037969482422E+04},
 {   16490, .8231646484375E+04, -.1462985107422E+04, .1039739990234E+04},
 {   16491, .8230318359375E+04, -.1448114013672E+04, .1040335571289E+04},
 {   16492, .8289487304688E+04, -.1524352050781E+04, .9860181274414E+03},
 {   16493, .8275916992188E+04, -.1522886962891E+04, .9920937500000E+03},
 {   16494, .8262864257812E+04, -.1518547973633E+04, .9979367675781E+03},
 {   16495, .8250837890625E+04, -.1511502075195E+04, .1003319946289E+04},
 {   16496, .8240298828125E+04, -.1502020019531E+04, .1008038513184E+04},
 {   16497, .8231648437500E+04, -.1490466552734E+04, .1011910766602E+04},
 {   16498, .8225221679688E+04, -.1477285888672E+04, .1014786621094E+04},
 {   16499, .8221269531250E+04, -.1462985107422E+04, .1016556518555E+04},
 {   16500, .8219941406250E+04, -.1448114013672E+04, .1017152099609E+04},
 {   16501, .8279110351562E+04, -.1524352050781E+04, .9628347167969E+03},
 {   16502, .8265537109375E+04, -.1522886962891E+04, .9689109497070E+03},
 {   16503, .8252487304688E+04, -.1518548095703E+04, .9747531127930E+03},
 {   16504, .8240459960938E+04, -.1511502075195E+04, .9801370239258E+03},
 {   16505, .8229919921875E+04, -.1502020019531E+04, .9848557128906E+03},
 {   16506, .8221272460938E+04, -.1490466552734E+04, .9887270507812E+03},
 {   16507, .8214843750000E+04, -.1477285888672E+04, .9916040039062E+03},
 {   16508, .8210893554688E+04, -.1462985107422E+04, .9933732910156E+03},
 {   16509, .8209562500000E+04, -.1448114013672E+04, .9939687500000E+03},
 {   16510, .8268731445312E+04, -.1524352050781E+04, .9396519775391E+03},
 {   16511, .8255161132812E+04, -.1522886962891E+04, .9457275390625E+03},
 {   16512, .8242108398438E+04, -.1518547973633E+04, .9515699462891E+03},
 {   16513, .8230080078125E+04, -.1511502075195E+04, .9569539794922E+03},
 {   16514, .8219542968750E+04, -.1502020019531E+04, .9616723632812E+03},
 {   16515, .8210892578125E+04, -.1490466552734E+04, .9655445556641E+03},
 {   16516, .8204466796875E+04, -.1477285888672E+04, .9684207763672E+03},
 {   16517, .8200512695312E+04, -.1462985107422E+04, .9701904907227E+03},
 {   16518, .8199182617188E+04, -.1448114013672E+04, .9707864379883E+03},
 {   16519, .8258354492188E+04, -.1516732055664E+04, .9164686279297E+03},
 {   16520, .8245090820312E+04, -.1515174804688E+04, .9224058227539E+03},
 {   16521, .8232430664062E+04, -.1510573974609E+04, .9280736694336E+03},
 {   16522, .8220946289062E+04, -.1503138061523E+04, .9332147216797E+03},
 {   16523, .8211161132812E+04, -.1493204956055E+04, .9375949096680E+03},
 {   16524, .8203519531250E+04, -.1481225952148E+04, .9410156860352E+03},
 {   16525, .8198370117188E+04, -.1467745117188E+04, .9433214111328E+03},
 {   16526, .8195941406250E+04, -.1453374389648E+04, .9444084472656E+03},
 {   16527, .8196348632812E+04, -.1438766723633E+04, .9442260131836E+03},
 {   16528, .8247525390625E+04, -.1510950927734E+04, .8934730224609E+03},
 {   16529, .8234710937500E+04, -.1509500488281E+04, .8991841430664E+03},
 {   16530, .8222423828125E+04, -.1505248168945E+04, .9046602783203E+03},
 {   16531, .8211153320312E+04, -.1498400878906E+04, .9096829833984E+03},
 {   16532, .8201331054688E+04, -.1489273193359E+04, .9140604248047E+03},
 {   16533, .8193328125000E+04, -.1478253173828E+04, .9176269531250E+03},
 {   16534, .8187410156250E+04, -.1465832763672E+04, .9202642822266E+03},
 {   16535, .8183779785156E+04, -.1452535766602E+04, .9218817749023E+03},
 {   16536, .8182541015625E+04, -.1438944335938E+04, .9224345703125E+03},
 {   16537, .8236812500000E+04, -.1498565673828E+04, .8704295654297E+03},
 {   16538, .8224815429688E+04, -.1497269531250E+04, .8757648925781E+03},
 {   16539, .8213256835938E+04, -.1493506103516E+04, .8809052124023E+03},
 {   16540, .8202524414062E+04, -.1487477539062E+04, .8856769409180E+03},
 {   16541, .8192954101562E+04, -.1479468627930E+04, .8899342041016E+03},
 {   16542, .8184820800781E+04, -.1469793212891E+04, .8935511474609E+03},
 {   16543, .8178300781250E+04, -.1458874023438E+04, .8964507446289E+03},
 {   16544, .8173550781250E+04, -.1447117553711E+04, .8985638427734E+03},
 {   16545, .8170635742188E+04, -.1434991455078E+04, .8998594970703E+03},
 {   16546, .8225369140625E+04, -.1476274536133E+04, .8476817626953E+03},
 {   16547, .8213412109375E+04, -.1475192871094E+04, .8529566650391E+03},
 {   16548, .8201833984375E+04, -.1472091308594E+04, .8580650634766E+03},
 {   16549, .8190943847656E+04, -.1467160156250E+04, .8628696899414E+03},
 {   16550, .8180984375000E+04, -.1460645751953E+04, .8672635498047E+03},
 {   16551, .8172167480469E+04, -.1452776367188E+04, .8711541137695E+03},
 {   16552, .8164567382812E+04, -.1443887695312E+04, .8745072021484E+03},
 {   16553, .8158286132812E+04, -.1434242187500E+04, .8772778930664E+03},
 {   16554, .8153355957031E+04, -.1424149902344E+04, .8794534912109E+03},
 {   16555, .8213367187500E+04, -.1467190917969E+04, .8251593017578E+03},
 {   16556, .8201268554688E+04, -.1466250732422E+04, .8304489746094E+03},
 {   16557, .8189483886719E+04, -.1463600708008E+04, .8356022338867E+03},
 {   16558, .8178242675781E+04, -.1459435913086E+04, .8405174560547E+03},
 {   16559, .8167693847656E+04, -.1453985107422E+04, .8451309204102E+03},
 {   16560, .8157948730469E+04, -.1447409545898E+04, .8493914794922E+03},
 {   16561, .8148979492188E+04, -.1439981567383E+04, .8533133544922E+03},
 {   16562, .8140811523438E+04, -.1431828369141E+04, .8568847045898E+03},
 {   16563, .8133399414062E+04, -.1423099121094E+04, .8601256103516E+03},
 {   16564, .8362827148438E+04, -.1342605712891E+04, .1259305664062E+04},
 {   16565, .8352286132812E+04, -.1338455322266E+04, .1264023803711E+04},
 {   16566, .8342193359375E+04, -.1333136230469E+04, .1268542480469E+04},
 {   16567, .8332759765625E+04, -.1326525268555E+04, .1272766357422E+04},
 {   16568, .8324321289062E+04, -.1318458618164E+04, .1276543701172E+04},
 {   16569, .8317365234375E+04, -.1308839721680E+04, .1279657226562E+04},
 {   16570, .8312635742188E+04, -.1297716918945E+04, .1281773559570E+04},
 {   16571, .8310916992188E+04, -.1285592041016E+04, .1282543823242E+04},
 {   16572, .8312635742188E+04, -.1273467163086E+04, .1281773559570E+04},
 {   16573, .8317365234375E+04, -.1262344238281E+04, .1279657226562E+04},
 {   16574, .8324321289062E+04, -.1252725463867E+04, .1276543701172E+04},
 {   16575, .8332759765625E+04, -.1244658813477E+04, .1272766357422E+04},
 {   16576, .8342194335938E+04, -.1238047729492E+04, .1268542358398E+04},
 {   16577, .8352286132812E+04, -.1232728759766E+04, .1264023803711E+04},
 {   16578, .8362827148438E+04, -.1228578369141E+04, .1259305664062E+04},
 {   16579, .8373669921875E+04, -.1225511718750E+04, .1254451416016E+04},
 {   16580, .8344752929688E+04, -.1350520507812E+04, .1239568115234E+04},
 {   16581, .8334907226562E+04, -.1344792602539E+04, .1243975585938E+04},
 {   16582, .8325758789062E+04, -.1337815673828E+04, .1248070800781E+04},
 {   16583, .8317546875000E+04, -.1329558227539E+04, .1251746459961E+04},
 {   16584, .8310569335938E+04, -.1320036010742E+04, .1254871093750E+04},
 {   16585, .8305166015625E+04, -.1309353393555E+04, .1257289062500E+04},
 {   16586, .8301735351562E+04, -.1297733520508E+04, .1258824218750E+04},
 {   16587, .8300538085938E+04, -.1285592041016E+04, .1259360839844E+04},
 {   16588, .8301735351562E+04, -.1273450439453E+04, .1258824218750E+04},
 {   16589, .8305166015625E+04, -.1261830688477E+04, .1257289062500E+04},
 {   16590, .8310569335938E+04, -.1251148071289E+04, .1254871093750E+04},
 {   16591, .8317546875000E+04, -.1241625854492E+04, .1251746459961E+04},
 {   16592, .8325758789062E+04, -.1233368408203E+04, .1248070800781E+04},
 {   16593, .8334907226562E+04, -.1226391357422E+04, .1243975585938E+04},
 {   16594, .8344752929688E+04, -.1220663574219E+04, .1239568115234E+04},
 {   16595, .8355109375000E+04, -.1216149780273E+04, .1234931640625E+04},
 {   16596, .8327375976562E+04, -.1373532470703E+04, .1233432861328E+04},
 {   16597, .8318479492188E+04, -.1363407958984E+04, .1237414428711E+04},
 {   16598, .8310815429688E+04, -.1352140014648E+04, .1240846191406E+04},
 {   16599, .8304464843750E+04, -.1339926757812E+04, .1243687500000E+04},
 {   16600, .8299493164062E+04, -.1326972534180E+04, .1245914062500E+04},
 {   16601, .8295905273438E+04, -.1313479248047E+04, .1247519409180E+04},
 {   16602, .8293766601562E+04, -.1299622924805E+04, .1248478759766E+04},
 {   16603, .8293029296875E+04, -.1285592041016E+04, .1248807006836E+04},
 {   16604, .8293766601562E+04, -.1271561157227E+04, .1248478759766E+04},
 {   16605, .8295905273438E+04, -.1257704711914E+04, .1247519409180E+04},
 {   16606, .8299493164062E+04, -.1244211425781E+04, .1245914062500E+04},
 {   16607, .8304464843750E+04, -.1231257324219E+04, .1243687500000E+04},
 {   16608, .8310815429688E+04, -.1219043945312E+04, .1240846191406E+04},
 {   16609, .8318479492188E+04, -.1207776123047E+04, .1237414428711E+04},
 {   16610, .8327375976562E+04, -.1197651489258E+04, .1233432861328E+04},
 {   16611, .8337409179688E+04, -.1188896240234E+04, .1228940795898E+04},
 {   16612, .8318628906250E+04, -.1390868774414E+04, .1230390502930E+04},
 {   16613, .8310359375000E+04, -.1377655639648E+04, .1234093261719E+04},
 {   16614, .8303456054688E+04, -.1363562011719E+04, .1237183837891E+04},
 {   16615, .8297883789062E+04, -.1348774902344E+04, .1239677978516E+04},
 {   16616, .8293596679688E+04, -.1333450683594E+04, .1241596923828E+04},
 {   16617, .8290546875000E+04, -.1317728271484E+04, .1242961669922E+04},
 {   16618, .8288732421875E+04, -.1301729614258E+04, .1243774169922E+04},
 {   16619, .8288116210938E+04, -.1285592041016E+04, .1244049804688E+04},
 {   16620, .8288732421875E+04, -.1269454467773E+04, .1243774169922E+04},
 {   16621, .8290546875000E+04, -.1253455810547E+04, .1242961669922E+04},
 {   16622, .8293596679688E+04, -.1237733398438E+04, .1241596923828E+04},
 {   16623, .8297883789062E+04, -.1222409179688E+04, .1239677978516E+04},
 {   16624, .8303456054688E+04, -.1207622070312E+04, .1237183837891E+04},
 {   16625, .8310359375000E+04, -.1193528442383E+04, .1234093261719E+04},
 {   16626, .8318628906250E+04, -.1180315307617E+04, .1230390502930E+04},
 {   16627, .8328337890625E+04, -.1168259033203E+04, .1226044433594E+04},
 {   16628, .8311053710938E+04, -.1408854125977E+04, .1226824951172E+04},
 {   16629, .8303297851562E+04, -.1392597290039E+04, .1230296508789E+04},
 {   16630, .8296944335938E+04, -.1375627197266E+04, .1233141235352E+04},
 {   16631, .8291883789062E+04, -.1358141601562E+04, .1235406616211E+04},
 {   16632, .8288041015625E+04, -.1340287963867E+04, .1237125732422E+04},
 {   16633, .8285341796875E+04, -.1322184814453E+04, .1238334594727E+04},
 {   16634, .8283736328125E+04, -.1303925903320E+04, .1239052734375E+04},
 {   16635, .8283205078125E+04, -.1285592041016E+04, .1239291748047E+04},
 {   16636, .8283736328125E+04, -.1267258300781E+04, .1239052734375E+04},
 {   16637, .8285341796875E+04, -.1248999389648E+04, .1238334594727E+04},
 {   16638, .8288041015625E+04, -.1230896240234E+04, .1237125732422E+04},
 {   16639, .8291883789062E+04, -.1213042602539E+04, .1235406616211E+04},
 {   16640, .8296944335938E+04, -.1195556884766E+04, .1233141235352E+04},
 {   16641, .8303297851562E+04, -.1178586791992E+04, .1230296508789E+04},
 {   16642, .8311053710938E+04, -.1162330078125E+04, .1226824951172E+04},
 {   16643, .8320395507812E+04, -.1147107299805E+04, .1222642700195E+04},
 {   16644, .8305195312500E+04, -.1426956542969E+04, .1215532958984E+04},
 {   16645, .8295216796875E+04, -.1408743408203E+04, .1219999877930E+04},
 {   16646, .8287119140625E+04, -.1389437500000E+04, .1223624755859E+04},
 {   16647, .8280729492188E+04, -.1369380737305E+04, .1226485839844E+04},
 {   16648, .8275918945312E+04, -.1348808349609E+04, .1228639282227E+04},
 {   16649, .8272547851562E+04, -.1327903930664E+04, .1230146606445E+04},
 {   16650, .8270568359375E+04, -.1306795288086E+04, .1231034057617E+04},
 {   16651, .8269901367188E+04, -.1285592041016E+04, .1231332031250E+04},
 {   16652, .8270568359375E+04, -.1264388916016E+04, .1231034057617E+04},
 {   16653, .8272547851562E+04, -.1243280151367E+04, .1230146606445E+04},
 {   16654, .8275918945312E+04, -.1222375732422E+04, .1228639282227E+04},
 {   16655, .8280729492188E+04, -.1201803344727E+04, .1226485839844E+04},
 {   16656, .8287119140625E+04, -.1181746582031E+04, .1223624755859E+04},
 {   16657, .8295216796875E+04, -.1162440673828E+04, .1219999877930E+04},
 {   16658, .8305195312500E+04, -.1144227661133E+04, .1215532958984E+04},
 {   16659, .8317299804688E+04, -.1127659423828E+04, .1210113525391E+04},
 {   16660, .8300989257812E+04, -.1445488037109E+04, .1203501464844E+04},
 {   16661, .8288444335938E+04, -.1425455444336E+04, .1209116577148E+04},
 {   16662, .8278270507812E+04, -.1403868652344E+04, .1213670898438E+04},
 {   16663, .8270243164062E+04, -.1381224243164E+04, .1217266113281E+04},
 {   16664, .8264192382812E+04, -.1357851196289E+04, .1219973510742E+04},
 {   16665, .8259946289062E+04, -.1334007568359E+04, .1221875122070E+04},
 {   16666, .8257447265625E+04, -.1309868286133E+04, .1222993774414E+04},
 {   16667, .8256601562500E+04, -.1285592041016E+04, .1223373046875E+04},
 {   16668, .8257447265625E+04, -.1261315795898E+04, .1222993774414E+04},
 {   16669, .8259946289062E+04, -.1237176391602E+04, .1221875122070E+04},
 {   16670, .8264192382812E+04, -.1213332763672E+04, .1219973510742E+04},
 {   16671, .8270243164062E+04, -.1189959838867E+04, .1217266113281E+04},
 {   16672, .8278270507812E+04, -.1167315429688E+04, .1213670898438E+04},
 {   16673, .8288444335938E+04, -.1145728515625E+04, .1209116577148E+04},
 {   16674, .8300989257812E+04, -.1125695922852E+04, .1203501464844E+04},
 {   16675, .8316198242188E+04, -.1108019042969E+04, .1196692138672E+04},
 {   16676, .8285581054688E+04, -.1438115478516E+04, .1182607910156E+04},
 {   16677, .8274536132812E+04, -.1418594726562E+04, .1187552001953E+04},
 {   16678, .8265543945312E+04, -.1397847534180E+04, .1191578613281E+04},
 {   16679, .8258422851562E+04, -.1376238159180E+04, .1194765991211E+04},
 {   16680, .8253017578125E+04, -.1354037841797E+04, .1197185791016E+04},
 {   16681, .8249241210938E+04, -.1331429199219E+04, .1198876342773E+04},
 {   16682, .8246992187500E+04, -.1308571289062E+04, .1199883789062E+04},
 {   16683, .8246233398438E+04, -.1285592041016E+04, .1200222290039E+04},
 {   16684, .8246992187500E+04, -.1262612670898E+04, .1199883789062E+04},
 {   16685, .8249241210938E+04, -.1239754882812E+04, .1198876342773E+04},
 {   16686, .8253017578125E+04, -.1217146240234E+04, .1197185791016E+04},
 {   16687, .8258422851562E+04, -.1194945800781E+04, .1194765991211E+04},
 {   16688, .8265543945312E+04, -.1173336547852E+04, .1191578613281E+04},
 {   16689, .8274537109375E+04, -.1152589355469E+04, .1187552368164E+04},
 {   16690, .8285581054688E+04, -.1133068603516E+04, .1182607910156E+04},
 {   16691, .8298907226562E+04, -.1115336669922E+04, .1176642822266E+04},
 {   16692, .8270563476562E+04, -.1430581542969E+04, .1161463989258E+04},
 {   16693, .8260870117188E+04, -.1411676757812E+04, .1165803222656E+04},
 {   16694, .8252953125000E+04, -.1391803222656E+04, .1169347290039E+04},
 {   16695, .8246663085938E+04, -.1371243652344E+04, .1172162719727E+04},
 {   16696, .8241872070312E+04, -.1350204345703E+04, .1174307373047E+04},
 {   16697, .8238505859375E+04, -.1328836547852E+04, .1175814453125E+04},
 {   16698, .8236509765625E+04, -.1307263549805E+04, .1176708984375E+04},
 {   16699, .8235843750000E+04, -.1285592041016E+04, .1177006713867E+04},
 {   16700, .8236509765625E+04, -.1263920410156E+04, .1176708984375E+04},
 {   16701, .8238505859375E+04, -.1242347534180E+04, .1175814453125E+04},
 {   16702, .8241872070312E+04, -.1220979736328E+04, .1174307373047E+04},
 {   16703, .8246663085938E+04, -.1199940307617E+04, .1172162719727E+04},
 {   16704, .8252953125000E+04, -.1179380859375E+04, .1169347290039E+04},
 {   16705, .8260870117188E+04, -.1159507202148E+04, .1165803222656E+04},
 {   16706, .8270563476562E+04, -.1140602539062E+04, .1161463989258E+04},
 {   16707, .8282207031250E+04, -.1123070068359E+04, .1156250976562E+04},
 {   16708, .8260184570312E+04, -.1430581542969E+04, .1138280883789E+04},
 {   16709, .8250491210938E+04, -.1411676757812E+04, .1142620361328E+04},
 {   16710, .8242574218750E+04, -.1391803222656E+04, .1146164794922E+04},
 {   16711, .8236288085938E+04, -.1371243652344E+04, .1148979736328E+04},
 {   16712, .8231496093750E+04, -.1350204345703E+04, .1151124267578E+04},
 {   16713, .8228128906250E+04, -.1328836547852E+04, .1152630493164E+04},
 {   16714, .8226129882812E+04, -.1307263549805E+04, .1153525878906E+04},
 {   16715, .8225464843750E+04, -.1285592041016E+04, .1153824340820E+04},
 {   16716, .8226129882812E+04, -.1263920410156E+04, .1153525878906E+04},
 {   16717, .8228128906250E+04, -.1242347534180E+04, .1152630493164E+04},
 {   16718, .8231496093750E+04, -.1220979736328E+04, .1151124267578E+04},
 {   16719, .8236288085938E+04, -.1199940307617E+04, .1148979736328E+04},
 {   16720, .8242574218750E+04, -.1179380859375E+04, .1146164550781E+04},
 {   16721, .8250491210938E+04, -.1159507202148E+04, .1142620117188E+04},
 {   16722, .8260184570312E+04, -.1140602539062E+04, .1138280883789E+04},
 {   16723, .8271831054688E+04, -.1123070068359E+04, .1133067260742E+04},
 {   16724, .8249805664062E+04, -.1430581542969E+04, .1115098266602E+04},
 {   16725, .8240113281250E+04, -.1411676757812E+04, .1119437011719E+04},
 {   16726, .8232195312500E+04, -.1391803222656E+04, .1122981689453E+04},
 {   16727, .8225906250000E+04, -.1371243652344E+04, .1125797241211E+04},
 {   16728, .8221117187500E+04, -.1350204345703E+04, .1127940917969E+04},
 {   16729, .8217748046875E+04, -.1328836547852E+04, .1129448608398E+04},
 {   16730, .8215751953125E+04, -.1307263549805E+04, .1130343017578E+04},
 {   16731, .8215087890625E+04, -.1285592041016E+04, .1130640869141E+04},
 {   16732, .8215751953125E+04, -.1263920410156E+04, .1130343017578E+04},
 {   16733, .8217748046875E+04, -.1242347534180E+04, .1129448608398E+04},
 {   16734, .8221117187500E+04, -.1220979736328E+04, .1127940917969E+04},
 {   16735, .8225906250000E+04, -.1199940307617E+04, .1125797241211E+04},
 {   16736, .8232195312500E+04, -.1179380859375E+04, .1122981689453E+04},
 {   16737, .8240113281250E+04, -.1159507202148E+04, .1119437011719E+04},
 {   16738, .8249805664062E+04, -.1140602539062E+04, .1115098266602E+04},
 {   16739, .8261451171875E+04, -.1123070068359E+04, .1109884277344E+04},
 {   16740, .8239429687500E+04, -.1430581542969E+04, .1091914794922E+04},
 {   16741, .8229736328125E+04, -.1411676757812E+04, .1096253906250E+04},
 {   16742, .8221820312500E+04, -.1391803222656E+04, .1099797851562E+04},
 {   16743, .8215526367188E+04, -.1371243652344E+04, .1102614013672E+04},
 {   16744, .8210739257812E+04, -.1350204345703E+04, .1104758300781E+04},
 {   16745, .8207372070312E+04, -.1328836547852E+04, .1106264892578E+04},
 {   16746, .8205371093750E+04, -.1307263549805E+04, .1107160644531E+04},
 {   16747, .8204708007812E+04, -.1285592041016E+04, .1107457763672E+04},
 {   16748, .8205371093750E+04, -.1263920410156E+04, .1107160400391E+04},
 {   16749, .8207372070312E+04, -.1242347534180E+04, .1106264892578E+04},
 {   16750, .8210739257812E+04, -.1220979736328E+04, .1104758300781E+04},
 {   16751, .8215526367188E+04, -.1199940307617E+04, .1102614013672E+04},
 {   16752, .8221820312500E+04, -.1179380859375E+04, .1099797851562E+04},
 {   16753, .8229736328125E+04, -.1159507202148E+04, .1096253906250E+04},
 {   16754, .8239429687500E+04, -.1140602539062E+04, .1091914550781E+04},
 {   16755, .8251073242188E+04, -.1123070068359E+04, .1086701293945E+04},
 {   16756, .8229050781250E+04, -.1430581542969E+04, .1068731933594E+04},
 {   16757, .8219357421875E+04, -.1411676757812E+04, .1073071044922E+04},
 {   16758, .8211438476562E+04, -.1391803222656E+04, .1076614990234E+04},
 {   16759, .8205150390625E+04, -.1371243652344E+04, .1079430908203E+04},
 {   16760, .8200360351562E+04, -.1350204345703E+04, .1081574829102E+04},
 {   16761, .8196994140625E+04, -.1328836547852E+04, .1083081787109E+04},
 {   16762, .8194996093750E+04, -.1307263549805E+04, .1083976440430E+04},
 {   16763, .8194328125000E+04, -.1285592041016E+04, .1084275146484E+04},
 {   16764, .8194996093750E+04, -.1263920410156E+04, .1083976440430E+04},
 {   16765, .8196994140625E+04, -.1242347534180E+04, .1083081787109E+04},
 {   16766, .8200360351562E+04, -.1220979736328E+04, .1081574829102E+04},
 {   16767, .8205150390625E+04, -.1199940429688E+04, .1079430908203E+04},
 {   16768, .8211438476562E+04, -.1179380859375E+04, .1076614990234E+04},
 {   16769, .8219357421875E+04, -.1159507202148E+04, .1073070800781E+04},
 {   16770, .8229050781250E+04, -.1140602539062E+04, .1068731689453E+04},
 {   16771, .8240697265625E+04, -.1123070068359E+04, .1063518188477E+04},
 {   16772, .8218670898438E+04, -.1430581542969E+04, .1045548706055E+04},
 {   16773, .8208978515625E+04, -.1411676879883E+04, .1049888183594E+04},
 {   16774, .8201061523438E+04, -.1391803222656E+04, .1053432250977E+04},
 {   16775, .8194773437500E+04, -.1371243652344E+04, .1056247802734E+04},
 {   16776, .8189979980469E+04, -.1350204345703E+04, .1058391845703E+04},
 {   16777, .8186616210938E+04, -.1328836547852E+04, .1059898925781E+04},
 {   16778, .8184617187500E+04, -.1307263549805E+04, .1060793823242E+04},
 {   16779, .8183954101562E+04, -.1285592041016E+04, .1061091064453E+04},
 {   16780, .8184617187500E+04, -.1263920410156E+04, .1060793823242E+04},
 {   16781, .8186616210938E+04, -.1242347534180E+04, .1059898925781E+04},
 {   16782, .8189979980469E+04, -.1220979736328E+04, .1058391845703E+04},
 {   16783, .8194773437500E+04, -.1199940429688E+04, .1056247802734E+04},
 {   16784, .8201061523438E+04, -.1179380859375E+04, .1053432250977E+04},
 {   16785, .8208978515625E+04, -.1159507202148E+04, .1049888183594E+04},
 {   16786, .8218670898438E+04, -.1140602539062E+04, .1045548461914E+04},
 {   16787, .8230318359375E+04, -.1123070068359E+04, .1040335571289E+04},
 {   16788, .8208292968750E+04, -.1430581542969E+04, .1022365722656E+04},
 {   16789, .8198600585938E+04, -.1411676879883E+04, .1026704956055E+04},
 {   16790, .8190685058594E+04, -.1391803222656E+04, .1030248779297E+04},
 {   16791, .8184394042969E+04, -.1371243652344E+04, .1033064697266E+04},
 {   16792, .8179604003906E+04, -.1350204345703E+04, .1035208740234E+04},
 {   16793, .8176237792969E+04, -.1328836547852E+04, .1036715942383E+04},
 {   16794, .8174237792969E+04, -.1307263549805E+04, .1037610595703E+04},
 {   16795, .8173574707031E+04, -.1285592041016E+04, .1037908203125E+04},
 {   16796, .8174237792969E+04, -.1263920410156E+04, .1037610595703E+04},
 {   16797, .8176237792969E+04, -.1242347534180E+04, .1036715942383E+04},
 {   16798, .8179604003906E+04, -.1220979736328E+04, .1035208740234E+04},
 {   16799, .8184394042969E+04, -.1199940429688E+04, .1033064697266E+04},
 {   16800, .8190685058594E+04, -.1179380859375E+04, .1030248535156E+04},
 {   16801, .8198600585938E+04, -.1159507202148E+04, .1026704711914E+04},
 {   16802, .8208292968750E+04, -.1140602539062E+04, .1022365722656E+04},
 {   16803, .8219941406250E+04, -.1123070068359E+04, .1017152099609E+04},
 {   16804, .8197916015625E+04, -.1430581542969E+04, .9991823730469E+03},
 {   16805, .8188223632812E+04, -.1411676879883E+04, .1003521850586E+04},
 {   16806, .8180305175781E+04, -.1391803222656E+04, .1007065979004E+04},
 {   16807, .8174017089844E+04, -.1371243652344E+04, .1009881713867E+04},
 {   16808, .8169226074219E+04, -.1350204345703E+04, .1012025878906E+04},
 {   16809, .8165860839844E+04, -.1328836547852E+04, .1013532958984E+04},
 {   16810, .8163860351562E+04, -.1307263549805E+04, .1014428100586E+04},
 {   16811, .8163196777344E+04, -.1285592041016E+04, .1014725463867E+04},
 {   16812, .8163860351562E+04, -.1263920410156E+04, .1014428100586E+04},
 {   16813, .8165860839844E+04, -.1242347534180E+04, .1013532958984E+04},
 {   16814, .8169226074219E+04, -.1220979736328E+04, .1012025878906E+04},
 {   16815, .8174017089844E+04, -.1199940429688E+04, .1009881713867E+04},
 {   16816, .8180305175781E+04, -.1179380859375E+04, .1007065979004E+04},
 {   16817, .8188223632812E+04, -.1159507202148E+04, .1003521850586E+04},
 {   16818, .8197916015625E+04, -.1140602539062E+04, .9991823730469E+03},
 {   16819, .8209562500000E+04, -.1123070068359E+04, .9939687500000E+03},
 {   16820, .8187537597656E+04, -.1430581542969E+04, .9759996337891E+03},
 {   16821, .8177844726562E+04, -.1411676879883E+04, .9803388671875E+03},
 {   16822, .8169928710938E+04, -.1391803222656E+04, .9838826904297E+03},
 {   16823, .8163638183594E+04, -.1371243652344E+04, .9866986083984E+03},
 {   16824, .8158847656250E+04, -.1350204345703E+04, .9888427124023E+03},
 {   16825, .8155478515625E+04, -.1328836547852E+04, .9903501586914E+03},
 {   16826, .8153480957031E+04, -.1307263549805E+04, .9912449340820E+03},
 {   16827, .8152817871094E+04, -.1285592041016E+04, .9915422363281E+03},
 {   16828, .8153480957031E+04, -.1263920410156E+04, .9912449340820E+03},
 {   16829, .8155478515625E+04, -.1242347534180E+04, .9903501586914E+03},
 {   16830, .8158847656250E+04, -.1220979736328E+04, .9888427124023E+03},
 {   16831, .8163638183594E+04, -.1199940429688E+04, .9866986083984E+03},
 {   16832, .8169928710938E+04, -.1179380859375E+04, .9838826904297E+03},
 {   16833, .8177844726562E+04, -.1159507202148E+04, .9803388671875E+03},
 {   16834, .8187537597656E+04, -.1140602539062E+04, .9759996337891E+03},
 {   16835, .8199182617188E+04, -.1123070068359E+04, .9707864379883E+03},
 {   16836, .8185619140625E+04, -.1422139892578E+04, .9490296020508E+03},
 {   16837, .8176752929688E+04, -.1404242919922E+04, .9529985351562E+03},
 {   16838, .8169532714844E+04, -.1385478637695E+04, .9562304077148E+03},
 {   16839, .8163822753906E+04, -.1366100341797E+04, .9587869873047E+03},
 {   16840, .8159481933594E+04, -.1346299682617E+04, .9607293701172E+03},
 {   16841, .8156437500000E+04, -.1326211547852E+04, .9620924072266E+03},
 {   16842, .8154632324219E+04, -.1305944702148E+04, .9629011840820E+03},
 {   16843, .8154030761719E+04, -.1285592041016E+04, .9631704101562E+03},
 {   16844, .8154632324219E+04, -.1265239379883E+04, .9629011840820E+03},
 {   16845, .8156437500000E+04, -.1244972534180E+04, .9620924072266E+03},
 {   16846, .8159481933594E+04, -.1224884399414E+04, .9607293701172E+03},
 {   16847, .8163822753906E+04, -.1205083740234E+04, .9587869873047E+03},
 {   16848, .8169532714844E+04, -.1185705444336E+04, .9562304077148E+03},
 {   16849, .8176752929688E+04, -.1166941162109E+04, .9529985351562E+03},
 {   16850, .8185619140625E+04, -.1149044189453E+04, .9490296020508E+03},
 {   16851, .8196348632812E+04, -.1132417358398E+04, .9442260131836E+03},
 {   16852, .8172026367188E+04, -.1422170898438E+04, .9271206665039E+03},
 {   16853, .8163328125000E+04, -.1404191772461E+04, .9309960937500E+03},
 {   16854, .8156252441406E+04, -.1385384643555E+04, .9341506958008E+03},
 {   16855, .8150651855469E+04, -.1365993408203E+04, .9366464233398E+03},
 {   16856, .8146402832031E+04, -.1346200561523E+04, .9385404052734E+03},
 {   16857, .8143423339844E+04, -.1326136230469E+04, .9398682250977E+03},
 {   16858, .8141656738281E+04, -.1305904174805E+04, .9406552734375E+03},
 {   16859, .8141066406250E+04, -.1285592041016E+04, .9409178466797E+03},
 {   16860, .8141657714844E+04, -.1265279907227E+04, .9406551513672E+03},
 {   16861, .8143423339844E+04, -.1245047851562E+04, .9398682250977E+03},
 {   16862, .8146402832031E+04, -.1224983520508E+04, .9385402832031E+03},
 {   16863, .8150651855469E+04, -.1205190673828E+04, .9366464233398E+03},
 {   16864, .8156252441406E+04, -.1185799438477E+04, .9341505737305E+03},
 {   16865, .8163328125000E+04, -.1166992309570E+04, .9309960937500E+03},
 {   16866, .8172026367188E+04, -.1149013183594E+04, .9271206665039E+03},
 {   16867, .8182541015625E+04, -.1132239746094E+04, .9224345703125E+03},
 {   16868, .8160607421875E+04, -.1418537109375E+04, .9043188476562E+03},
 {   16869, .8152301269531E+04, -.1400971801758E+04, .9080126953125E+03},
 {   16870, .8145535644531E+04, -.1382636474609E+04, .9110222167969E+03},
 {   16871, .8140174316406E+04, -.1363757812500E+04, .9134057006836E+03},
 {   16872, .8136107910156E+04, -.1344503540039E+04, .9152145996094E+03},
 {   16873, .8133255371094E+04, -.1324995605469E+04, .9164830322266E+03},
 {   16874, .8131563964844E+04, -.1305331298828E+04, .9172351684570E+03},
 {   16875, .8131000000000E+04, -.1285592041016E+04, .9174860229492E+03},
 {   16876, .8131563964844E+04, -.1265852783203E+04, .9172351684570E+03},
 {   16877, .8133255371094E+04, -.1246188354492E+04, .9164830322266E+03},
 {   16878, .8136107910156E+04, -.1226680541992E+04, .9152145996094E+03},
 {   16879, .8140174316406E+04, -.1207426147461E+04, .9134057006836E+03},
 {   16880, .8145535644531E+04, -.1188547607422E+04, .9110222167969E+03},
 {   16881, .8152301269531E+04, -.1170212280273E+04, .9080125732422E+03},
 {   16882, .8160607421875E+04, -.1152646972656E+04, .9043188476562E+03},
 {   16883, .8170635742188E+04, -.1136192626953E+04, .8998594970703E+03},
 {   16884, .8145441894531E+04, -.1408795410156E+04, .8829306030273E+03},
 {   16885, .8141574218750E+04, -.1392469482422E+04, .8846057128906E+03},
 {   16886, .8134637695312E+04, -.1375460449219E+04, .8876669921875E+03},
 {   16887, .8131445800781E+04, -.1357967285156E+04, .8890603637695E+03},
 {   16888, .8129576171875E+04, -.1340134887695E+04, .8898704833984E+03},
 {   16889, .8126636230469E+04, -.1322072021484E+04, .8911676635742E+03},
 {   16890, .8124887207031E+04, -.1303866333008E+04, .8919382934570E+03},
 {   16891, .8124305175781E+04, -.1285592041016E+04, .8921954956055E+03},
 {   16892, .8124887207031E+04, -.1267317749023E+04, .8919382934570E+03},
 {   16893, .8126636230469E+04, -.1249112060547E+04, .8911676635742E+03},
 {   16894, .8129576171875E+04, -.1231049194336E+04, .8898704833984E+03},
 {   16895, .8131445800781E+04, -.1213216796875E+04, .8890603637695E+03},
 {   16896, .8134637695312E+04, -.1195723510742E+04, .8876669921875E+03},
 {   16897, .8141575195312E+04, -.1178714599609E+04, .8846058959961E+03},
 {   16898, .8145441894531E+04, -.1162388671875E+04, .8829304809570E+03},
 {   16899, .8153355957031E+04, -.1147034179688E+04, .8794533691406E+03},
 {   16900, .8129678710938E+04, -.1407779785156E+04, .8616801757812E+03},
 {   16901, .8125414550781E+04, -.1391554565430E+04, .8634978027344E+03},
 {   16902, .8122756347656E+04, -.1374679199219E+04, .8646111450195E+03},
 {   16903, .8119261230469E+04, -.1357337890625E+04, .8661159057617E+03},
 {   16904, .8117145019531E+04, -.1339663085938E+04, .8670166625977E+03},
 {   16905, .8114023925781E+04, -.1321758666992E+04, .8683813476562E+03},
 {   16906, .8112165527344E+04, -.1303710205078E+04, .8691937255859E+03},
 {   16907, .8111544433594E+04, -.1285592041016E+04, .8694658813477E+03},
 {   16908, .8112165527344E+04, -.1267473876953E+04, .8691936035156E+03},
 {   16909, .8114023925781E+04, -.1249425415039E+04, .8683813476562E+03},
 {   16910, .8117145019531E+04, -.1231520996094E+04, .8670166625977E+03},
 {   16911, .8119261230469E+04, -.1213846191406E+04, .8661159057617E+03},
 {   16912, .8122756347656E+04, -.1196504882812E+04, .8646111450195E+03},
 {   16913, .8125414550781E+04, -.1179629394531E+04, .8634978027344E+03},
 {   16914, .8129678710938E+04, -.1163404296875E+04, .8616800537109E+03},
 {   16915, .8133399414062E+04, -.1148084960938E+04, .8601256103516E+03},
 {   16916, .8381090820312E+04, -.1224000854492E+04, .1251129638672E+04},
 {   16917, .8388576171875E+04, -.1222944824219E+04, .1247778076172E+04},
 {   16918, .8396103515625E+04, -.1222311279297E+04, .1244409790039E+04},
 {   16919, .8403649414062E+04, -.1222092041016E+04, .1241030761719E+04},
 {   16920, .8364424804688E+04, -.1213174926758E+04, .1230760986328E+04},
 {   16921, .8373938476562E+04, -.1211067138672E+04, .1226503173828E+04},
 {   16922, .8383572265625E+04, -.1209809814453E+04, .1222188964844E+04},
 {   16923, .8393270507812E+04, -.1209392089844E+04, .1217848388672E+04},
 {   16924, .8349023437500E+04, -.1181395874023E+04, .1223740966797E+04},
 {   16925, .8361521484375E+04, -.1175852294922E+04, .1218146484375E+04},
 {   16926, .8374640625000E+04, -.1172444824219E+04, .1212273925781E+04},
 {   16927, .8388082031250E+04, -.1171291992188E+04, .1206256225586E+04},
 {   16928, .8340397460938E+04, -.1156813110352E+04, .1220645507812E+04},
 {   16929, .8354141601562E+04, -.1147704345703E+04, .1214492919922E+04},
 {   16930, .8369355468750E+04, -.1141684570312E+04, .1207682739258E+04},
 {   16931, .8385488281250E+04, -.1139541992188E+04, .1200460815430E+04},
 {   16932, .8332801757812E+04, -.1131877319336E+04, .1217088623047E+04},
 {   16933, .8347533203125E+04, -.1119379394531E+04, .1210493652344E+04},
 {   16934, .8364474609375E+04, -.1110877319336E+04, .1202910522461E+04},
 {   16935, .8382892578125E+04, -.1107791992188E+04, .1194665527344E+04},
 {   16936, .8327555664062E+04, -.1110380981445E+04, .1205522705078E+04},
 {   16937, .8341638671875E+04, -.1096298828125E+04, .1199218750000E+04},
 {   16938, .8358782226562E+04, -.1086964233398E+04, .1191543823242E+04},
 {   16939, .8377703125000E+04, -.1083661987305E+04, .1183073486328E+04},
 {   16940, .8323773437500E+04, -.1088675170898E+04, .1193301635742E+04},
 {   16941, .8336702148438E+04, -.1073104980469E+04, .1187513793945E+04},
 {   16942, .8353566406250E+04, -.1063020751953E+04, .1179963745117E+04},
 {   16943, .8372514648438E+04, -.1059532104492E+04, .1171481811523E+04},
 {   16944, .8305565429688E+04, -.1091055175781E+04, .1173652587891E+04},
 {   16945, .8319701171875E+04, -.1070978637695E+04, .1167315551758E+04},
 {   16946, .8339427734375E+04, -.1057772827148E+04, .1158475097656E+04},
 {   16947, .8362138671875E+04, -.1053182006836E+04, .1148298828125E+04},
 {   16948, .8287493164062E+04, -.1093902587891E+04, .1153885864258E+04},
 {   16949, .8302562500000E+04, -.1069166992188E+04, .1147138427734E+04},
 {   16950, .8325133789062E+04, -.1052635742188E+04, .1137034179688E+04},
 {   16951, .8351757812500E+04, -.1046832031250E+04, .1125116088867E+04},
 {   16952, .8277114257812E+04, -.1093902587891E+04, .1130702758789E+04},
 {   16953, .8292186523438E+04, -.1069166992188E+04, .1123955200195E+04},
 {   16954, .8314756835938E+04, -.1052635742188E+04, .1113850952148E+04},
 {   16955, .8341379882812E+04, -.1046832031250E+04, .1101933227539E+04},
 {   16956, .8266736328125E+04, -.1093902587891E+04, .1107519653320E+04},
 {   16957, .8281807617188E+04, -.1069166992188E+04, .1100772094727E+04},
 {   16958, .8304378906250E+04, -.1052635742188E+04, .1090667846680E+04},
 {   16959, .8331000976562E+04, -.1046832031250E+04, .1078749877930E+04},
 {   16960, .8256355468750E+04, -.1093902587891E+04, .1084336547852E+04},
 {   16961, .8271429687500E+04, -.1069166992188E+04, .1077588867188E+04},
 {   16962, .8294000000000E+04, -.1052635742188E+04, .1067484985352E+04},
 {   16963, .8320622070312E+04, -.1046832031250E+04, .1055566894531E+04},
 {   16964, .8245978515625E+04, -.1093902587891E+04, .1061153564453E+04},
 {   16965, .8261051757812E+04, -.1069166992188E+04, .1054405761719E+04},
 {   16966, .8283623046875E+04, -.1052635742188E+04, .1044301513672E+04},
 {   16967, .8310247070312E+04, -.1046832031250E+04, .1032383544922E+04},
 {   16968, .8235602539062E+04, -.1093902587891E+04, .1037970458984E+04},
 {   16969, .8250672851562E+04, -.1069166992188E+04, .1031222656250E+04},
 {   16970, .8273243164062E+04, -.1052635742188E+04, .1021119018555E+04},
 {   16971, .8299867187500E+04, -.1046832031250E+04, .1009200866699E+04},
 {   16972, .8225219726562E+04, -.1093902587891E+04, .1014787719727E+04},
 {   16973, .8240295898438E+04, -.1069166992188E+04, .1008039794922E+04},
 {   16974, .8262865234375E+04, -.1052635742188E+04, .9979362182617E+03},
 {   16975, .8289487304688E+04, -.1046832031250E+04, .9860181274414E+03},
 {   16976, .8214842773438E+04, -.1093902587891E+04, .9916044311523E+03},
 {   16977, .8229916992188E+04, -.1069166992188E+04, .9848572998047E+03},
 {   16978, .8252488281250E+04, -.1052635742188E+04, .9747525634766E+03},
 {   16979, .8279110351562E+04, -.1046832031250E+04, .9628347167969E+03},
 {   16980, .8204463867188E+04, -.1093902587891E+04, .9684215087891E+03},
 {   16981, .8219540039062E+04, -.1069166992188E+04, .9616737670898E+03},
 {   16982, .8242108398438E+04, -.1052635742188E+04, .9515697021484E+03},
 {   16983, .8268731445312E+04, -.1046832031250E+04, .9396518554688E+03},
 {   16984, .8198370117188E+04, -.1103439086914E+04, .9433214111328E+03},
 {   16985, .8211161132812E+04, -.1077979125977E+04, .9375949096680E+03},
 {   16986, .8232430664062E+04, -.1060610229492E+04, .9280736694336E+03},
 {   16987, .8258354492188E+04, -.1054452026367E+04, .9164686279297E+03},
 {   16988, .8187424316406E+04, -.1105337524414E+04, .9202577514648E+03},
 {   16989, .8201369140625E+04, -.1081887939453E+04, .9140432739258E+03},
 {   16990, .8222496093750E+04, -.1065914184570E+04, .9046279907227E+03},
 {   16991, .8247638671875E+04, -.1060230590820E+04, .8934229125977E+03},
 {   16992, .8178330566406E+04, -.1112282470703E+04, .8964380493164E+03},
 {   16993, .8193025390625E+04, -.1091669921875E+04, .8899015502930E+03},
 {   16994, .8213393554688E+04, -.1077635009766E+04, .8808440551758E+03},
 {   16995, .8237025390625E+04, -.1072613037109E+04, .8703350830078E+03},
 {   16996, .8164611816406E+04, -.1127257080078E+04, .8744874267578E+03},
 {   16997, .8181096191406E+04, -.1110474121094E+04, .8672141113281E+03},
 {   16998, .8202040039062E+04, -.1099032226562E+04, .8579739990234E+03},
 {   16999, .8225690429688E+04, -.1094901611328E+04, .8475399780273E+03},
 {   17000, .8149040039062E+04, -.1131149047852E+04, .8532868041992E+03},
 {   17001, .8167843261719E+04, -.1117112670898E+04, .8450646362305E+03},
 {   17002, .8189768066406E+04, -.1107502197266E+04, .8354783935547E+03},
 {   17003, .8213804687500E+04, -.1103982055664E+04, .8249686279297E+03},
 {   17004, .8408865234375E+04, -.1223730468750E+04, .1238696044922E+04},
 {   17005, .8413037109375E+04, -.1227533691406E+04, .1236828857422E+04},
 {   17006, .8416256835938E+04, -.1232318115234E+04, .1235386474609E+04},
 {   17007, .8418809570312E+04, -.1237565673828E+04, .1234244262695E+04},
 {   17008, .8400765625000E+04, -.1210404418945E+04, .1214493652344E+04},
 {   17009, .8407849609375E+04, -.1213263305664E+04, .1211321777344E+04},
 {   17010, .8414250976562E+04, -.1217651123047E+04, .1208456787109E+04},
 {   17011, .8419862304688E+04, -.1223183837891E+04, .1205944213867E+04},
 {   17012, .8401522460938E+04, -.1172444824219E+04, .1200239746094E+04},
 {   17013, .8414640625000E+04, -.1175852294922E+04, .1194366821289E+04},
 {   17014, .8427137695312E+04, -.1181395874023E+04, .1188772460938E+04},
 {   17015, .8438753906250E+04, -.1188896240234E+04, .1183572998047E+04},
 {   17016, .8401620117188E+04, -.1141684570312E+04, .1193239135742E+04},
 {   17017, .8416834960938E+04, -.1147704345703E+04, .1186429321289E+04},
 {   17018, .8430576171875E+04, -.1156813110352E+04, .1180276367188E+04},
 {   17019, .8442634765625E+04, -.1168259033203E+04, .1174877929688E+04},
 {   17020, .8401310546875E+04, -.1110877319336E+04, .1186420043945E+04},
 {   17021, .8418250000000E+04, -.1119379394531E+04, .1178837036133E+04},
 {   17022, .8432983398438E+04, -.1131877319336E+04, .1172241943359E+04},
 {   17023, .8445390625000E+04, -.1147107299805E+04, .1166687744141E+04},
 {   17024, .8396625976562E+04, -.1086964233398E+04, .1174603149414E+04},
 {   17025, .8413766601562E+04, -.1096298828125E+04, .1166928710938E+04},
 {   17026, .8427850585938E+04, -.1110381103516E+04, .1160624267578E+04},
 {   17027, .8438106445312E+04, -.1127659423828E+04, .1156033691406E+04},
 {   17028, .8391460937500E+04, -.1063020874023E+04, .1163000732422E+04},
 {   17029, .8408326171875E+04, -.1073104980469E+04, .1155450439453E+04},
 {   17030, .8421256835938E+04, -.1088675170898E+04, .1149662353516E+04},
 {   17031, .8428828125000E+04, -.1108019042969E+04, .1146271972656E+04},
 {   17032, .8384852539062E+04, -.1057772827148E+04, .1138139038086E+04},
 {   17033, .8404585937500E+04, -.1070978637695E+04, .1129315185547E+04},
 {   17034, .8418728515625E+04, -.1091055175781E+04, .1122994140625E+04},
 {   17035, .8425391601562E+04, -.1115336669922E+04, .1120020019531E+04},
 {   17036, .8378379882812E+04, -.1052635742188E+04, .1113197998047E+04},
 {   17037, .8400952148438E+04, -.1069166992188E+04, .1103094238281E+04},
 {   17038, .8416027343750E+04, -.1093902587891E+04, .1096346069336E+04},
 {   17039, .8421307617188E+04, -.1123070068359E+04, .1093981079102E+04},
 {   17040, .8368000000000E+04, -.1052635742188E+04, .1090015258789E+04},
 {   17041, .8390574218750E+04, -.1069166992188E+04, .1079911010742E+04},
 {   17042, .8405646484375E+04, -.1093902587891E+04, .1073163330078E+04},
 {   17043, .8410929687500E+04, -.1123070068359E+04, .1070798217773E+04},
 {   17044, .8357624023438E+04, -.1052635742188E+04, .1066832153320E+04},
 {   17045, .8380195312500E+04, -.1069166992188E+04, .1056727905273E+04},
 {   17046, .8395268554688E+04, -.1093902587891E+04, .1049980102539E+04},
 {   17047, .8400550781250E+04, -.1123070068359E+04, .1047615478516E+04},
 {   17048, .8347246093750E+04, -.1052635742188E+04, .1043649047852E+04},
 {   17049, .8369817382812E+04, -.1069166992188E+04, .1033544677734E+04},
 {   17050, .8384891601562E+04, -.1093902587891E+04, .1026796997070E+04},
 {   17051, .8390172851562E+04, -.1123070068359E+04, .1024432373047E+04},
 {   17052, .8336868164062E+04, -.1052635742188E+04, .1020465759277E+04},
 {   17053, .8359437500000E+04, -.1069166992188E+04, .1010361572266E+04},
 {   17054, .8374511718750E+04, -.1093902587891E+04, .1003614440918E+04},
 {   17055, .8379793945312E+04, -.1123070068359E+04, .1001249267578E+04},
 {   17056, .8326488281250E+04, -.1052635742188E+04, .9972831420898E+03},
 {   17057, .8349060546875E+04, -.1069166992188E+04, .9871785888672E+03},
 {   17058, .8364134765625E+04, -.1093902587891E+04, .9804309082031E+03},
 {   17059, .8369416992188E+04, -.1123070190430E+04, .9780658569336E+03},
 {   17060, .8316110351562E+04, -.1052635742188E+04, .9740998535156E+03},
 {   17061, .8338681640625E+04, -.1069166992188E+04, .9639954833984E+03},
 {   17062, .8353756835938E+04, -.1093902587891E+04, .9572481079102E+03},
 {   17063, .8359039062500E+04, -.1123070190430E+04, .9548834228516E+03},
 {   17064, .8305732421875E+04, -.1052635742188E+04, .9509167480469E+03},
 {   17065, .8328302734375E+04, -.1069166992188E+04, .9408124389648E+03},
 {   17066, .8343376953125E+04, -.1093902587891E+04, .9340648193359E+03},
 {   17067, .8348662109375E+04, -.1123070190430E+04, .9316998901367E+03},
 {   17068, .8295353515625E+04, -.1052635742188E+04, .9277338867188E+03},
 {   17069, .8317926757812E+04, -.1069166992188E+04, .9176291503906E+03},
 {   17070, .8332999023438E+04, -.1093902587891E+04, .9108818359375E+03},
 {   17071, .8338282226562E+04, -.1123070190430E+04, .9085170288086E+03},
 {   17072, .8282773437500E+04, -.1059886230469E+04, .9055366821289E+03},
 {   17073, .8303329101562E+04, -.1075332763672E+04, .8963354492188E+03},
 {   17074, .8316750000000E+04, -.1098337890625E+04, .8903267822266E+03},
 {   17075, .8320916015625E+04, -.1125250976562E+04, .8884621582031E+03},
 {   17076, .8272027343750E+04, -.1065171020508E+04, .8825534057617E+03},
 {   17077, .8293138671875E+04, -.1079242187500E+04, .8731447753906E+03},
 {   17078, .8308204101562E+04, -.1100299316406E+04, .8664310302734E+03},
 {   17079, .8315379882812E+04, -.1125113647461E+04, .8632324829102E+03},
 {   17080, .8260624023438E+04, -.1076878417969E+04, .8598401489258E+03},
 {   17081, .8281646484375E+04, -.1089057861328E+04, .8504903564453E+03},
 {   17082, .8297947265625E+04, -.1107411621094E+04, .8432418212891E+03},
 {   17083, .8308089843750E+04, -.1129340820312E+04, .8387316894531E+03},
 {   17084, .8249996093750E+04, -.1098284301758E+04, .8368159179688E+03},
 {   17085, .8272314453125E+04, -.1107976562500E+04, .8269692382812E+03},
 {   17086, .8291042968750E+04, -.1122736694336E+04, .8187062988281E+03},
 {   17087, .8305157226562E+04, -.1140800781250E+04, .8124784545898E+03},
 {   17088, .8239223632812E+04, -.1106695312500E+04, .8138530273438E+03},
 {   17089, .8263329101562E+04, -.1114508178711E+04, .8033129272461E+03},
 {   17090, .8285178710938E+04, -.1126610107422E+04, .7937590332031E+03},
 {   17091, .8304302734375E+04, -.1142051635742E+04, .7853966674805E+03},
 {   17092, .8420925781250E+04, -.1243257080078E+04, .1233297363281E+04},
 {   17093, .8422620117188E+04, -.1249115478516E+04, .1232539062500E+04},
 {   17094, .8423975585938E+04, -.1255079101562E+04, .1231931884766E+04},
 {   17095, .8425037109375E+04, -.1261113891602E+04, .1231457519531E+04},
 {   17096, .8425833984375E+04, -.1267197143555E+04, .1231099365234E+04},
 {   17097, .8426391601562E+04, -.1273312500000E+04, .1230850708008E+04},
 {   17098, .8426718750000E+04, -.1279447509766E+04, .1230703369141E+04},
 {   17099, .8426830078125E+04, -.1285592041016E+04, .1230653564453E+04},
 {   17100, .8426718750000E+04, -.1291736450195E+04, .1230703369141E+04},
 {   17101, .8426391601562E+04, -.1297871459961E+04, .1230850708008E+04},
 {   17102, .8425833984375E+04, -.1303986816406E+04, .1231099365234E+04},
 {   17103, .8425037109375E+04, -.1310070068359E+04, .1231457519531E+04},
 {   17104, .8423975585938E+04, -.1316104980469E+04, .1231931884766E+04},
 {   17105, .8422620117188E+04, -.1322068481445E+04, .1232539062500E+04},
 {   17106, .8420925781250E+04, -.1327927001953E+04, .1233297363281E+04},
 {   17107, .8418809570312E+04, -.1333618408203E+04, .1234244262695E+04},
 {   17108, .8424770507812E+04, -.1229694458008E+04, .1203746582031E+04},
 {   17109, .8428896484375E+04, -.1236829101562E+04, .1201899658203E+04},
 {   17110, .8432276367188E+04, -.1244418212891E+04, .1200386108398E+04},
 {   17111, .8434983398438E+04, -.1252326049805E+04, .1199175415039E+04},
 {   17112, .8437038085938E+04, -.1260466064453E+04, .1198255615234E+04},
 {   17113, .8438483398438E+04, -.1268760742188E+04, .1197607666016E+04},
 {   17114, .8439347656250E+04, -.1277152832031E+04, .1197221679688E+04},
 {   17115, .8439637695312E+04, -.1285592041016E+04, .1197092163086E+04},
 {   17116, .8439347656250E+04, -.1294031250000E+04, .1197221679688E+04},
 {   17117, .8438483398438E+04, -.1302423339844E+04, .1197607910156E+04},
 {   17118, .8437038085938E+04, -.1310718139648E+04, .1198255615234E+04},
 {   17119, .8434983398438E+04, -.1318858154297E+04, .1199175415039E+04},
 {   17120, .8432276367188E+04, -.1326765869141E+04, .1200386108398E+04},
 {   17121, .8428896484375E+04, -.1334355102539E+04, .1201899658203E+04},
 {   17122, .8424770507812E+04, -.1341489624023E+04, .1203746582031E+04},
 {   17123, .8419862304688E+04, -.1348000244141E+04, .1205944213867E+04},
 {   17124, .8448787109375E+04, -.1197651611328E+04, .1179081176758E+04},
 {   17125, .8457681640625E+04, -.1207776123047E+04, .1175098876953E+04},
 {   17126, .8465349609375E+04, -.1219044067383E+04, .1171666870117E+04},
 {   17127, .8471694335938E+04, -.1231257324219E+04, .1168826171875E+04},
 {   17128, .8476668945312E+04, -.1244211547852E+04, .1166599609375E+04},
 {   17129, .8480254882812E+04, -.1257704833984E+04, .1164994018555E+04},
 {   17130, .8482399414062E+04, -.1271561157227E+04, .1164034667969E+04},
 {   17131, .8483131835938E+04, -.1285592041016E+04, .1163706054688E+04},
 {   17132, .8482399414062E+04, -.1299622924805E+04, .1164034667969E+04},
 {   17133, .8480254882812E+04, -.1313479370117E+04, .1164994018555E+04},
 {   17134, .8476668945312E+04, -.1326972656250E+04, .1166599609375E+04},
 {   17135, .8471694335938E+04, -.1339926757812E+04, .1168826171875E+04},
 {   17136, .8465349609375E+04, -.1352140136719E+04, .1171666870117E+04},
 {   17137, .8457681640625E+04, -.1363407958984E+04, .1175098876953E+04},
 {   17138, .8448787109375E+04, -.1373532592773E+04, .1179081176758E+04},
 {   17139, .8438753906250E+04, -.1382287841797E+04, .1183572998047E+04},
 {   17140, .8452345703125E+04, -.1180315307617E+04, .1170531250000E+04},
 {   17141, .8460615234375E+04, -.1193528442383E+04, .1166829101562E+04},
 {   17142, .8467516601562E+04, -.1207622070312E+04, .1163738769531E+04},
 {   17143, .8473091796875E+04, -.1222409179688E+04, .1161243896484E+04},
 {   17144, .8477378906250E+04, -.1237733398438E+04, .1159325683594E+04},
 {   17145, .8480425781250E+04, -.1253455810547E+04, .1157960571289E+04},
 {   17146, .8482241210938E+04, -.1269454467773E+04, .1157147460938E+04},
 {   17147, .8482855468750E+04, -.1285592041016E+04, .1156872680664E+04},
 {   17148, .8482241210938E+04, -.1301729614258E+04, .1157147705078E+04},
 {   17149, .8480425781250E+04, -.1317728271484E+04, .1157960571289E+04},
 {   17150, .8477378906250E+04, -.1333450683594E+04, .1159325683594E+04},
 {   17151, .8473091796875E+04, -.1348774902344E+04, .1161243896484E+04},
 {   17152, .8467516601562E+04, -.1363562011719E+04, .1163738769531E+04},
 {   17153, .8460615234375E+04, -.1377655639648E+04, .1166829101562E+04},
 {   17154, .8452345703125E+04, -.1390868774414E+04, .1170531250000E+04},
 {   17155, .8442634765625E+04, -.1402925048828E+04, .1174877929688E+04},
 {   17156, .8454732421875E+04, -.1162330078125E+04, .1162505615234E+04},
 {   17157, .8462487304688E+04, -.1178586791992E+04, .1159034423828E+04},
 {   17158, .8468841796875E+04, -.1195556884766E+04, .1156188720703E+04},
 {   17159, .8473901367188E+04, -.1213042602539E+04, .1153924560547E+04},
 {   17160, .8477742187500E+04, -.1230896118164E+04, .1152204589844E+04},
 {   17161, .8480441406250E+04, -.1248999389648E+04, .1150995849609E+04},
 {   17162, .8482045898438E+04, -.1267258178711E+04, .1150278564453E+04},
 {   17163, .8482579101562E+04, -.1285592041016E+04, .1150039306641E+04},
 {   17164, .8482045898438E+04, -.1303925903320E+04, .1150278564453E+04},
 {   17165, .8480441406250E+04, -.1322184692383E+04, .1150995849609E+04},
 {   17166, .8477742187500E+04, -.1340287963867E+04, .1152204589844E+04},
 {   17167, .8473901367188E+04, -.1358141479492E+04, .1153924560547E+04},
 {   17168, .8468841796875E+04, -.1375627197266E+04, .1156188720703E+04},
 {   17169, .8462487304688E+04, -.1392597290039E+04, .1159034423828E+04},
 {   17170, .8454732421875E+04, -.1408854003906E+04, .1162505615234E+04},
 {   17171, .8445390625000E+04, -.1424076782227E+04, .1166687744141E+04},
 {   17172, .8450211914062E+04, -.1144227661133E+04, .1150614257812E+04},
 {   17173, .8460188476562E+04, -.1162440673828E+04, .1146147583008E+04},
 {   17174, .8468289062500E+04, -.1181746582031E+04, .1142522705078E+04},
 {   17175, .8474679687500E+04, -.1201803344727E+04, .1139661254883E+04},
 {   17176, .8479489257812E+04, -.1222375732422E+04, .1137508178711E+04},
 {   17177, .8482857421875E+04, -.1243280151367E+04, .1136000488281E+04},
 {   17178, .8484837890625E+04, -.1264388793945E+04, .1135113891602E+04},
 {   17179, .8485504882812E+04, -.1285592041016E+04, .1134815185547E+04},
 {   17180, .8484837890625E+04, -.1306795288086E+04, .1135113891602E+04},
 {   17181, .8482857421875E+04, -.1327903930664E+04, .1136000488281E+04},
 {   17182, .8479489257812E+04, -.1348808349609E+04, .1137508178711E+04},
 {   17183, .8474679687500E+04, -.1369380737305E+04, .1139661254883E+04},
 {   17184, .8468289062500E+04, -.1389437500000E+04, .1142522705078E+04},
 {   17185, .8460188476562E+04, -.1408743408203E+04, .1146147583008E+04},
 {   17186, .8450211914062E+04, -.1426956420898E+04, .1150614257812E+04},
 {   17187, .8438106445312E+04, -.1443524536133E+04, .1156033691406E+04},
 {   17188, .8444040039062E+04, -.1125696044922E+04, .1139463134766E+04},
 {   17189, .8456584960938E+04, -.1145728637695E+04, .1133847534180E+04},
 {   17190, .8466754882812E+04, -.1167315429688E+04, .1129293701172E+04},
 {   17191, .8474787109375E+04, -.1189959838867E+04, .1125698242188E+04},
 {   17192, .8480834960938E+04, -.1213332885742E+04, .1122991210938E+04},
 {   17193, .8485083984375E+04, -.1237176391602E+04, .1121088867188E+04},
 {   17194, .8487581054688E+04, -.1261315795898E+04, .1119970703125E+04},
 {   17195, .8488428710938E+04, -.1285592041016E+04, .1119591430664E+04},
 {   17196, .8487581054688E+04, -.1309868286133E+04, .1119970703125E+04},
 {   17197, .8485083984375E+04, -.1334007690430E+04, .1121088867188E+04},
 {   17198, .8480834960938E+04, -.1357851318359E+04, .1122991210938E+04},
 {   17199, .8474787109375E+04, -.1381224243164E+04, .1125698486328E+04},
 {   17200, .8466754882812E+04, -.1403868652344E+04, .1129293701172E+04},
 {   17201, .8456584960938E+04, -.1425455566406E+04, .1133847534180E+04},
 {   17202, .8444040039062E+04, -.1445488037109E+04, .1139463134766E+04},
 {   17203, .8428828125000E+04, -.1463165039062E+04, .1146272216797E+04},
 {   17204, .8438717773438E+04, -.1133068603516E+04, .1114055053711E+04},
 {   17205, .8449761718750E+04, -.1152589477539E+04, .1109110839844E+04},
 {   17206, .8458755859375E+04, -.1173336547852E+04, .1105084472656E+04},
 {   17207, .8465876953125E+04, -.1194945922852E+04, .1101896728516E+04},
 {   17208, .8471282226562E+04, -.1217146240234E+04, .1099477905273E+04},
 {   17209, .8475060546875E+04, -.1239754882812E+04, .1097786376953E+04},
 {   17210, .8477307617188E+04, -.1262612792969E+04, .1096779296875E+04},
 {   17211, .8478066406250E+04, -.1285592529297E+04, .1096440429688E+04},
 {   17212, .8477307617188E+04, -.1308571411133E+04, .1096779296875E+04},
 {   17213, .8475060546875E+04, -.1331429199219E+04, .1097786376953E+04},
 {   17214, .8471282226562E+04, -.1354037963867E+04, .1099477905273E+04},
 {   17215, .8465876953125E+04, -.1376238281250E+04, .1101896606445E+04},
 {   17216, .8458755859375E+04, -.1397847656250E+04, .1105084472656E+04},
 {   17217, .8449761718750E+04, -.1418594726562E+04, .1109110839844E+04},
 {   17218, .8438720703125E+04, -.1438115600586E+04, .1114054809570E+04},
 {   17219, .8425391601562E+04, -.1455847412109E+04, .1120020019531E+04},
 {   17220, .8432952148438E+04, -.1140602661133E+04, .1088768066406E+04},
 {   17221, .8442647460938E+04, -.1159507324219E+04, .1084428222656E+04},
 {   17222, .8450563476562E+04, -.1179380859375E+04, .1080884521484E+04},
 {   17223, .8456852539062E+04, -.1199940429688E+04, .1078069213867E+04},
 {   17224, .8461641601562E+04, -.1220979736328E+04, .1075925048828E+04},
 {   17225, .8465008789062E+04, -.1242347534180E+04, .1074417724609E+04},
 {   17226, .8467006835938E+04, -.1263920532227E+04, .1073523315430E+04},
 {   17227, .8467671875000E+04, -.1285592041016E+04, .1073225341797E+04},
 {   17228, .8467006835938E+04, -.1307263671875E+04, .1073523315430E+04},
 {   17229, .8465008789062E+04, -.1328836547852E+04, .1074417724609E+04},
 {   17230, .8461641601562E+04, -.1350204345703E+04, .1075925048828E+04},
 {   17231, .8456851562500E+04, -.1371243774414E+04, .1078069091797E+04},
 {   17232, .8450563476562E+04, -.1391803222656E+04, .1080884521484E+04},
 {   17233, .8442647460938E+04, -.1411676879883E+04, .1084428222656E+04},
 {   17234, .8432952148438E+04, -.1430581542969E+04, .1088767822266E+04},
 {   17235, .8421307617188E+04, -.1448114135742E+04, .1093981079102E+04},
 {   17236, .8422576171875E+04, -.1140602661133E+04, .1065585083008E+04},
 {   17237, .8432268554688E+04, -.1159507324219E+04, .1061245239258E+04},
 {   17238, .8440187500000E+04, -.1179380859375E+04, .1057701904297E+04},
 {   17239, .8446473632812E+04, -.1199940429688E+04, .1054886108398E+04},
 {   17240, .8451265625000E+04, -.1220979736328E+04, .1052741699219E+04},
 {   17241, .8454630859375E+04, -.1242347534180E+04, .1051234741211E+04},
 {   17242, .8456629882812E+04, -.1263920532227E+04, .1050340332031E+04},
 {   17243, .8457294921875E+04, -.1285592041016E+04, .1050042236328E+04},
 {   17244, .8456629882812E+04, -.1307263671875E+04, .1050340332031E+04},
 {   17245, .8454630859375E+04, -.1328836547852E+04, .1051234741211E+04},
 {   17246, .8451265625000E+04, -.1350204467773E+04, .1052741699219E+04},
 {   17247, .8446473632812E+04, -.1371243774414E+04, .1054886108398E+04},
 {   17248, .8440187500000E+04, -.1391803344727E+04, .1057701904297E+04},
 {   17249, .8432266601562E+04, -.1411676879883E+04, .1061245605469E+04},
 {   17250, .8422576171875E+04, -.1430581542969E+04, .1065585083008E+04},
 {   17251, .8410929687500E+04, -.1448114013672E+04, .1070798217773E+04},
 {   17252, .8412195312500E+04, -.1140602661133E+04, .1042401977539E+04},
 {   17253, .8421889648438E+04, -.1159507324219E+04, .1038062744141E+04},
 {   17254, .8429807617188E+04, -.1179380859375E+04, .1034518554688E+04},
 {   17255, .8436095703125E+04, -.1199940429688E+04, .1031703002930E+04},
 {   17256, .8440885742188E+04, -.1220979736328E+04, .1029559082031E+04},
 {   17257, .8444250976562E+04, -.1242347534180E+04, .1028051757812E+04},
 {   17258, .8446253906250E+04, -.1263920532227E+04, .1027156494141E+04},
 {   17259, .8446916992188E+04, -.1285592041016E+04, .1026859497070E+04},
 {   17260, .8446253906250E+04, -.1307263671875E+04, .1027156494141E+04},
 {   17261, .8444250976562E+04, -.1328836547852E+04, .1028051757812E+04},
 {   17262, .8440885742188E+04, -.1350204467773E+04, .1029559082031E+04},
 {   17263, .8436095703125E+04, -.1371243774414E+04, .1031703002930E+04},
 {   17264, .8429807617188E+04, -.1391803344727E+04, .1034518798828E+04},
 {   17265, .8421889648438E+04, -.1411676879883E+04, .1038062744141E+04},
 {   17266, .8412195312500E+04, -.1430581542969E+04, .1042402221680E+04},
 {   17267, .8400550781250E+04, -.1448114013672E+04, .1047615478516E+04},
 {   17268, .8401818359375E+04, -.1140602661133E+04, .1019218994141E+04},
 {   17269, .8411513671875E+04, -.1159507324219E+04, .1014879394531E+04},
 {   17270, .8419429687500E+04, -.1179380859375E+04, .1011335815430E+04},
 {   17271, .8425717773438E+04, -.1199940429688E+04, .1008519714355E+04},
 {   17272, .8430508789062E+04, -.1220979736328E+04, .1006375915527E+04},
 {   17273, .8433873046875E+04, -.1242347534180E+04, .1004868774414E+04},
 {   17274, .8435874023438E+04, -.1263920532227E+04, .1003973754883E+04},
 {   17275, .8436538085938E+04, -.1285592041016E+04, .1003676269531E+04},
 {   17276, .8435874023438E+04, -.1307263671875E+04, .1003973754883E+04},
 {   17277, .8433873046875E+04, -.1328836547852E+04, .1004868774414E+04},
 {   17278, .8430508789062E+04, -.1350204467773E+04, .1006375915527E+04},
 {   17279, .8425717773438E+04, -.1371243774414E+04, .1008519714355E+04},
 {   17280, .8419429687500E+04, -.1391803344727E+04, .1011336059570E+04},
 {   17281, .8411513671875E+04, -.1411676879883E+04, .1014879394531E+04},
 {   17282, .8401818359375E+04, -.1430581542969E+04, .1019218994141E+04},
 {   17283, .8390172851562E+04, -.1448114013672E+04, .1024432373047E+04},
 {   17284, .8391441406250E+04, -.1140602661133E+04, .9960359497070E+03},
 {   17285, .8401133789062E+04, -.1159507324219E+04, .9916964111328E+03},
 {   17286, .8409049804688E+04, -.1179380859375E+04, .9881527099609E+03},
 {   17287, .8415340820312E+04, -.1199940429688E+04, .9853368530273E+03},
 {   17288, .8420129882812E+04, -.1220979736328E+04, .9831928710938E+03},
 {   17289, .8423498046875E+04, -.1242347534180E+04, .9816857299805E+03},
 {   17290, .8425496093750E+04, -.1263920532227E+04, .9807906494141E+03},
 {   17291, .8426162109375E+04, -.1285592041016E+04, .9804927978516E+03},
 {   17292, .8425496093750E+04, -.1307263671875E+04, .9807906494141E+03},
 {   17293, .8423498046875E+04, -.1328836547852E+04, .9816857299805E+03},
 {   17294, .8420129882812E+04, -.1350204467773E+04, .9831928710938E+03},
 {   17295, .8415340820312E+04, -.1371243774414E+04, .9853368530273E+03},
 {   17296, .8409049804688E+04, -.1391803344727E+04, .9881527099609E+03},
 {   17297, .8401133789062E+04, -.1411676879883E+04, .9916964111328E+03},
 {   17298, .8391441406250E+04, -.1430581542969E+04, .9960359497070E+03},
 {   17299, .8379793945312E+04, -.1448114013672E+04, .1001249267578E+04},
 {   17300, .8381061523438E+04, -.1140602661133E+04, .9728529052734E+03},
 {   17301, .8390755859375E+04, -.1159507324219E+04, .9685135498047E+03},
 {   17302, .8398672851562E+04, -.1179380859375E+04, .9649693603516E+03},
 {   17303, .8404961914062E+04, -.1199940429688E+04, .9621536865234E+03},
 {   17304, .8409751953125E+04, -.1220979736328E+04, .9600096435547E+03},
 {   17305, .8413118164062E+04, -.1242347534180E+04, .9585025634766E+03},
 {   17306, .8415116210938E+04, -.1263920532227E+04, .9576077880859E+03},
 {   17307, .8415781250000E+04, -.1285592041016E+04, .9573101806641E+03},
 {   17308, .8415116210938E+04, -.1307263671875E+04, .9576077880859E+03},
 {   17309, .8413118164062E+04, -.1328836547852E+04, .9585025634766E+03},
 {   17310, .8409751953125E+04, -.1350204467773E+04, .9600096435547E+03},
 {   17311, .8404961914062E+04, -.1371243774414E+04, .9621536865234E+03},
 {   17312, .8398672851562E+04, -.1391803344727E+04, .9649693603516E+03},
 {   17313, .8390755859375E+04, -.1411676879883E+04, .9685135498047E+03},
 {   17314, .8381061523438E+04, -.1430581542969E+04, .9728526611328E+03},
 {   17315, .8369416992188E+04, -.1448114013672E+04, .9780658569336E+03},
 {   17316, .8370685546875E+04, -.1140602661133E+04, .9496695556641E+03},
 {   17317, .8380377929688E+04, -.1159507324219E+04, .9453300781250E+03},
 {   17318, .8388293945312E+04, -.1179380859375E+04, .9417861328125E+03},
 {   17319, .8394584960938E+04, -.1199940429688E+04, .9389705200195E+03},
 {   17320, .8399374023438E+04, -.1220979736328E+04, .9368265991211E+03},
 {   17321, .8402740234375E+04, -.1242347534180E+04, .9353197021484E+03},
 {   17322, .8404738281250E+04, -.1263920532227E+04, .9344248046875E+03},
 {   17323, .8405405273438E+04, -.1285592041016E+04, .9341266479492E+03},
 {   17324, .8404738281250E+04, -.1307263671875E+04, .9344248046875E+03},
 {   17325, .8402740234375E+04, -.1328836547852E+04, .9353197021484E+03},
 {   17326, .8399374023438E+04, -.1350204345703E+04, .9368265991211E+03},
 {   17327, .8394584960938E+04, -.1371243774414E+04, .9389705200195E+03},
 {   17328, .8388293945312E+04, -.1391803222656E+04, .9417862548828E+03},
 {   17329, .8380377929688E+04, -.1411676879883E+04, .9453302001953E+03},
 {   17330, .8370685546875E+04, -.1430581542969E+04, .9496695556641E+03},
 {   17331, .8359039062500E+04, -.1448114135742E+04, .9548834228516E+03},
 {   17332, .8360306640625E+04, -.1140602661133E+04, .9264866943359E+03},
 {   17333, .8369998046875E+04, -.1159507324219E+04, .9221472167969E+03},
 {   17334, .8377915039062E+04, -.1179380859375E+04, .9186035156250E+03},
 {   17335, .8384205078125E+04, -.1199940429688E+04, .9157876586914E+03},
 {   17336, .8388995117188E+04, -.1220979736328E+04, .9136434936523E+03},
 {   17337, .8392362304688E+04, -.1242347534180E+04, .9121364135742E+03},
 {   17338, .8394361328125E+04, -.1263920532227E+04, .9112415771484E+03},
 {   17339, .8395026367188E+04, -.1285592041016E+04, .9109437255859E+03},
 {   17340, .8394361328125E+04, -.1307263671875E+04, .9112415771484E+03},
 {   17341, .8392362304688E+04, -.1328836547852E+04, .9121364135742E+03},
 {   17342, .8388995117188E+04, -.1350204467773E+04, .9136434936523E+03},
 {   17343, .8384205078125E+04, -.1371243774414E+04, .9157876586914E+03},
 {   17344, .8377915039062E+04, -.1391803344727E+04, .9186036376953E+03},
 {   17345, .8369998046875E+04, -.1411676879883E+04, .9221472167969E+03},
 {   17346, .8360306640625E+04, -.1430581542969E+04, .9264866943359E+03},
 {   17347, .8348661132812E+04, -.1448114013672E+04, .9317001953125E+03},
 {   17348, .8349926757812E+04, -.1140602661133E+04, .9033034057617E+03},
 {   17349, .8359621093750E+04, -.1159507324219E+04, .8989641723633E+03},
 {   17350, .8367539062500E+04, -.1179380859375E+04, .8954201049805E+03},
 {   17351, .8373826171875E+04, -.1199940429688E+04, .8926044921875E+03},
 {   17352, .8378617187500E+04, -.1220979736328E+04, .8904603271484E+03},
 {   17353, .8381982421875E+04, -.1242347534180E+04, .8889536743164E+03},
 {   17354, .8383982421875E+04, -.1263920532227E+04, .8880585937500E+03},
 {   17355, .8384647460938E+04, -.1285592041016E+04, .8877607421875E+03},
 {   17356, .8383982421875E+04, -.1307263671875E+04, .8880585937500E+03},
 {   17357, .8381982421875E+04, -.1328836547852E+04, .8889536743164E+03},
 {   17358, .8378617187500E+04, -.1350204467773E+04, .8904603271484E+03},
 {   17359, .8373826171875E+04, -.1371243774414E+04, .8926044921875E+03},
 {   17360, .8367539062500E+04, -.1391803222656E+04, .8954202270508E+03},
 {   17361, .8359621093750E+04, -.1411676879883E+04, .8989642944336E+03},
 {   17362, .8349926757812E+04, -.1430581542969E+04, .9033034057617E+03},
 {   17363, .8338282226562E+04, -.1448114013672E+04, .9085170288086E+03},
 {   17364, .8334202148438E+04, -.1141575317383E+04, .8825139770508E+03},
 {   17365, .8345343750000E+04, -.1159725830078E+04, .8775264892578E+03},
 {   17366, .8354493164062E+04, -.1179166992188E+04, .8734310302734E+03},
 {   17367, .8361751953125E+04, -.1199542968750E+04, .8701816406250E+03},
 {   17368, .8367303710938E+04, -.1220552978516E+04, .8676963500977E+03},
 {   17369, .8371176757812E+04, -.1242010009766E+04, .8659615478516E+03},
 {   17370, .8373489257812E+04, -.1263735839844E+04, .8649266357422E+03},
 {   17371, .8374270507812E+04, -.1285592163086E+04, .8645778198242E+03},
 {   17372, .8373489257812E+04, -.1307448364258E+04, .8649266357422E+03},
 {   17373, .8371176757812E+04, -.1329174194336E+04, .8659615478516E+03},
 {   17374, .8367303710938E+04, -.1350631225586E+04, .8676963500977E+03},
 {   17375, .8361751953125E+04, -.1371641235352E+04, .8701816406250E+03},
 {   17376, .8354493164062E+04, -.1392017089844E+04, .8734310302734E+03},
 {   17377, .8345343750000E+04, -.1411458374023E+04, .8775264892578E+03},
 {   17378, .8334202148438E+04, -.1429608886719E+04, .8825139770508E+03},
 {   17379, .8320916015625E+04, -.1445933105469E+04, .8884622802734E+03},
 {   17380, .8328499023438E+04, -.1141583862305E+04, .8573858032227E+03},
 {   17381, .8339523437500E+04, -.1159792968750E+04, .8524726562500E+03},
 {   17382, .8348583984375E+04, -.1179252075195E+04, .8484345703125E+03},
 {   17383, .8355785156250E+04, -.1199618041992E+04, .8452248535156E+03},
 {   17384, .8361292968750E+04, -.1220609863281E+04, .8427706909180E+03},
 {   17385, .8365143554688E+04, -.1242044433594E+04, .8410541992188E+03},
 {   17386, .8367440429688E+04, -.1263751586914E+04, .8400306396484E+03},
 {   17387, .8368213867188E+04, -.1285592163086E+04, .8396860961914E+03},
 {   17388, .8367440429688E+04, -.1307432617188E+04, .8400306396484E+03},
 {   17389, .8365143554688E+04, -.1329139770508E+04, .8410541992188E+03},
 {   17390, .8361292968750E+04, -.1350574340820E+04, .8427706909180E+03},
 {   17391, .8355785156250E+04, -.1371566162109E+04, .8452248535156E+03},
 {   17392, .8348583984375E+04, -.1391932128906E+04, .8484346923828E+03},
 {   17393, .8339523437500E+04, -.1411391235352E+04, .8524726562500E+03},
 {   17394, .8328499023438E+04, -.1429600219727E+04, .8573858032227E+03},
 {   17395, .8315379882812E+04, -.1446070434570E+04, .8632326049805E+03},
 {   17396, .8320719726562E+04, -.1145484985352E+04, .8331144409180E+03},
 {   17397, .8331375000000E+04, -.1163240966797E+04, .8283756103516E+03},
 {   17398, .8340153320312E+04, -.1182181396484E+04, .8244719848633E+03},
 {   17399, .8347153320312E+04, -.1201984863281E+04, .8213587036133E+03},
 {   17400, .8352513671875E+04, -.1222395751953E+04, .8189759521484E+03},
 {   17401, .8356270507812E+04, -.1243237060547E+04, .8173043212891E+03},
 {   17402, .8358512695312E+04, -.1264348266602E+04, .8163077392578E+03},
 {   17403, .8359265625000E+04, -.1285592163086E+04, .8159727783203E+03},
 {   17404, .8358512695312E+04, -.1306835937500E+04, .8163077392578E+03},
 {   17405, .8356270507812E+04, -.1327947143555E+04, .8173043212891E+03},
 {   17406, .8352513671875E+04, -.1348788452148E+04, .8189760742188E+03},
 {   17407, .8347153320312E+04, -.1369199218750E+04, .8213587036133E+03},
 {   17408, .8340153320312E+04, -.1389002685547E+04, .8244721069336E+03},
 {   17409, .8331375000000E+04, -.1407943115234E+04, .8283756103516E+03},
 {   17410, .8320719726562E+04, -.1425699096680E+04, .8331144409180E+03},
 {   17411, .8308089843750E+04, -.1441843261719E+04, .8387316894531E+03},
 {   17412, .8318204101562E+04, -.1155839965820E+04, .8067224731445E+03},
 {   17413, .8325800781250E+04, -.1172303222656E+04, .8033942260742E+03},
 {   17414, .8334955078125E+04, -.1189842163086E+04, .7993547973633E+03},
 {   17415, .8338815429688E+04, -.1208170532227E+04, .7976743164062E+03},
 {   17416, .8342124023438E+04, -.1227066040039E+04, .7962290039062E+03},
 {   17417, .8346089843750E+04, -.1246363159180E+04, .7944794921875E+03},
 {   17418, .8348454101562E+04, -.1265915161133E+04, .7934363403320E+03},
 {   17419, .8349246093750E+04, -.1285592041016E+04, .7930865478516E+03},
 {   17420, .8348454101562E+04, -.1305269165039E+04, .7934363403320E+03},
 {   17421, .8346089843750E+04, -.1324821044922E+04, .7944796142578E+03},
 {   17422, .8342124023438E+04, -.1344118164062E+04, .7962290039062E+03},
 {   17423, .8342291992188E+04, -.1363013671875E+04, .7961175537109E+03},
 {   17424, .8334955078125E+04, -.1381342041016E+04, .7993547973633E+03},
 {   17425, .8325800781250E+04, -.1398880859375E+04, .8033942260742E+03},
 {   17426, .8318204101562E+04, -.1415344116211E+04, .8067225952148E+03},
 {   17427, .8305157226562E+04, -.1430383300781E+04, .8124784545898E+03},
 {   17428, .8318117187500E+04, -.1157016967773E+04, .7793559570312E+03},
 {   17429, .8326455078125E+04, -.1173331420898E+04, .7757457275391E+03},
 {   17430, .8336281250000E+04, -.1190700195312E+04, .7714492187500E+03},
 {   17431, .8338416015625E+04, -.1208850097656E+04, .7705768432617E+03},
 {   17432, .8341037109375E+04, -.1227572998047E+04, .7694661865234E+03},
 {   17433, .8341881835938E+04, -.1246699462891E+04, .7691333618164E+03},
 {   17434, .8344460937500E+04, -.1266083129883E+04, .7680050659180E+03},
 {   17435, .8345323242188E+04, -.1285592163086E+04, .7676281738281E+03},
 {   17436, .8344460937500E+04, -.1305101074219E+04, .7680050659180E+03},
 {   17437, .8341881835938E+04, -.1324484741211E+04, .7691333618164E+03},
 {   17438, .8341037109375E+04, -.1343611328125E+04, .7694661865234E+03},
 {   17439, .8338416015625E+04, -.1362334106445E+04, .7705768432617E+03},
 {   17440, .8336281250000E+04, -.1380484008789E+04, .7714492187500E+03},
 {   17441, .8326455078125E+04, -.1397852783203E+04, .7757458496094E+03},
 {   17442, .8318117187500E+04, -.1414167236328E+04, .7793559570312E+03},
 {   17443, .8304302734375E+04, -.1429132568359E+04, .7853966674805E+03},
 {   17444, .8417601562500E+04, -.1336291137695E+04, .1234785278320E+04},
 {   17445, .8416250000000E+04, -.1338880126953E+04, .1235390136719E+04},
 {   17446, .8414731445312E+04, -.1341355957031E+04, .1236069213867E+04},
 {   17447, .8413016601562E+04, -.1343672485352E+04, .1236837646484E+04},
 {   17448, .8411061523438E+04, -.1345748168945E+04, .1237711791992E+04},
 {   17449, .8408838867188E+04, -.1347469726562E+04, .1238707397461E+04},
 {   17450, .8406341796875E+04, -.1348653564453E+04, .1239826171875E+04},
 {   17451, .8417153320312E+04, -.1350890502930E+04, .1207156250000E+04},
 {   17452, .8414248046875E+04, -.1353535522461E+04, .1208457885742E+04},
 {   17453, .8411138671875E+04, -.1355894653320E+04, .1209848754883E+04},
 {   17454, .8407844726562E+04, -.1357923461914E+04, .1211324707031E+04},
 {   17455, .8404374023438E+04, -.1359570922852E+04, .1212876953125E+04},
 {   17456, .8400760742188E+04, -.1360780395508E+04, .1214494873047E+04},
 {   17457, .8397043945312E+04, -.1361529052734E+04, .1216159179688E+04},
 {   17458, .8433070312500E+04, -.1386269775391E+04, .1186117187500E+04},
 {   17459, .8427135742188E+04, -.1389788574219E+04, .1188772583008E+04},
 {   17460, .8420983398438E+04, -.1392817382812E+04, .1191527709961E+04},
 {   17461, .8414638671875E+04, -.1395332031250E+04, .1194367675781E+04},
 {   17462, .8408141601562E+04, -.1397311767578E+04, .1197277099609E+04},
 {   17463, .8401521484375E+04, -.1398739257812E+04, .1200239990234E+04},
 {   17464, .8394822265625E+04, -.1399602050781E+04, .1203239257812E+04},
 {   17465, .8436816406250E+04, -.1408899780273E+04, .1177482910156E+04},
 {   17466, .8430571289062E+04, -.1414377441406E+04, .1180278442383E+04},
 {   17467, .8423897460938E+04, -.1419267700195E+04, .1183265625000E+04},
 {   17468, .8416824218750E+04, -.1423486938477E+04, .1186432617188E+04},
 {   17469, .8409378906250E+04, -.1426941040039E+04, .1189766113281E+04},
 {   17470, .8401611328125E+04, -.1429502441406E+04, .1193242919922E+04},
 {   17471, .8393610351562E+04, -.1431091186523E+04, .1196823730469E+04},
 {   17472, .8439457031250E+04, -.1431969726562E+04, .1169343261719E+04},
 {   17473, .8432970703125E+04, -.1439320190430E+04, .1172247192383E+04},
 {   17474, .8425890625000E+04, -.1445981567383E+04, .1175416625977E+04},
 {   17475, .8418229492188E+04, -.1451819580078E+04, .1178846923828E+04},
 {   17476, .8410017578125E+04, -.1456673950195E+04, .1182523681641E+04},
 {   17477, .8401292968750E+04, -.1460312744141E+04, .1186427734375E+04},
 {   17478, .8392194335938E+04, -.1462592285156E+04, .1190500732422E+04},
 {   17479, .8433480468750E+04, -.1452462036133E+04, .1158104248047E+04},
 {   17480, .8427842773438E+04, -.1460810424805E+04, .1160627685547E+04},
 {   17481, .8421238281250E+04, -.1468351562500E+04, .1163584106445E+04},
 {   17482, .8413755859375E+04, -.1474893066406E+04, .1166934448242E+04},
 {   17483, .8405501953125E+04, -.1480249877930E+04, .1170628540039E+04},
 {   17484, .8396615234375E+04, -.1484222778320E+04, .1174607910156E+04},
 {   17485, .8387275390625E+04, -.1486679199219E+04, .1178787841797E+04},
 {   17486, .8425777343750E+04, -.1473183837891E+04, .1147638061523E+04},
 {   17487, .8421255859375E+04, -.1482510131836E+04, .1149662719727E+04},
 {   17488, .8415381835938E+04, -.1490885986328E+04, .1152291503906E+04},
 {   17489, .8408325195312E+04, -.1498079833984E+04, .1155450683594E+04},
 {   17490, .8400277343750E+04, -.1503892456055E+04, .1159053833008E+04},
 {   17491, .8391460937500E+04, -.1508163208008E+04, .1163000732422E+04},
 {   17492, .8382119140625E+04, -.1510773681641E+04, .1167182006836E+04},
 {   17493, .8423077148438E+04, -.1468321411133E+04, .1121052368164E+04},
 {   17494, .8418726562500E+04, -.1480131713867E+04, .1122994628906E+04},
 {   17495, .8412492187500E+04, -.1490880249023E+04, .1125780883789E+04},
 {   17496, .8404584960938E+04, -.1500207275391E+04, .1129315795898E+04},
 {   17497, .8395269531250E+04, -.1507801635742E+04, .1133481689453E+04},
 {   17498, .8384853515625E+04, -.1513411132812E+04, .1138138916016E+04},
 {   17499, .8373685546875E+04, -.1516849243164E+04, .1143133422852E+04},
 {   17500, .8419976562500E+04, -.1462985107422E+04, .1094577270508E+04},
 {   17501, .8416025390625E+04, -.1477286010742E+04, .1096346923828E+04},
 {   17502, .8409597656250E+04, -.1490466552734E+04, .1099222900391E+04},
 {   17503, .8400949218750E+04, -.1502020019531E+04, .1103095214844E+04},
 {   17504, .8390408203125E+04, -.1511502075195E+04, .1107813964844E+04},
 {   17505, .8378379882812E+04, -.1518548095703E+04, .1113197998047E+04},
 {   17506, .8365329101562E+04, -.1522886962891E+04, .1119040527344E+04},
 {   17507, .8409597656250E+04, -.1462985229492E+04, .1071394165039E+04},
 {   17508, .8405645507812E+04, -.1477286010742E+04, .1073164306641E+04},
 {   17509, .8399219726562E+04, -.1490466674805E+04, .1076040039062E+04},
 {   17510, .8390572265625E+04, -.1502020019531E+04, .1079912109375E+04},
 {   17511, .8380032226562E+04, -.1511502075195E+04, .1084630615234E+04},
 {   17512, .8368000976562E+04, -.1518548095703E+04, .1090015014648E+04},
 {   17513, .8354951171875E+04, -.1522886962891E+04, .1095857421875E+04},
 {   17514, .8399220703125E+04, -.1462985229492E+04, .1048210937500E+04},
 {   17515, .8395267578125E+04, -.1477286010742E+04, .1049981079102E+04},
 {   17516, .8388840820312E+04, -.1490466674805E+04, .1052857177734E+04},
 {   17517, .8380192382812E+04, -.1502020019531E+04, .1056729003906E+04},
 {   17518, .8369652343750E+04, -.1511502075195E+04, .1061447509766E+04},
 {   17519, .8357624023438E+04, -.1518548095703E+04, .1066831909180E+04},
 {   17520, .8344575195312E+04, -.1522886962891E+04, .1072674072266E+04},
 {   17521, .8388841796875E+04, -.1462985229492E+04, .1025028564453E+04},
 {   17522, .8384889648438E+04, -.1477286010742E+04, .1026797607422E+04},
 {   17523, .8378462890625E+04, -.1490466674805E+04, .1029673828125E+04},
 {   17524, .8369814453125E+04, -.1502020019531E+04, .1033545898438E+04},
 {   17525, .8359274414062E+04, -.1511502075195E+04, .1038264648438E+04},
 {   17526, .8347247070312E+04, -.1518548095703E+04, .1043648193359E+04},
 {   17527, .8334193359375E+04, -.1522886962891E+04, .1049491333008E+04},
 {   17528, .8378463867188E+04, -.1462985229492E+04, .1001844726562E+04},
 {   17529, .8374509765625E+04, -.1477286010742E+04, .1003614746094E+04},
 {   17530, .8368084960938E+04, -.1490466674805E+04, .1006490966797E+04},
 {   17531, .8359435546875E+04, -.1502020019531E+04, .1010363159180E+04},
 {   17532, .8348897460938E+04, -.1511502075195E+04, .1015081665039E+04},
 {   17533, .8336868164062E+04, -.1518548095703E+04, .1020465759277E+04},
 {   17534, .8323815429688E+04, -.1522886962891E+04, .1026307861328E+04},
 {   17535, .8368084960938E+04, -.1462985229492E+04, .9786616210938E+03},
 {   17536, .8364132812500E+04, -.1477286010742E+04, .9804317626953E+03},
 {   17537, .8357706054688E+04, -.1490466674805E+04, .9833081665039E+03},
 {   17538, .8349057617188E+04, -.1502020019531E+04, .9871795654297E+03},
 {   17539, .8338516601562E+04, -.1511502075195E+04, .9918986816406E+03},
 {   17540, .8326488281250E+04, -.1518548095703E+04, .9972828979492E+03},
 {   17541, .8313439453125E+04, -.1522886962891E+04, .1003125061035E+04},
 {   17542, .8357706054688E+04, -.1462985107422E+04, .9554790039062E+03},
 {   17543, .8353755859375E+04, -.1477286010742E+04, .9572486572266E+03},
 {   17544, .8347330078125E+04, -.1490466552734E+04, .9601246337891E+03},
 {   17545, .8338680664062E+04, -.1502020019531E+04, .9639967041016E+03},
 {   17546, .8328138671875E+04, -.1511502075195E+04, .9687159423828E+03},
 {   17547, .8316111328125E+04, -.1518548095703E+04, .9740994873047E+03},
 {   17548, .8303060546875E+04, -.1522886962891E+04, .9799417724609E+03},
 {   17549, .8347329101562E+04, -.1462985229492E+04, .9322956542969E+03},
 {   17550, .8343375000000E+04, -.1477286010742E+04, .9340655517578E+03},
 {   17551, .8336951171875E+04, -.1490466674805E+04, .9369417724609E+03},
 {   17552, .8328301757812E+04, -.1502020019531E+04, .9408137207031E+03},
 {   17553, .8317760742188E+04, -.1511502075195E+04, .9455322265625E+03},
 {   17554, .8305734375000E+04, -.1518548095703E+04, .9509165039062E+03},
 {   17555, .8292682617188E+04, -.1522886962891E+04, .9567587890625E+03},
 {   17556, .8336951171875E+04, -.1462985107422E+04, .9091128540039E+03},
 {   17557, .8332997070312E+04, -.1477286010742E+04, .9108824462891E+03},
 {   17558, .8326572265625E+04, -.1490466552734E+04, .9137589721680E+03},
 {   17559, .8317923828125E+04, -.1502020019531E+04, .9176307983398E+03},
 {   17560, .8307380859375E+04, -.1511502075195E+04, .9223493652344E+03},
 {   17561, .8295355468750E+04, -.1518548095703E+04, .9277332763672E+03},
 {   17562, .8282304687500E+04, -.1522886962891E+04, .9335756835938E+03},
 {   17563, .8320067382812E+04, -.1459621582031E+04, .8888421630859E+03},
 {   17564, .8316748046875E+04, -.1472850952148E+04, .8903279418945E+03},
 {   17565, .8311090820312E+04, -.1485091918945E+04, .8928600463867E+03},
 {   17566, .8303326171875E+04, -.1495854370117E+04, .8963367309570E+03},
 {   17567, .8293760742188E+04, -.1504707641602E+04, .9006191406250E+03},
 {   17568, .8282775390625E+04, -.1511297485352E+04, .9055363769531E+03},
 {   17569, .8270814453125E+04, -.1515359741211E+04, .9108908081055E+03},
 {   17570, .8312857421875E+04, -.1458709716797E+04, .8643573608398E+03},
 {   17571, .8308219726562E+04, -.1470877441406E+04, .8664243164062E+03},
 {   17572, .8301590820312E+04, -.1482096069336E+04, .8693775634766E+03},
 {   17573, .8293175781250E+04, -.1491927124023E+04, .8731282958984E+03},
 {   17574, .8283233398438E+04, -.1499994140625E+04, .8775591430664E+03},
 {   17575, .8272093750000E+04, -.1505998901367E+04, .8825234985352E+03},
 {   17576, .8260124023438E+04, -.1509691162109E+04, .8878583374023E+03},
 {   17577, .8247731445312E+04, -.1510951782227E+04, .8933814697266E+03},
 {   17578, .8303859375000E+04, -.1453055297852E+04, .8406124267578E+03},
 {   17579, .8297976562500E+04, -.1463752685547E+04, .8432283935547E+03},
 {   17580, .8290549804688E+04, -.1473551513672E+04, .8465323486328E+03},
 {   17581, .8281720703125E+04, -.1482093872070E+04, .8504581909180E+03},
 {   17582, .8271702148438E+04, -.1489078369141E+04, .8549136352539E+03},
 {   17583, .8260750000000E+04, -.1494278198242E+04, .8597842407227E+03},
 {   17584, .8249141601562E+04, -.1497464233398E+04, .8649467163086E+03},
 {   17585, .8237202148438E+04, -.1498567260742E+04, .8702567138672E+03},
 {   17586, .8298740234375E+04, -.1439687133789E+04, .8153104248047E+03},
 {   17587, .8291088867188E+04, -.1448416503906E+04, .8186859130859E+03},
 {   17588, .8282284179688E+04, -.1456323242188E+04, .8225702514648E+03},
 {   17589, .8272426757812E+04, -.1463160034180E+04, .8269201660156E+03},
 {   17590, .8261659179688E+04, -.1468720458984E+04, .8316697998047E+03},
 {   17591, .8250185546875E+04, -.1472861206055E+04, .8367323608398E+03},
 {   17592, .8238200195312E+04, -.1475385620117E+04, .8420206298828E+03},
 {   17593, .8225955078125E+04, -.1476276977539E+04, .8474225463867E+03},
 {   17594, .8295124023438E+04, -.1437190429688E+04, .7894098510742E+03},
 {   17595, .8285242187500E+04, -.1444530029297E+04, .7937308959961E+03},
 {   17596, .8274686523438E+04, -.1451049682617E+04, .7983468017578E+03},
 {   17597, .8263483398438E+04, -.1456610839844E+04, .8032453613281E+03},
 {   17598, .8251708007812E+04, -.1461095458984E+04, .8083939819336E+03},
 {   17599, .8239480468750E+04, -.1464437500000E+04, .8137402954102E+03},
 {   17600, .8226909179688E+04, -.1466458618164E+04, .8192377929688E+03},
 {   17601, .8214166015625E+04, -.1467194213867E+04, .8248098754883E+03},
 {   17602, .8318005859375E+04, -.1450828613281E+04, .1150653320312E+04},
 {   17603, .8321814453125E+04, -.1453232055664E+04, .1139042968750E+04},
 {   17604, .8307483398438E+04, -.1448847900391E+04, .1141268066406E+04},
 {   17605, .8317319335938E+04, -.1453232055664E+04, .1128996337891E+04},
 {   17606, .8298369140625E+04, -.1447363647461E+04, .1129759521484E+04},
 {   17607, .8312819335938E+04, -.1453232055664E+04, .1118950683594E+04},
 {   17608, .8291129882812E+04, -.1446812622070E+04, .1116601318359E+04},
 {   17609, .8308323242188E+04, -.1453232055664E+04, .1108904541016E+04},
 {   17610, .8280750000000E+04, -.1446812622070E+04, .1093418334961E+04},
 {   17611, .8297944335938E+04, -.1453232055664E+04, .1085721435547E+04},
 {   17612, .8270373046875E+04, -.1446812622070E+04, .1070235107422E+04},
 {   17613, .8287566406250E+04, -.1453232055664E+04, .1062538330078E+04},
 {   17614, .8259997070312E+04, -.1446812622070E+04, .1047051391602E+04},
 {   17615, .8277189453125E+04, -.1453232055664E+04, .1039355346680E+04},
 {   17616, .8250912109375E+04, -.1446812622070E+04, .1026767211914E+04},
 {   17617, .8268106445312E+04, -.1453232055664E+04, .1019070129395E+04},
 {   17618, .8241833984375E+04, -.1446812622070E+04, .1006481689453E+04},
 {   17619, .8259026367188E+04, -.1453232055664E+04, .9987851562500E+03},
 {   17620, .8232750976562E+04, -.1446812622070E+04, .9861966552734E+03},
 {   17621, .8249945312500E+04, -.1453232055664E+04, .9784997558594E+03},
 {   17622, .8223668945312E+04, -.1446812622070E+04, .9659114379883E+03},
 {   17623, .8240865234375E+04, -.1453232055664E+04, .9582145385742E+03},
 {   17624, .8218678710938E+04, -.1447363647461E+04, .9517468872070E+03},
 {   17625, .8236365234375E+04, -.1453232055664E+04, .9481689453125E+03},
 {   17626, .8216166015625E+04, -.1448847900391E+04, .9372829589844E+03},
 {   17627, .8231868164062E+04, -.1453232055664E+04, .9381228637695E+03},
 {   17628, .8216172851562E+04, -.1450828735352E+04, .9231839599609E+03},
 {   17629, .8227373046875E+04, -.1453232055664E+04, .9280765380859E+03},
 {   17630, .8338834960938E+04, -.1453437500000E+04, .1149289428711E+04},
 {   17631, .8359652343750E+04, -.1454502075195E+04, .1142751464844E+04},
 {   17632, .8336884765625E+04, -.1453232055664E+04, .1132296386719E+04},
 {   17633, .8351951171875E+04, -.1453232055664E+04, .1125551025391E+04},
 {   17634, .8332385742188E+04, -.1453232055664E+04, .1122250610352E+04},
 {   17635, .8347455078125E+04, -.1453232055664E+04, .1115504882812E+04},
 {   17636, .8327888671875E+04, -.1453232055664E+04, .1112204833984E+04},
 {   17637, .8342958984375E+04, -.1453232055664E+04, .1105459350586E+04},
 {   17638, .8323389648438E+04, -.1453232055664E+04, .1102158691406E+04},
 {   17639, .8338461914062E+04, -.1453232055664E+04, .1095413452148E+04},
 {   17640, .8313014648438E+04, -.1453232055664E+04, .1078975585938E+04},
 {   17641, .8328083007812E+04, -.1453232055664E+04, .1072229858398E+04},
 {   17642, .8302634765625E+04, -.1453232055664E+04, .1055793090820E+04},
 {   17643, .8317705078125E+04, -.1453232055664E+04, .1049046875000E+04},
 {   17644, .8292255859375E+04, -.1453232055664E+04, .1032609497070E+04},
 {   17645, .8307327148438E+04, -.1453232055664E+04, .1025863769531E+04},
 {   17646, .8283175781250E+04, -.1453232055664E+04, .1012324035645E+04},
 {   17647, .8298244140625E+04, -.1453232055664E+04, .1005578613281E+04},
 {   17648, .8274094726562E+04, -.1453232055664E+04, .9920388793945E+03},
 {   17649, .8289163085938E+04, -.1453232055664E+04, .9852933959961E+03},
 {   17650, .8265014648438E+04, -.1453232055664E+04, .9717537231445E+03},
 {   17651, .8280083984375E+04, -.1453232055664E+04, .9650081787109E+03},
 {   17652, .8255934570312E+04, -.1453232055664E+04, .9514685668945E+03},
 {   17653, .8271002929688E+04, -.1453232055664E+04, .9447231445312E+03},
 {   17654, .8251438476562E+04, -.1453232055664E+04, .9414225463867E+03},
 {   17655, .8266504882812E+04, -.1453232055664E+04, .9346771240234E+03},
 {   17656, .8246939453125E+04, -.1453232055664E+04, .9313767700195E+03},
 {   17657, .8262008789062E+04, -.1453232055664E+04, .9246307983398E+03},
 {   17658, .8242442382812E+04, -.1453232055664E+04, .9213309326172E+03},
 {   17659, .8257511718750E+04, -.1453232055664E+04, .9145848388672E+03},
 {   17660, .8231068359375E+04, -.1453437500000E+04, .9085563354492E+03},
 {   17661, .8249811523438E+04, -.1454502075195E+04, .8973844604492E+03},
 {   17662, .8378395507812E+04, -.1453437500000E+04, .1131579223633E+04},
 {   17663, .8393288085938E+04, -.1450828613281E+04, .1116952392578E+04},
 {   17664, .8367021484375E+04, -.1453232055664E+04, .1118804809570E+04},
 {   17665, .8382090820312E+04, -.1453232055664E+04, .1112058959961E+04},
 {   17666, .8362524414062E+04, -.1453232055664E+04, .1108758789062E+04},
 {   17667, .8377593750000E+04, -.1453232055664E+04, .1102013793945E+04},
 {   17668, .8358026367188E+04, -.1453232055664E+04, .1098713134766E+04},
 {   17669, .8373095703125E+04, -.1453232055664E+04, .1091967773438E+04},
 {   17670, .8353531250000E+04, -.1453232055664E+04, .1088666992188E+04},
 {   17671, .8368596679688E+04, -.1453232055664E+04, .1081921508789E+04},
 {   17672, .8343151367188E+04, -.1453232055664E+04, .1065483764648E+04},
 {   17673, .8358220703125E+04, -.1453232055664E+04, .1058738159180E+04},
 {   17674, .8332774414062E+04, -.1453232055664E+04, .1042301147461E+04},
 {   17675, .8347843750000E+04, -.1453232055664E+04, .1035555297852E+04},
 {   17676, .8322395507812E+04, -.1453232055664E+04, .1019117492676E+04},
 {   17677, .8337463867188E+04, -.1453232055664E+04, .1012372009277E+04},
 {   17678, .8313313476562E+04, -.1453232055664E+04, .9988328857422E+03},
 {   17679, .8328381835938E+04, -.1453232055664E+04, .9920869140625E+03},
 {   17680, .8304234375000E+04, -.1453232055664E+04, .9785473632812E+03},
 {   17681, .8319302734375E+04, -.1453232055664E+04, .9718016357422E+03},
 {   17682, .8295152343750E+04, -.1453232055664E+04, .9582623901367E+03},
 {   17683, .8310221679688E+04, -.1453232055664E+04, .9515164184570E+03},
 {   17684, .8286072265625E+04, -.1453232055664E+04, .9379769287109E+03},
 {   17685, .8301140625000E+04, -.1453232055664E+04, .9312313232422E+03},
 {   17686, .8281574218750E+04, -.1453232055664E+04, .9279310302734E+03},
 {   17687, .8296644531250E+04, -.1453232055664E+04, .9211851196289E+03},
 {   17688, .8277076171875E+04, -.1453232055664E+04, .9178851928711E+03},
 {   17689, .8292146484375E+04, -.1453232055664E+04, .9111389770508E+03},
 {   17690, .8272580078125E+04, -.1453232055664E+04, .9078392333984E+03},
 {   17691, .8287650390625E+04, -.1453232055664E+04, .9010930786133E+03},
 {   17692, .8270626953125E+04, -.1453437500000E+04, .8908463134766E+03},
 {   17693, .8291458007812E+04, -.1450828735352E+04, .8894819335938E+03},
 {   17694, .8393296875000E+04, -.1448847900391E+04, .1102852539062E+04},
 {   17695, .8390781250000E+04, -.1447363647461E+04, .1088389648438E+04},
 {   17696, .8385791992188E+04, -.1446812622070E+04, .1074223876953E+04},
 {   17697, .8375413085938E+04, -.1446812622070E+04, .1051041381836E+04},
 {   17698, .8365034179688E+04, -.1446812622070E+04, .1027858154297E+04},
 {   17699, .8354658203125E+04, -.1446812622070E+04, .1004675292969E+04},
 {   17700, .8345578125000E+04, -.1446812622070E+04, .9843897705078E+03},
 {   17701, .8336496093750E+04, -.1446812622070E+04, .9641046752930E+03},
 {   17702, .8327414062500E+04, -.1446812622070E+04, .9438195190430E+03},
 {   17703, .8318333984375E+04, -.1446812622070E+04, .9235344848633E+03},
 {   17704, .8311094726562E+04, -.1447363647461E+04, .9103767700195E+03},
 {   17705, .8301980468750E+04, -.1448847900391E+04, .8988674926758E+03},
 {   20000, .8221334960938E+04, -.1114318359375E+04, .6660175170898E+03},
 {   20001, .8229469726562E+04, -.1112345458984E+04, .6923956909180E+03},
 {   20002, .8242388671875E+04, -.1126311401367E+04, .6547593383789E+03},
 {   20003, .8299099609375E+04, -.1177436279297E+04, .6742855224609E+03},
 {   20004, .8285311523438E+04, -.1146860351562E+04, .6791268920898E+03},
 {   20005, .8297224609375E+04, -.1148205322266E+04, .7100858154297E+03},
 {   20006, .8311208984375E+04, -.1177665283203E+04, .7011039428711E+03},
 {   20007, .8264123046875E+04, -.1126217407227E+04, .6953387451172E+03},
 {   20008, .8275026367188E+04, -.1128804321289E+04, .7246196289062E+03},
 {   20009, .8304035156250E+04, -.1152812255859E+04, .7405898437500E+03},
 {   20010, .8306616210938E+04, -.1159820312500E+04, .7722965087891E+03},
 {   20011, .8321920898438E+04, -.1185097290039E+04, .7652559204102E+03},
 {   20012, .8318469726562E+04, -.1180184204102E+04, .7306381835938E+03},
 {   20013, .8281583984375E+04, -.1133493408203E+04, .7528951416016E+03},
 {   20014, .8286395507812E+04, -.1141610351562E+04, .7815134277344E+03},
 {   20015, .8303175781250E+04, -.1206579223633E+04, .6731119384766E+03},
 {   20016, .8315314453125E+04, -.1206553222656E+04, .6989295654297E+03},
 {   20017, .8263010742188E+04, -.1179743286133E+04, .6144863281250E+03},
 {   20018, .8256654296875E+04, -.1153607299805E+04, .6269889526367E+03},
 {   20019, .8268521484375E+04, -.1148243286133E+04, .6489467773438E+03},
 {   20020, .8281695312500E+04, -.1177579223633E+04, .6417368164062E+03},
 {   20021, .8233368164062E+04, -.1137639404297E+04, .6242036743164E+03},
 {   20022, .8232829101562E+04, -.1171894287109E+04, .5965442504883E+03},
 {   20023, .8242522460938E+04, -.1113764404297E+04, .7139424438477E+03},
 {   20024, .8252968750000E+04, -.1119171386719E+04, .7371580200195E+03},
 {   20025, .8262209960938E+04, -.1125983398438E+04, .7648962402344E+03},
 {   20026, .8273609375000E+04, -.1133339355469E+04, .7883507690430E+03},
 {   20027, .8215849609375E+04, -.1120537353516E+04, .6435011596680E+03},
 {   20028, .8184347167969E+04, -.1112431396484E+04, .6478016967773E+03},
 {   20029, .8194059570312E+04, -.1105350463867E+04, .6752220458984E+03},
 {   20030, .8205533203125E+04, -.1104609375000E+04, .7021431274414E+03},
 {   20031, .8150839843750E+04, -.1107752441406E+04, .6574788818359E+03},
 {   20032, .8164010253906E+04, -.1100643432617E+04, .6847281494141E+03},
 {   20033, .8324293945312E+04, -.1291211059570E+04, .7933649902344E+03},
 {   20034, .8328677734375E+04, -.1292647094727E+04, .7941295166016E+03},
 {   20035, .8330552734375E+04, -.1249544189453E+04, .8016476440430E+03},
 {   20036, .8326376953125E+04, -.1257984130859E+04, .7993178100586E+03},
 {   20037, .8325506835938E+04, -.1291203002930E+04, .7721834106445E+03},
 {   20038, .8326670898438E+04, -.1253477172852E+04, .7777946166992E+03},
 {   20039, .8330956054688E+04, -.1230569213867E+04, .8056950073242E+03},
 {   20040, .8324666992188E+04, -.1231558105469E+04, .8057034301758E+03},
 {   20041, .8327803710938E+04, -.1231919189453E+04, .7806319580078E+03},
 {   20042, .8329578125000E+04, -.1211952148438E+04, .8082604980469E+03},
 {   20043, .8320123046875E+04, -.1205905273438E+04, .8118612670898E+03},
 {   20044, .8326210937500E+04, -.1210230224609E+04, .7847802734375E+03},
 {   20045, .8325854492188E+04, -.1191636230469E+04, .8103929443359E+03},
 {   20046, .8310490234375E+04, -.1183226196289E+04, .8164830322266E+03},
 {   20047, .8322251953125E+04, -.1187901245117E+04, .7905787353516E+03},
 {   20048, .8315116210938E+04, -.1168847290039E+04, .8143828125000E+03},
 {   20049, .8296639648438E+04, -.1149485351562E+04, .8216397705078E+03},
 {   20050, .8309751953125E+04, -.1163604248047E+04, .7964669189453E+03},
 {   20051, .8290714843750E+04, -.1144871337891E+04, .8043790893555E+03},
 {   20052, .8284549804688E+04, -.1142659301758E+04, .8269224853516E+03},
 {   20053, .8292534179688E+04, -.1167934326172E+04, .8244078369141E+03},
 {   20054, .8279395507812E+04, -.1139439331055E+04, .8099572753906E+03},
 {   20055, .8263810546875E+04, -.1137565307617E+04, .8353657836914E+03},
 {   20056, .8270958007812E+04, -.1154444335938E+04, .8339989013672E+03},
 {   20057, .8259363281250E+04, -.1134420410156E+04, .8190068359375E+03},
 {   20058, .8249296875000E+04, -.1139257324219E+04, .8422262573242E+03},
 {   20059, .8247178710938E+04, -.1147031372070E+04, .8446380004883E+03},
 {   20060, .8237533203125E+04, -.1135059326172E+04, .8268518066406E+03},
 {   20061, .8218426757812E+04, -.1145035400391E+04, .8566428833008E+03},
 {   20062, .8221731445312E+04, -.1148524291992E+04, .8557681274414E+03},
 {   20063, .8208824218750E+04, -.1142715332031E+04, .8412341308594E+03},
 {   20064, .8186823242188E+04, -.1155191284180E+04, .8524267578125E+03},
 {   20065, .8195674804688E+04, -.1156751342773E+04, .8675089111328E+03},
 {   20066, .8198276367188E+04, -.1158225341797E+04, .8669866943359E+03},
 {   20067, .8168103515625E+04, -.1172313232422E+04, .8601078491211E+03},
 {   20068, .8178054199219E+04, -.1175817260742E+04, .8755500488281E+03},
 {   20069, .8186426757812E+04, -.1169875244141E+04, .8735729980469E+03},
 {   20070, .8155001953125E+04, -.1191598266602E+04, .8648604736328E+03},
 {   20071, .8165515136719E+04, -.1198578247070E+04, .8819425659180E+03},
 {   20072, .8172717773438E+04, -.1190911254883E+04, .8804022827148E+03},
 {   20073, .8144407226562E+04, -.1213425170898E+04, .8686635742188E+03},
 {   20074, .8157070800781E+04, -.1220638183594E+04, .8856065673828E+03},
 {   20075, .8163945312500E+04, -.1213534179688E+04, .8830734863281E+03},
 {   20076, .8133422851562E+04, -.1239191162109E+04, .8694008178711E+03},
 {   20077, .8149476074219E+04, -.1242614135742E+04, .8890161132812E+03},
 {   20078, .8154448242188E+04, -.1236709106445E+04, .8880517578125E+03},
 {   20079, .8146138671875E+04, -.1263442138672E+04, .8910945434570E+03},
 {   20080, .8148759277344E+04, -.1260926147461E+04, .8902681884766E+03},
 {   20081, .8130820800781E+04, -.1261780151367E+04, .8703256225586E+03},
 {   20082, .8144522460938E+04, -.1288301025391E+04, .8918510742188E+03},
 {   20083, .8149380371094E+04, -.1291211059570E+04, .8907600097656E+03},
 {   20084, .8130681640625E+04, -.1288523071289E+04, .8703189086914E+03},
 {   20085, .8111149414062E+04, -.1288110107422E+04, .8493769531250E+03},
 {   20086, .8111573730469E+04, -.1259650146484E+04, .8493336181641E+03},
 {   20087, .8115351562500E+04, -.1234543212891E+04, .8478386230469E+03},
 {   20088, .8130904296875E+04, -.1204896240234E+04, .8478902587891E+03},
 {   20089, .8145407226562E+04, -.1185384277344E+04, .8428988037109E+03},
 {   20090, .8160942382812E+04, -.1168306274414E+04, .8375796508789E+03},
 {   20091, .8176873046875E+04, -.1150780273438E+04, .8299720458984E+03},
 {   20092, .8197159179688E+04, -.1135787353516E+04, .8180693359375E+03},
 {   20093, .8324658203125E+04, -.1254077148438E+04, .7522008666992E+03},
 {   20094, .8327187500000E+04, -.1233545166016E+04, .7535158081055E+03},
 {   20095, .8321255859375E+04, -.1291017089844E+04, .7504875488281E+03},
 {   20096, .8326854492188E+04, -.1209160156250E+04, .7607690429688E+03},
 {   20097, .8252541992188E+04, -.1128946411133E+04, .7955891723633E+03},
 {   20098, .8218214843750E+04, -.1128661376953E+04, .8025316772461E+03},
 {   20099, .8096734863281E+04, -.1257945068359E+04, .8162101440430E+03},
 {   20100, .8092711914062E+04, -.1289028076172E+04, .8066590576172E+03},
 {   20101, .8103931640625E+04, -.1233679199219E+04, .8200980834961E+03},
 {   20102, .8122844238281E+04, -.1200506225586E+04, .8221862792969E+03},
 {   20103, .8139534179688E+04, -.1183268310547E+04, .8191456909180E+03},
 {   20104, .8152487304688E+04, -.1163298339844E+04, .8143187255859E+03},
 {   20105, .8166030273438E+04, -.1144855346680E+04, .8088356323242E+03},
 {   20106, .8185244628906E+04, -.1131825317383E+04, .7927114257812E+03},
 {   20107, .8206840820312E+04, -.1124989379883E+04, .7800773925781E+03},
 {   20108, .8234409179688E+04, -.1122424438477E+04, .7728263549805E+03},
 {   20109, .8315448242188E+04, -.1290112060547E+04, .7311929931641E+03},
 {   20110, .8321006835938E+04, -.1256509155273E+04, .7282465209961E+03},
 {   20111, .8324354492188E+04, -.1234243164062E+04, .7283739013672E+03},
 {   20112, .8323921875000E+04, -.1207326171875E+04, .7286352539062E+03},
 {   20113, .8307087890625E+04, -.1288179077148E+04, .7058951416016E+03},
 {   20114, .8312444335938E+04, -.1259360107422E+04, .7018990478516E+03},
 {   20115, .8293073242188E+04, -.1288069091797E+04, .6754035034180E+03},
 {   20116, .8299047851562E+04, -.1258765136719E+04, .6730797119141E+03},
 {   20117, .8211672851562E+04, -.1286820068359E+04, .6126928710938E+03},
 {   20118, .8171599121094E+04, -.1287780029297E+04, .6262720947266E+03},
 {   20119, .8165477539062E+04, -.1263824096680E+04, .6123370971680E+03},
 {   20120, .8203986328125E+04, -.1264952148438E+04, .5999550781250E+03},
 {   20121, .8144112792969E+04, -.1287884033203E+04, .6410380249023E+03},
 {   20122, .8138145019531E+04, -.1265367065430E+04, .6279558715820E+03},
 {   20123, .8118280273438E+04, -.1288359008789E+04, .6585221557617E+03},
 {   20124, .8112353515625E+04, -.1267026123047E+04, .6448267211914E+03},
 {   20125, .8094773437500E+04, -.1288265014648E+04, .6788886108398E+03},
 {   20126, .8087403808594E+04, -.1267705078125E+04, .6617024536133E+03},
 {   20127, .8088764648438E+04, -.1256013061523E+04, .7835079345703E+03},
 {   20128, .8081342285156E+04, -.1288519042969E+04, .7659102783203E+03},
 {   20129, .8095461425781E+04, -.1232320190430E+04, .7945558471680E+03},
 {   20130, .8195972656250E+04, -.1120557373047E+04, .7605704345703E+03},
 {   20131, .8224050781250E+04, -.1116907348633E+04, .7486752929688E+03},
 {   20132, .8315974609375E+04, -.1234570190430E+04, .7002612304688E+03},
 {   20133, .8304290039062E+04, -.1234104125977E+04, .6735903930664E+03},
 {   20134, .8274801757812E+04, -.1259677124023E+04, .6383092041016E+03},
 {   20135, .8286048828125E+04, -.1234428222656E+04, .6402947387695E+03},
 {   20136, .8286306640625E+04, -.1205487182617E+04, .6385345458984E+03},
 {   20137, .8266165039062E+04, -.1203543212891E+04, .6110313110352E+03},
 {   20138, .8231732421875E+04, -.1202794189453E+04, .5888987426758E+03},
 {   20139, .8200819335938E+04, -.1200527221680E+04, .5887554321289E+03},
 {   20140, .8159269531250E+04, -.1199795288086E+04, .6012469482422E+03},
 {   20141, .8165377929688E+04, -.1161652343750E+04, .6057780761719E+03},
 {   20142, .8196077148438E+04, -.1167313232422E+04, .5963555297852E+03},
 {   20143, .8203892578125E+04, -.1235326171875E+04, .5892828369141E+03},
 {   20144, .8160936523438E+04, -.1232803222656E+04, .6023351440430E+03},
 {   20145, .8132830566406E+04, -.1238016113281E+04, .6170338134766E+03},
 {   20146, .8205527343750E+04, -.1130065429688E+04, .6216671142578E+03},
 {   20147, .8175817382812E+04, -.1127211425781E+04, .6244683837891E+03},
 {   20148, .8129320312500E+04, -.1210305175781E+04, .6145715942383E+03},
 {   20149, .8138049316406E+04, -.1099878417969E+04, .6917573852539E+03},
 {   20150, .8148526367188E+04, -.1101249511719E+04, .7194396972656E+03},
 {   20151, .8175356933594E+04, -.1100600463867E+04, .7118104858398E+03},
 {   20152, .8091757812500E+04, -.1098491455078E+04, .7408794555664E+03},
 {   20153, .8081135742188E+04, -.1097532470703E+04, .7133184814453E+03},
 {   20154, .8054524902344E+04, -.1097082397461E+04, .7250893554688E+03},
 {   20155, .8065468750000E+04, -.1098695434570E+04, .7522424316406E+03},
 {   20156, .8055509277344E+04, -.1141020385742E+04, .7278684692383E+03},
 {   20157, .8065304199219E+04, -.1140851318359E+04, .7519920654297E+03},
 {   20158, .8069968261719E+04, -.1105681396484E+04, .6867026977539E+03},
 {   20159, .8043460449219E+04, -.1105169433594E+04, .6973512573242E+03},
 {   20160, .8046650390625E+04, -.1153991333008E+04, .7060902709961E+03},
 {   20161, .8119084960938E+04, -.1099408447266E+04, .7300857543945E+03},
 {   20162, .8128294921875E+04, -.1107725341797E+04, .7546955566406E+03},
 {   20163, .8158488769531E+04, -.1109361450195E+04, .7437252197266E+03},
 {   20164, .8097947753906E+04, -.1105370483398E+04, .6759517822266E+03},
 {   20165, .8109070312500E+04, -.1098141479492E+04, .7023973388672E+03},
 {   20166, .8129680664062E+04, -.1105771484375E+04, .6646010742188E+03},
 {   20167, .8101479003906E+04, -.1107557373047E+04, .7658840942383E+03},
 {   20168, .8056329101562E+04, -.1246314086914E+04, .6612705078125E+03},
 {   20169, .8052044433594E+04, -.1217843261719E+04, .6512761230469E+03},
 {   20170, .8076268066406E+04, -.1216546264648E+04, .6394502563477E+03},
 {   20171, .8080723632812E+04, -.1244320190430E+04, .6475759277344E+03},
 {   20172, .8101765136719E+04, -.1214186157227E+04, .6271171264648E+03},
 {   20173, .8106033691406E+04, -.1241980224609E+04, .6327735595703E+03},
 {   20174, .8051527343750E+04, -.1186785278320E+04, .6493507690430E+03},
 {   20175, .8075404296875E+04, -.1186200317383E+04, .6384702148438E+03},
 {   20176, .8098152343750E+04, -.1180493286133E+04, .6285466308594E+03},
 {   20177, .8034166992188E+04, -.1127027343750E+04, .6748286132812E+03},
 {   20178, .8060100585938E+04, -.1126598388672E+04, .6648012695312E+03},
 {   20179, .8053860839844E+04, -.1156166259766E+04, .6528675537109E+03},
 {   20180, .8029395019531E+04, -.1156485351562E+04, .6630393066406E+03},
 {   20181, .8027741210938E+04, -.1187414306641E+04, .6596500244141E+03},
 {   20182, .8043501953125E+04, -.1188334228516E+04, .6975463256836E+03},
 {   20183, .8028528320312E+04, -.1218845214844E+04, .6623579711914E+03},
 {   20184, .8045303710938E+04, -.1211430175781E+04, .7024004516602E+03},
 {   20185, .8033191406250E+04, -.1248106201172E+04, .6734692382812E+03},
 {   20186, .8048331054688E+04, -.1227091186523E+04, .7103623046875E+03},
 {   20187, .8062511718750E+04, -.1266017089844E+04, .6768580932617E+03},
 {   20188, .8040392578125E+04, -.1266042114258E+04, .6913593750000E+03},
 {   20189, .8052332519531E+04, -.1243902099609E+04, .7202362060547E+03},
 {   20190, .8086851074219E+04, -.1125932373047E+04, .6537277221680E+03},
 {   20191, .8115416015625E+04, -.1123579345703E+04, .6444545288086E+03},
 {   20192, .8084512695312E+04, -.1155476318359E+04, .6389169311523E+03},
 {   20193, .8086760742188E+04, -.1149685302734E+04, .8060927734375E+03},
 {   20194, .8116174316406E+04, -.1138355346680E+04, .7895264282227E+03},
 {   20195, .8111163085938E+04, -.1124782348633E+04, .7837799072266E+03},
 {   20196, .8083423339844E+04, -.1127811401367E+04, .7967877807617E+03},
 {   20197, .8075661621094E+04, -.1109023437500E+04, .7773757934570E+03},
 {   20198, .8075063964844E+04, -.1148791381836E+04, .7760114135742E+03},
 {   20199, .8128913574219E+04, -.1182853271484E+04, .6151767578125E+03},
 {   20200, .8134738281250E+04, -.1155548339844E+04, .6237980346680E+03},
 {   20201, .8181341308594E+04, -.1110169433594E+04, .7340070190430E+03},
 {   20202, .8174425781250E+04, -.1128941406250E+04, .7710006103516E+03},
 {   20203, .8072874023438E+04, -.1288301025391E+04, .6984991455078E+03},
 {   20204, .8110505371094E+04, -.1154320312500E+04, .7963269042969E+03},
 {   20205, .8108873535156E+04, -.1201780273438E+04, .8005902709961E+03},
 {   20206, .8087224121094E+04, -.1201870239258E+04, .8049542236328E+03},
 {   20207, .8083112304688E+04, -.1231622192383E+04, .7955129394531E+03},
 {   20208, .8074904785156E+04, -.1198142211914E+04, .7757004394531E+03},
 {   20209, .8071464843750E+04, -.1215212158203E+04, .7672632446289E+03},
 {   20210, .8065278320312E+04, -.1276084106445E+04, .7507579345703E+03},
 {   20211, .8061203125000E+04, -.1278615112305E+04, .7414506835938E+03},
 {   20212, .8078462890625E+04, -.1288520019531E+04, .7356887207031E+03},
 {   20213, .8079957031250E+04, -.1288520019531E+04, .7464848022461E+03},
 {   20214, .8066072265625E+04, -.1229176147461E+04, .7540221557617E+03},
 {   20215, .8060829101562E+04, -.1237423217773E+04, .7411442871094E+03},
 {   20216, .8077708496094E+04, -.1251429077148E+04, .7835180053711E+03},
 {   20217, .8071136230469E+04, -.1268609130859E+04, .7646463012695E+03},
 {   20218, .8118741699219E+04, -.1177570312500E+04, .8021271362305E+03},
 {   20219, .8101439941406E+04, -.1177667236328E+04, .8018574829102E+03},
 {   20220, .8088340820312E+04, -.1176907226562E+04, .8077891845703E+03},
 {   20221, .8075062500000E+04, -.1178300292969E+04, .7760585327148E+03},
 {   20222, .8133506835938E+04, -.1154350341797E+04, .7969713134766E+03},
 {   20223, .8056005859375E+04, -.1278842041016E+04, .7291827392578E+03},
 {   20224, .8078709960938E+04, -.1288425048828E+04, .7162497558594E+03},
 {   20225, .8049120117188E+04, -.1276445068359E+04, .7123823242188E+03},
 {   20226, .8118954589844E+04, -.1148256347656E+04, .6276500244141E+03},
 {   20227, .8139469238281E+04, -.1127862426758E+04, .6322988281250E+03},
 {   20228, .8147543945312E+04, -.1132300292969E+04, .7867094726562E+03},
 {   20229, .8212941406250E+04, -.1107603393555E+04, .7264933471680E+03},
 {   20230, .8142623046875E+04, -.1116760375977E+04, .7770410156250E+03},
 {   20231, .8267002929688E+04, -.1235521118164E+04, .6133294677734E+03},
 {   20232, .8232994140625E+04, -.1236648193359E+04, .5914793701172E+03},
 {   20233, .8267757812500E+04, -.1263253173828E+04, .6262641601562E+03},
 {   20234, .8236414062500E+04, -.1266578125000E+04, .6038491821289E+03},
 {   20235, .8258668945312E+04, -.1288181030273E+04, .6293937377930E+03},
 {   20236, .8240596679688E+04, -.1288595092773E+04, .6167203369141E+03},
 {   20237, .8242388671875E+04, -.1450290771484E+04, .6547593383789E+03},
 {   20238, .8229469726562E+04, -.1464256713867E+04, .6923957519531E+03},
 {   20239, .8221334960938E+04, -.1462283691406E+04, .6660175170898E+03},
 {   20240, .8297224609375E+04, -.1428396728516E+04, .7100858154297E+03},
 {   20241, .8285311523438E+04, -.1429741821289E+04, .6791270141602E+03},
 {   20242, .8299099609375E+04, -.1399165771484E+04, .6742855224609E+03},
 {   20243, .8311208984375E+04, -.1398936767578E+04, .7011040649414E+03},
 {   20244, .8275026367188E+04, -.1447797729492E+04, .7246196289062E+03},
 {   20245, .8264123046875E+04, -.1450384765625E+04, .6953387451172E+03},
 {   20246, .8321920898438E+04, -.1391504882812E+04, .7652559204102E+03},
 {   20247, .8306616210938E+04, -.1416781738281E+04, .7722966308594E+03},
 {   20248, .8304035156250E+04, -.1423789794922E+04, .7405898437500E+03},
 {   20249, .8318469726562E+04, -.1396417846680E+04, .7306381835938E+03},
 {   20250, .8286395507812E+04, -.1434991699219E+04, .7815134277344E+03},
 {   20251, .8281583984375E+04, -.1443108764648E+04, .7528951416016E+03},
 {   20252, .8303175781250E+04, -.1370022949219E+04, .6731120605469E+03},
 {   20253, .8315314453125E+04, -.1370048828125E+04, .6989295654297E+03},
 {   20254, .8268521484375E+04, -.1428358764648E+04, .6489467773438E+03},
 {   20255, .8256655273438E+04, -.1422994873047E+04, .6269889526367E+03},
 {   20256, .8263010742188E+04, -.1396858886719E+04, .6144863281250E+03},
 {   20257, .8281695312500E+04, -.1399022827148E+04, .6417368164062E+03},
 {   20258, .8233368164062E+04, -.1438962768555E+04, .6242036743164E+03},
 {   20259, .8232829101562E+04, -.1404707885742E+04, .5965442504883E+03},
 {   20260, .8252968750000E+04, -.1457430664062E+04, .7371580200195E+03},
 {   20261, .8242522460938E+04, -.1462837646484E+04, .7139425048828E+03},
 {   20262, .8273609375000E+04, -.1443262695312E+04, .7883507690430E+03},
 {   20263, .8262209960938E+04, -.1450618774414E+04, .7648962402344E+03},
 {   20264, .8215849609375E+04, -.1456064697266E+04, .6435011596680E+03},
 {   20265, .8194059570312E+04, -.1471251708984E+04, .6752220458984E+03},
 {   20266, .8184347167969E+04, -.1464170654297E+04, .6478016967773E+03},
 {   20267, .8205533203125E+04, -.1471992675781E+04, .7021431884766E+03},
 {   20268, .8164010253906E+04, -.1475958618164E+04, .6847282714844E+03},
 {   20269, .8150839843750E+04, -.1468849731445E+04, .6574788818359E+03},
 {   20270, .8326376953125E+04, -.1324437988281E+04, .7993178100586E+03},
 {   20271, .8330552734375E+04, -.1327057983398E+04, .8016476440430E+03},
 {   20272, .8326670898438E+04, -.1323125000000E+04, .7777946166992E+03},
 {   20273, .8324666992188E+04, -.1345043945312E+04, .8057034301758E+03},
 {   20274, .8330956054688E+04, -.1346032958984E+04, .8056951293945E+03},
 {   20275, .8327803710938E+04, -.1344682983398E+04, .7806320800781E+03},
 {   20276, .8329578125000E+04, -.1364649902344E+04, .8082604980469E+03},
 {   20277, .8320123046875E+04, -.1370696899414E+04, .8118612670898E+03},
 {   20278, .8326210937500E+04, -.1366371826172E+04, .7847802734375E+03},
 {   20279, .8325854492188E+04, -.1384965820312E+04, .8103929443359E+03},
 {   20280, .8310490234375E+04, -.1393375854492E+04, .8164830322266E+03},
 {   20281, .8322251953125E+04, -.1388700805664E+04, .7905787353516E+03},
 {   20282, .8315116210938E+04, -.1407754760742E+04, .8143828125000E+03},
 {   20283, .8296639648438E+04, -.1427116821289E+04, .8216397705078E+03},
 {   20284, .8290714843750E+04, -.1431730712891E+04, .8043790893555E+03},
 {   20285, .8309751953125E+04, -.1412997802734E+04, .7964669189453E+03},
 {   20286, .8284549804688E+04, -.1433942749023E+04, .8269224853516E+03},
 {   20287, .8292534179688E+04, -.1408667846680E+04, .8244079589844E+03},
 {   20288, .8279395507812E+04, -.1437162719727E+04, .8099573974609E+03},
 {   20289, .8263810546875E+04, -.1439036743164E+04, .8353657836914E+03},
 {   20290, .8270958007812E+04, -.1422157836914E+04, .8339989013672E+03},
 {   20291, .8259363281250E+04, -.1442181762695E+04, .8190068359375E+03},
 {   20292, .8249296875000E+04, -.1437344726562E+04, .8422263793945E+03},
 {   20293, .8247178710938E+04, -.1429570800781E+04, .8446380004883E+03},
 {   20294, .8237533203125E+04, -.1441542724609E+04, .8268518066406E+03},
 {   20295, .8218426757812E+04, -.1431566772461E+04, .8566430053711E+03},
 {   20296, .8208824218750E+04, -.1433886718750E+04, .8412341308594E+03},
 {   20297, .8221731445312E+04, -.1428077758789E+04, .8557681274414E+03},
 {   20298, .8198276367188E+04, -.1418376708984E+04, .8669868164062E+03},
 {   20299, .8195674804688E+04, -.1419850830078E+04, .8675089111328E+03},
 {   20300, .8186823242188E+04, -.1421410766602E+04, .8524267578125E+03},
 {   20301, .8186426757812E+04, -.1406726806641E+04, .8735729980469E+03},
 {   20302, .8178054199219E+04, -.1400784790039E+04, .8755500488281E+03},
 {   20303, .8168103515625E+04, -.1404288818359E+04, .8601078491211E+03},
 {   20304, .8172717773438E+04, -.1385690917969E+04, .8804022827148E+03},
 {   20305, .8165515136719E+04, -.1378023925781E+04, .8819425659180E+03},
 {   20306, .8155001953125E+04, -.1385003906250E+04, .8648604736328E+03},
 {   20307, .8163945312500E+04, -.1363067871094E+04, .8830734863281E+03},
 {   20308, .8157070800781E+04, -.1355963867188E+04, .8856065673828E+03},
 {   20309, .8144407226562E+04, -.1363176879883E+04, .8686635742188E+03},
 {   20310, .8154448242188E+04, -.1339892944336E+04, .8880517578125E+03},
 {   20311, .8149476074219E+04, -.1333987915039E+04, .8890161132812E+03},
 {   20312, .8133422851562E+04, -.1337410888672E+04, .8694008178711E+03},
 {   20313, .8146138671875E+04, -.1313160034180E+04, .8910945434570E+03},
 {   20314, .8130820800781E+04, -.1314822021484E+04, .8703256225586E+03},
 {   20315, .8148759277344E+04, -.1315676025391E+04, .8902681884766E+03},
 {   20316, .8111573730469E+04, -.1316952026367E+04, .8493336181641E+03},
 {   20317, .8115351562500E+04, -.1342058959961E+04, .8478386230469E+03},
 {   20318, .8130904296875E+04, -.1371705932617E+04, .8478902587891E+03},
 {   20319, .8145407226562E+04, -.1391217895508E+04, .8428988037109E+03},
 {   20320, .8160942382812E+04, -.1408295776367E+04, .8375796508789E+03},
 {   20321, .8176873046875E+04, -.1425821777344E+04, .8299720458984E+03},
 {   20322, .8197159179688E+04, -.1440814697266E+04, .8180693359375E+03},
 {   20323, .8324658203125E+04, -.1322525024414E+04, .7522008666992E+03},
 {   20324, .8327187500000E+04, -.1343056884766E+04, .7535158081055E+03},
 {   20325, .8326854492188E+04, -.1367441894531E+04, .7607690429688E+03},
 {   20326, .8252541992188E+04, -.1447655761719E+04, .7955891723633E+03},
 {   20327, .8218214843750E+04, -.1447940673828E+04, .8025316772461E+03},
 {   20328, .8096734863281E+04, -.1318656982422E+04, .8162101440430E+03},
 {   20329, .8103931640625E+04, -.1342922973633E+04, .8200980834961E+03},
 {   20330, .8122844238281E+04, -.1376095825195E+04, .8221862792969E+03},
 {   20331, .8139534179688E+04, -.1393333862305E+04, .8191458129883E+03},
 {   20332, .8152487304688E+04, -.1413303833008E+04, .8143187255859E+03},
 {   20333, .8166030273438E+04, -.1431746826172E+04, .8088356323242E+03},
 {   20334, .8185244628906E+04, -.1444776733398E+04, .7927115478516E+03},
 {   20335, .8206840820312E+04, -.1451612792969E+04, .7800773925781E+03},
 {   20336, .8234409179688E+04, -.1454177734375E+04, .7728263549805E+03},
 {   20337, .8321006835938E+04, -.1320093017578E+04, .7282465209961E+03},
 {   20338, .8324354492188E+04, -.1342358886719E+04, .7283739013672E+03},
 {   20339, .8323921875000E+04, -.1369275878906E+04, .7286352539062E+03},
 {   20340, .8312444335938E+04, -.1317241943359E+04, .7018990478516E+03},
 {   20341, .8298801757812E+04, -.1315868041992E+04, .6731243286133E+03},
 {   20342, .8203986328125E+04, -.1311650024414E+04, .5999550781250E+03},
 {   20343, .8165477539062E+04, -.1312778076172E+04, .6123370971680E+03},
 {   20344, .8138145019531E+04, -.1311234985352E+04, .6279558715820E+03},
 {   20345, .8112353515625E+04, -.1309576049805E+04, .6448267211914E+03},
 {   20346, .8087403808594E+04, -.1308896972656E+04, .6617024536133E+03},
 {   20347, .8088764648438E+04, -.1320588989258E+04, .7835079345703E+03},
 {   20348, .8095461425781E+04, -.1344281982422E+04, .7945558471680E+03},
 {   20349, .8195972656250E+04, -.1456044677734E+04, .7605704345703E+03},
 {   20350, .8224050781250E+04, -.1459694702148E+04, .7486752929688E+03},
 {   20351, .8304290039062E+04, -.1342497924805E+04, .6735903930664E+03},
 {   20352, .8315974609375E+04, -.1342031982422E+04, .7002612304688E+03},
 {   20353, .8286048828125E+04, -.1342173950195E+04, .6402947387695E+03},
 {   20354, .8275472656250E+04, -.1316133056641E+04, .6379448242188E+03},
 {   20355, .8286306640625E+04, -.1371114868164E+04, .6385346679688E+03},
 {   20356, .8266165039062E+04, -.1373058837891E+04, .6110313110352E+03},
 {   20357, .8231732421875E+04, -.1373807861328E+04, .5888987426758E+03},
 {   20358, .8165377929688E+04, -.1414949829102E+04, .6057780761719E+03},
 {   20359, .8159269531250E+04, -.1376806884766E+04, .6012469482422E+03},
 {   20360, .8200819335938E+04, -.1376074951172E+04, .5887555541992E+03},
 {   20361, .8196077148438E+04, -.1409288818359E+04, .5963555297852E+03},
 {   20362, .8160936523438E+04, -.1343798950195E+04, .6023351440430E+03},
 {   20363, .8203892578125E+04, -.1341276000977E+04, .5892828369141E+03},
 {   20364, .8132830566406E+04, -.1338585937500E+04, .6170338134766E+03},
 {   20365, .8205527343750E+04, -.1446536743164E+04, .6216671142578E+03},
 {   20366, .8175817382812E+04, -.1449390747070E+04, .6244683837891E+03},
 {   20367, .8129320312500E+04, -.1366296875000E+04, .6145717163086E+03},
 {   20368, .8175356933594E+04, -.1476001586914E+04, .7118104858398E+03},
 {   20369, .8148526367188E+04, -.1475352661133E+04, .7194397583008E+03},
 {   20370, .8138049316406E+04, -.1476723632812E+04, .6917573852539E+03},
 {   20371, .8054524902344E+04, -.1479519653320E+04, .7250893554688E+03},
 {   20372, .8081135742188E+04, -.1479069702148E+04, .7133186035156E+03},
 {   20373, .8091757812500E+04, -.1478110717773E+04, .7408794555664E+03},
 {   20374, .8065468750000E+04, -.1477906616211E+04, .7522425537109E+03},
 {   20375, .8065304199219E+04, -.1435750732422E+04, .7519920654297E+03},
 {   20376, .8055509277344E+04, -.1435581787109E+04, .7278684692383E+03},
 {   20377, .8069968261719E+04, -.1470920654297E+04, .6867026977539E+03},
 {   20378, .8043460449219E+04, -.1471432617188E+04, .6973512573242E+03},
 {   20379, .8046650390625E+04, -.1422610839844E+04, .7060902709961E+03},
 {   20380, .8158488769531E+04, -.1467240722656E+04, .7437252197266E+03},
 {   20381, .8128294921875E+04, -.1468876708984E+04, .7546956176758E+03},
 {   20382, .8119084960938E+04, -.1477193603516E+04, .7300857543945E+03},
 {   20383, .8129680664062E+04, -.1470830688477E+04, .6646010742188E+03},
 {   20384, .8109070312500E+04, -.1478460693359E+04, .7023973388672E+03},
 {   20385, .8097947753906E+04, -.1471231689453E+04, .6759517822266E+03},
 {   20386, .8101479003906E+04, -.1469044677734E+04, .7658840942383E+03},
 {   20387, .8076268066406E+04, -.1360055908203E+04, .6394502563477E+03},
 {   20388, .8052044433594E+04, -.1358758911133E+04, .6512762451172E+03},
 {   20389, .8056329101562E+04, -.1330287963867E+04, .6612705078125E+03},
 {   20390, .8080723632812E+04, -.1332281982422E+04, .6475759277344E+03},
 {   20391, .8101765136719E+04, -.1362415893555E+04, .6271171264648E+03},
 {   20392, .8106033691406E+04, -.1334621948242E+04, .6327735595703E+03},
 {   20393, .8075404296875E+04, -.1390401855469E+04, .6384703369141E+03},
 {   20394, .8051527343750E+04, -.1389816894531E+04, .6493507690430E+03},
 {   20395, .8098152343750E+04, -.1396108886719E+04, .6285466308594E+03},
 {   20396, .8053860839844E+04, -.1420435791016E+04, .6528675537109E+03},
 {   20397, .8060100585938E+04, -.1450003662109E+04, .6648012695312E+03},
 {   20398, .8034166992188E+04, -.1449574707031E+04, .6748286132812E+03},
 {   20399, .8029395019531E+04, -.1420116821289E+04, .6630393066406E+03},
 {   20400, .8027741210938E+04, -.1389187866211E+04, .6596500244141E+03},
 {   20401, .8043501953125E+04, -.1388267822266E+04, .6975463256836E+03},
 {   20402, .8028528320312E+04, -.1357756958008E+04, .6623579711914E+03},
 {   20403, .8045303710938E+04, -.1365171875000E+04, .7024004516602E+03},
 {   20404, .8033191406250E+04, -.1328495971680E+04, .6734692382812E+03},
 {   20405, .8048331054688E+04, -.1349510986328E+04, .7103623046875E+03},
 {   20406, .8062511718750E+04, -.1310584960938E+04, .6768580932617E+03},
 {   20407, .8040392578125E+04, -.1310560058594E+04, .6913593750000E+03},
 {   20408, .8052332519531E+04, -.1332699951172E+04, .7202362060547E+03},
 {   20409, .8084512695312E+04, -.1421125732422E+04, .6389169311523E+03},
 {   20410, .8115416015625E+04, -.1453022705078E+04, .6444545288086E+03},
 {   20411, .8086851074219E+04, -.1450669677734E+04, .6537278442383E+03},
 {   20412, .8111163085938E+04, -.1451819702148E+04, .7837799072266E+03},
 {   20413, .8116174316406E+04, -.1438246826172E+04, .7895264282227E+03},
 {   20414, .8086760742188E+04, -.1426916748047E+04, .8060928955078E+03},
 {   20415, .8083423339844E+04, -.1448790771484E+04, .7967877807617E+03},
 {   20416, .8075063964844E+04, -.1427810791016E+04, .7760114135742E+03},
 {   20417, .8075661621094E+04, -.1467578735352E+04, .7773757934570E+03},
 {   20418, .8128913574219E+04, -.1393748901367E+04, .6151767578125E+03},
 {   20419, .8134738281250E+04, -.1421053833008E+04, .6237980346680E+03},
 {   20420, .8174425781250E+04, -.1447660766602E+04, .7710006103516E+03},
 {   20421, .8181341308594E+04, -.1466432617188E+04, .7340070190430E+03},
 {   20422, .8110505371094E+04, -.1422281738281E+04, .7963269042969E+03},
 {   20423, .8087224121094E+04, -.1374731933594E+04, .8049542236328E+03},
 {   20424, .8108873535156E+04, -.1374821899414E+04, .8005902709961E+03},
 {   20425, .8083112304688E+04, -.1344979980469E+04, .7955129394531E+03},
 {   20426, .8071464843750E+04, -.1361389892578E+04, .7672632446289E+03},
 {   20427, .8074904785156E+04, -.1378459838867E+04, .7757004394531E+03},
 {   20428, .8065278320312E+04, -.1300518066406E+04, .7507579345703E+03},
 {   20429, .8061203125000E+04, -.1297987060547E+04, .7414506835938E+03},
 {   20430, .8060829101562E+04, -.1339178955078E+04, .7411442871094E+03},
 {   20431, .8066072265625E+04, -.1347425903320E+04, .7540221557617E+03},
 {   20432, .8071136230469E+04, -.1307993041992E+04, .7646463012695E+03},
 {   20433, .8077708496094E+04, -.1325172973633E+04, .7835180053711E+03},
 {   20434, .8101439941406E+04, -.1398934814453E+04, .8018574829102E+03},
 {   20435, .8118741699219E+04, -.1399031860352E+04, .8021271362305E+03},
 {   20436, .8088340820312E+04, -.1399694824219E+04, .8077891845703E+03},
 {   20437, .8075062500000E+04, -.1398301879883E+04, .7760585327148E+03},
 {   20438, .8133506835938E+04, -.1422251831055E+04, .7969713134766E+03},
 {   20439, .8056005859375E+04, -.1297760009766E+04, .7291827392578E+03},
 {   20440, .8049120117188E+04, -.1300156982422E+04, .7123823242188E+03},
 {   20441, .8139469238281E+04, -.1448739746094E+04, .6322989501953E+03},
 {   20442, .8118954589844E+04, -.1428345825195E+04, .6276500244141E+03},
 {   20443, .8147543945312E+04, -.1444301757812E+04, .7867094726562E+03},
 {   20444, .8212941406250E+04, -.1468998657227E+04, .7264934692383E+03},
 {   20445, .8142624023438E+04, -.1459841674805E+04, .7770408935547E+03},
 {   20446, .8267002929688E+04, -.1341080932617E+04, .6133294677734E+03},
 {   20447, .8232994140625E+04, -.1339953979492E+04, .5914793701172E+03},
 {   20448, .8267166015625E+04, -.1312300048828E+04, .6254645996094E+03},
 {   20449, .8236414062500E+04, -.1310024047852E+04, .6038491821289E+03},
 {   20450, .8269813476562E+04, -.1288185058594E+04, .6399351806641E+03},
 {   20451, .8229130859375E+04, -.1164320312500E+04, .6860800170898E+03},
 {   20452, .8219431640625E+04, -.1164740356445E+04, .6622189331055E+03},
 {   20453, .8244725585938E+04, -.1167580322266E+04, .6484957275391E+03},
 {   20454, .8266969726562E+04, -.1164662231445E+04, .6920318603516E+03},
 {   20455, .8277658203125E+04, -.1165956298828E+04, .7207186279297E+03},
 {   20456, .8286106445312E+04, -.1167170288086E+04, .7428651733398E+03},
 {   20457, .8296468750000E+04, -.1172900268555E+04, .7716434936523E+03},
 {   20458, .8270948242188E+04, -.1205573242188E+04, .6886805419922E+03},
 {   20459, .8284291015625E+04, -.1206635253906E+04, .7143566284180E+03},
 {   20460, .8241764648438E+04, -.1164019287109E+04, .7060654907227E+03},
 {   20461, .8253408203125E+04, -.1164820312500E+04, .7325335693359E+03},
 {   20462, .8263618164062E+04, -.1152147338867E+04, .7607834472656E+03},
 {   20463, .8276159179688E+04, -.1152757324219E+04, .7850525512695E+03},
 {   20464, .8244424804688E+04, -.1201797241211E+04, .7025409545898E+03},
 {   20465, .8253904296875E+04, -.1197736206055E+04, .7281652221680E+03},
 {   20466, .8298028320312E+04, -.1210683227539E+04, .7380823364258E+03},
 {   20467, .8259788085938E+04, -.1201034179688E+04, .7537557373047E+03},
 {   20468, .8302254882812E+04, -.1202395263672E+04, .7659450683594E+03},
 {   20469, .8274774414062E+04, -.1181143310547E+04, .7802836914062E+03},
 {   20470, .8251607421875E+04, -.1204793212891E+04, .6532927856445E+03},
 {   20471, .8229412109375E+04, -.1201403198242E+04, .6841643066406E+03},
 {   20472, .8208323242188E+04, -.1168660278320E+04, .6339674072266E+03},
 {   20473, .8161774414062E+04, -.1132907348633E+04, .7413535766602E+03},
 {   20474, .8165198730469E+04, -.1180410278320E+04, .7358640136719E+03},
 {   20475, .8184619628906E+04, -.1177901245117E+04, .7266712036133E+03},
 {   20476, .8182754882812E+04, -.1138504394531E+04, .7315166015625E+03},
 {   20477, .8177538085938E+04, -.1145611328125E+04, .7689982299805E+03},
 {   20478, .8176807128906E+04, -.1172380249023E+04, .7616022338867E+03},
 {   20479, .8197355468750E+04, -.1172816284180E+04, .7518117675781E+03},
 {   20480, .8196055664062E+04, -.1149610351562E+04, .7562351684570E+03},
 {   20481, .8234684570312E+04, -.1183770263672E+04, .7639663085938E+03},
 {   20482, .8208016601562E+04, -.1173374267578E+04, .7746589355469E+03},
 {   20483, .8206071289062E+04, -.1152070312500E+04, .7753648071289E+03},
 {   20484, .8233450195312E+04, -.1141547363281E+04, .7688070678711E+03},
 {   20485, .8225425781250E+04, -.1181096313477E+04, .7409253540039E+03},
 {   20486, .8225118164062E+04, -.1150705322266E+04, .7444207763672E+03},
 {   20487, .8210897460938E+04, -.1174790283203E+04, .7188211669922E+03},
 {   20488, .8212396484375E+04, -.1146920288086E+04, .7207428588867E+03},
 {   20489, .8178479003906E+04, -.1161485351562E+04, .6444986572266E+03},
 {   20490, .8192079101562E+04, -.1144780273438E+04, .6734001464844E+03},
 {   20491, .8202250976562E+04, -.1144360351562E+04, .6970751342773E+03},
 {   20492, .8151955078125E+04, -.1144548339844E+04, .6615415649414E+03},
 {   20493, .8162562011719E+04, -.1137438354492E+04, .6864129638672E+03},
 {   20494, .8156502929688E+04, -.1142765380859E+04, .7825332031250E+03},
 {   20495, .8150164062500E+04, -.1174460327148E+04, .7842259521484E+03},
 {   20496, .8143436035156E+04, -.1132990356445E+04, .7480237426758E+03},
 {   20497, .8138465332031E+04, -.1170935302734E+04, .7492154541016E+03},
 {   20498, .8318907226562E+04, -.1291211059570E+04, .7724935302734E+03},
 {   20499, .8318598632812E+04, -.1256347167969E+04, .7762675781250E+03},
 {   20500, .8313353515625E+04, -.1228082153320E+04, .7831387329102E+03},
 {   20501, .8309865234375E+04, -.1200289184570E+04, .7896964111328E+03},
 {   20502, .8302314453125E+04, -.1177020263672E+04, .7967549438477E+03},
 {   20503, .8285027343750E+04, -.1163783325195E+04, .8042858886719E+03},
 {   20504, .8262550781250E+04, -.1153545288086E+04, .8139880371094E+03},
 {   20505, .8238361328125E+04, -.1149315307617E+04, .8238776855469E+03},
 {   20506, .8211397460938E+04, -.1156458251953E+04, .8359410400391E+03},
 {   20507, .8193332031250E+04, -.1165659301758E+04, .8455639648438E+03},
 {   20508, .8176021484375E+04, -.1175414306641E+04, .8532178955078E+03},
 {   20509, .8164821289062E+04, -.1193073242188E+04, .8579597167969E+03},
 {   20510, .8154315429688E+04, -.1212986206055E+04, .8616691894531E+03},
 {   20511, .8146219238281E+04, -.1234395141602E+04, .8625835571289E+03},
 {   20512, .8141961914062E+04, -.1256776123047E+04, .8638906250000E+03},
 {   20513, .8142281250000E+04, -.1291520019531E+04, .8665570068359E+03},
 {   20514, .8139947265625E+04, -.1291520996094E+04, .8364943237305E+03},
 {   20515, .8139616210938E+04, -.1256579101562E+04, .8363707275391E+03},
 {   20516, .8143405273438E+04, -.1233125122070E+04, .8352714843750E+03},
 {   20517, .8150654296875E+04, -.1210551269531E+04, .8368130493164E+03},
 {   20518, .8161256347656E+04, -.1191190307617E+04, .8332422485352E+03},
 {   20519, .8170932617188E+04, -.1173271240234E+04, .8289495239258E+03},
 {   20520, .8186535644531E+04, -.1163630249023E+04, .8212151489258E+03},
 {   20521, .8199300781250E+04, -.1152292358398E+04, .8146037597656E+03},
 {   20522, .8309138671875E+04, -.1257298095703E+04, .7527840576172E+03},
 {   20523, .8305178710938E+04, -.1229749145508E+04, .7583654785156E+03},
 {   20524, .8308779296875E+04, -.1291211059570E+04, .7509728393555E+03},
 {   20525, .8254387695312E+04, -.1142323364258E+04, .7944768066406E+03},
 {   20526, .8218632812500E+04, -.1145060302734E+04, .8028565063477E+03},
 {   20527, .8125747558594E+04, -.1256429077148E+04, .8077823486328E+03},
 {   20528, .8124094238281E+04, -.1291520996094E+04, .8007474975586E+03},
 {   20529, .8133544921875E+04, -.1232938110352E+04, .8083259277344E+03},
 {   20530, .8142414062500E+04, -.1209994262695E+04, .8111502685547E+03},
 {   20531, .8155354003906E+04, -.1189243286133E+04, .8090092163086E+03},
 {   20532, .8162221191406E+04, -.1173395263672E+04, .8057006835938E+03},
 {   20533, .8172309082031E+04, -.1158921264648E+04, .7998519897461E+03},
 {   20534, .8186217773438E+04, -.1153231323242E+04, .7876194458008E+03},
 {   20535, .8219167968750E+04, -.1155871337891E+04, .8009004516602E+03},
 {   20536, .8186321777344E+04, -.1171006225586E+04, .7887932739258E+03},
 {   20537, .8197923828125E+04, -.1161176269531E+04, .8129661254883E+03},
 {   20538, .8253567382812E+04, -.1164830322266E+04, .7897035522461E+03},
 {   20539, .8304916015625E+04, -.1259137084961E+04, .7310228271484E+03},
 {   20540, .8303753906250E+04, -.1291211059570E+04, .7322512207031E+03},
 {   20541, .8301374023438E+04, -.1233126220703E+04, .7342466430664E+03},
 {   20542, .8302243164062E+04, -.1261636108398E+04, .7069771118164E+03},
 {   20543, .8300717773438E+04, -.1290986083984E+04, .7061799926758E+03},
 {   20544, .8283733398438E+04, -.1286886108398E+04, .6775573730469E+03},
 {   20545, .8285406250000E+04, -.1257927124023E+04, .6766157836914E+03},
 {   20546, .8221725585938E+04, -.1291211059570E+04, .6328450927734E+03},
 {   20547, .8217918945312E+04, -.1260253173828E+04, .6258404541016E+03},
 {   20548, .8183022949219E+04, -.1291211059570E+04, .6448064575195E+03},
 {   20549, .8176426757812E+04, -.1253790161133E+04, .6288469848633E+03},
 {   20550, .8155917968750E+04, -.1291211059570E+04, .6644862060547E+03},
 {   20551, .8144722656250E+04, -.1252162109375E+04, .6400581054688E+03},
 {   20552, .8127346679688E+04, -.1291211059570E+04, .6787355346680E+03},
 {   20553, .8123346191406E+04, -.1249490112305E+04, .6601043090820E+03},
 {   20554, .8104884765625E+04, -.1291211059570E+04, .6985787353516E+03},
 {   20555, .8107334472656E+04, -.1248824096680E+04, .6850720825195E+03},
 {   20556, .8106115234375E+04, -.1290320068359E+04, .7623261108398E+03},
 {   20557, .8113750976562E+04, -.1253874145508E+04, .7765959472656E+03},
 {   20558, .8123708007812E+04, -.1232792114258E+04, .7800521240234E+03},
 {   20559, .8288031250000E+04, -.1236701171875E+04, .7098858032227E+03},
 {   20560, .8275713867188E+04, -.1233831176758E+04, .6856658325195E+03},
 {   20561, .8242821289062E+04, -.1259949096680E+04, .6478756713867E+03},
 {   20562, .8252852539062E+04, -.1232455200195E+04, .6539686279297E+03},
 {   20563, .8200662109375E+04, -.1183168334961E+04, .6954318237305E+03},
 {   20564, .8191009765625E+04, -.1199628173828E+04, .6726956176758E+03},
 {   20565, .8175591796875E+04, -.1202662231445E+04, .6368486938477E+03},
 {   20566, .8207239257812E+04, -.1203167236328E+04, .6285049438477E+03},
 {   20567, .8218980468750E+04, -.1206793212891E+04, .6611552734375E+03},
 {   20568, .8227889648438E+04, -.1233180175781E+04, .6590971679688E+03},
 {   20569, .8215752929688E+04, -.1231719116211E+04, .6266950683594E+03},
 {   20570, .8172699218750E+04, -.1226900146484E+04, .6283753051758E+03},
 {   20571, .8142092285156E+04, -.1228361206055E+04, .6362024536133E+03},
 {   20572, .8162013183594E+04, -.1187732299805E+04, .6849189453125E+03},
 {   20573, .8173476562500E+04, -.1184909301758E+04, .7060338745117E+03},
 {   20574, .8169992187500E+04, -.1136291381836E+04, .7081137695312E+03},
 {   20575, .8142997558594E+04, -.1206349243164E+04, .6435178222656E+03},
 {   20576, .8145395019531E+04, -.1131651367188E+04, .6945888671875E+03},
 {   20577, .8153583984375E+04, -.1131778320312E+04, .7179713745117E+03},
 {   20578, .8084936523438E+04, -.1142220336914E+04, .7158573608398E+03},
 {   20579, .8093581054688E+04, -.1138767333984E+04, .7399722290039E+03},
 {   20580, .8075840820312E+04, -.1152681396484E+04, .6933887329102E+03},
 {   20581, .8120189941406E+04, -.1133593383789E+04, .7258135375977E+03},
 {   20582, .8132561035156E+04, -.1133095336914E+04, .7498334960938E+03},
 {   20583, .8102441406250E+04, -.1147200317383E+04, .6767194213867E+03},
 {   20584, .8112231445312E+04, -.1139791381836E+04, .7007926635742E+03},
 {   20585, .8104046875000E+04, -.1142830322266E+04, .7637159423828E+03},
 {   20586, .8133963867188E+04, -.1133030395508E+04, .7203406372070E+03},
 {   20587, .8126419433594E+04, -.1140280395508E+04, .6945307006836E+03},
 {   20588, .8134878906250E+04, -.1139062377930E+04, .6686829833984E+03},
 {   20589, .8069629882812E+04, -.1210764282227E+04, .6923320312500E+03},
 {   20590, .8073770019531E+04, -.1228474121094E+04, .6983433227539E+03},
 {   20591, .8099209960938E+04, -.1229856201172E+04, .6863268432617E+03},
 {   20592, .8093988769531E+04, -.1210489257812E+04, .6822908935547E+03},
 {   20593, .8119687988281E+04, -.1228522216797E+04, .6605174560547E+03},
 {   20594, .8119243164062E+04, -.1207749267578E+04, .6638703002930E+03},
 {   20595, .8067796386719E+04, -.1188221313477E+04, .6891648559570E+03},
 {   20596, .8094521484375E+04, -.1178517333984E+04, .6798299560547E+03},
 {   20597, .8120463378906E+04, -.1164126342773E+04, .6684019775391E+03},
 {   20598, .8078841796875E+04, -.1248837158203E+04, .7049028320312E+03},
 {   20599, .8163018554688E+04, -.1205793212891E+04, .6838976440430E+03},
 {   20600, .8143433105469E+04, -.1173975341797E+04, .6506860351562E+03},
 {   20601, .8105973632812E+04, -.1237955200195E+04, .7411036376953E+03},
 {   20602, .8086023925781E+04, -.1233066162109E+04, .7475635986328E+03},
 {   20603, .8105125488281E+04, -.1290696044922E+04, .7415849609375E+03},
 {   20604, .8083643066406E+04, -.1239868164062E+04, .7319744262695E+03},
 {   20605, .8106452148438E+04, -.1243314208984E+04, .7228034057617E+03},
 {   20606, .8105012207031E+04, -.1291211059570E+04, .7200441284180E+03},
 {   20607, .8101121093750E+04, -.1158870239258E+04, .7661053466797E+03},
 {   20608, .8099274902344E+04, -.1201157226562E+04, .7619778442383E+03},
 {   20609, .8094035644531E+04, -.1218380249023E+04, .7560866699219E+03},
 {   20610, .8093025878906E+04, -.1180880249023E+04, .7688414916992E+03},
 {   20611, .8111271484375E+04, -.1183460205078E+04, .7615294799805E+03},
 {   20612, .8123380371094E+04, -.1160270263672E+04, .7548442993164E+03},
 {   20613, .8141615234375E+04, -.1189377197266E+04, .7844832763672E+03},
 {   20614, .8128741699219E+04, -.1188177246094E+04, .7519396972656E+03},
 {   20615, .8132484863281E+04, -.1206311279297E+04, .7853868408203E+03},
 {   20616, .8123643066406E+04, -.1205172241211E+04, .7482565307617E+03},
 {   20617, .8116605957031E+04, -.1222549194336E+04, .7449093017578E+03},
 {   20618, .8242058593750E+04, -.1291262084961E+04, .6517556762695E+03},
 {   20619, .8229130859375E+04, -.1412281738281E+04, .6860800170898E+03},
 {   20620, .8244725585938E+04, -.1409021850586E+04, .6484957885742E+03},
 {   20621, .8219431640625E+04, -.1411861816406E+04, .6622189331055E+03},
 {   20622, .8277658203125E+04, -.1410645751953E+04, .7207186279297E+03},
 {   20623, .8266969726562E+04, -.1411939819336E+04, .6920318603516E+03},
 {   20624, .8296468750000E+04, -.1403701782227E+04, .7716434936523E+03},
 {   20625, .8286106445312E+04, -.1409431762695E+04, .7428651733398E+03},
 {   20626, .8284291015625E+04, -.1369966918945E+04, .7143566284180E+03},
 {   20627, .8270948242188E+04, -.1371028930664E+04, .6886805419922E+03},
 {   20628, .8253408203125E+04, -.1411781738281E+04, .7325335693359E+03},
 {   20629, .8241764648438E+04, -.1412582763672E+04, .7060654907227E+03},
 {   20630, .8276159179688E+04, -.1423844726562E+04, .7850525512695E+03},
 {   20631, .8263618164062E+04, -.1424454833984E+04, .7607834472656E+03},
 {   20632, .8253904296875E+04, -.1378865844727E+04, .7281652832031E+03},
 {   20633, .8244424804688E+04, -.1374804931641E+04, .7025410156250E+03},
 {   20634, .8298028320312E+04, -.1365918945312E+04, .7380823364258E+03},
 {   20635, .8259788085938E+04, -.1375567871094E+04, .7537557373047E+03},
 {   20636, .8302254882812E+04, -.1374206909180E+04, .7659451904297E+03},
 {   20637, .8274774414062E+04, -.1395458862305E+04, .7802836914062E+03},
 {   20638, .8251607421875E+04, -.1371808837891E+04, .6532927856445E+03},
 {   20639, .8229412109375E+04, -.1375198852539E+04, .6841643066406E+03},
 {   20640, .8208323242188E+04, -.1407941772461E+04, .6339675292969E+03},
 {   20641, .8161774414062E+04, -.1443694702148E+04, .7413535766602E+03},
 {   20642, .8182754882812E+04, -.1438097778320E+04, .7315166015625E+03},
 {   20643, .8184619628906E+04, -.1398700805664E+04, .7266712646484E+03},
 {   20644, .8165198730469E+04, -.1396191772461E+04, .7358640747070E+03},
 {   20645, .8177538085938E+04, -.1430990722656E+04, .7689982299805E+03},
 {   20646, .8196055664062E+04, -.1426991821289E+04, .7562352905273E+03},
 {   20647, .8197355468750E+04, -.1403785888672E+04, .7518117675781E+03},
 {   20648, .8176807128906E+04, -.1404221801758E+04, .7616022338867E+03},
 {   20649, .8234684570312E+04, -.1392831787109E+04, .7639663085938E+03},
 {   20650, .8233450195312E+04, -.1435054809570E+04, .7688070678711E+03},
 {   20651, .8206071289062E+04, -.1424531738281E+04, .7753648071289E+03},
 {   20652, .8208016601562E+04, -.1403227783203E+04, .7746589355469E+03},
 {   20653, .8225425781250E+04, -.1395505859375E+04, .7409253540039E+03},
 {   20654, .8225118164062E+04, -.1425896728516E+04, .7444207763672E+03},
 {   20655, .8210897460938E+04, -.1401811889648E+04, .7188212890625E+03},
 {   20656, .8212396484375E+04, -.1429681762695E+04, .7207428588867E+03},
 {   20657, .8178479003906E+04, -.1415116821289E+04, .6444986572266E+03},
 {   20658, .8192079101562E+04, -.1431821777344E+04, .6734001464844E+03},
 {   20659, .8202250976562E+04, -.1432241821289E+04, .6970751342773E+03},
 {   20660, .8151955078125E+04, -.1432053710938E+04, .6615416870117E+03},
 {   20661, .8162562011719E+04, -.1439163818359E+04, .6864129638672E+03},
 {   20662, .8156502929688E+04, -.1433836791992E+04, .7825332031250E+03},
 {   20663, .8150164062500E+04, -.1402141845703E+04, .7842259521484E+03},
 {   20664, .8143436035156E+04, -.1443611694336E+04, .7480238647461E+03},
 {   20665, .8138465332031E+04, -.1405666870117E+04, .7492154541016E+03},
 {   20666, .8318598632812E+04, -.1320255004883E+04, .7762677001953E+03},
 {   20667, .8313353515625E+04, -.1348519897461E+04, .7831387329102E+03},
 {   20668, .8309865234375E+04, -.1376312866211E+04, .7896964111328E+03},
 {   20669, .8302314453125E+04, -.1399581787109E+04, .7967549438477E+03},
 {   20670, .8285027343750E+04, -.1412818725586E+04, .8042858886719E+03},
 {   20671, .8262550781250E+04, -.1423056762695E+04, .8139880371094E+03},
 {   20672, .8238361328125E+04, -.1427286743164E+04, .8238776855469E+03},
 {   20673, .8211397460938E+04, -.1420143798828E+04, .8359410400391E+03},
 {   20674, .8193332031250E+04, -.1410942749023E+04, .8455639648438E+03},
 {   20675, .8176021484375E+04, -.1401187866211E+04, .8532178955078E+03},
 {   20676, .8164821289062E+04, -.1383528808594E+04, .8579597167969E+03},
 {   20677, .8154315429688E+04, -.1363615844727E+04, .8616691894531E+03},
 {   20678, .8146219238281E+04, -.1342206909180E+04, .8625835571289E+03},
 {   20679, .8141961914062E+04, -.1319825927734E+04, .8638906250000E+03},
 {   20680, .8139616210938E+04, -.1320022949219E+04, .8363707275391E+03},
 {   20681, .8143405273438E+04, -.1343476928711E+04, .8352714843750E+03},
 {   20682, .8150654296875E+04, -.1366050903320E+04, .8368131713867E+03},
 {   20683, .8161256347656E+04, -.1385411865234E+04, .8332422485352E+03},
 {   20684, .8170932617188E+04, -.1403330810547E+04, .8289495239258E+03},
 {   20685, .8186535644531E+04, -.1412971801758E+04, .8212151489258E+03},
 {   20686, .8199300781250E+04, -.1424309814453E+04, .8146037597656E+03},
 {   20687, .8309138671875E+04, -.1319303955078E+04, .7527840576172E+03},
 {   20688, .8305178710938E+04, -.1346852905273E+04, .7583654785156E+03},
 {   20689, .8254387695312E+04, -.1434278808594E+04, .7944768066406E+03},
 {   20690, .8218632812500E+04, -.1431541748047E+04, .8028565063477E+03},
 {   20691, .8125747558594E+04, -.1320172973633E+04, .8077823486328E+03},
 {   20692, .8133544921875E+04, -.1343663940430E+04, .8083259277344E+03},
 {   20693, .8142414062500E+04, -.1366607910156E+04, .8111502685547E+03},
 {   20694, .8155354003906E+04, -.1387358886719E+04, .8090092163086E+03},
 {   20695, .8162221191406E+04, -.1403206787109E+04, .8057008056641E+03},
 {   20696, .8172309082031E+04, -.1417680786133E+04, .7998519897461E+03},
 {   20697, .8186217773438E+04, -.1423370727539E+04, .7876194458008E+03},
 {   20698, .8219167968750E+04, -.1420730834961E+04, .8009004516602E+03},
 {   20699, .8197923828125E+04, -.1415425781250E+04, .8129661254883E+03},
 {   20700, .8186321777344E+04, -.1405595825195E+04, .7887932739258E+03},
 {   20701, .8253567382812E+04, -.1411771850586E+04, .7897035522461E+03},
 {   20702, .8304916015625E+04, -.1317464965820E+04, .7310228271484E+03},
 {   20703, .8301374023438E+04, -.1343475952148E+04, .7342466430664E+03},
 {   20704, .8302243164062E+04, -.1314966064453E+04, .7069771118164E+03},
 {   20705, .8282062500000E+04, -.1315844970703E+04, .6784992675781E+03},
 {   20706, .8217918945312E+04, -.1316348999023E+04, .6258404541016E+03},
 {   20707, .8176426757812E+04, -.1322812011719E+04, .6288469848633E+03},
 {   20708, .8144722656250E+04, -.1324439941406E+04, .6400582275391E+03},
 {   20709, .8123346191406E+04, -.1327111938477E+04, .6601043090820E+03},
 {   20710, .8107334472656E+04, -.1327777954102E+04, .6850720825195E+03},
 {   20711, .8113750976562E+04, -.1322728027344E+04, .7765959472656E+03},
 {   20712, .8123708007812E+04, -.1343809936523E+04, .7800521240234E+03},
 {   20713, .8288031250000E+04, -.1339901000977E+04, .7098858032227E+03},
 {   20714, .8275713867188E+04, -.1342770996094E+04, .6856658325195E+03},
 {   20715, .8245032226562E+04, -.1316964965820E+04, .6499033203125E+03},
 {   20716, .8252852539062E+04, -.1344146972656E+04, .6539686279297E+03},
 {   20717, .8200662109375E+04, -.1393433837891E+04, .6954318237305E+03},
 {   20718, .8191009765625E+04, -.1376973876953E+04, .6726956176758E+03},
 {   20719, .8218980468750E+04, -.1369808837891E+04, .6611552734375E+03},
 {   20720, .8207239257812E+04, -.1373434936523E+04, .6285049438477E+03},
 {   20721, .8175591796875E+04, -.1373939941406E+04, .6368486938477E+03},
 {   20722, .8215752929688E+04, -.1344882934570E+04, .6266950683594E+03},
 {   20723, .8227889648438E+04, -.1343421997070E+04, .6590971679688E+03},
 {   20724, .8172699218750E+04, -.1349701904297E+04, .6283753051758E+03},
 {   20725, .8142092285156E+04, -.1348240966797E+04, .6362024536133E+03},
 {   20726, .8162013183594E+04, -.1388869873047E+04, .6849189453125E+03},
 {   20727, .8173476562500E+04, -.1391692871094E+04, .7060339355469E+03},
 {   20728, .8169992187500E+04, -.1440310791016E+04, .7081137695312E+03},
 {   20729, .8142997558594E+04, -.1370252929688E+04, .6435178222656E+03},
 {   20730, .8153583984375E+04, -.1444823730469E+04, .7179714965820E+03},
 {   20731, .8145395019531E+04, -.1444950683594E+04, .6945888671875E+03},
 {   20732, .8084936523438E+04, -.1434381713867E+04, .7158574218750E+03},
 {   20733, .8093581054688E+04, -.1437834716797E+04, .7399722290039E+03},
 {   20734, .8075840820312E+04, -.1423920776367E+04, .6933887329102E+03},
 {   20735, .8120189941406E+04, -.1443008789062E+04, .7258135375977E+03},
 {   20736, .8132561035156E+04, -.1443506713867E+04, .7498334960938E+03},
 {   20737, .8102441406250E+04, -.1429401733398E+04, .6767194213867E+03},
 {   20738, .8112231445312E+04, -.1436810791016E+04, .7007926635742E+03},
 {   20739, .8104046875000E+04, -.1433771728516E+04, .7637159423828E+03},
 {   20740, .8133963867188E+04, -.1443571777344E+04, .7203406982422E+03},
 {   20741, .8126419433594E+04, -.1436321777344E+04, .6945307006836E+03},
 {   20742, .8134878906250E+04, -.1437539794922E+04, .6686831054688E+03},
 {   20743, .8069629882812E+04, -.1365837890625E+04, .6923321533203E+03},
 {   20744, .8093988769531E+04, -.1366112915039E+04, .6822908935547E+03},
 {   20745, .8099209960938E+04, -.1346745971680E+04, .6863268432617E+03},
 {   20746, .8073770019531E+04, -.1348127929688E+04, .6983433227539E+03},
 {   20747, .8119243164062E+04, -.1368852905273E+04, .6638703002930E+03},
 {   20748, .8119687988281E+04, -.1348079956055E+04, .6605174560547E+03},
 {   20749, .8067796386719E+04, -.1388380859375E+04, .6891648559570E+03},
 {   20750, .8094521484375E+04, -.1398084838867E+04, .6798299560547E+03},
 {   20751, .8120463378906E+04, -.1412475830078E+04, .6684019775391E+03},
 {   20752, .8078841796875E+04, -.1327765014648E+04, .7049028320312E+03},
 {   20753, .8163018554688E+04, -.1370808837891E+04, .6838976440430E+03},
 {   20754, .8143433105469E+04, -.1402626831055E+04, .6506860351562E+03},
 {   20755, .8105973632812E+04, -.1338646972656E+04, .7411036376953E+03},
 {   20756, .8086023925781E+04, -.1343535888672E+04, .7475635986328E+03},
 {   20757, .8106452148438E+04, -.1333287963867E+04, .7228034057617E+03},
 {   20758, .8083643066406E+04, -.1336734008789E+04, .7319744262695E+03},
 {   20759, .8101121093750E+04, -.1417731811523E+04, .7661053466797E+03},
 {   20760, .8099274902344E+04, -.1375444824219E+04, .7619778442383E+03},
 {   20761, .8094035644531E+04, -.1358221923828E+04, .7560866699219E+03},
 {   20762, .8093025878906E+04, -.1395721801758E+04, .7688414916992E+03},
 {   20763, .8111271484375E+04, -.1393141845703E+04, .7615294799805E+03},
 {   20764, .8123380371094E+04, -.1416331787109E+04, .7548442993164E+03},
 {   20765, .8128741699219E+04, -.1388424804688E+04, .7519396972656E+03},
 {   20766, .8141615234375E+04, -.1387224853516E+04, .7844833984375E+03},
 {   20767, .8132484863281E+04, -.1370290893555E+04, .7853868408203E+03},
 {   20768, .8123643066406E+04, -.1371429931641E+04, .7482565307617E+03},
 {   20769, .8116605957031E+04, -.1354052978516E+04, .7449093017578E+03},
 {   20770, .8186063964844E+04, -.1384682861328E+04, .7373969116211E+03},
 {   20771, .8175565917969E+04, -.1380919921875E+04, .7392689819336E+03},
 {   20772, .8175348144531E+04, -.1376617919922E+04, .7319461669922E+03},
 {   20773, .8183397949219E+04, -.1379088867188E+04, .7297929077148E+03},
 {   20774, .8165769042969E+04, -.1376110839844E+04, .7387557983398E+03},
 {   20775, .8167691894531E+04, -.1372699951172E+04, .7312588500977E+03},
 {   20776, .8157501464844E+04, -.1370207885742E+04, .7350997924805E+03},
 {   20777, .8161599121094E+04, -.1367926879883E+04, .7278294677734E+03},
 {   20778, .8206590820312E+04, -.1374015869141E+04, .7023166503906E+03},
 {   20779, .8200710937500E+04, -.1367496826172E+04, .6956728515625E+03},
 {   20780, .8195048828125E+04, -.1366772949219E+04, .6989555053711E+03},
 {   20781, .8198257812500E+04, -.1371542846680E+04, .7046967773438E+03},
 {   20782, .8193001953125E+04, -.1361314941406E+04, .6910818481445E+03},
 {   20783, .8189380859375E+04, -.1362037841797E+04, .6952495117188E+03},
 {   20784, .8150731445312E+04, -.1363774902344E+04, .7293173828125E+03},
 {   20785, .8151365722656E+04, -.1356544921875E+04, .7161989135742E+03},
 {   20786, .8158027343750E+04, -.1357258911133E+04, .7120952148438E+03},
 {   20787, .8157970703125E+04, -.1363015869141E+04, .7221807861328E+03},
 {   20788, .8158225585938E+04, -.1351025878906E+04, .7010650634766E+03},
 {   20789, .8164023437500E+04, -.1354403930664E+04, .7022996826172E+03},
 {   20790, .8172843750000E+04, -.1351426879883E+04, .6900249633789E+03},
 {   20791, .8174180175781E+04, -.1355300903320E+04, .6957087402344E+03},
 {   20792, .8183390136719E+04, -.1355949951172E+04, .6894450073242E+03},
 {   20793, .8182165527344E+04, -.1357877929688E+04, .6937914428711E+03},
 {   20794, .8194929687500E+04, -.1384562866211E+04, .7300856323242E+03},
 {   20795, .8190524902344E+04, -.1379751831055E+04, .7252199707031E+03},
 {   20796, .8201772460938E+04, -.1382842895508E+04, .7215860595703E+03},
 {   20797, .8195831054688E+04, -.1378555908203E+04, .7188729858398E+03},
 {   20798, .8205461914062E+04, -.1379098876953E+04, .7120859375000E+03},
 {   20799, .8198541015625E+04, -.1375679931641E+04, .7116846313477E+03},
 {   20800, .8277112304688E+04, -.1332063964844E+04, .7090800170898E+03},
 {   20801, .8251115234375E+04, -.1335054931641E+04, .7208850708008E+03},
 {   20802, .8263960937500E+04, -.1342686889648E+04, .7365703735352E+03},
 {   20803, .8286263671875E+04, -.1335295898438E+04, .7233074951172E+03},
 {   20804, .8226044921875E+04, -.1342637939453E+04, .7323002929688E+03},
 {   20805, .8239477539062E+04, -.1353475952148E+04, .7476414794922E+03},
 {   20806, .8199932617188E+04, -.1343979003906E+04, .7441720581055E+03},
 {   20807, .8212415039062E+04, -.1357213867188E+04, .7587783813477E+03},
 {   20808, .8173917480469E+04, -.1346528930664E+04, .7560013427734E+03},
 {   20809, .8184838867188E+04, -.1359824951172E+04, .7691708984375E+03},
 {   20810, .8154065429688E+04, -.1363937866211E+04, .7650286865234E+03},
 {   20811, .8162509277344E+04, -.1372399902344E+04, .7770828247070E+03},
 {   20812, .8275943359375E+04, -.1349790893555E+04, .7529920654297E+03},
 {   20813, .8294713867188E+04, -.1338427978516E+04, .7379376220703E+03},
 {   20814, .8251888671875E+04, -.1363356933594E+04, .7640485839844E+03},
 {   20815, .8223711914062E+04, -.1369062866211E+04, .7747803955078E+03},
 {   20816, .8194413085938E+04, -.1371307861328E+04, .7840688476562E+03},
 {   20817, .8169445312500E+04, -.1378619873047E+04, .7911956176758E+03},
 {   20818, .8286773437500E+04, -.1356946899414E+04, .7699930419922E+03},
 {   20819, .8301880859375E+04, -.1342110961914E+04, .7530357666016E+03},
 {   20820, .8263277343750E+04, -.1372790893555E+04, .7811513671875E+03},
 {   20821, .8234124023438E+04, -.1379965820312E+04, .7915908203125E+03},
 {   20822, .8203229492188E+04, -.1381347900391E+04, .7998900756836E+03},
 {   20823, .8175760742188E+04, -.1382896850586E+04, .8063468627930E+03},
 {   20824, .8297159179688E+04, -.1366374877930E+04, .7860485839844E+03},
 {   20825, .8307330078125E+04, -.1347970947266E+04, .7680354003906E+03},
 {   20826, .8275493164062E+04, -.1384594848633E+04, .7964600219727E+03},
 {   20827, .8246632812500E+04, -.1393336791992E+04, .8057575683594E+03},
 {   20828, .8215422851562E+04, -.1393950805664E+04, .8122184448242E+03},
 {   20829, .8186716308594E+04, -.1389834838867E+04, .8171554565430E+03},
 {   20830, .8307139648438E+04, -.1377578857422E+04, .8005953979492E+03},
 {   20831, .8311535156250E+04, -.1355522949219E+04, .7826186523438E+03},
 {   20832, .8288145507812E+04, -.1398256835938E+04, .8091693115234E+03},
 {   20833, .8260419921875E+04, -.1408646850586E+04, .8162360229492E+03},
 {   20834, .8229728515625E+04, -.1408575805664E+04, .8197682495117E+03},
 {   20835, .8200629882812E+04, -.1398877807617E+04, .8220960083008E+03},
 {   20836, .8278287109375E+04, -.1346021972656E+04, .7085454711914E+03},
 {   20837, .8252511718750E+04, -.1355544921875E+04, .7202662353516E+03},
 {   20838, .8263031250000E+04, -.1361259887695E+04, .7347456665039E+03},
 {   20839, .8287476562500E+04, -.1348513916016E+04, .7235904541016E+03},
 {   20840, .8230730468750E+04, -.1372539916992E+04, .7301691894531E+03},
 {   20841, .8240253906250E+04, -.1378505859375E+04, .7443463134766E+03},
 {   20842, .8208225585938E+04, -.1388190795898E+04, .7404027709961E+03},
 {   20843, .8215916015625E+04, -.1392218872070E+04, .7539318847656E+03},
 {   20844, .8273569335938E+04, -.1367000854492E+04, .7492122802734E+03},
 {   20845, .8296783203125E+04, -.1351022949219E+04, .7385662231445E+03},
 {   20846, .8249687500000E+04, -.1384507812500E+04, .7585656127930E+03},
 {   20847, .8223418945312E+04, -.1396291870117E+04, .7675552978516E+03},
 {   20848, .8282231445312E+04, -.1375043945312E+04, .7638911132812E+03},
 {   20849, .8303950195312E+04, -.1356380859375E+04, .7537130737305E+03},
 {   20850, .8257513671875E+04, -.1392264892578E+04, .7730393066406E+03},
 {   20851, .8229577148438E+04, -.1401574829102E+04, .7814743652344E+03},
 {   20852, .8194417968750E+04, -.1394389892578E+04, .7764907226562E+03},
 {   20853, .8199848632812E+04, -.1398720825195E+04, .7887814941406E+03},
 {   20854, .8167017578125E+04, -.1385130859375E+04, .7811198730469E+03},
 {   20855, .8171786132812E+04, -.1389283813477E+04, .7899661865234E+03},
 {   20856, .8286655273438E+04, -.1387282836914E+04, .7772395629883E+03},
 {   20857, .8306030273438E+04, -.1366960937500E+04, .7671146240234E+03},
 {   20858, .8261954101562E+04, -.1403190795898E+04, .7865935058594E+03},
 {   20859, .8233202148438E+04, -.1408999755859E+04, .7948900146484E+03},
 {   20860, .8203588867188E+04, -.1404169799805E+04, .8009845581055E+03},
 {   20861, .8175709472656E+04, -.1393525878906E+04, .7991376342773E+03},
 {   20862, .8286773437500E+04, -.1402466796875E+04, .7872306518555E+03},
 {   20863, .8302833007812E+04, -.1381213867188E+04, .7762851562500E+03},
 {   20864, .8263048828125E+04, -.1416334838867E+04, .7976661987305E+03},
 {   20865, .8234448242188E+04, -.1417912841797E+04, .8067000732422E+03},
 {   20866, .8205921875000E+04, -.1410377807617E+04, .8124531250000E+03},
 {   20867, .8179196777344E+04, -.1397800781250E+04, .8084513549805E+03},
 {   20868, .8172387695312E+04, -.1344694946289E+04, .7514581298828E+03},
 {   20869, .8177559570312E+04, -.1325291015625E+04, .7491054687500E+03},
 {   20870, .8196837890625E+04, -.1323455932617E+04, .7403408813477E+03},
 {   20871, .8192716796875E+04, -.1341984985352E+04, .7422152099609E+03},
 {   20872, .8181235839844E+04, -.1305701049805E+04, .7474347534180E+03},
 {   20873, .8199768554688E+04, -.1304774047852E+04, .7390083618164E+03},
 {   20874, .8180805664062E+04, -.1285593017578E+04, .7476303100586E+03},
 {   20875, .8199407226562E+04, -.1285682006836E+04, .7391718750000E+03},
 {   20876, .8216195312500E+04, -.1322471923828E+04, .7315404052734E+03},
 {   20877, .8213155273438E+04, -.1340554931641E+04, .7329217529297E+03},
 {   20878, .8218333984375E+04, -.1304276977539E+04, .7305649414062E+03},
 {   20879, .8218009765625E+04, -.1285772094727E+04, .7307128906250E+03},
 {   20880, .8235407226562E+04, -.1320542968750E+04, .7228040771484E+03},
 {   20881, .8233381835938E+04, -.1337705932617E+04, .7237234497070E+03},
 {   20882, .8236830078125E+04, -.1303305053711E+04, .7221567382812E+03},
 {   20883, .8236615234375E+04, -.1285861083984E+04, .7222545776367E+03},
 {   20884, .8254508789062E+04, -.1317693969727E+04, .7141187744141E+03},
 {   20885, .8253444335938E+04, -.1333476928711E+04, .7146024780273E+03},
 {   20886, .8255273437500E+04, -.1301874023438E+04, .7137716674805E+03},
 {   20887, .8255216796875E+04, -.1285950073242E+04, .7137970581055E+03},
 {   20888, .8273779296875E+04, -.1315788940430E+04, .7053568115234E+03},
 {   20889, .8273758789062E+04, -.1330661987305E+04, .7053660278320E+03},
 {   20890, .8273801757812E+04, -.1300915039062E+04, .7053471679688E+03},
 {   20891, .8273823242188E+04, -.1286039062500E+04, .7053381958008E+03},
 {   20892, .8172448242188E+04, -.1285775024414E+04, .7357145996094E+03},
 {   20893, .8172753417969E+04, -.1301901977539E+04, .7361098632812E+03},
 {   20894, .8164089843750E+04, -.1285955078125E+04, .7237979736328E+03},
 {   20895, .8164104492188E+04, -.1298718017578E+04, .7242916870117E+03},
 {   20896, .8155731445312E+04, -.1285942016602E+04, .7118833618164E+03},
 {   20897, .8155594238281E+04, -.1295731079102E+04, .7122749633789E+03},
 {   20898, .8147375976562E+04, -.1285761108398E+04, .6999666748047E+03},
 {   20899, .8147248535156E+04, -.1292978027344E+04, .7000240478516E+03},
 {   20900, .8169981445312E+04, -.1317640991211E+04, .7379053955078E+03},
 {   20901, .8162063964844E+04, -.1311223999023E+04, .7257190551758E+03},
 {   20902, .8154425781250E+04, -.1305195068359E+04, .7131364746094E+03},
 {   20903, .8147126953125E+04, -.1299635986328E+04, .7000797119141E+03},
 {   20904, .8166523925781E+04, -.1333856933594E+04, .7410266113281E+03},
 {   20905, .8159710937500E+04, -.1324266967773E+04, .7304432983398E+03},
 {   20906, .8152884765625E+04, -.1314614990234E+04, .7141671752930E+03},
 {   20907, .8147001953125E+04, -.1306295043945E+04, .7001376342773E+03},
 {   20908, .8139208496094E+04, -.1310880004883E+04, .7036795654297E+03},
 {   20909, .8142396484375E+04, -.1317112060547E+04, .7207628173828E+03},
 {   20910, .8132236816406E+04, -.1304368041992E+04, .7068496704102E+03},
 {   20911, .8133008789062E+04, -.1309320068359E+04, .7252288818359E+03},
 {   20912, .8127854980469E+04, -.1295791015625E+04, .7088419799805E+03},
 {   20913, .8126579589844E+04, -.1298701049805E+04, .7283489379883E+03},
 {   20914, .8125875976562E+04, -.1285761108398E+04, .7097424316406E+03},
 {   20915, .8124259277344E+04, -.1286319091797E+04, .7296009521484E+03},
 {   20916, .8144932617188E+04, -.1323343994141E+04, .7377474975586E+03},
 {   20917, .8132478515625E+04, -.1314272949219E+04, .7434105834961E+03},
 {   20918, .8123354492188E+04, -.1301611083984E+04, .7475582275391E+03},
 {   20919, .8120041015625E+04, -.1286319091797E+04, .7490656738281E+03},
 {   20920, .8114130371094E+04, -.1286319091797E+04, .7606467895508E+03},
 {   20921, .8118905273438E+04, -.1303955078125E+04, .7594177856445E+03},
 {   20922, .8129255859375E+04, -.1318276000977E+04, .7534525756836E+03},
 {   20923, .8141380859375E+04, -.1332232910156E+04, .7506162719727E+03},
 {   20924, .8150626464844E+04, -.1341847900391E+04, .7482562866211E+03},
 {   20925, .8152568359375E+04, -.1359360961914E+04, .7604696044922E+03},
 {   20926, .8137552734375E+04, -.1294385009766E+04, .7044328002930E+03},
 {   20927, .8136623535156E+04, -.1285761108398E+04, .7048540649414E+03},
 {   20928, .8139680664062E+04, -.1302000976562E+04, .7034652099609E+03},
 {   20929, .8116321777344E+04, -.1303927001953E+04, .7140856323242E+03},
 {   20930, .8114823730469E+04, -.1305632080078E+04, .7247462768555E+03},
 {   20931, .8126443359375E+04, -.1313671997070E+04, .7191015014648E+03},
 {   20932, .8128666992188E+04, -.1311672973633E+04, .7084731445312E+03},
 {   20933, .8113332031250E+04, -.1307334960938E+04, .7354085693359E+03},
 {   20934, .8124671875000E+04, -.1315876953125E+04, .7297203979492E+03},
 {   20935, .8111832031250E+04, -.1309041015625E+04, .7460688476562E+03},
 {   20936, .8124063476562E+04, -.1318606933594E+04, .7403229980469E+03},
 {   20937, .8110339355469E+04, -.1310744995117E+04, .7567297363281E+03},
 {   20938, .8124317382812E+04, -.1321484008789E+04, .7504877929688E+03},
 {   20939, .8136374023438E+04, -.1323454956055E+04, .7140721435547E+03},
 {   20940, .8140204101562E+04, -.1320593017578E+04, .7032286376953E+03},
 {   20941, .8133442871094E+04, -.1326723022461E+04, .7249006958008E+03},
 {   20942, .8132844726562E+04, -.1331042968750E+04, .7356905517578E+03},
 {   20943, .8133968750000E+04, -.1335656982422E+04, .7456118774414E+03},
 {   20944, .8142815429688E+04, -.1335880981445E+04, .7107568969727E+03},
 {   20945, .8147961425781E+04, -.1332353027344E+04, .6997733154297E+03},
 {   20946, .8139018554688E+04, -.1340019897461E+04, .7217141113281E+03},
 {   20947, .8138722656250E+04, -.1345735961914E+04, .7326141967773E+03},
 {   20948, .8141005859375E+04, -.1351892944336E+04, .7422111816406E+03},
 {   20949, .8146493652344E+04, -.1350245971680E+04, .7091284790039E+03},
 {   20950, .8152287597656E+04, -.1346506958008E+04, .6979512329102E+03},
 {   20951, .8142502441406E+04, -.1354799926758E+04, .7202741088867E+03},
 {   20952, .8143177734375E+04, -.1361455932617E+04, .7313402099609E+03},
 {   20953, .8147291992188E+04, -.1368698852539E+04, .7406677856445E+03},
 {   20954, .8160131347656E+04, -.1346931884766E+04, .6923960571289E+03},
 {   20955, .8156231933594E+04, -.1335475952148E+04, .6937069702148E+03},
 {   20956, .8167973632812E+04, -.1347357910156E+04, .6868418579102E+03},
 {   20957, .8165055664062E+04, -.1339893920898E+04, .6874038696289E+03},
 {   20958, .8176445800781E+04, -.1349394897461E+04, .6835930786133E+03},
 {   20959, .8174377929688E+04, -.1344713989258E+04, .6821699218750E+03},
 {   20960, .8185429687500E+04, -.1352750976562E+04, .6822296142578E+03},
 {   20961, .8184599121094E+04, -.1348797973633E+04, .6775863647461E+03},
 {   20962, .8151944335938E+04, -.1328365966797E+04, .6874110107422E+03},
 {   20963, .8142226562500E+04, -.1321094970703E+04, .6918300781250E+03},
 {   20964, .8161877441406E+04, -.1335324951172E+04, .6828950805664E+03},
 {   20965, .8172180175781E+04, -.1341481933594E+04, .6782106933594E+03},
 {   20966, .8183763183594E+04, -.1344844970703E+04, .6729430541992E+03},
 {   20967, .8172023437500E+04, -.1340784912109E+04, .6689241333008E+03},
 {   20968, .8159151367188E+04, -.1335255981445E+04, .6707423706055E+03},
 {   20969, .8171986816406E+04, -.1340131958008E+04, .6595727539062E+03},
 {   20970, .8156660644531E+04, -.1335281982422E+04, .6584663085938E+03},
 {   20971, .8172648437500E+04, -.1339829956055E+04, .6500723876953E+03},
 {   20972, .8155564941406E+04, -.1336010986328E+04, .6458881835938E+03},
 {   20973, .8148064941406E+04, -.1327916992188E+04, .6774395141602E+03},
 {   20974, .8144539550781E+04, -.1327611938477E+04, .6672811279297E+03},
 {   20975, .8143108886719E+04, -.1328361938477E+04, .6566714477539E+03},
 {   20976, .8138077148438E+04, -.1319814941406E+04, .6844545288086E+03},
 {   20977, .8134402343750E+04, -.1318724975586E+04, .6768302612305E+03},
 {   20978, .8133517578125E+04, -.1319042968750E+04, .6686037597656E+03},
 {   20979, .8117830566406E+04, -.1301681030273E+04, .6923274536133E+03},
 {   20980, .8117564941406E+04, -.1303098999023E+04, .6976835327148E+03},
 {   20981, .8122975097656E+04, -.1308342041016E+04, .6907297973633E+03},
 {   20982, .8122546386719E+04, -.1307702026367E+04, .6842880249023E+03},
 {   20983, .8117297363281E+04, -.1304515014648E+04, .7030380249023E+03},
 {   20984, .8124349609375E+04, -.1309460083008E+04, .6969580688477E+03},
 {   20985, .8116811035156E+04, -.1304242065430E+04, .7085606079102E+03},
 {   20986, .8125653808594E+04, -.1309629028320E+04, .7032150268555E+03},
 {   20987, .8128495605469E+04, -.1313640991211E+04, .6838848876953E+03},
 {   20988, .8127560546875E+04, -.1313586059570E+04, .6763251342773E+03},
 {   20989, .8131334960938E+04, -.1314650024414E+04, .6910197753906E+03},
 {   20990, .8134247558594E+04, -.1315453002930E+04, .6980351562500E+03},
 {   20991, .8204300781250E+04, -.1333596923828E+04, .6682874755859E+03},
 {   20992, .8198187500000E+04, -.1329396972656E+04, .6550922851562E+03},
 {   20993, .8188312500000E+04, -.1337942016602E+04, .6590733032227E+03},
 {   20994, .8198561523438E+04, -.1340467895508E+04, .6691942749023E+03},
 {   20995, .8220354492188E+04, -.1376836914062E+04, .7094531860352E+03},
 {   20996, .8225319335938E+04, -.1369880859375E+04, .7064360961914E+03},
 {   20997, .8220309570312E+04, -.1362240966797E+04, .6946868896484E+03},
 {   20998, .8216541015625E+04, -.1370154907227E+04, .6980163574219E+03},
 {   20999, .8215532226562E+04, -.1350831909180E+04, .6867396850586E+03},
 {   21000, .8211167968750E+04, -.1361208984375E+04, .6892119750977E+03},
 {   21001, .8212079101562E+04, -.1337927978516E+04, .6805864868164E+03},
 {   21002, .8205010742188E+04, -.1351414916992E+04, .6823051147461E+03},
 {   21003, .8195573242188E+04, -.1346071899414E+04, .6735119628906E+03},
 {   21004, .8194292968750E+04, -.1351508911133E+04, .6789687500000E+03},
 {   21005, .8215388671875E+04, -.1383792846680E+04, .7124692382812E+03},
 {   21006, .8215023437500E+04, -.1378025878906E+04, .7025761718750E+03},
 {   21007, .8211306640625E+04, -.1371500854492E+04, .6941458740234E+03},
 {   21008, .8204701171875E+04, -.1364773925781E+04, .6877177734375E+03},
 {   21009, .8195860351562E+04, -.1358374877930E+04, .6836594848633E+03},
 {   21010, .8249481445312E+04, -.1344784912109E+04, .6954486083984E+03},
 {   21011, .8243709960938E+04, -.1329963989258E+04, .6878003540039E+03},
 {   21012, .8236002929688E+04, -.1341763916016E+04, .6923127441406E+03},
 {   21013, .8240119140625E+04, -.1351465942383E+04, .6997070312500E+03},
 {   21014, .8238277343750E+04, -.1328231933594E+04, .6770396728516E+03},
 {   21015, .8231233398438E+04, -.1334716918945E+04, .6835336303711E+03},
 {   21016, .8232844726562E+04, -.1326501953125E+04, .6662781372070E+03},
 {   21017, .8226504882812E+04, -.1329301025391E+04, .6739068603516E+03},
 {   21018, .8227413085938E+04, -.1324771972656E+04, .6555155029297E+03},
 {   21019, .8220340820312E+04, -.1326740966797E+04, .6622328491211E+03},
 {   21020, .8221980468750E+04, -.1323041015625E+04, .6447543334961E+03},
 {   21021, .8214049804688E+04, -.1325160034180E+04, .6482001953125E+03},
 {   21022, .8228232421875E+04, -.1351900878906E+04, .6937235717773E+03},
 {   21023, .8232719726562E+04, -.1360673950195E+04, .7030719604492E+03},
 {   21024, .8223534179688E+04, -.1342569946289E+04, .6855847778320E+03},
 {   21025, .8219515625000E+04, -.1333308959961E+04, .6779205932617E+03},
 {   21026, .8212619140625E+04, -.1329761962891E+04, .6661579589844E+03},
 {   21027, .8206120117188E+04, -.1327277954102E+04, .6516456298828E+03},
 {   21028, .8248219726562E+04, -.1284527099609E+04, .6959982910156E+03},
 {   21029, .8243403320312E+04, -.1284467041016E+04, .6877149658203E+03},
 {   21030, .8243482421875E+04, -.1295842041016E+04, .6877365112305E+03},
 {   21031, .8248850585938E+04, -.1295579101562E+04, .6957232055664E+03},
 {   21032, .8243557617188E+04, -.1307216064453E+04, .6877569580078E+03},
 {   21033, .8248850585938E+04, -.1314656005859E+04, .6957232055664E+03},
 {   21034, .8249166015625E+04, -.1329719970703E+04, .6955878295898E+03},
 {   21035, .8243522460938E+04, -.1315094970703E+04, .6859263916016E+03},
 {   21036, .8238192382812E+04, -.1315534057617E+04, .6761312255859E+03},
 {   21037, .8232863281250E+04, -.1315973022461E+04, .6663343505859E+03},
 {   21038, .8227480468750E+04, -.1314662963867E+04, .6556113281250E+03},
 {   21039, .8222094726562E+04, -.1313354980469E+04, .6448903198242E+03},
 {   21040, .8232883789062E+04, -.1305441040039E+04, .6663911132812E+03},
 {   21041, .8238220703125E+04, -.1306328002930E+04, .6770753784180E+03},
 {   21042, .8227546875000E+04, -.1304555053711E+04, .6557096557617E+03},
 {   21043, .8222208984375E+04, -.1303667968750E+04, .6450253906250E+03},
 {   21044, .8238191406250E+04, -.1295376098633E+04, .6770921020508E+03},
 {   21045, .8232902343750E+04, -.1294911987305E+04, .6664494018555E+03},
 {   21046, .8227613281250E+04, -.1294446044922E+04, .6558059082031E+03},
 {   21047, .8222323242188E+04, -.1293981079102E+04, .6451630249023E+03},
 {   21048, .8238164062500E+04, -.1284423095703E+04, .6771107788086E+03},
 {   21049, .8232919921875E+04, -.1284380004883E+04, .6665061645508E+03},
 {   21050, .8227680664062E+04, -.1284337036133E+04, .6559020385742E+03},
 {   21051, .8222442382812E+04, -.1284294067383E+04, .6452974853516E+03},
 {   21052, .8265291992188E+04, -.1305648071289E+04, .6871866455078E+03},
 {   21053, .8265128906250E+04, -.1296046020508E+04, .6872610473633E+03},
 {   21054, .8264961914062E+04, -.1286445068359E+04, .6873349609375E+03},
 {   21055, .8261511718750E+04, -.1339416015625E+04, .6899806518555E+03},
 {   21056, .8265458984375E+04, -.1315250000000E+04, .6871114501953E+03},
 {   21057, .8220820312500E+04, -.1378845825195E+04, .7211480712891E+03},
 {   21058, .8210798828125E+04, -.1389116821289E+04, .7252733764648E+03},
 {   21059, .8230836914062E+04, -.1368571899414E+04, .7170238037109E+03},
 {   21060, .8248171875000E+04, -.1352317871094E+04, .7091412353516E+03},
 {   21061, .8239505859375E+04, -.1360444946289E+04, .7130820922852E+03},
 {   21062, .8258990234375E+04, -.1347539916992E+04, .7042243652344E+03},
 {   21063, .8269805664062E+04, -.1342760009766E+04, .6993051757812E+03},
 {   21064, .8109145996094E+04, -.1302603027344E+04, .7563250732422E+03},
 {   21065, .8110358398438E+04, -.1301458984375E+04, .7451619262695E+03},
 {   21066, .8106760742188E+04, -.1286319091797E+04, .7555126342773E+03},
 {   21067, .8107390625000E+04, -.1286319091797E+04, .7434874267578E+03},
 {   21068, .8111862792969E+04, -.1300315063477E+04, .7340247802734E+03},
 {   21069, .8108895019531E+04, -.1286319091797E+04, .7315358886719E+03},
 {   21070, .8113694824219E+04, -.1299171997070E+04, .7229324951172E+03},
 {   21071, .8111381347656E+04, -.1286319091797E+04, .7197265014648E+03},
 {   21072, .8115609863281E+04, -.1298069091797E+04, .7118594970703E+03},
 {   21073, .8114142089844E+04, -.1285761108398E+04, .7079754638672E+03},
 {   21074, .8116949707031E+04, -.1298248046875E+04, .7064885864258E+03},
 {   21075, .8118286621094E+04, -.1298425048828E+04, .7011169433594E+03},
 {   21076, .8120243652344E+04, -.1286319091797E+04, .6975540771484E+03},
 {   21077, .8117194335938E+04, -.1286319091797E+04, .7027645263672E+03},
 {   21078, .8130959472656E+04, -.1286975097656E+04, .6914418334961E+03},
 {   21079, .8120246582031E+04, -.1297603027344E+04, .6965760498047E+03},
 {   21080, .8125604003906E+04, -.1286647094727E+04, .6944981689453E+03},
 {   21081, .8206409179688E+04, -.1316785034180E+04, .6520693969727E+03},
 {   21082, .8198567382812E+04, -.1318500976562E+04, .6556586303711E+03},
 {   21083, .8214252929688E+04, -.1315069946289E+04, .6484793090820E+03},
 {   21084, .8206701171875E+04, -.1306292968750E+04, .6524926757812E+03},
 {   21085, .8198944335938E+04, -.1307604980469E+04, .6562263183594E+03},
 {   21086, .8214453125000E+04, -.1304979980469E+04, .6487585449219E+03},
 {   21087, .8206992187500E+04, -.1295799072266E+04, .6529145507812E+03},
 {   21088, .8199321289062E+04, -.1296708984375E+04, .6567919311523E+03},
 {   21089, .8214657226562E+04, -.1294890991211E+04, .6490386962891E+03},
 {   21090, .8207280273438E+04, -.1285307006836E+04, .6533392333984E+03},
 {   21091, .8199702148438E+04, -.1285812011719E+04, .6573579101562E+03},
 {   21092, .8214861328125E+04, -.1284800048828E+04, .6493182983398E+03},
 {   21093, .8176499023438E+04, -.1281461059570E+04, .6655518798828E+03},
 {   21094, .8188103027344E+04, -.1283637084961E+04, .6614547729492E+03},
 {   21095, .8187600097656E+04, -.1296038085938E+04, .6611767578125E+03},
 {   21096, .8175873535156E+04, -.1295366088867E+04, .6655596923828E+03},
 {   21097, .8186604980469E+04, -.1308393066406E+04, .6612413330078E+03},
 {   21098, .8174132812500E+04, -.1310221069336E+04, .6663188476562E+03},
 {   21099, .8185411132812E+04, -.1318297973633E+04, .6558381347656E+03},
 {   21100, .8172253417969E+04, -.1318095947266E+04, .6560182495117E+03},
 {   21101, .8184203125000E+04, -.1328005004883E+04, .6499868164062E+03},
 {   21102, .8170218261719E+04, -.1326611938477E+04, .6448791503906E+03},
 {   21103, .8165724121094E+04, -.1315645019531E+04, .6596673583984E+03},
 {   21104, .8173379882812E+04, -.1302875000000E+04, .6719015502930E+03},
 {   21105, .8165883789062E+04, -.1309399047852E+04, .6753112182617E+03},
 {   21106, .8175257812500E+04, -.1291179077148E+04, .6710494995117E+03},
 {   21107, .8174665039062E+04, -.1279182128906E+04, .6713177490234E+03},
 {   21108, .8175041503906E+04, -.1293229003906E+04, .6763843383789E+03},
 {   21109, .8174713378906E+04, -.1281683105469E+04, .6765330810547E+03},
 {   21110, .8172145507812E+04, -.1304274047852E+04, .6777023925781E+03},
 {   21111, .8162890136719E+04, -.1305486083984E+04, .6819089965820E+03},
 {   21112, .8166196777344E+04, -.1300835083008E+04, .6891705322266E+03},
 {   21113, .8155274414062E+04, -.1304347045898E+04, .6801350097656E+03},
 {   21114, .8153236328125E+04, -.1299486083984E+04, .6862991943359E+03},
 {   21115, .8159240234375E+04, -.1296118041992E+04, .6920459594727E+03},
 {   21116, .8144387695312E+04, -.1292481079102E+04, .6903225097656E+03},
 {   21117, .8152935058594E+04, -.1288765014648E+04, .6946998291016E+03},
 {   21118, .8174981933594E+04, -.1290330078125E+04, .6876486816406E+03},
 {   21119, .8165778320312E+04, -.1294777099609E+04, .6963136596680E+03},
 {   21120, .8159463378906E+04, -.1283169067383E+04, .6991854858398E+03},
 {   21121, .8166646972656E+04, -.1285310058594E+04, .6959179077148E+03},
 {   21122, .8173826660156E+04, -.1287451049805E+04, .6926528320312E+03},
 {   21123, .8159246582031E+04, -.1313307983398E+04, .6626126708984E+03},
 {   21124, .8146236328125E+04, -.1308718017578E+04, .6684387817383E+03},
 {   21125, .8144847167969E+04, -.1298847045898E+04, .6848750000000E+03},
 {   21126, .8132483886719E+04, -.1305202026367E+04, .6734911499023E+03},
 {   21127, .8134997558594E+04, -.1292385009766E+04, .6893530883789E+03},
 {   21128, .8128320312500E+04, -.1297941040039E+04, .6837606201172E+03},
 {   21129, .8157240234375E+04, -.1324741943359E+04, .6437825927734E+03},
 {   21130, .8145136230469E+04, -.1318954956055E+04, .6504072265625E+03},
 {   21131, .8137200683594E+04, -.1312552978516E+04, .6611243286133E+03},
 {   21132, .8149484375000E+04, -.1285242065430E+04, .6951335449219E+03},
 {   21133, .8139930175781E+04, -.1287412109375E+04, .6907876586914E+03},
 {   21134, .8201374023438E+04, -.1391305908203E+04, .7366549072266E+03},
 {   21135, .8188732421875E+04, -.1390265869141E+04, .7450023193359E+03},
 {   21136, .8175354492188E+04, -.1386567871094E+04, .7492952880859E+03},
 {   21137, .8162284179688E+04, -.1380624877930E+04, .7494326782227E+03},
 {   21138, .8154787597656E+04, -.1374662841797E+04, .7450510864258E+03},
 {   21139, .8181108398438E+04, -.1387103881836E+04, .7527299194336E+03},
 {   21140, .8150018554688E+04, -.1371505859375E+04, .7485750122070E+03},
 {   21141, .8152742675781E+04, -.1374312866211E+04, .7564833984375E+03},
 {   21142, .8161440429688E+04, -.1381090820312E+04, .7726504516602E+03},
 {   21143, .8174674804688E+04, -.1385904907227E+04, .7685917358398E+03},
 {   21144, .8168287597656E+04, -.1382110839844E+04, .7585596313477E+03},
 {   21145, .8155469726562E+04, -.1377117919922E+04, .7643893432617E+03},
 {   21146, .8187911132812E+04, -.1390718872070E+04, .7645341186523E+03},
 {   21147, .8194665039062E+04, -.1387647827148E+04, .7465666503906E+03},
 {   21148, .8201910156250E+04, -.1391468872070E+04, .7592327880859E+03},
 {   21149, .8186063964844E+04, -.1187397216797E+04, .7373969116211E+03},
 {   21150, .8183397949219E+04, -.1192990234375E+04, .7297929077148E+03},
 {   21151, .8175348144531E+04, -.1195462280273E+04, .7319461669922E+03},
 {   21152, .8175565917969E+04, -.1191159301758E+04, .7392688598633E+03},
 {   21153, .8167691894531E+04, -.1199380249023E+04, .7312588500977E+03},
 {   21154, .8165769042969E+04, -.1195968261719E+04, .7387557983398E+03},
 {   21155, .8161599121094E+04, -.1204153198242E+04, .7278294677734E+03},
 {   21156, .8157501464844E+04, -.1201871215820E+04, .7350997314453E+03},
 {   21157, .8206590820312E+04, -.1198064208984E+04, .7023166503906E+03},
 {   21158, .8198257812500E+04, -.1200537231445E+04, .7046967773438E+03},
 {   21159, .8195048828125E+04, -.1205307250977E+04, .6989555053711E+03},
 {   21160, .8200710937500E+04, -.1204582275391E+04, .6956728515625E+03},
 {   21161, .8189380859375E+04, -.1210041259766E+04, .6952495117188E+03},
 {   21162, .8193001953125E+04, -.1210765258789E+04, .6910818481445E+03},
 {   21163, .8150731445312E+04, -.1208305175781E+04, .7293173828125E+03},
 {   21164, .8157970703125E+04, -.1209063232422E+04, .7221807861328E+03},
 {   21165, .8158027343750E+04, -.1214820190430E+04, .7120952148438E+03},
 {   21166, .8151365722656E+04, -.1215535156250E+04, .7161989135742E+03},
 {   21167, .8164023437500E+04, -.1217676147461E+04, .7022996826172E+03},
 {   21168, .8158225585938E+04, -.1221054199219E+04, .7010650024414E+03},
 {   21169, .8174180175781E+04, -.1216778198242E+04, .6957087402344E+03},
 {   21170, .8172843750000E+04, -.1220653198242E+04, .6900249633789E+03},
 {   21171, .8182165527344E+04, -.1214201171875E+04, .6937914428711E+03},
 {   21172, .8183390136719E+04, -.1216129150391E+04, .6894450073242E+03},
 {   21173, .8190524902344E+04, -.1192328247070E+04, .7252199707031E+03},
 {   21174, .8194929687500E+04, -.1187517333984E+04, .7300856323242E+03},
 {   21175, .8195831054688E+04, -.1193524291992E+04, .7188729858398E+03},
 {   21176, .8201772460938E+04, -.1189237304688E+04, .7215860595703E+03},
 {   21177, .8198541015625E+04, -.1196400268555E+04, .7116846313477E+03},
 {   21178, .8205461914062E+04, -.1192981201172E+04, .7120859375000E+03},
 {   21179, .8277112304688E+04, -.1240016113281E+04, .7090800170898E+03},
 {   21180, .8286263671875E+04, -.1236784179688E+04, .7233074951172E+03},
 {   21181, .8263960937500E+04, -.1229393188477E+04, .7365703735352E+03},
 {   21182, .8251115234375E+04, -.1237024169922E+04, .7208850708008E+03},
 {   21183, .8239477539062E+04, -.1218603149414E+04, .7476413574219E+03},
 {   21184, .8226044921875E+04, -.1229441162109E+04, .7323002929688E+03},
 {   21185, .8212415039062E+04, -.1214866210938E+04, .7587783813477E+03},
 {   21186, .8199932617188E+04, -.1228099121094E+04, .7441720581055E+03},
 {   21187, .8184838867188E+04, -.1212254150391E+04, .7691708984375E+03},
 {   21188, .8173917480469E+04, -.1225550170898E+04, .7560013427734E+03},
 {   21189, .8162509277344E+04, -.1199680175781E+04, .7770828247070E+03},
 {   21190, .8154065429688E+04, -.1208142211914E+04, .7650286865234E+03},
 {   21191, .8294713867188E+04, -.1233652099609E+04, .7379376220703E+03},
 {   21192, .8275943359375E+04, -.1222289184570E+04, .7529920654297E+03},
 {   21193, .8251888671875E+04, -.1208723266602E+04, .7640485839844E+03},
 {   21194, .8223711914062E+04, -.1203017211914E+04, .7747803955078E+03},
 {   21195, .8194413085938E+04, -.1200771240234E+04, .7840687255859E+03},
 {   21196, .8169445312500E+04, -.1193460205078E+04, .7911956176758E+03},
 {   21197, .8301880859375E+04, -.1229968139648E+04, .7530357666016E+03},
 {   21198, .8286773437500E+04, -.1215133178711E+04, .7699930419922E+03},
 {   21199, .8263277343750E+04, -.1199288208008E+04, .7811513671875E+03},
 {   21200, .8234124023438E+04, -.1192114257812E+04, .7915908203125E+03},
 {   21201, .8203229492188E+04, -.1190732177734E+04, .7998900756836E+03},
 {   21202, .8175760742188E+04, -.1189182250977E+04, .8063468627930E+03},
 {   21203, .8307330078125E+04, -.1224108154297E+04, .7680354003906E+03},
 {   21204, .8297159179688E+04, -.12