// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: WellBoreViewerEnginePluginInfo.C
// ****************************************************************************

#include <WellBorePluginInfo.h>
#include <avtWellBorePlot.h>
#include <WellBoreAttributes.h>

//
// Storage for static data elements.
//
WellBoreAttributes *WellBoreViewerEnginePluginInfo::clientAtts = NULL;
WellBoreAttributes *WellBoreViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
// Method:  WellBoreViewerEnginePluginInfo::InitializeGlobalObjects
//
// Purpose:
//   Initialize the plot atts.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************
void
WellBoreViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (WellBoreViewerEnginePluginInfo::clientAtts == NULL)
    {
        WellBoreViewerEnginePluginInfo::clientAtts  = new WellBoreAttributes;
        WellBoreViewerEnginePluginInfo::defaultAtts = new WellBoreAttributes;
    }

    InitializeDefaultPalette(clientAtts);
    InitializeDefaultPalette(defaultAtts);
}


// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
WellBoreViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
WellBoreViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(WellBoreAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(WellBoreAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
WellBoreViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtWellBorePlot;
}

// ****************************************************************************
// Method: WellBoreViewerEnginePluginInfo::InitializePlotAtts
//
// Purpose:
//   Initialize the plot attributes to the default attributes.
//
// Arguments:
//   atts       The attribute subject to initialize.
//   plot       The viewer plot whose attributes are getting initialized.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************

void
WellBoreViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    WellBoreAttributes *wellBore = (WellBoreAttributes *)atts;
    *wellBore = *defaultAtts;

    // Set the defaultPalette for the plot.
    InitializeDefaultPalette(wellBore);
}

// ****************************************************************************
//  Method: WellBoreViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WellBoreViewerEnginePluginInfo::GetMenuName() const
{
    return "Well Bore";
}

// ****************************************************************************
// Method: WellBoreViewerEnginePluginInfo::InitializeDefaultPalette
//
// Purpose:
//   Initializes the default palette in the wellBore attributes using the
//   default discrete color table.
//
// Arguments:
//   wellBore   The WellBoreAttributes to initialize.
//
// Programmer: Eric Brugger
// Creation:   October 1, 2008
//
// Modifications:
//
// ****************************************************************************
#include <avtColorTables.h>
#include <ColorTableAttributes.h>
void
WellBoreViewerEnginePluginInfo::InitializeDefaultPalette(
    WellBoreAttributes *wellBore)
{
    // Copy over the wellBore's defaultPalette with the default discrete
    // color table from avtColorTable.
    if(wellBore->GetColorType() != WellBoreAttributes::ColorByMultipleColors ||
       wellBore->GetDefaultPalette().GetNumControlPoints() < 1)
    {
        avtColorTables *ct = avtColorTables::Instance();
        ColorTableAttributes *ctAtts = ct->GetColorTables();
        int i = ctAtts->GetColorTableIndex(ct->GetDefaultDiscreteColorTable());
        if(i != -1)
        {
            wellBore->SetDefaultPalette(ctAtts->operator[](i));
        }
    }
}

