// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: WellBorePluginInfo.C
// ****************************************************************************

#include <WellBorePluginInfo.h>
#include <WellBoreAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(WellBore,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(WellBore,General)

// ****************************************************************************
//  Method: WellBoreGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WellBoreGeneralPluginInfo::GetName() const
{
    return "WellBore";
}

// ****************************************************************************
//  Method: WellBoreGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WellBoreGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: WellBoreGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
WellBoreGeneralPluginInfo::GetID() const
{
    return "WellBore_1.0";
}
// ****************************************************************************
//  Method: WellBoreGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
WellBoreGeneralPluginInfo::EnabledByDefault() const
{
    return false;
}
