// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: WellBoreGUIPluginInfo.C
// ****************************************************************************

#include <WellBorePluginInfo.h>
#include <WellBoreAttributes.h>
#include <QApplication>
#include <QvisWellBorePlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(WellBore,GUI)

// ****************************************************************************
//  Method: WellBoreGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
WellBoreGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Well Bore"));
}


// ****************************************************************************
//  Method: WellBoreGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
WellBoreGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisWellBorePlotWindow(type, (WellBoreAttributes *)attr,
        caption, shortName, notepad);
}

