// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: WellBoreCommonPluginInfo.C
// ****************************************************************************

#include <WellBorePluginInfo.h>
#include <WellBoreAttributes.h>

// ****************************************************************************
//  Method: WellBoreCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
WellBoreCommonPluginInfo::AllocAttributes()
{
    return new WellBoreAttributes;
}

// ****************************************************************************
//  Method: WellBoreCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a WellBore attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
WellBoreCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((WellBoreAttributes *) to) = *((WellBoreAttributes *) from);
}

// ****************************************************************************
// Method: WellBoreCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
WellBoreCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_MESH;
}

