// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  VolumeScriptingPluginInfo.C
// ************************************************************************* //
#include <PyVolumeAttributes.h>
#include <VolumePluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Volume,Scripting)

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VolumeScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyVolumeAttributes_StartUp((VolumeAttributes *)subj, data);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
VolumeScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyVolumeAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Volume plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VolumeScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyVolumeAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
VolumeScriptingPluginInfo::GetLogString()
{
    std::string s(PyVolumeAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: VolumeScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VolumeScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyVolumeAttributes_SetDefaults((const VolumeAttributes *)atts);
}
