// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VolumePluginInfo.C
// ****************************************************************************

#include <VolumePluginInfo.h>
#include <VolumeAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Volume,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Volume,General)

// ****************************************************************************
//  Method: VolumeGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VolumeGeneralPluginInfo::GetName() const
{
    return "Volume";
}

// ****************************************************************************
//  Method: VolumeGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VolumeGeneralPluginInfo::GetVersion() const
{
    return "1.1";
}

// ****************************************************************************
//  Method: VolumeGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
VolumeGeneralPluginInfo::GetID() const
{
    return "Volume_1.1";
}
// ****************************************************************************
//  Method: VolumeGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
VolumeGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
