// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VolumeGUIPluginInfo.C
// ****************************************************************************

#include <VolumePluginInfo.h>
#include <VolumeAttributes.h>
#include <QApplication>
#include <QvisVolumePlotWindow.h>

VISIT_PLOT_PLUGIN_ENTRY(Volume,GUI)

// ****************************************************************************
//  Method: VolumeGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
VolumeGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("PlotNames", "Volume"));
}


// ****************************************************************************
//  Method: VolumeGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an plot's attribute window.
//
//  Arguments:
//    type      The type of the plot.
//    attr      The attribute subject for the plot.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the plot's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
VolumeGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisVolumePlotWindow(type, (VolumeAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: VolumeGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Volume.xpm>
const char **
VolumeGUIPluginInfo::XPMIconData() const
{
    return Volume_xpm;
}

