// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VolumeCommonPluginInfo.C
// ****************************************************************************

#include <VolumePluginInfo.h>
#include <VolumeAttributes.h>

// ****************************************************************************
//  Method: VolumeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VolumeCommonPluginInfo::AllocAttributes()
{
    return new VolumeAttributes;
}

// ****************************************************************************
//  Method: VolumeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Volume attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VolumeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((VolumeAttributes *) to) = *((VolumeAttributes *) from);
}

// ****************************************************************************
// Method: VolumeCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
VolumeCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_SCALAR | VAR_CATEGORY_SPECIES;
}

