// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: VectorCommonPluginInfo.C
// ****************************************************************************

#include <VectorPluginInfo.h>
#include <VectorAttributes.h>

// ****************************************************************************
//  Method: VectorCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
VectorCommonPluginInfo::AllocAttributes()
{
    return new VectorAttributes;
}

// ****************************************************************************
//  Method: VectorCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Vector attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
VectorCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((VectorAttributes *) to) = *((VectorAttributes *) from);
}

// ****************************************************************************
// Method: VectorCommonPluginInfo::GetVariableTypes
//
// Purpose:
//   Returns a flag indicating the types of variables that can be put in the
//   plot's variable list.
//
// Returns:    A flag indicating the types of variables that can be put in
//             the plot's variable list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

int
VectorCommonPluginInfo::GetVariableTypes() const
{
    return VAR_CATEGORY_VECTOR;
}

