// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <VectorAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for VectorAttributes::Quality
//

static const char *Quality_strings[] = {
"Fast", "High"};

std::string
VectorAttributes::Quality_ToString(VectorAttributes::Quality t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Quality_strings[index];
}

std::string
VectorAttributes::Quality_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Quality_strings[index];
}

bool
VectorAttributes::Quality_FromString(const std::string &s, VectorAttributes::Quality &val)
{
    val = VectorAttributes::Fast;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Quality_strings[i])
        {
            val = (Quality)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::OriginType
//

static const char *OriginType_strings[] = {
"Head", "Middle", "Tail"
};

std::string
VectorAttributes::OriginType_ToString(VectorAttributes::OriginType t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return OriginType_strings[index];
}

std::string
VectorAttributes::OriginType_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return OriginType_strings[index];
}

bool
VectorAttributes::OriginType_FromString(const std::string &s, VectorAttributes::OriginType &val)
{
    val = VectorAttributes::Head;
    for(int i = 0; i < 3; ++i)
    {
        if(s == OriginType_strings[i])
        {
            val = (OriginType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::GlyphType
//

static const char *GlyphType_strings[] = {
"Arrow", "Ellipsoid"};

std::string
VectorAttributes::GlyphType_ToString(VectorAttributes::GlyphType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return GlyphType_strings[index];
}

std::string
VectorAttributes::GlyphType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return GlyphType_strings[index];
}

bool
VectorAttributes::GlyphType_FromString(const std::string &s, VectorAttributes::GlyphType &val)
{
    val = VectorAttributes::Arrow;
    for(int i = 0; i < 2; ++i)
    {
        if(s == GlyphType_strings[i])
        {
            val = (GlyphType)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::LineStem
//

static const char *LineStem_strings[] = {
"Cylinder", "Line"};

std::string
VectorAttributes::LineStem_ToString(VectorAttributes::LineStem t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LineStem_strings[index];
}

std::string
VectorAttributes::LineStem_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LineStem_strings[index];
}

bool
VectorAttributes::LineStem_FromString(const std::string &s, VectorAttributes::LineStem &val)
{
    val = VectorAttributes::Cylinder;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LineStem_strings[i])
        {
            val = (LineStem)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::LimitsMode
//

static const char *LimitsMode_strings[] = {
"OriginalData", "CurrentPlot"};

std::string
VectorAttributes::LimitsMode_ToString(VectorAttributes::LimitsMode t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return LimitsMode_strings[index];
}

std::string
VectorAttributes::LimitsMode_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return LimitsMode_strings[index];
}

bool
VectorAttributes::LimitsMode_FromString(const std::string &s, VectorAttributes::LimitsMode &val)
{
    val = VectorAttributes::OriginalData;
    for(int i = 0; i < 2; ++i)
    {
        if(s == LimitsMode_strings[i])
        {
            val = (LimitsMode)i;
            return true;
        }
    }
    return false;
}

//
// Enum conversion methods for VectorAttributes::GlyphLocation
//

static const char *GlyphLocation_strings[] = {
"AdaptsToMeshResolution", "UniformInSpace"};

std::string
VectorAttributes::GlyphLocation_ToString(VectorAttributes::GlyphLocation t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return GlyphLocation_strings[index];
}

std::string
VectorAttributes::GlyphLocation_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return GlyphLocation_strings[index];
}

bool
VectorAttributes::GlyphLocation_FromString(const std::string &s, VectorAttributes::GlyphLocation &val)
{
    val = VectorAttributes::AdaptsToMeshResolution;
    for(int i = 0; i < 2; ++i)
    {
        if(s == GlyphLocation_strings[i])
        {
            val = (GlyphLocation)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Init utility for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void VectorAttributes::Init()
{
    glyphLocation = AdaptsToMeshResolution;
    useStride = false;
    nVectors = 400;
    stride = 1;
    origOnly = true;
    limitsMode = OriginalData;
    minFlag = false;
    min = 0;
    maxFlag = false;
    max = 1;
    colorByMagnitude = true;
    invertColorTable = false;
    useLegend = true;
    scale = 0.25;
    scaleByMagnitude = true;
    autoScale = true;
    glyphType = Arrow;
    headOn = true;
    headSize = 0.25;
    lineStem = Line;
    lineWidth = 0;
    stemWidth = 0.08;
    vectorOrigin = Tail;
    geometryQuality = Fast;
    animationStep = 0;

    VectorAttributes::SelectAll();
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Copy utility for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void VectorAttributes::Copy(const VectorAttributes &obj)
{
    glyphLocation = obj.glyphLocation;
    useStride = obj.useStride;
    nVectors = obj.nVectors;
    stride = obj.stride;
    origOnly = obj.origOnly;
    limitsMode = obj.limitsMode;
    minFlag = obj.minFlag;
    min = obj.min;
    maxFlag = obj.maxFlag;
    max = obj.max;
    colorByMagnitude = obj.colorByMagnitude;
    colorTableName = obj.colorTableName;
    invertColorTable = obj.invertColorTable;
    vectorColor = obj.vectorColor;
    useLegend = obj.useLegend;
    scale = obj.scale;
    scaleByMagnitude = obj.scaleByMagnitude;
    autoScale = obj.autoScale;
    glyphType = obj.glyphType;
    headOn = obj.headOn;
    headSize = obj.headSize;
    lineStem = obj.lineStem;
    lineWidth = obj.lineWidth;
    stemWidth = obj.stemWidth;
    vectorOrigin = obj.vectorOrigin;
    geometryQuality = obj.geometryQuality;
    animationStep = obj.animationStep;

    VectorAttributes::SelectAll();
}

// Type map format string
const char *VectorAttributes::TypeMapFormatString = VECTORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t VectorAttributes::TmfsStruct = {VECTORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Default constructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes::VectorAttributes() :
    AttributeSubject(VectorAttributes::TypeMapFormatString),
    colorTableName("Default"), vectorColor(0, 0, 0)
{
    VectorAttributes::Init();
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Constructor for the derived classes of VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes::VectorAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    colorTableName("Default"), vectorColor(0, 0, 0)
{
    VectorAttributes::Init();
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Copy constructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes::VectorAttributes(const VectorAttributes &obj) :
    AttributeSubject(VectorAttributes::TypeMapFormatString)
{
    VectorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: VectorAttributes::VectorAttributes
//
// Purpose:
//   Copy constructor for derived classes of the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes::VectorAttributes(const VectorAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    VectorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: VectorAttributes::~VectorAttributes
//
// Purpose:
//   Destructor for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes::~VectorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: VectorAttributes::operator =
//
// Purpose:
//   Assignment operator for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

VectorAttributes&
VectorAttributes::operator = (const VectorAttributes &obj)
{
    if (this == &obj) return *this;

    VectorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: VectorAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorAttributes::operator == (const VectorAttributes &obj) const
{
    // Create the return value
    return ((glyphLocation == obj.glyphLocation) &&
            (useStride == obj.useStride) &&
            (nVectors == obj.nVectors) &&
            (stride == obj.stride) &&
            (origOnly == obj.origOnly) &&
            (limitsMode == obj.limitsMode) &&
            (minFlag == obj.minFlag) &&
            (min == obj.min) &&
            (maxFlag == obj.maxFlag) &&
            (max == obj.max) &&
            (colorByMagnitude == obj.colorByMagnitude) &&
            (colorTableName == obj.colorTableName) &&
            (invertColorTable == obj.invertColorTable) &&
            (vectorColor == obj.vectorColor) &&
            (useLegend == obj.useLegend) &&
            (scale == obj.scale) &&
            (scaleByMagnitude == obj.scaleByMagnitude) &&
            (autoScale == obj.autoScale) &&
            (glyphType == obj.glyphType) &&
            (headOn == obj.headOn) &&
            (headSize == obj.headSize) &&
            (lineStem == obj.lineStem) &&
            (lineWidth == obj.lineWidth) &&
            (stemWidth == obj.stemWidth) &&
            (vectorOrigin == obj.vectorOrigin) &&
            (geometryQuality == obj.geometryQuality) &&
            (animationStep == obj.animationStep));
}

// ****************************************************************************
// Method: VectorAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorAttributes::operator != (const VectorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: VectorAttributes::TypeName
//
// Purpose:
//   Type name method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
VectorAttributes::TypeName() const
{
    return "VectorAttributes";
}

// ****************************************************************************
// Method: VectorAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const VectorAttributes *tmp = (const VectorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: VectorAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
VectorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new VectorAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: VectorAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the VectorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
VectorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new VectorAttributes(*this);
    else
        retval = new VectorAttributes;

    return retval;
}

// ****************************************************************************
// Method: VectorAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VectorAttributes::SelectAll()
{
    Select(ID_glyphLocation,    (void *)&glyphLocation);
    Select(ID_useStride,        (void *)&useStride);
    Select(ID_nVectors,         (void *)&nVectors);
    Select(ID_stride,           (void *)&stride);
    Select(ID_origOnly,         (void *)&origOnly);
    Select(ID_limitsMode,       (void *)&limitsMode);
    Select(ID_minFlag,          (void *)&minFlag);
    Select(ID_min,              (void *)&min);
    Select(ID_maxFlag,          (void *)&maxFlag);
    Select(ID_max,              (void *)&max);
    Select(ID_colorByMagnitude, (void *)&colorByMagnitude);
    Select(ID_colorTableName,   (void *)&colorTableName);
    Select(ID_invertColorTable, (void *)&invertColorTable);
    Select(ID_vectorColor,      (void *)&vectorColor);
    Select(ID_useLegend,        (void *)&useLegend);
    Select(ID_scale,            (void *)&scale);
    Select(ID_scaleByMagnitude, (void *)&scaleByMagnitude);
    Select(ID_autoScale,        (void *)&autoScale);
    Select(ID_glyphType,        (void *)&glyphType);
    Select(ID_headOn,           (void *)&headOn);
    Select(ID_headSize,         (void *)&headSize);
    Select(ID_lineStem,         (void *)&lineStem);
    Select(ID_lineWidth,        (void *)&lineWidth);
    Select(ID_stemWidth,        (void *)&stemWidth);
    Select(ID_vectorOrigin,     (void *)&vectorOrigin);
    Select(ID_geometryQuality,  (void *)&geometryQuality);
    Select(ID_animationStep,    (void *)&animationStep);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VectorAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    VectorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for VectorAttributes.
    DataNode *node = new DataNode("VectorAttributes");

    if(completeSave || !FieldsEqual(ID_glyphLocation, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("glyphLocation", GlyphLocation_ToString(glyphLocation)));
    }

    if(completeSave || !FieldsEqual(ID_useStride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useStride", useStride));
    }

    if(completeSave || !FieldsEqual(ID_nVectors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nVectors", nVectors));
    }

    if(completeSave || !FieldsEqual(ID_stride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(ID_origOnly, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("origOnly", origOnly));
    }

    if(completeSave || !FieldsEqual(ID_limitsMode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("limitsMode", LimitsMode_ToString(limitsMode)));
    }

    if(completeSave || !FieldsEqual(ID_minFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minFlag", minFlag));
    }

    if(completeSave || !FieldsEqual(ID_min, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("min", min));
    }

    if(completeSave || !FieldsEqual(ID_maxFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxFlag", maxFlag));
    }

    if(completeSave || !FieldsEqual(ID_max, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("max", max));
    }

    if(completeSave || !FieldsEqual(ID_colorByMagnitude, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorByMagnitude", colorByMagnitude));
    }

    if(completeSave || !FieldsEqual(ID_colorTableName, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorTableName", colorTableName));
    }

    if(completeSave || !FieldsEqual(ID_invertColorTable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("invertColorTable", invertColorTable));
    }

        DataNode *vectorColorNode = new DataNode("vectorColor");
        if(vectorColor.CreateNode(vectorColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(vectorColorNode);
        }
        else
            delete vectorColorNode;
    if(completeSave || !FieldsEqual(ID_useLegend, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useLegend", useLegend));
    }

    if(completeSave || !FieldsEqual(ID_scale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scale", scale));
    }

    if(completeSave || !FieldsEqual(ID_scaleByMagnitude, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleByMagnitude", scaleByMagnitude));
    }

    if(completeSave || !FieldsEqual(ID_autoScale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoScale", autoScale));
    }

    if(completeSave || !FieldsEqual(ID_glyphType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("glyphType", GlyphType_ToString(glyphType)));
    }

    if(completeSave || !FieldsEqual(ID_headOn, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("headOn", headOn));
    }

    if(completeSave || !FieldsEqual(ID_headSize, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("headSize", headSize));
    }

    if(completeSave || !FieldsEqual(ID_lineStem, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineStem", LineStem_ToString(lineStem)));
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(ID_stemWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stemWidth", stemWidth));
    }

    if(completeSave || !FieldsEqual(ID_vectorOrigin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("vectorOrigin", OriginType_ToString(vectorOrigin)));
    }

    if(completeSave || !FieldsEqual(ID_geometryQuality, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("geometryQuality", Quality_ToString(geometryQuality)));
    }

    if(completeSave || !FieldsEqual(ID_animationStep, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("animationStep", animationStep));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: VectorAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
VectorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("VectorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("glyphLocation")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetGlyphLocation(GlyphLocation(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            GlyphLocation value;
            if(GlyphLocation_FromString(node->AsString(), value))
                SetGlyphLocation(value);
        }
    }
    if((node = searchNode->GetNode("useStride")) != 0)
        SetUseStride(node->AsBool());
    if((node = searchNode->GetNode("nVectors")) != 0)
        SetNVectors(node->AsInt());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("origOnly")) != 0)
        SetOrigOnly(node->AsBool());
    if((node = searchNode->GetNode("limitsMode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLimitsMode(LimitsMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LimitsMode value;
            if(LimitsMode_FromString(node->AsString(), value))
                SetLimitsMode(value);
        }
    }
    if((node = searchNode->GetNode("minFlag")) != 0)
        SetMinFlag(node->AsBool());
    if((node = searchNode->GetNode("min")) != 0)
        SetMin(node->AsDouble());
    if((node = searchNode->GetNode("maxFlag")) != 0)
        SetMaxFlag(node->AsBool());
    if((node = searchNode->GetNode("max")) != 0)
        SetMax(node->AsDouble());
    if((node = searchNode->GetNode("colorByMagnitude")) != 0)
        SetColorByMagnitude(node->AsBool());
    if((node = searchNode->GetNode("colorTableName")) != 0)
        SetColorTableName(node->AsString());
    if((node = searchNode->GetNode("invertColorTable")) != 0)
        SetInvertColorTable(node->AsBool());
    if((node = searchNode->GetNode("vectorColor")) != 0)
        vectorColor.SetFromNode(node);
    if((node = searchNode->GetNode("useLegend")) != 0)
        SetUseLegend(node->AsBool());
    if((node = searchNode->GetNode("scale")) != 0)
        SetScale(node->AsDouble());
    if((node = searchNode->GetNode("scaleByMagnitude")) != 0)
        SetScaleByMagnitude(node->AsBool());
    if((node = searchNode->GetNode("autoScale")) != 0)
        SetAutoScale(node->AsBool());
    if((node = searchNode->GetNode("glyphType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetGlyphType(GlyphType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            GlyphType value;
            if(GlyphType_FromString(node->AsString(), value))
                SetGlyphType(value);
        }
    }
    if((node = searchNode->GetNode("headOn")) != 0)
        SetHeadOn(node->AsBool());
    if((node = searchNode->GetNode("headSize")) != 0)
        SetHeadSize(node->AsDouble());
    if((node = searchNode->GetNode("lineStem")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetLineStem(LineStem(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            LineStem value;
            if(LineStem_FromString(node->AsString(), value))
                SetLineStem(value);
        }
    }
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("stemWidth")) != 0)
        SetStemWidth(node->AsDouble());
    if((node = searchNode->GetNode("vectorOrigin")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetVectorOrigin(OriginType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            OriginType value;
            if(OriginType_FromString(node->AsString(), value))
                SetVectorOrigin(value);
        }
    }
    if((node = searchNode->GetNode("geometryQuality")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetGeometryQuality(Quality(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            Quality value;
            if(Quality_FromString(node->AsString(), value))
                SetGeometryQuality(value);
        }
    }
    if((node = searchNode->GetNode("animationStep")) != 0)
        SetAnimationStep(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
VectorAttributes::SetGlyphLocation(VectorAttributes::GlyphLocation glyphLocation_)
{
    glyphLocation = glyphLocation_;
    Select(ID_glyphLocation, (void *)&glyphLocation);
}

void
VectorAttributes::SetUseStride(bool useStride_)
{
    useStride = useStride_;
    Select(ID_useStride, (void *)&useStride);
}

void
VectorAttributes::SetNVectors(int nVectors_)
{
    nVectors = nVectors_;
    Select(ID_nVectors, (void *)&nVectors);
}

void
VectorAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(ID_stride, (void *)&stride);
}

void
VectorAttributes::SetOrigOnly(bool origOnly_)
{
    origOnly = origOnly_;
    Select(ID_origOnly, (void *)&origOnly);
}

void
VectorAttributes::SetLimitsMode(VectorAttributes::LimitsMode limitsMode_)
{
    limitsMode = limitsMode_;
    Select(ID_limitsMode, (void *)&limitsMode);
}

void
VectorAttributes::SetMinFlag(bool minFlag_)
{
    minFlag = minFlag_;
    Select(ID_minFlag, (void *)&minFlag);
}

void
VectorAttributes::SetMin(double min_)
{
    min = min_;
    Select(ID_min, (void *)&min);
}

void
VectorAttributes::SetMaxFlag(bool maxFlag_)
{
    maxFlag = maxFlag_;
    Select(ID_maxFlag, (void *)&maxFlag);
}

void
VectorAttributes::SetMax(double max_)
{
    max = max_;
    Select(ID_max, (void *)&max);
}

void
VectorAttributes::SetColorByMagnitude(bool colorByMagnitude_)
{
    colorByMagnitude = colorByMagnitude_;
    Select(ID_colorByMagnitude, (void *)&colorByMagnitude);
}

void
VectorAttributes::SetColorTableName(const std::string &colorTableName_)
{
    colorTableName = colorTableName_;
    Select(ID_colorTableName, (void *)&colorTableName);
}

void
VectorAttributes::SetInvertColorTable(bool invertColorTable_)
{
    invertColorTable = invertColorTable_;
    Select(ID_invertColorTable, (void *)&invertColorTable);
}

void
VectorAttributes::SetVectorColor(const ColorAttribute &vectorColor_)
{
    vectorColor = vectorColor_;
    Select(ID_vectorColor, (void *)&vectorColor);
}

void
VectorAttributes::SetUseLegend(bool useLegend_)
{
    useLegend = useLegend_;
    Select(ID_useLegend, (void *)&useLegend);
}

void
VectorAttributes::SetScale(double scale_)
{
    scale = scale_;
    Select(ID_scale, (void *)&scale);
}

void
VectorAttributes::SetScaleByMagnitude(bool scaleByMagnitude_)
{
    scaleByMagnitude = scaleByMagnitude_;
    Select(ID_scaleByMagnitude, (void *)&scaleByMagnitude);
}

void
VectorAttributes::SetAutoScale(bool autoScale_)
{
    autoScale = autoScale_;
    Select(ID_autoScale, (void *)&autoScale);
}

void
VectorAttributes::SetGlyphType(VectorAttributes::GlyphType glyphType_)
{
    glyphType = glyphType_;
    Select(ID_glyphType, (void *)&glyphType);
}

void
VectorAttributes::SetHeadOn(bool headOn_)
{
    headOn = headOn_;
    Select(ID_headOn, (void *)&headOn);
}

void
VectorAttributes::SetHeadSize(double headSize_)
{
    headSize = headSize_;
    Select(ID_headSize, (void *)&headSize);
}

void
VectorAttributes::SetLineStem(VectorAttributes::LineStem lineStem_)
{
    lineStem = lineStem_;
    Select(ID_lineStem, (void *)&lineStem);
}

void
VectorAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
VectorAttributes::SetStemWidth(double stemWidth_)
{
    stemWidth = stemWidth_;
    Select(ID_stemWidth, (void *)&stemWidth);
}

void
VectorAttributes::SetVectorOrigin(VectorAttributes::OriginType vectorOrigin_)
{
    vectorOrigin = vectorOrigin_;
    Select(ID_vectorOrigin, (void *)&vectorOrigin);
}

void
VectorAttributes::SetGeometryQuality(VectorAttributes::Quality geometryQuality_)
{
    geometryQuality = geometryQuality_;
    Select(ID_geometryQuality, (void *)&geometryQuality);
}

void
VectorAttributes::SetAnimationStep(int animationStep_)
{
    animationStep = animationStep_;
    Select(ID_animationStep, (void *)&animationStep);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

VectorAttributes::GlyphLocation
VectorAttributes::GetGlyphLocation() const
{
    return GlyphLocation(glyphLocation);
}

bool
VectorAttributes::GetUseStride() const
{
    return useStride;
}

int
VectorAttributes::GetNVectors() const
{
    return nVectors;
}

int
VectorAttributes::GetStride() const
{
    return stride;
}

bool
VectorAttributes::GetOrigOnly() const
{
    return origOnly;
}

VectorAttributes::LimitsMode
VectorAttributes::GetLimitsMode() const
{
    return LimitsMode(limitsMode);
}

bool
VectorAttributes::GetMinFlag() const
{
    return minFlag;
}

double
VectorAttributes::GetMin() const
{
    return min;
}

bool
VectorAttributes::GetMaxFlag() const
{
    return maxFlag;
}

double
VectorAttributes::GetMax() const
{
    return max;
}

bool
VectorAttributes::GetColorByMagnitude() const
{
    return colorByMagnitude;
}

const std::string &
VectorAttributes::GetColorTableName() const
{
    return colorTableName;
}

std::string &
VectorAttributes::GetColorTableName()
{
    return colorTableName;
}

bool
VectorAttributes::GetInvertColorTable() const
{
    return invertColorTable;
}

const ColorAttribute &
VectorAttributes::GetVectorColor() const
{
    return vectorColor;
}

ColorAttribute &
VectorAttributes::GetVectorColor()
{
    return vectorColor;
}

bool
VectorAttributes::GetUseLegend() const
{
    return useLegend;
}

double
VectorAttributes::GetScale() const
{
    return scale;
}

bool
VectorAttributes::GetScaleByMagnitude() const
{
    return scaleByMagnitude;
}

bool
VectorAttributes::GetAutoScale() const
{
    return autoScale;
}

VectorAttributes::GlyphType
VectorAttributes::GetGlyphType() const
{
    return GlyphType(glyphType);
}

bool
VectorAttributes::GetHeadOn() const
{
    return headOn;
}

double
VectorAttributes::GetHeadSize() const
{
    return headSize;
}

VectorAttributes::LineStem
VectorAttributes::GetLineStem() const
{
    return LineStem(lineStem);
}

int
VectorAttributes::GetLineWidth() const
{
    return lineWidth;
}

double
VectorAttributes::GetStemWidth() const
{
    return stemWidth;
}

VectorAttributes::OriginType
VectorAttributes::GetVectorOrigin() const
{
    return OriginType(vectorOrigin);
}

VectorAttributes::Quality
VectorAttributes::GetGeometryQuality() const
{
    return Quality(geometryQuality);
}

int
VectorAttributes::GetAnimationStep() const
{
    return animationStep;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
VectorAttributes::SelectColorTableName()
{
    Select(ID_colorTableName, (void *)&colorTableName);
}

void
VectorAttributes::SelectVectorColor()
{
    Select(ID_vectorColor, (void *)&vectorColor);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VectorAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
VectorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_glyphLocation:    return "glyphLocation";
    case ID_useStride:        return "useStride";
    case ID_nVectors:         return "nVectors";
    case ID_stride:           return "stride";
    case ID_origOnly:         return "origOnly";
    case ID_limitsMode:       return "limitsMode";
    case ID_minFlag:          return "minFlag";
    case ID_min:              return "min";
    case ID_maxFlag:          return "maxFlag";
    case ID_max:              return "max";
    case ID_colorByMagnitude: return "colorByMagnitude";
    case ID_colorTableName:   return "colorTableName";
    case ID_invertColorTable: return "invertColorTable";
    case ID_vectorColor:      return "vectorColor";
    case ID_useLegend:        return "useLegend";
    case ID_scale:            return "scale";
    case ID_scaleByMagnitude: return "scaleByMagnitude";
    case ID_autoScale:        return "autoScale";
    case ID_glyphType:        return "glyphType";
    case ID_headOn:           return "headOn";
    case ID_headSize:         return "headSize";
    case ID_lineStem:         return "lineStem";
    case ID_lineWidth:        return "lineWidth";
    case ID_stemWidth:        return "stemWidth";
    case ID_vectorOrigin:     return "vectorOrigin";
    case ID_geometryQuality:  return "geometryQuality";
    case ID_animationStep:    return "animationStep";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VectorAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
VectorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_glyphLocation:    return FieldType_enum;
    case ID_useStride:        return FieldType_bool;
    case ID_nVectors:         return FieldType_int;
    case ID_stride:           return FieldType_int;
    case ID_origOnly:         return FieldType_bool;
    case ID_limitsMode:       return FieldType_enum;
    case ID_minFlag:          return FieldType_bool;
    case ID_min:              return FieldType_double;
    case ID_maxFlag:          return FieldType_bool;
    case ID_max:              return FieldType_double;
    case ID_colorByMagnitude: return FieldType_bool;
    case ID_colorTableName:   return FieldType_colortable;
    case ID_invertColorTable: return FieldType_bool;
    case ID_vectorColor:      return FieldType_color;
    case ID_useLegend:        return FieldType_bool;
    case ID_scale:            return FieldType_double;
    case ID_scaleByMagnitude: return FieldType_bool;
    case ID_autoScale:        return FieldType_bool;
    case ID_glyphType:        return FieldType_enum;
    case ID_headOn:           return FieldType_bool;
    case ID_headSize:         return FieldType_double;
    case ID_lineStem:         return FieldType_enum;
    case ID_lineWidth:        return FieldType_linewidth;
    case ID_stemWidth:        return FieldType_double;
    case ID_vectorOrigin:     return FieldType_enum;
    case ID_geometryQuality:  return FieldType_enum;
    case ID_animationStep:    return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: VectorAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
VectorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_glyphLocation:    return "enum";
    case ID_useStride:        return "bool";
    case ID_nVectors:         return "int";
    case ID_stride:           return "int";
    case ID_origOnly:         return "bool";
    case ID_limitsMode:       return "enum";
    case ID_minFlag:          return "bool";
    case ID_min:              return "double";
    case ID_maxFlag:          return "bool";
    case ID_max:              return "double";
    case ID_colorByMagnitude: return "bool";
    case ID_colorTableName:   return "colortable";
    case ID_invertColorTable: return "bool";
    case ID_vectorColor:      return "color";
    case ID_useLegend:        return "bool";
    case ID_scale:            return "double";
    case ID_scaleByMagnitude: return "bool";
    case ID_autoScale:        return "bool";
    case ID_glyphType:        return "enum";
    case ID_headOn:           return "bool";
    case ID_headSize:         return "double";
    case ID_lineStem:         return "enum";
    case ID_lineWidth:        return "linewidth";
    case ID_stemWidth:        return "double";
    case ID_vectorOrigin:     return "enum";
    case ID_geometryQuality:  return "enum";
    case ID_animationStep:    return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VectorAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
VectorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const VectorAttributes &obj = *((const VectorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_glyphLocation:
        {  // new scope
        retval = (glyphLocation == obj.glyphLocation);
        }
        break;
    case ID_useStride:
        {  // new scope
        retval = (useStride == obj.useStride);
        }
        break;
    case ID_nVectors:
        {  // new scope
        retval = (nVectors == obj.nVectors);
        }
        break;
    case ID_stride:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case ID_origOnly:
        {  // new scope
        retval = (origOnly == obj.origOnly);
        }
        break;
    case ID_limitsMode:
        {  // new scope
        retval = (limitsMode == obj.limitsMode);
        }
        break;
    case ID_minFlag:
        {  // new scope
        retval = (minFlag == obj.minFlag);
        }
        break;
    case ID_min:
        {  // new scope
        retval = (min == obj.min);
        }
        break;
    case ID_maxFlag:
        {  // new scope
        retval = (maxFlag == obj.maxFlag);
        }
        break;
    case ID_max:
        {  // new scope
        retval = (max == obj.max);
        }
        break;
    case ID_colorByMagnitude:
        {  // new scope
        retval = (colorByMagnitude == obj.colorByMagnitude);
        }
        break;
    case ID_colorTableName:
        {  // new scope
        retval = (colorTableName == obj.colorTableName);
        }
        break;
    case ID_invertColorTable:
        {  // new scope
        retval = (invertColorTable == obj.invertColorTable);
        }
        break;
    case ID_vectorColor:
        {  // new scope
        retval = (vectorColor == obj.vectorColor);
        }
        break;
    case ID_useLegend:
        {  // new scope
        retval = (useLegend == obj.useLegend);
        }
        break;
    case ID_scale:
        {  // new scope
        retval = (scale == obj.scale);
        }
        break;
    case ID_scaleByMagnitude:
        {  // new scope
        retval = (scaleByMagnitude == obj.scaleByMagnitude);
        }
        break;
    case ID_autoScale:
        {  // new scope
        retval = (autoScale == obj.autoScale);
        }
        break;
    case ID_glyphType:
        {  // new scope
        retval = (glyphType == obj.glyphType);
        }
        break;
    case ID_headOn:
        {  // new scope
        retval = (headOn == obj.headOn);
        }
        break;
    case ID_headSize:
        {  // new scope
        retval = (headSize == obj.headSize);
        }
        break;
    case ID_lineStem:
        {  // new scope
        retval = (lineStem == obj.lineStem);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_stemWidth:
        {  // new scope
        retval = (stemWidth == obj.stemWidth);
        }
        break;
    case ID_vectorOrigin:
        {  // new scope
        retval = (vectorOrigin == obj.vectorOrigin);
        }
        break;
    case ID_geometryQuality:
        {  // new scope
        retval = (geometryQuality == obj.geometryQuality);
        }
        break;
    case ID_animationStep:
        {  // new scope
        retval = (animationStep == obj.animationStep);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VectorAttributes::ProcessOldVersions
//
// Purpose:
//   This method allows handling of older config/session files that may
//   contain fields that are no longer present or have been modified/renamed.
//
// Programmer: Kathleen Biagas
// Creation:   April 4, 2018
//
// Modifications:
//
// ****************************************************************************

void
VectorAttributes::ProcessOldVersions(DataNode *parentNode,
                                    const char *configVersion)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("VectorAttributes");
    if(searchNode == 0)
        return;

    if (VersionLessThan(configVersion, "3.0.0"))
    {
        if (searchNode->GetNode("lineStyle") != 0)
            searchNode->RemoveNode("lineStyle");
    }

    if (VersionLessThan(configVersion, "3.2.0"))
    {
        DataNode *k = 0;
        if((k = searchNode->GetNode("colorByMag")) != 0)
	{
            searchNode->AddNode(new DataNode("colorByMagnitude", k->AsBool()));
            searchNode->RemoveNode(k, true);
	}
    }
}

bool
VectorAttributes::ChangesRequireRecalculation(const VectorAttributes &obj)
{
    return ((glyphLocation != obj.glyphLocation) ||
            (useStride != obj.useStride) ||
            (stride != obj.stride) ||
            (glyphLocation != obj.glyphLocation) ||
            (nVectors != obj.nVectors) ||
            (origOnly != obj.origOnly));
}

#include <math.h>
double
VectorAttributes::GetAnimationScale() const
{
    const int nsteps = 100;
    double angle = 2.* M_PI * (double(animationStep % nsteps) / double(nsteps-1));
    return 0.75 + 0.25 * cos(angle);
}

