// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  TruecolorScriptingPluginInfo.C
// ************************************************************************* //
#include <PyTruecolorAttributes.h>
#include <TruecolorPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Truecolor,Scripting)

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TruecolorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyTruecolorAttributes_StartUp((TruecolorAttributes *)subj, data);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
TruecolorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTruecolorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Truecolor plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
TruecolorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTruecolorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
TruecolorScriptingPluginInfo::GetLogString()
{
    std::string s(PyTruecolorAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: TruecolorScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TruecolorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTruecolorAttributes_SetDefaults((const TruecolorAttributes *)atts);
}
