// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TopologyViewerEnginePluginInfo.C
// ****************************************************************************

#include <TopologyPluginInfo.h>
#include <avtTopologyPlot.h>
#include <TopologyAttributes.h>

//
// Storage for static data elements.
//
TopologyAttributes *TopologyViewerEnginePluginInfo::clientAtts = NULL;
TopologyAttributes *TopologyViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  TopologyViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
TopologyViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (TopologyViewerEnginePluginInfo::clientAtts == NULL)
    {
        TopologyViewerEnginePluginInfo::clientAtts  = new TopologyAttributes;
        TopologyViewerEnginePluginInfo::defaultAtts = new TopologyAttributes;
    }
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TopologyViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
TopologyViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TopologyViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(TopologyAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TopologyViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(TopologyAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
TopologyViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtTopologyPlot;
}

// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    plot      The viewer plot whose attributes are getting initialized.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
TopologyViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(TopologyAttributes*)atts = *defaultAtts;
}
// ****************************************************************************
//  Method: TopologyViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TopologyViewerEnginePluginInfo::GetMenuName() const
{
    return "Topology";
}

