// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  TopologyScriptingPluginInfo.C
// ************************************************************************* //
#include <PyTopologyAttributes.h>
#include <TopologyPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Topology,Scripting)

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TopologyScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyTopologyAttributes_StartUp((TopologyAttributes *)subj, data);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
TopologyScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTopologyAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Topology plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
TopologyScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTopologyAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
TopologyScriptingPluginInfo::GetLogString()
{
    std::string s(PyTopologyAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: TopologyScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TopologyScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTopologyAttributes_SetDefaults((const TopologyAttributes *)atts);
}
