// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: TopologyPluginInfo.C
// ****************************************************************************

#include <TopologyPluginInfo.h>
#include <TopologyAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Topology,PLOT_EXPORT)

VISIT_PLOT_PLUGIN_ENTRY(Topology,General)

// ****************************************************************************
//  Method: TopologyGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the plot plugin.
//
//  Returns:    A pointer to the name of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TopologyGeneralPluginInfo::GetName() const
{
    return "Topology";
}

// ****************************************************************************
//  Method: TopologyGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the plot plugin.
//
//  Returns:    A pointer to the version of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TopologyGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: TopologyGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the plot plugin.
//
//  Returns:    A pointer to the id of the plot plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
TopologyGeneralPluginInfo::GetID() const
{
    return "Topology_1.0";
}
// ****************************************************************************
//  Method: TopologyGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
TopologyGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
