// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef TOPOLOGYATTRIBUTES_H
#define TOPOLOGYATTRIBUTES_H
#include <AttributeSubject.h>

#include <ColorAttributeList.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Class: TopologyAttributes
//
// Purpose:
//    This class contains the plot attributes for the topology plot
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class TopologyAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    TopologyAttributes();
    TopologyAttributes(const TopologyAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    TopologyAttributes(private_tmfs_t tmfs);
    TopologyAttributes(const TopologyAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~TopologyAttributes();

    virtual TopologyAttributes& operator = (const TopologyAttributes &obj);
    virtual bool operator == (const TopologyAttributes &obj) const;
    virtual bool operator != (const TopologyAttributes &obj) const;
private:
    void Init();
    void Copy(const TopologyAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectMultiColor();

    // Property setting methods
    void SetLineWidth(int lineWidth_);
    void SetMultiColor(const ColorAttributeList &multiColor_);
    void SetMinOpacity(double minOpacity_);
    void SetMinPlateauOpacity(double minPlateauOpacity_);
    void SetMaxPlateauOpacity(double maxPlateauOpacity_);
    void SetMaxOpacity(double maxOpacity_);
    void SetTolerance(double tolerance_);
    void SetHitpercent(double hitpercent_);

    // Property getting methods
    int                      GetLineWidth() const;
    const ColorAttributeList &GetMultiColor() const;
          ColorAttributeList &GetMultiColor();
    double                   GetMinOpacity() const;
    double                   GetMinPlateauOpacity() const;
    double                   GetMaxPlateauOpacity() const;
    double                   GetMaxOpacity() const;
    double                   GetTolerance() const;
    double                   GetHitpercent() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    bool ChangesRequireRecalculation(const TopologyAttributes &obj);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_lineWidth = 0,
        ID_multiColor,
        ID_minOpacity,
        ID_minPlateauOpacity,
        ID_maxPlateauOpacity,
        ID_maxOpacity,
        ID_tolerance,
        ID_hitpercent,
        ID__LAST
    };

private:
    int                lineWidth;
    ColorAttributeList multiColor;
    double             minOpacity;
    double             minPlateauOpacity;
    double             maxPlateauOpacity;
    double             maxOpacity;
    double             tolerance;
    double             hitpercent;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define TOPOLOGYATTRIBUTES_TMFS "iadddddd"

#endif
