// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  TensorScriptingPluginInfo.C
// ************************************************************************* //
#include <PyTensorAttributes.h>
#include <TensorPluginInfo.h>

VISIT_PLOT_PLUGIN_ENTRY(Tensor,Scripting)

// ****************************************************************************
// Method: TensorScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TensorScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyTensorAttributes_StartUp((TensorAttributes *)subj, data);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
TensorScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyTensorAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Tensor plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
TensorScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyTensorAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
TensorScriptingPluginInfo::GetLogString()
{
    std::string s(PyTensorAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: TensorScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
TensorScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyTensorAttributes_SetDefaults((const TensorAttributes *)atts);
}
